import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkingFloatingipAssociateV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_associate_v2#floating_ip NetworkingFloatingipAssociateV2#floating_ip}
    */
    readonly floatingIp: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_associate_v2#port_id NetworkingFloatingipAssociateV2#port_id}
    */
    readonly portId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_associate_v2#region NetworkingFloatingipAssociateV2#region}
    */
    readonly region?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_associate_v2 opentelekomcloud_networking_floatingip_associate_v2}
*/
export declare class NetworkingFloatingipAssociateV2 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_associate_v2 opentelekomcloud_networking_floatingip_associate_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkingFloatingipAssociateV2Config
    */
    constructor(scope: Construct, id: string, config: NetworkingFloatingipAssociateV2Config);
    private _floatingIp?;
    get floatingIp(): string;
    set floatingIp(value: string);
    get floatingIpInput(): string | undefined;
    get id(): string;
    private _portId?;
    get portId(): string;
    set portId(value: string);
    get portIdInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
