import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkingNetworkV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_network_v2#admin_state_up NetworkingNetworkV2#admin_state_up}
    */
    readonly adminStateUp?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_network_v2#name NetworkingNetworkV2#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_network_v2#region NetworkingNetworkV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_network_v2#shared NetworkingNetworkV2#shared}
    */
    readonly shared?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_network_v2#tenant_id NetworkingNetworkV2#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_network_v2#value_specs NetworkingNetworkV2#value_specs}
    */
    readonly valueSpecs?: {
        [key: string]: string;
    };
    /**
    * segments block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_network_v2#segments NetworkingNetworkV2#segments}
    */
    readonly segments?: NetworkingNetworkV2Segments[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_network_v2#timeouts NetworkingNetworkV2#timeouts}
    */
    readonly timeouts?: NetworkingNetworkV2Timeouts;
}
export interface NetworkingNetworkV2Segments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_network_v2#network_type NetworkingNetworkV2#network_type}
    */
    readonly networkType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_network_v2#physical_network NetworkingNetworkV2#physical_network}
    */
    readonly physicalNetwork?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_network_v2#segmentation_id NetworkingNetworkV2#segmentation_id}
    */
    readonly segmentationId?: number;
}
export declare function networkingNetworkV2SegmentsToTerraform(struct?: NetworkingNetworkV2Segments | cdktf.IResolvable): any;
export interface NetworkingNetworkV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_network_v2#create NetworkingNetworkV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_network_v2#delete NetworkingNetworkV2#delete}
    */
    readonly delete?: string;
}
export declare function networkingNetworkV2TimeoutsToTerraform(struct?: NetworkingNetworkV2TimeoutsOutputReference | NetworkingNetworkV2Timeouts | cdktf.IResolvable): any;
export declare class NetworkingNetworkV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): NetworkingNetworkV2Timeouts | undefined;
    set internalValue(value: NetworkingNetworkV2Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_network_v2 opentelekomcloud_networking_network_v2}
*/
export declare class NetworkingNetworkV2 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_network_v2 opentelekomcloud_networking_network_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkingNetworkV2Config = {}
    */
    constructor(scope: Construct, id: string, config?: NetworkingNetworkV2Config);
    private _adminStateUp?;
    get adminStateUp(): string;
    set adminStateUp(value: string);
    resetAdminStateUp(): void;
    get adminStateUpInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _shared?;
    get shared(): string;
    set shared(value: string);
    resetShared(): void;
    get sharedInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _valueSpecs?;
    get valueSpecs(): {
        [key: string]: string;
    };
    set valueSpecs(value: {
        [key: string]: string;
    });
    resetValueSpecs(): void;
    get valueSpecsInput(): {
        [key: string]: string;
    } | undefined;
    private _segments?;
    get segments(): NetworkingNetworkV2Segments[] | cdktf.IResolvable;
    set segments(value: NetworkingNetworkV2Segments[] | cdktf.IResolvable);
    resetSegments(): void;
    get segmentsInput(): cdktf.IResolvable | NetworkingNetworkV2Segments[] | undefined;
    private _timeouts;
    get timeouts(): NetworkingNetworkV2TimeoutsOutputReference;
    putTimeouts(value: NetworkingNetworkV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): NetworkingNetworkV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
