import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkingPortV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2#admin_state_up NetworkingPortV2#admin_state_up}
    */
    readonly adminStateUp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2#device_id NetworkingPortV2#device_id}
    */
    readonly deviceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2#device_owner NetworkingPortV2#device_owner}
    */
    readonly deviceOwner?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2#mac_address NetworkingPortV2#mac_address}
    */
    readonly macAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2#name NetworkingPortV2#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2#network_id NetworkingPortV2#network_id}
    */
    readonly networkId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2#no_security_groups NetworkingPortV2#no_security_groups}
    */
    readonly noSecurityGroups?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2#port_security_enabled NetworkingPortV2#port_security_enabled}
    */
    readonly portSecurityEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2#region NetworkingPortV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2#security_group_ids NetworkingPortV2#security_group_ids}
    */
    readonly securityGroupIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2#tenant_id NetworkingPortV2#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2#value_specs NetworkingPortV2#value_specs}
    */
    readonly valueSpecs?: {
        [key: string]: string;
    };
    /**
    * allowed_address_pairs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2#allowed_address_pairs NetworkingPortV2#allowed_address_pairs}
    */
    readonly allowedAddressPairs?: NetworkingPortV2AllowedAddressPairs[] | cdktf.IResolvable;
    /**
    * fixed_ip block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2#fixed_ip NetworkingPortV2#fixed_ip}
    */
    readonly fixedIp?: NetworkingPortV2FixedIp[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2#timeouts NetworkingPortV2#timeouts}
    */
    readonly timeouts?: NetworkingPortV2Timeouts;
}
export interface NetworkingPortV2AllowedAddressPairs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2#ip_address NetworkingPortV2#ip_address}
    */
    readonly ipAddress: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2#mac_address NetworkingPortV2#mac_address}
    */
    readonly macAddress?: string;
}
export declare function networkingPortV2AllowedAddressPairsToTerraform(struct?: NetworkingPortV2AllowedAddressPairs | cdktf.IResolvable): any;
export interface NetworkingPortV2FixedIp {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2#ip_address NetworkingPortV2#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2#subnet_id NetworkingPortV2#subnet_id}
    */
    readonly subnetId: string;
}
export declare function networkingPortV2FixedIpToTerraform(struct?: NetworkingPortV2FixedIp | cdktf.IResolvable): any;
export interface NetworkingPortV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2#create NetworkingPortV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2#delete NetworkingPortV2#delete}
    */
    readonly delete?: string;
}
export declare function networkingPortV2TimeoutsToTerraform(struct?: NetworkingPortV2TimeoutsOutputReference | NetworkingPortV2Timeouts | cdktf.IResolvable): any;
export declare class NetworkingPortV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): NetworkingPortV2Timeouts | undefined;
    set internalValue(value: NetworkingPortV2Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2 opentelekomcloud_networking_port_v2}
*/
export declare class NetworkingPortV2 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2 opentelekomcloud_networking_port_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkingPortV2Config
    */
    constructor(scope: Construct, id: string, config: NetworkingPortV2Config);
    private _adminStateUp?;
    get adminStateUp(): boolean | cdktf.IResolvable;
    set adminStateUp(value: boolean | cdktf.IResolvable);
    resetAdminStateUp(): void;
    get adminStateUpInput(): boolean | cdktf.IResolvable | undefined;
    get allFixedIps(): string[];
    private _deviceId?;
    get deviceId(): string;
    set deviceId(value: string);
    resetDeviceId(): void;
    get deviceIdInput(): string | undefined;
    private _deviceOwner?;
    get deviceOwner(): string;
    set deviceOwner(value: string);
    resetDeviceOwner(): void;
    get deviceOwnerInput(): string | undefined;
    get id(): string;
    private _macAddress?;
    get macAddress(): string;
    set macAddress(value: string);
    resetMacAddress(): void;
    get macAddressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _networkId?;
    get networkId(): string;
    set networkId(value: string);
    get networkIdInput(): string | undefined;
    private _noSecurityGroups?;
    get noSecurityGroups(): boolean | cdktf.IResolvable;
    set noSecurityGroups(value: boolean | cdktf.IResolvable);
    resetNoSecurityGroups(): void;
    get noSecurityGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _portSecurityEnabled?;
    get portSecurityEnabled(): boolean | cdktf.IResolvable;
    set portSecurityEnabled(value: boolean | cdktf.IResolvable);
    resetPortSecurityEnabled(): void;
    get portSecurityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _securityGroupIds?;
    get securityGroupIds(): string[];
    set securityGroupIds(value: string[]);
    resetSecurityGroupIds(): void;
    get securityGroupIdsInput(): string[] | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _valueSpecs?;
    get valueSpecs(): {
        [key: string]: string;
    };
    set valueSpecs(value: {
        [key: string]: string;
    });
    resetValueSpecs(): void;
    get valueSpecsInput(): {
        [key: string]: string;
    } | undefined;
    private _allowedAddressPairs?;
    get allowedAddressPairs(): NetworkingPortV2AllowedAddressPairs[] | cdktf.IResolvable;
    set allowedAddressPairs(value: NetworkingPortV2AllowedAddressPairs[] | cdktf.IResolvable);
    resetAllowedAddressPairs(): void;
    get allowedAddressPairsInput(): cdktf.IResolvable | NetworkingPortV2AllowedAddressPairs[] | undefined;
    private _fixedIp?;
    get fixedIp(): NetworkingPortV2FixedIp[] | cdktf.IResolvable;
    set fixedIp(value: NetworkingPortV2FixedIp[] | cdktf.IResolvable);
    resetFixedIp(): void;
    get fixedIpInput(): cdktf.IResolvable | NetworkingPortV2FixedIp[] | undefined;
    private _timeouts;
    get timeouts(): NetworkingPortV2TimeoutsOutputReference;
    putTimeouts(value: NetworkingPortV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): NetworkingPortV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
