import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkingSubnetV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2#cidr NetworkingSubnetV2#cidr}
    */
    readonly cidr: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2#dns_nameservers NetworkingSubnetV2#dns_nameservers}
    */
    readonly dnsNameservers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2#enable_dhcp NetworkingSubnetV2#enable_dhcp}
    */
    readonly enableDhcp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2#gateway_ip NetworkingSubnetV2#gateway_ip}
    */
    readonly gatewayIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2#ip_version NetworkingSubnetV2#ip_version}
    */
    readonly ipVersion?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2#name NetworkingSubnetV2#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2#network_id NetworkingSubnetV2#network_id}
    */
    readonly networkId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2#no_gateway NetworkingSubnetV2#no_gateway}
    */
    readonly noGateway?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2#region NetworkingSubnetV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2#tenant_id NetworkingSubnetV2#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2#value_specs NetworkingSubnetV2#value_specs}
    */
    readonly valueSpecs?: {
        [key: string]: string;
    };
    /**
    * allocation_pools block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2#allocation_pools NetworkingSubnetV2#allocation_pools}
    */
    readonly allocationPools?: NetworkingSubnetV2AllocationPools[] | cdktf.IResolvable;
    /**
    * host_routes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2#host_routes NetworkingSubnetV2#host_routes}
    */
    readonly hostRoutes?: NetworkingSubnetV2HostRoutes[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2#timeouts NetworkingSubnetV2#timeouts}
    */
    readonly timeouts?: NetworkingSubnetV2Timeouts;
}
export interface NetworkingSubnetV2AllocationPools {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2#end NetworkingSubnetV2#end}
    */
    readonly end: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2#start NetworkingSubnetV2#start}
    */
    readonly start: string;
}
export declare function networkingSubnetV2AllocationPoolsToTerraform(struct?: NetworkingSubnetV2AllocationPools | cdktf.IResolvable): any;
export interface NetworkingSubnetV2HostRoutes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2#destination_cidr NetworkingSubnetV2#destination_cidr}
    */
    readonly destinationCidr: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2#next_hop NetworkingSubnetV2#next_hop}
    */
    readonly nextHop: string;
}
export declare function networkingSubnetV2HostRoutesToTerraform(struct?: NetworkingSubnetV2HostRoutes | cdktf.IResolvable): any;
export interface NetworkingSubnetV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2#create NetworkingSubnetV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2#delete NetworkingSubnetV2#delete}
    */
    readonly delete?: string;
}
export declare function networkingSubnetV2TimeoutsToTerraform(struct?: NetworkingSubnetV2TimeoutsOutputReference | NetworkingSubnetV2Timeouts | cdktf.IResolvable): any;
export declare class NetworkingSubnetV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): NetworkingSubnetV2Timeouts | undefined;
    set internalValue(value: NetworkingSubnetV2Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2 opentelekomcloud_networking_subnet_v2}
*/
export declare class NetworkingSubnetV2 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2 opentelekomcloud_networking_subnet_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkingSubnetV2Config
    */
    constructor(scope: Construct, id: string, config: NetworkingSubnetV2Config);
    private _cidr?;
    get cidr(): string;
    set cidr(value: string);
    get cidrInput(): string | undefined;
    private _dnsNameservers?;
    get dnsNameservers(): string[];
    set dnsNameservers(value: string[]);
    resetDnsNameservers(): void;
    get dnsNameserversInput(): string[] | undefined;
    private _enableDhcp?;
    get enableDhcp(): boolean | cdktf.IResolvable;
    set enableDhcp(value: boolean | cdktf.IResolvable);
    resetEnableDhcp(): void;
    get enableDhcpInput(): boolean | cdktf.IResolvable | undefined;
    private _gatewayIp?;
    get gatewayIp(): string;
    set gatewayIp(value: string);
    resetGatewayIp(): void;
    get gatewayIpInput(): string | undefined;
    get id(): string;
    private _ipVersion?;
    get ipVersion(): number;
    set ipVersion(value: number);
    resetIpVersion(): void;
    get ipVersionInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _networkId?;
    get networkId(): string;
    set networkId(value: string);
    get networkIdInput(): string | undefined;
    private _noGateway?;
    get noGateway(): boolean | cdktf.IResolvable;
    set noGateway(value: boolean | cdktf.IResolvable);
    resetNoGateway(): void;
    get noGatewayInput(): boolean | cdktf.IResolvable | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _valueSpecs?;
    get valueSpecs(): {
        [key: string]: string;
    };
    set valueSpecs(value: {
        [key: string]: string;
    });
    resetValueSpecs(): void;
    get valueSpecsInput(): {
        [key: string]: string;
    } | undefined;
    private _allocationPools?;
    get allocationPools(): NetworkingSubnetV2AllocationPools[] | cdktf.IResolvable;
    set allocationPools(value: NetworkingSubnetV2AllocationPools[] | cdktf.IResolvable);
    resetAllocationPools(): void;
    get allocationPoolsInput(): cdktf.IResolvable | NetworkingSubnetV2AllocationPools[] | undefined;
    private _hostRoutes?;
    get hostRoutes(): NetworkingSubnetV2HostRoutes[] | cdktf.IResolvable;
    set hostRoutes(value: NetworkingSubnetV2HostRoutes[] | cdktf.IResolvable);
    resetHostRoutes(): void;
    get hostRoutesInput(): cdktf.IResolvable | NetworkingSubnetV2HostRoutes[] | undefined;
    private _timeouts;
    get timeouts(): NetworkingSubnetV2TimeoutsOutputReference;
    putTimeouts(value: NetworkingSubnetV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): NetworkingSubnetV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
