import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ObsBucketConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#acl ObsBucket#acl}
    */
    readonly acl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#bucket ObsBucket#bucket}
    */
    readonly bucket: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#force_destroy ObsBucket#force_destroy}
    */
    readonly forceDestroy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#region ObsBucket#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#storage_class ObsBucket#storage_class}
    */
    readonly storageClass?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#tags ObsBucket#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#versioning ObsBucket#versioning}
    */
    readonly versioning?: boolean | cdktf.IResolvable;
    /**
    * cors_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#cors_rule ObsBucket#cors_rule}
    */
    readonly corsRule?: ObsBucketCorsRule[] | cdktf.IResolvable;
    /**
    * event_notifications block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#event_notifications ObsBucket#event_notifications}
    */
    readonly eventNotifications?: ObsBucketEventNotifications[] | cdktf.IResolvable;
    /**
    * lifecycle_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#lifecycle_rule ObsBucket#lifecycle_rule}
    */
    readonly lifecycleRule?: ObsBucketLifecycleRule[] | cdktf.IResolvable;
    /**
    * logging block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#logging ObsBucket#logging}
    */
    readonly logging?: ObsBucketLogging[] | cdktf.IResolvable;
    /**
    * server_side_encryption block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#server_side_encryption ObsBucket#server_side_encryption}
    */
    readonly serverSideEncryption?: ObsBucketServerSideEncryption;
    /**
    * website block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#website ObsBucket#website}
    */
    readonly website?: ObsBucketWebsite;
}
export interface ObsBucketCorsRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#allowed_headers ObsBucket#allowed_headers}
    */
    readonly allowedHeaders?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#allowed_methods ObsBucket#allowed_methods}
    */
    readonly allowedMethods: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#allowed_origins ObsBucket#allowed_origins}
    */
    readonly allowedOrigins: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#expose_headers ObsBucket#expose_headers}
    */
    readonly exposeHeaders?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#max_age_seconds ObsBucket#max_age_seconds}
    */
    readonly maxAgeSeconds?: number;
}
export declare function obsBucketCorsRuleToTerraform(struct?: ObsBucketCorsRule | cdktf.IResolvable): any;
export interface ObsBucketEventNotificationsFilterRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#name ObsBucket#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#value ObsBucket#value}
    */
    readonly value?: string;
}
export declare function obsBucketEventNotificationsFilterRuleToTerraform(struct?: ObsBucketEventNotificationsFilterRule | cdktf.IResolvable): any;
export interface ObsBucketEventNotifications {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#events ObsBucket#events}
    */
    readonly events: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#id ObsBucket#id}
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#topic ObsBucket#topic}
    */
    readonly topic: string;
    /**
    * filter_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#filter_rule ObsBucket#filter_rule}
    */
    readonly filterRule?: ObsBucketEventNotificationsFilterRule[] | cdktf.IResolvable;
}
export declare function obsBucketEventNotificationsToTerraform(struct?: ObsBucketEventNotifications | cdktf.IResolvable): any;
export interface ObsBucketLifecycleRuleExpiration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#days ObsBucket#days}
    */
    readonly days: number;
}
export declare function obsBucketLifecycleRuleExpirationToTerraform(struct?: ObsBucketLifecycleRuleExpiration | cdktf.IResolvable): any;
export interface ObsBucketLifecycleRuleNoncurrentVersionExpiration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#days ObsBucket#days}
    */
    readonly days: number;
}
export declare function obsBucketLifecycleRuleNoncurrentVersionExpirationToTerraform(struct?: ObsBucketLifecycleRuleNoncurrentVersionExpiration | cdktf.IResolvable): any;
export interface ObsBucketLifecycleRuleNoncurrentVersionTransition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#days ObsBucket#days}
    */
    readonly days: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#storage_class ObsBucket#storage_class}
    */
    readonly storageClass: string;
}
export declare function obsBucketLifecycleRuleNoncurrentVersionTransitionToTerraform(struct?: ObsBucketLifecycleRuleNoncurrentVersionTransition | cdktf.IResolvable): any;
export interface ObsBucketLifecycleRuleTransition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#days ObsBucket#days}
    */
    readonly days: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#storage_class ObsBucket#storage_class}
    */
    readonly storageClass: string;
}
export declare function obsBucketLifecycleRuleTransitionToTerraform(struct?: ObsBucketLifecycleRuleTransition | cdktf.IResolvable): any;
export interface ObsBucketLifecycleRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#enabled ObsBucket#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#name ObsBucket#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#prefix ObsBucket#prefix}
    */
    readonly prefix?: string;
    /**
    * expiration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#expiration ObsBucket#expiration}
    */
    readonly expiration?: ObsBucketLifecycleRuleExpiration[] | cdktf.IResolvable;
    /**
    * noncurrent_version_expiration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#noncurrent_version_expiration ObsBucket#noncurrent_version_expiration}
    */
    readonly noncurrentVersionExpiration?: ObsBucketLifecycleRuleNoncurrentVersionExpiration[] | cdktf.IResolvable;
    /**
    * noncurrent_version_transition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#noncurrent_version_transition ObsBucket#noncurrent_version_transition}
    */
    readonly noncurrentVersionTransition?: ObsBucketLifecycleRuleNoncurrentVersionTransition[] | cdktf.IResolvable;
    /**
    * transition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#transition ObsBucket#transition}
    */
    readonly transition?: ObsBucketLifecycleRuleTransition[] | cdktf.IResolvable;
}
export declare function obsBucketLifecycleRuleToTerraform(struct?: ObsBucketLifecycleRule | cdktf.IResolvable): any;
export interface ObsBucketLogging {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#target_bucket ObsBucket#target_bucket}
    */
    readonly targetBucket: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#target_prefix ObsBucket#target_prefix}
    */
    readonly targetPrefix?: string;
}
export declare function obsBucketLoggingToTerraform(struct?: ObsBucketLogging | cdktf.IResolvable): any;
export interface ObsBucketServerSideEncryption {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#algorithm ObsBucket#algorithm}
    */
    readonly algorithm: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#kms_key_id ObsBucket#kms_key_id}
    */
    readonly kmsKeyId: string;
}
export declare function obsBucketServerSideEncryptionToTerraform(struct?: ObsBucketServerSideEncryptionOutputReference | ObsBucketServerSideEncryption): any;
export declare class ObsBucketServerSideEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ObsBucketServerSideEncryption | undefined;
    set internalValue(value: ObsBucketServerSideEncryption | undefined);
    private _algorithm?;
    get algorithm(): string;
    set algorithm(value: string);
    get algorithmInput(): string | undefined;
    private _kmsKeyId?;
    get kmsKeyId(): string;
    set kmsKeyId(value: string);
    get kmsKeyIdInput(): string | undefined;
}
export interface ObsBucketWebsite {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#error_document ObsBucket#error_document}
    */
    readonly errorDocument?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#index_document ObsBucket#index_document}
    */
    readonly indexDocument?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#redirect_all_requests_to ObsBucket#redirect_all_requests_to}
    */
    readonly redirectAllRequestsTo?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket#routing_rules ObsBucket#routing_rules}
    */
    readonly routingRules?: string;
}
export declare function obsBucketWebsiteToTerraform(struct?: ObsBucketWebsiteOutputReference | ObsBucketWebsite): any;
export declare class ObsBucketWebsiteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ObsBucketWebsite | undefined;
    set internalValue(value: ObsBucketWebsite | undefined);
    private _errorDocument?;
    get errorDocument(): string;
    set errorDocument(value: string);
    resetErrorDocument(): void;
    get errorDocumentInput(): string | undefined;
    private _indexDocument?;
    get indexDocument(): string;
    set indexDocument(value: string);
    resetIndexDocument(): void;
    get indexDocumentInput(): string | undefined;
    private _redirectAllRequestsTo?;
    get redirectAllRequestsTo(): string;
    set redirectAllRequestsTo(value: string);
    resetRedirectAllRequestsTo(): void;
    get redirectAllRequestsToInput(): string | undefined;
    private _routingRules?;
    get routingRules(): string;
    set routingRules(value: string);
    resetRoutingRules(): void;
    get routingRulesInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket opentelekomcloud_obs_bucket}
*/
export declare class ObsBucket extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket opentelekomcloud_obs_bucket} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ObsBucketConfig
    */
    constructor(scope: Construct, id: string, config: ObsBucketConfig);
    private _acl?;
    get acl(): string;
    set acl(value: string);
    resetAcl(): void;
    get aclInput(): string | undefined;
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    get bucketDomainName(): string;
    private _forceDestroy?;
    get forceDestroy(): boolean | cdktf.IResolvable;
    set forceDestroy(value: boolean | cdktf.IResolvable);
    resetForceDestroy(): void;
    get forceDestroyInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _storageClass?;
    get storageClass(): string;
    set storageClass(value: string);
    resetStorageClass(): void;
    get storageClassInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _versioning?;
    get versioning(): boolean | cdktf.IResolvable;
    set versioning(value: boolean | cdktf.IResolvable);
    resetVersioning(): void;
    get versioningInput(): boolean | cdktf.IResolvable | undefined;
    private _corsRule?;
    get corsRule(): ObsBucketCorsRule[] | cdktf.IResolvable;
    set corsRule(value: ObsBucketCorsRule[] | cdktf.IResolvable);
    resetCorsRule(): void;
    get corsRuleInput(): cdktf.IResolvable | ObsBucketCorsRule[] | undefined;
    private _eventNotifications?;
    get eventNotifications(): ObsBucketEventNotifications[] | cdktf.IResolvable;
    set eventNotifications(value: ObsBucketEventNotifications[] | cdktf.IResolvable);
    resetEventNotifications(): void;
    get eventNotificationsInput(): cdktf.IResolvable | ObsBucketEventNotifications[] | undefined;
    private _lifecycleRule?;
    get lifecycleRule(): ObsBucketLifecycleRule[] | cdktf.IResolvable;
    set lifecycleRule(value: ObsBucketLifecycleRule[] | cdktf.IResolvable);
    resetLifecycleRule(): void;
    get lifecycleRuleInput(): cdktf.IResolvable | ObsBucketLifecycleRule[] | undefined;
    private _logging?;
    get logging(): ObsBucketLogging[] | cdktf.IResolvable;
    set logging(value: ObsBucketLogging[] | cdktf.IResolvable);
    resetLogging(): void;
    get loggingInput(): cdktf.IResolvable | ObsBucketLogging[] | undefined;
    private _serverSideEncryption;
    get serverSideEncryption(): ObsBucketServerSideEncryptionOutputReference;
    putServerSideEncryption(value: ObsBucketServerSideEncryption): void;
    resetServerSideEncryption(): void;
    get serverSideEncryptionInput(): ObsBucketServerSideEncryption | undefined;
    private _website;
    get website(): ObsBucketWebsiteOutputReference;
    putWebsite(value: ObsBucketWebsite): void;
    resetWebsite(): void;
    get websiteInput(): ObsBucketWebsite | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
