import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OpentelekomcloudProviderConfig {
    /**
    * The access key for API operations. You can retrieve this
  from the 'My Credential' section of the console.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#access_key OpentelekomcloudProvider#access_key}
    */
    readonly accessKey?: string;
    /**
    * The name of domain who created the agency (Identity v3).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#agency_domain_name OpentelekomcloudProvider#agency_domain_name}
    */
    readonly agencyDomainName?: string;
    /**
    * The name of agency
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#agency_name OpentelekomcloudProvider#agency_name}
    */
    readonly agencyName?: string;
    /**
    * The Identity authentication URL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#auth_url OpentelekomcloudProvider#auth_url}
    */
    readonly authUrl?: string;
    /**
    * A Custom CA certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#cacert_file OpentelekomcloudProvider#cacert_file}
    */
    readonly cacertFile?: string;
    /**
    * A client certificate to authenticate with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#cert OpentelekomcloudProvider#cert}
    */
    readonly cert?: string;
    /**
    * An entry in a `clouds.yaml` file to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#cloud OpentelekomcloudProvider#cloud}
    */
    readonly cloud?: string;
    /**
    * The name of delegated project (Identity v3).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#delegated_project OpentelekomcloudProvider#delegated_project}
    */
    readonly delegatedProject?: string;
    /**
    * The ID of the Domain to scope to (Identity v3).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#domain_id OpentelekomcloudProvider#domain_id}
    */
    readonly domainId?: string;
    /**
    * The name of the Domain to scope to (Identity v3).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#domain_name OpentelekomcloudProvider#domain_name}
    */
    readonly domainName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#endpoint_type OpentelekomcloudProvider#endpoint_type}
    */
    readonly endpointType?: string;
    /**
    * Trust self-signed certificates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#insecure OpentelekomcloudProvider#insecure}
    */
    readonly insecure?: boolean | cdktf.IResolvable;
    /**
    * A client private key to authenticate with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#key OpentelekomcloudProvider#key}
    */
    readonly key?: string;
    /**
    * How many times HTTP connection should be retried until giving up.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#max_retries OpentelekomcloudProvider#max_retries}
    */
    readonly maxRetries?: number;
    /**
    * One-time MFA passcode
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#passcode OpentelekomcloudProvider#passcode}
    */
    readonly passcode?: string;
    /**
    * Password to login with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#password OpentelekomcloudProvider#password}
    */
    readonly password?: string;
    /**
    * The OpenTelekomCloud region to connect to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#region OpentelekomcloudProvider#region}
    */
    readonly region?: string;
    /**
    * The secret key for API operations. You can retrieve this
  from the 'My Credential' section of the console.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#secret_key OpentelekomcloudProvider#secret_key}
    */
    readonly secretKey?: string;
    /**
    * Security token to use for OBS federated authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#security_token OpentelekomcloudProvider#security_token}
    */
    readonly securityToken?: string;
    /**
    * Use Swift's authentication system instead of Keystone. Only used for
  interaction with Swift.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#swauth OpentelekomcloudProvider#swauth}
    */
    readonly swauth?: boolean | cdktf.IResolvable;
    /**
    * The ID of the Tenant (Identity v2) or Project (Identity v3)
  to login with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#tenant_id OpentelekomcloudProvider#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * The name of the Tenant (Identity v2) or Project (Identity v3)
  to login with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#tenant_name OpentelekomcloudProvider#tenant_name}
    */
    readonly tenantName?: string;
    /**
    * Authentication token to use as an alternative to username/password.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#token OpentelekomcloudProvider#token}
    */
    readonly token?: string;
    /**
    * User ID to login with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#user_id OpentelekomcloudProvider#user_id}
    */
    readonly userId?: string;
    /**
    * Username to login with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#user_name OpentelekomcloudProvider#user_name}
    */
    readonly userName?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#alias OpentelekomcloudProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud opentelekomcloud}
*/
export declare class OpentelekomcloudProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud opentelekomcloud} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OpentelekomcloudProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: OpentelekomcloudProviderConfig);
    private _accessKey?;
    get accessKey(): string | undefined;
    set accessKey(value: string | undefined);
    resetAccessKey(): void;
    get accessKeyInput(): string | undefined;
    private _agencyDomainName?;
    get agencyDomainName(): string | undefined;
    set agencyDomainName(value: string | undefined);
    resetAgencyDomainName(): void;
    get agencyDomainNameInput(): string | undefined;
    private _agencyName?;
    get agencyName(): string | undefined;
    set agencyName(value: string | undefined);
    resetAgencyName(): void;
    get agencyNameInput(): string | undefined;
    private _authUrl?;
    get authUrl(): string | undefined;
    set authUrl(value: string | undefined);
    resetAuthUrl(): void;
    get authUrlInput(): string | undefined;
    private _cacertFile?;
    get cacertFile(): string | undefined;
    set cacertFile(value: string | undefined);
    resetCacertFile(): void;
    get cacertFileInput(): string | undefined;
    private _cert?;
    get cert(): string | undefined;
    set cert(value: string | undefined);
    resetCert(): void;
    get certInput(): string | undefined;
    private _cloud?;
    get cloud(): string | undefined;
    set cloud(value: string | undefined);
    resetCloud(): void;
    get cloudInput(): string | undefined;
    private _delegatedProject?;
    get delegatedProject(): string | undefined;
    set delegatedProject(value: string | undefined);
    resetDelegatedProject(): void;
    get delegatedProjectInput(): string | undefined;
    private _domainId?;
    get domainId(): string | undefined;
    set domainId(value: string | undefined);
    resetDomainId(): void;
    get domainIdInput(): string | undefined;
    private _domainName?;
    get domainName(): string | undefined;
    set domainName(value: string | undefined);
    resetDomainName(): void;
    get domainNameInput(): string | undefined;
    private _endpointType?;
    get endpointType(): string | undefined;
    set endpointType(value: string | undefined);
    resetEndpointType(): void;
    get endpointTypeInput(): string | undefined;
    private _insecure?;
    get insecure(): boolean | cdktf.IResolvable | undefined;
    set insecure(value: boolean | cdktf.IResolvable | undefined);
    resetInsecure(): void;
    get insecureInput(): boolean | cdktf.IResolvable | undefined;
    private _key?;
    get key(): string | undefined;
    set key(value: string | undefined);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _maxRetries?;
    get maxRetries(): number | undefined;
    set maxRetries(value: number | undefined);
    resetMaxRetries(): void;
    get maxRetriesInput(): number | undefined;
    private _passcode?;
    get passcode(): string | undefined;
    set passcode(value: string | undefined);
    resetPasscode(): void;
    get passcodeInput(): string | undefined;
    private _password?;
    get password(): string | undefined;
    set password(value: string | undefined);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _secretKey?;
    get secretKey(): string | undefined;
    set secretKey(value: string | undefined);
    resetSecretKey(): void;
    get secretKeyInput(): string | undefined;
    private _securityToken?;
    get securityToken(): string | undefined;
    set securityToken(value: string | undefined);
    resetSecurityToken(): void;
    get securityTokenInput(): string | undefined;
    private _swauth?;
    get swauth(): boolean | cdktf.IResolvable | undefined;
    set swauth(value: boolean | cdktf.IResolvable | undefined);
    resetSwauth(): void;
    get swauthInput(): boolean | cdktf.IResolvable | undefined;
    private _tenantId?;
    get tenantId(): string | undefined;
    set tenantId(value: string | undefined);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _tenantName?;
    get tenantName(): string | undefined;
    set tenantName(value: string | undefined);
    resetTenantName(): void;
    get tenantNameInput(): string | undefined;
    private _token?;
    get token(): string | undefined;
    set token(value: string | undefined);
    resetToken(): void;
    get tokenInput(): string | undefined;
    private _userId?;
    get userId(): string | undefined;
    set userId(value: string | undefined);
    resetUserId(): void;
    get userIdInput(): string | undefined;
    private _userName?;
    get userName(): string | undefined;
    set userName(value: string | undefined);
    resetUserName(): void;
    get userNameInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
