import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RdsInstanceV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#availabilityzone RdsInstanceV1#availabilityzone}
    */
    readonly availabilityzone: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#dbport RdsInstanceV1#dbport}
    */
    readonly dbport?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#dbrtpd RdsInstanceV1#dbrtpd}
    */
    readonly dbrtpd: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#flavorref RdsInstanceV1#flavorref}
    */
    readonly flavorref: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#name RdsInstanceV1#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#region RdsInstanceV1#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#tag RdsInstanceV1#tag}
    */
    readonly tag?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#vpc RdsInstanceV1#vpc}
    */
    readonly vpc: string;
    /**
    * backupstrategy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#backupstrategy RdsInstanceV1#backupstrategy}
    */
    readonly backupstrategy?: RdsInstanceV1Backupstrategy;
    /**
    * datastore block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#datastore RdsInstanceV1#datastore}
    */
    readonly datastore: RdsInstanceV1Datastore;
    /**
    * ha block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#ha RdsInstanceV1#ha}
    */
    readonly ha?: RdsInstanceV1Ha;
    /**
    * nics block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#nics RdsInstanceV1#nics}
    */
    readonly nics: RdsInstanceV1Nics;
    /**
    * securitygroup block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#securitygroup RdsInstanceV1#securitygroup}
    */
    readonly securitygroup: RdsInstanceV1Securitygroup;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#timeouts RdsInstanceV1#timeouts}
    */
    readonly timeouts?: RdsInstanceV1Timeouts;
    /**
    * volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#volume RdsInstanceV1#volume}
    */
    readonly volume: RdsInstanceV1Volume;
}
export interface RdsInstanceV1Backupstrategy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#keepdays RdsInstanceV1#keepdays}
    */
    readonly keepdays?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#starttime RdsInstanceV1#starttime}
    */
    readonly starttime?: string;
}
export declare function rdsInstanceV1BackupstrategyToTerraform(struct?: RdsInstanceV1BackupstrategyOutputReference | RdsInstanceV1Backupstrategy): any;
export declare class RdsInstanceV1BackupstrategyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): RdsInstanceV1Backupstrategy | undefined;
    set internalValue(value: RdsInstanceV1Backupstrategy | undefined);
    private _keepdays?;
    get keepdays(): number;
    set keepdays(value: number);
    resetKeepdays(): void;
    get keepdaysInput(): number | undefined;
    private _starttime?;
    get starttime(): string;
    set starttime(value: string);
    resetStarttime(): void;
    get starttimeInput(): string | undefined;
}
export interface RdsInstanceV1Datastore {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#type RdsInstanceV1#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#version RdsInstanceV1#version}
    */
    readonly version: string;
}
export declare function rdsInstanceV1DatastoreToTerraform(struct?: RdsInstanceV1DatastoreOutputReference | RdsInstanceV1Datastore): any;
export declare class RdsInstanceV1DatastoreOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): RdsInstanceV1Datastore | undefined;
    set internalValue(value: RdsInstanceV1Datastore | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export interface RdsInstanceV1Ha {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#enable RdsInstanceV1#enable}
    */
    readonly enable?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#replicationmode RdsInstanceV1#replicationmode}
    */
    readonly replicationmode?: string;
}
export declare function rdsInstanceV1HaToTerraform(struct?: RdsInstanceV1HaOutputReference | RdsInstanceV1Ha): any;
export declare class RdsInstanceV1HaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): RdsInstanceV1Ha | undefined;
    set internalValue(value: RdsInstanceV1Ha | undefined);
    private _enable?;
    get enable(): boolean | cdktf.IResolvable;
    set enable(value: boolean | cdktf.IResolvable);
    resetEnable(): void;
    get enableInput(): boolean | cdktf.IResolvable | undefined;
    private _replicationmode?;
    get replicationmode(): string;
    set replicationmode(value: string);
    resetReplicationmode(): void;
    get replicationmodeInput(): string | undefined;
}
export interface RdsInstanceV1Nics {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#subnetid RdsInstanceV1#subnetid}
    */
    readonly subnetid: string;
}
export declare function rdsInstanceV1NicsToTerraform(struct?: RdsInstanceV1NicsOutputReference | RdsInstanceV1Nics): any;
export declare class RdsInstanceV1NicsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): RdsInstanceV1Nics | undefined;
    set internalValue(value: RdsInstanceV1Nics | undefined);
    private _subnetid?;
    get subnetid(): string;
    set subnetid(value: string);
    get subnetidInput(): string | undefined;
}
export interface RdsInstanceV1Securitygroup {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#id RdsInstanceV1#id}
    */
    readonly id: string;
}
export declare function rdsInstanceV1SecuritygroupToTerraform(struct?: RdsInstanceV1SecuritygroupOutputReference | RdsInstanceV1Securitygroup): any;
export declare class RdsInstanceV1SecuritygroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): RdsInstanceV1Securitygroup | undefined;
    set internalValue(value: RdsInstanceV1Securitygroup | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
}
export interface RdsInstanceV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#create RdsInstanceV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#delete RdsInstanceV1#delete}
    */
    readonly delete?: string;
}
export declare function rdsInstanceV1TimeoutsToTerraform(struct?: RdsInstanceV1TimeoutsOutputReference | RdsInstanceV1Timeouts | cdktf.IResolvable): any;
export declare class RdsInstanceV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): RdsInstanceV1Timeouts | undefined;
    set internalValue(value: RdsInstanceV1Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
export interface RdsInstanceV1Volume {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#size RdsInstanceV1#size}
    */
    readonly size: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1#type RdsInstanceV1#type}
    */
    readonly type: string;
}
export declare function rdsInstanceV1VolumeToTerraform(struct?: RdsInstanceV1VolumeOutputReference | RdsInstanceV1Volume): any;
export declare class RdsInstanceV1VolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): RdsInstanceV1Volume | undefined;
    set internalValue(value: RdsInstanceV1Volume | undefined);
    private _size?;
    get size(): number;
    set size(value: number);
    get sizeInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1 opentelekomcloud_rds_instance_v1}
*/
export declare class RdsInstanceV1 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1 opentelekomcloud_rds_instance_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RdsInstanceV1Config
    */
    constructor(scope: Construct, id: string, config: RdsInstanceV1Config);
    private _availabilityzone?;
    get availabilityzone(): string;
    set availabilityzone(value: string);
    get availabilityzoneInput(): string | undefined;
    get created(): string;
    private _dbport?;
    get dbport(): string;
    set dbport(value: string);
    resetDbport(): void;
    get dbportInput(): string | undefined;
    private _dbrtpd?;
    get dbrtpd(): string;
    set dbrtpd(value: string);
    get dbrtpdInput(): string | undefined;
    private _flavorref?;
    get flavorref(): string;
    set flavorref(value: string);
    get flavorrefInput(): string | undefined;
    get hostname(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get status(): string;
    private _tag?;
    get tag(): {
        [key: string]: string;
    };
    set tag(value: {
        [key: string]: string;
    });
    resetTag(): void;
    get tagInput(): {
        [key: string]: string;
    } | undefined;
    get type(): string;
    get updated(): string;
    private _vpc?;
    get vpc(): string;
    set vpc(value: string);
    get vpcInput(): string | undefined;
    private _backupstrategy;
    get backupstrategy(): RdsInstanceV1BackupstrategyOutputReference;
    putBackupstrategy(value: RdsInstanceV1Backupstrategy): void;
    resetBackupstrategy(): void;
    get backupstrategyInput(): RdsInstanceV1Backupstrategy | undefined;
    private _datastore;
    get datastore(): RdsInstanceV1DatastoreOutputReference;
    putDatastore(value: RdsInstanceV1Datastore): void;
    get datastoreInput(): RdsInstanceV1Datastore | undefined;
    private _ha;
    get ha(): RdsInstanceV1HaOutputReference;
    putHa(value: RdsInstanceV1Ha): void;
    resetHa(): void;
    get haInput(): RdsInstanceV1Ha | undefined;
    private _nics;
    get nics(): RdsInstanceV1NicsOutputReference;
    putNics(value: RdsInstanceV1Nics): void;
    get nicsInput(): RdsInstanceV1Nics | undefined;
    private _securitygroup;
    get securitygroup(): RdsInstanceV1SecuritygroupOutputReference;
    putSecuritygroup(value: RdsInstanceV1Securitygroup): void;
    get securitygroupInput(): RdsInstanceV1Securitygroup | undefined;
    private _timeouts;
    get timeouts(): RdsInstanceV1TimeoutsOutputReference;
    putTimeouts(value: RdsInstanceV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): RdsInstanceV1Timeouts | undefined;
    private _volume;
    get volume(): RdsInstanceV1VolumeOutputReference;
    putVolume(value: RdsInstanceV1Volume): void;
    get volumeInput(): RdsInstanceV1Volume | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
