import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RdsParametergroupV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_parametergroup_v3#description RdsParametergroupV3#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_parametergroup_v3#name RdsParametergroupV3#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_parametergroup_v3#values RdsParametergroupV3#values}
    */
    readonly values?: {
        [key: string]: string;
    };
    /**
    * datastore block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_parametergroup_v3#datastore RdsParametergroupV3#datastore}
    */
    readonly datastore: RdsParametergroupV3Datastore;
}
export declare class RdsParametergroupV3ConfigurationParameters extends cdktf.ComplexComputedList {
    get description(): string;
    get name(): string;
    get readonly(): cdktf.IResolvable;
    get restartRequired(): cdktf.IResolvable;
    get type(): string;
    get value(): string;
    get valueRange(): string;
}
export interface RdsParametergroupV3Datastore {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_parametergroup_v3#type RdsParametergroupV3#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_parametergroup_v3#version RdsParametergroupV3#version}
    */
    readonly version: string;
}
export declare function rdsParametergroupV3DatastoreToTerraform(struct?: RdsParametergroupV3DatastoreOutputReference | RdsParametergroupV3Datastore): any;
export declare class RdsParametergroupV3DatastoreOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): RdsParametergroupV3Datastore | undefined;
    set internalValue(value: RdsParametergroupV3Datastore | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_parametergroup_v3 opentelekomcloud_rds_parametergroup_v3}
*/
export declare class RdsParametergroupV3 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_parametergroup_v3 opentelekomcloud_rds_parametergroup_v3} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RdsParametergroupV3Config
    */
    constructor(scope: Construct, id: string, config: RdsParametergroupV3Config);
    configurationParameters(index: string): RdsParametergroupV3ConfigurationParameters;
    get created(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get updated(): string;
    private _values?;
    get values(): {
        [key: string]: string;
    };
    set values(value: {
        [key: string]: string;
    });
    resetValues(): void;
    get valuesInput(): {
        [key: string]: string;
    } | undefined;
    private _datastore;
    get datastore(): RdsParametergroupV3DatastoreOutputReference;
    putDatastore(value: RdsParametergroupV3Datastore): void;
    get datastoreInput(): RdsParametergroupV3Datastore | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
