import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RdsReadReplicaV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3#availability_zone RdsReadReplicaV3#availability_zone}
    */
    readonly availabilityZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3#flavor_ref RdsReadReplicaV3#flavor_ref}
    */
    readonly flavorRef: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3#name RdsReadReplicaV3#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3#public_ips RdsReadReplicaV3#public_ips}
    */
    readonly publicIps?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3#region RdsReadReplicaV3#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3#replica_of_id RdsReadReplicaV3#replica_of_id}
    */
    readonly replicaOfId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3#timeouts RdsReadReplicaV3#timeouts}
    */
    readonly timeouts?: RdsReadReplicaV3Timeouts;
    /**
    * volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3#volume RdsReadReplicaV3#volume}
    */
    readonly volume: RdsReadReplicaV3Volume;
}
export declare class RdsReadReplicaV3Db extends cdktf.ComplexComputedList {
    get port(): number;
    get type(): string;
    get userName(): string;
    get version(): string;
}
export interface RdsReadReplicaV3Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3#create RdsReadReplicaV3#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3#update RdsReadReplicaV3#update}
    */
    readonly update?: string;
}
export declare function rdsReadReplicaV3TimeoutsToTerraform(struct?: RdsReadReplicaV3TimeoutsOutputReference | RdsReadReplicaV3Timeouts | cdktf.IResolvable): any;
export declare class RdsReadReplicaV3TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): RdsReadReplicaV3Timeouts | undefined;
    set internalValue(value: RdsReadReplicaV3Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface RdsReadReplicaV3Volume {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3#disk_encryption_id RdsReadReplicaV3#disk_encryption_id}
    */
    readonly diskEncryptionId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3#type RdsReadReplicaV3#type}
    */
    readonly type: string;
}
export declare function rdsReadReplicaV3VolumeToTerraform(struct?: RdsReadReplicaV3VolumeOutputReference | RdsReadReplicaV3Volume): any;
export declare class RdsReadReplicaV3VolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): RdsReadReplicaV3Volume | undefined;
    set internalValue(value: RdsReadReplicaV3Volume | undefined);
    private _diskEncryptionId?;
    get diskEncryptionId(): string;
    set diskEncryptionId(value: string);
    resetDiskEncryptionId(): void;
    get diskEncryptionIdInput(): string | undefined;
    get size(): number;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3 opentelekomcloud_rds_read_replica_v3}
*/
export declare class RdsReadReplicaV3 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3 opentelekomcloud_rds_read_replica_v3} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RdsReadReplicaV3Config
    */
    constructor(scope: Construct, id: string, config: RdsReadReplicaV3Config);
    private _availabilityZone?;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    resetAvailabilityZone(): void;
    get availabilityZoneInput(): string | undefined;
    db(index: string): RdsReadReplicaV3Db;
    private _flavorRef?;
    get flavorRef(): string;
    set flavorRef(value: string);
    get flavorRefInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get privateIps(): string[];
    private _publicIps?;
    get publicIps(): string[];
    set publicIps(value: string[]);
    resetPublicIps(): void;
    get publicIpsInput(): string[] | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _replicaOfId?;
    get replicaOfId(): string;
    set replicaOfId(value: string);
    get replicaOfIdInput(): string | undefined;
    get securityGroupId(): string;
    get subnetId(): string;
    get vpcId(): string;
    private _timeouts;
    get timeouts(): RdsReadReplicaV3TimeoutsOutputReference;
    putTimeouts(value: RdsReadReplicaV3Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): RdsReadReplicaV3Timeouts | undefined;
    private _volume;
    get volume(): RdsReadReplicaV3VolumeOutputReference;
    putVolume(value: RdsReadReplicaV3Volume): void;
    get volumeInput(): RdsReadReplicaV3Volume | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
