import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SdrsProtectedInstanceV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protected_instance_v1#delete_target_eip SdrsProtectedInstanceV1#delete_target_eip}
    */
    readonly deleteTargetEip?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protected_instance_v1#delete_target_server SdrsProtectedInstanceV1#delete_target_server}
    */
    readonly deleteTargetServer?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protected_instance_v1#description SdrsProtectedInstanceV1#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protected_instance_v1#group_id SdrsProtectedInstanceV1#group_id}
    */
    readonly groupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protected_instance_v1#ip_address SdrsProtectedInstanceV1#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protected_instance_v1#name SdrsProtectedInstanceV1#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protected_instance_v1#server_id SdrsProtectedInstanceV1#server_id}
    */
    readonly serverId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protected_instance_v1#subnet_id SdrsProtectedInstanceV1#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protected_instance_v1#tags SdrsProtectedInstanceV1#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protected_instance_v1#timeouts SdrsProtectedInstanceV1#timeouts}
    */
    readonly timeouts?: SdrsProtectedInstanceV1Timeouts;
}
export interface SdrsProtectedInstanceV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protected_instance_v1#create SdrsProtectedInstanceV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protected_instance_v1#delete SdrsProtectedInstanceV1#delete}
    */
    readonly delete?: string;
}
export declare function sdrsProtectedInstanceV1TimeoutsToTerraform(struct?: SdrsProtectedInstanceV1TimeoutsOutputReference | SdrsProtectedInstanceV1Timeouts | cdktf.IResolvable): any;
export declare class SdrsProtectedInstanceV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SdrsProtectedInstanceV1Timeouts | undefined;
    set internalValue(value: SdrsProtectedInstanceV1Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protected_instance_v1 opentelekomcloud_sdrs_protected_instance_v1}
*/
export declare class SdrsProtectedInstanceV1 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protected_instance_v1 opentelekomcloud_sdrs_protected_instance_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SdrsProtectedInstanceV1Config
    */
    constructor(scope: Construct, id: string, config: SdrsProtectedInstanceV1Config);
    get createdAt(): string;
    private _deleteTargetEip?;
    get deleteTargetEip(): boolean | cdktf.IResolvable;
    set deleteTargetEip(value: boolean | cdktf.IResolvable);
    resetDeleteTargetEip(): void;
    get deleteTargetEipInput(): boolean | cdktf.IResolvable | undefined;
    private _deleteTargetServer?;
    get deleteTargetServer(): boolean | cdktf.IResolvable;
    set deleteTargetServer(value: boolean | cdktf.IResolvable);
    resetDeleteTargetServer(): void;
    get deleteTargetServerInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    get groupIdInput(): string | undefined;
    get id(): string;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get priorityStation(): string;
    private _serverId?;
    get serverId(): string;
    set serverId(value: string);
    get serverIdInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get targetId(): string;
    get updatedAt(): string;
    private _timeouts;
    get timeouts(): SdrsProtectedInstanceV1TimeoutsOutputReference;
    putTimeouts(value: SdrsProtectedInstanceV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SdrsProtectedInstanceV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
