import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SdrsProtectiongroupV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protectiongroup_v1#description SdrsProtectiongroupV1#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protectiongroup_v1#domain_id SdrsProtectiongroupV1#domain_id}
    */
    readonly domainId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protectiongroup_v1#dr_type SdrsProtectiongroupV1#dr_type}
    */
    readonly drType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protectiongroup_v1#name SdrsProtectiongroupV1#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protectiongroup_v1#source_availability_zone SdrsProtectiongroupV1#source_availability_zone}
    */
    readonly sourceAvailabilityZone: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protectiongroup_v1#source_vpc_id SdrsProtectiongroupV1#source_vpc_id}
    */
    readonly sourceVpcId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protectiongroup_v1#target_availability_zone SdrsProtectiongroupV1#target_availability_zone}
    */
    readonly targetAvailabilityZone: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protectiongroup_v1#timeouts SdrsProtectiongroupV1#timeouts}
    */
    readonly timeouts?: SdrsProtectiongroupV1Timeouts;
}
export interface SdrsProtectiongroupV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protectiongroup_v1#create SdrsProtectiongroupV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protectiongroup_v1#delete SdrsProtectiongroupV1#delete}
    */
    readonly delete?: string;
}
export declare function sdrsProtectiongroupV1TimeoutsToTerraform(struct?: SdrsProtectiongroupV1TimeoutsOutputReference | SdrsProtectiongroupV1Timeouts | cdktf.IResolvable): any;
export declare class SdrsProtectiongroupV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SdrsProtectiongroupV1Timeouts | undefined;
    set internalValue(value: SdrsProtectiongroupV1Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protectiongroup_v1 opentelekomcloud_sdrs_protectiongroup_v1}
*/
export declare class SdrsProtectiongroupV1 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protectiongroup_v1 opentelekomcloud_sdrs_protectiongroup_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SdrsProtectiongroupV1Config
    */
    constructor(scope: Construct, id: string, config: SdrsProtectiongroupV1Config);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _domainId?;
    get domainId(): string;
    set domainId(value: string);
    get domainIdInput(): string | undefined;
    private _drType?;
    get drType(): string;
    set drType(value: string);
    resetDrType(): void;
    get drTypeInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sourceAvailabilityZone?;
    get sourceAvailabilityZone(): string;
    set sourceAvailabilityZone(value: string);
    get sourceAvailabilityZoneInput(): string | undefined;
    private _sourceVpcId?;
    get sourceVpcId(): string;
    set sourceVpcId(value: string);
    get sourceVpcIdInput(): string | undefined;
    private _targetAvailabilityZone?;
    get targetAvailabilityZone(): string;
    set targetAvailabilityZone(value: string);
    get targetAvailabilityZoneInput(): string | undefined;
    private _timeouts;
    get timeouts(): SdrsProtectiongroupV1TimeoutsOutputReference;
    putTimeouts(value: SdrsProtectiongroupV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SdrsProtectiongroupV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
