import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SfsFileSystemV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2#access_level SfsFileSystemV2#access_level}
    */
    readonly accessLevel?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2#access_to SfsFileSystemV2#access_to}
    */
    readonly accessTo?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2#access_type SfsFileSystemV2#access_type}
    */
    readonly accessType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2#availability_zone SfsFileSystemV2#availability_zone}
    */
    readonly availabilityZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2#description SfsFileSystemV2#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2#is_public SfsFileSystemV2#is_public}
    */
    readonly isPublic?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2#metadata SfsFileSystemV2#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2#name SfsFileSystemV2#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2#region SfsFileSystemV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2#share_proto SfsFileSystemV2#share_proto}
    */
    readonly shareProto?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2#size SfsFileSystemV2#size}
    */
    readonly size: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2#tags SfsFileSystemV2#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2#timeouts SfsFileSystemV2#timeouts}
    */
    readonly timeouts?: SfsFileSystemV2Timeouts;
}
export interface SfsFileSystemV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2#create SfsFileSystemV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2#delete SfsFileSystemV2#delete}
    */
    readonly delete?: string;
}
export declare function sfsFileSystemV2TimeoutsToTerraform(struct?: SfsFileSystemV2TimeoutsOutputReference | SfsFileSystemV2Timeouts | cdktf.IResolvable): any;
export declare class SfsFileSystemV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SfsFileSystemV2Timeouts | undefined;
    set internalValue(value: SfsFileSystemV2Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2 opentelekomcloud_sfs_file_system_v2}
*/
export declare class SfsFileSystemV2 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2 opentelekomcloud_sfs_file_system_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SfsFileSystemV2Config
    */
    constructor(scope: Construct, id: string, config: SfsFileSystemV2Config);
    private _accessLevel?;
    get accessLevel(): string;
    set accessLevel(value: string);
    resetAccessLevel(): void;
    get accessLevelInput(): string | undefined;
    get accessRuleStatus(): string;
    private _accessTo?;
    get accessTo(): string;
    set accessTo(value: string);
    resetAccessTo(): void;
    get accessToInput(): string | undefined;
    private _accessType?;
    get accessType(): string;
    set accessType(value: string);
    resetAccessType(): void;
    get accessTypeInput(): string | undefined;
    private _availabilityZone?;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    resetAvailabilityZone(): void;
    get availabilityZoneInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get exportLocation(): string;
    get host(): string;
    get id(): string;
    private _isPublic?;
    get isPublic(): boolean | cdktf.IResolvable;
    set isPublic(value: boolean | cdktf.IResolvable);
    resetIsPublic(): void;
    get isPublicInput(): boolean | cdktf.IResolvable | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get shareAccessId(): string;
    private _shareProto?;
    get shareProto(): string;
    set shareProto(value: string);
    resetShareProto(): void;
    get shareProtoInput(): string | undefined;
    get shareType(): string;
    private _size?;
    get size(): number;
    set size(value: number);
    get sizeInput(): number | undefined;
    get status(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get volumeType(): string;
    private _timeouts;
    get timeouts(): SfsFileSystemV2TimeoutsOutputReference;
    putTimeouts(value: SfsFileSystemV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SfsFileSystemV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
