import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SfsShareAccessRulesV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_share_access_rules_v2#share_id SfsShareAccessRulesV2#share_id}
    */
    readonly shareId: string;
    /**
    * access_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_share_access_rules_v2#access_rule SfsShareAccessRulesV2#access_rule}
    */
    readonly accessRule: SfsShareAccessRulesV2AccessRule[] | cdktf.IResolvable;
}
export interface SfsShareAccessRulesV2AccessRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_share_access_rules_v2#access_level SfsShareAccessRulesV2#access_level}
    */
    readonly accessLevel: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_share_access_rules_v2#access_to SfsShareAccessRulesV2#access_to}
    */
    readonly accessTo: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_share_access_rules_v2#access_type SfsShareAccessRulesV2#access_type}
    */
    readonly accessType?: string;
}
export declare function sfsShareAccessRulesV2AccessRuleToTerraform(struct?: SfsShareAccessRulesV2AccessRule | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_share_access_rules_v2 opentelekomcloud_sfs_share_access_rules_v2}
*/
export declare class SfsShareAccessRulesV2 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_share_access_rules_v2 opentelekomcloud_sfs_share_access_rules_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SfsShareAccessRulesV2Config
    */
    constructor(scope: Construct, id: string, config: SfsShareAccessRulesV2Config);
    get id(): string;
    private _shareId?;
    get shareId(): string;
    set shareId(value: string);
    get shareIdInput(): string | undefined;
    private _accessRule?;
    get accessRule(): SfsShareAccessRulesV2AccessRule[] | cdktf.IResolvable;
    set accessRule(value: SfsShareAccessRulesV2AccessRule[] | cdktf.IResolvable);
    get accessRuleInput(): cdktf.IResolvable | SfsShareAccessRulesV2AccessRule[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
