import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SmnTopicV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_topic_v2#display_name SmnTopicV2#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_topic_v2#name SmnTopicV2#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_topic_v2#project_name SmnTopicV2#project_name}
    */
    readonly projectName?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_topic_v2 opentelekomcloud_smn_topic_v2}
*/
export declare class SmnTopicV2 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_topic_v2 opentelekomcloud_smn_topic_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SmnTopicV2Config
    */
    constructor(scope: Construct, id: string, config: SmnTopicV2Config);
    get createTime(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _projectName?;
    get projectName(): string;
    set projectName(value: string);
    resetProjectName(): void;
    get projectNameInput(): string | undefined;
    get pushPolicy(): number;
    get topicUrn(): string;
    get updateTime(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
