import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SwrOrganizationV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_organization_v2#name SwrOrganizationV2#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_organization_v2#timeouts SwrOrganizationV2#timeouts}
    */
    readonly timeouts?: SwrOrganizationV2Timeouts;
}
export interface SwrOrganizationV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_organization_v2#create SwrOrganizationV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_organization_v2#delete SwrOrganizationV2#delete}
    */
    readonly delete?: string;
}
export declare function swrOrganizationV2TimeoutsToTerraform(struct?: SwrOrganizationV2TimeoutsOutputReference | SwrOrganizationV2Timeouts | cdktf.IResolvable): any;
export declare class SwrOrganizationV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SwrOrganizationV2Timeouts | undefined;
    set internalValue(value: SwrOrganizationV2Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_organization_v2 opentelekomcloud_swr_organization_v2}
*/
export declare class SwrOrganizationV2 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_organization_v2 opentelekomcloud_swr_organization_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SwrOrganizationV2Config
    */
    constructor(scope: Construct, id: string, config: SwrOrganizationV2Config);
    get auth(): number;
    get creatorName(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get organizationId(): number;
    private _timeouts;
    get timeouts(): SwrOrganizationV2TimeoutsOutputReference;
    putTimeouts(value: SwrOrganizationV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SwrOrganizationV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
