import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VbsBackupPolicyV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2#frequency VbsBackupPolicyV2#frequency}
    */
    readonly frequency?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2#name VbsBackupPolicyV2#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2#region VbsBackupPolicyV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2#rentention_day VbsBackupPolicyV2#rentention_day}
    */
    readonly rententionDay?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2#rentention_num VbsBackupPolicyV2#rentention_num}
    */
    readonly rententionNum?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2#resources VbsBackupPolicyV2#resources}
    */
    readonly resources?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2#retain_first_backup VbsBackupPolicyV2#retain_first_backup}
    */
    readonly retainFirstBackup: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2#start_time VbsBackupPolicyV2#start_time}
    */
    readonly startTime: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2#status VbsBackupPolicyV2#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2#week_frequency VbsBackupPolicyV2#week_frequency}
    */
    readonly weekFrequency?: string[];
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2#tags VbsBackupPolicyV2#tags}
    */
    readonly tags?: VbsBackupPolicyV2Tags[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2#timeouts VbsBackupPolicyV2#timeouts}
    */
    readonly timeouts?: VbsBackupPolicyV2Timeouts;
}
export interface VbsBackupPolicyV2Tags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2#key VbsBackupPolicyV2#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2#value VbsBackupPolicyV2#value}
    */
    readonly value: string;
}
export declare function vbsBackupPolicyV2TagsToTerraform(struct?: VbsBackupPolicyV2Tags | cdktf.IResolvable): any;
export interface VbsBackupPolicyV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2#create VbsBackupPolicyV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2#delete VbsBackupPolicyV2#delete}
    */
    readonly delete?: string;
}
export declare function vbsBackupPolicyV2TimeoutsToTerraform(struct?: VbsBackupPolicyV2TimeoutsOutputReference | VbsBackupPolicyV2Timeouts | cdktf.IResolvable): any;
export declare class VbsBackupPolicyV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VbsBackupPolicyV2Timeouts | undefined;
    set internalValue(value: VbsBackupPolicyV2Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2 opentelekomcloud_vbs_backup_policy_v2}
*/
export declare class VbsBackupPolicyV2 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2 opentelekomcloud_vbs_backup_policy_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VbsBackupPolicyV2Config
    */
    constructor(scope: Construct, id: string, config: VbsBackupPolicyV2Config);
    private _frequency?;
    get frequency(): number;
    set frequency(value: number);
    resetFrequency(): void;
    get frequencyInput(): number | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get policyResourceCount(): number;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _rententionDay?;
    get rententionDay(): number;
    set rententionDay(value: number);
    resetRententionDay(): void;
    get rententionDayInput(): number | undefined;
    private _rententionNum?;
    get rententionNum(): number;
    set rententionNum(value: number);
    resetRententionNum(): void;
    get rententionNumInput(): number | undefined;
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _retainFirstBackup?;
    get retainFirstBackup(): string;
    set retainFirstBackup(value: string);
    get retainFirstBackupInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _weekFrequency?;
    get weekFrequency(): string[];
    set weekFrequency(value: string[]);
    resetWeekFrequency(): void;
    get weekFrequencyInput(): string[] | undefined;
    private _tags?;
    get tags(): VbsBackupPolicyV2Tags[] | cdktf.IResolvable;
    set tags(value: VbsBackupPolicyV2Tags[] | cdktf.IResolvable);
    resetTags(): void;
    get tagsInput(): cdktf.IResolvable | VbsBackupPolicyV2Tags[] | undefined;
    private _timeouts;
    get timeouts(): VbsBackupPolicyV2TimeoutsOutputReference;
    putTimeouts(value: VbsBackupPolicyV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): VbsBackupPolicyV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
