import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VbsBackupShareV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_share_v2#backup_id VbsBackupShareV2#backup_id}
    */
    readonly backupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_share_v2#region VbsBackupShareV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_share_v2#to_project_ids VbsBackupShareV2#to_project_ids}
    */
    readonly toProjectIds: string[];
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_share_v2#timeouts VbsBackupShareV2#timeouts}
    */
    readonly timeouts?: VbsBackupShareV2Timeouts;
}
export interface VbsBackupShareV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_share_v2#create VbsBackupShareV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_share_v2#delete VbsBackupShareV2#delete}
    */
    readonly delete?: string;
}
export declare function vbsBackupShareV2TimeoutsToTerraform(struct?: VbsBackupShareV2TimeoutsOutputReference | VbsBackupShareV2Timeouts | cdktf.IResolvable): any;
export declare class VbsBackupShareV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VbsBackupShareV2Timeouts | undefined;
    set internalValue(value: VbsBackupShareV2Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_share_v2 opentelekomcloud_vbs_backup_share_v2}
*/
export declare class VbsBackupShareV2 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_share_v2 opentelekomcloud_vbs_backup_share_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VbsBackupShareV2Config
    */
    constructor(scope: Construct, id: string, config: VbsBackupShareV2Config);
    get availabilityZone(): string;
    private _backupId?;
    get backupId(): string;
    set backupId(value: string);
    get backupIdInput(): string | undefined;
    get backupName(): string;
    get backupStatus(): string;
    get container(): string;
    get description(): string;
    get id(): string;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get serviceMetadata(): string;
    get shareIds(): string[];
    get size(): number;
    get snapshotId(): string;
    private _toProjectIds?;
    get toProjectIds(): string[];
    set toProjectIds(value: string[]);
    get toProjectIdsInput(): string[] | undefined;
    get volumeId(): string;
    private _timeouts;
    get timeouts(): VbsBackupShareV2TimeoutsOutputReference;
    putTimeouts(value: VbsBackupShareV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): VbsBackupShareV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
