import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VbsBackupV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_v2#description VbsBackupV2#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_v2#name VbsBackupV2#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_v2#region VbsBackupV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_v2#snapshot_id VbsBackupV2#snapshot_id}
    */
    readonly snapshotId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_v2#volume_id VbsBackupV2#volume_id}
    */
    readonly volumeId: string;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_v2#tags VbsBackupV2#tags}
    */
    readonly tags?: VbsBackupV2Tags[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_v2#timeouts VbsBackupV2#timeouts}
    */
    readonly timeouts?: VbsBackupV2Timeouts;
}
export interface VbsBackupV2Tags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_v2#key VbsBackupV2#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_v2#value VbsBackupV2#value}
    */
    readonly value: string;
}
export declare function vbsBackupV2TagsToTerraform(struct?: VbsBackupV2Tags | cdktf.IResolvable): any;
export interface VbsBackupV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_v2#create VbsBackupV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_v2#delete VbsBackupV2#delete}
    */
    readonly delete?: string;
}
export declare function vbsBackupV2TimeoutsToTerraform(struct?: VbsBackupV2TimeoutsOutputReference | VbsBackupV2Timeouts | cdktf.IResolvable): any;
export declare class VbsBackupV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VbsBackupV2Timeouts | undefined;
    set internalValue(value: VbsBackupV2Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_v2 opentelekomcloud_vbs_backup_v2}
*/
export declare class VbsBackupV2 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_v2 opentelekomcloud_vbs_backup_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VbsBackupV2Config
    */
    constructor(scope: Construct, id: string, config: VbsBackupV2Config);
    get availabilityZone(): string;
    get container(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get serviceMetadata(): string;
    get size(): number;
    private _snapshotId?;
    get snapshotId(): string;
    set snapshotId(value: string);
    resetSnapshotId(): void;
    get snapshotIdInput(): string | undefined;
    get status(): string;
    private _volumeId?;
    get volumeId(): string;
    set volumeId(value: string);
    get volumeIdInput(): string | undefined;
    private _tags?;
    get tags(): VbsBackupV2Tags[] | cdktf.IResolvable;
    set tags(value: VbsBackupV2Tags[] | cdktf.IResolvable);
    resetTags(): void;
    get tagsInput(): cdktf.IResolvable | VbsBackupV2Tags[] | undefined;
    private _timeouts;
    get timeouts(): VbsBackupV2TimeoutsOutputReference;
    putTimeouts(value: VbsBackupV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): VbsBackupV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
