import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VpcEipV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_eip_v1#region VpcEipV1#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_eip_v1#tags VpcEipV1#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_eip_v1#value_specs VpcEipV1#value_specs}
    */
    readonly valueSpecs?: {
        [key: string]: string;
    };
    /**
    * bandwidth block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_eip_v1#bandwidth VpcEipV1#bandwidth}
    */
    readonly bandwidth: VpcEipV1Bandwidth;
    /**
    * publicip block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_eip_v1#publicip VpcEipV1#publicip}
    */
    readonly publicip: VpcEipV1Publicip;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_eip_v1#timeouts VpcEipV1#timeouts}
    */
    readonly timeouts?: VpcEipV1Timeouts;
}
export interface VpcEipV1Bandwidth {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_eip_v1#charge_mode VpcEipV1#charge_mode}
    */
    readonly chargeMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_eip_v1#name VpcEipV1#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_eip_v1#share_type VpcEipV1#share_type}
    */
    readonly shareType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_eip_v1#size VpcEipV1#size}
    */
    readonly size: number;
}
export declare function vpcEipV1BandwidthToTerraform(struct?: VpcEipV1BandwidthOutputReference | VpcEipV1Bandwidth): any;
export declare class VpcEipV1BandwidthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VpcEipV1Bandwidth | undefined;
    set internalValue(value: VpcEipV1Bandwidth | undefined);
    private _chargeMode?;
    get chargeMode(): string;
    set chargeMode(value: string);
    resetChargeMode(): void;
    get chargeModeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _shareType?;
    get shareType(): string;
    set shareType(value: string);
    get shareTypeInput(): string | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    get sizeInput(): number | undefined;
}
export interface VpcEipV1Publicip {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_eip_v1#ip_address VpcEipV1#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_eip_v1#port_id VpcEipV1#port_id}
    */
    readonly portId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_eip_v1#type VpcEipV1#type}
    */
    readonly type: string;
}
export declare function vpcEipV1PublicipToTerraform(struct?: VpcEipV1PublicipOutputReference | VpcEipV1Publicip): any;
export declare class VpcEipV1PublicipOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VpcEipV1Publicip | undefined;
    set internalValue(value: VpcEipV1Publicip | undefined);
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _portId?;
    get portId(): string;
    set portId(value: string);
    resetPortId(): void;
    get portIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface VpcEipV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_eip_v1#create VpcEipV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_eip_v1#delete VpcEipV1#delete}
    */
    readonly delete?: string;
}
export declare function vpcEipV1TimeoutsToTerraform(struct?: VpcEipV1TimeoutsOutputReference | VpcEipV1Timeouts | cdktf.IResolvable): any;
export declare class VpcEipV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VpcEipV1Timeouts | undefined;
    set internalValue(value: VpcEipV1Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_eip_v1 opentelekomcloud_vpc_eip_v1}
*/
export declare class VpcEipV1 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_eip_v1 opentelekomcloud_vpc_eip_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VpcEipV1Config
    */
    constructor(scope: Construct, id: string, config: VpcEipV1Config);
    get id(): string;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _valueSpecs?;
    get valueSpecs(): {
        [key: string]: string;
    };
    set valueSpecs(value: {
        [key: string]: string;
    });
    resetValueSpecs(): void;
    get valueSpecsInput(): {
        [key: string]: string;
    } | undefined;
    private _bandwidth;
    get bandwidth(): VpcEipV1BandwidthOutputReference;
    putBandwidth(value: VpcEipV1Bandwidth): void;
    get bandwidthInput(): VpcEipV1Bandwidth | undefined;
    private _publicip;
    get publicip(): VpcEipV1PublicipOutputReference;
    putPublicip(value: VpcEipV1Publicip): void;
    get publicipInput(): VpcEipV1Publicip | undefined;
    private _timeouts;
    get timeouts(): VpcEipV1TimeoutsOutputReference;
    putTimeouts(value: VpcEipV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): VpcEipV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
