import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VpcPeeringConnectionAccepterV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_accepter_v2#accept VpcPeeringConnectionAccepterV2#accept}
    */
    readonly accept?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_accepter_v2#region VpcPeeringConnectionAccepterV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_accepter_v2#vpc_peering_connection_id VpcPeeringConnectionAccepterV2#vpc_peering_connection_id}
    */
    readonly vpcPeeringConnectionId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_accepter_v2#timeouts VpcPeeringConnectionAccepterV2#timeouts}
    */
    readonly timeouts?: VpcPeeringConnectionAccepterV2Timeouts;
}
export interface VpcPeeringConnectionAccepterV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_accepter_v2#create VpcPeeringConnectionAccepterV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_accepter_v2#delete VpcPeeringConnectionAccepterV2#delete}
    */
    readonly delete?: string;
}
export declare function vpcPeeringConnectionAccepterV2TimeoutsToTerraform(struct?: VpcPeeringConnectionAccepterV2TimeoutsOutputReference | VpcPeeringConnectionAccepterV2Timeouts | cdktf.IResolvable): any;
export declare class VpcPeeringConnectionAccepterV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VpcPeeringConnectionAccepterV2Timeouts | undefined;
    set internalValue(value: VpcPeeringConnectionAccepterV2Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_accepter_v2 opentelekomcloud_vpc_peering_connection_accepter_v2}
*/
export declare class VpcPeeringConnectionAccepterV2 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_accepter_v2 opentelekomcloud_vpc_peering_connection_accepter_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VpcPeeringConnectionAccepterV2Config
    */
    constructor(scope: Construct, id: string, config: VpcPeeringConnectionAccepterV2Config);
    private _accept?;
    get accept(): boolean | cdktf.IResolvable;
    set accept(value: boolean | cdktf.IResolvable);
    resetAccept(): void;
    get acceptInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    get name(): string;
    get peerTenantId(): string;
    get peerVpcId(): string;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get status(): string;
    get vpcId(): string;
    private _vpcPeeringConnectionId?;
    get vpcPeeringConnectionId(): string;
    set vpcPeeringConnectionId(value: string);
    get vpcPeeringConnectionIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): VpcPeeringConnectionAccepterV2TimeoutsOutputReference;
    putTimeouts(value: VpcPeeringConnectionAccepterV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): VpcPeeringConnectionAccepterV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
