import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VpcRouteV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_route_v2#destination VpcRouteV2#destination}
    */
    readonly destination: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_route_v2#nexthop VpcRouteV2#nexthop}
    */
    readonly nexthop: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_route_v2#region VpcRouteV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_route_v2#tenant_id VpcRouteV2#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_route_v2#type VpcRouteV2#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_route_v2#vpc_id VpcRouteV2#vpc_id}
    */
    readonly vpcId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_route_v2#timeouts VpcRouteV2#timeouts}
    */
    readonly timeouts?: VpcRouteV2Timeouts;
}
export interface VpcRouteV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_route_v2#create VpcRouteV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_route_v2#delete VpcRouteV2#delete}
    */
    readonly delete?: string;
}
export declare function vpcRouteV2TimeoutsToTerraform(struct?: VpcRouteV2TimeoutsOutputReference | VpcRouteV2Timeouts | cdktf.IResolvable): any;
export declare class VpcRouteV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VpcRouteV2Timeouts | undefined;
    set internalValue(value: VpcRouteV2Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_route_v2 opentelekomcloud_vpc_route_v2}
*/
export declare class VpcRouteV2 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_route_v2 opentelekomcloud_vpc_route_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VpcRouteV2Config
    */
    constructor(scope: Construct, id: string, config: VpcRouteV2Config);
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    get id(): string;
    private _nexthop?;
    get nexthop(): string;
    set nexthop(value: string);
    get nexthopInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    get vpcIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): VpcRouteV2TimeoutsOutputReference;
    putTimeouts(value: VpcRouteV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): VpcRouteV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
