import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VpcepServiceV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1#approval_enabled VpcepServiceV1#approval_enabled}
    */
    readonly approvalEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1#name VpcepServiceV1#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1#pool_id VpcepServiceV1#pool_id}
    */
    readonly poolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1#port_id VpcepServiceV1#port_id}
    */
    readonly portId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1#server_type VpcepServiceV1#server_type}
    */
    readonly serverType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1#service_type VpcepServiceV1#service_type}
    */
    readonly serviceType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1#tags VpcepServiceV1#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1#tcp_proxy VpcepServiceV1#tcp_proxy}
    */
    readonly tcpProxy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1#vip_port_id VpcepServiceV1#vip_port_id}
    */
    readonly vipPortId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1#vpc_id VpcepServiceV1#vpc_id}
    */
    readonly vpcId: string;
    /**
    * port block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1#port VpcepServiceV1#port}
    */
    readonly port: VpcepServiceV1Port[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1#timeouts VpcepServiceV1#timeouts}
    */
    readonly timeouts?: VpcepServiceV1Timeouts;
}
export interface VpcepServiceV1Port {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1#client_port VpcepServiceV1#client_port}
    */
    readonly clientPort: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1#protocol VpcepServiceV1#protocol}
    */
    readonly protocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1#server_port VpcepServiceV1#server_port}
    */
    readonly serverPort: number;
}
export declare function vpcepServiceV1PortToTerraform(struct?: VpcepServiceV1Port | cdktf.IResolvable): any;
export interface VpcepServiceV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1#default VpcepServiceV1#default}
    */
    readonly default?: string;
}
export declare function vpcepServiceV1TimeoutsToTerraform(struct?: VpcepServiceV1TimeoutsOutputReference | VpcepServiceV1Timeouts | cdktf.IResolvable): any;
export declare class VpcepServiceV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VpcepServiceV1Timeouts | undefined;
    set internalValue(value: VpcepServiceV1Timeouts | undefined);
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1 opentelekomcloud_vpcep_service_v1}
*/
export declare class VpcepServiceV1 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1 opentelekomcloud_vpcep_service_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VpcepServiceV1Config
    */
    constructor(scope: Construct, id: string, config: VpcepServiceV1Config);
    private _approvalEnabled?;
    get approvalEnabled(): boolean | cdktf.IResolvable;
    set approvalEnabled(value: boolean | cdktf.IResolvable);
    resetApprovalEnabled(): void;
    get approvalEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _poolId?;
    get poolId(): string;
    set poolId(value: string);
    resetPoolId(): void;
    get poolIdInput(): string | undefined;
    private _portId?;
    get portId(): string;
    set portId(value: string);
    get portIdInput(): string | undefined;
    private _serverType?;
    get serverType(): string;
    set serverType(value: string);
    get serverTypeInput(): string | undefined;
    private _serviceType?;
    get serviceType(): string;
    set serviceType(value: string);
    resetServiceType(): void;
    get serviceTypeInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tcpProxy?;
    get tcpProxy(): string;
    set tcpProxy(value: string);
    resetTcpProxy(): void;
    get tcpProxyInput(): string | undefined;
    private _vipPortId?;
    get vipPortId(): string;
    set vipPortId(value: string);
    resetVipPortId(): void;
    get vipPortIdInput(): string | undefined;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    get vpcIdInput(): string | undefined;
    private _port?;
    get port(): VpcepServiceV1Port[] | cdktf.IResolvable;
    set port(value: VpcepServiceV1Port[] | cdktf.IResolvable);
    get portInput(): cdktf.IResolvable | VpcepServiceV1Port[] | undefined;
    private _timeouts;
    get timeouts(): VpcepServiceV1TimeoutsOutputReference;
    putTimeouts(value: VpcepServiceV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): VpcepServiceV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
