import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VpnaasIkePolicyV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ike_policy_v2#auth_algorithm VpnaasIkePolicyV2#auth_algorithm}
    */
    readonly authAlgorithm?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ike_policy_v2#description VpnaasIkePolicyV2#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ike_policy_v2#encryption_algorithm VpnaasIkePolicyV2#encryption_algorithm}
    */
    readonly encryptionAlgorithm?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ike_policy_v2#ike_version VpnaasIkePolicyV2#ike_version}
    */
    readonly ikeVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ike_policy_v2#name VpnaasIkePolicyV2#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ike_policy_v2#pfs VpnaasIkePolicyV2#pfs}
    */
    readonly pfs?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ike_policy_v2#phase1_negotiation_mode VpnaasIkePolicyV2#phase1_negotiation_mode}
    */
    readonly phase1NegotiationMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ike_policy_v2#region VpnaasIkePolicyV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ike_policy_v2#tenant_id VpnaasIkePolicyV2#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ike_policy_v2#value_specs VpnaasIkePolicyV2#value_specs}
    */
    readonly valueSpecs?: {
        [key: string]: string;
    };
    /**
    * lifetime block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ike_policy_v2#lifetime VpnaasIkePolicyV2#lifetime}
    */
    readonly lifetime?: VpnaasIkePolicyV2Lifetime[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ike_policy_v2#timeouts VpnaasIkePolicyV2#timeouts}
    */
    readonly timeouts?: VpnaasIkePolicyV2Timeouts;
}
export interface VpnaasIkePolicyV2Lifetime {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ike_policy_v2#units VpnaasIkePolicyV2#units}
    */
    readonly units?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ike_policy_v2#value VpnaasIkePolicyV2#value}
    */
    readonly value?: number;
}
export declare function vpnaasIkePolicyV2LifetimeToTerraform(struct?: VpnaasIkePolicyV2Lifetime | cdktf.IResolvable): any;
export interface VpnaasIkePolicyV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ike_policy_v2#create VpnaasIkePolicyV2#create}
    */
    readonly create?: string;
}
export declare function vpnaasIkePolicyV2TimeoutsToTerraform(struct?: VpnaasIkePolicyV2TimeoutsOutputReference | VpnaasIkePolicyV2Timeouts | cdktf.IResolvable): any;
export declare class VpnaasIkePolicyV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): VpnaasIkePolicyV2Timeouts | undefined;
    set internalValue(value: VpnaasIkePolicyV2Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ike_policy_v2 opentelekomcloud_vpnaas_ike_policy_v2}
*/
export declare class VpnaasIkePolicyV2 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ike_policy_v2 opentelekomcloud_vpnaas_ike_policy_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VpnaasIkePolicyV2Config = {}
    */
    constructor(scope: Construct, id: string, config?: VpnaasIkePolicyV2Config);
    private _authAlgorithm?;
    get authAlgorithm(): string;
    set authAlgorithm(value: string);
    resetAuthAlgorithm(): void;
    get authAlgorithmInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _encryptionAlgorithm?;
    get encryptionAlgorithm(): string;
    set encryptionAlgorithm(value: string);
    resetEncryptionAlgorithm(): void;
    get encryptionAlgorithmInput(): string | undefined;
    get id(): string;
    private _ikeVersion?;
    get ikeVersion(): string;
    set ikeVersion(value: string);
    resetIkeVersion(): void;
    get ikeVersionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _pfs?;
    get pfs(): string;
    set pfs(value: string);
    resetPfs(): void;
    get pfsInput(): string | undefined;
    private _phase1NegotiationMode?;
    get phase1NegotiationMode(): string;
    set phase1NegotiationMode(value: string);
    resetPhase1NegotiationMode(): void;
    get phase1NegotiationModeInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _valueSpecs?;
    get valueSpecs(): {
        [key: string]: string;
    };
    set valueSpecs(value: {
        [key: string]: string;
    });
    resetValueSpecs(): void;
    get valueSpecsInput(): {
        [key: string]: string;
    } | undefined;
    private _lifetime?;
    get lifetime(): VpnaasIkePolicyV2Lifetime[] | cdktf.IResolvable;
    set lifetime(value: VpnaasIkePolicyV2Lifetime[] | cdktf.IResolvable);
    resetLifetime(): void;
    get lifetimeInput(): cdktf.IResolvable | VpnaasIkePolicyV2Lifetime[] | undefined;
    private _timeouts;
    get timeouts(): VpnaasIkePolicyV2TimeoutsOutputReference;
    putTimeouts(value: VpnaasIkePolicyV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): VpnaasIkePolicyV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
