import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WafCertificateV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_certificate_v1#content WafCertificateV1#content}
    */
    readonly content: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_certificate_v1#key WafCertificateV1#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_certificate_v1#name WafCertificateV1#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_certificate_v1#region WafCertificateV1#region}
    */
    readonly region?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_certificate_v1#timeouts WafCertificateV1#timeouts}
    */
    readonly timeouts?: WafCertificateV1Timeouts;
}
export interface WafCertificateV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_certificate_v1#create WafCertificateV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_certificate_v1#delete WafCertificateV1#delete}
    */
    readonly delete?: string;
}
export declare function wafCertificateV1TimeoutsToTerraform(struct?: WafCertificateV1TimeoutsOutputReference | WafCertificateV1Timeouts | cdktf.IResolvable): any;
export declare class WafCertificateV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): WafCertificateV1Timeouts | undefined;
    set internalValue(value: WafCertificateV1Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_certificate_v1 opentelekomcloud_waf_certificate_v1}
*/
export declare class WafCertificateV1 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_certificate_v1 opentelekomcloud_waf_certificate_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WafCertificateV1Config
    */
    constructor(scope: Construct, id: string, config: WafCertificateV1Config);
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
    get expires(): string;
    get id(): string;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _timeouts;
    get timeouts(): WafCertificateV1TimeoutsOutputReference;
    putTimeouts(value: WafCertificateV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): WafCertificateV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
