import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WafDomainV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#certificate_id WafDomainV1#certificate_id}
    */
    readonly certificateId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#cipher WafDomainV1#cipher}
    */
    readonly cipher?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#hostname WafDomainV1#hostname}
    */
    readonly hostname: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#policy_id WafDomainV1#policy_id}
    */
    readonly policyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#proxy WafDomainV1#proxy}
    */
    readonly proxy: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#sip_header_list WafDomainV1#sip_header_list}
    */
    readonly sipHeaderList?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#sip_header_name WafDomainV1#sip_header_name}
    */
    readonly sipHeaderName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#tls WafDomainV1#tls}
    */
    readonly tls?: string;
    /**
    * server block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#server WafDomainV1#server}
    */
    readonly server: WafDomainV1Server[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#timeouts WafDomainV1#timeouts}
    */
    readonly timeouts?: WafDomainV1Timeouts;
}
export interface WafDomainV1Server {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#address WafDomainV1#address}
    */
    readonly address: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#back_protocol WafDomainV1#back_protocol}
    */
    readonly backProtocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#client_protocol WafDomainV1#client_protocol}
    */
    readonly clientProtocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#front_protocol WafDomainV1#front_protocol}
    */
    readonly frontProtocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#port WafDomainV1#port}
    */
    readonly port: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#server_protocol WafDomainV1#server_protocol}
    */
    readonly serverProtocol?: string;
}
export declare function wafDomainV1ServerToTerraform(struct?: WafDomainV1Server | cdktf.IResolvable): any;
export interface WafDomainV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#create WafDomainV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1#delete WafDomainV1#delete}
    */
    readonly delete?: string;
}
export declare function wafDomainV1TimeoutsToTerraform(struct?: WafDomainV1TimeoutsOutputReference | WafDomainV1Timeouts | cdktf.IResolvable): any;
export declare class WafDomainV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): WafDomainV1Timeouts | undefined;
    set internalValue(value: WafDomainV1Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1 opentelekomcloud_waf_domain_v1}
*/
export declare class WafDomainV1 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_domain_v1 opentelekomcloud_waf_domain_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WafDomainV1Config
    */
    constructor(scope: Construct, id: string, config: WafDomainV1Config);
    get accessCode(): string;
    get accessStatus(): number;
    private _certificateId?;
    get certificateId(): string;
    set certificateId(value: string);
    resetCertificateId(): void;
    get certificateIdInput(): string | undefined;
    private _cipher?;
    get cipher(): string;
    set cipher(value: string);
    resetCipher(): void;
    get cipherInput(): string | undefined;
    get cname(): string;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    get hostnameInput(): string | undefined;
    get id(): string;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    resetPolicyId(): void;
    get policyIdInput(): string | undefined;
    get protectStatus(): number;
    get protocol(): string;
    private _proxy?;
    get proxy(): boolean | cdktf.IResolvable;
    set proxy(value: boolean | cdktf.IResolvable);
    get proxyInput(): boolean | cdktf.IResolvable | undefined;
    private _sipHeaderList?;
    get sipHeaderList(): string[];
    set sipHeaderList(value: string[]);
    resetSipHeaderList(): void;
    get sipHeaderListInput(): string[] | undefined;
    private _sipHeaderName?;
    get sipHeaderName(): string;
    set sipHeaderName(value: string);
    resetSipHeaderName(): void;
    get sipHeaderNameInput(): string | undefined;
    get subDomain(): string;
    private _tls?;
    get tls(): string;
    set tls(value: string);
    resetTls(): void;
    get tlsInput(): string | undefined;
    get txtCode(): string;
    private _server?;
    get server(): WafDomainV1Server[] | cdktf.IResolvable;
    set server(value: WafDomainV1Server[] | cdktf.IResolvable);
    get serverInput(): cdktf.IResolvable | WafDomainV1Server[] | undefined;
    private _timeouts;
    get timeouts(): WafDomainV1TimeoutsOutputReference;
    putTimeouts(value: WafDomainV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): WafDomainV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
