import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WafFalsealarmmaskingRuleV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_falsealarmmasking_rule_v1#policy_id WafFalsealarmmaskingRuleV1#policy_id}
    */
    readonly policyId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_falsealarmmasking_rule_v1#rule WafFalsealarmmaskingRuleV1#rule}
    */
    readonly rule: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_falsealarmmasking_rule_v1#url WafFalsealarmmaskingRuleV1#url}
    */
    readonly url: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_falsealarmmasking_rule_v1#timeouts WafFalsealarmmaskingRuleV1#timeouts}
    */
    readonly timeouts?: WafFalsealarmmaskingRuleV1Timeouts;
}
export interface WafFalsealarmmaskingRuleV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_falsealarmmasking_rule_v1#create WafFalsealarmmaskingRuleV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_falsealarmmasking_rule_v1#delete WafFalsealarmmaskingRuleV1#delete}
    */
    readonly delete?: string;
}
export declare function wafFalsealarmmaskingRuleV1TimeoutsToTerraform(struct?: WafFalsealarmmaskingRuleV1TimeoutsOutputReference | WafFalsealarmmaskingRuleV1Timeouts | cdktf.IResolvable): any;
export declare class WafFalsealarmmaskingRuleV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): WafFalsealarmmaskingRuleV1Timeouts | undefined;
    set internalValue(value: WafFalsealarmmaskingRuleV1Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_falsealarmmasking_rule_v1 opentelekomcloud_waf_falsealarmmasking_rule_v1}
*/
export declare class WafFalsealarmmaskingRuleV1 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_falsealarmmasking_rule_v1 opentelekomcloud_waf_falsealarmmasking_rule_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WafFalsealarmmaskingRuleV1Config
    */
    constructor(scope: Construct, id: string, config: WafFalsealarmmaskingRuleV1Config);
    get id(): string;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    get policyIdInput(): string | undefined;
    private _rule?;
    get rule(): string;
    set rule(value: string);
    get ruleInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _timeouts;
    get timeouts(): WafFalsealarmmaskingRuleV1TimeoutsOutputReference;
    putTimeouts(value: WafFalsealarmmaskingRuleV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): WafFalsealarmmaskingRuleV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
