import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WafPreciseprotectionRuleV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1#action_category WafPreciseprotectionRuleV1#action_category}
    */
    readonly actionCategory: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1#end WafPreciseprotectionRuleV1#end}
    */
    readonly end?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1#name WafPreciseprotectionRuleV1#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1#policy_id WafPreciseprotectionRuleV1#policy_id}
    */
    readonly policyId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1#priority WafPreciseprotectionRuleV1#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1#start WafPreciseprotectionRuleV1#start}
    */
    readonly start?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1#time WafPreciseprotectionRuleV1#time}
    */
    readonly time?: boolean | cdktf.IResolvable;
    /**
    * conditions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1#conditions WafPreciseprotectionRuleV1#conditions}
    */
    readonly conditions: WafPreciseprotectionRuleV1Conditions[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1#timeouts WafPreciseprotectionRuleV1#timeouts}
    */
    readonly timeouts?: WafPreciseprotectionRuleV1Timeouts;
}
export interface WafPreciseprotectionRuleV1Conditions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1#category WafPreciseprotectionRuleV1#category}
    */
    readonly category: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1#contents WafPreciseprotectionRuleV1#contents}
    */
    readonly contents: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1#index WafPreciseprotectionRuleV1#index}
    */
    readonly index?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1#logic WafPreciseprotectionRuleV1#logic}
    */
    readonly logic: string;
}
export declare function wafPreciseprotectionRuleV1ConditionsToTerraform(struct?: WafPreciseprotectionRuleV1Conditions | cdktf.IResolvable): any;
export interface WafPreciseprotectionRuleV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1#create WafPreciseprotectionRuleV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1#delete WafPreciseprotectionRuleV1#delete}
    */
    readonly delete?: string;
}
export declare function wafPreciseprotectionRuleV1TimeoutsToTerraform(struct?: WafPreciseprotectionRuleV1TimeoutsOutputReference | WafPreciseprotectionRuleV1Timeouts | cdktf.IResolvable): any;
export declare class WafPreciseprotectionRuleV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): WafPreciseprotectionRuleV1Timeouts | undefined;
    set internalValue(value: WafPreciseprotectionRuleV1Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1 opentelekomcloud_waf_preciseprotection_rule_v1}
*/
export declare class WafPreciseprotectionRuleV1 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_preciseprotection_rule_v1 opentelekomcloud_waf_preciseprotection_rule_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WafPreciseprotectionRuleV1Config
    */
    constructor(scope: Construct, id: string, config: WafPreciseprotectionRuleV1Config);
    private _actionCategory?;
    get actionCategory(): string;
    set actionCategory(value: string);
    get actionCategoryInput(): string | undefined;
    private _end?;
    get end(): string;
    set end(value: string);
    resetEnd(): void;
    get endInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    get policyIdInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _start?;
    get start(): string;
    set start(value: string);
    resetStart(): void;
    get startInput(): string | undefined;
    private _time?;
    get time(): boolean | cdktf.IResolvable;
    set time(value: boolean | cdktf.IResolvable);
    resetTime(): void;
    get timeInput(): boolean | cdktf.IResolvable | undefined;
    private _conditions?;
    get conditions(): WafPreciseprotectionRuleV1Conditions[] | cdktf.IResolvable;
    set conditions(value: WafPreciseprotectionRuleV1Conditions[] | cdktf.IResolvable);
    get conditionsInput(): cdktf.IResolvable | WafPreciseprotectionRuleV1Conditions[] | undefined;
    private _timeouts;
    get timeouts(): WafPreciseprotectionRuleV1TimeoutsOutputReference;
    putTimeouts(value: WafPreciseprotectionRuleV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): WafPreciseprotectionRuleV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
