import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WafWhiteblackipRuleV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_whiteblackip_rule_v1#addr WafWhiteblackipRuleV1#addr}
    */
    readonly addr: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_whiteblackip_rule_v1#policy_id WafWhiteblackipRuleV1#policy_id}
    */
    readonly policyId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_whiteblackip_rule_v1#white WafWhiteblackipRuleV1#white}
    */
    readonly white?: number;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_whiteblackip_rule_v1#timeouts WafWhiteblackipRuleV1#timeouts}
    */
    readonly timeouts?: WafWhiteblackipRuleV1Timeouts;
}
export interface WafWhiteblackipRuleV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_whiteblackip_rule_v1#create WafWhiteblackipRuleV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_whiteblackip_rule_v1#delete WafWhiteblackipRuleV1#delete}
    */
    readonly delete?: string;
}
export declare function wafWhiteblackipRuleV1TimeoutsToTerraform(struct?: WafWhiteblackipRuleV1TimeoutsOutputReference | WafWhiteblackipRuleV1Timeouts | cdktf.IResolvable): any;
export declare class WafWhiteblackipRuleV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): WafWhiteblackipRuleV1Timeouts | undefined;
    set internalValue(value: WafWhiteblackipRuleV1Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_whiteblackip_rule_v1 opentelekomcloud_waf_whiteblackip_rule_v1}
*/
export declare class WafWhiteblackipRuleV1 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_whiteblackip_rule_v1 opentelekomcloud_waf_whiteblackip_rule_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WafWhiteblackipRuleV1Config
    */
    constructor(scope: Construct, id: string, config: WafWhiteblackipRuleV1Config);
    private _addr?;
    get addr(): string;
    set addr(value: string);
    get addrInput(): string | undefined;
    get id(): string;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    get policyIdInput(): string | undefined;
    private _white?;
    get white(): number;
    set white(value: number);
    resetWhite(): void;
    get whiteInput(): number | undefined;
    private _timeouts;
    get timeouts(): WafWhiteblackipRuleV1TimeoutsOutputReference;
    putTimeouts(value: WafWhiteblackipRuleV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): WafWhiteblackipRuleV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
