# jgreenepack
This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.12.0-alpha.1-SNAPSHOT
- Package version: 1.22.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen
For more information, please visit [https://discuss.dockstore.org/t/opening-helpdesk-tickets/1506](https://discuss.dockstore.org/t/opening-helpdesk-tickets/1506)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com//.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com//.git`)

Then import the package:
```python
import jgreenepack 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import jgreenepack
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import jgreenepack
from jgreenepack.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = jgreenepack.GA4GHApi(jgreenepack.ApiClient(configuration))

try:
    # Return some metadata that is useful for describing this registry
    api_response = api_instance.metadata_get()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling GA4GHApi->metadata_get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*GA4GHApi* | [**metadata_get**](docs/GA4GHApi.md#metadata_get) | **GET** /api/ga4gh/v2/metadata | Return some metadata that is useful for describing this registry
*GA4GHApi* | [**tool_classes_get**](docs/GA4GHApi.md#tool_classes_get) | **GET** /api/ga4gh/v2/toolClasses | List all tool types
*GA4GHApi* | [**tools_get**](docs/GA4GHApi.md#tools_get) | **GET** /api/ga4gh/v2/tools | List all tools
*GA4GHApi* | [**tools_id_get**](docs/GA4GHApi.md#tools_id_get) | **GET** /api/ga4gh/v2/tools/{id} | List one specific tool, acts as an anchor for self references
*GA4GHApi* | [**tools_id_versions_get**](docs/GA4GHApi.md#tools_id_versions_get) | **GET** /api/ga4gh/v2/tools/{id}/versions | List versions of a tool
*GA4GHApi* | [**tools_id_versions_version_id_containerfile_get**](docs/GA4GHApi.md#tools_id_versions_version_id_containerfile_get) | **GET** /api/ga4gh/v2/tools/{id}/versions/{version_id}/containerfile | Get the container specification(s) for the specified image.
*GA4GHApi* | [**tools_id_versions_version_id_get**](docs/GA4GHApi.md#tools_id_versions_version_id_get) | **GET** /api/ga4gh/v2/tools/{id}/versions/{version_id} | List one specific tool version, acts as an anchor for self references
*GA4GHApi* | [**tools_id_versions_version_id_type_descriptor_get**](docs/GA4GHApi.md#tools_id_versions_version_id_type_descriptor_get) | **GET** /api/ga4gh/v2/tools/{id}/versions/{version_id}/{type}/descriptor | Get the tool descriptor for the specified tool
*GA4GHApi* | [**tools_id_versions_version_id_type_descriptor_relative_path_get**](docs/GA4GHApi.md#tools_id_versions_version_id_type_descriptor_relative_path_get) | **GET** /api/ga4gh/v2/tools/{id}/versions/{version_id}/{type}/descriptor/{relative_path} | Get additional tool descriptor files relative to the main file
*GA4GHApi* | [**tools_id_versions_version_id_type_files_get**](docs/GA4GHApi.md#tools_id_versions_version_id_type_files_get) | **GET** /api/ga4gh/v2/tools/{id}/versions/{version_id}/{type}/files | Get a list of objects that contain the relative path and file type
*GA4GHApi* | [**tools_id_versions_version_id_type_tests_get**](docs/GA4GHApi.md#tools_id_versions_version_id_type_tests_get) | **GET** /api/ga4gh/v2/tools/{id}/versions/{version_id}/{type}/tests | Get a list of test JSONs
*GA4GHV1Api* | [**metadata_get**](docs/GA4GHV1Api.md#metadata_get) | **GET** /api/ga4gh/v1/metadata | Return some metadata that is useful for describing this registry
*GA4GHV1Api* | [**tool_classes_get**](docs/GA4GHV1Api.md#tool_classes_get) | **GET** /api/ga4gh/v1/tool-classes | List all tool types
*GA4GHV1Api* | [**tools_get**](docs/GA4GHV1Api.md#tools_get) | **GET** /api/ga4gh/v1/tools | List all tools
*GA4GHV1Api* | [**tools_id_get**](docs/GA4GHV1Api.md#tools_id_get) | **GET** /api/ga4gh/v1/tools/{id} | List one specific tool, acts as an anchor for self references
*GA4GHV1Api* | [**tools_id_versions_get**](docs/GA4GHV1Api.md#tools_id_versions_get) | **GET** /api/ga4gh/v1/tools/{id}/versions | List versions of a tool
*GA4GHV1Api* | [**tools_id_versions_version_id_dockerfile_get**](docs/GA4GHV1Api.md#tools_id_versions_version_id_dockerfile_get) | **GET** /api/ga4gh/v1/tools/{id}/versions/{version_id}/dockerfile | Get the dockerfile for the specified image.
*GA4GHV1Api* | [**tools_id_versions_version_id_get**](docs/GA4GHV1Api.md#tools_id_versions_version_id_get) | **GET** /api/ga4gh/v1/tools/{id}/versions/{version_id} | List one specific tool version, acts as an anchor for self references
*GA4GHV1Api* | [**tools_id_versions_version_id_type_descriptor_get**](docs/GA4GHV1Api.md#tools_id_versions_version_id_type_descriptor_get) | **GET** /api/ga4gh/v1/tools/{id}/versions/{version_id}/{type}/descriptor | Get the tool descriptor (CWL/WDL) for the specified tool.
*GA4GHV1Api* | [**tools_id_versions_version_id_type_descriptor_relative_path_get**](docs/GA4GHV1Api.md#tools_id_versions_version_id_type_descriptor_relative_path_get) | **GET** /api/ga4gh/v1/tools/{id}/versions/{version_id}/{type}/descriptor/{relative_path} | Get additional tool descriptor files (CWL/WDL) relative to the main file
*GA4GHV1Api* | [**tools_id_versions_version_id_type_tests_get**](docs/GA4GHV1Api.md#tools_id_versions_version_id_type_tests_get) | **GET** /api/ga4gh/v1/tools/{id}/versions/{version_id}/{type}/tests | Get an array of test JSONs suitable for use with this descriptor type.
*AliasesApi* | [**add_aliases**](docs/AliasesApi.md#add_aliases) | **POST** /aliases/workflow-versions/{workflowVersionId} | Add aliases linked to a workflow version in Dockstore.
*AliasesApi* | [**get_workflow_version_path_info_by_alias**](docs/AliasesApi.md#get_workflow_version_path_info_by_alias) | **GET** /aliases/workflow-versions/{alias} | Retrieves workflow version path information by alias.
*ContainersApi* | [**add_test_parameter_files**](docs/ContainersApi.md#add_test_parameter_files) | **PUT** /containers/{containerId}/testParameterFiles | Add test parameter files to a tag.
*ContainersApi* | [**all_published_containers**](docs/ContainersApi.md#all_published_containers) | **GET** /containers/published | List all published tools.
*ContainersApi* | [**delete_container**](docs/ContainersApi.md#delete_container) | **DELETE** /containers/{containerId} | Delete a tool.
*ContainersApi* | [**delete_test_parameter_files**](docs/ContainersApi.md#delete_test_parameter_files) | **DELETE** /containers/{containerId}/testParameterFiles | Delete test parameter files to a tag.
*ContainersApi* | [**dockerfile**](docs/ContainersApi.md#dockerfile) | **GET** /containers/{containerId}/dockerfile | Get the corresponding Dockerfile.
*ContainersApi* | [**get_container**](docs/ContainersApi.md#get_container) | **GET** /containers/{containerId} | Retrieve a tool.
*ContainersApi* | [**get_container_by_path**](docs/ContainersApi.md#get_container_by_path) | **GET** /containers/path/{repository} | Get a list of tools by path.
*ContainersApi* | [**get_container_by_tool_path**](docs/ContainersApi.md#get_container_by_tool_path) | **GET** /containers/path/tool/{repository} | Get a tool by the specific tool path
*ContainersApi* | [**get_published_container**](docs/ContainersApi.md#get_published_container) | **GET** /containers/published/{containerId} | Get a published tool.
*ContainersApi* | [**get_published_container_by_path**](docs/ContainersApi.md#get_published_container_by_path) | **GET** /containers/path/{repository}/published | Get a list of published tools by path.
*ContainersApi* | [**get_published_container_by_tool_path**](docs/ContainersApi.md#get_published_container_by_tool_path) | **GET** /containers/path/tool/{repository}/published | Get a published tool by the specific tool path.
*ContainersApi* | [**get_published_container_schema**](docs/ContainersApi.md#get_published_container_schema) | **GET** /containers/schema/{containerId}/published | Get a published tool&#39;s schema by ID.
*ContainersApi* | [**get_published_containers_by_namespace**](docs/ContainersApi.md#get_published_containers_by_namespace) | **GET** /containers/namespace/{namespace}/published | List all published tools belonging to the specified namespace.
*ContainersApi* | [**get_starred_users**](docs/ContainersApi.md#get_starred_users) | **GET** /containers/{containerId}/starredUsers | Returns list of users who starred a tool.
*ContainersApi* | [**get_test_parameter_files**](docs/ContainersApi.md#get_test_parameter_files) | **GET** /containers/{containerId}/testParameterFiles | Get the corresponding test parameter files.
*ContainersApi* | [**get_tool_by_alias**](docs/ContainersApi.md#get_tool_by_alias) | **GET** /containers/{alias}/aliases | Retrieves a tool by alias.
*ContainersApi* | [**get_tool_zip**](docs/ContainersApi.md#get_tool_zip) | **GET** /containers/{toolId}/zip/{tagId} | Download a ZIP file of a tool and all associated files.
*ContainersApi* | [**get_users**](docs/ContainersApi.md#get_users) | **GET** /containers/{containerId}/users | Get users of a tool.
*ContainersApi* | [**primary_descriptor**](docs/ContainersApi.md#primary_descriptor) | **GET** /containers/{containerId}/primaryDescriptor | Get the primary descriptor file.
*ContainersApi* | [**publish**](docs/ContainersApi.md#publish) | **POST** /containers/{containerId}/publish | Publish or unpublish a tool.
*ContainersApi* | [**refresh**](docs/ContainersApi.md#refresh) | **GET** /containers/{containerId}/refresh | Refresh one particular tool.
*ContainersApi* | [**register_manual**](docs/ContainersApi.md#register_manual) | **POST** /containers/registerManual | Register a tool manually, along with tags.
*ContainersApi* | [**secondary_descriptor_path**](docs/ContainersApi.md#secondary_descriptor_path) | **GET** /containers/{containerId}/descriptor/{relative-path} | Get the corresponding descriptor file.
*ContainersApi* | [**secondary_descriptors**](docs/ContainersApi.md#secondary_descriptors) | **GET** /containers/{containerId}/secondaryDescriptors | Get a list of secondary descriptor files.
*ContainersApi* | [**star_entry**](docs/ContainersApi.md#star_entry) | **PUT** /containers/{containerId}/star | Star a tool.
*ContainersApi* | [**update_container**](docs/ContainersApi.md#update_container) | **PUT** /containers/{containerId} | Update the tool with the given tool.
*ContainersApi* | [**update_labels**](docs/ContainersApi.md#update_labels) | **PUT** /containers/{containerId}/labels | Update the labels linked to a tool.
*ContainersApi* | [**update_tag_container_path**](docs/ContainersApi.md#update_tag_container_path) | **PUT** /containers/{containerId}/updateTagPaths | Change the tool paths.
*ContainersApi* | [**update_tool_default_version**](docs/ContainersApi.md#update_tool_default_version) | **PUT** /containers/{toolId}/defaultVersion | Update the default version of the given tool.
*ContainertagsApi* | [**add_tags**](docs/ContainertagsApi.md#add_tags) | **POST** /containers/{containerId}/tags | Add new tags linked to a tool.
*ContainertagsApi* | [**delete_tags**](docs/ContainertagsApi.md#delete_tags) | **DELETE** /containers/{containerId}/tags/{tagId} | Delete tag linked to a tool.
*ContainertagsApi* | [**get_tags_by_path**](docs/ContainertagsApi.md#get_tags_by_path) | **GET** /containers/path/{containerId}/tags | Get tags for a tool by id.
*ContainertagsApi* | [**request_doi_for_tool_tag**](docs/ContainertagsApi.md#request_doi_for_tool_tag) | **POST** /containers/{containerId}/requestDOI/{tagId} | Request a DOI for this version of a tool.
*ContainertagsApi* | [**update_tags**](docs/ContainertagsApi.md#update_tags) | **PUT** /containers/{containerId}/tags | Update the tags linked to a tool.
*CurationApi* | [**create_notification**](docs/CurationApi.md#create_notification) | **POST** /curation/notifications | Create a notification
*CurationApi* | [**delete_notification**](docs/CurationApi.md#delete_notification) | **DELETE** /curation/notifications/{id} | Delete a notification
*CurationApi* | [**get_active_notifications**](docs/CurationApi.md#get_active_notifications) | **GET** /curation/notifications | Return all active notifications
*CurationApi* | [**get_notification**](docs/CurationApi.md#get_notification) | **GET** /curation/notifications/{id} | Return the notification with given id
*CurationApi* | [**update_notification**](docs/CurationApi.md#update_notification) | **PUT** /curation/notifications/{id} | Update a notification
*EntriesApi* | [**add_aliases**](docs/EntriesApi.md#add_aliases) | **POST** /entries/{id}/aliases | Add aliases linked to a entry in Dockstore.
*EntriesApi* | [**calculate_description_metrics**](docs/EntriesApi.md#calculate_description_metrics) | **GET** /entries/{entryId}/versions/{versionId}/descriptionMetrics | Retrieve metrics on the description of an entry
*EntriesApi* | [**entry_collections**](docs/EntriesApi.md#entry_collections) | **GET** /entries/{id}/collections | Get the collections and organizations that contain the published entry
*EntriesApi* | [**set_discourse_topic**](docs/EntriesApi.md#set_discourse_topic) | **POST** /entries/{id}/topic | Create a discourse topic for an entry.
*EventsApi* | [**get_events**](docs/EventsApi.md#get_events) | **GET** /events | Get events based on filters.
*ExtendedGA4GHApi* | [**entries_org_get**](docs/ExtendedGA4GHApi.md#entries_org_get) | **GET** /api/ga4gh/v2/extended/containers/{organization} | List entries of an organization
*ExtendedGA4GHApi* | [**entries_orgs_get**](docs/ExtendedGA4GHApi.md#entries_orgs_get) | **GET** /api/ga4gh/v2/extended/organizations | List all organizations
*ExtendedGA4GHApi* | [**tools_id_versions_version_id_type_tests_post**](docs/ExtendedGA4GHApi.md#tools_id_versions_version_id_type_tests_post) | **POST** /api/ga4gh/v2/extended/{id}/versions/{version_id}/{type}/tests/{relative_path} | Annotate test JSON with information on whether it ran successfully on particular platforms plus metadata
*ExtendedGA4GHApi* | [**tools_index_get**](docs/ExtendedGA4GHApi.md#tools_index_get) | **POST** /api/ga4gh/v2/extended/tools/index | Update the workflows and tools indices
*ExtendedGA4GHApi* | [**tools_index_search**](docs/ExtendedGA4GHApi.md#tools_index_search) | **POST** /api/ga4gh/v2/extended/tools/entry/_search | Search the tools and workflows indices.
*ExtendedGA4GHApi* | [**tools_org_get**](docs/ExtendedGA4GHApi.md#tools_org_get) | **GET** /api/ga4gh/v2/extended/tools/{organization} | List tools of an organization
*ExtendedGA4GHApi* | [**workflows_org_get**](docs/ExtendedGA4GHApi.md#workflows_org_get) | **GET** /api/ga4gh/v2/extended/workflows/{organization} | List workflows of an organization
*HostedApi* | [**add_zip**](docs/HostedApi.md#add_zip) | **POST** /workflows/hostedEntry/{entryId} | Creates a new revision of a hosted workflow from a zip
*HostedApi* | [**create_hosted_tool**](docs/HostedApi.md#create_hosted_tool) | **POST** /containers/hostedEntry | Create a hosted tool.
*HostedApi* | [**create_hosted_workflow**](docs/HostedApi.md#create_hosted_workflow) | **POST** /workflows/hostedEntry | Create a hosted workflow.
*HostedApi* | [**delete_hosted_tool_version**](docs/HostedApi.md#delete_hosted_tool_version) | **DELETE** /containers/hostedEntry/{entryId} | Delete a revision of a hosted tool.
*HostedApi* | [**delete_hosted_workflow_version**](docs/HostedApi.md#delete_hosted_workflow_version) | **DELETE** /workflows/hostedEntry/{entryId} | Delete a revision of a hosted workflow
*HostedApi* | [**edit_hosted_tool**](docs/HostedApi.md#edit_hosted_tool) | **PATCH** /containers/hostedEntry/{entryId} | Non-idempotent operation for creating new revisions of hosted tools.
*HostedApi* | [**edit_hosted_workflow**](docs/HostedApi.md#edit_hosted_workflow) | **PATCH** /workflows/hostedEntry/{entryId} | Non-idempotent operation for creating new revisions of hosted workflows
*LambdaEventsApi* | [**get_lambda_events_by_organization**](docs/LambdaEventsApi.md#get_lambda_events_by_organization) | **GET** /lambdaEvents/{organization} | See OpenApi for details
*MetadataApi* | [**check_elastic_search**](docs/MetadataApi.md#check_elastic_search) | **GET** /metadata/elasticSearch | Successful response if elastic search is up and running.
*MetadataApi* | [**get_cache_performance**](docs/MetadataApi.md#get_cache_performance) | **GET** /metadata/okHttpCachePerformance | Get measures of cache performance.
*MetadataApi* | [**get_config**](docs/MetadataApi.md#get_config) | **GET** /metadata/config.json | Configuration for UI clients of the API
*MetadataApi* | [**get_descriptor_languages**](docs/MetadataApi.md#get_descriptor_languages) | **GET** /metadata/descriptorLanguageList | Get the list of descriptor languages supported on Dockstore.
*MetadataApi* | [**get_docker_registries**](docs/MetadataApi.md#get_docker_registries) | **GET** /metadata/dockerRegistryList | Get the list of docker registries supported on Dockstore.
*MetadataApi* | [**get_runner_dependencies**](docs/MetadataApi.md#get_runner_dependencies) | **GET** /metadata/runner_dependencies | Returns the file containing runner dependencies.
*MetadataApi* | [**get_source_control_list**](docs/MetadataApi.md#get_source_control_list) | **GET** /metadata/sourceControlList | Get the list of source controls supported on Dockstore.
*MetadataApi* | [**rss_feed**](docs/MetadataApi.md#rss_feed) | **GET** /metadata/rss | List all published tools and workflows in creation order.
*MetadataApi* | [**sitemap**](docs/MetadataApi.md#sitemap) | **GET** /metadata/sitemap | List all available workflow, tool, organization, and collection paths.
*OrganizationsApi* | [**accept_or_reject_invitation**](docs/OrganizationsApi.md#accept_or_reject_invitation) | **POST** /organizations/{organizationId}/invitation | Accept or reject an organization invitation.
*OrganizationsApi* | [**add_collection_aliases**](docs/OrganizationsApi.md#add_collection_aliases) | **POST** /organizations/collections/{collectionId}/aliases | Add aliases linked to a collection in Dockstore.
*OrganizationsApi* | [**add_entry_to_collection**](docs/OrganizationsApi.md#add_entry_to_collection) | **POST** /organizations/{organizationId}/collections/{collectionId}/entry | Add an entry to a collection.
*OrganizationsApi* | [**add_organization_aliases**](docs/OrganizationsApi.md#add_organization_aliases) | **POST** /organizations/{organizationId}/aliases | Add aliases linked to a listing in Dockstore.
*OrganizationsApi* | [**add_user_to_org**](docs/OrganizationsApi.md#add_user_to_org) | **PUT** /organizations/{organizationId}/user | Add a user role to an organization.
*OrganizationsApi* | [**add_user_to_org_by_username**](docs/OrganizationsApi.md#add_user_to_org_by_username) | **PUT** /organizations/{organizationId}/users/{username} | Add a user role to an organization.
*OrganizationsApi* | [**approve_organization**](docs/OrganizationsApi.md#approve_organization) | **POST** /organizations/{organizationId}/approve | Approve an organization.
*OrganizationsApi* | [**create_collection**](docs/OrganizationsApi.md#create_collection) | **POST** /organizations/{organizationId}/collections | Create a collection in the given organization.
*OrganizationsApi* | [**create_organization**](docs/OrganizationsApi.md#create_organization) | **POST** /organizations | Create an organization.
*OrganizationsApi* | [**delete_entry_from_collection**](docs/OrganizationsApi.md#delete_entry_from_collection) | **DELETE** /organizations/{organizationId}/collections/{collectionId}/entry | Delete an entry from a collection.
*OrganizationsApi* | [**delete_user_role**](docs/OrganizationsApi.md#delete_user_role) | **DELETE** /organizations/{organizationId}/user | Remove a user from an organization.
*OrganizationsApi* | [**get_all_organizations**](docs/OrganizationsApi.md#get_all_organizations) | **GET** /organizations/all | List all organizations.
*OrganizationsApi* | [**get_approved_organizations**](docs/OrganizationsApi.md#get_approved_organizations) | **GET** /organizations | List all available organizations.
*OrganizationsApi* | [**get_collection_by_alias**](docs/OrganizationsApi.md#get_collection_by_alias) | **GET** /organizations/collections/{alias}/aliases | Retrieve a collection by alias.
*OrganizationsApi* | [**get_collection_by_id**](docs/OrganizationsApi.md#get_collection_by_id) | **GET** /organizations/{organizationId}/collections/{collectionId} | Retrieve a collection by ID.
*OrganizationsApi* | [**get_collection_by_name**](docs/OrganizationsApi.md#get_collection_by_name) | **GET** /organizations/{organizationName}/collections/{collectionName}/name | Retrieve a collection by name.
*OrganizationsApi* | [**get_collection_description**](docs/OrganizationsApi.md#get_collection_description) | **GET** /organizations/{organizationId}/collections/{collectionId}/description | Retrieve a collection description by organization ID and collection ID.
*OrganizationsApi* | [**get_collections_from_organization**](docs/OrganizationsApi.md#get_collections_from_organization) | **GET** /organizations/{organizationId}/collections | Retrieve all collections for an organization.
*OrganizationsApi* | [**get_organization_by_alias**](docs/OrganizationsApi.md#get_organization_by_alias) | **GET** /organizations/{alias}/aliases | Retrieve an organization by alias.
*OrganizationsApi* | [**get_organization_by_id**](docs/OrganizationsApi.md#get_organization_by_id) | **GET** /organizations/{organizationId} | Retrieve an organization by ID.
*OrganizationsApi* | [**get_organization_by_name**](docs/OrganizationsApi.md#get_organization_by_name) | **GET** /organizations/name/{name} | Retrieve an organization by name.
*OrganizationsApi* | [**get_organization_description**](docs/OrganizationsApi.md#get_organization_description) | **GET** /organizations/{organizationId}/description | Retrieve an organization description by organization ID.
*OrganizationsApi* | [**get_organization_events**](docs/OrganizationsApi.md#get_organization_events) | **GET** /organizations/{organizationId}/events | Retrieve all events for an organization.
*OrganizationsApi* | [**get_organization_members**](docs/OrganizationsApi.md#get_organization_members) | **GET** /organizations/{organizationId}/members | Retrieve all members for an organization.
*OrganizationsApi* | [**get_starred_users_for_approved_organization**](docs/OrganizationsApi.md#get_starred_users_for_approved_organization) | **GET** /organizations/{organizationId}/starredUsers | Return list of users who starred the given approved organization.
*OrganizationsApi* | [**reject_organization**](docs/OrganizationsApi.md#reject_organization) | **POST** /organizations/{organizationId}/reject | Reject an organization.
*OrganizationsApi* | [**request_organization_review**](docs/OrganizationsApi.md#request_organization_review) | **POST** /organizations/{organizationId}/request | Re-request an organization approval.
*OrganizationsApi* | [**star_organization**](docs/OrganizationsApi.md#star_organization) | **PUT** /organizations/{organizationId}/star | Star an organization.
*OrganizationsApi* | [**update_collection**](docs/OrganizationsApi.md#update_collection) | **PUT** /organizations/{organizationId}/collections/{collectionId} | Update a collection.
*OrganizationsApi* | [**update_collection_description**](docs/OrganizationsApi.md#update_collection_description) | **PUT** /organizations/{organizationId}/collections/{collectionId}/description | Update a collection&#39;s description.
*OrganizationsApi* | [**update_organization**](docs/OrganizationsApi.md#update_organization) | **PUT** /organizations/{organizationId} | Update an organization.
*OrganizationsApi* | [**update_organization_description**](docs/OrganizationsApi.md#update_organization_description) | **PUT** /organizations/{organizationId}/description | Update an organization&#39;s description.
*OrganizationsApi* | [**update_user_role**](docs/OrganizationsApi.md#update_user_role) | **POST** /organizations/{organizationId}/user | Update a user role in an organization.
*TokensApi* | [**add_bitbucket_token**](docs/TokensApi.md#add_bitbucket_token) | **GET** /auth/tokens/bitbucket.org | Add a new bitbucket.org token, used by quay.io redirect.
*TokensApi* | [**add_github_token**](docs/TokensApi.md#add_github_token) | **GET** /auth/tokens/github.com | Add a new github.com token, used by accounts page.
*TokensApi* | [**add_gitlab_token**](docs/TokensApi.md#add_gitlab_token) | **GET** /auth/tokens/gitlab.com | Add a new gitlab.com token.
*TokensApi* | [**add_google_token**](docs/TokensApi.md#add_google_token) | **POST** /auth/tokens/google | Allow satellizer to post a new Google token to Dockstore.
*TokensApi* | [**add_orcid_token**](docs/TokensApi.md#add_orcid_token) | **POST** /auth/tokens/orcid.org | Add a new orcid.org token
*TokensApi* | [**add_quay_token**](docs/TokensApi.md#add_quay_token) | **GET** /auth/tokens/quay.io | Add a new Quay.io token.
*TokensApi* | [**add_token**](docs/TokensApi.md#add_token) | **POST** /auth/tokens/github | Allow satellizer to post a new GitHub token to dockstore, used by login, can create new users.
*TokensApi* | [**add_zenodo_token**](docs/TokensApi.md#add_zenodo_token) | **GET** /auth/tokens/zenodo.org | Add a new zenodo.org token, used by accounts page.
*TokensApi* | [**delete_token**](docs/TokensApi.md#delete_token) | **DELETE** /auth/tokens/{tokenId} | Delete a token.
*TokensApi* | [**list_token**](docs/TokensApi.md#list_token) | **GET** /auth/tokens/{tokenId} | Get information about a specific token by id.
*ToolTesterApi* | [**get_tool_tester_log**](docs/ToolTesterApi.md#get_tool_tester_log) | **GET** /toolTester/logs | 
*ToolTesterApi* | [**search**](docs/ToolTesterApi.md#search) | **GET** /toolTester/logs/search | 
*UsersApi* | [**add_user_to_dockstore_workflows**](docs/UsersApi.md#add_user_to_dockstore_workflows) | **PATCH** /users/{userId}/workflows | Adds a user to any Dockstore workflows that they should have access to.
*UsersApi* | [**change_username**](docs/UsersApi.md#change_username) | **POST** /users/user/changeUsername | Change username if possible.
*UsersApi* | [**check_user_exists**](docs/UsersApi.md#check_user_exists) | **GET** /users/checkUser/{username} | Check if user with some username exists.
*UsersApi* | [**get_extended_user_data**](docs/UsersApi.md#get_extended_user_data) | **GET** /users/user/extended | Get additional information about the authenticated user.
*UsersApi* | [**get_my_git_hub_orgs**](docs/UsersApi.md#get_my_git_hub_orgs) | **GET** /users/github/organizations | 
*UsersApi* | [**get_specific_user**](docs/UsersApi.md#get_specific_user) | **GET** /users/{userId} | Get user by id.
*UsersApi* | [**get_starred_organizations**](docs/UsersApi.md#get_starred_organizations) | **GET** /users/starredOrganizations | Get the authenticated user&#39;s starred organizations.
*UsersApi* | [**get_starred_services**](docs/UsersApi.md#get_starred_services) | **GET** /users/starredServices | Get the authenticated user&#39;s starred services.
*UsersApi* | [**get_starred_tools**](docs/UsersApi.md#get_starred_tools) | **GET** /users/starredTools | Get the authenticated user&#39;s starred tools.
*UsersApi* | [**get_starred_workflows**](docs/UsersApi.md#get_starred_workflows) | **GET** /users/starredWorkflows | Get the authenticated user&#39;s starred workflows.
*UsersApi* | [**get_user**](docs/UsersApi.md#get_user) | **GET** /users/user | Get the logged-in user.
*UsersApi* | [**get_user_dockstore_organizations**](docs/UsersApi.md#get_user_dockstore_organizations) | **GET** /users/users/organizations | See OpenApi for details
*UsersApi* | [**get_user_entries**](docs/UsersApi.md#get_user_entries) | **GET** /users/users/entries | See OpenApi for details
*UsersApi* | [**get_user_git_hub_events**](docs/UsersApi.md#get_user_git_hub_events) | **GET** /users/github/events | See OpenApi for details
*UsersApi* | [**get_user_limits**](docs/UsersApi.md#get_user_limits) | **GET** /users/user/{userId}/limits | Returns the specified user&#39;s limits. ADMIN or CURATOR only
*UsersApi* | [**get_user_memberships**](docs/UsersApi.md#get_user_memberships) | **GET** /users/user/memberships | Get the logged-in user&#39;s memberships.
*UsersApi* | [**get_user_organization_repositories**](docs/UsersApi.md#get_user_organization_repositories) | **GET** /users/registries/{gitRegistry}/organizations/{organization} | See OpenApi for details
*UsersApi* | [**get_user_organizations**](docs/UsersApi.md#get_user_organizations) | **GET** /users/registries/{gitRegistry}/organizations | See OpenApi for details
*UsersApi* | [**get_user_registries**](docs/UsersApi.md#get_user_registries) | **GET** /users/registries | See OpenApi for details
*UsersApi* | [**get_user_tokens**](docs/UsersApi.md#get_user_tokens) | **GET** /users/{userId}/tokens | Get information about tokens with user id.
*UsersApi* | [**list_user**](docs/UsersApi.md#list_user) | **GET** /users/username/{username} | Get a user by username.
*UsersApi* | [**refresh_tools_by_organization**](docs/UsersApi.md#refresh_tools_by_organization) | **GET** /users/{userId}/containers/{organization}/refresh | Refresh all tools owned by the authenticated user with specified organization.
*UsersApi* | [**self_destruct**](docs/UsersApi.md#self_destruct) | **DELETE** /users/user | Delete user if possible.
*UsersApi* | [**set_user_limits**](docs/UsersApi.md#set_user_limits) | **PUT** /users/user/{userId}/limits | Update the specified user&#39;s limits. ADMIN or CURATOR only
*UsersApi* | [**sync_user_with_git_hub**](docs/UsersApi.md#sync_user_with_git_hub) | **POST** /users/github/sync | Syncs Dockstore account with GitHub App Installations.
*UsersApi* | [**terminate_user**](docs/UsersApi.md#terminate_user) | **DELETE** /users/user/{userId} | Terminate user if possible.
*UsersApi* | [**update_logged_in_user_metadata**](docs/UsersApi.md#update_logged_in_user_metadata) | **GET** /users/user/updateUserMetadata | Update metadata for logged in user.
*UsersApi* | [**update_user_metadata**](docs/UsersApi.md#update_user_metadata) | **GET** /users/updateUserMetadata | Update metadata of all users.
*UsersApi* | [**user_containers**](docs/UsersApi.md#user_containers) | **GET** /users/{userId}/containers | List all tools owned by the authenticated user.
*UsersApi* | [**user_published_containers**](docs/UsersApi.md#user_published_containers) | **GET** /users/{userId}/containers/published | List all published tools from a user.
*UsersApi* | [**user_published_workflows**](docs/UsersApi.md#user_published_workflows) | **GET** /users/{userId}/workflows/published | List all published workflows from a user.
*UsersApi* | [**user_services**](docs/UsersApi.md#user_services) | **GET** /users/{userId}/services | List all services owned by the authenticated user.
*UsersApi* | [**user_workflows**](docs/UsersApi.md#user_workflows) | **GET** /users/{userId}/workflows | List all workflows owned by the authenticated user.
*WorkflowsApi* | [**add_test_parameter_files**](docs/WorkflowsApi.md#add_test_parameter_files) | **PUT** /workflows/{workflowId}/testParameterFiles | Add test parameter files for a given version.
*WorkflowsApi* | [**add_workflow**](docs/WorkflowsApi.md#add_workflow) | **POST** /workflows/registries/{gitRegistry}/organizations/{organization}/repositories/{repositoryName} | See OpenApi for details
*WorkflowsApi* | [**add_workflow_permission**](docs/WorkflowsApi.md#add_workflow_permission) | **PATCH** /workflows/path/workflow/{repository}/permissions | Set the specified permission for a user on a workflow.
*WorkflowsApi* | [**all_published_workflows**](docs/WorkflowsApi.md#all_published_workflows) | **GET** /workflows/published | List all published workflows.
*WorkflowsApi* | [**delete_test_parameter_files**](docs/WorkflowsApi.md#delete_test_parameter_files) | **DELETE** /workflows/{workflowId}/testParameterFiles | Delete test parameter files for a given version.
*WorkflowsApi* | [**delete_workflow**](docs/WorkflowsApi.md#delete_workflow) | **DELETE** /workflows/registries/{gitRegistry}/organizations/{organization}/repositories/{repositoryName} | See OpenApi for details
*WorkflowsApi* | [**get_all_workflow_by_path**](docs/WorkflowsApi.md#get_all_workflow_by_path) | **GET** /workflows/path/{repository} | Get a list of workflows by path.
*WorkflowsApi* | [**get_entry_by_path**](docs/WorkflowsApi.md#get_entry_by_path) | **GET** /workflows/path/entry/{repository} | Get an entry by path.
*WorkflowsApi* | [**get_published_entry_by_path**](docs/WorkflowsApi.md#get_published_entry_by_path) | **GET** /workflows/path/entry/{repository}/published | Get a published entry by path.
*WorkflowsApi* | [**get_published_workflow**](docs/WorkflowsApi.md#get_published_workflow) | **GET** /workflows/published/{workflowId} | Get a published workflow.
*WorkflowsApi* | [**get_published_workflow_by_path**](docs/WorkflowsApi.md#get_published_workflow_by_path) | **GET** /workflows/path/workflow/{repository}/published | Get a published workflow by path
*WorkflowsApi* | [**get_published_workflows_by_organization**](docs/WorkflowsApi.md#get_published_workflows_by_organization) | **GET** /workflows/organization/{organization}/published | List all published workflows of an organization.
*WorkflowsApi* | [**get_starred_users**](docs/WorkflowsApi.md#get_starred_users) | **GET** /workflows/{workflowId}/starredUsers | Returns list of users who starred the given workflow.
*WorkflowsApi* | [**get_table_tool_content**](docs/WorkflowsApi.md#get_table_tool_content) | **GET** /workflows/{workflowId}/tools/{workflowVersionId} | Get the Tools for a given workflow version.
*WorkflowsApi* | [**get_test_parameter_files**](docs/WorkflowsApi.md#get_test_parameter_files) | **GET** /workflows/{workflowId}/testParameterFiles | Get the corresponding test parameter files.
*WorkflowsApi* | [**get_users**](docs/WorkflowsApi.md#get_users) | **GET** /workflows/{workflowId}/users | Get users of a workflow.
*WorkflowsApi* | [**get_workflow**](docs/WorkflowsApi.md#get_workflow) | **GET** /workflows/{workflowId} | Retrieve a workflow
*WorkflowsApi* | [**get_workflow_actions**](docs/WorkflowsApi.md#get_workflow_actions) | **GET** /workflows/path/workflow/{repository}/actions | Gets all actions a user can perform on a workflow.
*WorkflowsApi* | [**get_workflow_by_alias**](docs/WorkflowsApi.md#get_workflow_by_alias) | **GET** /workflows/{alias}/aliases | Retrieves a workflow by alias.
*WorkflowsApi* | [**get_workflow_by_path**](docs/WorkflowsApi.md#get_workflow_by_path) | **GET** /workflows/path/workflow/{repository} | Get a workflow by path.
*WorkflowsApi* | [**get_workflow_dag**](docs/WorkflowsApi.md#get_workflow_dag) | **GET** /workflows/{workflowId}/dag/{workflowVersionId} | Get the DAG for a given workflow version.
*WorkflowsApi* | [**get_workflow_permissions**](docs/WorkflowsApi.md#get_workflow_permissions) | **GET** /workflows/path/workflow/{repository}/permissions | Get all permissions for a workflow.
*WorkflowsApi* | [**get_workflow_versions**](docs/WorkflowsApi.md#get_workflow_versions) | **GET** /workflows/{workflowId}/workflowVersions | Return first 200 versions in an entry
*WorkflowsApi* | [**get_workflow_zip**](docs/WorkflowsApi.md#get_workflow_zip) | **GET** /workflows/{workflowId}/zip/{workflowVersionId} | Download a ZIP file of a workflow and all associated files.
*WorkflowsApi* | [**handle_git_hub_branch_deletion**](docs/WorkflowsApi.md#handle_git_hub_branch_deletion) | **DELETE** /workflows/github | Handles the deletion of a branch on GitHub. Will delete all workflow versions that match in all workflows that share the same repository.
*WorkflowsApi* | [**handle_git_hub_installation**](docs/WorkflowsApi.md#handle_git_hub_installation) | **POST** /workflows/github/install | Handle the installation of our GitHub app onto a repository or organization.
*WorkflowsApi* | [**handle_git_hub_release**](docs/WorkflowsApi.md#handle_git_hub_release) | **POST** /workflows/github/release | Handle a release of a repository on GitHub. Will create a workflow/service and version when necessary.
*WorkflowsApi* | [**manual_register**](docs/WorkflowsApi.md#manual_register) | **POST** /workflows/manualRegister | Manually register a workflow.
*WorkflowsApi* | [**primary_descriptor**](docs/WorkflowsApi.md#primary_descriptor) | **GET** /workflows/{workflowId}/primaryDescriptor | Get the primary descriptor file.
*WorkflowsApi* | [**publish**](docs/WorkflowsApi.md#publish) | **POST** /workflows/{workflowId}/publish | Publish or unpublish a workflow.
*WorkflowsApi* | [**refresh**](docs/WorkflowsApi.md#refresh) | **GET** /workflows/{workflowId}/refresh | Refresh one particular workflow.
*WorkflowsApi* | [**refresh_version**](docs/WorkflowsApi.md#refresh_version) | **GET** /workflows/{workflowId}/refresh/{version} | Refresh one particular workflow version.
*WorkflowsApi* | [**register_checker_workflow**](docs/WorkflowsApi.md#register_checker_workflow) | **POST** /workflows/{entryId}/registerCheckerWorkflow/{descriptorType} | Register a checker workflow and associates it with the given tool/workflow.
*WorkflowsApi* | [**remove_workflow_role**](docs/WorkflowsApi.md#remove_workflow_role) | **DELETE** /workflows/path/workflow/{repository}/permissions | Remove the specified user role for a workflow.
*WorkflowsApi* | [**request_doi_for_workflow_version**](docs/WorkflowsApi.md#request_doi_for_workflow_version) | **PUT** /workflows/{workflowId}/requestDOI/{workflowVersionId} | Request a DOI for this version of a workflow.
*WorkflowsApi* | [**restub**](docs/WorkflowsApi.md#restub) | **GET** /workflows/{workflowId}/restub | Restub a workflow
*WorkflowsApi* | [**secondary_descriptor_path**](docs/WorkflowsApi.md#secondary_descriptor_path) | **GET** /workflows/{workflowId}/descriptor/{relative-path} | Get the corresponding descriptor file from source control.
*WorkflowsApi* | [**secondary_descriptors**](docs/WorkflowsApi.md#secondary_descriptors) | **GET** /workflows/{workflowId}/secondaryDescriptors | Get the corresponding descriptor documents from source control.
*WorkflowsApi* | [**shared_workflows**](docs/WorkflowsApi.md#shared_workflows) | **GET** /workflows/shared | Retrieve all workflows shared with user.
*WorkflowsApi* | [**star_entry**](docs/WorkflowsApi.md#star_entry) | **PUT** /workflows/{workflowId}/star | Star a workflow.
*WorkflowsApi* | [**update_labels**](docs/WorkflowsApi.md#update_labels) | **PUT** /workflows/{workflowId}/labels | Update the labels linked to a workflow.
*WorkflowsApi* | [**update_workflow**](docs/WorkflowsApi.md#update_workflow) | **PUT** /workflows/{workflowId} | Update the workflow with the given workflow.
*WorkflowsApi* | [**update_workflow_default_version**](docs/WorkflowsApi.md#update_workflow_default_version) | **PUT** /workflows/{workflowId}/defaultVersion | Update the default version of a workflow.
*WorkflowsApi* | [**update_workflow_path**](docs/WorkflowsApi.md#update_workflow_path) | **PUT** /workflows/{workflowId}/resetVersionPaths | Reset the workflow paths.
*WorkflowsApi* | [**update_workflow_version**](docs/WorkflowsApi.md#update_workflow_version) | **PUT** /workflows/{workflowId}/workflowVersions | Update the workflow versions linked to a workflow.


## Documentation For Models

 - [Alias](docs/Alias.md)
 - [AppTool](docs/AppTool.md)
 - [Author](docs/Author.md)
 - [BioWorkflow](docs/BioWorkflow.md)
 - [Checksum](docs/Checksum.md)
 - [Collection](docs/Collection.md)
 - [CollectionEntry](docs/CollectionEntry.md)
 - [CollectionOrganization](docs/CollectionOrganization.md)
 - [Config](docs/Config.md)
 - [DescriptionMetrics](docs/DescriptionMetrics.md)
 - [DescriptorLanguageBean](docs/DescriptorLanguageBean.md)
 - [DockstoreTool](docs/DockstoreTool.md)
 - [Entry](docs/Entry.md)
 - [EntryUpdateTime](docs/EntryUpdateTime.md)
 - [Error](docs/Error.md)
 - [Event](docs/Event.md)
 - [ExtendedUserData](docs/ExtendedUserData.md)
 - [FileFormat](docs/FileFormat.md)
 - [FileWrapper](docs/FileWrapper.md)
 - [Image](docs/Image.md)
 - [Label](docs/Label.md)
 - [LambdaEvent](docs/LambdaEvent.md)
 - [LicenseInformation](docs/LicenseInformation.md)
 - [Limits](docs/Limits.md)
 - [Metadata](docs/Metadata.md)
 - [MetadataV1](docs/MetadataV1.md)
 - [Notification](docs/Notification.md)
 - [Optional](docs/Optional.md)
 - [OptionalUser](docs/OptionalUser.md)
 - [OrcidAuthor](docs/OrcidAuthor.md)
 - [Organization](docs/Organization.md)
 - [OrganizationUpdateTime](docs/OrganizationUpdateTime.md)
 - [OrganizationUser](docs/OrganizationUser.md)
 - [OrganizationUserId](docs/OrganizationUserId.md)
 - [ParsedInformation](docs/ParsedInformation.md)
 - [Permission](docs/Permission.md)
 - [Profile](docs/Profile.md)
 - [PublishRequest](docs/PublishRequest.md)
 - [RegistryBean](docs/RegistryBean.md)
 - [Repository](docs/Repository.md)
 - [Service](docs/Service.md)
 - [SharedWorkflows](docs/SharedWorkflows.md)
 - [SourceControlBean](docs/SourceControlBean.md)
 - [SourceControlOrganization](docs/SourceControlOrganization.md)
 - [SourceFile](docs/SourceFile.md)
 - [StarRequest](docs/StarRequest.md)
 - [Tag](docs/Tag.md)
 - [TokenAuth](docs/TokenAuth.md)
 - [TokenUser](docs/TokenUser.md)
 - [Tool](docs/Tool.md)
 - [ToolClass](docs/ToolClass.md)
 - [ToolDescriptor](docs/ToolDescriptor.md)
 - [ToolDockerfile](docs/ToolDockerfile.md)
 - [ToolFile](docs/ToolFile.md)
 - [ToolTesterLog](docs/ToolTesterLog.md)
 - [ToolTestsV1](docs/ToolTestsV1.md)
 - [ToolV1](docs/ToolV1.md)
 - [ToolVersion](docs/ToolVersion.md)
 - [ToolVersionV1](docs/ToolVersionV1.md)
 - [User](docs/User.md)
 - [Validation](docs/Validation.md)
 - [VerificationInformation](docs/VerificationInformation.md)
 - [Version](docs/Version.md)
 - [VersionMetadata](docs/VersionMetadata.md)
 - [Workflow](docs/Workflow.md)
 - [WorkflowVersion](docs/WorkflowVersion.md)
 - [WorkflowVersionPathInfo](docs/WorkflowVersionPathInfo.md)


## Documentation For Authorization


## BEARER

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author

theglobalalliance@genomicsandhealth.org

