
<img align="left" src="https://raw.githubusercontent.com/claudioperez/sdof/master/docs/assets/peer-black-300.png" width="150px" alt="PEER Logo">

Nonlinear finite element analysis.

<br>

<div style="align:center">

[![Latest PyPI version](https://img.shields.io/pypi/v/xara?logo=pypi)](https://pypi.python.org/pypi/xara)
[![](https://img.shields.io/conda/v/opensees/opensees?color=%23660505)](https://anaconda.org/opensees/opensees)
[![PyPI Downloads](https://img.shields.io/pypi/dm/opensees)](https://pypi.org/project/opensees)

</div>

*xara* is a Python package that provides an intuitive and performant API for nonlinear
finite element analysis, implemented in C++ through the OpenSeesRT framework. 
OpenSees features state-of-the-art finite element formulations and solution 
algorithms, including mixed formulations for beams and solids, over 200 material models, and an
extensive collection of continuation algorithms to solve highly nonlinear
problems. 


This package may be used as a drop-in replacement for both `OpenSees.exe` and
OpenSeesPy (see *Getting Started* below), and generally provides a substantial performance boost.

<p style="text-align: center;">
<b>This package is <i>experimental</i> and not yet intended for public use.</b>
</p>


> [!NOTE]
> This package is independent of the [`openseespy`](https://pypi.org/project/openseespy)
> library, which is documented in the OpenSees [documentation](https://opensees.github.io/OpenSeesDocumentation)
> website. 


### Getting Started

The `xara` package can be installed into a Python environment
in the standard manner. For example, using `pip`:

```shell
pip install xara
```

There are several ways to use the `xara` package:

- To execute Tcl procedures from a Python script, just create an instance
  of the `xara.Model` class and call its `eval()` method:
  ```python
  model = xara.Model()
  model.eval("model Basic -ndm 2")
  model.eval("print -json")
  ```

- To start an interactive interpreter run the shell command:

  ```bash
  python -m opensees
  ```
  To quit the interpreter, just run `exit`:
  ```tcl
  opensees > exit
  ```

- The `xara` package exposes a compatibility layer that exactly reproduces
  the *OpenSeesPy* functions, but does so without mandating a single
  global program state. To run OpenSeesPy scripts, just change the import:

  ```python
  import openseespy.opensees
  ```
  to
  ```python
  import opensees.openseespy
  ```
  For true stateless modeling, the `Model` class should be used instead of the legacy
  `model` function; see the documentation [here](https://xara.so/user/manual/model/model_class.html).


## Development

To compile the project see [about/compiling](https://github.com/claudioperez/OpenSeesRT/blob/main/about/compiling.md)


## Support

<table align="center" style="border: 0;">
<tr>
  <td>
    <a href="https://peer.berkeley.edu">
    <img src="https://raw.githubusercontent.com/claudioperez/sdof/master/docs/assets/peer-black-300.png"
         alt="PEER Logo" width="200"/>
    </a>
  </td>

  <td>
    <a href="https://dot.ca.gov/">
    <img src="https://raw.githubusercontent.com/claudioperez/sdof/master/docs/assets/Caltrans.svg.png"
         alt="Caltrans Logo" width="200"/>
    </a>
  </td>

 </tr>
</table>

```stl
solid 
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 155.4429931640625 -12.314200401306152 -17.899999618530273
        vertex 155.64300537109375 -12.314200401306152 -17.899999618530273
        vertex 155.4429931640625 -12.1141996383667 -17.899999618530273
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 155.64300537109375 -12.1141996383667 -17.899999618530273
        vertex 155.4429931640625 -12.1141996383667 -17.899999618530273
        vertex 155.64300537109375 -12.314200401306152 -17.899999618530273
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 155.64300537109375 -12.314200401306152 -17.899999618530273
        vertex 155.4429931640625 -12.314200401306152 -17.899999618530273
        vertex 155.64300537109375 -12.314200401306152 -18.100000381469727
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 155.4429931640625 -12.314200401306152 -18.100000381469727
        vertex 155.64300537109375 -12.314200401306152 -18.100000381469727
        vertex 155.4429931640625 -12.314200401306152 -17.899999618530273
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 155.64300537109375 -12.1141996383667 -17.899999618530273
        vertex 155.64300537109375 -12.314200401306152 -17.899999618530273
        vertex 155.64300537109375 -12.1141996383667 -18.100000381469727
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 155.64300537109375 -12.314200401306152 -18.100000381469727
        vertex 155.64300537109375 -12.1141996383667 -18.100000381469727
        vertex 155.64300537109375 -12.314200401306152 -17.899999618530273
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 155.4429931640625 -12.1141996383667 -17.899999618530273
        vertex 155.64300537109375 -12.1141996383667 -17.899999618530273
        vertex 155.4429931640625 -12.1141996383667 -18.100000381469727
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 155.64300537109375 -12.1141996383667 -18.100000381469727
        vertex 155.4429931640625 -12.1141996383667 -18.100000381469727
        vertex 155.64300537109375 -12.1141996383667 -17.899999618530273
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 155.4429931640625 -12.314200401306152 -17.899999618530273
        vertex 155.4429931640625 -12.1141996383667 -17.899999618530273
        vertex 155.4429931640625 -12.314200401306152 -18.100000381469727
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 155.4429931640625 -12.1141996383667 -18.100000381469727
        vertex 155.4429931640625 -12.314200401306152 -18.100000381469727
        vertex 155.4429931640625 -12.1141996383667 -17.899999618530273
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 155.4429931640625 -12.314200401306152 -18.100000381469727
        vertex 155.4429931640625 -12.1141996383667 -18.100000381469727
        vertex 155.64300537109375 -12.314200401306152 -18.100000381469727
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 155.64300537109375 -12.1141996383667 -18.100000381469727
        vertex 155.64300537109375 -12.314200401306152 -18.100000381469727
        vertex 155.4429931640625 -12.1141996383667 -18.100000381469727
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 136.35699462890625 12.1141996383667 -17.899999618530273
        vertex 136.5570068359375 12.1141996383667 -17.899999618530273
        vertex 136.35699462890625 12.314200401306152 -17.899999618530273
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 136.5570068359375 12.314200401306152 -17.899999618530273
        vertex 136.35699462890625 12.314200401306152 -17.899999618530273
        vertex 136.5570068359375 12.1141996383667 -17.899999618530273
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 136.5570068359375 12.1141996383667 -17.899999618530273
        vertex 136.35699462890625 12.1141996383667 -17.899999618530273
        vertex 136.5570068359375 12.1141996383667 -18.100000381469727
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 136.35699462890625 12.1141996383667 -18.100000381469727
        vertex 136.5570068359375 12.1141996383667 -18.100000381469727
        vertex 136.35699462890625 12.1141996383667 -17.899999618530273
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 136.5570068359375 12.314200401306152 -17.899999618530273
        vertex 136.5570068359375 12.1141996383667 -17.899999618530273
        vertex 136.5570068359375 12.314200401306152 -18.100000381469727
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 136.5570068359375 12.1141996383667 -18.100000381469727
        vertex 136.5570068359375 12.314200401306152 -18.100000381469727
        vertex 136.5570068359375 12.1141996383667 -17.899999618530273
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 136.35699462890625 12.314200401306152 -17.899999618530273
        vertex 136.5570068359375 12.314200401306152 -17.899999618530273
        vertex 136.35699462890625 12.314200401306152 -18.100000381469727
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 136.5570068359375 12.314200401306152 -18.100000381469727
        vertex 136.35699462890625 12.314200401306152 -18.100000381469727
        vertex 136.5570068359375 12.314200401306152 -17.899999618530273
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 136.35699462890625 12.1141996383667 -17.899999618530273
        vertex 136.35699462890625 12.314200401306152 -17.899999618530273
        vertex 136.35699462890625 12.1141996383667 -18.100000381469727
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 136.35699462890625 12.314200401306152 -18.100000381469727
        vertex 136.35699462890625 12.1141996383667 -18.100000381469727
        vertex 136.35699462890625 12.314200401306152 -17.899999618530273
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 136.35699462890625 12.1141996383667 -18.100000381469727
        vertex 136.35699462890625 12.314200401306152 -18.100000381469727
        vertex 136.5570068359375 12.1141996383667 -18.100000381469727
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 136.5570068359375 12.314200401306152 -18.100000381469727
        vertex 136.5570068359375 12.1141996383667 -18.100000381469727
        vertex 136.35699462890625 12.314200401306152 -18.100000381469727
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 280.9590148925781 -20.65399932861328 -5.337850093841553
        vertex 281.15899658203125 -20.65399932861328 -5.337850093841553
        vertex 280.9590148925781 -20.45400047302246 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 281.15899658203125 -20.45400047302246 -5.337850093841553
        vertex 280.9590148925781 -20.45400047302246 -5.337850093841553
        vertex 281.15899658203125 -20.65399932861328 -5.337850093841553
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 281.15899658203125 -20.65399932861328 -5.337850093841553
        vertex 280.9590148925781 -20.65399932861328 -5.337850093841553
        vertex 281.15899658203125 -20.65399932861328 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 280.9590148925781 -20.65399932861328 -5.5378499031066895
        vertex 281.15899658203125 -20.65399932861328 -5.5378499031066895
        vertex 280.9590148925781 -20.65399932861328 -5.337850093841553
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 281.15899658203125 -20.45400047302246 -5.337850093841553
        vertex 281.15899658203125 -20.65399932861328 -5.337850093841553
        vertex 281.15899658203125 -20.45400047302246 -5.5378499031066895
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 281.15899658203125 -20.65399932861328 -5.5378499031066895
        vertex 281.15899658203125 -20.45400047302246 -5.5378499031066895
        vertex 281.15899658203125 -20.65399932861328 -5.337850093841553
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 280.9590148925781 -20.45400047302246 -5.337850093841553
        vertex 281.15899658203125 -20.45400047302246 -5.337850093841553
        vertex 280.9590148925781 -20.45400047302246 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 281.15899658203125 -20.45400047302246 -5.5378499031066895
        vertex 280.9590148925781 -20.45400047302246 -5.5378499031066895
        vertex 281.15899658203125 -20.45400047302246 -5.337850093841553
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 280.9590148925781 -20.65399932861328 -5.337850093841553
        vertex 280.9590148925781 -20.45400047302246 -5.337850093841553
        vertex 280.9590148925781 -20.65399932861328 -5.5378499031066895
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 280.9590148925781 -20.45400047302246 -5.5378499031066895
        vertex 280.9590148925781 -20.65399932861328 -5.5378499031066895
        vertex 280.9590148925781 -20.45400047302246 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 280.9590148925781 -20.65399932861328 -5.5378499031066895
        vertex 280.9590148925781 -20.45400047302246 -5.5378499031066895
        vertex 281.15899658203125 -20.65399932861328 -5.5378499031066895
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 281.15899658203125 -20.45400047302246 -5.5378499031066895
        vertex 281.15899658203125 -20.65399932861328 -5.5378499031066895
        vertex 280.9590148925781 -20.45400047302246 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 276.8800048828125 -15.433300018310547 -5.337850093841553
        vertex 277.0799865722656 -15.433300018310547 -5.337850093841553
        vertex 276.8800048828125 -15.23330020904541 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 277.0799865722656 -15.23330020904541 -5.337850093841553
        vertex 276.8800048828125 -15.23330020904541 -5.337850093841553
        vertex 277.0799865722656 -15.433300018310547 -5.337850093841553
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 277.0799865722656 -15.433300018310547 -5.337850093841553
        vertex 276.8800048828125 -15.433300018310547 -5.337850093841553
        vertex 277.0799865722656 -15.433300018310547 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 276.8800048828125 -15.433300018310547 -5.5378499031066895
        vertex 277.0799865722656 -15.433300018310547 -5.5378499031066895
        vertex 276.8800048828125 -15.433300018310547 -5.337850093841553
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 277.0799865722656 -15.23330020904541 -5.337850093841553
        vertex 277.0799865722656 -15.433300018310547 -5.337850093841553
        vertex 277.0799865722656 -15.23330020904541 -5.5378499031066895
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 277.0799865722656 -15.433300018310547 -5.5378499031066895
        vertex 277.0799865722656 -15.23330020904541 -5.5378499031066895
        vertex 277.0799865722656 -15.433300018310547 -5.337850093841553
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 276.8800048828125 -15.23330020904541 -5.337850093841553
        vertex 277.0799865722656 -15.23330020904541 -5.337850093841553
        vertex 276.8800048828125 -15.23330020904541 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 277.0799865722656 -15.23330020904541 -5.5378499031066895
        vertex 276.8800048828125 -15.23330020904541 -5.5378499031066895
        vertex 277.0799865722656 -15.23330020904541 -5.337850093841553
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 276.8800048828125 -15.433300018310547 -5.337850093841553
        vertex 276.8800048828125 -15.23330020904541 -5.337850093841553
        vertex 276.8800048828125 -15.433300018310547 -5.5378499031066895
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 276.8800048828125 -15.23330020904541 -5.5378499031066895
        vertex 276.8800048828125 -15.433300018310547 -5.5378499031066895
        vertex 276.8800048828125 -15.23330020904541 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 276.8800048828125 -15.433300018310547 -5.5378499031066895
        vertex 276.8800048828125 -15.23330020904541 -5.5378499031066895
        vertex 277.0799865722656 -15.433300018310547 -5.5378499031066895
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 277.0799865722656 -15.23330020904541 -5.5378499031066895
        vertex 277.0799865722656 -15.433300018310547 -5.5378499031066895
        vertex 276.8800048828125 -15.23330020904541 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 270.8900146484375 -7.766670227050781 -5.337850093841553
        vertex 271.0899963378906 -7.766670227050781 -5.337850093841553
        vertex 270.8900146484375 -7.566669940948486 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 271.0899963378906 -7.566669940948486 -5.337850093841553
        vertex 270.8900146484375 -7.566669940948486 -5.337850093841553
        vertex 271.0899963378906 -7.766670227050781 -5.337850093841553
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 271.0899963378906 -7.766670227050781 -5.337850093841553
        vertex 270.8900146484375 -7.766670227050781 -5.337850093841553
        vertex 271.0899963378906 -7.766670227050781 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 270.8900146484375 -7.766670227050781 -5.5378499031066895
        vertex 271.0899963378906 -7.766670227050781 -5.5378499031066895
        vertex 270.8900146484375 -7.766670227050781 -5.337850093841553
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 271.0899963378906 -7.566669940948486 -5.337850093841553
        vertex 271.0899963378906 -7.766670227050781 -5.337850093841553
        vertex 271.0899963378906 -7.566669940948486 -5.5378499031066895
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 271.0899963378906 -7.766670227050781 -5.5378499031066895
        vertex 271.0899963378906 -7.566669940948486 -5.5378499031066895
        vertex 271.0899963378906 -7.766670227050781 -5.337850093841553
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 270.8900146484375 -7.566669940948486 -5.337850093841553
        vertex 271.0899963378906 -7.566669940948486 -5.337850093841553
        vertex 270.8900146484375 -7.566669940948486 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 271.0899963378906 -7.566669940948486 -5.5378499031066895
        vertex 270.8900146484375 -7.566669940948486 -5.5378499031066895
        vertex 271.0899963378906 -7.566669940948486 -5.337850093841553
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 270.8900146484375 -7.766670227050781 -5.337850093841553
        vertex 270.8900146484375 -7.566669940948486 -5.337850093841553
        vertex 270.8900146484375 -7.766670227050781 -5.5378499031066895
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 270.8900146484375 -7.566669940948486 -5.5378499031066895
        vertex 270.8900146484375 -7.766670227050781 -5.5378499031066895
        vertex 270.8900146484375 -7.566669940948486 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 270.8900146484375 -7.766670227050781 -5.5378499031066895
        vertex 270.8900146484375 -7.566669940948486 -5.5378499031066895
        vertex 271.0899963378906 -7.766670227050781 -5.5378499031066895
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 271.0899963378906 -7.566669940948486 -5.5378499031066895
        vertex 271.0899963378906 -7.766670227050781 -5.5378499031066895
        vertex 270.8900146484375 -7.566669940948486 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 264.8999938964844 -0.10000000149011612 -5.337850093841553
        vertex 265.1000061035156 -0.10000000149011612 -5.337850093841553
        vertex 264.8999938964844 0.10000000149011612 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 265.1000061035156 0.10000000149011612 -5.337850093841553
        vertex 264.8999938964844 0.10000000149011612 -5.337850093841553
        vertex 265.1000061035156 -0.10000000149011612 -5.337850093841553
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 265.1000061035156 -0.10000000149011612 -5.337850093841553
        vertex 264.8999938964844 -0.10000000149011612 -5.337850093841553
        vertex 265.1000061035156 -0.10000000149011612 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 264.8999938964844 -0.10000000149011612 -5.5378499031066895
        vertex 265.1000061035156 -0.10000000149011612 -5.5378499031066895
        vertex 264.8999938964844 -0.10000000149011612 -5.337850093841553
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 265.1000061035156 0.10000000149011612 -5.337850093841553
        vertex 265.1000061035156 -0.10000000149011612 -5.337850093841553
        vertex 265.1000061035156 0.10000000149011612 -5.5378499031066895
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 265.1000061035156 -0.10000000149011612 -5.5378499031066895
        vertex 265.1000061035156 0.10000000149011612 -5.5378499031066895
        vertex 265.1000061035156 -0.10000000149011612 -5.337850093841553
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 264.8999938964844 0.10000000149011612 -5.337850093841553
        vertex 265.1000061035156 0.10000000149011612 -5.337850093841553
        vertex 264.8999938964844 0.10000000149011612 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 265.1000061035156 0.10000000149011612 -5.5378499031066895
        vertex 264.8999938964844 0.10000000149011612 -5.5378499031066895
        vertex 265.1000061035156 0.10000000149011612 -5.337850093841553
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 264.8999938964844 -0.10000000149011612 -5.337850093841553
        vertex 264.8999938964844 0.10000000149011612 -5.337850093841553
        vertex 264.8999938964844 -0.10000000149011612 -5.5378499031066895
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 264.8999938964844 0.10000000149011612 -5.5378499031066895
        vertex 264.8999938964844 -0.10000000149011612 -5.5378499031066895
        vertex 264.8999938964844 0.10000000149011612 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 264.8999938964844 -0.10000000149011612 -5.5378499031066895
        vertex 264.8999938964844 0.10000000149011612 -5.5378499031066895
        vertex 265.1000061035156 -0.10000000149011612 -5.5378499031066895
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 265.1000061035156 0.10000000149011612 -5.5378499031066895
        vertex 265.1000061035156 -0.10000000149011612 -5.5378499031066895
        vertex 264.8999938964844 0.10000000149011612 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 258.9100036621094 7.566669940948486 -5.337850093841553
        vertex 259.1099853515625 7.566669940948486 -5.337850093841553
        vertex 258.9100036621094 7.766670227050781 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 259.1099853515625 7.766670227050781 -5.337850093841553
        vertex 258.9100036621094 7.766670227050781 -5.337850093841553
        vertex 259.1099853515625 7.566669940948486 -5.337850093841553
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 259.1099853515625 7.566669940948486 -5.337850093841553
        vertex 258.9100036621094 7.566669940948486 -5.337850093841553
        vertex 259.1099853515625 7.566669940948486 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 258.9100036621094 7.566669940948486 -5.5378499031066895
        vertex 259.1099853515625 7.566669940948486 -5.5378499031066895
        vertex 258.9100036621094 7.566669940948486 -5.337850093841553
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 259.1099853515625 7.766670227050781 -5.337850093841553
        vertex 259.1099853515625 7.566669940948486 -5.337850093841553
        vertex 259.1099853515625 7.766670227050781 -5.5378499031066895
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 259.1099853515625 7.566669940948486 -5.5378499031066895
        vertex 259.1099853515625 7.766670227050781 -5.5378499031066895
        vertex 259.1099853515625 7.566669940948486 -5.337850093841553
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 258.9100036621094 7.766670227050781 -5.337850093841553
        vertex 259.1099853515625 7.766670227050781 -5.337850093841553
        vertex 258.9100036621094 7.766670227050781 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 259.1099853515625 7.766670227050781 -5.5378499031066895
        vertex 258.9100036621094 7.766670227050781 -5.5378499031066895
        vertex 259.1099853515625 7.766670227050781 -5.337850093841553
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 258.9100036621094 7.566669940948486 -5.337850093841553
        vertex 258.9100036621094 7.766670227050781 -5.337850093841553
        vertex 258.9100036621094 7.566669940948486 -5.5378499031066895
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 258.9100036621094 7.766670227050781 -5.5378499031066895
        vertex 258.9100036621094 7.566669940948486 -5.5378499031066895
        vertex 258.9100036621094 7.766670227050781 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 258.9100036621094 7.566669940948486 -5.5378499031066895
        vertex 258.9100036621094 7.766670227050781 -5.5378499031066895
        vertex 259.1099853515625 7.566669940948486 -5.5378499031066895
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 259.1099853515625 7.766670227050781 -5.5378499031066895
        vertex 259.1099853515625 7.566669940948486 -5.5378499031066895
        vertex 258.9100036621094 7.766670227050781 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 252.9199981689453 15.23330020904541 -5.337850093841553
        vertex 253.1199951171875 15.23330020904541 -5.337850093841553
        vertex 252.9199981689453 15.433300018310547 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 253.1199951171875 15.433300018310547 -5.337850093841553
        vertex 252.9199981689453 15.433300018310547 -5.337850093841553
        vertex 253.1199951171875 15.23330020904541 -5.337850093841553
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 253.1199951171875 15.23330020904541 -5.337850093841553
        vertex 252.9199981689453 15.23330020904541 -5.337850093841553
        vertex 253.1199951171875 15.23330020904541 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 252.9199981689453 15.23330020904541 -5.5378499031066895
        vertex 253.1199951171875 15.23330020904541 -5.5378499031066895
        vertex 252.9199981689453 15.23330020904541 -5.337850093841553
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 253.1199951171875 15.433300018310547 -5.337850093841553
        vertex 253.1199951171875 15.23330020904541 -5.337850093841553
        vertex 253.1199951171875 15.433300018310547 -5.5378499031066895
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 253.1199951171875 15.23330020904541 -5.5378499031066895
        vertex 253.1199951171875 15.433300018310547 -5.5378499031066895
        vertex 253.1199951171875 15.23330020904541 -5.337850093841553
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 252.9199981689453 15.433300018310547 -5.337850093841553
        vertex 253.1199951171875 15.433300018310547 -5.337850093841553
        vertex 252.9199981689453 15.433300018310547 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 253.1199951171875 15.433300018310547 -5.5378499031066895
        vertex 252.9199981689453 15.433300018310547 -5.5378499031066895
        vertex 253.1199951171875 15.433300018310547 -5.337850093841553
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 252.9199981689453 15.23330020904541 -5.337850093841553
        vertex 252.9199981689453 15.433300018310547 -5.337850093841553
        vertex 252.9199981689453 15.23330020904541 -5.5378499031066895
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 252.9199981689453 15.433300018310547 -5.5378499031066895
        vertex 252.9199981689453 15.23330020904541 -5.5378499031066895
        vertex 252.9199981689453 15.433300018310547 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 252.9199981689453 15.23330020904541 -5.5378499031066895
        vertex 252.9199981689453 15.433300018310547 -5.5378499031066895
        vertex 253.1199951171875 15.23330020904541 -5.5378499031066895
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 253.1199951171875 15.433300018310547 -5.5378499031066895
        vertex 253.1199951171875 15.23330020904541 -5.5378499031066895
        vertex 252.9199981689453 15.433300018310547 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 248.84100341796875 20.45400047302246 -5.337850093841553
        vertex 249.04100036621094 20.45400047302246 -5.337850093841553
        vertex 248.84100341796875 20.65399932861328 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 249.04100036621094 20.65399932861328 -5.337850093841553
        vertex 248.84100341796875 20.65399932861328 -5.337850093841553
        vertex 249.04100036621094 20.45400047302246 -5.337850093841553
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 249.04100036621094 20.45400047302246 -5.337850093841553
        vertex 248.84100341796875 20.45400047302246 -5.337850093841553
        vertex 249.04100036621094 20.45400047302246 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 248.84100341796875 20.45400047302246 -5.5378499031066895
        vertex 249.04100036621094 20.45400047302246 -5.5378499031066895
        vertex 248.84100341796875 20.45400047302246 -5.337850093841553
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 249.04100036621094 20.65399932861328 -5.337850093841553
        vertex 249.04100036621094 20.45400047302246 -5.337850093841553
        vertex 249.04100036621094 20.65399932861328 -5.5378499031066895
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 249.04100036621094 20.45400047302246 -5.5378499031066895
        vertex 249.04100036621094 20.65399932861328 -5.5378499031066895
        vertex 249.04100036621094 20.45400047302246 -5.337850093841553
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 248.84100341796875 20.65399932861328 -5.337850093841553
        vertex 249.04100036621094 20.65399932861328 -5.337850093841553
        vertex 248.84100341796875 20.65399932861328 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 249.04100036621094 20.65399932861328 -5.5378499031066895
        vertex 248.84100341796875 20.65399932861328 -5.5378499031066895
        vertex 249.04100036621094 20.65399932861328 -5.337850093841553
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 248.84100341796875 20.45400047302246 -5.337850093841553
        vertex 248.84100341796875 20.65399932861328 -5.337850093841553
        vertex 248.84100341796875 20.45400047302246 -5.5378499031066895
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 248.84100341796875 20.65399932861328 -5.5378499031066895
        vertex 248.84100341796875 20.45400047302246 -5.5378499031066895
        vertex 248.84100341796875 20.65399932861328 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 248.84100341796875 20.45400047302246 -5.5378499031066895
        vertex 248.84100341796875 20.65399932861328 -5.5378499031066895
        vertex 249.04100036621094 20.45400047302246 -5.5378499031066895
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 249.04100036621094 20.65399932861328 -5.5378499031066895
        vertex 249.04100036621094 20.45400047302246 -5.5378499031066895
        vertex 248.84100341796875 20.65399932861328 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 280.9590148925781 -20.65399932861328 -5.900000095367432
        vertex 281.15899658203125 -20.65399932861328 -5.900000095367432
        vertex 280.9590148925781 -20.45400047302246 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 281.15899658203125 -20.45400047302246 -5.900000095367432
        vertex 280.9590148925781 -20.45400047302246 -5.900000095367432
        vertex 281.15899658203125 -20.65399932861328 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 281.15899658203125 -20.65399932861328 -5.900000095367432
        vertex 280.9590148925781 -20.65399932861328 -5.900000095367432
        vertex 281.15899658203125 -20.65399932861328 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 280.9590148925781 -20.65399932861328 -6.099999904632568
        vertex 281.15899658203125 -20.65399932861328 -6.099999904632568
        vertex 280.9590148925781 -20.65399932861328 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 281.15899658203125 -20.45400047302246 -5.900000095367432
        vertex 281.15899658203125 -20.65399932861328 -5.900000095367432
        vertex 281.15899658203125 -20.45400047302246 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 281.15899658203125 -20.65399932861328 -6.099999904632568
        vertex 281.15899658203125 -20.45400047302246 -6.099999904632568
        vertex 281.15899658203125 -20.65399932861328 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 280.9590148925781 -20.45400047302246 -5.900000095367432
        vertex 281.15899658203125 -20.45400047302246 -5.900000095367432
        vertex 280.9590148925781 -20.45400047302246 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 281.15899658203125 -20.45400047302246 -6.099999904632568
        vertex 280.9590148925781 -20.45400047302246 -6.099999904632568
        vertex 281.15899658203125 -20.45400047302246 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 280.9590148925781 -20.65399932861328 -5.900000095367432
        vertex 280.9590148925781 -20.45400047302246 -5.900000095367432
        vertex 280.9590148925781 -20.65399932861328 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 280.9590148925781 -20.45400047302246 -6.099999904632568
        vertex 280.9590148925781 -20.65399932861328 -6.099999904632568
        vertex 280.9590148925781 -20.45400047302246 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 280.9590148925781 -20.65399932861328 -6.099999904632568
        vertex 280.9590148925781 -20.45400047302246 -6.099999904632568
        vertex 281.15899658203125 -20.65399932861328 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 281.15899658203125 -20.45400047302246 -6.099999904632568
        vertex 281.15899658203125 -20.65399932861328 -6.099999904632568
        vertex 280.9590148925781 -20.45400047302246 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 276.8800048828125 -15.433300018310547 -5.900000095367432
        vertex 277.0799865722656 -15.433300018310547 -5.900000095367432
        vertex 276.8800048828125 -15.23330020904541 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 277.0799865722656 -15.23330020904541 -5.900000095367432
        vertex 276.8800048828125 -15.23330020904541 -5.900000095367432
        vertex 277.0799865722656 -15.433300018310547 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 277.0799865722656 -15.433300018310547 -5.900000095367432
        vertex 276.8800048828125 -15.433300018310547 -5.900000095367432
        vertex 277.0799865722656 -15.433300018310547 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 276.8800048828125 -15.433300018310547 -6.099999904632568
        vertex 277.0799865722656 -15.433300018310547 -6.099999904632568
        vertex 276.8800048828125 -15.433300018310547 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 277.0799865722656 -15.23330020904541 -5.900000095367432
        vertex 277.0799865722656 -15.433300018310547 -5.900000095367432
        vertex 277.0799865722656 -15.23330020904541 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 277.0799865722656 -15.433300018310547 -6.099999904632568
        vertex 277.0799865722656 -15.23330020904541 -6.099999904632568
        vertex 277.0799865722656 -15.433300018310547 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 276.8800048828125 -15.23330020904541 -5.900000095367432
        vertex 277.0799865722656 -15.23330020904541 -5.900000095367432
        vertex 276.8800048828125 -15.23330020904541 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 277.0799865722656 -15.23330020904541 -6.099999904632568
        vertex 276.8800048828125 -15.23330020904541 -6.099999904632568
        vertex 277.0799865722656 -15.23330020904541 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 276.8800048828125 -15.433300018310547 -5.900000095367432
        vertex 276.8800048828125 -15.23330020904541 -5.900000095367432
        vertex 276.8800048828125 -15.433300018310547 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 276.8800048828125 -15.23330020904541 -6.099999904632568
        vertex 276.8800048828125 -15.433300018310547 -6.099999904632568
        vertex 276.8800048828125 -15.23330020904541 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 276.8800048828125 -15.433300018310547 -6.099999904632568
        vertex 276.8800048828125 -15.23330020904541 -6.099999904632568
        vertex 277.0799865722656 -15.433300018310547 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 277.0799865722656 -15.23330020904541 -6.099999904632568
        vertex 277.0799865722656 -15.433300018310547 -6.099999904632568
        vertex 276.8800048828125 -15.23330020904541 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 270.8900146484375 -7.766670227050781 -5.900000095367432
        vertex 271.0899963378906 -7.766670227050781 -5.900000095367432
        vertex 270.8900146484375 -7.566669940948486 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 271.0899963378906 -7.566669940948486 -5.900000095367432
        vertex 270.8900146484375 -7.566669940948486 -5.900000095367432
        vertex 271.0899963378906 -7.766670227050781 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 271.0899963378906 -7.766670227050781 -5.900000095367432
        vertex 270.8900146484375 -7.766670227050781 -5.900000095367432
        vertex 271.0899963378906 -7.766670227050781 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 270.8900146484375 -7.766670227050781 -6.099999904632568
        vertex 271.0899963378906 -7.766670227050781 -6.099999904632568
        vertex 270.8900146484375 -7.766670227050781 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 271.0899963378906 -7.566669940948486 -5.900000095367432
        vertex 271.0899963378906 -7.766670227050781 -5.900000095367432
        vertex 271.0899963378906 -7.566669940948486 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 271.0899963378906 -7.766670227050781 -6.099999904632568
        vertex 271.0899963378906 -7.566669940948486 -6.099999904632568
        vertex 271.0899963378906 -7.766670227050781 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 270.8900146484375 -7.566669940948486 -5.900000095367432
        vertex 271.0899963378906 -7.566669940948486 -5.900000095367432
        vertex 270.8900146484375 -7.566669940948486 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 271.0899963378906 -7.566669940948486 -6.099999904632568
        vertex 270.8900146484375 -7.566669940948486 -6.099999904632568
        vertex 271.0899963378906 -7.566669940948486 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 270.8900146484375 -7.766670227050781 -5.900000095367432
        vertex 270.8900146484375 -7.566669940948486 -5.900000095367432
        vertex 270.8900146484375 -7.766670227050781 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 270.8900146484375 -7.566669940948486 -6.099999904632568
        vertex 270.8900146484375 -7.766670227050781 -6.099999904632568
        vertex 270.8900146484375 -7.566669940948486 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 270.8900146484375 -7.766670227050781 -6.099999904632568
        vertex 270.8900146484375 -7.566669940948486 -6.099999904632568
        vertex 271.0899963378906 -7.766670227050781 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 271.0899963378906 -7.566669940948486 -6.099999904632568
        vertex 271.0899963378906 -7.766670227050781 -6.099999904632568
        vertex 270.8900146484375 -7.566669940948486 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 264.8999938964844 -0.10000000149011612 -5.900000095367432
        vertex 265.1000061035156 -0.10000000149011612 -5.900000095367432
        vertex 264.8999938964844 0.10000000149011612 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 265.1000061035156 0.10000000149011612 -5.900000095367432
        vertex 264.8999938964844 0.10000000149011612 -5.900000095367432
        vertex 265.1000061035156 -0.10000000149011612 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 265.1000061035156 -0.10000000149011612 -5.900000095367432
        vertex 264.8999938964844 -0.10000000149011612 -5.900000095367432
        vertex 265.1000061035156 -0.10000000149011612 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 264.8999938964844 -0.10000000149011612 -6.099999904632568
        vertex 265.1000061035156 -0.10000000149011612 -6.099999904632568
        vertex 264.8999938964844 -0.10000000149011612 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 265.1000061035156 0.10000000149011612 -5.900000095367432
        vertex 265.1000061035156 -0.10000000149011612 -5.900000095367432
        vertex 265.1000061035156 0.10000000149011612 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 265.1000061035156 -0.10000000149011612 -6.099999904632568
        vertex 265.1000061035156 0.10000000149011612 -6.099999904632568
        vertex 265.1000061035156 -0.10000000149011612 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 264.8999938964844 0.10000000149011612 -5.900000095367432
        vertex 265.1000061035156 0.10000000149011612 -5.900000095367432
        vertex 264.8999938964844 0.10000000149011612 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 265.1000061035156 0.10000000149011612 -6.099999904632568
        vertex 264.8999938964844 0.10000000149011612 -6.099999904632568
        vertex 265.1000061035156 0.10000000149011612 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 264.8999938964844 -0.10000000149011612 -5.900000095367432
        vertex 264.8999938964844 0.10000000149011612 -5.900000095367432
        vertex 264.8999938964844 -0.10000000149011612 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 264.8999938964844 0.10000000149011612 -6.099999904632568
        vertex 264.8999938964844 -0.10000000149011612 -6.099999904632568
        vertex 264.8999938964844 0.10000000149011612 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 264.8999938964844 -0.10000000149011612 -6.099999904632568
        vertex 264.8999938964844 0.10000000149011612 -6.099999904632568
        vertex 265.1000061035156 -0.10000000149011612 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 265.1000061035156 0.10000000149011612 -6.099999904632568
        vertex 265.1000061035156 -0.10000000149011612 -6.099999904632568
        vertex 264.8999938964844 0.10000000149011612 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 258.9100036621094 7.566669940948486 -5.900000095367432
        vertex 259.1099853515625 7.566669940948486 -5.900000095367432
        vertex 258.9100036621094 7.766670227050781 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 259.1099853515625 7.766670227050781 -5.900000095367432
        vertex 258.9100036621094 7.766670227050781 -5.900000095367432
        vertex 259.1099853515625 7.566669940948486 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 259.1099853515625 7.566669940948486 -5.900000095367432
        vertex 258.9100036621094 7.566669940948486 -5.900000095367432
        vertex 259.1099853515625 7.566669940948486 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 258.9100036621094 7.566669940948486 -6.099999904632568
        vertex 259.1099853515625 7.566669940948486 -6.099999904632568
        vertex 258.9100036621094 7.566669940948486 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 259.1099853515625 7.766670227050781 -5.900000095367432
        vertex 259.1099853515625 7.566669940948486 -5.900000095367432
        vertex 259.1099853515625 7.766670227050781 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 259.1099853515625 7.566669940948486 -6.099999904632568
        vertex 259.1099853515625 7.766670227050781 -6.099999904632568
        vertex 259.1099853515625 7.566669940948486 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 258.9100036621094 7.766670227050781 -5.900000095367432
        vertex 259.1099853515625 7.766670227050781 -5.900000095367432
        vertex 258.9100036621094 7.766670227050781 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 259.1099853515625 7.766670227050781 -6.099999904632568
        vertex 258.9100036621094 7.766670227050781 -6.099999904632568
        vertex 259.1099853515625 7.766670227050781 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 258.9100036621094 7.566669940948486 -5.900000095367432
        vertex 258.9100036621094 7.766670227050781 -5.900000095367432
        vertex 258.9100036621094 7.566669940948486 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 258.9100036621094 7.766670227050781 -6.099999904632568
        vertex 258.9100036621094 7.566669940948486 -6.099999904632568
        vertex 258.9100036621094 7.766670227050781 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 258.9100036621094 7.566669940948486 -6.099999904632568
        vertex 258.9100036621094 7.766670227050781 -6.099999904632568
        vertex 259.1099853515625 7.566669940948486 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 259.1099853515625 7.766670227050781 -6.099999904632568
        vertex 259.1099853515625 7.566669940948486 -6.099999904632568
        vertex 258.9100036621094 7.766670227050781 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 252.9199981689453 15.23330020904541 -5.900000095367432
        vertex 253.1199951171875 15.23330020904541 -5.900000095367432
        vertex 252.9199981689453 15.433300018310547 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 253.1199951171875 15.433300018310547 -5.900000095367432
        vertex 252.9199981689453 15.433300018310547 -5.900000095367432
        vertex 253.1199951171875 15.23330020904541 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 253.1199951171875 15.23330020904541 -5.900000095367432
        vertex 252.9199981689453 15.23330020904541 -5.900000095367432
        vertex 253.1199951171875 15.23330020904541 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 252.9199981689453 15.23330020904541 -6.099999904632568
        vertex 253.1199951171875 15.23330020904541 -6.099999904632568
        vertex 252.9199981689453 15.23330020904541 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 253.1199951171875 15.433300018310547 -5.900000095367432
        vertex 253.1199951171875 15.23330020904541 -5.900000095367432
        vertex 253.1199951171875 15.433300018310547 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 253.1199951171875 15.23330020904541 -6.099999904632568
        vertex 253.1199951171875 15.433300018310547 -6.099999904632568
        vertex 253.1199951171875 15.23330020904541 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 252.9199981689453 15.433300018310547 -5.900000095367432
        vertex 253.1199951171875 15.433300018310547 -5.900000095367432
        vertex 252.9199981689453 15.433300018310547 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 253.1199951171875 15.433300018310547 -6.099999904632568
        vertex 252.9199981689453 15.433300018310547 -6.099999904632568
        vertex 253.1199951171875 15.433300018310547 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 252.9199981689453 15.23330020904541 -5.900000095367432
        vertex 252.9199981689453 15.433300018310547 -5.900000095367432
        vertex 252.9199981689453 15.23330020904541 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 252.9199981689453 15.433300018310547 -6.099999904632568
        vertex 252.9199981689453 15.23330020904541 -6.099999904632568
        vertex 252.9199981689453 15.433300018310547 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 252.9199981689453 15.23330020904541 -6.099999904632568
        vertex 252.9199981689453 15.433300018310547 -6.099999904632568
        vertex 253.1199951171875 15.23330020904541 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 253.1199951171875 15.433300018310547 -6.099999904632568
        vertex 253.1199951171875 15.23330020904541 -6.099999904632568
        vertex 252.9199981689453 15.433300018310547 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 248.84100341796875 20.45400047302246 -5.900000095367432
        vertex 249.04100036621094 20.45400047302246 -5.900000095367432
        vertex 248.84100341796875 20.65399932861328 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 249.04100036621094 20.65399932861328 -5.900000095367432
        vertex 248.84100341796875 20.65399932861328 -5.900000095367432
        vertex 249.04100036621094 20.45400047302246 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 249.04100036621094 20.45400047302246 -5.900000095367432
        vertex 248.84100341796875 20.45400047302246 -5.900000095367432
        vertex 249.04100036621094 20.45400047302246 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 248.84100341796875 20.45400047302246 -6.099999904632568
        vertex 249.04100036621094 20.45400047302246 -6.099999904632568
        vertex 248.84100341796875 20.45400047302246 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 249.04100036621094 20.65399932861328 -5.900000095367432
        vertex 249.04100036621094 20.45400047302246 -5.900000095367432
        vertex 249.04100036621094 20.65399932861328 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 249.04100036621094 20.45400047302246 -6.099999904632568
        vertex 249.04100036621094 20.65399932861328 -6.099999904632568
        vertex 249.04100036621094 20.45400047302246 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 248.84100341796875 20.65399932861328 -5.900000095367432
        vertex 249.04100036621094 20.65399932861328 -5.900000095367432
        vertex 248.84100341796875 20.65399932861328 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 249.04100036621094 20.65399932861328 -6.099999904632568
        vertex 248.84100341796875 20.65399932861328 -6.099999904632568
        vertex 249.04100036621094 20.65399932861328 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 248.84100341796875 20.45400047302246 -5.900000095367432
        vertex 248.84100341796875 20.65399932861328 -5.900000095367432
        vertex 248.84100341796875 20.45400047302246 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 248.84100341796875 20.65399932861328 -6.099999904632568
        vertex 248.84100341796875 20.45400047302246 -6.099999904632568
        vertex 248.84100341796875 20.65399932861328 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 248.84100341796875 20.45400047302246 -6.099999904632568
        vertex 248.84100341796875 20.65399932861328 -6.099999904632568
        vertex 249.04100036621094 20.45400047302246 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 249.04100036621094 20.65399932861328 -6.099999904632568
        vertex 249.04100036621094 20.45400047302246 -6.099999904632568
        vertex 248.84100341796875 20.65399932861328 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 280.9590148925781 -20.65399932861328 -5.900000095367432
        vertex 281.15899658203125 -20.65399932861328 -5.900000095367432
        vertex 280.9590148925781 -20.45400047302246 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 281.15899658203125 -20.45400047302246 -5.900000095367432
        vertex 280.9590148925781 -20.45400047302246 -5.900000095367432
        vertex 281.15899658203125 -20.65399932861328 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 281.15899658203125 -20.65399932861328 -5.900000095367432
        vertex 280.9590148925781 -20.65399932861328 -5.900000095367432
        vertex 281.15899658203125 -20.65399932861328 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 280.9590148925781 -20.65399932861328 -6.099999904632568
        vertex 281.15899658203125 -20.65399932861328 -6.099999904632568
        vertex 280.9590148925781 -20.65399932861328 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 281.15899658203125 -20.45400047302246 -5.900000095367432
        vertex 281.15899658203125 -20.65399932861328 -5.900000095367432
        vertex 281.15899658203125 -20.45400047302246 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 281.15899658203125 -20.65399932861328 -6.099999904632568
        vertex 281.15899658203125 -20.45400047302246 -6.099999904632568
        vertex 281.15899658203125 -20.65399932861328 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 280.9590148925781 -20.45400047302246 -5.900000095367432
        vertex 281.15899658203125 -20.45400047302246 -5.900000095367432
        vertex 280.9590148925781 -20.45400047302246 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 281.15899658203125 -20.45400047302246 -6.099999904632568
        vertex 280.9590148925781 -20.45400047302246 -6.099999904632568
        vertex 281.15899658203125 -20.45400047302246 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 280.9590148925781 -20.65399932861328 -5.900000095367432
        vertex 280.9590148925781 -20.45400047302246 -5.900000095367432
        vertex 280.9590148925781 -20.65399932861328 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 280.9590148925781 -20.45400047302246 -6.099999904632568
        vertex 280.9590148925781 -20.65399932861328 -6.099999904632568
        vertex 280.9590148925781 -20.45400047302246 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 280.9590148925781 -20.65399932861328 -6.099999904632568
        vertex 280.9590148925781 -20.45400047302246 -6.099999904632568
        vertex 281.15899658203125 -20.65399932861328 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 281.15899658203125 -20.45400047302246 -6.099999904632568
        vertex 281.15899658203125 -20.65399932861328 -6.099999904632568
        vertex 280.9590148925781 -20.45400047302246 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 276.8800048828125 -15.433300018310547 -5.900000095367432
        vertex 277.0799865722656 -15.433300018310547 -5.900000095367432
        vertex 276.8800048828125 -15.23330020904541 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 277.0799865722656 -15.23330020904541 -5.900000095367432
        vertex 276.8800048828125 -15.23330020904541 -5.900000095367432
        vertex 277.0799865722656 -15.433300018310547 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 277.0799865722656 -15.433300018310547 -5.900000095367432
        vertex 276.8800048828125 -15.433300018310547 -5.900000095367432
        vertex 277.0799865722656 -15.433300018310547 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 276.8800048828125 -15.433300018310547 -6.099999904632568
        vertex 277.0799865722656 -15.433300018310547 -6.099999904632568
        vertex 276.8800048828125 -15.433300018310547 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 277.0799865722656 -15.23330020904541 -5.900000095367432
        vertex 277.0799865722656 -15.433300018310547 -5.900000095367432
        vertex 277.0799865722656 -15.23330020904541 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 277.0799865722656 -15.433300018310547 -6.099999904632568
        vertex 277.0799865722656 -15.23330020904541 -6.099999904632568
        vertex 277.0799865722656 -15.433300018310547 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 276.8800048828125 -15.23330020904541 -5.900000095367432
        vertex 277.0799865722656 -15.23330020904541 -5.900000095367432
        vertex 276.8800048828125 -15.23330020904541 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 277.0799865722656 -15.23330020904541 -6.099999904632568
        vertex 276.8800048828125 -15.23330020904541 -6.099999904632568
        vertex 277.0799865722656 -15.23330020904541 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 276.8800048828125 -15.433300018310547 -5.900000095367432
        vertex 276.8800048828125 -15.23330020904541 -5.900000095367432
        vertex 276.8800048828125 -15.433300018310547 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 276.8800048828125 -15.23330020904541 -6.099999904632568
        vertex 276.8800048828125 -15.433300018310547 -6.099999904632568
        vertex 276.8800048828125 -15.23330020904541 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 276.8800048828125 -15.433300018310547 -6.099999904632568
        vertex 276.8800048828125 -15.23330020904541 -6.099999904632568
        vertex 277.0799865722656 -15.433300018310547 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 277.0799865722656 -15.23330020904541 -6.099999904632568
        vertex 277.0799865722656 -15.433300018310547 -6.099999904632568
        vertex 276.8800048828125 -15.23330020904541 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 270.8900146484375 -7.766670227050781 -5.900000095367432
        vertex 271.0899963378906 -7.766670227050781 -5.900000095367432
        vertex 270.8900146484375 -7.566669940948486 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 271.0899963378906 -7.566669940948486 -5.900000095367432
        vertex 270.8900146484375 -7.566669940948486 -5.900000095367432
        vertex 271.0899963378906 -7.766670227050781 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 271.0899963378906 -7.766670227050781 -5.900000095367432
        vertex 270.8900146484375 -7.766670227050781 -5.900000095367432
        vertex 271.0899963378906 -7.766670227050781 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 270.8900146484375 -7.766670227050781 -6.099999904632568
        vertex 271.0899963378906 -7.766670227050781 -6.099999904632568
        vertex 270.8900146484375 -7.766670227050781 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 271.0899963378906 -7.566669940948486 -5.900000095367432
        vertex 271.0899963378906 -7.766670227050781 -5.900000095367432
        vertex 271.0899963378906 -7.566669940948486 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 271.0899963378906 -7.766670227050781 -6.099999904632568
        vertex 271.0899963378906 -7.566669940948486 -6.099999904632568
        vertex 271.0899963378906 -7.766670227050781 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 270.8900146484375 -7.566669940948486 -5.900000095367432
        vertex 271.0899963378906 -7.566669940948486 -5.900000095367432
        vertex 270.8900146484375 -7.566669940948486 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 271.0899963378906 -7.566669940948486 -6.099999904632568
        vertex 270.8900146484375 -7.566669940948486 -6.099999904632568
        vertex 271.0899963378906 -7.566669940948486 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 270.8900146484375 -7.766670227050781 -5.900000095367432
        vertex 270.8900146484375 -7.566669940948486 -5.900000095367432
        vertex 270.8900146484375 -7.766670227050781 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 270.8900146484375 -7.566669940948486 -6.099999904632568
        vertex 270.8900146484375 -7.766670227050781 -6.099999904632568
        vertex 270.8900146484375 -7.566669940948486 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 270.8900146484375 -7.766670227050781 -6.099999904632568
        vertex 270.8900146484375 -7.566669940948486 -6.099999904632568
        vertex 271.0899963378906 -7.766670227050781 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 271.0899963378906 -7.566669940948486 -6.099999904632568
        vertex 271.0899963378906 -7.766670227050781 -6.099999904632568
        vertex 270.8900146484375 -7.566669940948486 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 264.8999938964844 -0.10000000149011612 -5.900000095367432
        vertex 265.1000061035156 -0.10000000149011612 -5.900000095367432
        vertex 264.8999938964844 0.10000000149011612 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 265.1000061035156 0.10000000149011612 -5.900000095367432
        vertex 264.8999938964844 0.10000000149011612 -5.900000095367432
        vertex 265.1000061035156 -0.10000000149011612 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 265.1000061035156 -0.10000000149011612 -5.900000095367432
        vertex 264.8999938964844 -0.10000000149011612 -5.900000095367432
        vertex 265.1000061035156 -0.10000000149011612 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 264.8999938964844 -0.10000000149011612 -6.099999904632568
        vertex 265.1000061035156 -0.10000000149011612 -6.099999904632568
        vertex 264.8999938964844 -0.10000000149011612 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 265.1000061035156 0.10000000149011612 -5.900000095367432
        vertex 265.1000061035156 -0.10000000149011612 -5.900000095367432
        vertex 265.1000061035156 0.10000000149011612 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 265.1000061035156 -0.10000000149011612 -6.099999904632568
        vertex 265.1000061035156 0.10000000149011612 -6.099999904632568
        vertex 265.1000061035156 -0.10000000149011612 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 264.8999938964844 0.10000000149011612 -5.900000095367432
        vertex 265.1000061035156 0.10000000149011612 -5.900000095367432
        vertex 264.8999938964844 0.10000000149011612 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 265.1000061035156 0.10000000149011612 -6.099999904632568
        vertex 264.8999938964844 0.10000000149011612 -6.099999904632568
        vertex 265.1000061035156 0.10000000149011612 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 264.8999938964844 -0.10000000149011612 -5.900000095367432
        vertex 264.8999938964844 0.10000000149011612 -5.900000095367432
        vertex 264.8999938964844 -0.10000000149011612 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 264.8999938964844 0.10000000149011612 -6.099999904632568
        vertex 264.8999938964844 -0.10000000149011612 -6.099999904632568
        vertex 264.8999938964844 0.10000000149011612 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 264.8999938964844 -0.10000000149011612 -6.099999904632568
        vertex 264.8999938964844 0.10000000149011612 -6.099999904632568
        vertex 265.1000061035156 -0.10000000149011612 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 265.1000061035156 0.10000000149011612 -6.099999904632568
        vertex 265.1000061035156 -0.10000000149011612 -6.099999904632568
        vertex 264.8999938964844 0.10000000149011612 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 258.9100036621094 7.566669940948486 -5.900000095367432
        vertex 259.1099853515625 7.566669940948486 -5.900000095367432
        vertex 258.9100036621094 7.766670227050781 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 259.1099853515625 7.766670227050781 -5.900000095367432
        vertex 258.9100036621094 7.766670227050781 -5.900000095367432
        vertex 259.1099853515625 7.566669940948486 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 259.1099853515625 7.566669940948486 -5.900000095367432
        vertex 258.9100036621094 7.566669940948486 -5.900000095367432
        vertex 259.1099853515625 7.566669940948486 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 258.9100036621094 7.566669940948486 -6.099999904632568
        vertex 259.1099853515625 7.566669940948486 -6.099999904632568
        vertex 258.9100036621094 7.566669940948486 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 259.1099853515625 7.766670227050781 -5.900000095367432
        vertex 259.1099853515625 7.566669940948486 -5.900000095367432
        vertex 259.1099853515625 7.766670227050781 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 259.1099853515625 7.566669940948486 -6.099999904632568
        vertex 259.1099853515625 7.766670227050781 -6.099999904632568
        vertex 259.1099853515625 7.566669940948486 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 258.9100036621094 7.766670227050781 -5.900000095367432
        vertex 259.1099853515625 7.766670227050781 -5.900000095367432
        vertex 258.9100036621094 7.766670227050781 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 259.1099853515625 7.766670227050781 -6.099999904632568
        vertex 258.9100036621094 7.766670227050781 -6.099999904632568
        vertex 259.1099853515625 7.766670227050781 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 258.9100036621094 7.566669940948486 -5.900000095367432
        vertex 258.9100036621094 7.766670227050781 -5.900000095367432
        vertex 258.9100036621094 7.566669940948486 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 258.9100036621094 7.766670227050781 -6.099999904632568
        vertex 258.9100036621094 7.566669940948486 -6.099999904632568
        vertex 258.9100036621094 7.766670227050781 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 258.9100036621094 7.566669940948486 -6.099999904632568
        vertex 258.9100036621094 7.766670227050781 -6.099999904632568
        vertex 259.1099853515625 7.566669940948486 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 259.1099853515625 7.766670227050781 -6.099999904632568
        vertex 259.1099853515625 7.566669940948486 -6.099999904632568
        vertex 258.9100036621094 7.766670227050781 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 252.9199981689453 15.23330020904541 -5.900000095367432
        vertex 253.1199951171875 15.23330020904541 -5.900000095367432
        vertex 252.9199981689453 15.433300018310547 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 253.1199951171875 15.433300018310547 -5.900000095367432
        vertex 252.9199981689453 15.433300018310547 -5.900000095367432
        vertex 253.1199951171875 15.23330020904541 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 253.1199951171875 15.23330020904541 -5.900000095367432
        vertex 252.9199981689453 15.23330020904541 -5.900000095367432
        vertex 253.1199951171875 15.23330020904541 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 252.9199981689453 15.23330020904541 -6.099999904632568
        vertex 253.1199951171875 15.23330020904541 -6.099999904632568
        vertex 252.9199981689453 15.23330020904541 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 253.1199951171875 15.433300018310547 -5.900000095367432
        vertex 253.1199951171875 15.23330020904541 -5.900000095367432
        vertex 253.1199951171875 15.433300018310547 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 253.1199951171875 15.23330020904541 -6.099999904632568
        vertex 253.1199951171875 15.433300018310547 -6.099999904632568
        vertex 253.1199951171875 15.23330020904541 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 252.9199981689453 15.433300018310547 -5.900000095367432
        vertex 253.1199951171875 15.433300018310547 -5.900000095367432
        vertex 252.9199981689453 15.433300018310547 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 253.1199951171875 15.433300018310547 -6.099999904632568
        vertex 252.9199981689453 15.433300018310547 -6.099999904632568
        vertex 253.1199951171875 15.433300018310547 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 252.9199981689453 15.23330020904541 -5.900000095367432
        vertex 252.9199981689453 15.433300018310547 -5.900000095367432
        vertex 252.9199981689453 15.23330020904541 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 252.9199981689453 15.433300018310547 -6.099999904632568
        vertex 252.9199981689453 15.23330020904541 -6.099999904632568
        vertex 252.9199981689453 15.433300018310547 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 252.9199981689453 15.23330020904541 -6.099999904632568
        vertex 252.9199981689453 15.433300018310547 -6.099999904632568
        vertex 253.1199951171875 15.23330020904541 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 253.1199951171875 15.433300018310547 -6.099999904632568
        vertex 253.1199951171875 15.23330020904541 -6.099999904632568
        vertex 252.9199981689453 15.433300018310547 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 248.84100341796875 20.45400047302246 -5.900000095367432
        vertex 249.04100036621094 20.45400047302246 -5.900000095367432
        vertex 248.84100341796875 20.65399932861328 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 249.04100036621094 20.65399932861328 -5.900000095367432
        vertex 248.84100341796875 20.65399932861328 -5.900000095367432
        vertex 249.04100036621094 20.45400047302246 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 249.04100036621094 20.45400047302246 -5.900000095367432
        vertex 248.84100341796875 20.45400047302246 -5.900000095367432
        vertex 249.04100036621094 20.45400047302246 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 248.84100341796875 20.45400047302246 -6.099999904632568
        vertex 249.04100036621094 20.45400047302246 -6.099999904632568
        vertex 248.84100341796875 20.45400047302246 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 249.04100036621094 20.65399932861328 -5.900000095367432
        vertex 249.04100036621094 20.45400047302246 -5.900000095367432
        vertex 249.04100036621094 20.65399932861328 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 249.04100036621094 20.45400047302246 -6.099999904632568
        vertex 249.04100036621094 20.65399932861328 -6.099999904632568
        vertex 249.04100036621094 20.45400047302246 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 248.84100341796875 20.65399932861328 -5.900000095367432
        vertex 249.04100036621094 20.65399932861328 -5.900000095367432
        vertex 248.84100341796875 20.65399932861328 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 249.04100036621094 20.65399932861328 -6.099999904632568
        vertex 248.84100341796875 20.65399932861328 -6.099999904632568
        vertex 249.04100036621094 20.65399932861328 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 248.84100341796875 20.45400047302246 -5.900000095367432
        vertex 248.84100341796875 20.65399932861328 -5.900000095367432
        vertex 248.84100341796875 20.45400047302246 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 248.84100341796875 20.65399932861328 -6.099999904632568
        vertex 248.84100341796875 20.45400047302246 -6.099999904632568
        vertex 248.84100341796875 20.65399932861328 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 248.84100341796875 20.45400047302246 -6.099999904632568
        vertex 248.84100341796875 20.65399932861328 -6.099999904632568
        vertex 249.04100036621094 20.45400047302246 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 249.04100036621094 20.65399932861328 -6.099999904632568
        vertex 249.04100036621094 20.45400047302246 -6.099999904632568
        vertex 248.84100341796875 20.65399932861328 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 15.958499908447266 -20.65399932861328 -5.337850093841553
        vertex 16.15850067138672 -20.65399932861328 -5.337850093841553
        vertex 15.958499908447266 -20.45400047302246 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 16.15850067138672 -20.45400047302246 -5.337850093841553
        vertex 15.958499908447266 -20.45400047302246 -5.337850093841553
        vertex 16.15850067138672 -20.65399932861328 -5.337850093841553
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 16.15850067138672 -20.65399932861328 -5.337850093841553
        vertex 15.958499908447266 -20.65399932861328 -5.337850093841553
        vertex 16.15850067138672 -20.65399932861328 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 15.958499908447266 -20.65399932861328 -5.5378499031066895
        vertex 16.15850067138672 -20.65399932861328 -5.5378499031066895
        vertex 15.958499908447266 -20.65399932861328 -5.337850093841553
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 16.15850067138672 -20.45400047302246 -5.337850093841553
        vertex 16.15850067138672 -20.65399932861328 -5.337850093841553
        vertex 16.15850067138672 -20.45400047302246 -5.5378499031066895
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 16.15850067138672 -20.65399932861328 -5.5378499031066895
        vertex 16.15850067138672 -20.45400047302246 -5.5378499031066895
        vertex 16.15850067138672 -20.65399932861328 -5.337850093841553
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 15.958499908447266 -20.45400047302246 -5.337850093841553
        vertex 16.15850067138672 -20.45400047302246 -5.337850093841553
        vertex 15.958499908447266 -20.45400047302246 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 16.15850067138672 -20.45400047302246 -5.5378499031066895
        vertex 15.958499908447266 -20.45400047302246 -5.5378499031066895
        vertex 16.15850067138672 -20.45400047302246 -5.337850093841553
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 15.958499908447266 -20.65399932861328 -5.337850093841553
        vertex 15.958499908447266 -20.45400047302246 -5.337850093841553
        vertex 15.958499908447266 -20.65399932861328 -5.5378499031066895
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 15.958499908447266 -20.45400047302246 -5.5378499031066895
        vertex 15.958499908447266 -20.65399932861328 -5.5378499031066895
        vertex 15.958499908447266 -20.45400047302246 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 15.958499908447266 -20.65399932861328 -5.5378499031066895
        vertex 15.958499908447266 -20.45400047302246 -5.5378499031066895
        vertex 16.15850067138672 -20.65399932861328 -5.5378499031066895
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 16.15850067138672 -20.45400047302246 -5.5378499031066895
        vertex 16.15850067138672 -20.65399932861328 -5.5378499031066895
        vertex 15.958499908447266 -20.45400047302246 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 11.87969970703125 -15.433300018310547 -5.337850093841553
        vertex 12.079700469970703 -15.433300018310547 -5.337850093841553
        vertex 11.87969970703125 -15.23330020904541 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 12.079700469970703 -15.23330020904541 -5.337850093841553
        vertex 11.87969970703125 -15.23330020904541 -5.337850093841553
        vertex 12.079700469970703 -15.433300018310547 -5.337850093841553
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 12.079700469970703 -15.433300018310547 -5.337850093841553
        vertex 11.87969970703125 -15.433300018310547 -5.337850093841553
        vertex 12.079700469970703 -15.433300018310547 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 11.87969970703125 -15.433300018310547 -5.5378499031066895
        vertex 12.079700469970703 -15.433300018310547 -5.5378499031066895
        vertex 11.87969970703125 -15.433300018310547 -5.337850093841553
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 12.079700469970703 -15.23330020904541 -5.337850093841553
        vertex 12.079700469970703 -15.433300018310547 -5.337850093841553
        vertex 12.079700469970703 -15.23330020904541 -5.5378499031066895
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 12.079700469970703 -15.433300018310547 -5.5378499031066895
        vertex 12.079700469970703 -15.23330020904541 -5.5378499031066895
        vertex 12.079700469970703 -15.433300018310547 -5.337850093841553
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 11.87969970703125 -15.23330020904541 -5.337850093841553
        vertex 12.079700469970703 -15.23330020904541 -5.337850093841553
        vertex 11.87969970703125 -15.23330020904541 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 12.079700469970703 -15.23330020904541 -5.5378499031066895
        vertex 11.87969970703125 -15.23330020904541 -5.5378499031066895
        vertex 12.079700469970703 -15.23330020904541 -5.337850093841553
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 11.87969970703125 -15.433300018310547 -5.337850093841553
        vertex 11.87969970703125 -15.23330020904541 -5.337850093841553
        vertex 11.87969970703125 -15.433300018310547 -5.5378499031066895
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 11.87969970703125 -15.23330020904541 -5.5378499031066895
        vertex 11.87969970703125 -15.433300018310547 -5.5378499031066895
        vertex 11.87969970703125 -15.23330020904541 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 11.87969970703125 -15.433300018310547 -5.5378499031066895
        vertex 11.87969970703125 -15.23330020904541 -5.5378499031066895
        vertex 12.079700469970703 -15.433300018310547 -5.5378499031066895
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 12.079700469970703 -15.23330020904541 -5.5378499031066895
        vertex 12.079700469970703 -15.433300018310547 -5.5378499031066895
        vertex 11.87969970703125 -15.23330020904541 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 5.889860153198242 -7.766670227050781 -5.337850093841553
        vertex 6.089859962463379 -7.766670227050781 -5.337850093841553
        vertex 5.889860153198242 -7.566669940948486 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 6.089859962463379 -7.566669940948486 -5.337850093841553
        vertex 5.889860153198242 -7.566669940948486 -5.337850093841553
        vertex 6.089859962463379 -7.766670227050781 -5.337850093841553
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 6.089859962463379 -7.766670227050781 -5.337850093841553
        vertex 5.889860153198242 -7.766670227050781 -5.337850093841553
        vertex 6.089859962463379 -7.766670227050781 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 5.889860153198242 -7.766670227050781 -5.5378499031066895
        vertex 6.089859962463379 -7.766670227050781 -5.5378499031066895
        vertex 5.889860153198242 -7.766670227050781 -5.337850093841553
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 6.089859962463379 -7.566669940948486 -5.337850093841553
        vertex 6.089859962463379 -7.766670227050781 -5.337850093841553
        vertex 6.089859962463379 -7.566669940948486 -5.5378499031066895
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 6.089859962463379 -7.766670227050781 -5.5378499031066895
        vertex 6.089859962463379 -7.566669940948486 -5.5378499031066895
        vertex 6.089859962463379 -7.766670227050781 -5.337850093841553
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 5.889860153198242 -7.566669940948486 -5.337850093841553
        vertex 6.089859962463379 -7.566669940948486 -5.337850093841553
        vertex 5.889860153198242 -7.566669940948486 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 6.089859962463379 -7.566669940948486 -5.5378499031066895
        vertex 5.889860153198242 -7.566669940948486 -5.5378499031066895
        vertex 6.089859962463379 -7.566669940948486 -5.337850093841553
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 5.889860153198242 -7.766670227050781 -5.337850093841553
        vertex 5.889860153198242 -7.566669940948486 -5.337850093841553
        vertex 5.889860153198242 -7.766670227050781 -5.5378499031066895
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 5.889860153198242 -7.566669940948486 -5.5378499031066895
        vertex 5.889860153198242 -7.766670227050781 -5.5378499031066895
        vertex 5.889860153198242 -7.566669940948486 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 5.889860153198242 -7.766670227050781 -5.5378499031066895
        vertex 5.889860153198242 -7.566669940948486 -5.5378499031066895
        vertex 6.089859962463379 -7.766670227050781 -5.5378499031066895
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 6.089859962463379 -7.566669940948486 -5.5378499031066895
        vertex 6.089859962463379 -7.766670227050781 -5.5378499031066895
        vertex 5.889860153198242 -7.566669940948486 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex -0.10000000149011612 -0.10000000149011612 -5.337850093841553
        vertex 0.10000000149011612 -0.10000000149011612 -5.337850093841553
        vertex -0.10000000149011612 0.10000000149011612 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 0.10000000149011612 0.10000000149011612 -5.337850093841553
        vertex -0.10000000149011612 0.10000000149011612 -5.337850093841553
        vertex 0.10000000149011612 -0.10000000149011612 -5.337850093841553
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 0.10000000149011612 -0.10000000149011612 -5.337850093841553
        vertex -0.10000000149011612 -0.10000000149011612 -5.337850093841553
        vertex 0.10000000149011612 -0.10000000149011612 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex -0.10000000149011612 -0.10000000149011612 -5.5378499031066895
        vertex 0.10000000149011612 -0.10000000149011612 -5.5378499031066895
        vertex -0.10000000149011612 -0.10000000149011612 -5.337850093841553
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 0.10000000149011612 0.10000000149011612 -5.337850093841553
        vertex 0.10000000149011612 -0.10000000149011612 -5.337850093841553
        vertex 0.10000000149011612 0.10000000149011612 -5.5378499031066895
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 0.10000000149011612 -0.10000000149011612 -5.5378499031066895
        vertex 0.10000000149011612 0.10000000149011612 -5.5378499031066895
        vertex 0.10000000149011612 -0.10000000149011612 -5.337850093841553
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex -0.10000000149011612 0.10000000149011612 -5.337850093841553
        vertex 0.10000000149011612 0.10000000149011612 -5.337850093841553
        vertex -0.10000000149011612 0.10000000149011612 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 0.10000000149011612 0.10000000149011612 -5.5378499031066895
        vertex -0.10000000149011612 0.10000000149011612 -5.5378499031066895
        vertex 0.10000000149011612 0.10000000149011612 -5.337850093841553
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex -0.10000000149011612 -0.10000000149011612 -5.337850093841553
        vertex -0.10000000149011612 0.10000000149011612 -5.337850093841553
        vertex -0.10000000149011612 -0.10000000149011612 -5.5378499031066895
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex -0.10000000149011612 0.10000000149011612 -5.5378499031066895
        vertex -0.10000000149011612 -0.10000000149011612 -5.5378499031066895
        vertex -0.10000000149011612 0.10000000149011612 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex -0.10000000149011612 -0.10000000149011612 -5.5378499031066895
        vertex -0.10000000149011612 0.10000000149011612 -5.5378499031066895
        vertex 0.10000000149011612 -0.10000000149011612 -5.5378499031066895
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 0.10000000149011612 0.10000000149011612 -5.5378499031066895
        vertex 0.10000000149011612 -0.10000000149011612 -5.5378499031066895
        vertex -0.10000000149011612 0.10000000149011612 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex -6.089859962463379 7.566669940948486 -5.337850093841553
        vertex -5.889860153198242 7.566669940948486 -5.337850093841553
        vertex -6.089859962463379 7.766670227050781 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex -5.889860153198242 7.766670227050781 -5.337850093841553
        vertex -6.089859962463379 7.766670227050781 -5.337850093841553
        vertex -5.889860153198242 7.566669940948486 -5.337850093841553
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex -5.889860153198242 7.566669940948486 -5.337850093841553
        vertex -6.089859962463379 7.566669940948486 -5.337850093841553
        vertex -5.889860153198242 7.566669940948486 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex -6.089859962463379 7.566669940948486 -5.5378499031066895
        vertex -5.889860153198242 7.566669940948486 -5.5378499031066895
        vertex -6.089859962463379 7.566669940948486 -5.337850093841553
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex -5.889860153198242 7.766670227050781 -5.337850093841553
        vertex -5.889860153198242 7.566669940948486 -5.337850093841553
        vertex -5.889860153198242 7.766670227050781 -5.5378499031066895
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex -5.889860153198242 7.566669940948486 -5.5378499031066895
        vertex -5.889860153198242 7.766670227050781 -5.5378499031066895
        vertex -5.889860153198242 7.566669940948486 -5.337850093841553
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex -6.089859962463379 7.766670227050781 -5.337850093841553
        vertex -5.889860153198242 7.766670227050781 -5.337850093841553
        vertex -6.089859962463379 7.766670227050781 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex -5.889860153198242 7.766670227050781 -5.5378499031066895
        vertex -6.089859962463379 7.766670227050781 -5.5378499031066895
        vertex -5.889860153198242 7.766670227050781 -5.337850093841553
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex -6.089859962463379 7.566669940948486 -5.337850093841553
        vertex -6.089859962463379 7.766670227050781 -5.337850093841553
        vertex -6.089859962463379 7.566669940948486 -5.5378499031066895
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex -6.089859962463379 7.766670227050781 -5.5378499031066895
        vertex -6.089859962463379 7.566669940948486 -5.5378499031066895
        vertex -6.089859962463379 7.766670227050781 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex -6.089859962463379 7.566669940948486 -5.5378499031066895
        vertex -6.089859962463379 7.766670227050781 -5.5378499031066895
        vertex -5.889860153198242 7.566669940948486 -5.5378499031066895
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex -5.889860153198242 7.766670227050781 -5.5378499031066895
        vertex -5.889860153198242 7.566669940948486 -5.5378499031066895
        vertex -6.089859962463379 7.766670227050781 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex -12.079700469970703 15.23330020904541 -5.337850093841553
        vertex -11.87969970703125 15.23330020904541 -5.337850093841553
        vertex -12.079700469970703 15.433300018310547 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex -11.87969970703125 15.433300018310547 -5.337850093841553
        vertex -12.079700469970703 15.433300018310547 -5.337850093841553
        vertex -11.87969970703125 15.23330020904541 -5.337850093841553
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex -11.87969970703125 15.23330020904541 -5.337850093841553
        vertex -12.079700469970703 15.23330020904541 -5.337850093841553
        vertex -11.87969970703125 15.23330020904541 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex -12.079700469970703 15.23330020904541 -5.5378499031066895
        vertex -11.87969970703125 15.23330020904541 -5.5378499031066895
        vertex -12.079700469970703 15.23330020904541 -5.337850093841553
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex -11.87969970703125 15.433300018310547 -5.337850093841553
        vertex -11.87969970703125 15.23330020904541 -5.337850093841553
        vertex -11.87969970703125 15.433300018310547 -5.5378499031066895
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex -11.87969970703125 15.23330020904541 -5.5378499031066895
        vertex -11.87969970703125 15.433300018310547 -5.5378499031066895
        vertex -11.87969970703125 15.23330020904541 -5.337850093841553
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex -12.079700469970703 15.433300018310547 -5.337850093841553
        vertex -11.87969970703125 15.433300018310547 -5.337850093841553
        vertex -12.079700469970703 15.433300018310547 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex -11.87969970703125 15.433300018310547 -5.5378499031066895
        vertex -12.079700469970703 15.433300018310547 -5.5378499031066895
        vertex -11.87969970703125 15.433300018310547 -5.337850093841553
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex -12.079700469970703 15.23330020904541 -5.337850093841553
        vertex -12.079700469970703 15.433300018310547 -5.337850093841553
        vertex -12.079700469970703 15.23330020904541 -5.5378499031066895
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex -12.079700469970703 15.433300018310547 -5.5378499031066895
        vertex -12.079700469970703 15.23330020904541 -5.5378499031066895
        vertex -12.079700469970703 15.433300018310547 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex -12.079700469970703 15.23330020904541 -5.5378499031066895
        vertex -12.079700469970703 15.433300018310547 -5.5378499031066895
        vertex -11.87969970703125 15.23330020904541 -5.5378499031066895
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex -11.87969970703125 15.433300018310547 -5.5378499031066895
        vertex -11.87969970703125 15.23330020904541 -5.5378499031066895
        vertex -12.079700469970703 15.433300018310547 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex -16.15850067138672 20.45400047302246 -5.337850093841553
        vertex -15.958499908447266 20.45400047302246 -5.337850093841553
        vertex -16.15850067138672 20.65399932861328 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex -15.958499908447266 20.65399932861328 -5.337850093841553
        vertex -16.15850067138672 20.65399932861328 -5.337850093841553
        vertex -15.958499908447266 20.45400047302246 -5.337850093841553
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex -15.958499908447266 20.45400047302246 -5.337850093841553
        vertex -16.15850067138672 20.45400047302246 -5.337850093841553
        vertex -15.958499908447266 20.45400047302246 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex -16.15850067138672 20.45400047302246 -5.5378499031066895
        vertex -15.958499908447266 20.45400047302246 -5.5378499031066895
        vertex -16.15850067138672 20.45400047302246 -5.337850093841553
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex -15.958499908447266 20.65399932861328 -5.337850093841553
        vertex -15.958499908447266 20.45400047302246 -5.337850093841553
        vertex -15.958499908447266 20.65399932861328 -5.5378499031066895
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex -15.958499908447266 20.45400047302246 -5.5378499031066895
        vertex -15.958499908447266 20.65399932861328 -5.5378499031066895
        vertex -15.958499908447266 20.45400047302246 -5.337850093841553
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex -16.15850067138672 20.65399932861328 -5.337850093841553
        vertex -15.958499908447266 20.65399932861328 -5.337850093841553
        vertex -16.15850067138672 20.65399932861328 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex -15.958499908447266 20.65399932861328 -5.5378499031066895
        vertex -16.15850067138672 20.65399932861328 -5.5378499031066895
        vertex -15.958499908447266 20.65399932861328 -5.337850093841553
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex -16.15850067138672 20.45400047302246 -5.337850093841553
        vertex -16.15850067138672 20.65399932861328 -5.337850093841553
        vertex -16.15850067138672 20.45400047302246 -5.5378499031066895
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex -16.15850067138672 20.65399932861328 -5.5378499031066895
        vertex -16.15850067138672 20.45400047302246 -5.5378499031066895
        vertex -16.15850067138672 20.65399932861328 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex -16.15850067138672 20.45400047302246 -5.5378499031066895
        vertex -16.15850067138672 20.65399932861328 -5.5378499031066895
        vertex -15.958499908447266 20.45400047302246 -5.5378499031066895
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex -15.958499908447266 20.65399932861328 -5.5378499031066895
        vertex -15.958499908447266 20.45400047302246 -5.5378499031066895
        vertex -16.15850067138672 20.65399932861328 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 15.958499908447266 -20.65399932861328 -5.900000095367432
        vertex 16.15850067138672 -20.65399932861328 -5.900000095367432
        vertex 15.958499908447266 -20.45400047302246 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 16.15850067138672 -20.45400047302246 -5.900000095367432
        vertex 15.958499908447266 -20.45400047302246 -5.900000095367432
        vertex 16.15850067138672 -20.65399932861328 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 16.15850067138672 -20.65399932861328 -5.900000095367432
        vertex 15.958499908447266 -20.65399932861328 -5.900000095367432
        vertex 16.15850067138672 -20.65399932861328 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 15.958499908447266 -20.65399932861328 -6.099999904632568
        vertex 16.15850067138672 -20.65399932861328 -6.099999904632568
        vertex 15.958499908447266 -20.65399932861328 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 16.15850067138672 -20.45400047302246 -5.900000095367432
        vertex 16.15850067138672 -20.65399932861328 -5.900000095367432
        vertex 16.15850067138672 -20.45400047302246 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 16.15850067138672 -20.65399932861328 -6.099999904632568
        vertex 16.15850067138672 -20.45400047302246 -6.099999904632568
        vertex 16.15850067138672 -20.65399932861328 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 15.958499908447266 -20.45400047302246 -5.900000095367432
        vertex 16.15850067138672 -20.45400047302246 -5.900000095367432
        vertex 15.958499908447266 -20.45400047302246 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 16.15850067138672 -20.45400047302246 -6.099999904632568
        vertex 15.958499908447266 -20.45400047302246 -6.099999904632568
        vertex 16.15850067138672 -20.45400047302246 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 15.958499908447266 -20.65399932861328 -5.900000095367432
        vertex 15.958499908447266 -20.45400047302246 -5.900000095367432
        vertex 15.958499908447266 -20.65399932861328 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 15.958499908447266 -20.45400047302246 -6.099999904632568
        vertex 15.958499908447266 -20.65399932861328 -6.099999904632568
        vertex 15.958499908447266 -20.45400047302246 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 15.958499908447266 -20.65399932861328 -6.099999904632568
        vertex 15.958499908447266 -20.45400047302246 -6.099999904632568
        vertex 16.15850067138672 -20.65399932861328 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 16.15850067138672 -20.45400047302246 -6.099999904632568
        vertex 16.15850067138672 -20.65399932861328 -6.099999904632568
        vertex 15.958499908447266 -20.45400047302246 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 11.87969970703125 -15.433300018310547 -5.900000095367432
        vertex 12.079700469970703 -15.433300018310547 -5.900000095367432
        vertex 11.87969970703125 -15.23330020904541 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 12.079700469970703 -15.23330020904541 -5.900000095367432
        vertex 11.87969970703125 -15.23330020904541 -5.900000095367432
        vertex 12.079700469970703 -15.433300018310547 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 12.079700469970703 -15.433300018310547 -5.900000095367432
        vertex 11.87969970703125 -15.433300018310547 -5.900000095367432
        vertex 12.079700469970703 -15.433300018310547 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 11.87969970703125 -15.433300018310547 -6.099999904632568
        vertex 12.079700469970703 -15.433300018310547 -6.099999904632568
        vertex 11.87969970703125 -15.433300018310547 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 12.079700469970703 -15.23330020904541 -5.900000095367432
        vertex 12.079700469970703 -15.433300018310547 -5.900000095367432
        vertex 12.079700469970703 -15.23330020904541 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 12.079700469970703 -15.433300018310547 -6.099999904632568
        vertex 12.079700469970703 -15.23330020904541 -6.099999904632568
        vertex 12.079700469970703 -15.433300018310547 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 11.87969970703125 -15.23330020904541 -5.900000095367432
        vertex 12.079700469970703 -15.23330020904541 -5.900000095367432
        vertex 11.87969970703125 -15.23330020904541 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 12.079700469970703 -15.23330020904541 -6.099999904632568
        vertex 11.87969970703125 -15.23330020904541 -6.099999904632568
        vertex 12.079700469970703 -15.23330020904541 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 11.87969970703125 -15.433300018310547 -5.900000095367432
        vertex 11.87969970703125 -15.23330020904541 -5.900000095367432
        vertex 11.87969970703125 -15.433300018310547 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 11.87969970703125 -15.23330020904541 -6.099999904632568
        vertex 11.87969970703125 -15.433300018310547 -6.099999904632568
        vertex 11.87969970703125 -15.23330020904541 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 11.87969970703125 -15.433300018310547 -6.099999904632568
        vertex 11.87969970703125 -15.23330020904541 -6.099999904632568
        vertex 12.079700469970703 -15.433300018310547 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 12.079700469970703 -15.23330020904541 -6.099999904632568
        vertex 12.079700469970703 -15.433300018310547 -6.099999904632568
        vertex 11.87969970703125 -15.23330020904541 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 5.889860153198242 -7.766670227050781 -5.900000095367432
        vertex 6.089859962463379 -7.766670227050781 -5.900000095367432
        vertex 5.889860153198242 -7.566669940948486 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 6.089859962463379 -7.566669940948486 -5.900000095367432
        vertex 5.889860153198242 -7.566669940948486 -5.900000095367432
        vertex 6.089859962463379 -7.766670227050781 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 6.089859962463379 -7.766670227050781 -5.900000095367432
        vertex 5.889860153198242 -7.766670227050781 -5.900000095367432
        vertex 6.089859962463379 -7.766670227050781 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 5.889860153198242 -7.766670227050781 -6.099999904632568
        vertex 6.089859962463379 -7.766670227050781 -6.099999904632568
        vertex 5.889860153198242 -7.766670227050781 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 6.089859962463379 -7.566669940948486 -5.900000095367432
        vertex 6.089859962463379 -7.766670227050781 -5.900000095367432
        vertex 6.089859962463379 -7.566669940948486 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 6.089859962463379 -7.766670227050781 -6.099999904632568
        vertex 6.089859962463379 -7.566669940948486 -6.099999904632568
        vertex 6.089859962463379 -7.766670227050781 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 5.889860153198242 -7.566669940948486 -5.900000095367432
        vertex 6.089859962463379 -7.566669940948486 -5.900000095367432
        vertex 5.889860153198242 -7.566669940948486 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 6.089859962463379 -7.566669940948486 -6.099999904632568
        vertex 5.889860153198242 -7.566669940948486 -6.099999904632568
        vertex 6.089859962463379 -7.566669940948486 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 5.889860153198242 -7.766670227050781 -5.900000095367432
        vertex 5.889860153198242 -7.566669940948486 -5.900000095367432
        vertex 5.889860153198242 -7.766670227050781 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 5.889860153198242 -7.566669940948486 -6.099999904632568
        vertex 5.889860153198242 -7.766670227050781 -6.099999904632568
        vertex 5.889860153198242 -7.566669940948486 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 5.889860153198242 -7.766670227050781 -6.099999904632568
        vertex 5.889860153198242 -7.566669940948486 -6.099999904632568
        vertex 6.089859962463379 -7.766670227050781 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 6.089859962463379 -7.566669940948486 -6.099999904632568
        vertex 6.089859962463379 -7.766670227050781 -6.099999904632568
        vertex 5.889860153198242 -7.566669940948486 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex -0.10000000149011612 -0.10000000149011612 -5.900000095367432
        vertex 0.10000000149011612 -0.10000000149011612 -5.900000095367432
        vertex -0.10000000149011612 0.10000000149011612 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 0.10000000149011612 0.10000000149011612 -5.900000095367432
        vertex -0.10000000149011612 0.10000000149011612 -5.900000095367432
        vertex 0.10000000149011612 -0.10000000149011612 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 0.10000000149011612 -0.10000000149011612 -5.900000095367432
        vertex -0.10000000149011612 -0.10000000149011612 -5.900000095367432
        vertex 0.10000000149011612 -0.10000000149011612 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex -0.10000000149011612 -0.10000000149011612 -6.099999904632568
        vertex 0.10000000149011612 -0.10000000149011612 -6.099999904632568
        vertex -0.10000000149011612 -0.10000000149011612 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 0.10000000149011612 0.10000000149011612 -5.900000095367432
        vertex 0.10000000149011612 -0.10000000149011612 -5.900000095367432
        vertex 0.10000000149011612 0.10000000149011612 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 0.10000000149011612 -0.10000000149011612 -6.099999904632568
        vertex 0.10000000149011612 0.10000000149011612 -6.099999904632568
        vertex 0.10000000149011612 -0.10000000149011612 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex -0.10000000149011612 0.10000000149011612 -5.900000095367432
        vertex 0.10000000149011612 0.10000000149011612 -5.900000095367432
        vertex -0.10000000149011612 0.10000000149011612 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 0.10000000149011612 0.10000000149011612 -6.099999904632568
        vertex -0.10000000149011612 0.10000000149011612 -6.099999904632568
        vertex 0.10000000149011612 0.10000000149011612 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex -0.10000000149011612 -0.10000000149011612 -5.900000095367432
        vertex -0.10000000149011612 0.10000000149011612 -5.900000095367432
        vertex -0.10000000149011612 -0.10000000149011612 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex -0.10000000149011612 0.10000000149011612 -6.099999904632568
        vertex -0.10000000149011612 -0.10000000149011612 -6.099999904632568
        vertex -0.10000000149011612 0.10000000149011612 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex -0.10000000149011612 -0.10000000149011612 -6.099999904632568
        vertex -0.10000000149011612 0.10000000149011612 -6.099999904632568
        vertex 0.10000000149011612 -0.10000000149011612 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 0.10000000149011612 0.10000000149011612 -6.099999904632568
        vertex 0.10000000149011612 -0.10000000149011612 -6.099999904632568
        vertex -0.10000000149011612 0.10000000149011612 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex -6.089859962463379 7.566669940948486 -5.900000095367432
        vertex -5.889860153198242 7.566669940948486 -5.900000095367432
        vertex -6.089859962463379 7.766670227050781 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex -5.889860153198242 7.766670227050781 -5.900000095367432
        vertex -6.089859962463379 7.766670227050781 -5.900000095367432
        vertex -5.889860153198242 7.566669940948486 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex -5.889860153198242 7.566669940948486 -5.900000095367432
        vertex -6.089859962463379 7.566669940948486 -5.900000095367432
        vertex -5.889860153198242 7.566669940948486 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex -6.089859962463379 7.566669940948486 -6.099999904632568
        vertex -5.889860153198242 7.566669940948486 -6.099999904632568
        vertex -6.089859962463379 7.566669940948486 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex -5.889860153198242 7.766670227050781 -5.900000095367432
        vertex -5.889860153198242 7.566669940948486 -5.900000095367432
        vertex -5.889860153198242 7.766670227050781 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex -5.889860153198242 7.566669940948486 -6.099999904632568
        vertex -5.889860153198242 7.766670227050781 -6.099999904632568
        vertex -5.889860153198242 7.566669940948486 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex -6.089859962463379 7.766670227050781 -5.900000095367432
        vertex -5.889860153198242 7.766670227050781 -5.900000095367432
        vertex -6.089859962463379 7.766670227050781 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex -5.889860153198242 7.766670227050781 -6.099999904632568
        vertex -6.089859962463379 7.766670227050781 -6.099999904632568
        vertex -5.889860153198242 7.766670227050781 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex -6.089859962463379 7.566669940948486 -5.900000095367432
        vertex -6.089859962463379 7.766670227050781 -5.900000095367432
        vertex -6.089859962463379 7.566669940948486 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex -6.089859962463379 7.766670227050781 -6.099999904632568
        vertex -6.089859962463379 7.566669940948486 -6.099999904632568
        vertex -6.089859962463379 7.766670227050781 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex -6.089859962463379 7.566669940948486 -6.099999904632568
        vertex -6.089859962463379 7.766670227050781 -6.099999904632568
        vertex -5.889860153198242 7.566669940948486 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex -5.889860153198242 7.766670227050781 -6.099999904632568
        vertex -5.889860153198242 7.566669940948486 -6.099999904632568
        vertex -6.089859962463379 7.766670227050781 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex -12.079700469970703 15.23330020904541 -5.900000095367432
        vertex -11.87969970703125 15.23330020904541 -5.900000095367432
        vertex -12.079700469970703 15.433300018310547 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex -11.87969970703125 15.433300018310547 -5.900000095367432
        vertex -12.079700469970703 15.433300018310547 -5.900000095367432
        vertex -11.87969970703125 15.23330020904541 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex -11.87969970703125 15.23330020904541 -5.900000095367432
        vertex -12.079700469970703 15.23330020904541 -5.900000095367432
        vertex -11.87969970703125 15.23330020904541 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex -12.079700469970703 15.23330020904541 -6.099999904632568
        vertex -11.87969970703125 15.23330020904541 -6.099999904632568
        vertex -12.079700469970703 15.23330020904541 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex -11.87969970703125 15.433300018310547 -5.900000095367432
        vertex -11.87969970703125 15.23330020904541 -5.900000095367432
        vertex -11.87969970703125 15.433300018310547 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex -11.87969970703125 15.23330020904541 -6.099999904632568
        vertex -11.87969970703125 15.433300018310547 -6.099999904632568
        vertex -11.87969970703125 15.23330020904541 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex -12.079700469970703 15.433300018310547 -5.900000095367432
        vertex -11.87969970703125 15.433300018310547 -5.900000095367432
        vertex -12.079700469970703 15.433300018310547 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex -11.87969970703125 15.433300018310547 -6.099999904632568
        vertex -12.079700469970703 15.433300018310547 -6.099999904632568
        vertex -11.87969970703125 15.433300018310547 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex -12.079700469970703 15.23330020904541 -5.900000095367432
        vertex -12.079700469970703 15.433300018310547 -5.900000095367432
        vertex -12.079700469970703 15.23330020904541 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex -12.079700469970703 15.433300018310547 -6.099999904632568
        vertex -12.079700469970703 15.23330020904541 -6.099999904632568
        vertex -12.079700469970703 15.433300018310547 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex -12.079700469970703 15.23330020904541 -6.099999904632568
        vertex -12.079700469970703 15.433300018310547 -6.099999904632568
        vertex -11.87969970703125 15.23330020904541 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex -11.87969970703125 15.433300018310547 -6.099999904632568
        vertex -11.87969970703125 15.23330020904541 -6.099999904632568
        vertex -12.079700469970703 15.433300018310547 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex -16.15850067138672 20.45400047302246 -5.900000095367432
        vertex -15.958499908447266 20.45400047302246 -5.900000095367432
        vertex -16.15850067138672 20.65399932861328 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex -15.958499908447266 20.65399932861328 -5.900000095367432
        vertex -16.15850067138672 20.65399932861328 -5.900000095367432
        vertex -15.958499908447266 20.45400047302246 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex -15.958499908447266 20.45400047302246 -5.900000095367432
        vertex -16.15850067138672 20.45400047302246 -5.900000095367432
        vertex -15.958499908447266 20.45400047302246 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex -16.15850067138672 20.45400047302246 -6.099999904632568
        vertex -15.958499908447266 20.45400047302246 -6.099999904632568
        vertex -16.15850067138672 20.45400047302246 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex -15.958499908447266 20.65399932861328 -5.900000095367432
        vertex -15.958499908447266 20.45400047302246 -5.900000095367432
        vertex -15.958499908447266 20.65399932861328 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex -15.958499908447266 20.45400047302246 -6.099999904632568
        vertex -15.958499908447266 20.65399932861328 -6.099999904632568
        vertex -15.958499908447266 20.45400047302246 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex -16.15850067138672 20.65399932861328 -5.900000095367432
        vertex -15.958499908447266 20.65399932861328 -5.900000095367432
        vertex -16.15850067138672 20.65399932861328 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex -15.958499908447266 20.65399932861328 -6.099999904632568
        vertex -16.15850067138672 20.65399932861328 -6.099999904632568
        vertex -15.958499908447266 20.65399932861328 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex -16.15850067138672 20.45400047302246 -5.900000095367432
        vertex -16.15850067138672 20.65399932861328 -5.900000095367432
        vertex -16.15850067138672 20.45400047302246 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex -16.15850067138672 20.65399932861328 -6.099999904632568
        vertex -16.15850067138672 20.45400047302246 -6.099999904632568
        vertex -16.15850067138672 20.65399932861328 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex -16.15850067138672 20.45400047302246 -6.099999904632568
        vertex -16.15850067138672 20.65399932861328 -6.099999904632568
        vertex -15.958499908447266 20.45400047302246 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex -15.958499908447266 20.65399932861328 -6.099999904632568
        vertex -15.958499908447266 20.45400047302246 -6.099999904632568
        vertex -16.15850067138672 20.65399932861328 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 15.958499908447266 -20.65399932861328 -5.900000095367432
        vertex 16.15850067138672 -20.65399932861328 -5.900000095367432
        vertex 15.958499908447266 -20.45400047302246 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 16.15850067138672 -20.45400047302246 -5.900000095367432
        vertex 15.958499908447266 -20.45400047302246 -5.900000095367432
        vertex 16.15850067138672 -20.65399932861328 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 16.15850067138672 -20.65399932861328 -5.900000095367432
        vertex 15.958499908447266 -20.65399932861328 -5.900000095367432
        vertex 16.15850067138672 -20.65399932861328 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 15.958499908447266 -20.65399932861328 -6.099999904632568
        vertex 16.15850067138672 -20.65399932861328 -6.099999904632568
        vertex 15.958499908447266 -20.65399932861328 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 16.15850067138672 -20.45400047302246 -5.900000095367432
        vertex 16.15850067138672 -20.65399932861328 -5.900000095367432
        vertex 16.15850067138672 -20.45400047302246 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 16.15850067138672 -20.65399932861328 -6.099999904632568
        vertex 16.15850067138672 -20.45400047302246 -6.099999904632568
        vertex 16.15850067138672 -20.65399932861328 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 15.958499908447266 -20.45400047302246 -5.900000095367432
        vertex 16.15850067138672 -20.45400047302246 -5.900000095367432
        vertex 15.958499908447266 -20.45400047302246 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 16.15850067138672 -20.45400047302246 -6.099999904632568
        vertex 15.958499908447266 -20.45400047302246 -6.099999904632568
        vertex 16.15850067138672 -20.45400047302246 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 15.958499908447266 -20.65399932861328 -5.900000095367432
        vertex 15.958499908447266 -20.45400047302246 -5.900000095367432
        vertex 15.958499908447266 -20.65399932861328 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 15.958499908447266 -20.45400047302246 -6.099999904632568
        vertex 15.958499908447266 -20.65399932861328 -6.099999904632568
        vertex 15.958499908447266 -20.45400047302246 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 15.958499908447266 -20.65399932861328 -6.099999904632568
        vertex 15.958499908447266 -20.45400047302246 -6.099999904632568
        vertex 16.15850067138672 -20.65399932861328 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 16.15850067138672 -20.45400047302246 -6.099999904632568
        vertex 16.15850067138672 -20.65399932861328 -6.099999904632568
        vertex 15.958499908447266 -20.45400047302246 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 11.87969970703125 -15.433300018310547 -5.900000095367432
        vertex 12.079700469970703 -15.433300018310547 -5.900000095367432
        vertex 11.87969970703125 -15.23330020904541 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 12.079700469970703 -15.23330020904541 -5.900000095367432
        vertex 11.87969970703125 -15.23330020904541 -5.900000095367432
        vertex 12.079700469970703 -15.433300018310547 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 12.079700469970703 -15.433300018310547 -5.900000095367432
        vertex 11.87969970703125 -15.433300018310547 -5.900000095367432
        vertex 12.079700469970703 -15.433300018310547 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 11.87969970703125 -15.433300018310547 -6.099999904632568
        vertex 12.079700469970703 -15.433300018310547 -6.099999904632568
        vertex 11.87969970703125 -15.433300018310547 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 12.079700469970703 -15.23330020904541 -5.900000095367432
        vertex 12.079700469970703 -15.433300018310547 -5.900000095367432
        vertex 12.079700469970703 -15.23330020904541 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 12.079700469970703 -15.433300018310547 -6.099999904632568
        vertex 12.079700469970703 -15.23330020904541 -6.099999904632568
        vertex 12.079700469970703 -15.433300018310547 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 11.87969970703125 -15.23330020904541 -5.900000095367432
        vertex 12.079700469970703 -15.23330020904541 -5.900000095367432
        vertex 11.87969970703125 -15.23330020904541 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 12.079700469970703 -15.23330020904541 -6.099999904632568
        vertex 11.87969970703125 -15.23330020904541 -6.099999904632568
        vertex 12.079700469970703 -15.23330020904541 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 11.87969970703125 -15.433300018310547 -5.900000095367432
        vertex 11.87969970703125 -15.23330020904541 -5.900000095367432
        vertex 11.87969970703125 -15.433300018310547 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 11.87969970703125 -15.23330020904541 -6.099999904632568
        vertex 11.87969970703125 -15.433300018310547 -6.099999904632568
        vertex 11.87969970703125 -15.23330020904541 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 11.87969970703125 -15.433300018310547 -6.099999904632568
        vertex 11.87969970703125 -15.23330020904541 -6.099999904632568
        vertex 12.079700469970703 -15.433300018310547 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 12.079700469970703 -15.23330020904541 -6.099999904632568
        vertex 12.079700469970703 -15.433300018310547 -6.099999904632568
        vertex 11.87969970703125 -15.23330020904541 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 5.889860153198242 -7.766670227050781 -5.900000095367432
        vertex 6.089859962463379 -7.766670227050781 -5.900000095367432
        vertex 5.889860153198242 -7.566669940948486 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 6.089859962463379 -7.566669940948486 -5.900000095367432
        vertex 5.889860153198242 -7.566669940948486 -5.900000095367432
        vertex 6.089859962463379 -7.766670227050781 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 6.089859962463379 -7.766670227050781 -5.900000095367432
        vertex 5.889860153198242 -7.766670227050781 -5.900000095367432
        vertex 6.089859962463379 -7.766670227050781 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 5.889860153198242 -7.766670227050781 -6.099999904632568
        vertex 6.089859962463379 -7.766670227050781 -6.099999904632568
        vertex 5.889860153198242 -7.766670227050781 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 6.089859962463379 -7.566669940948486 -5.900000095367432
        vertex 6.089859962463379 -7.766670227050781 -5.900000095367432
        vertex 6.089859962463379 -7.566669940948486 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 6.089859962463379 -7.766670227050781 -6.099999904632568
        vertex 6.089859962463379 -7.566669940948486 -6.099999904632568
        vertex 6.089859962463379 -7.766670227050781 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 5.889860153198242 -7.566669940948486 -5.900000095367432
        vertex 6.089859962463379 -7.566669940948486 -5.900000095367432
        vertex 5.889860153198242 -7.566669940948486 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 6.089859962463379 -7.566669940948486 -6.099999904632568
        vertex 5.889860153198242 -7.566669940948486 -6.099999904632568
        vertex 6.089859962463379 -7.566669940948486 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 5.889860153198242 -7.766670227050781 -5.900000095367432
        vertex 5.889860153198242 -7.566669940948486 -5.900000095367432
        vertex 5.889860153198242 -7.766670227050781 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 5.889860153198242 -7.566669940948486 -6.099999904632568
        vertex 5.889860153198242 -7.766670227050781 -6.099999904632568
        vertex 5.889860153198242 -7.566669940948486 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 5.889860153198242 -7.766670227050781 -6.099999904632568
        vertex 5.889860153198242 -7.566669940948486 -6.099999904632568
        vertex 6.089859962463379 -7.766670227050781 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 6.089859962463379 -7.566669940948486 -6.099999904632568
        vertex 6.089859962463379 -7.766670227050781 -6.099999904632568
        vertex 5.889860153198242 -7.566669940948486 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex -0.10000000149011612 -0.10000000149011612 -5.900000095367432
        vertex 0.10000000149011612 -0.10000000149011612 -5.900000095367432
        vertex -0.10000000149011612 0.10000000149011612 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 0.10000000149011612 0.10000000149011612 -5.900000095367432
        vertex -0.10000000149011612 0.10000000149011612 -5.900000095367432
        vertex 0.10000000149011612 -0.10000000149011612 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 0.10000000149011612 -0.10000000149011612 -5.900000095367432
        vertex -0.10000000149011612 -0.10000000149011612 -5.900000095367432
        vertex 0.10000000149011612 -0.10000000149011612 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex -0.10000000149011612 -0.10000000149011612 -6.099999904632568
        vertex 0.10000000149011612 -0.10000000149011612 -6.099999904632568
        vertex -0.10000000149011612 -0.10000000149011612 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 0.10000000149011612 0.10000000149011612 -5.900000095367432
        vertex 0.10000000149011612 -0.10000000149011612 -5.900000095367432
        vertex 0.10000000149011612 0.10000000149011612 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 0.10000000149011612 -0.10000000149011612 -6.099999904632568
        vertex 0.10000000149011612 0.10000000149011612 -6.099999904632568
        vertex 0.10000000149011612 -0.10000000149011612 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex -0.10000000149011612 0.10000000149011612 -5.900000095367432
        vertex 0.10000000149011612 0.10000000149011612 -5.900000095367432
        vertex -0.10000000149011612 0.10000000149011612 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 0.10000000149011612 0.10000000149011612 -6.099999904632568
        vertex -0.10000000149011612 0.10000000149011612 -6.099999904632568
        vertex 0.10000000149011612 0.10000000149011612 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex -0.10000000149011612 -0.10000000149011612 -5.900000095367432
        vertex -0.10000000149011612 0.10000000149011612 -5.900000095367432
        vertex -0.10000000149011612 -0.10000000149011612 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex -0.10000000149011612 0.10000000149011612 -6.099999904632568
        vertex -0.10000000149011612 -0.10000000149011612 -6.099999904632568
        vertex -0.10000000149011612 0.10000000149011612 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex -0.10000000149011612 -0.10000000149011612 -6.099999904632568
        vertex -0.10000000149011612 0.10000000149011612 -6.099999904632568
        vertex 0.10000000149011612 -0.10000000149011612 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 0.10000000149011612 0.10000000149011612 -6.099999904632568
        vertex 0.10000000149011612 -0.10000000149011612 -6.099999904632568
        vertex -0.10000000149011612 0.10000000149011612 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex -6.089859962463379 7.566669940948486 -5.900000095367432
        vertex -5.889860153198242 7.566669940948486 -5.900000095367432
        vertex -6.089859962463379 7.766670227050781 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex -5.889860153198242 7.766670227050781 -5.900000095367432
        vertex -6.089859962463379 7.766670227050781 -5.900000095367432
        vertex -5.889860153198242 7.566669940948486 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex -5.889860153198242 7.566669940948486 -5.900000095367432
        vertex -6.089859962463379 7.566669940948486 -5.900000095367432
        vertex -5.889860153198242 7.566669940948486 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex -6.089859962463379 7.566669940948486 -6.099999904632568
        vertex -5.889860153198242 7.566669940948486 -6.099999904632568
        vertex -6.089859962463379 7.566669940948486 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex -5.889860153198242 7.766670227050781 -5.900000095367432
        vertex -5.889860153198242 7.566669940948486 -5.900000095367432
        vertex -5.889860153198242 7.766670227050781 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex -5.889860153198242 7.566669940948486 -6.099999904632568
        vertex -5.889860153198242 7.766670227050781 -6.099999904632568
        vertex -5.889860153198242 7.566669940948486 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex -6.089859962463379 7.766670227050781 -5.900000095367432
        vertex -5.889860153198242 7.766670227050781 -5.900000095367432
        vertex -6.089859962463379 7.766670227050781 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex -5.889860153198242 7.766670227050781 -6.099999904632568
        vertex -6.089859962463379 7.766670227050781 -6.099999904632568
        vertex -5.889860153198242 7.766670227050781 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex -6.089859962463379 7.566669940948486 -5.900000095367432
        vertex -6.089859962463379 7.766670227050781 -5.900000095367432
        vertex -6.089859962463379 7.566669940948486 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex -6.089859962463379 7.766670227050781 -6.099999904632568
        vertex -6.089859962463379 7.566669940948486 -6.099999904632568
        vertex -6.089859962463379 7.766670227050781 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex -6.089859962463379 7.566669940948486 -6.099999904632568
        vertex -6.089859962463379 7.766670227050781 -6.099999904632568
        vertex -5.889860153198242 7.566669940948486 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex -5.889860153198242 7.766670227050781 -6.099999904632568
        vertex -5.889860153198242 7.566669940948486 -6.099999904632568
        vertex -6.089859962463379 7.766670227050781 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex -12.079700469970703 15.23330020904541 -5.900000095367432
        vertex -11.87969970703125 15.23330020904541 -5.900000095367432
        vertex -12.079700469970703 15.433300018310547 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex -11.87969970703125 15.433300018310547 -5.900000095367432
        vertex -12.079700469970703 15.433300018310547 -5.900000095367432
        vertex -11.87969970703125 15.23330020904541 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex -11.87969970703125 15.23330020904541 -5.900000095367432
        vertex -12.079700469970703 15.23330020904541 -5.900000095367432
        vertex -11.87969970703125 15.23330020904541 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex -12.079700469970703 15.23330020904541 -6.099999904632568
        vertex -11.87969970703125 15.23330020904541 -6.099999904632568
        vertex -12.079700469970703 15.23330020904541 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex -11.87969970703125 15.433300018310547 -5.900000095367432
        vertex -11.87969970703125 15.23330020904541 -5.900000095367432
        vertex -11.87969970703125 15.433300018310547 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex -11.87969970703125 15.23330020904541 -6.099999904632568
        vertex -11.87969970703125 15.433300018310547 -6.099999904632568
        vertex -11.87969970703125 15.23330020904541 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex -12.079700469970703 15.433300018310547 -5.900000095367432
        vertex -11.87969970703125 15.433300018310547 -5.900000095367432
        vertex -12.079700469970703 15.433300018310547 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex -11.87969970703125 15.433300018310547 -6.099999904632568
        vertex -12.079700469970703 15.433300018310547 -6.099999904632568
        vertex -11.87969970703125 15.433300018310547 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex -12.079700469970703 15.23330020904541 -5.900000095367432
        vertex -12.079700469970703 15.433300018310547 -5.900000095367432
        vertex -12.079700469970703 15.23330020904541 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex -12.079700469970703 15.433300018310547 -6.099999904632568
        vertex -12.079700469970703 15.23330020904541 -6.099999904632568
        vertex -12.079700469970703 15.433300018310547 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex -12.079700469970703 15.23330020904541 -6.099999904632568
        vertex -12.079700469970703 15.433300018310547 -6.099999904632568
        vertex -11.87969970703125 15.23330020904541 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex -11.87969970703125 15.433300018310547 -6.099999904632568
        vertex -11.87969970703125 15.23330020904541 -6.099999904632568
        vertex -12.079700469970703 15.433300018310547 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex -16.15850067138672 20.45400047302246 -5.900000095367432
        vertex -15.958499908447266 20.45400047302246 -5.900000095367432
        vertex -16.15850067138672 20.65399932861328 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex -15.958499908447266 20.65399932861328 -5.900000095367432
        vertex -16.15850067138672 20.65399932861328 -5.900000095367432
        vertex -15.958499908447266 20.45400047302246 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex -15.958499908447266 20.45400047302246 -5.900000095367432
        vertex -16.15850067138672 20.45400047302246 -5.900000095367432
        vertex -15.958499908447266 20.45400047302246 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex -16.15850067138672 20.45400047302246 -6.099999904632568
        vertex -15.958499908447266 20.45400047302246 -6.099999904632568
        vertex -16.15850067138672 20.45400047302246 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex -15.958499908447266 20.65399932861328 -5.900000095367432
        vertex -15.958499908447266 20.45400047302246 -5.900000095367432
        vertex -15.958499908447266 20.65399932861328 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex -15.958499908447266 20.45400047302246 -6.099999904632568
        vertex -15.958499908447266 20.65399932861328 -6.099999904632568
        vertex -15.958499908447266 20.45400047302246 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex -16.15850067138672 20.65399932861328 -5.900000095367432
        vertex -15.958499908447266 20.65399932861328 -5.900000095367432
        vertex -16.15850067138672 20.65399932861328 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex -15.958499908447266 20.65399932861328 -6.099999904632568
        vertex -16.15850067138672 20.65399932861328 -6.099999904632568
        vertex -15.958499908447266 20.65399932861328 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex -16.15850067138672 20.45400047302246 -5.900000095367432
        vertex -16.15850067138672 20.65399932861328 -5.900000095367432
        vertex -16.15850067138672 20.45400047302246 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex -16.15850067138672 20.65399932861328 -6.099999904632568
        vertex -16.15850067138672 20.45400047302246 -6.099999904632568
        vertex -16.15850067138672 20.65399932861328 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex -16.15850067138672 20.45400047302246 -6.099999904632568
        vertex -16.15850067138672 20.65399932861328 -6.099999904632568
        vertex -15.958499908447266 20.45400047302246 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex -15.958499908447266 20.65399932861328 -6.099999904632568
        vertex -15.958499908447266 20.45400047302246 -6.099999904632568
        vertex -16.15850067138672 20.65399932861328 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 155.4429931640625 -12.314200401306152 -5.337850093841553
        vertex 155.64300537109375 -12.314200401306152 -5.337850093841553
        vertex 155.4429931640625 -12.1141996383667 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 155.64300537109375 -12.1141996383667 -5.337850093841553
        vertex 155.4429931640625 -12.1141996383667 -5.337850093841553
        vertex 155.64300537109375 -12.314200401306152 -5.337850093841553
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 155.64300537109375 -12.314200401306152 -5.337850093841553
        vertex 155.4429931640625 -12.314200401306152 -5.337850093841553
        vertex 155.64300537109375 -12.314200401306152 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 155.4429931640625 -12.314200401306152 -5.5378499031066895
        vertex 155.64300537109375 -12.314200401306152 -5.5378499031066895
        vertex 155.4429931640625 -12.314200401306152 -5.337850093841553
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 155.64300537109375 -12.1141996383667 -5.337850093841553
        vertex 155.64300537109375 -12.314200401306152 -5.337850093841553
        vertex 155.64300537109375 -12.1141996383667 -5.5378499031066895
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 155.64300537109375 -12.314200401306152 -5.5378499031066895
        vertex 155.64300537109375 -12.1141996383667 -5.5378499031066895
        vertex 155.64300537109375 -12.314200401306152 -5.337850093841553
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 155.4429931640625 -12.1141996383667 -5.337850093841553
        vertex 155.64300537109375 -12.1141996383667 -5.337850093841553
        vertex 155.4429931640625 -12.1141996383667 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 155.64300537109375 -12.1141996383667 -5.5378499031066895
        vertex 155.4429931640625 -12.1141996383667 -5.5378499031066895
        vertex 155.64300537109375 -12.1141996383667 -5.337850093841553
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 155.4429931640625 -12.314200401306152 -5.337850093841553
        vertex 155.4429931640625 -12.1141996383667 -5.337850093841553
        vertex 155.4429931640625 -12.314200401306152 -5.5378499031066895
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 155.4429931640625 -12.1141996383667 -5.5378499031066895
        vertex 155.4429931640625 -12.314200401306152 -5.5378499031066895
        vertex 155.4429931640625 -12.1141996383667 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 155.4429931640625 -12.314200401306152 -5.5378499031066895
        vertex 155.4429931640625 -12.1141996383667 -5.5378499031066895
        vertex 155.64300537109375 -12.314200401306152 -5.5378499031066895
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 155.64300537109375 -12.1141996383667 -5.5378499031066895
        vertex 155.64300537109375 -12.314200401306152 -5.5378499031066895
        vertex 155.4429931640625 -12.1141996383667 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 155.4429931640625 -12.314200401306152 -5.900000095367432
        vertex 155.64300537109375 -12.314200401306152 -5.900000095367432
        vertex 155.4429931640625 -12.1141996383667 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 155.64300537109375 -12.1141996383667 -5.900000095367432
        vertex 155.4429931640625 -12.1141996383667 -5.900000095367432
        vertex 155.64300537109375 -12.314200401306152 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 155.64300537109375 -12.314200401306152 -5.900000095367432
        vertex 155.4429931640625 -12.314200401306152 -5.900000095367432
        vertex 155.64300537109375 -12.314200401306152 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 155.4429931640625 -12.314200401306152 -6.099999904632568
        vertex 155.64300537109375 -12.314200401306152 -6.099999904632568
        vertex 155.4429931640625 -12.314200401306152 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 155.64300537109375 -12.1141996383667 -5.900000095367432
        vertex 155.64300537109375 -12.314200401306152 -5.900000095367432
        vertex 155.64300537109375 -12.1141996383667 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 155.64300537109375 -12.314200401306152 -6.099999904632568
        vertex 155.64300537109375 -12.1141996383667 -6.099999904632568
        vertex 155.64300537109375 -12.314200401306152 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 155.4429931640625 -12.1141996383667 -5.900000095367432
        vertex 155.64300537109375 -12.1141996383667 -5.900000095367432
        vertex 155.4429931640625 -12.1141996383667 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 155.64300537109375 -12.1141996383667 -6.099999904632568
        vertex 155.4429931640625 -12.1141996383667 -6.099999904632568
        vertex 155.64300537109375 -12.1141996383667 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 155.4429931640625 -12.314200401306152 -5.900000095367432
        vertex 155.4429931640625 -12.1141996383667 -5.900000095367432
        vertex 155.4429931640625 -12.314200401306152 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 155.4429931640625 -12.1141996383667 -6.099999904632568
        vertex 155.4429931640625 -12.314200401306152 -6.099999904632568
        vertex 155.4429931640625 -12.1141996383667 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 155.4429931640625 -12.314200401306152 -6.099999904632568
        vertex 155.4429931640625 -12.1141996383667 -6.099999904632568
        vertex 155.64300537109375 -12.314200401306152 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 155.64300537109375 -12.1141996383667 -6.099999904632568
        vertex 155.64300537109375 -12.314200401306152 -6.099999904632568
        vertex 155.4429931640625 -12.1141996383667 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 136.35699462890625 12.1141996383667 -5.337850093841553
        vertex 136.5570068359375 12.1141996383667 -5.337850093841553
        vertex 136.35699462890625 12.314200401306152 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 136.5570068359375 12.314200401306152 -5.337850093841553
        vertex 136.35699462890625 12.314200401306152 -5.337850093841553
        vertex 136.5570068359375 12.1141996383667 -5.337850093841553
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 136.5570068359375 12.1141996383667 -5.337850093841553
        vertex 136.35699462890625 12.1141996383667 -5.337850093841553
        vertex 136.5570068359375 12.1141996383667 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 136.35699462890625 12.1141996383667 -5.5378499031066895
        vertex 136.5570068359375 12.1141996383667 -5.5378499031066895
        vertex 136.35699462890625 12.1141996383667 -5.337850093841553
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 136.5570068359375 12.314200401306152 -5.337850093841553
        vertex 136.5570068359375 12.1141996383667 -5.337850093841553
        vertex 136.5570068359375 12.314200401306152 -5.5378499031066895
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 136.5570068359375 12.1141996383667 -5.5378499031066895
        vertex 136.5570068359375 12.314200401306152 -5.5378499031066895
        vertex 136.5570068359375 12.1141996383667 -5.337850093841553
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 136.35699462890625 12.314200401306152 -5.337850093841553
        vertex 136.5570068359375 12.314200401306152 -5.337850093841553
        vertex 136.35699462890625 12.314200401306152 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 136.5570068359375 12.314200401306152 -5.5378499031066895
        vertex 136.35699462890625 12.314200401306152 -5.5378499031066895
        vertex 136.5570068359375 12.314200401306152 -5.337850093841553
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 136.35699462890625 12.1141996383667 -5.337850093841553
        vertex 136.35699462890625 12.314200401306152 -5.337850093841553
        vertex 136.35699462890625 12.1141996383667 -5.5378499031066895
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 136.35699462890625 12.314200401306152 -5.5378499031066895
        vertex 136.35699462890625 12.1141996383667 -5.5378499031066895
        vertex 136.35699462890625 12.314200401306152 -5.337850093841553
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 136.35699462890625 12.1141996383667 -5.5378499031066895
        vertex 136.35699462890625 12.314200401306152 -5.5378499031066895
        vertex 136.5570068359375 12.1141996383667 -5.5378499031066895
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 136.5570068359375 12.314200401306152 -5.5378499031066895
        vertex 136.5570068359375 12.1141996383667 -5.5378499031066895
        vertex 136.35699462890625 12.314200401306152 -5.5378499031066895
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 136.35699462890625 12.1141996383667 -5.900000095367432
        vertex 136.5570068359375 12.1141996383667 -5.900000095367432
        vertex 136.35699462890625 12.314200401306152 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 136.5570068359375 12.314200401306152 -5.900000095367432
        vertex 136.35699462890625 12.314200401306152 -5.900000095367432
        vertex 136.5570068359375 12.1141996383667 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 136.5570068359375 12.1141996383667 -5.900000095367432
        vertex 136.35699462890625 12.1141996383667 -5.900000095367432
        vertex 136.5570068359375 12.1141996383667 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 136.35699462890625 12.1141996383667 -6.099999904632568
        vertex 136.5570068359375 12.1141996383667 -6.099999904632568
        vertex 136.35699462890625 12.1141996383667 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 136.5570068359375 12.314200401306152 -5.900000095367432
        vertex 136.5570068359375 12.1141996383667 -5.900000095367432
        vertex 136.5570068359375 12.314200401306152 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 136.5570068359375 12.1141996383667 -6.099999904632568
        vertex 136.5570068359375 12.314200401306152 -6.099999904632568
        vertex 136.5570068359375 12.1141996383667 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 136.35699462890625 12.314200401306152 -5.900000095367432
        vertex 136.5570068359375 12.314200401306152 -5.900000095367432
        vertex 136.35699462890625 12.314200401306152 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 136.5570068359375 12.314200401306152 -6.099999904632568
        vertex 136.35699462890625 12.314200401306152 -6.099999904632568
        vertex 136.5570068359375 12.314200401306152 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 136.35699462890625 12.1141996383667 -5.900000095367432
        vertex 136.35699462890625 12.314200401306152 -5.900000095367432
        vertex 136.35699462890625 12.1141996383667 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 136.35699462890625 12.314200401306152 -6.099999904632568
        vertex 136.35699462890625 12.1141996383667 -6.099999904632568
        vertex 136.35699462890625 12.314200401306152 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 136.35699462890625 12.1141996383667 -6.099999904632568
        vertex 136.35699462890625 12.314200401306152 -6.099999904632568
        vertex 136.5570068359375 12.1141996383667 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 136.5570068359375 12.314200401306152 -6.099999904632568
        vertex 136.5570068359375 12.1141996383667 -6.099999904632568
        vertex 136.35699462890625 12.314200401306152 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 155.4429931640625 -12.314200401306152 -5.900000095367432
        vertex 155.64300537109375 -12.314200401306152 -5.900000095367432
        vertex 155.4429931640625 -12.1141996383667 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 155.64300537109375 -12.1141996383667 -5.900000095367432
        vertex 155.4429931640625 -12.1141996383667 -5.900000095367432
        vertex 155.64300537109375 -12.314200401306152 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 155.64300537109375 -12.314200401306152 -5.900000095367432
        vertex 155.4429931640625 -12.314200401306152 -5.900000095367432
        vertex 155.64300537109375 -12.314200401306152 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 155.4429931640625 -12.314200401306152 -6.099999904632568
        vertex 155.64300537109375 -12.314200401306152 -6.099999904632568
        vertex 155.4429931640625 -12.314200401306152 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 155.64300537109375 -12.1141996383667 -5.900000095367432
        vertex 155.64300537109375 -12.314200401306152 -5.900000095367432
        vertex 155.64300537109375 -12.1141996383667 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 155.64300537109375 -12.314200401306152 -6.099999904632568
        vertex 155.64300537109375 -12.1141996383667 -6.099999904632568
        vertex 155.64300537109375 -12.314200401306152 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 155.4429931640625 -12.1141996383667 -5.900000095367432
        vertex 155.64300537109375 -12.1141996383667 -5.900000095367432
        vertex 155.4429931640625 -12.1141996383667 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 155.64300537109375 -12.1141996383667 -6.099999904632568
        vertex 155.4429931640625 -12.1141996383667 -6.099999904632568
        vertex 155.64300537109375 -12.1141996383667 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 155.4429931640625 -12.314200401306152 -5.900000095367432
        vertex 155.4429931640625 -12.1141996383667 -5.900000095367432
        vertex 155.4429931640625 -12.314200401306152 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 155.4429931640625 -12.1141996383667 -6.099999904632568
        vertex 155.4429931640625 -12.314200401306152 -6.099999904632568
        vertex 155.4429931640625 -12.1141996383667 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 155.4429931640625 -12.314200401306152 -6.099999904632568
        vertex 155.4429931640625 -12.1141996383667 -6.099999904632568
        vertex 155.64300537109375 -12.314200401306152 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 155.64300537109375 -12.1141996383667 -6.099999904632568
        vertex 155.64300537109375 -12.314200401306152 -6.099999904632568
        vertex 155.4429931640625 -12.1141996383667 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 155.4429931640625 -12.314200401306152 -35.900001525878906
        vertex 155.64300537109375 -12.314200401306152 -35.900001525878906
        vertex 155.4429931640625 -12.1141996383667 -35.900001525878906
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 155.64300537109375 -12.1141996383667 -35.900001525878906
        vertex 155.4429931640625 -12.1141996383667 -35.900001525878906
        vertex 155.64300537109375 -12.314200401306152 -35.900001525878906
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 155.64300537109375 -12.314200401306152 -35.900001525878906
        vertex 155.4429931640625 -12.314200401306152 -35.900001525878906
        vertex 155.64300537109375 -12.314200401306152 -36.099998474121094
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 155.4429931640625 -12.314200401306152 -36.099998474121094
        vertex 155.64300537109375 -12.314200401306152 -36.099998474121094
        vertex 155.4429931640625 -12.314200401306152 -35.900001525878906
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 155.64300537109375 -12.1141996383667 -35.900001525878906
        vertex 155.64300537109375 -12.314200401306152 -35.900001525878906
        vertex 155.64300537109375 -12.1141996383667 -36.099998474121094
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 155.64300537109375 -12.314200401306152 -36.099998474121094
        vertex 155.64300537109375 -12.1141996383667 -36.099998474121094
        vertex 155.64300537109375 -12.314200401306152 -35.900001525878906
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 155.4429931640625 -12.1141996383667 -35.900001525878906
        vertex 155.64300537109375 -12.1141996383667 -35.900001525878906
        vertex 155.4429931640625 -12.1141996383667 -36.099998474121094
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 155.64300537109375 -12.1141996383667 -36.099998474121094
        vertex 155.4429931640625 -12.1141996383667 -36.099998474121094
        vertex 155.64300537109375 -12.1141996383667 -35.900001525878906
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 155.4429931640625 -12.314200401306152 -35.900001525878906
        vertex 155.4429931640625 -12.1141996383667 -35.900001525878906
        vertex 155.4429931640625 -12.314200401306152 -36.099998474121094
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 155.4429931640625 -12.1141996383667 -36.099998474121094
        vertex 155.4429931640625 -12.314200401306152 -36.099998474121094
        vertex 155.4429931640625 -12.1141996383667 -35.900001525878906
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 155.4429931640625 -12.314200401306152 -36.099998474121094
        vertex 155.4429931640625 -12.1141996383667 -36.099998474121094
        vertex 155.64300537109375 -12.314200401306152 -36.099998474121094
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 155.64300537109375 -12.1141996383667 -36.099998474121094
        vertex 155.64300537109375 -12.314200401306152 -36.099998474121094
        vertex 155.4429931640625 -12.1141996383667 -36.099998474121094
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 136.35699462890625 12.1141996383667 -5.900000095367432
        vertex 136.5570068359375 12.1141996383667 -5.900000095367432
        vertex 136.35699462890625 12.314200401306152 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 136.5570068359375 12.314200401306152 -5.900000095367432
        vertex 136.35699462890625 12.314200401306152 -5.900000095367432
        vertex 136.5570068359375 12.1141996383667 -5.900000095367432
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 136.5570068359375 12.1141996383667 -5.900000095367432
        vertex 136.35699462890625 12.1141996383667 -5.900000095367432
        vertex 136.5570068359375 12.1141996383667 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 136.35699462890625 12.1141996383667 -6.099999904632568
        vertex 136.5570068359375 12.1141996383667 -6.099999904632568
        vertex 136.35699462890625 12.1141996383667 -5.900000095367432
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 136.5570068359375 12.314200401306152 -5.900000095367432
        vertex 136.5570068359375 12.1141996383667 -5.900000095367432
        vertex 136.5570068359375 12.314200401306152 -6.099999904632568
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 136.5570068359375 12.1141996383667 -6.099999904632568
        vertex 136.5570068359375 12.314200401306152 -6.099999904632568
        vertex 136.5570068359375 12.1141996383667 -5.900000095367432
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 136.35699462890625 12.314200401306152 -5.900000095367432
        vertex 136.5570068359375 12.314200401306152 -5.900000095367432
        vertex 136.35699462890625 12.314200401306152 -6.099999904632568
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 136.5570068359375 12.314200401306152 -6.099999904632568
        vertex 136.35699462890625 12.314200401306152 -6.099999904632568
        vertex 136.5570068359375 12.314200401306152 -5.900000095367432
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 136.35699462890625 12.1141996383667 -5.900000095367432
        vertex 136.35699462890625 12.314200401306152 -5.900000095367432
        vertex 136.35699462890625 12.1141996383667 -6.099999904632568
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 136.35699462890625 12.314200401306152 -6.099999904632568
        vertex 136.35699462890625 12.1141996383667 -6.099999904632568
        vertex 136.35699462890625 12.314200401306152 -5.900000095367432
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 136.35699462890625 12.1141996383667 -6.099999904632568
        vertex 136.35699462890625 12.314200401306152 -6.099999904632568
        vertex 136.5570068359375 12.1141996383667 -6.099999904632568
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 136.5570068359375 12.314200401306152 -6.099999904632568
        vertex 136.5570068359375 12.1141996383667 -6.099999904632568
        vertex 136.35699462890625 12.314200401306152 -6.099999904632568
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 136.35699462890625 12.1141996383667 -35.900001525878906
        vertex 136.5570068359375 12.1141996383667 -35.900001525878906
        vertex 136.35699462890625 12.314200401306152 -35.900001525878906
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 136.5570068359375 12.314200401306152 -35.900001525878906
        vertex 136.35699462890625 12.314200401306152 -35.900001525878906
        vertex 136.5570068359375 12.1141996383667 -35.900001525878906
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 136.5570068359375 12.1141996383667 -35.900001525878906
        vertex 136.35699462890625 12.1141996383667 -35.900001525878906
        vertex 136.5570068359375 12.1141996383667 -36.099998474121094
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 136.35699462890625 12.1141996383667 -36.099998474121094
        vertex 136.5570068359375 12.1141996383667 -36.099998474121094
        vertex 136.35699462890625 12.1141996383667 -35.900001525878906
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 136.5570068359375 12.314200401306152 -35.900001525878906
        vertex 136.5570068359375 12.1141996383667 -35.900001525878906
        vertex 136.5570068359375 12.314200401306152 -36.099998474121094
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 136.5570068359375 12.1141996383667 -36.099998474121094
        vertex 136.5570068359375 12.314200401306152 -36.099998474121094
        vertex 136.5570068359375 12.1141996383667 -35.900001525878906
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 136.35699462890625 12.314200401306152 -35.900001525878906
        vertex 136.5570068359375 12.314200401306152 -35.900001525878906
        vertex 136.35699462890625 12.314200401306152 -36.099998474121094
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 136.5570068359375 12.314200401306152 -36.099998474121094
        vertex 136.35699462890625 12.314200401306152 -36.099998474121094
        vertex 136.5570068359375 12.314200401306152 -35.900001525878906
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 136.35699462890625 12.1141996383667 -35.900001525878906
        vertex 136.35699462890625 12.314200401306152 -35.900001525878906
        vertex 136.35699462890625 12.1141996383667 -36.099998474121094
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 136.35699462890625 12.314200401306152 -36.099998474121094
        vertex 136.35699462890625 12.1141996383667 -36.099998474121094
        vertex 136.35699462890625 12.314200401306152 -35.900001525878906
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 136.35699462890625 12.1141996383667 -36.099998474121094
        vertex 136.35699462890625 12.314200401306152 -36.099998474121094
        vertex 136.5570068359375 12.1141996383667 -36.099998474121094
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 136.5570068359375 12.314200401306152 -36.099998474121094
        vertex 136.5570068359375 12.1141996383667 -36.099998474121094
        vertex 136.35699462890625 12.314200401306152 -36.099998474121094
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 264.8999938964844 -0.10000000149011612 0.10000000149011612
        vertex 265.1000061035156 -0.10000000149011612 0.10000000149011612
        vertex 264.8999938964844 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 265.1000061035156 0.10000000149011612 0.10000000149011612
        vertex 264.8999938964844 0.10000000149011612 0.10000000149011612
        vertex 265.1000061035156 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 265.1000061035156 -0.10000000149011612 0.10000000149011612
        vertex 264.8999938964844 -0.10000000149011612 0.10000000149011612
        vertex 265.1000061035156 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 264.8999938964844 -0.10000000149011612 -0.10000000149011612
        vertex 265.1000061035156 -0.10000000149011612 -0.10000000149011612
        vertex 264.8999938964844 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 265.1000061035156 0.10000000149011612 0.10000000149011612
        vertex 265.1000061035156 -0.10000000149011612 0.10000000149011612
        vertex 265.1000061035156 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 265.1000061035156 -0.10000000149011612 -0.10000000149011612
        vertex 265.1000061035156 0.10000000149011612 -0.10000000149011612
        vertex 265.1000061035156 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 264.8999938964844 0.10000000149011612 0.10000000149011612
        vertex 265.1000061035156 0.10000000149011612 0.10000000149011612
        vertex 264.8999938964844 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 265.1000061035156 0.10000000149011612 -0.10000000149011612
        vertex 264.8999938964844 0.10000000149011612 -0.10000000149011612
        vertex 265.1000061035156 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 264.8999938964844 -0.10000000149011612 0.10000000149011612
        vertex 264.8999938964844 0.10000000149011612 0.10000000149011612
        vertex 264.8999938964844 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 264.8999938964844 0.10000000149011612 -0.10000000149011612
        vertex 264.8999938964844 -0.10000000149011612 -0.10000000149011612
        vertex 264.8999938964844 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 264.8999938964844 -0.10000000149011612 -0.10000000149011612
        vertex 264.8999938964844 0.10000000149011612 -0.10000000149011612
        vertex 265.1000061035156 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 265.1000061035156 0.10000000149011612 -0.10000000149011612
        vertex 265.1000061035156 -0.10000000149011612 -0.10000000149011612
        vertex 264.8999938964844 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 254.98300170898438 -0.10000000149011612 0.10000000149011612
        vertex 255.18299865722656 -0.10000000149011612 0.10000000149011612
        vertex 254.98300170898438 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 255.18299865722656 0.10000000149011612 0.10000000149011612
        vertex 254.98300170898438 0.10000000149011612 0.10000000149011612
        vertex 255.18299865722656 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 255.18299865722656 -0.10000000149011612 0.10000000149011612
        vertex 254.98300170898438 -0.10000000149011612 0.10000000149011612
        vertex 255.18299865722656 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 254.98300170898438 -0.10000000149011612 -0.10000000149011612
        vertex 255.18299865722656 -0.10000000149011612 -0.10000000149011612
        vertex 254.98300170898438 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 255.18299865722656 0.10000000149011612 0.10000000149011612
        vertex 255.18299865722656 -0.10000000149011612 0.10000000149011612
        vertex 255.18299865722656 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 255.18299865722656 -0.10000000149011612 -0.10000000149011612
        vertex 255.18299865722656 0.10000000149011612 -0.10000000149011612
        vertex 255.18299865722656 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 254.98300170898438 0.10000000149011612 0.10000000149011612
        vertex 255.18299865722656 0.10000000149011612 0.10000000149011612
        vertex 254.98300170898438 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 255.18299865722656 0.10000000149011612 -0.10000000149011612
        vertex 254.98300170898438 0.10000000149011612 -0.10000000149011612
        vertex 255.18299865722656 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 254.98300170898438 -0.10000000149011612 0.10000000149011612
        vertex 254.98300170898438 0.10000000149011612 0.10000000149011612
        vertex 254.98300170898438 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 254.98300170898438 0.10000000149011612 -0.10000000149011612
        vertex 254.98300170898438 -0.10000000149011612 -0.10000000149011612
        vertex 254.98300170898438 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 254.98300170898438 -0.10000000149011612 -0.10000000149011612
        vertex 254.98300170898438 0.10000000149011612 -0.10000000149011612
        vertex 255.18299865722656 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 255.18299865722656 0.10000000149011612 -0.10000000149011612
        vertex 255.18299865722656 -0.10000000149011612 -0.10000000149011612
        vertex 254.98300170898438 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 245.06700134277344 -0.10000000149011612 0.10000000149011612
        vertex 245.26699829101562 -0.10000000149011612 0.10000000149011612
        vertex 245.06700134277344 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 245.26699829101562 0.10000000149011612 0.10000000149011612
        vertex 245.06700134277344 0.10000000149011612 0.10000000149011612
        vertex 245.26699829101562 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 245.26699829101562 -0.10000000149011612 0.10000000149011612
        vertex 245.06700134277344 -0.10000000149011612 0.10000000149011612
        vertex 245.26699829101562 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 245.06700134277344 -0.10000000149011612 -0.10000000149011612
        vertex 245.26699829101562 -0.10000000149011612 -0.10000000149011612
        vertex 245.06700134277344 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 245.26699829101562 0.10000000149011612 0.10000000149011612
        vertex 245.26699829101562 -0.10000000149011612 0.10000000149011612
        vertex 245.26699829101562 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 245.26699829101562 -0.10000000149011612 -0.10000000149011612
        vertex 245.26699829101562 0.10000000149011612 -0.10000000149011612
        vertex 245.26699829101562 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 245.06700134277344 0.10000000149011612 0.10000000149011612
        vertex 245.26699829101562 0.10000000149011612 0.10000000149011612
        vertex 245.06700134277344 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 245.26699829101562 0.10000000149011612 -0.10000000149011612
        vertex 245.06700134277344 0.10000000149011612 -0.10000000149011612
        vertex 245.26699829101562 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 245.06700134277344 -0.10000000149011612 0.10000000149011612
        vertex 245.06700134277344 0.10000000149011612 0.10000000149011612
        vertex 245.06700134277344 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 245.06700134277344 0.10000000149011612 -0.10000000149011612
        vertex 245.06700134277344 -0.10000000149011612 -0.10000000149011612
        vertex 245.06700134277344 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 245.06700134277344 -0.10000000149011612 -0.10000000149011612
        vertex 245.06700134277344 0.10000000149011612 -0.10000000149011612
        vertex 245.26699829101562 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 245.26699829101562 0.10000000149011612 -0.10000000149011612
        vertex 245.26699829101562 -0.10000000149011612 -0.10000000149011612
        vertex 245.06700134277344 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 235.14999389648438 -0.10000000149011612 0.10000000149011612
        vertex 235.35000610351562 -0.10000000149011612 0.10000000149011612
        vertex 235.14999389648438 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 235.35000610351562 0.10000000149011612 0.10000000149011612
        vertex 235.14999389648438 0.10000000149011612 0.10000000149011612
        vertex 235.35000610351562 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 235.35000610351562 -0.10000000149011612 0.10000000149011612
        vertex 235.14999389648438 -0.10000000149011612 0.10000000149011612
        vertex 235.35000610351562 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 235.14999389648438 -0.10000000149011612 -0.10000000149011612
        vertex 235.35000610351562 -0.10000000149011612 -0.10000000149011612
        vertex 235.14999389648438 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 235.35000610351562 0.10000000149011612 0.10000000149011612
        vertex 235.35000610351562 -0.10000000149011612 0.10000000149011612
        vertex 235.35000610351562 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 235.35000610351562 -0.10000000149011612 -0.10000000149011612
        vertex 235.35000610351562 0.10000000149011612 -0.10000000149011612
        vertex 235.35000610351562 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 235.14999389648438 0.10000000149011612 0.10000000149011612
        vertex 235.35000610351562 0.10000000149011612 0.10000000149011612
        vertex 235.14999389648438 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 235.35000610351562 0.10000000149011612 -0.10000000149011612
        vertex 235.14999389648438 0.10000000149011612 -0.10000000149011612
        vertex 235.35000610351562 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 235.14999389648438 -0.10000000149011612 0.10000000149011612
        vertex 235.14999389648438 0.10000000149011612 0.10000000149011612
        vertex 235.14999389648438 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 235.14999389648438 0.10000000149011612 -0.10000000149011612
        vertex 235.14999389648438 -0.10000000149011612 -0.10000000149011612
        vertex 235.14999389648438 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 235.14999389648438 -0.10000000149011612 -0.10000000149011612
        vertex 235.14999389648438 0.10000000149011612 -0.10000000149011612
        vertex 235.35000610351562 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 235.35000610351562 0.10000000149011612 -0.10000000149011612
        vertex 235.35000610351562 -0.10000000149011612 -0.10000000149011612
        vertex 235.14999389648438 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 225.23300170898438 -0.10000000149011612 0.10000000149011612
        vertex 225.43299865722656 -0.10000000149011612 0.10000000149011612
        vertex 225.23300170898438 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 225.43299865722656 0.10000000149011612 0.10000000149011612
        vertex 225.23300170898438 0.10000000149011612 0.10000000149011612
        vertex 225.43299865722656 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 225.43299865722656 -0.10000000149011612 0.10000000149011612
        vertex 225.23300170898438 -0.10000000149011612 0.10000000149011612
        vertex 225.43299865722656 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 225.23300170898438 -0.10000000149011612 -0.10000000149011612
        vertex 225.43299865722656 -0.10000000149011612 -0.10000000149011612
        vertex 225.23300170898438 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 225.43299865722656 0.10000000149011612 0.10000000149011612
        vertex 225.43299865722656 -0.10000000149011612 0.10000000149011612
        vertex 225.43299865722656 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 225.43299865722656 -0.10000000149011612 -0.10000000149011612
        vertex 225.43299865722656 0.10000000149011612 -0.10000000149011612
        vertex 225.43299865722656 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 225.23300170898438 0.10000000149011612 0.10000000149011612
        vertex 225.43299865722656 0.10000000149011612 0.10000000149011612
        vertex 225.23300170898438 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 225.43299865722656 0.10000000149011612 -0.10000000149011612
        vertex 225.23300170898438 0.10000000149011612 -0.10000000149011612
        vertex 225.43299865722656 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 225.23300170898438 -0.10000000149011612 0.10000000149011612
        vertex 225.23300170898438 0.10000000149011612 0.10000000149011612
        vertex 225.23300170898438 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 225.23300170898438 0.10000000149011612 -0.10000000149011612
        vertex 225.23300170898438 -0.10000000149011612 -0.10000000149011612
        vertex 225.23300170898438 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 225.23300170898438 -0.10000000149011612 -0.10000000149011612
        vertex 225.23300170898438 0.10000000149011612 -0.10000000149011612
        vertex 225.43299865722656 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 225.43299865722656 0.10000000149011612 -0.10000000149011612
        vertex 225.43299865722656 -0.10000000149011612 -0.10000000149011612
        vertex 225.23300170898438 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 215.31700134277344 -0.10000000149011612 0.10000000149011612
        vertex 215.51699829101562 -0.10000000149011612 0.10000000149011612
        vertex 215.31700134277344 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 215.51699829101562 0.10000000149011612 0.10000000149011612
        vertex 215.31700134277344 0.10000000149011612 0.10000000149011612
        vertex 215.51699829101562 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 215.51699829101562 -0.10000000149011612 0.10000000149011612
        vertex 215.31700134277344 -0.10000000149011612 0.10000000149011612
        vertex 215.51699829101562 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 215.31700134277344 -0.10000000149011612 -0.10000000149011612
        vertex 215.51699829101562 -0.10000000149011612 -0.10000000149011612
        vertex 215.31700134277344 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 215.51699829101562 0.10000000149011612 0.10000000149011612
        vertex 215.51699829101562 -0.10000000149011612 0.10000000149011612
        vertex 215.51699829101562 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 215.51699829101562 -0.10000000149011612 -0.10000000149011612
        vertex 215.51699829101562 0.10000000149011612 -0.10000000149011612
        vertex 215.51699829101562 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 215.31700134277344 0.10000000149011612 0.10000000149011612
        vertex 215.51699829101562 0.10000000149011612 0.10000000149011612
        vertex 215.31700134277344 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 215.51699829101562 0.10000000149011612 -0.10000000149011612
        vertex 215.31700134277344 0.10000000149011612 -0.10000000149011612
        vertex 215.51699829101562 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 215.31700134277344 -0.10000000149011612 0.10000000149011612
        vertex 215.31700134277344 0.10000000149011612 0.10000000149011612
        vertex 215.31700134277344 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 215.31700134277344 0.10000000149011612 -0.10000000149011612
        vertex 215.31700134277344 -0.10000000149011612 -0.10000000149011612
        vertex 215.31700134277344 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 215.31700134277344 -0.10000000149011612 -0.10000000149011612
        vertex 215.31700134277344 0.10000000149011612 -0.10000000149011612
        vertex 215.51699829101562 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 215.51699829101562 0.10000000149011612 -0.10000000149011612
        vertex 215.51699829101562 -0.10000000149011612 -0.10000000149011612
        vertex 215.31700134277344 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 205.39999389648438 -0.10000000149011612 0.10000000149011612
        vertex 205.60000610351562 -0.10000000149011612 0.10000000149011612
        vertex 205.39999389648438 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 205.60000610351562 0.10000000149011612 0.10000000149011612
        vertex 205.39999389648438 0.10000000149011612 0.10000000149011612
        vertex 205.60000610351562 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 205.60000610351562 -0.10000000149011612 0.10000000149011612
        vertex 205.39999389648438 -0.10000000149011612 0.10000000149011612
        vertex 205.60000610351562 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 205.39999389648438 -0.10000000149011612 -0.10000000149011612
        vertex 205.60000610351562 -0.10000000149011612 -0.10000000149011612
        vertex 205.39999389648438 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 205.60000610351562 0.10000000149011612 0.10000000149011612
        vertex 205.60000610351562 -0.10000000149011612 0.10000000149011612
        vertex 205.60000610351562 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 205.60000610351562 -0.10000000149011612 -0.10000000149011612
        vertex 205.60000610351562 0.10000000149011612 -0.10000000149011612
        vertex 205.60000610351562 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 205.39999389648438 0.10000000149011612 0.10000000149011612
        vertex 205.60000610351562 0.10000000149011612 0.10000000149011612
        vertex 205.39999389648438 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 205.60000610351562 0.10000000149011612 -0.10000000149011612
        vertex 205.39999389648438 0.10000000149011612 -0.10000000149011612
        vertex 205.60000610351562 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 205.39999389648438 -0.10000000149011612 0.10000000149011612
        vertex 205.39999389648438 0.10000000149011612 0.10000000149011612
        vertex 205.39999389648438 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 205.39999389648438 0.10000000149011612 -0.10000000149011612
        vertex 205.39999389648438 -0.10000000149011612 -0.10000000149011612
        vertex 205.39999389648438 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 205.39999389648438 -0.10000000149011612 -0.10000000149011612
        vertex 205.39999389648438 0.10000000149011612 -0.10000000149011612
        vertex 205.60000610351562 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 205.60000610351562 0.10000000149011612 -0.10000000149011612
        vertex 205.60000610351562 -0.10000000149011612 -0.10000000149011612
        vertex 205.39999389648438 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 195.48300170898438 -0.10000000149011612 0.10000000149011612
        vertex 195.68299865722656 -0.10000000149011612 0.10000000149011612
        vertex 195.48300170898438 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 195.68299865722656 0.10000000149011612 0.10000000149011612
        vertex 195.48300170898438 0.10000000149011612 0.10000000149011612
        vertex 195.68299865722656 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 195.68299865722656 -0.10000000149011612 0.10000000149011612
        vertex 195.48300170898438 -0.10000000149011612 0.10000000149011612
        vertex 195.68299865722656 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 195.48300170898438 -0.10000000149011612 -0.10000000149011612
        vertex 195.68299865722656 -0.10000000149011612 -0.10000000149011612
        vertex 195.48300170898438 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 195.68299865722656 0.10000000149011612 0.10000000149011612
        vertex 195.68299865722656 -0.10000000149011612 0.10000000149011612
        vertex 195.68299865722656 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 195.68299865722656 -0.10000000149011612 -0.10000000149011612
        vertex 195.68299865722656 0.10000000149011612 -0.10000000149011612
        vertex 195.68299865722656 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 195.48300170898438 0.10000000149011612 0.10000000149011612
        vertex 195.68299865722656 0.10000000149011612 0.10000000149011612
        vertex 195.48300170898438 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 195.68299865722656 0.10000000149011612 -0.10000000149011612
        vertex 195.48300170898438 0.10000000149011612 -0.10000000149011612
        vertex 195.68299865722656 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 195.48300170898438 -0.10000000149011612 0.10000000149011612
        vertex 195.48300170898438 0.10000000149011612 0.10000000149011612
        vertex 195.48300170898438 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 195.48300170898438 0.10000000149011612 -0.10000000149011612
        vertex 195.48300170898438 -0.10000000149011612 -0.10000000149011612
        vertex 195.48300170898438 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 195.48300170898438 -0.10000000149011612 -0.10000000149011612
        vertex 195.48300170898438 0.10000000149011612 -0.10000000149011612
        vertex 195.68299865722656 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 195.68299865722656 0.10000000149011612 -0.10000000149011612
        vertex 195.68299865722656 -0.10000000149011612 -0.10000000149011612
        vertex 195.48300170898438 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 185.56700134277344 -0.10000000149011612 0.10000000149011612
        vertex 185.76699829101562 -0.10000000149011612 0.10000000149011612
        vertex 185.56700134277344 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 185.76699829101562 0.10000000149011612 0.10000000149011612
        vertex 185.56700134277344 0.10000000149011612 0.10000000149011612
        vertex 185.76699829101562 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 185.76699829101562 -0.10000000149011612 0.10000000149011612
        vertex 185.56700134277344 -0.10000000149011612 0.10000000149011612
        vertex 185.76699829101562 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 185.56700134277344 -0.10000000149011612 -0.10000000149011612
        vertex 185.76699829101562 -0.10000000149011612 -0.10000000149011612
        vertex 185.56700134277344 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 185.76699829101562 0.10000000149011612 0.10000000149011612
        vertex 185.76699829101562 -0.10000000149011612 0.10000000149011612
        vertex 185.76699829101562 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 185.76699829101562 -0.10000000149011612 -0.10000000149011612
        vertex 185.76699829101562 0.10000000149011612 -0.10000000149011612
        vertex 185.76699829101562 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 185.56700134277344 0.10000000149011612 0.10000000149011612
        vertex 185.76699829101562 0.10000000149011612 0.10000000149011612
        vertex 185.56700134277344 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 185.76699829101562 0.10000000149011612 -0.10000000149011612
        vertex 185.56700134277344 0.10000000149011612 -0.10000000149011612
        vertex 185.76699829101562 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 185.56700134277344 -0.10000000149011612 0.10000000149011612
        vertex 185.56700134277344 0.10000000149011612 0.10000000149011612
        vertex 185.56700134277344 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 185.56700134277344 0.10000000149011612 -0.10000000149011612
        vertex 185.56700134277344 -0.10000000149011612 -0.10000000149011612
        vertex 185.56700134277344 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 185.56700134277344 -0.10000000149011612 -0.10000000149011612
        vertex 185.56700134277344 0.10000000149011612 -0.10000000149011612
        vertex 185.76699829101562 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 185.76699829101562 0.10000000149011612 -0.10000000149011612
        vertex 185.76699829101562 -0.10000000149011612 -0.10000000149011612
        vertex 185.56700134277344 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 175.64999389648438 -0.10000000149011612 0.10000000149011612
        vertex 175.85000610351562 -0.10000000149011612 0.10000000149011612
        vertex 175.64999389648438 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 175.85000610351562 0.10000000149011612 0.10000000149011612
        vertex 175.64999389648438 0.10000000149011612 0.10000000149011612
        vertex 175.85000610351562 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 175.85000610351562 -0.10000000149011612 0.10000000149011612
        vertex 175.64999389648438 -0.10000000149011612 0.10000000149011612
        vertex 175.85000610351562 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 175.64999389648438 -0.10000000149011612 -0.10000000149011612
        vertex 175.85000610351562 -0.10000000149011612 -0.10000000149011612
        vertex 175.64999389648438 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 175.85000610351562 0.10000000149011612 0.10000000149011612
        vertex 175.85000610351562 -0.10000000149011612 0.10000000149011612
        vertex 175.85000610351562 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 175.85000610351562 -0.10000000149011612 -0.10000000149011612
        vertex 175.85000610351562 0.10000000149011612 -0.10000000149011612
        vertex 175.85000610351562 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 175.64999389648438 0.10000000149011612 0.10000000149011612
        vertex 175.85000610351562 0.10000000149011612 0.10000000149011612
        vertex 175.64999389648438 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 175.85000610351562 0.10000000149011612 -0.10000000149011612
        vertex 175.64999389648438 0.10000000149011612 -0.10000000149011612
        vertex 175.85000610351562 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 175.64999389648438 -0.10000000149011612 0.10000000149011612
        vertex 175.64999389648438 0.10000000149011612 0.10000000149011612
        vertex 175.64999389648438 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 175.64999389648438 0.10000000149011612 -0.10000000149011612
        vertex 175.64999389648438 -0.10000000149011612 -0.10000000149011612
        vertex 175.64999389648438 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 175.64999389648438 -0.10000000149011612 -0.10000000149011612
        vertex 175.64999389648438 0.10000000149011612 -0.10000000149011612
        vertex 175.85000610351562 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 175.85000610351562 0.10000000149011612 -0.10000000149011612
        vertex 175.85000610351562 -0.10000000149011612 -0.10000000149011612
        vertex 175.64999389648438 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 165.73300170898438 -0.10000000149011612 0.10000000149011612
        vertex 165.93299865722656 -0.10000000149011612 0.10000000149011612
        vertex 165.73300170898438 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 165.93299865722656 0.10000000149011612 0.10000000149011612
        vertex 165.73300170898438 0.10000000149011612 0.10000000149011612
        vertex 165.93299865722656 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 165.93299865722656 -0.10000000149011612 0.10000000149011612
        vertex 165.73300170898438 -0.10000000149011612 0.10000000149011612
        vertex 165.93299865722656 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 165.73300170898438 -0.10000000149011612 -0.10000000149011612
        vertex 165.93299865722656 -0.10000000149011612 -0.10000000149011612
        vertex 165.73300170898438 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 165.93299865722656 0.10000000149011612 0.10000000149011612
        vertex 165.93299865722656 -0.10000000149011612 0.10000000149011612
        vertex 165.93299865722656 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 165.93299865722656 -0.10000000149011612 -0.10000000149011612
        vertex 165.93299865722656 0.10000000149011612 -0.10000000149011612
        vertex 165.93299865722656 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 165.73300170898438 0.10000000149011612 0.10000000149011612
        vertex 165.93299865722656 0.10000000149011612 0.10000000149011612
        vertex 165.73300170898438 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 165.93299865722656 0.10000000149011612 -0.10000000149011612
        vertex 165.73300170898438 0.10000000149011612 -0.10000000149011612
        vertex 165.93299865722656 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 165.73300170898438 -0.10000000149011612 0.10000000149011612
        vertex 165.73300170898438 0.10000000149011612 0.10000000149011612
        vertex 165.73300170898438 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 165.73300170898438 0.10000000149011612 -0.10000000149011612
        vertex 165.73300170898438 -0.10000000149011612 -0.10000000149011612
        vertex 165.73300170898438 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 165.73300170898438 -0.10000000149011612 -0.10000000149011612
        vertex 165.73300170898438 0.10000000149011612 -0.10000000149011612
        vertex 165.93299865722656 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 165.93299865722656 0.10000000149011612 -0.10000000149011612
        vertex 165.93299865722656 -0.10000000149011612 -0.10000000149011612
        vertex 165.73300170898438 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 155.81700134277344 -0.10000000149011612 0.10000000149011612
        vertex 156.01699829101562 -0.10000000149011612 0.10000000149011612
        vertex 155.81700134277344 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 156.01699829101562 0.10000000149011612 0.10000000149011612
        vertex 155.81700134277344 0.10000000149011612 0.10000000149011612
        vertex 156.01699829101562 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 156.01699829101562 -0.10000000149011612 0.10000000149011612
        vertex 155.81700134277344 -0.10000000149011612 0.10000000149011612
        vertex 156.01699829101562 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 155.81700134277344 -0.10000000149011612 -0.10000000149011612
        vertex 156.01699829101562 -0.10000000149011612 -0.10000000149011612
        vertex 155.81700134277344 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 156.01699829101562 0.10000000149011612 0.10000000149011612
        vertex 156.01699829101562 -0.10000000149011612 0.10000000149011612
        vertex 156.01699829101562 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 156.01699829101562 -0.10000000149011612 -0.10000000149011612
        vertex 156.01699829101562 0.10000000149011612 -0.10000000149011612
        vertex 156.01699829101562 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 155.81700134277344 0.10000000149011612 0.10000000149011612
        vertex 156.01699829101562 0.10000000149011612 0.10000000149011612
        vertex 155.81700134277344 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 156.01699829101562 0.10000000149011612 -0.10000000149011612
        vertex 155.81700134277344 0.10000000149011612 -0.10000000149011612
        vertex 156.01699829101562 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 155.81700134277344 -0.10000000149011612 0.10000000149011612
        vertex 155.81700134277344 0.10000000149011612 0.10000000149011612
        vertex 155.81700134277344 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 155.81700134277344 0.10000000149011612 -0.10000000149011612
        vertex 155.81700134277344 -0.10000000149011612 -0.10000000149011612
        vertex 155.81700134277344 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 155.81700134277344 -0.10000000149011612 -0.10000000149011612
        vertex 155.81700134277344 0.10000000149011612 -0.10000000149011612
        vertex 156.01699829101562 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 156.01699829101562 0.10000000149011612 -0.10000000149011612
        vertex 156.01699829101562 -0.10000000149011612 -0.10000000149011612
        vertex 155.81700134277344 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 145.89999389648438 -0.10000000149011612 0.10000000149011612
        vertex 146.10000610351562 -0.10000000149011612 0.10000000149011612
        vertex 145.89999389648438 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 146.10000610351562 0.10000000149011612 0.10000000149011612
        vertex 145.89999389648438 0.10000000149011612 0.10000000149011612
        vertex 146.10000610351562 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 146.10000610351562 -0.10000000149011612 0.10000000149011612
        vertex 145.89999389648438 -0.10000000149011612 0.10000000149011612
        vertex 146.10000610351562 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 145.89999389648438 -0.10000000149011612 -0.10000000149011612
        vertex 146.10000610351562 -0.10000000149011612 -0.10000000149011612
        vertex 145.89999389648438 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 146.10000610351562 0.10000000149011612 0.10000000149011612
        vertex 146.10000610351562 -0.10000000149011612 0.10000000149011612
        vertex 146.10000610351562 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 146.10000610351562 -0.10000000149011612 -0.10000000149011612
        vertex 146.10000610351562 0.10000000149011612 -0.10000000149011612
        vertex 146.10000610351562 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 145.89999389648438 0.10000000149011612 0.10000000149011612
        vertex 146.10000610351562 0.10000000149011612 0.10000000149011612
        vertex 145.89999389648438 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 146.10000610351562 0.10000000149011612 -0.10000000149011612
        vertex 145.89999389648438 0.10000000149011612 -0.10000000149011612
        vertex 146.10000610351562 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 145.89999389648438 -0.10000000149011612 0.10000000149011612
        vertex 145.89999389648438 0.10000000149011612 0.10000000149011612
        vertex 145.89999389648438 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 145.89999389648438 0.10000000149011612 -0.10000000149011612
        vertex 145.89999389648438 -0.10000000149011612 -0.10000000149011612
        vertex 145.89999389648438 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 145.89999389648438 -0.10000000149011612 -0.10000000149011612
        vertex 145.89999389648438 0.10000000149011612 -0.10000000149011612
        vertex 146.10000610351562 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 146.10000610351562 0.10000000149011612 -0.10000000149011612
        vertex 146.10000610351562 -0.10000000149011612 -0.10000000149011612
        vertex 145.89999389648438 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 145.89999389648438 -0.10000000149011612 0.10000000149011612
        vertex 146.10000610351562 -0.10000000149011612 0.10000000149011612
        vertex 145.89999389648438 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 146.10000610351562 0.10000000149011612 0.10000000149011612
        vertex 145.89999389648438 0.10000000149011612 0.10000000149011612
        vertex 146.10000610351562 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 146.10000610351562 -0.10000000149011612 0.10000000149011612
        vertex 145.89999389648438 -0.10000000149011612 0.10000000149011612
        vertex 146.10000610351562 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 145.89999389648438 -0.10000000149011612 -0.10000000149011612
        vertex 146.10000610351562 -0.10000000149011612 -0.10000000149011612
        vertex 145.89999389648438 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 146.10000610351562 0.10000000149011612 0.10000000149011612
        vertex 146.10000610351562 -0.10000000149011612 0.10000000149011612
        vertex 146.10000610351562 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 146.10000610351562 -0.10000000149011612 -0.10000000149011612
        vertex 146.10000610351562 0.10000000149011612 -0.10000000149011612
        vertex 146.10000610351562 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 145.89999389648438 0.10000000149011612 0.10000000149011612
        vertex 146.10000610351562 0.10000000149011612 0.10000000149011612
        vertex 145.89999389648438 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 146.10000610351562 0.10000000149011612 -0.10000000149011612
        vertex 145.89999389648438 0.10000000149011612 -0.10000000149011612
        vertex 146.10000610351562 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 145.89999389648438 -0.10000000149011612 0.10000000149011612
        vertex 145.89999389648438 0.10000000149011612 0.10000000149011612
        vertex 145.89999389648438 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 145.89999389648438 0.10000000149011612 -0.10000000149011612
        vertex 145.89999389648438 -0.10000000149011612 -0.10000000149011612
        vertex 145.89999389648438 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 145.89999389648438 -0.10000000149011612 -0.10000000149011612
        vertex 145.89999389648438 0.10000000149011612 -0.10000000149011612
        vertex 146.10000610351562 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 146.10000610351562 0.10000000149011612 -0.10000000149011612
        vertex 146.10000610351562 -0.10000000149011612 -0.10000000149011612
        vertex 145.89999389648438 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 136.16700744628906 -0.10000000149011612 0.10000000149011612
        vertex 136.36700439453125 -0.10000000149011612 0.10000000149011612
        vertex 136.16700744628906 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 136.36700439453125 0.10000000149011612 0.10000000149011612
        vertex 136.16700744628906 0.10000000149011612 0.10000000149011612
        vertex 136.36700439453125 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 136.36700439453125 -0.10000000149011612 0.10000000149011612
        vertex 136.16700744628906 -0.10000000149011612 0.10000000149011612
        vertex 136.36700439453125 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 136.16700744628906 -0.10000000149011612 -0.10000000149011612
        vertex 136.36700439453125 -0.10000000149011612 -0.10000000149011612
        vertex 136.16700744628906 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 136.36700439453125 0.10000000149011612 0.10000000149011612
        vertex 136.36700439453125 -0.10000000149011612 0.10000000149011612
        vertex 136.36700439453125 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 136.36700439453125 -0.10000000149011612 -0.10000000149011612
        vertex 136.36700439453125 0.10000000149011612 -0.10000000149011612
        vertex 136.36700439453125 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 136.16700744628906 0.10000000149011612 0.10000000149011612
        vertex 136.36700439453125 0.10000000149011612 0.10000000149011612
        vertex 136.16700744628906 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 136.36700439453125 0.10000000149011612 -0.10000000149011612
        vertex 136.16700744628906 0.10000000149011612 -0.10000000149011612
        vertex 136.36700439453125 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 136.16700744628906 -0.10000000149011612 0.10000000149011612
        vertex 136.16700744628906 0.10000000149011612 0.10000000149011612
        vertex 136.16700744628906 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 136.16700744628906 0.10000000149011612 -0.10000000149011612
        vertex 136.16700744628906 -0.10000000149011612 -0.10000000149011612
        vertex 136.16700744628906 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 136.16700744628906 -0.10000000149011612 -0.10000000149011612
        vertex 136.16700744628906 0.10000000149011612 -0.10000000149011612
        vertex 136.36700439453125 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 136.36700439453125 0.10000000149011612 -0.10000000149011612
        vertex 136.36700439453125 -0.10000000149011612 -0.10000000149011612
        vertex 136.16700744628906 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 126.43299865722656 -0.10000000149011612 0.10000000149011612
        vertex 126.63300323486328 -0.10000000149011612 0.10000000149011612
        vertex 126.43299865722656 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 126.63300323486328 0.10000000149011612 0.10000000149011612
        vertex 126.43299865722656 0.10000000149011612 0.10000000149011612
        vertex 126.63300323486328 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 126.63300323486328 -0.10000000149011612 0.10000000149011612
        vertex 126.43299865722656 -0.10000000149011612 0.10000000149011612
        vertex 126.63300323486328 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 126.43299865722656 -0.10000000149011612 -0.10000000149011612
        vertex 126.63300323486328 -0.10000000149011612 -0.10000000149011612
        vertex 126.43299865722656 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 126.63300323486328 0.10000000149011612 0.10000000149011612
        vertex 126.63300323486328 -0.10000000149011612 0.10000000149011612
        vertex 126.63300323486328 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 126.63300323486328 -0.10000000149011612 -0.10000000149011612
        vertex 126.63300323486328 0.10000000149011612 -0.10000000149011612
        vertex 126.63300323486328 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 126.43299865722656 0.10000000149011612 0.10000000149011612
        vertex 126.63300323486328 0.10000000149011612 0.10000000149011612
        vertex 126.43299865722656 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 126.63300323486328 0.10000000149011612 -0.10000000149011612
        vertex 126.43299865722656 0.10000000149011612 -0.10000000149011612
        vertex 126.63300323486328 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 126.43299865722656 -0.10000000149011612 0.10000000149011612
        vertex 126.43299865722656 0.10000000149011612 0.10000000149011612
        vertex 126.43299865722656 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 126.43299865722656 0.10000000149011612 -0.10000000149011612
        vertex 126.43299865722656 -0.10000000149011612 -0.10000000149011612
        vertex 126.43299865722656 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 126.43299865722656 -0.10000000149011612 -0.10000000149011612
        vertex 126.43299865722656 0.10000000149011612 -0.10000000149011612
        vertex 126.63300323486328 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 126.63300323486328 0.10000000149011612 -0.10000000149011612
        vertex 126.63300323486328 -0.10000000149011612 -0.10000000149011612
        vertex 126.43299865722656 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 116.69999694824219 -0.10000000149011612 0.10000000149011612
        vertex 116.9000015258789 -0.10000000149011612 0.10000000149011612
        vertex 116.69999694824219 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 116.9000015258789 0.10000000149011612 0.10000000149011612
        vertex 116.69999694824219 0.10000000149011612 0.10000000149011612
        vertex 116.9000015258789 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 116.9000015258789 -0.10000000149011612 0.10000000149011612
        vertex 116.69999694824219 -0.10000000149011612 0.10000000149011612
        vertex 116.9000015258789 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 116.69999694824219 -0.10000000149011612 -0.10000000149011612
        vertex 116.9000015258789 -0.10000000149011612 -0.10000000149011612
        vertex 116.69999694824219 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 116.9000015258789 0.10000000149011612 0.10000000149011612
        vertex 116.9000015258789 -0.10000000149011612 0.10000000149011612
        vertex 116.9000015258789 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 116.9000015258789 -0.10000000149011612 -0.10000000149011612
        vertex 116.9000015258789 0.10000000149011612 -0.10000000149011612
        vertex 116.9000015258789 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 116.69999694824219 0.10000000149011612 0.10000000149011612
        vertex 116.9000015258789 0.10000000149011612 0.10000000149011612
        vertex 116.69999694824219 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 116.9000015258789 0.10000000149011612 -0.10000000149011612
        vertex 116.69999694824219 0.10000000149011612 -0.10000000149011612
        vertex 116.9000015258789 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 116.69999694824219 -0.10000000149011612 0.10000000149011612
        vertex 116.69999694824219 0.10000000149011612 0.10000000149011612
        vertex 116.69999694824219 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 116.69999694824219 0.10000000149011612 -0.10000000149011612
        vertex 116.69999694824219 -0.10000000149011612 -0.10000000149011612
        vertex 116.69999694824219 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 116.69999694824219 -0.10000000149011612 -0.10000000149011612
        vertex 116.69999694824219 0.10000000149011612 -0.10000000149011612
        vertex 116.9000015258789 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 116.9000015258789 0.10000000149011612 -0.10000000149011612
        vertex 116.9000015258789 -0.10000000149011612 -0.10000000149011612
        vertex 116.69999694824219 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 106.96700286865234 -0.10000000149011612 0.10000000149011612
        vertex 107.16699981689453 -0.10000000149011612 0.10000000149011612
        vertex 106.96700286865234 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 107.16699981689453 0.10000000149011612 0.10000000149011612
        vertex 106.96700286865234 0.10000000149011612 0.10000000149011612
        vertex 107.16699981689453 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 107.16699981689453 -0.10000000149011612 0.10000000149011612
        vertex 106.96700286865234 -0.10000000149011612 0.10000000149011612
        vertex 107.16699981689453 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 106.96700286865234 -0.10000000149011612 -0.10000000149011612
        vertex 107.16699981689453 -0.10000000149011612 -0.10000000149011612
        vertex 106.96700286865234 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 107.16699981689453 0.10000000149011612 0.10000000149011612
        vertex 107.16699981689453 -0.10000000149011612 0.10000000149011612
        vertex 107.16699981689453 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 107.16699981689453 -0.10000000149011612 -0.10000000149011612
        vertex 107.16699981689453 0.10000000149011612 -0.10000000149011612
        vertex 107.16699981689453 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 106.96700286865234 0.10000000149011612 0.10000000149011612
        vertex 107.16699981689453 0.10000000149011612 0.10000000149011612
        vertex 106.96700286865234 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 107.16699981689453 0.10000000149011612 -0.10000000149011612
        vertex 106.96700286865234 0.10000000149011612 -0.10000000149011612
        vertex 107.16699981689453 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 106.96700286865234 -0.10000000149011612 0.10000000149011612
        vertex 106.96700286865234 0.10000000149011612 0.10000000149011612
        vertex 106.96700286865234 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 106.96700286865234 0.10000000149011612 -0.10000000149011612
        vertex 106.96700286865234 -0.10000000149011612 -0.10000000149011612
        vertex 106.96700286865234 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 106.96700286865234 -0.10000000149011612 -0.10000000149011612
        vertex 106.96700286865234 0.10000000149011612 -0.10000000149011612
        vertex 107.16699981689453 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 107.16699981689453 0.10000000149011612 -0.10000000149011612
        vertex 107.16699981689453 -0.10000000149011612 -0.10000000149011612
        vertex 106.96700286865234 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 97.2332992553711 -0.10000000149011612 0.10000000149011612
        vertex 97.43329620361328 -0.10000000149011612 0.10000000149011612
        vertex 97.2332992553711 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 97.43329620361328 0.10000000149011612 0.10000000149011612
        vertex 97.2332992553711 0.10000000149011612 0.10000000149011612
        vertex 97.43329620361328 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 97.43329620361328 -0.10000000149011612 0.10000000149011612
        vertex 97.2332992553711 -0.10000000149011612 0.10000000149011612
        vertex 97.43329620361328 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 97.2332992553711 -0.10000000149011612 -0.10000000149011612
        vertex 97.43329620361328 -0.10000000149011612 -0.10000000149011612
        vertex 97.2332992553711 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 97.43329620361328 0.10000000149011612 0.10000000149011612
        vertex 97.43329620361328 -0.10000000149011612 0.10000000149011612
        vertex 97.43329620361328 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 97.43329620361328 -0.10000000149011612 -0.10000000149011612
        vertex 97.43329620361328 0.10000000149011612 -0.10000000149011612
        vertex 97.43329620361328 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 97.2332992553711 0.10000000149011612 0.10000000149011612
        vertex 97.43329620361328 0.10000000149011612 0.10000000149011612
        vertex 97.2332992553711 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 97.43329620361328 0.10000000149011612 -0.10000000149011612
        vertex 97.2332992553711 0.10000000149011612 -0.10000000149011612
        vertex 97.43329620361328 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 97.2332992553711 -0.10000000149011612 0.10000000149011612
        vertex 97.2332992553711 0.10000000149011612 0.10000000149011612
        vertex 97.2332992553711 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 97.2332992553711 0.10000000149011612 -0.10000000149011612
        vertex 97.2332992553711 -0.10000000149011612 -0.10000000149011612
        vertex 97.2332992553711 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 97.2332992553711 -0.10000000149011612 -0.10000000149011612
        vertex 97.2332992553711 0.10000000149011612 -0.10000000149011612
        vertex 97.43329620361328 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 97.43329620361328 0.10000000149011612 -0.10000000149011612
        vertex 97.43329620361328 -0.10000000149011612 -0.10000000149011612
        vertex 97.2332992553711 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 87.5 -0.10000000149011612 0.10000000149011612
        vertex 87.69999694824219 -0.10000000149011612 0.10000000149011612
        vertex 87.5 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 87.69999694824219 0.10000000149011612 0.10000000149011612
        vertex 87.5 0.10000000149011612 0.10000000149011612
        vertex 87.69999694824219 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 87.69999694824219 -0.10000000149011612 0.10000000149011612
        vertex 87.5 -0.10000000149011612 0.10000000149011612
        vertex 87.69999694824219 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 87.5 -0.10000000149011612 -0.10000000149011612
        vertex 87.69999694824219 -0.10000000149011612 -0.10000000149011612
        vertex 87.5 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 87.69999694824219 0.10000000149011612 0.10000000149011612
        vertex 87.69999694824219 -0.10000000149011612 0.10000000149011612
        vertex 87.69999694824219 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 87.69999694824219 -0.10000000149011612 -0.10000000149011612
        vertex 87.69999694824219 0.10000000149011612 -0.10000000149011612
        vertex 87.69999694824219 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 87.5 0.10000000149011612 0.10000000149011612
        vertex 87.69999694824219 0.10000000149011612 0.10000000149011612
        vertex 87.5 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 87.69999694824219 0.10000000149011612 -0.10000000149011612
        vertex 87.5 0.10000000149011612 -0.10000000149011612
        vertex 87.69999694824219 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 87.5 -0.10000000149011612 0.10000000149011612
        vertex 87.5 0.10000000149011612 0.10000000149011612
        vertex 87.5 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 87.5 0.10000000149011612 -0.10000000149011612
        vertex 87.5 -0.10000000149011612 -0.10000000149011612
        vertex 87.5 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 87.5 -0.10000000149011612 -0.10000000149011612
        vertex 87.5 0.10000000149011612 -0.10000000149011612
        vertex 87.69999694824219 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 87.69999694824219 0.10000000149011612 -0.10000000149011612
        vertex 87.69999694824219 -0.10000000149011612 -0.10000000149011612
        vertex 87.5 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 77.7667007446289 -0.10000000149011612 0.10000000149011612
        vertex 77.9666976928711 -0.10000000149011612 0.10000000149011612
        vertex 77.7667007446289 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 77.9666976928711 0.10000000149011612 0.10000000149011612
        vertex 77.7667007446289 0.10000000149011612 0.10000000149011612
        vertex 77.9666976928711 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 77.9666976928711 -0.10000000149011612 0.10000000149011612
        vertex 77.7667007446289 -0.10000000149011612 0.10000000149011612
        vertex 77.9666976928711 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 77.7667007446289 -0.10000000149011612 -0.10000000149011612
        vertex 77.9666976928711 -0.10000000149011612 -0.10000000149011612
        vertex 77.7667007446289 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 77.9666976928711 0.10000000149011612 0.10000000149011612
        vertex 77.9666976928711 -0.10000000149011612 0.10000000149011612
        vertex 77.9666976928711 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 77.9666976928711 -0.10000000149011612 -0.10000000149011612
        vertex 77.9666976928711 0.10000000149011612 -0.10000000149011612
        vertex 77.9666976928711 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 77.7667007446289 0.10000000149011612 0.10000000149011612
        vertex 77.9666976928711 0.10000000149011612 0.10000000149011612
        vertex 77.7667007446289 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 77.9666976928711 0.10000000149011612 -0.10000000149011612
        vertex 77.7667007446289 0.10000000149011612 -0.10000000149011612
        vertex 77.9666976928711 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 77.7667007446289 -0.10000000149011612 0.10000000149011612
        vertex 77.7667007446289 0.10000000149011612 0.10000000149011612
        vertex 77.7667007446289 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 77.7667007446289 0.10000000149011612 -0.10000000149011612
        vertex 77.7667007446289 -0.10000000149011612 -0.10000000149011612
        vertex 77.7667007446289 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 77.7667007446289 -0.10000000149011612 -0.10000000149011612
        vertex 77.7667007446289 0.10000000149011612 -0.10000000149011612
        vertex 77.9666976928711 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 77.9666976928711 0.10000000149011612 -0.10000000149011612
        vertex 77.9666976928711 -0.10000000149011612 -0.10000000149011612
        vertex 77.7667007446289 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 68.0333023071289 -0.10000000149011612 0.10000000149011612
        vertex 68.2332992553711 -0.10000000149011612 0.10000000149011612
        vertex 68.0333023071289 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 68.2332992553711 0.10000000149011612 0.10000000149011612
        vertex 68.0333023071289 0.10000000149011612 0.10000000149011612
        vertex 68.2332992553711 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 68.2332992553711 -0.10000000149011612 0.10000000149011612
        vertex 68.0333023071289 -0.10000000149011612 0.10000000149011612
        vertex 68.2332992553711 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 68.0333023071289 -0.10000000149011612 -0.10000000149011612
        vertex 68.2332992553711 -0.10000000149011612 -0.10000000149011612
        vertex 68.0333023071289 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 68.2332992553711 0.10000000149011612 0.10000000149011612
        vertex 68.2332992553711 -0.10000000149011612 0.10000000149011612
        vertex 68.2332992553711 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 68.2332992553711 -0.10000000149011612 -0.10000000149011612
        vertex 68.2332992553711 0.10000000149011612 -0.10000000149011612
        vertex 68.2332992553711 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 68.0333023071289 0.10000000149011612 0.10000000149011612
        vertex 68.2332992553711 0.10000000149011612 0.10000000149011612
        vertex 68.0333023071289 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 68.2332992553711 0.10000000149011612 -0.10000000149011612
        vertex 68.0333023071289 0.10000000149011612 -0.10000000149011612
        vertex 68.2332992553711 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 68.0333023071289 -0.10000000149011612 0.10000000149011612
        vertex 68.0333023071289 0.10000000149011612 0.10000000149011612
        vertex 68.0333023071289 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 68.0333023071289 0.10000000149011612 -0.10000000149011612
        vertex 68.0333023071289 -0.10000000149011612 -0.10000000149011612
        vertex 68.0333023071289 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 68.0333023071289 -0.10000000149011612 -0.10000000149011612
        vertex 68.0333023071289 0.10000000149011612 -0.10000000149011612
        vertex 68.2332992553711 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 68.2332992553711 0.10000000149011612 -0.10000000149011612
        vertex 68.2332992553711 -0.10000000149011612 -0.10000000149011612
        vertex 68.0333023071289 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 58.29999923706055 -0.10000000149011612 0.10000000149011612
        vertex 58.5 -0.10000000149011612 0.10000000149011612
        vertex 58.29999923706055 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 58.5 0.10000000149011612 0.10000000149011612
        vertex 58.29999923706055 0.10000000149011612 0.10000000149011612
        vertex 58.5 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 58.5 -0.10000000149011612 0.10000000149011612
        vertex 58.29999923706055 -0.10000000149011612 0.10000000149011612
        vertex 58.5 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 58.29999923706055 -0.10000000149011612 -0.10000000149011612
        vertex 58.5 -0.10000000149011612 -0.10000000149011612
        vertex 58.29999923706055 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 58.5 0.10000000149011612 0.10000000149011612
        vertex 58.5 -0.10000000149011612 0.10000000149011612
        vertex 58.5 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 58.5 -0.10000000149011612 -0.10000000149011612
        vertex 58.5 0.10000000149011612 -0.10000000149011612
        vertex 58.5 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 58.29999923706055 0.10000000149011612 0.10000000149011612
        vertex 58.5 0.10000000149011612 0.10000000149011612
        vertex 58.29999923706055 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 58.5 0.10000000149011612 -0.10000000149011612
        vertex 58.29999923706055 0.10000000149011612 -0.10000000149011612
        vertex 58.5 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 58.29999923706055 -0.10000000149011612 0.10000000149011612
        vertex 58.29999923706055 0.10000000149011612 0.10000000149011612
        vertex 58.29999923706055 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 58.29999923706055 0.10000000149011612 -0.10000000149011612
        vertex 58.29999923706055 -0.10000000149011612 -0.10000000149011612
        vertex 58.29999923706055 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 58.29999923706055 -0.10000000149011612 -0.10000000149011612
        vertex 58.29999923706055 0.10000000149011612 -0.10000000149011612
        vertex 58.5 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 58.5 0.10000000149011612 -0.10000000149011612
        vertex 58.5 -0.10000000149011612 -0.10000000149011612
        vertex 58.29999923706055 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 48.56669998168945 -0.10000000149011612 0.10000000149011612
        vertex 48.766700744628906 -0.10000000149011612 0.10000000149011612
        vertex 48.56669998168945 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 48.766700744628906 0.10000000149011612 0.10000000149011612
        vertex 48.56669998168945 0.10000000149011612 0.10000000149011612
        vertex 48.766700744628906 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 48.766700744628906 -0.10000000149011612 0.10000000149011612
        vertex 48.56669998168945 -0.10000000149011612 0.10000000149011612
        vertex 48.766700744628906 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 48.56669998168945 -0.10000000149011612 -0.10000000149011612
        vertex 48.766700744628906 -0.10000000149011612 -0.10000000149011612
        vertex 48.56669998168945 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 48.766700744628906 0.10000000149011612 0.10000000149011612
        vertex 48.766700744628906 -0.10000000149011612 0.10000000149011612
        vertex 48.766700744628906 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 48.766700744628906 -0.10000000149011612 -0.10000000149011612
        vertex 48.766700744628906 0.10000000149011612 -0.10000000149011612
        vertex 48.766700744628906 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 48.56669998168945 0.10000000149011612 0.10000000149011612
        vertex 48.766700744628906 0.10000000149011612 0.10000000149011612
        vertex 48.56669998168945 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 48.766700744628906 0.10000000149011612 -0.10000000149011612
        vertex 48.56669998168945 0.10000000149011612 -0.10000000149011612
        vertex 48.766700744628906 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 48.56669998168945 -0.10000000149011612 0.10000000149011612
        vertex 48.56669998168945 0.10000000149011612 0.10000000149011612
        vertex 48.56669998168945 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 48.56669998168945 0.10000000149011612 -0.10000000149011612
        vertex 48.56669998168945 -0.10000000149011612 -0.10000000149011612
        vertex 48.56669998168945 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 48.56669998168945 -0.10000000149011612 -0.10000000149011612
        vertex 48.56669998168945 0.10000000149011612 -0.10000000149011612
        vertex 48.766700744628906 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 48.766700744628906 0.10000000149011612 -0.10000000149011612
        vertex 48.766700744628906 -0.10000000149011612 -0.10000000149011612
        vertex 48.56669998168945 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 38.83330154418945 -0.10000000149011612 0.10000000149011612
        vertex 39.03329849243164 -0.10000000149011612 0.10000000149011612
        vertex 38.83330154418945 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 39.03329849243164 0.10000000149011612 0.10000000149011612
        vertex 38.83330154418945 0.10000000149011612 0.10000000149011612
        vertex 39.03329849243164 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 39.03329849243164 -0.10000000149011612 0.10000000149011612
        vertex 38.83330154418945 -0.10000000149011612 0.10000000149011612
        vertex 39.03329849243164 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 38.83330154418945 -0.10000000149011612 -0.10000000149011612
        vertex 39.03329849243164 -0.10000000149011612 -0.10000000149011612
        vertex 38.83330154418945 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 39.03329849243164 0.10000000149011612 0.10000000149011612
        vertex 39.03329849243164 -0.10000000149011612 0.10000000149011612
        vertex 39.03329849243164 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 39.03329849243164 -0.10000000149011612 -0.10000000149011612
        vertex 39.03329849243164 0.10000000149011612 -0.10000000149011612
        vertex 39.03329849243164 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 38.83330154418945 0.10000000149011612 0.10000000149011612
        vertex 39.03329849243164 0.10000000149011612 0.10000000149011612
        vertex 38.83330154418945 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 39.03329849243164 0.10000000149011612 -0.10000000149011612
        vertex 38.83330154418945 0.10000000149011612 -0.10000000149011612
        vertex 39.03329849243164 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 38.83330154418945 -0.10000000149011612 0.10000000149011612
        vertex 38.83330154418945 0.10000000149011612 0.10000000149011612
        vertex 38.83330154418945 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 38.83330154418945 0.10000000149011612 -0.10000000149011612
        vertex 38.83330154418945 -0.10000000149011612 -0.10000000149011612
        vertex 38.83330154418945 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 38.83330154418945 -0.10000000149011612 -0.10000000149011612
        vertex 38.83330154418945 0.10000000149011612 -0.10000000149011612
        vertex 39.03329849243164 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 39.03329849243164 0.10000000149011612 -0.10000000149011612
        vertex 39.03329849243164 -0.10000000149011612 -0.10000000149011612
        vertex 38.83330154418945 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 29.100000381469727 -0.10000000149011612 0.10000000149011612
        vertex 29.299999237060547 -0.10000000149011612 0.10000000149011612
        vertex 29.100000381469727 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 29.299999237060547 0.10000000149011612 0.10000000149011612
        vertex 29.100000381469727 0.10000000149011612 0.10000000149011612
        vertex 29.299999237060547 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 29.299999237060547 -0.10000000149011612 0.10000000149011612
        vertex 29.100000381469727 -0.10000000149011612 0.10000000149011612
        vertex 29.299999237060547 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 29.100000381469727 -0.10000000149011612 -0.10000000149011612
        vertex 29.299999237060547 -0.10000000149011612 -0.10000000149011612
        vertex 29.100000381469727 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 29.299999237060547 0.10000000149011612 0.10000000149011612
        vertex 29.299999237060547 -0.10000000149011612 0.10000000149011612
        vertex 29.299999237060547 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 29.299999237060547 -0.10000000149011612 -0.10000000149011612
        vertex 29.299999237060547 0.10000000149011612 -0.10000000149011612
        vertex 29.299999237060547 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 29.100000381469727 0.10000000149011612 0.10000000149011612
        vertex 29.299999237060547 0.10000000149011612 0.10000000149011612
        vertex 29.100000381469727 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 29.299999237060547 0.10000000149011612 -0.10000000149011612
        vertex 29.100000381469727 0.10000000149011612 -0.10000000149011612
        vertex 29.299999237060547 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 29.100000381469727 -0.10000000149011612 0.10000000149011612
        vertex 29.100000381469727 0.10000000149011612 0.10000000149011612
        vertex 29.100000381469727 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 29.100000381469727 0.10000000149011612 -0.10000000149011612
        vertex 29.100000381469727 -0.10000000149011612 -0.10000000149011612
        vertex 29.100000381469727 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 29.100000381469727 -0.10000000149011612 -0.10000000149011612
        vertex 29.100000381469727 0.10000000149011612 -0.10000000149011612
        vertex 29.299999237060547 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 29.299999237060547 0.10000000149011612 -0.10000000149011612
        vertex 29.299999237060547 -0.10000000149011612 -0.10000000149011612
        vertex 29.100000381469727 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 19.36669921875 -0.10000000149011612 0.10000000149011612
        vertex 19.566699981689453 -0.10000000149011612 0.10000000149011612
        vertex 19.36669921875 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 19.566699981689453 0.10000000149011612 0.10000000149011612
        vertex 19.36669921875 0.10000000149011612 0.10000000149011612
        vertex 19.566699981689453 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 19.566699981689453 -0.10000000149011612 0.10000000149011612
        vertex 19.36669921875 -0.10000000149011612 0.10000000149011612
        vertex 19.566699981689453 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 19.36669921875 -0.10000000149011612 -0.10000000149011612
        vertex 19.566699981689453 -0.10000000149011612 -0.10000000149011612
        vertex 19.36669921875 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 19.566699981689453 0.10000000149011612 0.10000000149011612
        vertex 19.566699981689453 -0.10000000149011612 0.10000000149011612
        vertex 19.566699981689453 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 19.566699981689453 -0.10000000149011612 -0.10000000149011612
        vertex 19.566699981689453 0.10000000149011612 -0.10000000149011612
        vertex 19.566699981689453 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 19.36669921875 0.10000000149011612 0.10000000149011612
        vertex 19.566699981689453 0.10000000149011612 0.10000000149011612
        vertex 19.36669921875 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 19.566699981689453 0.10000000149011612 -0.10000000149011612
        vertex 19.36669921875 0.10000000149011612 -0.10000000149011612
        vertex 19.566699981689453 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 19.36669921875 -0.10000000149011612 0.10000000149011612
        vertex 19.36669921875 0.10000000149011612 0.10000000149011612
        vertex 19.36669921875 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 19.36669921875 0.10000000149011612 -0.10000000149011612
        vertex 19.36669921875 -0.10000000149011612 -0.10000000149011612
        vertex 19.36669921875 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 19.36669921875 -0.10000000149011612 -0.10000000149011612
        vertex 19.36669921875 0.10000000149011612 -0.10000000149011612
        vertex 19.566699981689453 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 19.566699981689453 0.10000000149011612 -0.10000000149011612
        vertex 19.566699981689453 -0.10000000149011612 -0.10000000149011612
        vertex 19.36669921875 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex -0.10000000149011612 -0.10000000149011612 0.10000000149011612
        vertex 0.10000000149011612 -0.10000000149011612 0.10000000149011612
        vertex -0.10000000149011612 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 0.10000000149011612 0.10000000149011612 0.10000000149011612
        vertex -0.10000000149011612 0.10000000149011612 0.10000000149011612
        vertex 0.10000000149011612 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 0.10000000149011612 -0.10000000149011612 0.10000000149011612
        vertex -0.10000000149011612 -0.10000000149011612 0.10000000149011612
        vertex 0.10000000149011612 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex -0.10000000149011612 -0.10000000149011612 -0.10000000149011612
        vertex 0.10000000149011612 -0.10000000149011612 -0.10000000149011612
        vertex -0.10000000149011612 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 0.10000000149011612 0.10000000149011612 0.10000000149011612
        vertex 0.10000000149011612 -0.10000000149011612 0.10000000149011612
        vertex 0.10000000149011612 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 0.10000000149011612 -0.10000000149011612 -0.10000000149011612
        vertex 0.10000000149011612 0.10000000149011612 -0.10000000149011612
        vertex 0.10000000149011612 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex -0.10000000149011612 0.10000000149011612 0.10000000149011612
        vertex 0.10000000149011612 0.10000000149011612 0.10000000149011612
        vertex -0.10000000149011612 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 0.10000000149011612 0.10000000149011612 -0.10000000149011612
        vertex -0.10000000149011612 0.10000000149011612 -0.10000000149011612
        vertex 0.10000000149011612 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex -0.10000000149011612 -0.10000000149011612 0.10000000149011612
        vertex -0.10000000149011612 0.10000000149011612 0.10000000149011612
        vertex -0.10000000149011612 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex -0.10000000149011612 0.10000000149011612 -0.10000000149011612
        vertex -0.10000000149011612 -0.10000000149011612 -0.10000000149011612
        vertex -0.10000000149011612 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex -0.10000000149011612 -0.10000000149011612 -0.10000000149011612
        vertex -0.10000000149011612 0.10000000149011612 -0.10000000149011612
        vertex 0.10000000149011612 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 0.10000000149011612 0.10000000149011612 -0.10000000149011612
        vertex 0.10000000149011612 -0.10000000149011612 -0.10000000149011612
        vertex -0.10000000149011612 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 9.633330345153809 -0.10000000149011612 0.10000000149011612
        vertex 9.833330154418945 -0.10000000149011612 0.10000000149011612
        vertex 9.633330345153809 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 9.833330154418945 0.10000000149011612 0.10000000149011612
        vertex 9.633330345153809 0.10000000149011612 0.10000000149011612
        vertex 9.833330154418945 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 9.833330154418945 -0.10000000149011612 0.10000000149011612
        vertex 9.633330345153809 -0.10000000149011612 0.10000000149011612
        vertex 9.833330154418945 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 9.633330345153809 -0.10000000149011612 -0.10000000149011612
        vertex 9.833330154418945 -0.10000000149011612 -0.10000000149011612
        vertex 9.633330345153809 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 9.833330154418945 0.10000000149011612 0.10000000149011612
        vertex 9.833330154418945 -0.10000000149011612 0.10000000149011612
        vertex 9.833330154418945 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 9.833330154418945 -0.10000000149011612 -0.10000000149011612
        vertex 9.833330154418945 0.10000000149011612 -0.10000000149011612
        vertex 9.833330154418945 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 9.633330345153809 0.10000000149011612 0.10000000149011612
        vertex 9.833330154418945 0.10000000149011612 0.10000000149011612
        vertex 9.633330345153809 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 9.833330154418945 0.10000000149011612 -0.10000000149011612
        vertex 9.633330345153809 0.10000000149011612 -0.10000000149011612
        vertex 9.833330154418945 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex 9.633330345153809 -0.10000000149011612 0.10000000149011612
        vertex 9.633330345153809 0.10000000149011612 0.10000000149011612
        vertex 9.633330345153809 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex 9.633330345153809 0.10000000149011612 -0.10000000149011612
        vertex 9.633330345153809 -0.10000000149011612 -0.10000000149011612
        vertex 9.633330345153809 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex 9.633330345153809 -0.10000000149011612 -0.10000000149011612
        vertex 9.633330345153809 0.10000000149011612 -0.10000000149011612
        vertex 9.833330154418945 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 9.833330154418945 0.10000000149011612 -0.10000000149011612
        vertex 9.833330154418945 -0.10000000149011612 -0.10000000149011612
        vertex 9.633330345153809 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex -0.10000000149011612 -0.10000000149011612 0.10000000149011612
        vertex 0.10000000149011612 -0.10000000149011612 0.10000000149011612
        vertex -0.10000000149011612 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 0.10000000149011612 0.10000000149011612 0.10000000149011612
        vertex -0.10000000149011612 0.10000000149011612 0.10000000149011612
        vertex 0.10000000149011612 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 -1.0 -0.0
    outer loop
        vertex 0.10000000149011612 -0.10000000149011612 0.10000000149011612
        vertex -0.10000000149011612 -0.10000000149011612 0.10000000149011612
        vertex 0.10000000149011612 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex -0.10000000149011612 -0.10000000149011612 -0.10000000149011612
        vertex 0.10000000149011612 -0.10000000149011612 -0.10000000149011612
        vertex -0.10000000149011612 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 0.10000000149011612 0.10000000149011612 0.10000000149011612
        vertex 0.10000000149011612 -0.10000000149011612 0.10000000149011612
        vertex 0.10000000149011612 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 1.0 0.0 -0.0
    outer loop
        vertex 0.10000000149011612 -0.10000000149011612 -0.10000000149011612
        vertex 0.10000000149011612 0.10000000149011612 -0.10000000149011612
        vertex 0.10000000149011612 -0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex -0.10000000149011612 0.10000000149011612 0.10000000149011612
        vertex 0.10000000149011612 0.10000000149011612 0.10000000149011612
        vertex -0.10000000149011612 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 1.0 -0.0
    outer loop
        vertex 0.10000000149011612 0.10000000149011612 -0.10000000149011612
        vertex -0.10000000149011612 0.10000000149011612 -0.10000000149011612
        vertex 0.10000000149011612 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 -0.0
    outer loop
        vertex -0.10000000149011612 -0.10000000149011612 0.10000000149011612
        vertex -0.10000000149011612 0.10000000149011612 0.10000000149011612
        vertex -0.10000000149011612 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -1.0 0.0 0.0
    outer loop
        vertex -0.10000000149011612 0.10000000149011612 -0.10000000149011612
        vertex -0.10000000149011612 -0.10000000149011612 -0.10000000149011612
        vertex -0.10000000149011612 0.10000000149011612 0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 -1.0
    outer loop
        vertex -0.10000000149011612 -0.10000000149011612 -0.10000000149011612
        vertex -0.10000000149011612 0.10000000149011612 -0.10000000149011612
        vertex 0.10000000149011612 -0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal -0.0 -0.0 -1.0
    outer loop
        vertex 0.10000000149011612 0.10000000149011612 -0.10000000149011612
        vertex 0.10000000149011612 -0.10000000149011612 -0.10000000149011612
        vertex -0.10000000149011612 0.10000000149011612 -0.10000000149011612
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 159.99136352539062 -12.89399528503418 -6.0
        vertex 160.0334930419922 -11.921836853027344 -6.0
        vertex 160.0334930419922 -11.921836853027344 -6.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 160.0334930419922 -11.921836853027344 -6.0
        vertex 159.86566162109375 -10.963348388671875 -6.0
        vertex 159.49569702148438 -10.063349723815918 -6.0
    endloop
endfacet
facet normal -2.886270908757896e-15 -3.1140029164072663e-15 1.0
    outer loop
        vertex 159.49569702148438 -10.063349723815918 -6.0
        vertex 158.94091796875 -9.263921737670898 -6.0
        vertex 158.2272491455078 -8.602444648742676 -6.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 158.2272491455078 -8.602444648742676 -6.0
        vertex 157.38807678222656 -8.10984992980957 -6.0
        vertex 156.46263122558594 -7.809170246124268 -6.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 156.46263122558594 -7.809170246124268 -6.0
        vertex 155.49417114257812 -7.7144646644592285 -6.0
        vertex 154.5279998779297 -7.830162048339844 -6.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 154.5279998779297 -7.830162048339844 -6.0
        vertex 153.6092987060547 -8.150851249694824 -6.0
        vertex 152.781005859375 -8.661539077758789 -6.0
    endloop
endfacet
facet normal 2.953275873566921e-15 -3.050739931400974e-15 1.0
    outer loop
        vertex 152.781005859375 -8.661539077758789 -6.0
        vertex 152.0818634033203 -9.338345527648926 -6.0
        vertex 151.5445556640625 -10.149622917175293 -6.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 151.5445556640625 -10.149622917175293 -6.0
        vertex 151.1942138671875 -11.057437896728516 -6.0
        vertex 151.04722595214844 -12.019341468811035 -6.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 151.04722595214844 -12.019341468811035 -6.0
        vertex 151.11044311523438 -12.990357398986816 -6.0
        vertex 151.38092041015625 -13.925080299377441 -6.0
    endloop
endfacet
facet normal -3.2062952028236212e-15 -2.7838654724677983e-15 1.0
    outer loop
        vertex 151.38092041015625 -13.925080299377441 -6.0
        vertex 151.8460235595703 -14.779804229736328 -6.0
        vertex 152.48397827148438 -15.51456356048584 -6.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 152.48397827148438 -15.51456356048584 -6.0
        vertex 153.26498413085938 -16.095001220703125 -6.0
        vertex 154.15249633789062 -16.49397850036621 -6.0
    endloop
endfacet
facet normal -0.0 0.0 1.0
    outer loop
        vertex 154.15249633789062 -16.49397850036621 -6.0
        vertex 155.1050262451172 -16.69283676147461 -6.0
        vertex 156.0780487060547 -16.682279586791992 -6.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 156.0780487060547 -16.682279586791992 -6.0
        vertex 157.0260467529297 -16.462799072265625 -6.0
        vertex 157.90469360351562 -16.044658660888672 -6.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 157.90469360351562 -16.044658660888672 -6.0
        vertex 158.67291259765625 -15.44741153717041 -6.0
        vertex 159.29478454589844 -14.698982238769531 -6.0
    endloop
endfacet
facet normal -4.103287635614638e-15 1.0914680211070518e-15 1.0
    outer loop
        vertex 159.29478454589844 -14.698982238769531 -6.0
        vertex 159.74122619628906 -13.834366798400879 -6.0
        vertex 159.99136352539062 -12.89399528503418 -6.0
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 159.99136352539062 -12.89399528503418 -6.0
        vertex 160.0334930419922 -11.921836853027344 -6.0
        vertex 159.49569702148438 -10.063349723815918 -6.0
    endloop
endfacet
facet normal -4.482813347247018e-16 -9.971899718249776e-16 1.0
    outer loop
        vertex 159.49569702148438 -10.063349723815918 -6.0
        vertex 158.2272491455078 -8.602444648742676 -6.0
        vertex 156.46263122558594 -7.809170246124268 -6.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 156.46263122558594 -7.809170246124268 -6.0
        vertex 154.5279998779297 -7.830162048339844 -6.0
        vertex 152.781005859375 -8.661539077758789 -6.0
    endloop
endfacet
facet normal -1.0565600992848076e-15 2.8103626747611626e-16 1.0
    outer loop
        vertex 152.781005859375 -8.661539077758789 -6.0
        vertex 151.5445556640625 -10.149622917175293 -6.0
        vertex 151.04722595214844 -12.019341468811035 -6.0
    endloop
endfacet
facet normal 1.0769197008423672e-15 1.8856840701166327e-16 1.0
    outer loop
        vertex 151.04722595214844 -12.019341468811035 -6.0
        vertex 151.38092041015625 -13.925080299377441 -6.0
        vertex 152.48397827148438 -15.51456356048584 -6.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 152.48397827148438 -15.51456356048584 -6.0
        vertex 154.15249633789062 -16.49397850036621 -6.0
        vertex 156.0780487060547 -16.682279586791992 -6.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 156.0780487060547 -16.682279586791992 -6.0
        vertex 157.90469360351562 -16.044658660888672 -6.0
        vertex 159.29478454589844 -14.698982238769531 -6.0
    endloop
endfacet
facet normal -8.770874232283366e-16 -1.5358434486839476e-16 1.0
    outer loop
        vertex 159.29478454589844 -14.698982238769531 -6.0
        vertex 159.99136352539062 -12.89399528503418 -6.0
        vertex 159.49569702148438 -10.063349723815918 -6.0
    endloop
endfacet
facet normal 6.95546001547095e-17 -3.004262810068657e-16 1.0
    outer loop
        vertex 159.49569702148438 -10.063349723815918 -6.0
        vertex 156.46263122558594 -7.809170246124268 -6.0
        vertex 152.781005859375 -8.661539077758789 -6.0
    endloop
endfacet
facet normal -1.1213718641828198e-17 -2.5872168740651415e-16 1.0
    outer loop
        vertex 152.781005859375 -8.661539077758789 -6.0
        vertex 151.04722595214844 -12.019341468811035 -6.0
        vertex 152.48397827148438 -15.51456356048584 -6.0
    endloop
endfacet
facet normal -0.0 0.0 1.0
    outer loop
        vertex 152.48397827148438 -15.51456356048584 -6.0
        vertex 156.0780487060547 -16.682279586791992 -6.0
        vertex 159.29478454589844 -14.698982238769531 -6.0
    endloop
endfacet
facet normal 9.144698062221965e-17 -1.9556149778930497e-16 1.0
    outer loop
        vertex 159.29478454589844 -14.698982238769531 -6.0
        vertex 159.49569702148438 -10.063349723815918 -6.0
        vertex 152.781005859375 -8.661539077758789 -6.0
    endloop
endfacet
facet normal 3.1201583577745225e-17 -2.605600665394112e-16 1.0
    outer loop
        vertex 152.781005859375 -8.661539077758789 -6.0
        vertex 152.48397827148438 -15.51456356048584 -6.0
        vertex 159.29478454589844 -14.698982238769531 -6.0
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 158.01431274414062 -12.591863632202148 -18.0
        vertex 158.0377197265625 -12.051775932312012 -18.0
        vertex 158.0377197265625 -12.051775932312012 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 158.0377197265625 -12.051775932312012 -18.0
        vertex 157.94447326660156 -11.519282341003418 -18.0
        vertex 157.7389373779297 -11.019283294677734 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 157.7389373779297 -11.019283294677734 -18.0
        vertex 157.4307403564453 -10.575156211853027 -18.0
        vertex 157.0342559814453 -10.207669258117676 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 157.0342559814453 -10.207669258117676 -18.0
        vertex 156.5680389404297 -9.934005737304688 -18.0
        vertex 156.0539093017578 -9.766961097717285 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 156.0539093017578 -9.766961097717285 -18.0
        vertex 155.515869140625 -9.714346885681152 -18.0
        vertex 154.97911071777344 -9.778623580932617 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 154.97911071777344 -9.778623580932617 -18.0
        vertex 154.46871948242188 -9.95678424835205 -18.0
        vertex 154.00856018066406 -10.240499496459961 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 154.00856018066406 -10.240499496459961 -18.0
        vertex 153.62014770507812 -10.61650276184082 -18.0
        vertex 153.32164001464844 -11.06721305847168 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.32164001464844 -11.06721305847168 -18.0
        vertex 153.12701416015625 -11.571554183959961 -18.0
        vertex 153.04534912109375 -12.105945587158203 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.04534912109375 -12.105945587158203 -18.0
        vertex 153.08045959472656 -12.645398139953613 -18.0
        vertex 153.23072814941406 -13.164689064025879 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.23072814941406 -13.164689064025879 -18.0
        vertex 153.48912048339844 -13.639535903930664 -18.0
        vertex 153.8435516357422 -14.047735214233398 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.8435516357422 -14.047735214233398 -18.0
        vertex 154.27743530273438 -14.370201110839844 -18.0
        vertex 154.77049255371094 -14.591854095458984 -18.0
    endloop
endfacet
facet normal -0.0 0.0 1.0
    outer loop
        vertex 154.77049255371094 -14.591854095458984 -18.0
        vertex 155.2996826171875 -14.70233154296875 -18.0
        vertex 155.84024047851562 -14.696465492248535 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 155.84024047851562 -14.696465492248535 -18.0
        vertex 156.36691284179688 -14.574532508850098 -18.0
        vertex 156.8550567626953 -14.342232704162598 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 156.8550567626953 -14.342232704162598 -18.0
        vertex 157.28184509277344 -14.010428428649902 -18.0
        vertex 157.6273193359375 -13.594634056091309 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 157.6273193359375 -13.594634056091309 -18.0
        vertex 157.87535095214844 -13.114293098449707 -18.0
        vertex 158.01431274414062 -12.591863632202148 -18.0
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 158.01431274414062 -12.591863632202148 -18.0
        vertex 158.0377197265625 -12.051775932312012 -18.0
        vertex 157.7389373779297 -11.019283294677734 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 157.7389373779297 -11.019283294677734 -18.0
        vertex 157.0342559814453 -10.207669258117676 -18.0
        vertex 156.0539093017578 -9.766961097717285 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 156.0539093017578 -9.766961097717285 -18.0
        vertex 154.97911071777344 -9.778623580932617 -18.0
        vertex 154.00856018066406 -10.240499496459961 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 154.00856018066406 -10.240499496459961 -18.0
        vertex 153.32164001464844 -11.06721305847168 -18.0
        vertex 153.04534912109375 -12.105945587158203 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.04534912109375 -12.105945587158203 -18.0
        vertex 153.23072814941406 -13.164689064025879 -18.0
        vertex 153.8435516357422 -14.047735214233398 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.8435516357422 -14.047735214233398 -18.0
        vertex 154.77049255371094 -14.591854095458984 -18.0
        vertex 155.84024047851562 -14.696465492248535 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 155.84024047851562 -14.696465492248535 -18.0
        vertex 156.8550567626953 -14.342232704162598 -18.0
        vertex 157.6273193359375 -13.594634056091309 -18.0
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 157.6273193359375 -13.594634056091309 -18.0
        vertex 158.01431274414062 -12.591863632202148 -18.0
        vertex 157.7389373779297 -11.019283294677734 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 157.7389373779297 -11.019283294677734 -18.0
        vertex 156.0539093017578 -9.766961097717285 -18.0
        vertex 154.00856018066406 -10.240499496459961 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 154.00856018066406 -10.240499496459961 -18.0
        vertex 153.04534912109375 -12.105945587158203 -18.0
        vertex 153.8435516357422 -14.047735214233398 -18.0
    endloop
endfacet
facet normal -0.0 0.0 1.0
    outer loop
        vertex 153.8435516357422 -14.047735214233398 -18.0
        vertex 155.84024047851562 -14.696465492248535 -18.0
        vertex 157.6273193359375 -13.594634056091309 -18.0
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 157.6273193359375 -13.594634056091309 -18.0
        vertex 157.7389373779297 -11.019283294677734 -18.0
        vertex 154.00856018066406 -10.240499496459961 -18.0
    endloop
endfacet
facet normal -0.0 0.0 1.0
    outer loop
        vertex 154.00856018066406 -10.240499496459961 -18.0
        vertex 153.8435516357422 -14.047735214233398 -18.0
        vertex 157.6273193359375 -13.594634056091309 -18.0
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 158.02569580078125 -12.507844924926758 -18.0
        vertex 158.0406494140625 -12.105790138244629 -18.0
        vertex 158.0406494140625 -12.105790138244629 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 158.0406494140625 -12.105790138244629 -18.0
        vertex 157.9909210205078 -11.70654296875 -18.0
        vertex 157.87777709960938 -11.320444107055664 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 157.87777709960938 -11.320444107055664 -18.0
        vertex 157.7041778564453 -10.95749282836914 -18.0
        vertex 157.47459411621094 -10.627089500427246 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 157.47459411621094 -10.627089500427246 -18.0
        vertex 157.1949920654297 -10.337791442871094 -18.0
        vertex 156.8726043701172 -10.097091674804688 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 156.8726043701172 -10.097091674804688 -18.0
        vertex 156.51577758789062 -9.911224365234375 -18.0
        vertex 156.13375854492188 -9.785001754760742 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 156.13375854492188 -9.785001754760742 -18.0
        vertex 155.73643493652344 -9.721694946289062 -18.0
        vertex 155.3341064453125 -9.722942352294922 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 155.3341064453125 -9.722942352294922 -18.0
        vertex 154.93719482421875 -9.788712501525879 -18.0
        vertex 154.5559539794922 -9.917301177978516 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 154.5559539794922 -9.917301177978516 -18.0
        vertex 154.20028686523438 -10.105378150939941 -18.0
        vertex 153.87939453125 -10.348072052001953 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.87939453125 -10.348072052001953 -18.0
        vertex 153.60159301757812 -10.63909912109375 -18.0
        vertex 153.3740692138672 -10.970919609069824 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.3740692138672 -10.970919609069824 -18.0
        vertex 153.20272827148438 -11.334939956665039 -18.0
        vertex 153.09197998046875 -11.721733093261719 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.09197998046875 -11.721733093261719 -18.0
        vertex 153.0447235107422 -12.121280670166016 -18.0
        vertex 153.0621795654297 -12.523235321044922 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.0621795654297 -12.523235321044922 -18.0
        vertex 153.1438751220703 -12.91718578338623 -18.0
        vertex 153.28770446777344 -13.292929649353027 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.28770446777344 -13.292929649353027 -18.0
        vertex 153.48995971679688 -13.640734672546387 -18.0
        vertex 153.74537658691406 -13.951593399047852 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.74537658691406 -13.951593399047852 -18.0
        vertex 154.04734802246094 -14.217453956604004 -18.0
        vertex 154.3880615234375 -14.431431770324707 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 154.3880615234375 -14.431431770324707 -18.0
        vertex 154.75868225097656 -14.587984085083008 -18.0
        vertex 155.14962768554688 -14.683056831359863 -18.0
    endloop
endfacet
facet normal -0.0 0.0 1.0
    outer loop
        vertex 155.14962768554688 -14.683056831359863 -18.0
        vertex 155.55075073242188 -14.714187622070312 -18.0
        vertex 155.95167541503906 -14.680570602416992 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 155.95167541503906 -14.680570602416992 -18.0
        vertex 156.34202575683594 -14.583074569702148 -18.0
        vertex 156.711669921875 -14.424226760864258 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 156.711669921875 -14.424226760864258 -18.0
        vertex 157.05104064941406 -14.20814037322998 -18.0
        vertex 157.3513641357422 -13.940411567687988 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 157.3513641357422 -13.940411567687988 -18.0
        vertex 157.6048583984375 -13.627975463867188 -18.0
        vertex 157.804931640625 -13.278923034667969 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 157.804931640625 -13.278923034667969 -18.0
        vertex 157.94644165039062 -12.902295112609863 -18.0
        vertex 158.02569580078125 -12.507844924926758 -18.0
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 158.02569580078125 -12.507844924926758 -18.0
        vertex 158.0406494140625 -12.105790138244629 -18.0
        vertex 157.87777709960938 -11.320444107055664 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 157.87777709960938 -11.320444107055664 -18.0
        vertex 157.47459411621094 -10.627089500427246 -18.0
        vertex 156.8726043701172 -10.097091674804688 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 156.8726043701172 -10.097091674804688 -18.0
        vertex 156.13375854492188 -9.785001754760742 -18.0
        vertex 155.3341064453125 -9.722942352294922 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 155.3341064453125 -9.722942352294922 -18.0
        vertex 154.5559539794922 -9.917301177978516 -18.0
        vertex 153.87939453125 -10.348072052001953 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.87939453125 -10.348072052001953 -18.0
        vertex 153.3740692138672 -10.970919609069824 -18.0
        vertex 153.09197998046875 -11.721733093261719 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.09197998046875 -11.721733093261719 -18.0
        vertex 153.0621795654297 -12.523235321044922 -18.0
        vertex 153.28770446777344 -13.292929649353027 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.28770446777344 -13.292929649353027 -18.0
        vertex 153.74537658691406 -13.951593399047852 -18.0
        vertex 154.3880615234375 -14.431431770324707 -18.0
    endloop
endfacet
facet normal -0.0 0.0 1.0
    outer loop
        vertex 154.3880615234375 -14.431431770324707 -18.0
        vertex 155.14962768554688 -14.683056831359863 -18.0
        vertex 155.95167541503906 -14.680570602416992 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 155.95167541503906 -14.680570602416992 -18.0
        vertex 156.711669921875 -14.424226760864258 -18.0
        vertex 157.3513641357422 -13.940411567687988 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 157.3513641357422 -13.940411567687988 -18.0
        vertex 157.804931640625 -13.278923034667969 -18.0
        vertex 158.02569580078125 -12.507844924926758 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 158.02569580078125 -12.507844924926758 -18.0
        vertex 157.87777709960938 -11.320444107055664 -18.0
        vertex 156.8726043701172 -10.097091674804688 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 156.8726043701172 -10.097091674804688 -18.0
        vertex 155.3341064453125 -9.722942352294922 -18.0
        vertex 153.87939453125 -10.348072052001953 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.87939453125 -10.348072052001953 -18.0
        vertex 153.09197998046875 -11.721733093261719 -18.0
        vertex 153.28770446777344 -13.292929649353027 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.28770446777344 -13.292929649353027 -18.0
        vertex 154.3880615234375 -14.431431770324707 -18.0
        vertex 155.95167541503906 -14.680570602416992 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 155.95167541503906 -14.680570602416992 -18.0
        vertex 157.3513641357422 -13.940411567687988 -18.0
        vertex 158.02569580078125 -12.507844924926758 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 158.02569580078125 -12.507844924926758 -18.0
        vertex 156.8726043701172 -10.097091674804688 -18.0
        vertex 153.87939453125 -10.348072052001953 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.87939453125 -10.348072052001953 -18.0
        vertex 153.28770446777344 -13.292929649353027 -18.0
        vertex 155.95167541503906 -14.680570602416992 -18.0
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 155.95167541503906 -14.680570602416992 -18.0
        vertex 158.02569580078125 -12.507844924926758 -18.0
        vertex 153.87939453125 -10.348072052001953 -18.0
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 158.02569580078125 -12.507844924926758 -36.0
        vertex 158.0406494140625 -12.105790138244629 -36.0
        vertex 158.0406494140625 -12.105790138244629 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 158.0406494140625 -12.105790138244629 -36.0
        vertex 157.9909210205078 -11.70654296875 -36.0
        vertex 157.87777709960938 -11.320444107055664 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 157.87777709960938 -11.320444107055664 -36.0
        vertex 157.7041778564453 -10.95749282836914 -36.0
        vertex 157.47459411621094 -10.627089500427246 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 157.47459411621094 -10.627089500427246 -36.0
        vertex 157.1949920654297 -10.337791442871094 -36.0
        vertex 156.8726043701172 -10.097091674804688 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 156.8726043701172 -10.097091674804688 -36.0
        vertex 156.51577758789062 -9.911224365234375 -36.0
        vertex 156.13375854492188 -9.785001754760742 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 156.13375854492188 -9.785001754760742 -36.0
        vertex 155.73643493652344 -9.721694946289062 -36.0
        vertex 155.3341064453125 -9.722942352294922 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 155.3341064453125 -9.722942352294922 -36.0
        vertex 154.93719482421875 -9.788712501525879 -36.0
        vertex 154.5559539794922 -9.917301177978516 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 154.5559539794922 -9.917301177978516 -36.0
        vertex 154.20028686523438 -10.105378150939941 -36.0
        vertex 153.87939453125 -10.348072052001953 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.87939453125 -10.348072052001953 -36.0
        vertex 153.60159301757812 -10.63909912109375 -36.0
        vertex 153.3740692138672 -10.970919609069824 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.3740692138672 -10.970919609069824 -36.0
        vertex 153.20272827148438 -11.334939956665039 -36.0
        vertex 153.09197998046875 -11.721733093261719 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.09197998046875 -11.721733093261719 -36.0
        vertex 153.0447235107422 -12.121280670166016 -36.0
        vertex 153.0621795654297 -12.523235321044922 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.0621795654297 -12.523235321044922 -36.0
        vertex 153.1438751220703 -12.91718578338623 -36.0
        vertex 153.28770446777344 -13.292929649353027 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.28770446777344 -13.292929649353027 -36.0
        vertex 153.48995971679688 -13.640734672546387 -36.0
        vertex 153.74537658691406 -13.951593399047852 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.74537658691406 -13.951593399047852 -36.0
        vertex 154.04734802246094 -14.217453956604004 -36.0
        vertex 154.3880615234375 -14.431431770324707 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 154.3880615234375 -14.431431770324707 -36.0
        vertex 154.75868225097656 -14.587984085083008 -36.0
        vertex 155.14962768554688 -14.683056831359863 -36.0
    endloop
endfacet
facet normal -0.0 0.0 1.0
    outer loop
        vertex 155.14962768554688 -14.683056831359863 -36.0
        vertex 155.55075073242188 -14.714187622070312 -36.0
        vertex 155.95167541503906 -14.680570602416992 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 155.95167541503906 -14.680570602416992 -36.0
        vertex 156.34202575683594 -14.583074569702148 -36.0
        vertex 156.711669921875 -14.424226760864258 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 156.711669921875 -14.424226760864258 -36.0
        vertex 157.05104064941406 -14.20814037322998 -36.0
        vertex 157.3513641357422 -13.940411567687988 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 157.3513641357422 -13.940411567687988 -36.0
        vertex 157.6048583984375 -13.627975463867188 -36.0
        vertex 157.804931640625 -13.278923034667969 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 157.804931640625 -13.278923034667969 -36.0
        vertex 157.94644165039062 -12.902295112609863 -36.0
        vertex 158.02569580078125 -12.507844924926758 -36.0
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 158.02569580078125 -12.507844924926758 -36.0
        vertex 158.0406494140625 -12.105790138244629 -36.0
        vertex 157.87777709960938 -11.320444107055664 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 157.87777709960938 -11.320444107055664 -36.0
        vertex 157.47459411621094 -10.627089500427246 -36.0
        vertex 156.8726043701172 -10.097091674804688 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 156.8726043701172 -10.097091674804688 -36.0
        vertex 156.13375854492188 -9.785001754760742 -36.0
        vertex 155.3341064453125 -9.722942352294922 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 155.3341064453125 -9.722942352294922 -36.0
        vertex 154.5559539794922 -9.917301177978516 -36.0
        vertex 153.87939453125 -10.348072052001953 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.87939453125 -10.348072052001953 -36.0
        vertex 153.3740692138672 -10.970919609069824 -36.0
        vertex 153.09197998046875 -11.721733093261719 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.09197998046875 -11.721733093261719 -36.0
        vertex 153.0621795654297 -12.523235321044922 -36.0
        vertex 153.28770446777344 -13.292929649353027 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.28770446777344 -13.292929649353027 -36.0
        vertex 153.74537658691406 -13.951593399047852 -36.0
        vertex 154.3880615234375 -14.431431770324707 -36.0
    endloop
endfacet
facet normal -0.0 0.0 1.0
    outer loop
        vertex 154.3880615234375 -14.431431770324707 -36.0
        vertex 155.14962768554688 -14.683056831359863 -36.0
        vertex 155.95167541503906 -14.680570602416992 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 155.95167541503906 -14.680570602416992 -36.0
        vertex 156.711669921875 -14.424226760864258 -36.0
        vertex 157.3513641357422 -13.940411567687988 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 157.3513641357422 -13.940411567687988 -36.0
        vertex 157.804931640625 -13.278923034667969 -36.0
        vertex 158.02569580078125 -12.507844924926758 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 158.02569580078125 -12.507844924926758 -36.0
        vertex 157.87777709960938 -11.320444107055664 -36.0
        vertex 156.8726043701172 -10.097091674804688 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 156.8726043701172 -10.097091674804688 -36.0
        vertex 155.3341064453125 -9.722942352294922 -36.0
        vertex 153.87939453125 -10.348072052001953 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.87939453125 -10.348072052001953 -36.0
        vertex 153.09197998046875 -11.721733093261719 -36.0
        vertex 153.28770446777344 -13.292929649353027 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.28770446777344 -13.292929649353027 -36.0
        vertex 154.3880615234375 -14.431431770324707 -36.0
        vertex 155.95167541503906 -14.680570602416992 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 155.95167541503906 -14.680570602416992 -36.0
        vertex 157.3513641357422 -13.940411567687988 -36.0
        vertex 158.02569580078125 -12.507844924926758 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 158.02569580078125 -12.507844924926758 -36.0
        vertex 156.8726043701172 -10.097091674804688 -36.0
        vertex 153.87939453125 -10.348072052001953 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 153.87939453125 -10.348072052001953 -36.0
        vertex 153.28770446777344 -13.292929649353027 -36.0
        vertex 155.95167541503906 -14.680570602416992 -36.0
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 155.95167541503906 -14.680570602416992 -36.0
        vertex 158.02569580078125 -12.507844924926758 -36.0
        vertex 153.87939453125 -10.348072052001953 -36.0
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 140.9053497314453 11.534404754638672 -6.0
        vertex 140.94749450683594 12.506563186645508 -6.0
        vertex 140.94749450683594 12.506563186645508 -6.0
    endloop
endfacet
facet normal 4.182134544542752e-15 7.322929113071672e-16 1.0
    outer loop
        vertex 140.94749450683594 12.506563186645508 -6.0
        vertex 140.7796630859375 13.46505069732666 -6.0
        vertex 140.40969848632812 14.365050315856934 -6.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 140.40969848632812 14.365050315856934 -6.0
        vertex 139.85491943359375 15.164478302001953 -6.0
        vertex 139.14125061035156 15.825955390930176 -6.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 139.14125061035156 15.825955390930176 -6.0
        vertex 138.3020782470703 16.31855010986328 -6.0
        vertex 137.3766326904297 16.619230270385742 -6.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 137.3766326904297 16.619230270385742 -6.0
        vertex 136.40817260742188 16.71393585205078 -6.0
        vertex 135.44200134277344 16.598237991333008 -6.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 135.44200134277344 16.598237991333008 -6.0
        vertex 134.52330017089844 16.27754783630371 -6.0
        vertex 133.69500732421875 15.766860961914062 -6.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 133.69500732421875 15.766860961914062 -6.0
        vertex 132.99586486816406 15.090054512023926 -6.0
        vertex 132.45855712890625 14.278777122497559 -6.0
    endloop
endfacet
facet normal -4.197060959139267e-15 6.413504248318211e-16 1.0
    outer loop
        vertex 132.45855712890625 14.278777122497559 -6.0
        vertex 132.10821533203125 13.370962142944336 -6.0
        vertex 131.9612274169922 12.409058570861816 -6.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 131.9612274169922 12.409058570861816 -6.0
        vertex 132.02444458007812 11.438042640686035 -6.0
        vertex 132.294921875 10.50331974029541 -6.0
    endloop
endfacet
facet normal -3.2062952028236212e-15 -2.7838654724677983e-15 1.0
    outer loop
        vertex 132.294921875 10.50331974029541 -6.0
        vertex 132.76002502441406 9.648595809936523 -6.0
        vertex 133.39797973632812 8.913836479187012 -6.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 133.39797973632812 8.913836479187012 -6.0
        vertex 134.17898559570312 8.33339786529541 -6.0
        vertex 135.06649780273438 7.934422016143799 -6.0
    endloop
endfacet
facet normal -0.0 0.0 1.0
    outer loop
        vertex 135.06649780273438 7.934422016143799 -6.0
        vertex 136.01902770996094 7.7355637550354 -6.0
        vertex 136.99205017089844 7.746121406555176 -6.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 136.99205017089844 7.746121406555176 -6.0
        vertex 137.94004821777344 7.965601444244385 -6.0
        vertex 138.81869506835938 8.38374137878418 -6.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 138.81869506835938 8.38374137878418 -6.0
        vertex 139.5869140625 8.980988502502441 -6.0
        vertex 140.2087860107422 9.72941780090332 -6.0
    endloop
endfacet
facet normal -4.1030216672692e-15 1.0913306958904782e-15 1.0
    outer loop
        vertex 140.2087860107422 9.72941780090332 -6.0
        vertex 140.6552276611328 10.594033241271973 -6.0
        vertex 140.9053497314453 11.534404754638672 -6.0
    endloop
endfacet
facet normal 1.436334309208088e-15 -6.226761541415016e-17 1.0
    outer loop
        vertex 140.9053497314453 11.534404754638672 -6.0
        vertex 140.94749450683594 12.506563186645508 -6.0
        vertex 140.40969848632812 14.365050315856934 -6.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 140.40969848632812 14.365050315856934 -6.0
        vertex 139.14125061035156 15.825955390930176 -6.0
        vertex 137.3766326904297 16.619230270385742 -6.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 137.3766326904297 16.619230270385742 -6.0
        vertex 135.44200134277344 16.598237991333008 -6.0
        vertex 133.69500732421875 15.766860961914062 -6.0
    endloop
endfacet
facet normal 8.409019639633961e-16 -6.98706202063962e-16 1.0
    outer loop
        vertex 133.69500732421875 15.766860961914062 -6.0
        vertex 132.45855712890625 14.278777122497559 -6.0
        vertex 131.9612274169922 12.409058570861816 -6.0
    endloop
endfacet
facet normal 1.0769197008423672e-15 1.8856840701166327e-16 1.0
    outer loop
        vertex 131.9612274169922 12.409058570861816 -6.0
        vertex 132.294921875 10.50331974029541 -6.0
        vertex 133.39797973632812 8.913836479187012 -6.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 133.39797973632812 8.913836479187012 -6.0
        vertex 135.06649780273438 7.934422016143799 -6.0
        vertex 136.99205017089844 7.746121406555176 -6.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 136.99205017089844 7.746121406555176 -6.0
        vertex 138.81869506835938 8.38374137878418 -6.0
        vertex 140.2087860107422 9.72941780090332 -6.0
    endloop
endfacet
facet normal -3.1781247928220745e-16 -3.6942193206061596e-16 1.0
    outer loop
        vertex 140.2087860107422 9.72941780090332 -6.0
        vertex 140.9053497314453 11.534404754638672 -6.0
        vertex 140.40969848632812 14.365050315856934 -6.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 140.40969848632812 14.365050315856934 -6.0
        vertex 137.3766326904297 16.619230270385742 -6.0
        vertex 133.69500732421875 15.766860961914062 -6.0
    endloop
endfacet
facet normal -1.1213718641828198e-17 -2.5872168740651415e-16 1.0
    outer loop
        vertex 133.69500732421875 15.766860961914062 -6.0
        vertex 131.9612274169922 12.409058570861816 -6.0
        vertex 133.39797973632812 8.913836479187012 -6.0
    endloop
endfacet
facet normal -0.0 0.0 1.0
    outer loop
        vertex 133.39797973632812 8.913836479187012 -6.0
        vertex 136.99205017089844 7.746121406555176 -6.0
        vertex 140.2087860107422 9.72941780090332 -6.0
    endloop
endfacet
facet normal -7.928164197084717e-17 -3.797600750609731e-16 1.0
    outer loop
        vertex 140.2087860107422 9.72941780090332 -6.0
        vertex 140.40969848632812 14.365050315856934 -6.0
        vertex 133.69500732421875 15.766860961914062 -6.0
    endloop
endfacet
facet normal 3.1201583577745225e-17 -2.605600665394112e-16 1.0
    outer loop
        vertex 133.69500732421875 15.766860961914062 -6.0
        vertex 133.39797973632812 8.913836479187012 -6.0
        vertex 140.2087860107422 9.72941780090332 -6.0
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 138.92831420898438 11.836536407470703 -18.0
        vertex 138.95172119140625 12.37662410736084 -18.0
        vertex 138.95172119140625 12.37662410736084 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 138.95172119140625 12.37662410736084 -18.0
        vertex 138.8584747314453 12.909117698669434 -18.0
        vertex 138.65293884277344 13.409116744995117 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 138.65293884277344 13.409116744995117 -18.0
        vertex 138.3447265625 13.853243827819824 -18.0
        vertex 137.94825744628906 14.220730781555176 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 137.94825744628906 14.220730781555176 -18.0
        vertex 137.48204040527344 14.494394302368164 -18.0
        vertex 136.96791076660156 14.661438941955566 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 136.96791076660156 14.661438941955566 -18.0
        vertex 136.42987060546875 14.7140531539917 -18.0
        vertex 135.8931121826172 14.649776458740234 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 135.8931121826172 14.649776458740234 -18.0
        vertex 135.38272094726562 14.4716157913208 -18.0
        vertex 134.9225616455078 14.18790054321289 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.9225616455078 14.18790054321289 -18.0
        vertex 134.53414916992188 13.811897277832031 -18.0
        vertex 134.2356414794922 13.361186981201172 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.2356414794922 13.361186981201172 -18.0
        vertex 134.041015625 12.85684585571289 -18.0
        vertex 133.9593505859375 12.322454452514648 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 133.9593505859375 12.322454452514648 -18.0
        vertex 133.9944610595703 11.783001899719238 -18.0
        vertex 134.1447296142578 11.263710975646973 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.1447296142578 11.263710975646973 -18.0
        vertex 134.4031219482422 10.788864135742188 -18.0
        vertex 134.75753784179688 10.380664825439453 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.75753784179688 10.380664825439453 -18.0
        vertex 135.19143676757812 10.058198928833008 -18.0
        vertex 135.6844940185547 9.836545944213867 -18.0
    endloop
endfacet
facet normal -0.0 0.0 1.0
    outer loop
        vertex 135.6844940185547 9.836545944213867 -18.0
        vertex 136.21368408203125 9.726068496704102 -18.0
        vertex 136.75424194335938 9.731934547424316 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 136.75424194335938 9.731934547424316 -18.0
        vertex 137.28091430664062 9.853867530822754 -18.0
        vertex 137.76905822753906 10.086167335510254 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 137.76905822753906 10.086167335510254 -18.0
        vertex 138.1958465576172 10.41797161102295 -18.0
        vertex 138.54132080078125 10.833765983581543 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 138.54132080078125 10.833765983581543 -18.0
        vertex 138.7893524169922 11.314106941223145 -18.0
        vertex 138.92831420898438 11.836536407470703 -18.0
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 138.92831420898438 11.836536407470703 -18.0
        vertex 138.95172119140625 12.37662410736084 -18.0
        vertex 138.65293884277344 13.409116744995117 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 138.65293884277344 13.409116744995117 -18.0
        vertex 137.94825744628906 14.220730781555176 -18.0
        vertex 136.96791076660156 14.661438941955566 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 136.96791076660156 14.661438941955566 -18.0
        vertex 135.8931121826172 14.649776458740234 -18.0
        vertex 134.9225616455078 14.18790054321289 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.9225616455078 14.18790054321289 -18.0
        vertex 134.2356414794922 13.361186981201172 -18.0
        vertex 133.9593505859375 12.322454452514648 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 133.9593505859375 12.322454452514648 -18.0
        vertex 134.1447296142578 11.263710975646973 -18.0
        vertex 134.75753784179688 10.380664825439453 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.75753784179688 10.380664825439453 -18.0
        vertex 135.6844940185547 9.836545944213867 -18.0
        vertex 136.75424194335938 9.731934547424316 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 136.75424194335938 9.731934547424316 -18.0
        vertex 137.76905822753906 10.086167335510254 -18.0
        vertex 138.54132080078125 10.833765983581543 -18.0
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 138.54132080078125 10.833765983581543 -18.0
        vertex 138.92831420898438 11.836536407470703 -18.0
        vertex 138.65293884277344 13.409116744995117 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 138.65293884277344 13.409116744995117 -18.0
        vertex 136.96791076660156 14.661438941955566 -18.0
        vertex 134.9225616455078 14.18790054321289 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.9225616455078 14.18790054321289 -18.0
        vertex 133.9593505859375 12.322454452514648 -18.0
        vertex 134.75753784179688 10.380664825439453 -18.0
    endloop
endfacet
facet normal -0.0 0.0 1.0
    outer loop
        vertex 134.75753784179688 10.380664825439453 -18.0
        vertex 136.75424194335938 9.731934547424316 -18.0
        vertex 138.54132080078125 10.833765983581543 -18.0
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 138.54132080078125 10.833765983581543 -18.0
        vertex 138.65293884277344 13.409116744995117 -18.0
        vertex 134.9225616455078 14.18790054321289 -18.0
    endloop
endfacet
facet normal -0.0 0.0 1.0
    outer loop
        vertex 134.9225616455078 14.18790054321289 -18.0
        vertex 134.75753784179688 10.380664825439453 -18.0
        vertex 138.54132080078125 10.833765983581543 -18.0
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 138.939697265625 11.920555114746094 -18.0
        vertex 138.95465087890625 12.322609901428223 -18.0
        vertex 138.95465087890625 12.322609901428223 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 138.95465087890625 12.322609901428223 -18.0
        vertex 138.9049072265625 12.721857070922852 -18.0
        vertex 138.79177856445312 13.107955932617188 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 138.79177856445312 13.107955932617188 -18.0
        vertex 138.61817932128906 13.470907211303711 -18.0
        vertex 138.3885955810547 13.801310539245605 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 138.3885955810547 13.801310539245605 -18.0
        vertex 138.10899353027344 14.090608596801758 -18.0
        vertex 137.78660583496094 14.331308364868164 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 137.78660583496094 14.331308364868164 -18.0
        vertex 137.42977905273438 14.517175674438477 -18.0
        vertex 137.04776000976562 14.64339828491211 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 137.04776000976562 14.64339828491211 -18.0
        vertex 136.6504364013672 14.706705093383789 -18.0
        vertex 136.24810791015625 14.70545768737793 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 136.24810791015625 14.70545768737793 -18.0
        vertex 135.85118103027344 14.639687538146973 -18.0
        vertex 135.46995544433594 14.511098861694336 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 135.46995544433594 14.511098861694336 -18.0
        vertex 135.11428833007812 14.32302188873291 -18.0
        vertex 134.79339599609375 14.080327987670898 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.79339599609375 14.080327987670898 -18.0
        vertex 134.51559448242188 13.789300918579102 -18.0
        vertex 134.28807067871094 13.457480430603027 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.28807067871094 13.457480430603027 -18.0
        vertex 134.11671447753906 13.093460083007812 -18.0
        vertex 134.0059814453125 12.706666946411133 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.0059814453125 12.706666946411133 -18.0
        vertex 133.95872497558594 12.307119369506836 -18.0
        vertex 133.97618103027344 11.90516471862793 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 133.97618103027344 11.90516471862793 -18.0
        vertex 134.05787658691406 11.511214256286621 -18.0
        vertex 134.2017059326172 11.135470390319824 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.2017059326172 11.135470390319824 -18.0
        vertex 134.40396118164062 10.787665367126465 -18.0
        vertex 134.6593780517578 10.476806640625 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.6593780517578 10.476806640625 -18.0
        vertex 134.9613494873047 10.210946083068848 -18.0
        vertex 135.30206298828125 9.996968269348145 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 135.30206298828125 9.996968269348145 -18.0
        vertex 135.6726837158203 9.840415954589844 -18.0
        vertex 136.06362915039062 9.745343208312988 -18.0
    endloop
endfacet
facet normal -0.0 0.0 1.0
    outer loop
        vertex 136.06362915039062 9.745343208312988 -18.0
        vertex 136.46475219726562 9.714212417602539 -18.0
        vertex 136.8656768798828 9.74782943725586 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 136.8656768798828 9.74782943725586 -18.0
        vertex 137.25601196289062 9.845325469970703 -18.0
        vertex 137.62567138671875 10.004173278808594 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 137.62567138671875 10.004173278808594 -18.0
        vertex 137.9650421142578 10.220259666442871 -18.0
        vertex 138.26536560058594 10.487987518310547 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 138.26536560058594 10.487987518310547 -18.0
        vertex 138.51885986328125 10.800424575805664 -18.0
        vertex 138.71893310546875 11.149477005004883 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 138.71893310546875 11.149477005004883 -18.0
        vertex 138.86044311523438 11.526104927062988 -18.0
        vertex 138.939697265625 11.920555114746094 -18.0
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 138.939697265625 11.920555114746094 -18.0
        vertex 138.95465087890625 12.322609901428223 -18.0
        vertex 138.79177856445312 13.107955932617188 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 138.79177856445312 13.107955932617188 -18.0
        vertex 138.3885955810547 13.801310539245605 -18.0
        vertex 137.78660583496094 14.331308364868164 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 137.78660583496094 14.331308364868164 -18.0
        vertex 137.04776000976562 14.64339828491211 -18.0
        vertex 136.24810791015625 14.70545768737793 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 136.24810791015625 14.70545768737793 -18.0
        vertex 135.46995544433594 14.511098861694336 -18.0
        vertex 134.79339599609375 14.080327987670898 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.79339599609375 14.080327987670898 -18.0
        vertex 134.28807067871094 13.457480430603027 -18.0
        vertex 134.0059814453125 12.706666946411133 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.0059814453125 12.706666946411133 -18.0
        vertex 133.97618103027344 11.90516471862793 -18.0
        vertex 134.2017059326172 11.135470390319824 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.2017059326172 11.135470390319824 -18.0
        vertex 134.6593780517578 10.476806640625 -18.0
        vertex 135.30206298828125 9.996968269348145 -18.0
    endloop
endfacet
facet normal -0.0 0.0 1.0
    outer loop
        vertex 135.30206298828125 9.996968269348145 -18.0
        vertex 136.06362915039062 9.745343208312988 -18.0
        vertex 136.8656768798828 9.74782943725586 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 136.8656768798828 9.74782943725586 -18.0
        vertex 137.62567138671875 10.004173278808594 -18.0
        vertex 138.26536560058594 10.487987518310547 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 138.26536560058594 10.487987518310547 -18.0
        vertex 138.71893310546875 11.149477005004883 -18.0
        vertex 138.939697265625 11.920555114746094 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 138.939697265625 11.920555114746094 -18.0
        vertex 138.79177856445312 13.107955932617188 -18.0
        vertex 137.78660583496094 14.331308364868164 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 137.78660583496094 14.331308364868164 -18.0
        vertex 136.24810791015625 14.70545768737793 -18.0
        vertex 134.79339599609375 14.080327987670898 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.79339599609375 14.080327987670898 -18.0
        vertex 134.0059814453125 12.706666946411133 -18.0
        vertex 134.2017059326172 11.135470390319824 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.2017059326172 11.135470390319824 -18.0
        vertex 135.30206298828125 9.996968269348145 -18.0
        vertex 136.8656768798828 9.74782943725586 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 136.8656768798828 9.74782943725586 -18.0
        vertex 138.26536560058594 10.487987518310547 -18.0
        vertex 138.939697265625 11.920555114746094 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 138.939697265625 11.920555114746094 -18.0
        vertex 137.78660583496094 14.331308364868164 -18.0
        vertex 134.79339599609375 14.080327987670898 -18.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.79339599609375 14.080327987670898 -18.0
        vertex 134.2017059326172 11.135470390319824 -18.0
        vertex 136.8656768798828 9.74782943725586 -18.0
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 136.8656768798828 9.74782943725586 -18.0
        vertex 138.939697265625 11.920555114746094 -18.0
        vertex 134.79339599609375 14.080327987670898 -18.0
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 138.939697265625 11.920555114746094 -36.0
        vertex 138.95465087890625 12.322609901428223 -36.0
        vertex 138.95465087890625 12.322609901428223 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 138.95465087890625 12.322609901428223 -36.0
        vertex 138.9049072265625 12.721857070922852 -36.0
        vertex 138.79177856445312 13.107955932617188 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 138.79177856445312 13.107955932617188 -36.0
        vertex 138.61817932128906 13.470907211303711 -36.0
        vertex 138.3885955810547 13.801310539245605 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 138.3885955810547 13.801310539245605 -36.0
        vertex 138.10899353027344 14.090608596801758 -36.0
        vertex 137.78660583496094 14.331308364868164 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 137.78660583496094 14.331308364868164 -36.0
        vertex 137.42977905273438 14.517175674438477 -36.0
        vertex 137.04776000976562 14.64339828491211 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 137.04776000976562 14.64339828491211 -36.0
        vertex 136.6504364013672 14.706705093383789 -36.0
        vertex 136.24810791015625 14.70545768737793 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 136.24810791015625 14.70545768737793 -36.0
        vertex 135.85118103027344 14.639687538146973 -36.0
        vertex 135.46995544433594 14.511098861694336 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 135.46995544433594 14.511098861694336 -36.0
        vertex 135.11428833007812 14.32302188873291 -36.0
        vertex 134.79339599609375 14.080327987670898 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.79339599609375 14.080327987670898 -36.0
        vertex 134.51559448242188 13.789300918579102 -36.0
        vertex 134.28807067871094 13.457480430603027 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.28807067871094 13.457480430603027 -36.0
        vertex 134.11671447753906 13.093460083007812 -36.0
        vertex 134.0059814453125 12.706666946411133 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.0059814453125 12.706666946411133 -36.0
        vertex 133.95872497558594 12.307119369506836 -36.0
        vertex 133.97618103027344 11.90516471862793 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 133.97618103027344 11.90516471862793 -36.0
        vertex 134.05787658691406 11.511214256286621 -36.0
        vertex 134.2017059326172 11.135470390319824 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.2017059326172 11.135470390319824 -36.0
        vertex 134.40396118164062 10.787665367126465 -36.0
        vertex 134.6593780517578 10.476806640625 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.6593780517578 10.476806640625 -36.0
        vertex 134.9613494873047 10.210946083068848 -36.0
        vertex 135.30206298828125 9.996968269348145 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 135.30206298828125 9.996968269348145 -36.0
        vertex 135.6726837158203 9.840415954589844 -36.0
        vertex 136.06362915039062 9.745343208312988 -36.0
    endloop
endfacet
facet normal -0.0 0.0 1.0
    outer loop
        vertex 136.06362915039062 9.745343208312988 -36.0
        vertex 136.46475219726562 9.714212417602539 -36.0
        vertex 136.8656768798828 9.74782943725586 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 136.8656768798828 9.74782943725586 -36.0
        vertex 137.25601196289062 9.845325469970703 -36.0
        vertex 137.62567138671875 10.004173278808594 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 137.62567138671875 10.004173278808594 -36.0
        vertex 137.9650421142578 10.220259666442871 -36.0
        vertex 138.26536560058594 10.487987518310547 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 138.26536560058594 10.487987518310547 -36.0
        vertex 138.51885986328125 10.800424575805664 -36.0
        vertex 138.71893310546875 11.149477005004883 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 138.71893310546875 11.149477005004883 -36.0
        vertex 138.86044311523438 11.526104927062988 -36.0
        vertex 138.939697265625 11.920555114746094 -36.0
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 138.939697265625 11.920555114746094 -36.0
        vertex 138.95465087890625 12.322609901428223 -36.0
        vertex 138.79177856445312 13.107955932617188 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 138.79177856445312 13.107955932617188 -36.0
        vertex 138.3885955810547 13.801310539245605 -36.0
        vertex 137.78660583496094 14.331308364868164 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 137.78660583496094 14.331308364868164 -36.0
        vertex 137.04776000976562 14.64339828491211 -36.0
        vertex 136.24810791015625 14.70545768737793 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 136.24810791015625 14.70545768737793 -36.0
        vertex 135.46995544433594 14.511098861694336 -36.0
        vertex 134.79339599609375 14.080327987670898 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.79339599609375 14.080327987670898 -36.0
        vertex 134.28807067871094 13.457480430603027 -36.0
        vertex 134.0059814453125 12.706666946411133 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.0059814453125 12.706666946411133 -36.0
        vertex 133.97618103027344 11.90516471862793 -36.0
        vertex 134.2017059326172 11.135470390319824 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.2017059326172 11.135470390319824 -36.0
        vertex 134.6593780517578 10.476806640625 -36.0
        vertex 135.30206298828125 9.996968269348145 -36.0
    endloop
endfacet
facet normal -0.0 0.0 1.0
    outer loop
        vertex 135.30206298828125 9.996968269348145 -36.0
        vertex 136.06362915039062 9.745343208312988 -36.0
        vertex 136.8656768798828 9.74782943725586 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 136.8656768798828 9.74782943725586 -36.0
        vertex 137.62567138671875 10.004173278808594 -36.0
        vertex 138.26536560058594 10.487987518310547 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 138.26536560058594 10.487987518310547 -36.0
        vertex 138.71893310546875 11.149477005004883 -36.0
        vertex 138.939697265625 11.920555114746094 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 138.939697265625 11.920555114746094 -36.0
        vertex 138.79177856445312 13.107955932617188 -36.0
        vertex 137.78660583496094 14.331308364868164 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 137.78660583496094 14.331308364868164 -36.0
        vertex 136.24810791015625 14.70545768737793 -36.0
        vertex 134.79339599609375 14.080327987670898 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.79339599609375 14.080327987670898 -36.0
        vertex 134.0059814453125 12.706666946411133 -36.0
        vertex 134.2017059326172 11.135470390319824 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.2017059326172 11.135470390319824 -36.0
        vertex 135.30206298828125 9.996968269348145 -36.0
        vertex 136.8656768798828 9.74782943725586 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 136.8656768798828 9.74782943725586 -36.0
        vertex 138.26536560058594 10.487987518310547 -36.0
        vertex 138.939697265625 11.920555114746094 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 138.939697265625 11.920555114746094 -36.0
        vertex 137.78660583496094 14.331308364868164 -36.0
        vertex 134.79339599609375 14.080327987670898 -36.0
    endloop
endfacet
facet normal 0.0 0.0 1.0
    outer loop
        vertex 134.79339599609375 14.080327987670898 -36.0
        vertex 134.2017059326172 11.135470390319824 -36.0
        vertex 136.8656768798828 9.74782943725586 -36.0
    endloop
endfacet
facet normal 0.0 -0.0 1.0
    outer loop
        vertex 136.8656768798828 9.74782943725586 -36.0
        vertex 138.939697265625 11.920555114746094 -36.0
        vertex 134.79339599609375 14.080327987670898 -36.0
    endloop
endfacet
facet normal 0.8515531420707703 0.5242683291435242 2.0317376965138956e-16
    outer loop
        vertex 270.02789306640625 -8.166666984558105 -0.625
        vertex 270.02789306640625 -8.166666984558105 -5.208700180053711
        vertex 269.4122314453125 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 1.2063445881773706e-16
    outer loop
        vertex 265.3078308105469 -0.5 -0.625
        vertex 265.3078308105469 -0.5 -5.208700180053711
        vertex 264.6921691894531 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.8515531420707703 0.5242683291435242 2.0317376965138956e-16
    outer loop
        vertex 260.5877685546875 7.166666507720947 -0.625
        vertex 260.5877685546875 7.166666507720947 -5.208700180053711
        vertex 259.97210693359375 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 2.0317383582583857e-16
    outer loop
        vertex 255.86769104003906 14.833333015441895 -0.625
        vertex 255.86769104003906 14.833333015441895 -5.208700180053711
        vertex 255.2520294189453 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 -4.839794200961478e-07
    outer loop
        vertex 277.41815185546875 -20.170421600341797 -5.208700180053711
        vertex 278.8523864746094 -22.5 -0.625
        vertex 279.4680480957031 -23.5 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 -0.0
    outer loop
        vertex 250.53195190429688 23.5 -0.625
        vertex 248.9927978515625 26.0 -0.625
        vertex 248.9927978515625 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 0.0
    outer loop
        vertex 248.9927978515625 26.0 5.773159728050814e-15
        vertex 281.0072021484375 -26.0 -5.773159728050814e-15
        vertex 281.0072021484375 -26.0 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 2.0317383582583857e-16
    outer loop
        vertex 274.74798583984375 -15.833333015441895 -0.625
        vertex 274.74798583984375 -15.833333015441895 -5.208700180053711
        vertex 274.13232421875 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.8515531420707703 0.5242683291435242 1.0158688482569478e-16
    outer loop
        vertex 270.02789306640625 -8.166666984558105 -0.625
        vertex 269.4122314453125 -7.166666507720947 -5.208700180053711
        vertex 269.4122314453125 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 1.1428528513357603e-16
    outer loop
        vertex 265.3078308105469 -0.5 -0.625
        vertex 264.6921691894531 0.5 -5.208700180053711
        vertex 264.6921691894531 0.5 -0.625
    endloop
endfacet
facet normal 0.8515531420707703 0.5242683291435242 2.0317376965138956e-16
    outer loop
        vertex 260.5877685546875 7.166666507720947 -0.625
        vertex 259.97210693359375 8.166666984558105 -5.208700180053711
        vertex 259.97210693359375 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 2.0317383582583857e-16
    outer loop
        vertex 255.86769104003906 14.833333015441895 -0.625
        vertex 255.2520294189453 15.833333015441895 -5.208700180053711
        vertex 255.2520294189453 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8515533208847046 0.5242679715156555 -1.0176847808907041e-06
    outer loop
        vertex 277.41815185546875 -20.170421600341797 -5.208700180053711
        vertex 279.4680480957031 -23.5 -0.625
        vertex 277.8904113769531 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8515533804893494 0.524267852306366 7.225395529530942e-05
    outer loop
        vertex 248.9927978515625 26.0 5.773159728050814e-15
        vertex 281.0072021484375 -26.0 -0.625
        vertex 274.74798583984375 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 2.0317383582583857e-16
    outer loop
        vertex 274.74798583984375 -15.833333015441895 -0.625
        vertex 274.13232421875 -14.833333015441895 -5.208700180053711
        vertex 274.13232421875 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8515530824661255 0.5242684483528137 -2.0633538042602595e-06
    outer loop
        vertex 252.58184814453125 20.170421600341797 -5.208700180053711
        vertex 277.41815185546875 -20.170421600341797 -5.208700180053711
        vertex 277.8904113769531 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 1.4126569112704601e-05
    outer loop
        vertex 248.9927978515625 26.0 5.773159728050814e-15
        vertex 274.74798583984375 -15.833333015441895 -0.625
        vertex 274.13232421875 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8515530824661255 0.524268388748169 1.98775978788035e-06
    outer loop
        vertex 252.58184814453125 20.170421600341797 -5.208700180053711
        vertex 277.8904113769531 -20.9375 -5.666999816894531
        vertex 252.10958862304688 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8515518307685852 0.5242704153060913 -0.00015892369265202433
    outer loop
        vertex 248.9927978515625 26.0 5.773159728050814e-15
        vertex 274.13232421875 -14.833333015441895 -0.625
        vertex 270.02789306640625 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8515533804893494 0.5242679119110107 8.947282026383618e-07
    outer loop
        vertex 251.14761352539062 22.5 -0.625
        vertex 252.58184814453125 20.170421600341797 -5.208700180053711
        vertex 252.10958862304688 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8515531420707703 0.5242683291435242 -4.6041694190535054e-07
    outer loop
        vertex 248.9927978515625 26.0 5.773159728050814e-15
        vertex 270.02789306640625 -8.166666984558105 -0.625
        vertex 269.4122314453125 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 6.442715516641329e-07
    outer loop
        vertex 251.14761352539062 22.5 -0.625
        vertex 252.10958862304688 20.9375 -5.666999816894531
        vertex 250.53195190429688 23.5 -0.625
    endloop
endfacet
facet normal 0.8515535593032837 0.5242675542831421 5.456321014207788e-05
    outer loop
        vertex 248.9927978515625 26.0 5.773159728050814e-15
        vertex 269.4122314453125 -7.166666507720947 -0.625
        vertex 265.3078308105469 -0.5 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 3.0253240725438982e-15
    outer loop
        vertex 251.14761352539062 22.5 -0.625
        vertex 250.53195190429688 23.5 -0.625
        vertex 248.9927978515625 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 0.0
    outer loop
        vertex 248.9927978515625 26.0 5.773159728050814e-15
        vertex 265.3078308105469 -0.5 -0.625
        vertex 264.6921691894531 0.5 -0.625
    endloop
endfacet
facet normal 0.8515527248382568 0.5242689847946167 -3.4982308534381445e-06
    outer loop
        vertex 255.2520294189453 15.833333015441895 -0.625
        vertex 251.14761352539062 22.5 -0.625
        vertex 248.9927978515625 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8515535593032837 0.5242675542831421 5.2504219638649374e-05
    outer loop
        vertex 248.9927978515625 26.0 5.773159728050814e-15
        vertex 264.6921691894531 0.5 -0.625
        vertex 260.5877685546875 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 6.663299245701637e-06
    outer loop
        vertex 255.86769104003906 14.833333015441895 -0.625
        vertex 255.2520294189453 15.833333015441895 -0.625
        vertex 248.9927978515625 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8515531420707703 0.5242683291435242 2.1259636923787184e-05
    outer loop
        vertex 248.9927978515625 26.0 5.773159728050814e-15
        vertex 260.5877685546875 7.166666507720947 -0.625
        vertex 259.97210693359375 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8515527248382568 0.5242690443992615 -5.837676781084156e-06
    outer loop
        vertex 259.97210693359375 8.166666984558105 -0.625
        vertex 255.86769104003906 14.833333015441895 -0.625
        vertex 248.9927978515625 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835622668266296 0.46831366419792175 1.8148922327586704e-16
    outer loop
        vertex 259.4114685058594 -8.166666984558105 -0.625
        vertex 259.4114685058594 -8.166666984558105 -5.208700180053711
        vertex 258.8814392089844 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.0775684486706252e-16
    outer loop
        vertex 255.34800720214844 -0.5 -0.625
        vertex 255.34800720214844 -0.5 -5.208700180053711
        vertex 254.8179931640625 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 1.8148514692980838e-16
    outer loop
        vertex 251.2845458984375 7.166666507720947 -0.625
        vertex 251.2845458984375 7.166666507720947 -5.208700180053711
        vertex 250.75453186035156 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.8148521310425739e-16
    outer loop
        vertex 247.22108459472656 14.833333015441895 -0.625
        vertex 247.22108459472656 14.833333015441895 -5.208700180053711
        vertex 246.69107055664062 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.8835622072219849 0.4683138430118561 6.574685357918497e-06
    outer loop
        vertex 265.7736511230469 -20.170421600341797 -5.208700180053711
        vertex 267.00836181640625 -22.5 -0.625
        vertex 267.53839111328125 -23.5 -0.625
    endloop
endfacet
facet normal 0.8835688829421997 0.4683012068271637 -0.0
    outer loop
        vertex 242.6276092529297 23.5 -0.625
        vertex 241.30258178710938 26.0 -0.625
        vertex 241.30258178710938 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835669159889221 0.46830493211746216 0.0
    outer loop
        vertex 241.30258178710938 26.0 5.773159728050814e-15
        vertex 268.8634338378906 -26.0 -5.773159728050814e-15
        vertex 268.8634338378906 -26.0 -0.625
    endloop
endfacet
facet normal 0.8835733532905579 0.46829280257225037 1.8148113675819873e-16
    outer loop
        vertex 263.47491455078125 -15.833333015441895 -0.625
        vertex 263.47491455078125 -15.833333015441895 -5.208700180053711
        vertex 262.9449157714844 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.8835622668266296 0.46831366419792175 9.074461163793352e-17
    outer loop
        vertex 259.4114685058594 -8.166666984558105 -0.625
        vertex 258.8814392089844 -7.166666507720947 -5.208700180053711
        vertex 258.8814392089844 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.0208542988960294e-16
    outer loop
        vertex 255.34800720214844 -0.5 -0.625
        vertex 254.8179931640625 0.5 -5.208700180053711
        vertex 254.8179931640625 0.5 -0.625
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 1.8148514692980838e-16
    outer loop
        vertex 251.2845458984375 7.166666507720947 -0.625
        vertex 250.75453186035156 8.166666984558105 -5.208700180053711
        vertex 250.75453186035156 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.8148521310425739e-16
    outer loop
        vertex 247.22108459472656 14.833333015441895 -0.625
        vertex 246.69107055664062 15.833333015441895 -5.208700180053711
        vertex 246.69107055664062 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.883569598197937 0.46829989552497864 -6.413144546968397e-06
    outer loop
        vertex 265.7736511230469 -20.170421600341797 -5.208700180053711
        vertex 267.53839111328125 -23.5 -0.625
        vertex 266.1802062988281 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835662007331848 0.4683062434196472 -0.00013881924678571522
    outer loop
        vertex 241.30258178710938 26.0 5.773159728050814e-15
        vertex 268.8634338378906 -26.0 -0.625
        vertex 263.47491455078125 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8835733532905579 0.46829280257225037 1.8148113675819873e-16
    outer loop
        vertex 263.47491455078125 -15.833333015441895 -0.625
        vertex 262.9449157714844 -14.833333015441895 -5.208700180053711
        vertex 262.9449157714844 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8835669755935669 0.468304842710495 -1.7024543922161683e-05
    outer loop
        vertex 244.39234924316406 20.170421600341797 -5.208700180053711
        vertex 265.7736511230469 -20.170421600341797 -5.208700180053711
        vertex 266.1802062988281 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835728764533997 0.46829256415367126 0.0010141035309061408
    outer loop
        vertex 241.30258178710938 26.0 5.773159728050814e-15
        vertex 263.47491455078125 -15.833333015441895 -0.625
        vertex 262.9449157714844 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8835669755935669 0.4683047831058502 -1.2478082680900116e-05
    outer loop
        vertex 244.39234924316406 20.170421600341797 -5.208700180053711
        vertex 266.1802062988281 -20.9375 -5.666999816894531
        vertex 243.98577880859375 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835666179656982 0.46830546855926514 -4.582256588037126e-05
    outer loop
        vertex 241.30258178710938 26.0 5.773159728050814e-15
        vertex 262.9449157714844 -14.833333015441895 -0.625
        vertex 259.4114685058594 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8835647702217102 0.4683090150356293 -3.431093091421644e-06
    outer loop
        vertex 243.1576385498047 22.5 -0.625
        vertex 244.39234924316406 20.170421600341797 -5.208700180053711
        vertex 243.98577880859375 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835620880126953 0.4683135747909546 -0.0006207899423316121
    outer loop
        vertex 241.30258178710938 26.0 5.773159728050814e-15
        vertex 259.4114685058594 -8.166666984558105 -0.625
        vertex 258.8814392089844 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.8835622072219849 0.4683138430118561 -5.347913429432083e-06
    outer loop
        vertex 243.1576385498047 22.5 -0.625
        vertex 243.98577880859375 20.9375 -5.666999816894531
        vertex 242.6276092529297 23.5 -0.625
    endloop
endfacet
facet normal 0.8835675120353699 0.4683038592338562 4.6444543841062114e-05
    outer loop
        vertex 241.30258178710938 26.0 5.773159728050814e-15
        vertex 258.8814392089844 -7.166666507720947 -0.625
        vertex 255.34800720214844 -0.5 -0.625
    endloop
endfacet
facet normal 0.8835622072219849 0.4683138430118561 -6.471402593888342e-05
    outer loop
        vertex 243.1576385498047 22.5 -0.625
        vertex 242.6276092529297 23.5 -0.625
        vertex 241.30258178710938 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 7.550017471658066e-05
    outer loop
        vertex 241.30258178710938 26.0 5.773159728050814e-15
        vertex 255.34800720214844 -0.5 -0.625
        vertex 254.8179931640625 0.5 -0.625
    endloop
endfacet
facet normal 0.8835675120353699 0.4683038294315338 7.135779014788568e-06
    outer loop
        vertex 246.69107055664062 15.833333015441895 -0.625
        vertex 243.1576385498047 22.5 -0.625
        vertex 241.30258178710938 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835666179656982 0.46830543875694275 -3.4969863918377087e-05
    outer loop
        vertex 241.30258178710938 26.0 5.773159728050814e-15
        vertex 254.8179931640625 0.5 -0.625
        vertex 251.2845458984375 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.7738040696713142e-05
    outer loop
        vertex 247.22108459472656 14.833333015441895 -0.625
        vertex 246.69107055664062 15.833333015441895 -0.625
        vertex 241.30258178710938 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 5.334801608114503e-05
    outer loop
        vertex 241.30258178710938 26.0 5.773159728050814e-15
        vertex 251.2845458984375 7.166666507720947 -0.625
        vertex 250.75453186035156 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8835666179656982 0.46830546855926514 -3.123616988887079e-05
    outer loop
        vertex 250.75453186035156 8.166666984558105 -0.625
        vertex 247.22108459472656 14.833333015441895 -0.625
        vertex 241.30258178710938 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835622668266296 0.46831366419792175 1.8148922327586704e-16
    outer loop
        vertex 259.4114685058594 -8.166666984558105 -0.625
        vertex 259.4114685058594 -8.166666984558105 -5.208700180053711
        vertex 258.8814392089844 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.0775684486706252e-16
    outer loop
        vertex 255.34800720214844 -0.5 -0.625
        vertex 255.34800720214844 -0.5 -5.208700180053711
        vertex 254.8179931640625 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 1.8148514692980838e-16
    outer loop
        vertex 251.2845458984375 7.166666507720947 -0.625
        vertex 251.2845458984375 7.166666507720947 -5.208700180053711
        vertex 250.75453186035156 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.8148521310425739e-16
    outer loop
        vertex 247.22108459472656 14.833333015441895 -0.625
        vertex 247.22108459472656 14.833333015441895 -5.208700180053711
        vertex 246.69107055664062 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.8835622072219849 0.4683138430118561 6.574685357918497e-06
    outer loop
        vertex 265.7736511230469 -20.170421600341797 -5.208700180053711
        vertex 267.00836181640625 -22.5 -0.625
        vertex 267.53839111328125 -23.5 -0.625
    endloop
endfacet
facet normal 0.8835688829421997 0.4683012068271637 -0.0
    outer loop
        vertex 242.6276092529297 23.5 -0.625
        vertex 241.30258178710938 26.0 -0.625
        vertex 241.30258178710938 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835669159889221 0.46830493211746216 0.0
    outer loop
        vertex 241.30258178710938 26.0 5.773159728050814e-15
        vertex 268.8634338378906 -26.0 -5.773159728050814e-15
        vertex 268.8634338378906 -26.0 -0.625
    endloop
endfacet
facet normal 0.8835733532905579 0.46829280257225037 1.8148113675819873e-16
    outer loop
        vertex 263.47491455078125 -15.833333015441895 -0.625
        vertex 263.47491455078125 -15.833333015441895 -5.208700180053711
        vertex 262.9449157714844 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.8835622668266296 0.46831366419792175 9.074461163793352e-17
    outer loop
        vertex 259.4114685058594 -8.166666984558105 -0.625
        vertex 258.8814392089844 -7.166666507720947 -5.208700180053711
        vertex 258.8814392089844 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.0208542988960294e-16
    outer loop
        vertex 255.34800720214844 -0.5 -0.625
        vertex 254.8179931640625 0.5 -5.208700180053711
        vertex 254.8179931640625 0.5 -0.625
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 1.8148514692980838e-16
    outer loop
        vertex 251.2845458984375 7.166666507720947 -0.625
        vertex 250.75453186035156 8.166666984558105 -5.208700180053711
        vertex 250.75453186035156 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.8148521310425739e-16
    outer loop
        vertex 247.22108459472656 14.833333015441895 -0.625
        vertex 246.69107055664062 15.833333015441895 -5.208700180053711
        vertex 246.69107055664062 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.883569598197937 0.46829989552497864 -6.413144546968397e-06
    outer loop
        vertex 265.7736511230469 -20.170421600341797 -5.208700180053711
        vertex 267.53839111328125 -23.5 -0.625
        vertex 266.1802062988281 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835662007331848 0.4683062434196472 -0.00013881924678571522
    outer loop
        vertex 241.30258178710938 26.0 5.773159728050814e-15
        vertex 268.8634338378906 -26.0 -0.625
        vertex 263.47491455078125 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8835733532905579 0.46829280257225037 1.8148113675819873e-16
    outer loop
        vertex 263.47491455078125 -15.833333015441895 -0.625
        vertex 262.9449157714844 -14.833333015441895 -5.208700180053711
        vertex 262.9449157714844 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8835669755935669 0.468304842710495 -1.7024543922161683e-05
    outer loop
        vertex 244.39234924316406 20.170421600341797 -5.208700180053711
        vertex 265.7736511230469 -20.170421600341797 -5.208700180053711
        vertex 266.1802062988281 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835728764533997 0.46829256415367126 0.0010141035309061408
    outer loop
        vertex 241.30258178710938 26.0 5.773159728050814e-15
        vertex 263.47491455078125 -15.833333015441895 -0.625
        vertex 262.9449157714844 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8835669755935669 0.4683047831058502 -1.2478082680900116e-05
    outer loop
        vertex 244.39234924316406 20.170421600341797 -5.208700180053711
        vertex 266.1802062988281 -20.9375 -5.666999816894531
        vertex 243.98577880859375 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835666179656982 0.46830546855926514 -4.582256588037126e-05
    outer loop
        vertex 241.30258178710938 26.0 5.773159728050814e-15
        vertex 262.9449157714844 -14.833333015441895 -0.625
        vertex 259.4114685058594 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8835647702217102 0.4683090150356293 -3.431093091421644e-06
    outer loop
        vertex 243.1576385498047 22.5 -0.625
        vertex 244.39234924316406 20.170421600341797 -5.208700180053711
        vertex 243.98577880859375 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835620880126953 0.4683135747909546 -0.0006207899423316121
    outer loop
        vertex 241.30258178710938 26.0 5.773159728050814e-15
        vertex 259.4114685058594 -8.166666984558105 -0.625
        vertex 258.8814392089844 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.8835622072219849 0.4683138430118561 -5.347913429432083e-06
    outer loop
        vertex 243.1576385498047 22.5 -0.625
        vertex 243.98577880859375 20.9375 -5.666999816894531
        vertex 242.6276092529297 23.5 -0.625
    endloop
endfacet
facet normal 0.8835675120353699 0.4683038592338562 4.6444543841062114e-05
    outer loop
        vertex 241.30258178710938 26.0 5.773159728050814e-15
        vertex 258.8814392089844 -7.166666507720947 -0.625
        vertex 255.34800720214844 -0.5 -0.625
    endloop
endfacet
facet normal 0.8835622072219849 0.4683138430118561 -6.471402593888342e-05
    outer loop
        vertex 243.1576385498047 22.5 -0.625
        vertex 242.6276092529297 23.5 -0.625
        vertex 241.30258178710938 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 7.550017471658066e-05
    outer loop
        vertex 241.30258178710938 26.0 5.773159728050814e-15
        vertex 255.34800720214844 -0.5 -0.625
        vertex 254.8179931640625 0.5 -0.625
    endloop
endfacet
facet normal 0.8835675120353699 0.4683038294315338 7.135779014788568e-06
    outer loop
        vertex 246.69107055664062 15.833333015441895 -0.625
        vertex 243.1576385498047 22.5 -0.625
        vertex 241.30258178710938 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835666179656982 0.46830543875694275 -3.4969863918377087e-05
    outer loop
        vertex 241.30258178710938 26.0 5.773159728050814e-15
        vertex 254.8179931640625 0.5 -0.625
        vertex 251.2845458984375 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.7738040696713142e-05
    outer loop
        vertex 247.22108459472656 14.833333015441895 -0.625
        vertex 246.69107055664062 15.833333015441895 -0.625
        vertex 241.30258178710938 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 5.334801608114503e-05
    outer loop
        vertex 241.30258178710938 26.0 5.773159728050814e-15
        vertex 251.2845458984375 7.166666507720947 -0.625
        vertex 250.75453186035156 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8835666179656982 0.46830546855926514 -3.123616988887079e-05
    outer loop
        vertex 250.75453186035156 8.166666984558105 -0.625
        vertex 247.22108459472656 14.833333015441895 -0.625
        vertex 241.30258178710938 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 1.514166287376934e-16
    outer loop
        vertex 248.6333465576172 -8.166666984558105 -0.625
        vertex 248.6333465576172 -8.166666984558105 -5.208700180053711
        vertex 248.20889282226562 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 8.990366012254271e-17
    outer loop
        vertex 245.3792266845703 -0.5 -0.625
        vertex 245.3792266845703 -0.5 -5.208700180053711
        vertex 244.95477294921875 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 1.514166287376934e-16
    outer loop
        vertex 242.12510681152344 7.166666507720947 -0.625
        vertex 242.12510681152344 7.166666507720947 -5.208700180053711
        vertex 241.70065307617188 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 1.514166949121424e-16
    outer loop
        vertex 238.87100219726562 14.833333015441895 -0.625
        vertex 238.87100219726562 14.833333015441895 -5.208700180053711
        vertex 238.44654846191406 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 2.7037767722504213e-06
    outer loop
        vertex 253.72833251953125 -20.170421600341797 -5.208700180053711
        vertex 254.7171173095703 -22.5 -0.625
        vertex 255.14157104492188 -23.5 -0.625
    endloop
endfacet
facet normal 0.920512855052948 0.39071229100227356 -0.0
    outer loop
        vertex 235.1924285888672 23.5 -0.625
        vertex 234.1313018798828 26.0 -0.625
        vertex 234.1313018798828 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 0.0
    outer loop
        vertex 234.1313018798828 26.0 5.773159728050814e-15
        vertex 256.20269775390625 -26.0 -5.773159728050814e-15
        vertex 256.20269775390625 -26.0 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 1.514166949121424e-16
    outer loop
        vertex 251.887451171875 -15.833333015441895 -0.625
        vertex 251.887451171875 -15.833333015441895 -5.208700180053711
        vertex 251.46299743652344 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 7.57083143688467e-17
    outer loop
        vertex 248.6333465576172 -8.166666984558105 -0.625
        vertex 248.20889282226562 -7.166666507720947 -5.208700180053711
        vertex 248.20889282226562 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 8.517188923371887e-17
    outer loop
        vertex 245.3792266845703 -0.5 -0.625
        vertex 244.95477294921875 0.5 -5.208700180053711
        vertex 244.95477294921875 0.5 -0.625
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 1.514166287376934e-16
    outer loop
        vertex 242.12510681152344 7.166666507720947 -0.625
        vertex 241.70065307617188 8.166666984558105 -5.208700180053711
        vertex 241.70065307617188 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 1.514166949121424e-16
    outer loop
        vertex 238.87100219726562 14.833333015441895 -0.625
        vertex 238.44654846191406 15.833333015441895 -5.208700180053711
        vertex 238.44654846191406 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205160140991211 0.390704870223999 -5.718965439882595e-06
    outer loop
        vertex 253.72833251953125 -20.170421600341797 -5.208700180053711
        vertex 255.14157104492188 -23.5 -0.625
        vertex 254.0539093017578 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205129146575928 0.3907121419906616 -4.208839527564123e-05
    outer loop
        vertex 234.1313018798828 26.0 5.773159728050814e-15
        vertex 256.20269775390625 -26.0 -0.625
        vertex 251.887451171875 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 1.514166949121424e-16
    outer loop
        vertex 251.887451171875 -15.833333015441895 -0.625
        vertex 251.46299743652344 -14.833333015441895 -5.208700180053711
        vertex 251.46299743652344 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907116651535034 -1.9161656382493675e-05
    outer loop
        vertex 236.6056671142578 20.170421600341797 -5.208700180053711
        vertex 253.72833251953125 -20.170421600341797 -5.208700180053711
        vertex 254.0539093017578 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.920511782169342 0.3907146751880646 -0.0002432634646538645
    outer loop
        vertex 234.1313018798828 26.0 5.773159728050814e-15
        vertex 251.887451171875 -15.833333015441895 -0.625
        vertex 251.46299743652344 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205132722854614 0.39071130752563477 1.84596428880468e-05
    outer loop
        vertex 236.6056671142578 20.170421600341797 -5.208700180053711
        vertex 254.0539093017578 -20.9375 -5.666999816894531
        vertex 236.28009033203125 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205138087272644 0.3907099664211273 0.00012136849545640871
    outer loop
        vertex 234.1313018798828 26.0 5.773159728050814e-15
        vertex 251.46299743652344 -14.833333015441895 -0.625
        vertex 248.6333465576172 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9205164313316345 0.39070388674736023 3.7785082440677797e-06
    outer loop
        vertex 235.61688232421875 22.5 -0.625
        vertex 236.6056671142578 20.170421600341797 -5.208700180053711
        vertex 236.28009033203125 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 -0.00017354698502458632
    outer loop
        vertex 234.1313018798828 26.0 5.773159728050814e-15
        vertex 248.6333465576172 -8.166666984558105 -0.625
        vertex 248.20889282226562 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 -1.741111645969795e-07
    outer loop
        vertex 235.61688232421875 22.5 -0.625
        vertex 236.28009033203125 20.9375 -5.666999816894531
        vertex 235.1924285888672 23.5 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 2.4142145775840618e-06
    outer loop
        vertex 234.1313018798828 26.0 5.773159728050814e-15
        vertex 248.20889282226562 -7.166666507720947 -0.625
        vertex 245.3792266845703 -0.5 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 -1.1236717000429053e-05
    outer loop
        vertex 235.61688232421875 22.5 -0.625
        vertex 235.1924285888672 23.5 -0.625
        vertex 234.1313018798828 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 -0.00014607732009608299
    outer loop
        vertex 234.1313018798828 26.0 5.773159728050814e-15
        vertex 245.3792266845703 -0.5 -0.625
        vertex 244.95477294921875 0.5 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907116949558258 8.531880666851066e-06
    outer loop
        vertex 238.44654846191406 15.833333015441895 -0.625
        vertex 235.61688232421875 22.5 -0.625
        vertex 234.1313018798828 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 -3.1892470815364504e-06
    outer loop
        vertex 234.1313018798828 26.0 5.773159728050814e-15
        vertex 244.95477294921875 0.5 -0.625
        vertex 242.12510681152344 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 -4.8891168262343854e-05
    outer loop
        vertex 238.87100219726562 14.833333015441895 -0.625
        vertex 238.44654846191406 15.833333015441895 -0.625
        vertex 234.1313018798828 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 -0.0001031069114105776
    outer loop
        vertex 234.1313018798828 26.0 5.773159728050814e-15
        vertex 242.12510681152344 7.166666507720947 -0.625
        vertex 241.70065307617188 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9205138683319092 0.3907099664211273 5.082455390947871e-05
    outer loop
        vertex 241.70065307617188 8.166666984558105 -0.625
        vertex 238.87100219726562 14.833333015441895 -0.625
        vertex 234.1313018798828 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 1.514166287376934e-16
    outer loop
        vertex 248.6333465576172 -8.166666984558105 -0.625
        vertex 248.6333465576172 -8.166666984558105 -5.208700180053711
        vertex 248.20889282226562 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 8.990366012254271e-17
    outer loop
        vertex 245.3792266845703 -0.5 -0.625
        vertex 245.3792266845703 -0.5 -5.208700180053711
        vertex 244.95477294921875 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 1.514166287376934e-16
    outer loop
        vertex 242.12510681152344 7.166666507720947 -0.625
        vertex 242.12510681152344 7.166666507720947 -5.208700180053711
        vertex 241.70065307617188 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 1.514166949121424e-16
    outer loop
        vertex 238.87100219726562 14.833333015441895 -0.625
        vertex 238.87100219726562 14.833333015441895 -5.208700180053711
        vertex 238.44654846191406 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 2.7037767722504213e-06
    outer loop
        vertex 253.72833251953125 -20.170421600341797 -5.208700180053711
        vertex 254.7171173095703 -22.5 -0.625
        vertex 255.14157104492188 -23.5 -0.625
    endloop
endfacet
facet normal 0.920512855052948 0.39071229100227356 -0.0
    outer loop
        vertex 235.1924285888672 23.5 -0.625
        vertex 234.1313018798828 26.0 -0.625
        vertex 234.1313018798828 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 0.0
    outer loop
        vertex 234.1313018798828 26.0 5.773159728050814e-15
        vertex 256.20269775390625 -26.0 -5.773159728050814e-15
        vertex 256.20269775390625 -26.0 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 1.514166949121424e-16
    outer loop
        vertex 251.887451171875 -15.833333015441895 -0.625
        vertex 251.887451171875 -15.833333015441895 -5.208700180053711
        vertex 251.46299743652344 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 7.57083143688467e-17
    outer loop
        vertex 248.6333465576172 -8.166666984558105 -0.625
        vertex 248.20889282226562 -7.166666507720947 -5.208700180053711
        vertex 248.20889282226562 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 8.517188923371887e-17
    outer loop
        vertex 245.3792266845703 -0.5 -0.625
        vertex 244.95477294921875 0.5 -5.208700180053711
        vertex 244.95477294921875 0.5 -0.625
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 1.514166287376934e-16
    outer loop
        vertex 242.12510681152344 7.166666507720947 -0.625
        vertex 241.70065307617188 8.166666984558105 -5.208700180053711
        vertex 241.70065307617188 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 1.514166949121424e-16
    outer loop
        vertex 238.87100219726562 14.833333015441895 -0.625
        vertex 238.44654846191406 15.833333015441895 -5.208700180053711
        vertex 238.44654846191406 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205160140991211 0.390704870223999 -5.718965439882595e-06
    outer loop
        vertex 253.72833251953125 -20.170421600341797 -5.208700180053711
        vertex 255.14157104492188 -23.5 -0.625
        vertex 254.0539093017578 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205129146575928 0.3907121419906616 -4.208839527564123e-05
    outer loop
        vertex 234.1313018798828 26.0 5.773159728050814e-15
        vertex 256.20269775390625 -26.0 -0.625
        vertex 251.887451171875 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 1.514166949121424e-16
    outer loop
        vertex 251.887451171875 -15.833333015441895 -0.625
        vertex 251.46299743652344 -14.833333015441895 -5.208700180053711
        vertex 251.46299743652344 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907116651535034 -1.9161656382493675e-05
    outer loop
        vertex 236.6056671142578 20.170421600341797 -5.208700180053711
        vertex 253.72833251953125 -20.170421600341797 -5.208700180053711
        vertex 254.0539093017578 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.920511782169342 0.3907146751880646 -0.0002432634646538645
    outer loop
        vertex 234.1313018798828 26.0 5.773159728050814e-15
        vertex 251.887451171875 -15.833333015441895 -0.625
        vertex 251.46299743652344 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205132722854614 0.39071130752563477 1.84596428880468e-05
    outer loop
        vertex 236.6056671142578 20.170421600341797 -5.208700180053711
        vertex 254.0539093017578 -20.9375 -5.666999816894531
        vertex 236.28009033203125 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205138087272644 0.3907099664211273 0.00012136849545640871
    outer loop
        vertex 234.1313018798828 26.0 5.773159728050814e-15
        vertex 251.46299743652344 -14.833333015441895 -0.625
        vertex 248.6333465576172 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9205164313316345 0.39070388674736023 3.7785082440677797e-06
    outer loop
        vertex 235.61688232421875 22.5 -0.625
        vertex 236.6056671142578 20.170421600341797 -5.208700180053711
        vertex 236.28009033203125 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 -0.00017354698502458632
    outer loop
        vertex 234.1313018798828 26.0 5.773159728050814e-15
        vertex 248.6333465576172 -8.166666984558105 -0.625
        vertex 248.20889282226562 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 -1.741111645969795e-07
    outer loop
        vertex 235.61688232421875 22.5 -0.625
        vertex 236.28009033203125 20.9375 -5.666999816894531
        vertex 235.1924285888672 23.5 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 2.4142145775840618e-06
    outer loop
        vertex 234.1313018798828 26.0 5.773159728050814e-15
        vertex 248.20889282226562 -7.166666507720947 -0.625
        vertex 245.3792266845703 -0.5 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 -1.1236717000429053e-05
    outer loop
        vertex 235.61688232421875 22.5 -0.625
        vertex 235.1924285888672 23.5 -0.625
        vertex 234.1313018798828 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 -0.00014607732009608299
    outer loop
        vertex 234.1313018798828 26.0 5.773159728050814e-15
        vertex 245.3792266845703 -0.5 -0.625
        vertex 244.95477294921875 0.5 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907116949558258 8.531880666851066e-06
    outer loop
        vertex 238.44654846191406 15.833333015441895 -0.625
        vertex 235.61688232421875 22.5 -0.625
        vertex 234.1313018798828 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 -3.1892470815364504e-06
    outer loop
        vertex 234.1313018798828 26.0 5.773159728050814e-15
        vertex 244.95477294921875 0.5 -0.625
        vertex 242.12510681152344 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 -4.8891168262343854e-05
    outer loop
        vertex 238.87100219726562 14.833333015441895 -0.625
        vertex 238.44654846191406 15.833333015441895 -0.625
        vertex 234.1313018798828 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 -0.0001031069114105776
    outer loop
        vertex 234.1313018798828 26.0 5.773159728050814e-15
        vertex 242.12510681152344 7.166666507720947 -0.625
        vertex 241.70065307617188 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9205138683319092 0.3907099664211273 5.082455390947871e-05
    outer loop
        vertex 241.70065307617188 8.166666984558105 -0.625
        vertex 238.87100219726562 14.833333015441895 -0.625
        vertex 234.1313018798828 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582750797271729 0.28584763407707214 1.1077674893459561e-16
    outer loop
        vertex 237.68601989746094 -8.166666984558105 -0.625
        vertex 237.68601989746094 -8.166666984558105 -5.208700180053711
        vertex 237.38772583007812 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.9582790732383728 0.28583434224128723 6.577063266408363e-17
    outer loop
        vertex 235.39913940429688 -0.5 -0.625
        vertex 235.39913940429688 -0.5 -5.208700180053711
        vertex 235.10086059570312 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.9582750797271729 0.28584763407707214 1.1077674893459561e-16
    outer loop
        vertex 233.11227416992188 7.166666507720947 -0.625
        vertex 233.11227416992188 7.166666507720947 -5.208700180053711
        vertex 232.81398010253906 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.9582750201225281 0.2858477532863617 1.1077679525670992e-16
    outer loop
        vertex 230.82540893554688 14.833333015441895 -0.625
        vertex 230.82540893554688 14.833333015441895 -5.208700180053711
        vertex 230.52711486816406 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9582790732383728 0.28583434224128723 -4.4706580411002506e-06
    outer loop
        vertex 241.26658630371094 -20.170421600341797 -5.208700180053711
        vertex 241.9614715576172 -22.5 -0.625
        vertex 242.25975036621094 -23.5 -0.625
    endloop
endfacet
facet normal 0.9582758545875549 0.2858450710773468 -0.0
    outer loop
        vertex 228.24024963378906 23.5 -0.625
        vertex 227.49452209472656 26.0 -0.625
        vertex 227.49452209472656 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582767486572266 0.28584209084510803 0.0
    outer loop
        vertex 227.49452209472656 26.0 5.773159728050814e-15
        vertex 243.00547790527344 -26.0 -5.773159728050814e-15
        vertex 243.00547790527344 -26.0 -0.625
    endloop
endfacet
facet normal 0.9582750201225281 0.2858477532863617 1.1077679525670992e-16
    outer loop
        vertex 239.97288513183594 -15.833333015441895 -0.625
        vertex 239.97288513183594 -15.833333015441895 -5.208700180053711
        vertex 239.67459106445312 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9582750797271729 0.28584763407707214 5.5388374467297806e-17
    outer loop
        vertex 237.68601989746094 -8.166666984558105 -0.625
        vertex 237.38772583007812 -7.166666507720947 -5.208700180053711
        vertex 237.38772583007812 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9582790732383728 0.28583434224128723 6.230902076689211e-17
    outer loop
        vertex 235.39913940429688 -0.5 -0.625
        vertex 235.10086059570312 0.5 -5.208700180053711
        vertex 235.10086059570312 0.5 -0.625
    endloop
endfacet
facet normal 0.9582750797271729 0.28584763407707214 1.1077674893459561e-16
    outer loop
        vertex 233.11227416992188 7.166666507720947 -0.625
        vertex 232.81398010253906 8.166666984558105 -5.208700180053711
        vertex 232.81398010253906 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9582750201225281 0.2858477532863617 1.1077679525670992e-16
    outer loop
        vertex 230.82540893554688 14.833333015441895 -0.625
        vertex 230.52711486816406 15.833333015441895 -5.208700180053711
        vertex 230.52711486816406 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582780003547668 0.28583788871765137 -1.6552851320739137e-06
    outer loop
        vertex 241.26658630371094 -20.170421600341797 -5.208700180053711
        vertex 242.25975036621094 -23.5 -0.625
        vertex 241.49539184570312 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582766890525818 0.28584223985671997 -1.5364708815468475e-05
    outer loop
        vertex 227.49452209472656 26.0 5.773159728050814e-15
        vertex 243.00547790527344 -26.0 -0.625
        vertex 239.97288513183594 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582750201225281 0.2858477532863617 1.1077679525670992e-16
    outer loop
        vertex 239.97288513183594 -15.833333015441895 -0.625
        vertex 239.67459106445312 -14.833333015441895 -5.208700180053711
        vertex 239.67459106445312 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582767486572266 0.28584206104278564 -9.241280167771038e-06
    outer loop
        vertex 229.23341369628906 20.170421600341797 -5.208700180053711
        vertex 241.26658630371094 -20.170421600341797 -5.208700180053711
        vertex 241.49539184570312 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582749605178833 0.2858477234840393 -0.00041707229684107006
    outer loop
        vertex 227.49452209472656 26.0 5.773159728050814e-15
        vertex 239.97288513183594 -15.833333015441895 -0.625
        vertex 239.67459106445312 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582768082618713 0.2858418822288513 8.902711670089047e-06
    outer loop
        vertex 229.23341369628906 20.170421600341797 -5.208700180053711
        vertex 241.49539184570312 -20.9375 -5.666999816894531
        vertex 229.00460815429688 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582772254943848 0.28584039211273193 0.0001065683172782883
    outer loop
        vertex 227.49452209472656 26.0 5.773159728050814e-15
        vertex 239.67459106445312 -14.833333015441895 -0.625
        vertex 237.68601989746094 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9582778811454773 0.28583824634552 2.30389764510619e-06
    outer loop
        vertex 228.5385284423828 22.5 -0.625
        vertex 229.23341369628906 20.170421600341797 -5.208700180053711
        vertex 229.00460815429688 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582750201225281 0.28584763407707214 -0.0003241288068238646
    outer loop
        vertex 227.49452209472656 26.0 5.773159728050814e-15
        vertex 237.68601989746094 -8.166666984558105 -0.625
        vertex 237.38772583007812 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9582790732383728 0.28583434224128723 3.6250937682780204e-06
    outer loop
        vertex 228.5385284423828 22.5 -0.625
        vertex 229.00460815429688 20.9375 -5.666999816894531
        vertex 228.24024963378906 23.5 -0.625
    endloop
endfacet
facet normal 0.958276629447937 0.2858423888683319 -2.1344840206438676e-05
    outer loop
        vertex 227.49452209472656 26.0 5.773159728050814e-15
        vertex 237.38772583007812 -7.166666507720947 -0.625
        vertex 235.39913940429688 -0.5 -0.625
    endloop
endfacet
facet normal 0.9582790732383728 0.28583434224128723 4.679097037296742e-05
    outer loop
        vertex 228.5385284423828 22.5 -0.625
        vertex 228.24024963378906 23.5 -0.625
        vertex 227.49452209472656 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.958279013633728 0.28583431243896484 0.0003509322414174676
    outer loop
        vertex 227.49452209472656 26.0 5.773159728050814e-15
        vertex 235.39913940429688 -0.5 -0.625
        vertex 235.10086059570312 0.5 -0.625
    endloop
endfacet
facet normal 0.958276629447937 0.2858423888683319 -2.2632143554801587e-06
    outer loop
        vertex 230.52711486816406 15.833333015441895 -0.625
        vertex 228.5385284423828 22.5 -0.625
        vertex 227.49452209472656 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.958276629447937 0.2858423888683319 -7.296680450963322e-06
    outer loop
        vertex 227.49452209472656 26.0 5.773159728050814e-15
        vertex 235.10086059570312 0.5 -0.625
        vertex 233.11227416992188 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9582750201225281 0.2858477532863617 -9.762616537045687e-05
    outer loop
        vertex 230.82540893554688 14.833333015441895 -0.625
        vertex 230.52711486816406 15.833333015441895 -0.625
        vertex 227.49452209472656 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582750797271729 0.28584763407707214 -0.00017922930419445038
    outer loop
        vertex 227.49452209472656 26.0 5.773159728050814e-15
        vertex 233.11227416992188 7.166666507720947 -0.625
        vertex 232.81398010253906 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9582772254943848 0.28584039211273193 4.5573564420919865e-05
    outer loop
        vertex 232.81398010253906 8.166666984558105 -0.625
        vertex 230.82540893554688 14.833333015441895 -0.625
        vertex 227.49452209472656 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582750797271729 0.28584763407707214 1.1077674893459561e-16
    outer loop
        vertex 237.68601989746094 -8.166666984558105 -0.625
        vertex 237.68601989746094 -8.166666984558105 -5.208700180053711
        vertex 237.38772583007812 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.9582790732383728 0.28583434224128723 6.577063266408363e-17
    outer loop
        vertex 235.39913940429688 -0.5 -0.625
        vertex 235.39913940429688 -0.5 -5.208700180053711
        vertex 235.10086059570312 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.9582750797271729 0.28584763407707214 1.1077674893459561e-16
    outer loop
        vertex 233.11227416992188 7.166666507720947 -0.625
        vertex 233.11227416992188 7.166666507720947 -5.208700180053711
        vertex 232.81398010253906 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.9582750201225281 0.2858477532863617 1.1077679525670992e-16
    outer loop
        vertex 230.82540893554688 14.833333015441895 -0.625
        vertex 230.82540893554688 14.833333015441895 -5.208700180053711
        vertex 230.52711486816406 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9582790732383728 0.28583434224128723 -4.4706580411002506e-06
    outer loop
        vertex 241.26658630371094 -20.170421600341797 -5.208700180053711
        vertex 241.9614715576172 -22.5 -0.625
        vertex 242.25975036621094 -23.5 -0.625
    endloop
endfacet
facet normal 0.9582758545875549 0.2858450710773468 -0.0
    outer loop
        vertex 228.24024963378906 23.5 -0.625
        vertex 227.49452209472656 26.0 -0.625
        vertex 227.49452209472656 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582767486572266 0.28584209084510803 0.0
    outer loop
        vertex 227.49452209472656 26.0 5.773159728050814e-15
        vertex 243.00547790527344 -26.0 -5.773159728050814e-15
        vertex 243.00547790527344 -26.0 -0.625
    endloop
endfacet
facet normal 0.9582750201225281 0.2858477532863617 1.1077679525670992e-16
    outer loop
        vertex 239.97288513183594 -15.833333015441895 -0.625
        vertex 239.97288513183594 -15.833333015441895 -5.208700180053711
        vertex 239.67459106445312 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9582750797271729 0.28584763407707214 5.5388374467297806e-17
    outer loop
        vertex 237.68601989746094 -8.166666984558105 -0.625
        vertex 237.38772583007812 -7.166666507720947 -5.208700180053711
        vertex 237.38772583007812 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9582790732383728 0.28583434224128723 6.230902076689211e-17
    outer loop
        vertex 235.39913940429688 -0.5 -0.625
        vertex 235.10086059570312 0.5 -5.208700180053711
        vertex 235.10086059570312 0.5 -0.625
    endloop
endfacet
facet normal 0.9582750797271729 0.28584763407707214 1.1077674893459561e-16
    outer loop
        vertex 233.11227416992188 7.166666507720947 -0.625
        vertex 232.81398010253906 8.166666984558105 -5.208700180053711
        vertex 232.81398010253906 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9582750201225281 0.2858477532863617 1.1077679525670992e-16
    outer loop
        vertex 230.82540893554688 14.833333015441895 -0.625
        vertex 230.52711486816406 15.833333015441895 -5.208700180053711
        vertex 230.52711486816406 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582780003547668 0.28583788871765137 -1.6552851320739137e-06
    outer loop
        vertex 241.26658630371094 -20.170421600341797 -5.208700180053711
        vertex 242.25975036621094 -23.5 -0.625
        vertex 241.49539184570312 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582766890525818 0.28584223985671997 -1.5364708815468475e-05
    outer loop
        vertex 227.49452209472656 26.0 5.773159728050814e-15
        vertex 243.00547790527344 -26.0 -0.625
        vertex 239.97288513183594 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582750201225281 0.2858477532863617 1.1077679525670992e-16
    outer loop
        vertex 239.97288513183594 -15.833333015441895 -0.625
        vertex 239.67459106445312 -14.833333015441895 -5.208700180053711
        vertex 239.67459106445312 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582767486572266 0.28584206104278564 -9.241280167771038e-06
    outer loop
        vertex 229.23341369628906 20.170421600341797 -5.208700180053711
        vertex 241.26658630371094 -20.170421600341797 -5.208700180053711
        vertex 241.49539184570312 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582749605178833 0.2858477234840393 -0.00041707229684107006
    outer loop
        vertex 227.49452209472656 26.0 5.773159728050814e-15
        vertex 239.97288513183594 -15.833333015441895 -0.625
        vertex 239.67459106445312 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582768082618713 0.2858418822288513 8.902711670089047e-06
    outer loop
        vertex 229.23341369628906 20.170421600341797 -5.208700180053711
        vertex 241.49539184570312 -20.9375 -5.666999816894531
        vertex 229.00460815429688 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582772254943848 0.28584039211273193 0.0001065683172782883
    outer loop
        vertex 227.49452209472656 26.0 5.773159728050814e-15
        vertex 239.67459106445312 -14.833333015441895 -0.625
        vertex 237.68601989746094 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9582778811454773 0.28583824634552 2.30389764510619e-06
    outer loop
        vertex 228.5385284423828 22.5 -0.625
        vertex 229.23341369628906 20.170421600341797 -5.208700180053711
        vertex 229.00460815429688 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582750201225281 0.28584763407707214 -0.0003241288068238646
    outer loop
        vertex 227.49452209472656 26.0 5.773159728050814e-15
        vertex 237.68601989746094 -8.166666984558105 -0.625
        vertex 237.38772583007812 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9582790732383728 0.28583434224128723 3.6250937682780204e-06
    outer loop
        vertex 228.5385284423828 22.5 -0.625
        vertex 229.00460815429688 20.9375 -5.666999816894531
        vertex 228.24024963378906 23.5 -0.625
    endloop
endfacet
facet normal 0.958276629447937 0.2858423888683319 -2.1344840206438676e-05
    outer loop
        vertex 227.49452209472656 26.0 5.773159728050814e-15
        vertex 237.38772583007812 -7.166666507720947 -0.625
        vertex 235.39913940429688 -0.5 -0.625
    endloop
endfacet
facet normal 0.9582790732383728 0.28583434224128723 4.679097037296742e-05
    outer loop
        vertex 228.5385284423828 22.5 -0.625
        vertex 228.24024963378906 23.5 -0.625
        vertex 227.49452209472656 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.958279013633728 0.28583431243896484 0.0003509322414174676
    outer loop
        vertex 227.49452209472656 26.0 5.773159728050814e-15
        vertex 235.39913940429688 -0.5 -0.625
        vertex 235.10086059570312 0.5 -0.625
    endloop
endfacet
facet normal 0.958276629447937 0.2858423888683319 -2.2632143554801587e-06
    outer loop
        vertex 230.52711486816406 15.833333015441895 -0.625
        vertex 228.5385284423828 22.5 -0.625
        vertex 227.49452209472656 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.958276629447937 0.2858423888683319 -7.296680450963322e-06
    outer loop
        vertex 227.49452209472656 26.0 5.773159728050814e-15
        vertex 235.10086059570312 0.5 -0.625
        vertex 233.11227416992188 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9582750201225281 0.2858477532863617 -9.762616537045687e-05
    outer loop
        vertex 230.82540893554688 14.833333015441895 -0.625
        vertex 230.52711486816406 15.833333015441895 -0.625
        vertex 227.49452209472656 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582750797271729 0.28584763407707214 -0.00017922930419445038
    outer loop
        vertex 227.49452209472656 26.0 5.773159728050814e-15
        vertex 233.11227416992188 7.166666507720947 -0.625
        vertex 232.81398010253906 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9582772254943848 0.28584039211273193 4.5573564420919865e-05
    outer loop
        vertex 232.81398010253906 8.166666984558105 -0.625
        vertex 230.82540893554688 14.833333015441895 -0.625
        vertex 227.49452209472656 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882932901382446 0.15256589651107788 5.91250437704979e-17
    outer loop
        vertex 226.5937957763672 -8.166666984558105 -0.625
        vertex 226.5937957763672 -8.166666984558105 -5.208700180053711
        vertex 226.43942260742188 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 3.510551210952599e-17
    outer loop
        vertex 225.41018676757812 -0.5 -0.625
        vertex 225.41018676757812 -0.5 -5.208700180053711
        vertex 225.2558135986328 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.9882932901382446 0.15256589651107788 5.91250437704979e-17
    outer loop
        vertex 224.22657775878906 7.166666507720947 -0.625
        vertex 224.22657775878906 7.166666507720947 -5.208700180053711
        vertex 224.07220458984375 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 5.91250702402775e-17
    outer loop
        vertex 223.04296875 14.833333015441895 -0.625
        vertex 223.04296875 14.833333015441895 -5.208700180053711
        vertex 222.8885955810547 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 -5.445960141514661e-06
    outer loop
        vertex 228.44699096679688 -20.170421600341797 -5.208700180053711
        vertex 228.806640625 -22.5 -0.625
        vertex 228.9610137939453 -23.5 -0.625
    endloop
endfacet
facet normal 0.9882910251617432 0.15258069336414337 -0.0
    outer loop
        vertex 221.70498657226562 23.5 -0.625
        vertex 221.3190155029297 26.0 -0.625
        vertex 221.3190155029297 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882916808128357 0.15257644653320312 0.0
    outer loop
        vertex 221.3190155029297 26.0 5.773159728050814e-15
        vertex 229.34698486328125 -26.0 -5.773159728050814e-15
        vertex 229.34698486328125 -26.0 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 5.91250702402775e-17
    outer loop
        vertex 227.77740478515625 -15.833333015441895 -0.625
        vertex 227.77740478515625 -15.833333015441895 -5.208700180053711
        vertex 227.62303161621094 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9882932901382446 0.15256589651107788 2.956252188524895e-17
    outer loop
        vertex 226.5937957763672 -8.166666984558105 -0.625
        vertex 226.43942260742188 -7.166666507720947 -5.208700180053711
        vertex 226.43942260742188 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 3.3257852010156095e-17
    outer loop
        vertex 225.41018676757812 -0.5 -0.625
        vertex 225.2558135986328 0.5 -5.208700180053711
        vertex 225.2558135986328 0.5 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256589651107788 5.91250437704979e-17
    outer loop
        vertex 224.22657775878906 7.166666507720947 -0.625
        vertex 224.07220458984375 8.166666984558105 -5.208700180053711
        vertex 224.07220458984375 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 5.91250702402775e-17
    outer loop
        vertex 223.04296875 14.833333015441895 -0.625
        vertex 222.8885955810547 15.833333015441895 -5.208700180053711
        vertex 222.8885955810547 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882919788360596 0.15257444977760315 8.611122552792949e-07
    outer loop
        vertex 228.44699096679688 -20.170421600341797 -5.208700180053711
        vertex 228.9610137939453 -23.5 -0.625
        vertex 228.56541442871094 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882915616035461 0.15257731080055237 -7.356988498941064e-05
    outer loop
        vertex 221.3190155029297 26.0 5.773159728050814e-15
        vertex 229.34698486328125 -26.0 -0.625
        vertex 227.77740478515625 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 5.91250702402775e-17
    outer loop
        vertex 227.77740478515625 -15.833333015441895 -0.625
        vertex 227.62303161621094 -14.833333015441895 -5.208700180053711
        vertex 227.62303161621094 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882916808128357 0.15257644653320312 -2.556523213570472e-06
    outer loop
        vertex 222.21900939941406 20.170421600341797 -5.208700180053711
        vertex 228.44699096679688 -20.170421600341797 -5.208700180053711
        vertex 228.56541442871094 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882930517196655 0.15256592631340027 0.0007038181647658348
    outer loop
        vertex 221.3190155029297 26.0 5.773159728050814e-15
        vertex 227.77740478515625 -15.833333015441895 -0.625
        vertex 227.62303161621094 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882916808128357 0.15257638692855835 2.462860948071466e-06
    outer loop
        vertex 222.21900939941406 20.170421600341797 -5.208700180053711
        vertex 228.56541442871094 -20.9375 -5.666999816894531
        vertex 222.1005859375 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882914423942566 0.15257775783538818 -8.532179344911128e-05
    outer loop
        vertex 221.3190155029297 26.0 5.773159728050814e-15
        vertex 227.62303161621094 -14.833333015441895 -0.625
        vertex 226.5937957763672 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.98829185962677 0.1525752991437912 5.919278578403464e-07
    outer loop
        vertex 221.85935974121094 22.5 -0.625
        vertex 222.21900939941406 20.170421600341797 -5.208700180053711
        vertex 222.1005859375 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882931113243103 0.1525658667087555 0.0005789559800177813
    outer loop
        vertex 221.3190155029297 26.0 5.773159728050814e-15
        vertex 226.5937957763672 -8.166666984558105 -0.625
        vertex 226.43942260742188 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 3.5517034575605066e-06
    outer loop
        vertex 221.85935974121094 22.5 -0.625
        vertex 222.1005859375 20.9375 -5.666999816894531
        vertex 221.70498657226562 23.5 -0.625
    endloop
endfacet
facet normal 0.9882914423942566 0.15257775783538818 -6.530040263896808e-05
    outer loop
        vertex 221.3190155029297 26.0 5.773159728050814e-15
        vertex 226.43942260742188 -7.166666507720947 -0.625
        vertex 225.41018676757812 -0.5 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 6.0320635384414345e-05
    outer loop
        vertex 221.85935974121094 22.5 -0.625
        vertex 221.70498657226562 23.5 -0.625
        vertex 221.3190155029297 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882931709289551 0.15256595611572266 0.0004463726654648781
    outer loop
        vertex 221.3190155029297 26.0 5.773159728050814e-15
        vertex 225.41018676757812 -0.5 -0.625
        vertex 225.2558135986328 0.5 -0.625
    endloop
endfacet
facet normal 0.9882914423942566 0.152577742934227 -7.197720151452813e-06
    outer loop
        vertex 222.8885955810547 15.833333015441895 -0.625
        vertex 221.85935974121094 22.5 -0.625
        vertex 221.3190155029297 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882914423942566 0.15257775783538818 -4.599201929522678e-05
    outer loop
        vertex 221.3190155029297 26.0 5.773159728050814e-15
        vertex 225.2558135986328 0.5 -0.625
        vertex 224.22657775878906 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 0.00018892704974859953
    outer loop
        vertex 223.04296875 14.833333015441895 -0.625
        vertex 222.8885955810547 15.833333015441895 -0.625
        vertex 221.3190155029297 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882932305335999 0.1525658816099167 0.00031984204542823136
    outer loop
        vertex 221.3190155029297 26.0 5.773159728050814e-15
        vertex 224.22657775878906 7.166666507720947 -0.625
        vertex 224.07220458984375 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9882914423942566 0.15257775783538818 -2.6878613425651565e-05
    outer loop
        vertex 224.07220458984375 8.166666984558105 -0.625
        vertex 223.04296875 14.833333015441895 -0.625
        vertex 221.3190155029297 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882932901382446 0.15256589651107788 5.91250437704979e-17
    outer loop
        vertex 226.5937957763672 -8.166666984558105 -0.625
        vertex 226.5937957763672 -8.166666984558105 -5.208700180053711
        vertex 226.43942260742188 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 3.510551210952599e-17
    outer loop
        vertex 225.41018676757812 -0.5 -0.625
        vertex 225.41018676757812 -0.5 -5.208700180053711
        vertex 225.2558135986328 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.9882932901382446 0.15256589651107788 5.91250437704979e-17
    outer loop
        vertex 224.22657775878906 7.166666507720947 -0.625
        vertex 224.22657775878906 7.166666507720947 -5.208700180053711
        vertex 224.07220458984375 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 5.91250702402775e-17
    outer loop
        vertex 223.04296875 14.833333015441895 -0.625
        vertex 223.04296875 14.833333015441895 -5.208700180053711
        vertex 222.8885955810547 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 -5.445960141514661e-06
    outer loop
        vertex 228.44699096679688 -20.170421600341797 -5.208700180053711
        vertex 228.806640625 -22.5 -0.625
        vertex 228.9610137939453 -23.5 -0.625
    endloop
endfacet
facet normal 0.9882910251617432 0.15258069336414337 -0.0
    outer loop
        vertex 221.70498657226562 23.5 -0.625
        vertex 221.3190155029297 26.0 -0.625
        vertex 221.3190155029297 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882916808128357 0.15257644653320312 0.0
    outer loop
        vertex 221.3190155029297 26.0 5.773159728050814e-15
        vertex 229.34698486328125 -26.0 -5.773159728050814e-15
        vertex 229.34698486328125 -26.0 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 5.91250702402775e-17
    outer loop
        vertex 227.77740478515625 -15.833333015441895 -0.625
        vertex 227.77740478515625 -15.833333015441895 -5.208700180053711
        vertex 227.62303161621094 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9882932901382446 0.15256589651107788 2.956252188524895e-17
    outer loop
        vertex 226.5937957763672 -8.166666984558105 -0.625
        vertex 226.43942260742188 -7.166666507720947 -5.208700180053711
        vertex 226.43942260742188 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 3.3257852010156095e-17
    outer loop
        vertex 225.41018676757812 -0.5 -0.625
        vertex 225.2558135986328 0.5 -5.208700180053711
        vertex 225.2558135986328 0.5 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256589651107788 5.91250437704979e-17
    outer loop
        vertex 224.22657775878906 7.166666507720947 -0.625
        vertex 224.07220458984375 8.166666984558105 -5.208700180053711
        vertex 224.07220458984375 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 5.91250702402775e-17
    outer loop
        vertex 223.04296875 14.833333015441895 -0.625
        vertex 222.8885955810547 15.833333015441895 -5.208700180053711
        vertex 222.8885955810547 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882919788360596 0.15257444977760315 8.611122552792949e-07
    outer loop
        vertex 228.44699096679688 -20.170421600341797 -5.208700180053711
        vertex 228.9610137939453 -23.5 -0.625
        vertex 228.56541442871094 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882915616035461 0.15257731080055237 -7.356988498941064e-05
    outer loop
        vertex 221.3190155029297 26.0 5.773159728050814e-15
        vertex 229.34698486328125 -26.0 -0.625
        vertex 227.77740478515625 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 5.91250702402775e-17
    outer loop
        vertex 227.77740478515625 -15.833333015441895 -0.625
        vertex 227.62303161621094 -14.833333015441895 -5.208700180053711
        vertex 227.62303161621094 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882916808128357 0.15257644653320312 -2.556523213570472e-06
    outer loop
        vertex 222.21900939941406 20.170421600341797 -5.208700180053711
        vertex 228.44699096679688 -20.170421600341797 -5.208700180053711
        vertex 228.56541442871094 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882930517196655 0.15256592631340027 0.0007038181647658348
    outer loop
        vertex 221.3190155029297 26.0 5.773159728050814e-15
        vertex 227.77740478515625 -15.833333015441895 -0.625
        vertex 227.62303161621094 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882916808128357 0.15257638692855835 2.462860948071466e-06
    outer loop
        vertex 222.21900939941406 20.170421600341797 -5.208700180053711
        vertex 228.56541442871094 -20.9375 -5.666999816894531
        vertex 222.1005859375 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882914423942566 0.15257775783538818 -8.532179344911128e-05
    outer loop
        vertex 221.3190155029297 26.0 5.773159728050814e-15
        vertex 227.62303161621094 -14.833333015441895 -0.625
        vertex 226.5937957763672 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.98829185962677 0.1525752991437912 5.919278578403464e-07
    outer loop
        vertex 221.85935974121094 22.5 -0.625
        vertex 222.21900939941406 20.170421600341797 -5.208700180053711
        vertex 222.1005859375 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882931113243103 0.1525658667087555 0.0005789559800177813
    outer loop
        vertex 221.3190155029297 26.0 5.773159728050814e-15
        vertex 226.5937957763672 -8.166666984558105 -0.625
        vertex 226.43942260742188 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 3.5517034575605066e-06
    outer loop
        vertex 221.85935974121094 22.5 -0.625
        vertex 222.1005859375 20.9375 -5.666999816894531
        vertex 221.70498657226562 23.5 -0.625
    endloop
endfacet
facet normal 0.9882914423942566 0.15257775783538818 -6.530040263896808e-05
    outer loop
        vertex 221.3190155029297 26.0 5.773159728050814e-15
        vertex 226.43942260742188 -7.166666507720947 -0.625
        vertex 225.41018676757812 -0.5 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 6.0320635384414345e-05
    outer loop
        vertex 221.85935974121094 22.5 -0.625
        vertex 221.70498657226562 23.5 -0.625
        vertex 221.3190155029297 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882931709289551 0.15256595611572266 0.0004463726654648781
    outer loop
        vertex 221.3190155029297 26.0 5.773159728050814e-15
        vertex 225.41018676757812 -0.5 -0.625
        vertex 225.2558135986328 0.5 -0.625
    endloop
endfacet
facet normal 0.9882914423942566 0.152577742934227 -7.197720151452813e-06
    outer loop
        vertex 222.8885955810547 15.833333015441895 -0.625
        vertex 221.85935974121094 22.5 -0.625
        vertex 221.3190155029297 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882914423942566 0.15257775783538818 -4.599201929522678e-05
    outer loop
        vertex 221.3190155029297 26.0 5.773159728050814e-15
        vertex 225.2558135986328 0.5 -0.625
        vertex 224.22657775878906 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 0.00018892704974859953
    outer loop
        vertex 223.04296875 14.833333015441895 -0.625
        vertex 222.8885955810547 15.833333015441895 -0.625
        vertex 221.3190155029297 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882932305335999 0.1525658816099167 0.00031984204542823136
    outer loop
        vertex 221.3190155029297 26.0 5.773159728050814e-15
        vertex 224.22657775878906 7.166666507720947 -0.625
        vertex 224.07220458984375 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9882914423942566 0.15257775783538818 -2.6878613425651565e-05
    outer loop
        vertex 224.07220458984375 8.166666984558105 -0.625
        vertex 223.04296875 14.833333015441895 -0.625
        vertex 221.3190155029297 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 -8.166666984558105 -0.625
        vertex 215.41700744628906 -8.166666984558105 -5.208700180053711
        vertex 215.41700744628906 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 -0.5 -0.625
        vertex 215.41700744628906 -0.5 -5.208700180053711
        vertex 215.41700744628906 0.5 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 7.166666507720947 -0.625
        vertex 215.41700744628906 7.166666507720947 -5.208700180053711
        vertex 215.41700744628906 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 14.833333015441895 -0.625
        vertex 215.41700744628906 14.833333015441895 -5.208700180053711
        vertex 215.41700744628906 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 215.41700744628906 -20.170421600341797 -5.208700180053711
        vertex 215.41700744628906 -22.5 -0.625
        vertex 215.41700744628906 -23.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 215.41700744628906 23.5 -0.625
        vertex 215.41700744628906 26.0 -0.625
        vertex 215.41700744628906 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 215.41700744628906 26.0 5.773159728050814e-15
        vertex 215.41700744628906 -26.0 -5.773159728050814e-15
        vertex 215.41700744628906 -26.0 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 -15.833333015441895 -0.625
        vertex 215.41700744628906 -15.833333015441895 -5.208700180053711
        vertex 215.41700744628906 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 215.41700744628906 -8.166666984558105 -0.625
        vertex 215.41700744628906 -7.166666507720947 -5.208700180053711
        vertex 215.41700744628906 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 215.41700744628906 -0.5 -0.625
        vertex 215.41700744628906 0.5 -5.208700180053711
        vertex 215.41700744628906 0.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 215.41700744628906 7.166666507720947 -0.625
        vertex 215.41700744628906 8.166666984558105 -5.208700180053711
        vertex 215.41700744628906 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 215.41700744628906 14.833333015441895 -0.625
        vertex 215.41700744628906 15.833333015441895 -5.208700180053711
        vertex 215.41700744628906 15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 215.41700744628906 -20.170421600341797 -5.208700180053711
        vertex 215.41700744628906 -23.5 -0.625
        vertex 215.41700744628906 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 26.0 5.773159728050814e-15
        vertex 215.41700744628906 -26.0 -0.625
        vertex 215.41700744628906 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 215.41700744628906 -15.833333015441895 -0.625
        vertex 215.41700744628906 -14.833333015441895 -5.208700180053711
        vertex 215.41700744628906 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 215.41700744628906 20.170421600341797 -5.208700180053711
        vertex 215.41700744628906 -20.170421600341797 -5.208700180053711
        vertex 215.41700744628906 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 26.0 5.773159728050814e-15
        vertex 215.41700744628906 -15.833333015441895 -0.625
        vertex 215.41700744628906 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 20.170421600341797 -5.208700180053711
        vertex 215.41700744628906 -20.9375 -5.666999816894531
        vertex 215.41700744628906 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 26.0 5.773159728050814e-15
        vertex 215.41700744628906 -14.833333015441895 -0.625
        vertex 215.41700744628906 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 215.41700744628906 22.5 -0.625
        vertex 215.41700744628906 20.170421600341797 -5.208700180053711
        vertex 215.41700744628906 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 26.0 5.773159728050814e-15
        vertex 215.41700744628906 -8.166666984558105 -0.625
        vertex 215.41700744628906 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 22.5 -0.625
        vertex 215.41700744628906 20.9375 -5.666999816894531
        vertex 215.41700744628906 23.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 26.0 5.773159728050814e-15
        vertex 215.41700744628906 -7.166666507720947 -0.625
        vertex 215.41700744628906 -0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 215.41700744628906 22.5 -0.625
        vertex 215.41700744628906 23.5 -0.625
        vertex 215.41700744628906 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 26.0 5.773159728050814e-15
        vertex 215.41700744628906 -0.5 -0.625
        vertex 215.41700744628906 0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 215.41700744628906 15.833333015441895 -0.625
        vertex 215.41700744628906 22.5 -0.625
        vertex 215.41700744628906 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 26.0 5.773159728050814e-15
        vertex 215.41700744628906 0.5 -0.625
        vertex 215.41700744628906 7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 215.41700744628906 14.833333015441895 -0.625
        vertex 215.41700744628906 15.833333015441895 -0.625
        vertex 215.41700744628906 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 26.0 5.773159728050814e-15
        vertex 215.41700744628906 7.166666507720947 -0.625
        vertex 215.41700744628906 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 215.41700744628906 8.166666984558105 -0.625
        vertex 215.41700744628906 14.833333015441895 -0.625
        vertex 215.41700744628906 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 -8.166666984558105 -0.625
        vertex 215.41700744628906 -8.166666984558105 -5.208700180053711
        vertex 215.41700744628906 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 -0.5 -0.625
        vertex 215.41700744628906 -0.5 -5.208700180053711
        vertex 215.41700744628906 0.5 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 7.166666507720947 -0.625
        vertex 215.41700744628906 7.166666507720947 -5.208700180053711
        vertex 215.41700744628906 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 14.833333015441895 -0.625
        vertex 215.41700744628906 14.833333015441895 -5.208700180053711
        vertex 215.41700744628906 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 215.41700744628906 -20.170421600341797 -5.208700180053711
        vertex 215.41700744628906 -22.5 -0.625
        vertex 215.41700744628906 -23.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 215.41700744628906 23.5 -0.625
        vertex 215.41700744628906 26.0 -0.625
        vertex 215.41700744628906 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 215.41700744628906 26.0 5.773159728050814e-15
        vertex 215.41700744628906 -26.0 -5.773159728050814e-15
        vertex 215.41700744628906 -26.0 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 -15.833333015441895 -0.625
        vertex 215.41700744628906 -15.833333015441895 -5.208700180053711
        vertex 215.41700744628906 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 215.41700744628906 -8.166666984558105 -0.625
        vertex 215.41700744628906 -7.166666507720947 -5.208700180053711
        vertex 215.41700744628906 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 215.41700744628906 -0.5 -0.625
        vertex 215.41700744628906 0.5 -5.208700180053711
        vertex 215.41700744628906 0.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 215.41700744628906 7.166666507720947 -0.625
        vertex 215.41700744628906 8.166666984558105 -5.208700180053711
        vertex 215.41700744628906 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 215.41700744628906 14.833333015441895 -0.625
        vertex 215.41700744628906 15.833333015441895 -5.208700180053711
        vertex 215.41700744628906 15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 215.41700744628906 -20.170421600341797 -5.208700180053711
        vertex 215.41700744628906 -23.5 -0.625
        vertex 215.41700744628906 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 26.0 5.773159728050814e-15
        vertex 215.41700744628906 -26.0 -0.625
        vertex 215.41700744628906 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 215.41700744628906 -15.833333015441895 -0.625
        vertex 215.41700744628906 -14.833333015441895 -5.208700180053711
        vertex 215.41700744628906 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 215.41700744628906 20.170421600341797 -5.208700180053711
        vertex 215.41700744628906 -20.170421600341797 -5.208700180053711
        vertex 215.41700744628906 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 26.0 5.773159728050814e-15
        vertex 215.41700744628906 -15.833333015441895 -0.625
        vertex 215.41700744628906 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 20.170421600341797 -5.208700180053711
        vertex 215.41700744628906 -20.9375 -5.666999816894531
        vertex 215.41700744628906 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 26.0 5.773159728050814e-15
        vertex 215.41700744628906 -14.833333015441895 -0.625
        vertex 215.41700744628906 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 215.41700744628906 22.5 -0.625
        vertex 215.41700744628906 20.170421600341797 -5.208700180053711
        vertex 215.41700744628906 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 26.0 5.773159728050814e-15
        vertex 215.41700744628906 -8.166666984558105 -0.625
        vertex 215.41700744628906 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 22.5 -0.625
        vertex 215.41700744628906 20.9375 -5.666999816894531
        vertex 215.41700744628906 23.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 26.0 5.773159728050814e-15
        vertex 215.41700744628906 -7.166666507720947 -0.625
        vertex 215.41700744628906 -0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 215.41700744628906 22.5 -0.625
        vertex 215.41700744628906 23.5 -0.625
        vertex 215.41700744628906 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 26.0 5.773159728050814e-15
        vertex 215.41700744628906 -0.5 -0.625
        vertex 215.41700744628906 0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 215.41700744628906 15.833333015441895 -0.625
        vertex 215.41700744628906 22.5 -0.625
        vertex 215.41700744628906 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 26.0 5.773159728050814e-15
        vertex 215.41700744628906 0.5 -0.625
        vertex 215.41700744628906 7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 215.41700744628906 14.833333015441895 -0.625
        vertex 215.41700744628906 15.833333015441895 -0.625
        vertex 215.41700744628906 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 215.41700744628906 26.0 5.773159728050814e-15
        vertex 215.41700744628906 7.166666507720947 -0.625
        vertex 215.41700744628906 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 215.41700744628906 8.166666984558105 -0.625
        vertex 215.41700744628906 14.833333015441895 -0.625
        vertex 215.41700744628906 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 -8.166666984558105 -0.625
        vertex 205.5 -8.166666984558105 -5.208700180053711
        vertex 205.5 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 -0.5 -0.625
        vertex 205.5 -0.5 -5.208700180053711
        vertex 205.5 0.5 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 7.166666507720947 -0.625
        vertex 205.5 7.166666507720947 -5.208700180053711
        vertex 205.5 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 14.833333015441895 -0.625
        vertex 205.5 14.833333015441895 -5.208700180053711
        vertex 205.5 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 205.5 -20.170421600341797 -5.208700180053711
        vertex 205.5 -22.5 -0.625
        vertex 205.5 -23.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 205.5 23.5 -0.625
        vertex 205.5 26.0 -0.625
        vertex 205.5 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 205.5 26.0 5.773159728050814e-15
        vertex 205.5 -26.0 -5.773159728050814e-15
        vertex 205.5 -26.0 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 -15.833333015441895 -0.625
        vertex 205.5 -15.833333015441895 -5.208700180053711
        vertex 205.5 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 205.5 -8.166666984558105 -0.625
        vertex 205.5 -7.166666507720947 -5.208700180053711
        vertex 205.5 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 205.5 -0.5 -0.625
        vertex 205.5 0.5 -5.208700180053711
        vertex 205.5 0.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 205.5 7.166666507720947 -0.625
        vertex 205.5 8.166666984558105 -5.208700180053711
        vertex 205.5 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 205.5 14.833333015441895 -0.625
        vertex 205.5 15.833333015441895 -5.208700180053711
        vertex 205.5 15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 205.5 -20.170421600341797 -5.208700180053711
        vertex 205.5 -23.5 -0.625
        vertex 205.5 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 26.0 5.773159728050814e-15
        vertex 205.5 -26.0 -0.625
        vertex 205.5 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 205.5 -15.833333015441895 -0.625
        vertex 205.5 -14.833333015441895 -5.208700180053711
        vertex 205.5 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 205.5 20.170421600341797 -5.208700180053711
        vertex 205.5 -20.170421600341797 -5.208700180053711
        vertex 205.5 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 26.0 5.773159728050814e-15
        vertex 205.5 -15.833333015441895 -0.625
        vertex 205.5 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 20.170421600341797 -5.208700180053711
        vertex 205.5 -20.9375 -5.666999816894531
        vertex 205.5 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 26.0 5.773159728050814e-15
        vertex 205.5 -14.833333015441895 -0.625
        vertex 205.5 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 205.5 22.5 -0.625
        vertex 205.5 20.170421600341797 -5.208700180053711
        vertex 205.5 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 26.0 5.773159728050814e-15
        vertex 205.5 -8.166666984558105 -0.625
        vertex 205.5 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 22.5 -0.625
        vertex 205.5 20.9375 -5.666999816894531
        vertex 205.5 23.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 26.0 5.773159728050814e-15
        vertex 205.5 -7.166666507720947 -0.625
        vertex 205.5 -0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 205.5 22.5 -0.625
        vertex 205.5 23.5 -0.625
        vertex 205.5 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 26.0 5.773159728050814e-15
        vertex 205.5 -0.5 -0.625
        vertex 205.5 0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 205.5 15.833333015441895 -0.625
        vertex 205.5 22.5 -0.625
        vertex 205.5 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 26.0 5.773159728050814e-15
        vertex 205.5 0.5 -0.625
        vertex 205.5 7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 205.5 14.833333015441895 -0.625
        vertex 205.5 15.833333015441895 -0.625
        vertex 205.5 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 26.0 5.773159728050814e-15
        vertex 205.5 7.166666507720947 -0.625
        vertex 205.5 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 205.5 8.166666984558105 -0.625
        vertex 205.5 14.833333015441895 -0.625
        vertex 205.5 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 -8.166666984558105 -0.625
        vertex 205.5 -8.166666984558105 -5.208700180053711
        vertex 205.5 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 -0.5 -0.625
        vertex 205.5 -0.5 -5.208700180053711
        vertex 205.5 0.5 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 7.166666507720947 -0.625
        vertex 205.5 7.166666507720947 -5.208700180053711
        vertex 205.5 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 14.833333015441895 -0.625
        vertex 205.5 14.833333015441895 -5.208700180053711
        vertex 205.5 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 205.5 -20.170421600341797 -5.208700180053711
        vertex 205.5 -22.5 -0.625
        vertex 205.5 -23.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 205.5 23.5 -0.625
        vertex 205.5 26.0 -0.625
        vertex 205.5 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 205.5 26.0 5.773159728050814e-15
        vertex 205.5 -26.0 -5.773159728050814e-15
        vertex 205.5 -26.0 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 -15.833333015441895 -0.625
        vertex 205.5 -15.833333015441895 -5.208700180053711
        vertex 205.5 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 205.5 -8.166666984558105 -0.625
        vertex 205.5 -7.166666507720947 -5.208700180053711
        vertex 205.5 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 205.5 -0.5 -0.625
        vertex 205.5 0.5 -5.208700180053711
        vertex 205.5 0.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 205.5 7.166666507720947 -0.625
        vertex 205.5 8.166666984558105 -5.208700180053711
        vertex 205.5 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 205.5 14.833333015441895 -0.625
        vertex 205.5 15.833333015441895 -5.208700180053711
        vertex 205.5 15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 205.5 -20.170421600341797 -5.208700180053711
        vertex 205.5 -23.5 -0.625
        vertex 205.5 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 26.0 5.773159728050814e-15
        vertex 205.5 -26.0 -0.625
        vertex 205.5 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 205.5 -15.833333015441895 -0.625
        vertex 205.5 -14.833333015441895 -5.208700180053711
        vertex 205.5 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 205.5 20.170421600341797 -5.208700180053711
        vertex 205.5 -20.170421600341797 -5.208700180053711
        vertex 205.5 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 26.0 5.773159728050814e-15
        vertex 205.5 -15.833333015441895 -0.625
        vertex 205.5 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 20.170421600341797 -5.208700180053711
        vertex 205.5 -20.9375 -5.666999816894531
        vertex 205.5 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 26.0 5.773159728050814e-15
        vertex 205.5 -14.833333015441895 -0.625
        vertex 205.5 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 205.5 22.5 -0.625
        vertex 205.5 20.170421600341797 -5.208700180053711
        vertex 205.5 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 26.0 5.773159728050814e-15
        vertex 205.5 -8.166666984558105 -0.625
        vertex 205.5 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 22.5 -0.625
        vertex 205.5 20.9375 -5.666999816894531
        vertex 205.5 23.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 26.0 5.773159728050814e-15
        vertex 205.5 -7.166666507720947 -0.625
        vertex 205.5 -0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 205.5 22.5 -0.625
        vertex 205.5 23.5 -0.625
        vertex 205.5 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 26.0 5.773159728050814e-15
        vertex 205.5 -0.5 -0.625
        vertex 205.5 0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 205.5 15.833333015441895 -0.625
        vertex 205.5 22.5 -0.625
        vertex 205.5 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 26.0 5.773159728050814e-15
        vertex 205.5 0.5 -0.625
        vertex 205.5 7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 205.5 14.833333015441895 -0.625
        vertex 205.5 15.833333015441895 -0.625
        vertex 205.5 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 205.5 26.0 5.773159728050814e-15
        vertex 205.5 7.166666507720947 -0.625
        vertex 205.5 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 205.5 8.166666984558105 -0.625
        vertex 205.5 14.833333015441895 -0.625
        vertex 205.5 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 -8.166666984558105 -0.625
        vertex 195.58299255371094 -8.166666984558105 -5.208700180053711
        vertex 195.58299255371094 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 -0.5 -0.625
        vertex 195.58299255371094 -0.5 -5.208700180053711
        vertex 195.58299255371094 0.5 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 7.166666507720947 -0.625
        vertex 195.58299255371094 7.166666507720947 -5.208700180053711
        vertex 195.58299255371094 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 14.833333015441895 -0.625
        vertex 195.58299255371094 14.833333015441895 -5.208700180053711
        vertex 195.58299255371094 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 195.58299255371094 -20.170421600341797 -5.208700180053711
        vertex 195.58299255371094 -22.5 -0.625
        vertex 195.58299255371094 -23.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 195.58299255371094 23.5 -0.625
        vertex 195.58299255371094 26.0 -0.625
        vertex 195.58299255371094 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 195.58299255371094 26.0 5.773159728050814e-15
        vertex 195.58299255371094 -26.0 -5.773159728050814e-15
        vertex 195.58299255371094 -26.0 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 -15.833333015441895 -0.625
        vertex 195.58299255371094 -15.833333015441895 -5.208700180053711
        vertex 195.58299255371094 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 195.58299255371094 -8.166666984558105 -0.625
        vertex 195.58299255371094 -7.166666507720947 -5.208700180053711
        vertex 195.58299255371094 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 195.58299255371094 -0.5 -0.625
        vertex 195.58299255371094 0.5 -5.208700180053711
        vertex 195.58299255371094 0.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 195.58299255371094 7.166666507720947 -0.625
        vertex 195.58299255371094 8.166666984558105 -5.208700180053711
        vertex 195.58299255371094 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 195.58299255371094 14.833333015441895 -0.625
        vertex 195.58299255371094 15.833333015441895 -5.208700180053711
        vertex 195.58299255371094 15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 195.58299255371094 -20.170421600341797 -5.208700180053711
        vertex 195.58299255371094 -23.5 -0.625
        vertex 195.58299255371094 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 26.0 5.773159728050814e-15
        vertex 195.58299255371094 -26.0 -0.625
        vertex 195.58299255371094 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 195.58299255371094 -15.833333015441895 -0.625
        vertex 195.58299255371094 -14.833333015441895 -5.208700180053711
        vertex 195.58299255371094 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 195.58299255371094 20.170421600341797 -5.208700180053711
        vertex 195.58299255371094 -20.170421600341797 -5.208700180053711
        vertex 195.58299255371094 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 26.0 5.773159728050814e-15
        vertex 195.58299255371094 -15.833333015441895 -0.625
        vertex 195.58299255371094 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 20.170421600341797 -5.208700180053711
        vertex 195.58299255371094 -20.9375 -5.666999816894531
        vertex 195.58299255371094 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 26.0 5.773159728050814e-15
        vertex 195.58299255371094 -14.833333015441895 -0.625
        vertex 195.58299255371094 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 195.58299255371094 22.5 -0.625
        vertex 195.58299255371094 20.170421600341797 -5.208700180053711
        vertex 195.58299255371094 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 26.0 5.773159728050814e-15
        vertex 195.58299255371094 -8.166666984558105 -0.625
        vertex 195.58299255371094 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 22.5 -0.625
        vertex 195.58299255371094 20.9375 -5.666999816894531
        vertex 195.58299255371094 23.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 26.0 5.773159728050814e-15
        vertex 195.58299255371094 -7.166666507720947 -0.625
        vertex 195.58299255371094 -0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 195.58299255371094 22.5 -0.625
        vertex 195.58299255371094 23.5 -0.625
        vertex 195.58299255371094 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 26.0 5.773159728050814e-15
        vertex 195.58299255371094 -0.5 -0.625
        vertex 195.58299255371094 0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 195.58299255371094 15.833333015441895 -0.625
        vertex 195.58299255371094 22.5 -0.625
        vertex 195.58299255371094 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 26.0 5.773159728050814e-15
        vertex 195.58299255371094 0.5 -0.625
        vertex 195.58299255371094 7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 195.58299255371094 14.833333015441895 -0.625
        vertex 195.58299255371094 15.833333015441895 -0.625
        vertex 195.58299255371094 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 26.0 5.773159728050814e-15
        vertex 195.58299255371094 7.166666507720947 -0.625
        vertex 195.58299255371094 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 195.58299255371094 8.166666984558105 -0.625
        vertex 195.58299255371094 14.833333015441895 -0.625
        vertex 195.58299255371094 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 -8.166666984558105 -0.625
        vertex 195.58299255371094 -8.166666984558105 -5.208700180053711
        vertex 195.58299255371094 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 -0.5 -0.625
        vertex 195.58299255371094 -0.5 -5.208700180053711
        vertex 195.58299255371094 0.5 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 7.166666507720947 -0.625
        vertex 195.58299255371094 7.166666507720947 -5.208700180053711
        vertex 195.58299255371094 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 14.833333015441895 -0.625
        vertex 195.58299255371094 14.833333015441895 -5.208700180053711
        vertex 195.58299255371094 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 195.58299255371094 -20.170421600341797 -5.208700180053711
        vertex 195.58299255371094 -22.5 -0.625
        vertex 195.58299255371094 -23.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 195.58299255371094 23.5 -0.625
        vertex 195.58299255371094 26.0 -0.625
        vertex 195.58299255371094 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 195.58299255371094 26.0 5.773159728050814e-15
        vertex 195.58299255371094 -26.0 -5.773159728050814e-15
        vertex 195.58299255371094 -26.0 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 -15.833333015441895 -0.625
        vertex 195.58299255371094 -15.833333015441895 -5.208700180053711
        vertex 195.58299255371094 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 195.58299255371094 -8.166666984558105 -0.625
        vertex 195.58299255371094 -7.166666507720947 -5.208700180053711
        vertex 195.58299255371094 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 195.58299255371094 -0.5 -0.625
        vertex 195.58299255371094 0.5 -5.208700180053711
        vertex 195.58299255371094 0.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 195.58299255371094 7.166666507720947 -0.625
        vertex 195.58299255371094 8.166666984558105 -5.208700180053711
        vertex 195.58299255371094 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 195.58299255371094 14.833333015441895 -0.625
        vertex 195.58299255371094 15.833333015441895 -5.208700180053711
        vertex 195.58299255371094 15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 195.58299255371094 -20.170421600341797 -5.208700180053711
        vertex 195.58299255371094 -23.5 -0.625
        vertex 195.58299255371094 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 26.0 5.773159728050814e-15
        vertex 195.58299255371094 -26.0 -0.625
        vertex 195.58299255371094 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 195.58299255371094 -15.833333015441895 -0.625
        vertex 195.58299255371094 -14.833333015441895 -5.208700180053711
        vertex 195.58299255371094 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 195.58299255371094 20.170421600341797 -5.208700180053711
        vertex 195.58299255371094 -20.170421600341797 -5.208700180053711
        vertex 195.58299255371094 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 26.0 5.773159728050814e-15
        vertex 195.58299255371094 -15.833333015441895 -0.625
        vertex 195.58299255371094 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 20.170421600341797 -5.208700180053711
        vertex 195.58299255371094 -20.9375 -5.666999816894531
        vertex 195.58299255371094 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 26.0 5.773159728050814e-15
        vertex 195.58299255371094 -14.833333015441895 -0.625
        vertex 195.58299255371094 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 195.58299255371094 22.5 -0.625
        vertex 195.58299255371094 20.170421600341797 -5.208700180053711
        vertex 195.58299255371094 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 26.0 5.773159728050814e-15
        vertex 195.58299255371094 -8.166666984558105 -0.625
        vertex 195.58299255371094 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 22.5 -0.625
        vertex 195.58299255371094 20.9375 -5.666999816894531
        vertex 195.58299255371094 23.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 26.0 5.773159728050814e-15
        vertex 195.58299255371094 -7.166666507720947 -0.625
        vertex 195.58299255371094 -0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 195.58299255371094 22.5 -0.625
        vertex 195.58299255371094 23.5 -0.625
        vertex 195.58299255371094 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 26.0 5.773159728050814e-15
        vertex 195.58299255371094 -0.5 -0.625
        vertex 195.58299255371094 0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 195.58299255371094 15.833333015441895 -0.625
        vertex 195.58299255371094 22.5 -0.625
        vertex 195.58299255371094 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 26.0 5.773159728050814e-15
        vertex 195.58299255371094 0.5 -0.625
        vertex 195.58299255371094 7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 195.58299255371094 14.833333015441895 -0.625
        vertex 195.58299255371094 15.833333015441895 -0.625
        vertex 195.58299255371094 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 195.58299255371094 26.0 5.773159728050814e-15
        vertex 195.58299255371094 7.166666507720947 -0.625
        vertex 195.58299255371094 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 195.58299255371094 8.166666984558105 -0.625
        vertex 195.58299255371094 14.833333015441895 -0.625
        vertex 195.58299255371094 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882932901382446 0.15256589651107788 5.91250437704979e-17
    outer loop
        vertex 186.92779541015625 -8.166666984558105 -0.625
        vertex 186.92779541015625 -8.166666984558105 -5.208700180053711
        vertex 186.77342224121094 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 3.510551210952599e-17
    outer loop
        vertex 185.7441864013672 -0.5 -0.625
        vertex 185.7441864013672 -0.5 -5.208700180053711
        vertex 185.58981323242188 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.9882932901382446 0.15256589651107788 5.91250437704979e-17
    outer loop
        vertex 184.56057739257812 7.166666507720947 -0.625
        vertex 184.56057739257812 7.166666507720947 -5.208700180053711
        vertex 184.4062042236328 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 5.91250702402775e-17
    outer loop
        vertex 183.37696838378906 14.833333015441895 -0.625
        vertex 183.37696838378906 14.833333015441895 -5.208700180053711
        vertex 183.22259521484375 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 -5.445960141514661e-06
    outer loop
        vertex 188.78099060058594 -20.170421600341797 -5.208700180053711
        vertex 189.14064025878906 -22.5 -0.625
        vertex 189.29501342773438 -23.5 -0.625
    endloop
endfacet
facet normal 0.9882910251617432 0.15258069336414337 -0.0
    outer loop
        vertex 182.0389862060547 23.5 -0.625
        vertex 181.65301513671875 26.0 -0.625
        vertex 181.65301513671875 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882916808128357 0.15257644653320312 0.0
    outer loop
        vertex 181.65301513671875 26.0 5.773159728050814e-15
        vertex 189.6809844970703 -26.0 -5.773159728050814e-15
        vertex 189.6809844970703 -26.0 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 5.91250702402775e-17
    outer loop
        vertex 188.1114044189453 -15.833333015441895 -0.625
        vertex 188.1114044189453 -15.833333015441895 -5.208700180053711
        vertex 187.95703125 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9882932901382446 0.15256589651107788 2.956252188524895e-17
    outer loop
        vertex 186.92779541015625 -8.166666984558105 -0.625
        vertex 186.77342224121094 -7.166666507720947 -5.208700180053711
        vertex 186.77342224121094 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 3.3257852010156095e-17
    outer loop
        vertex 185.7441864013672 -0.5 -0.625
        vertex 185.58981323242188 0.5 -5.208700180053711
        vertex 185.58981323242188 0.5 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256589651107788 5.91250437704979e-17
    outer loop
        vertex 184.56057739257812 7.166666507720947 -0.625
        vertex 184.4062042236328 8.166666984558105 -5.208700180053711
        vertex 184.4062042236328 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 5.91250702402775e-17
    outer loop
        vertex 183.37696838378906 14.833333015441895 -0.625
        vertex 183.22259521484375 15.833333015441895 -5.208700180053711
        vertex 183.22259521484375 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882919788360596 0.15257444977760315 8.611122552792949e-07
    outer loop
        vertex 188.78099060058594 -20.170421600341797 -5.208700180053711
        vertex 189.29501342773438 -23.5 -0.625
        vertex 188.8994140625 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882915616035461 0.15257731080055237 -7.356988498941064e-05
    outer loop
        vertex 181.65301513671875 26.0 5.773159728050814e-15
        vertex 189.6809844970703 -26.0 -0.625
        vertex 188.1114044189453 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 5.91250702402775e-17
    outer loop
        vertex 188.1114044189453 -15.833333015441895 -0.625
        vertex 187.95703125 -14.833333015441895 -5.208700180053711
        vertex 187.95703125 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882916808128357 0.15257644653320312 -2.556523213570472e-06
    outer loop
        vertex 182.55300903320312 20.170421600341797 -5.208700180053711
        vertex 188.78099060058594 -20.170421600341797 -5.208700180053711
        vertex 188.8994140625 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882930517196655 0.15256592631340027 0.0007038181647658348
    outer loop
        vertex 181.65301513671875 26.0 5.773159728050814e-15
        vertex 188.1114044189453 -15.833333015441895 -0.625
        vertex 187.95703125 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882916808128357 0.15257638692855835 2.462860948071466e-06
    outer loop
        vertex 182.55300903320312 20.170421600341797 -5.208700180053711
        vertex 188.8994140625 -20.9375 -5.666999816894531
        vertex 182.43458557128906 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882914423942566 0.15257775783538818 -8.532179344911128e-05
    outer loop
        vertex 181.65301513671875 26.0 5.773159728050814e-15
        vertex 187.95703125 -14.833333015441895 -0.625
        vertex 186.92779541015625 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.98829185962677 0.1525752991437912 5.919278578403464e-07
    outer loop
        vertex 182.193359375 22.5 -0.625
        vertex 182.55300903320312 20.170421600341797 -5.208700180053711
        vertex 182.43458557128906 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882931113243103 0.1525658667087555 0.0005789559800177813
    outer loop
        vertex 181.65301513671875 26.0 5.773159728050814e-15
        vertex 186.92779541015625 -8.166666984558105 -0.625
        vertex 186.77342224121094 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 3.5517034575605066e-06
    outer loop
        vertex 182.193359375 22.5 -0.625
        vertex 182.43458557128906 20.9375 -5.666999816894531
        vertex 182.0389862060547 23.5 -0.625
    endloop
endfacet
facet normal 0.9882914423942566 0.15257775783538818 -6.530040263896808e-05
    outer loop
        vertex 181.65301513671875 26.0 5.773159728050814e-15
        vertex 186.77342224121094 -7.166666507720947 -0.625
        vertex 185.7441864013672 -0.5 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 6.0320635384414345e-05
    outer loop
        vertex 182.193359375 22.5 -0.625
        vertex 182.0389862060547 23.5 -0.625
        vertex 181.65301513671875 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882931709289551 0.15256595611572266 0.0004463726654648781
    outer loop
        vertex 181.65301513671875 26.0 5.773159728050814e-15
        vertex 185.7441864013672 -0.5 -0.625
        vertex 185.58981323242188 0.5 -0.625
    endloop
endfacet
facet normal 0.9882914423942566 0.152577742934227 -7.197720151452813e-06
    outer loop
        vertex 183.22259521484375 15.833333015441895 -0.625
        vertex 182.193359375 22.5 -0.625
        vertex 181.65301513671875 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882914423942566 0.15257775783538818 -4.599201929522678e-05
    outer loop
        vertex 181.65301513671875 26.0 5.773159728050814e-15
        vertex 185.58981323242188 0.5 -0.625
        vertex 184.56057739257812 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 0.00018892704974859953
    outer loop
        vertex 183.37696838378906 14.833333015441895 -0.625
        vertex 183.22259521484375 15.833333015441895 -0.625
        vertex 181.65301513671875 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882932305335999 0.1525658816099167 0.00031984204542823136
    outer loop
        vertex 181.65301513671875 26.0 5.773159728050814e-15
        vertex 184.56057739257812 7.166666507720947 -0.625
        vertex 184.4062042236328 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9882914423942566 0.15257775783538818 -2.6878613425651565e-05
    outer loop
        vertex 184.4062042236328 8.166666984558105 -0.625
        vertex 183.37696838378906 14.833333015441895 -0.625
        vertex 181.65301513671875 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882932901382446 0.15256589651107788 5.91250437704979e-17
    outer loop
        vertex 186.92779541015625 -8.166666984558105 -0.625
        vertex 186.92779541015625 -8.166666984558105 -5.208700180053711
        vertex 186.77342224121094 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 3.510551210952599e-17
    outer loop
        vertex 185.7441864013672 -0.5 -0.625
        vertex 185.7441864013672 -0.5 -5.208700180053711
        vertex 185.58981323242188 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.9882932901382446 0.15256589651107788 5.91250437704979e-17
    outer loop
        vertex 184.56057739257812 7.166666507720947 -0.625
        vertex 184.56057739257812 7.166666507720947 -5.208700180053711
        vertex 184.4062042236328 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 5.91250702402775e-17
    outer loop
        vertex 183.37696838378906 14.833333015441895 -0.625
        vertex 183.37696838378906 14.833333015441895 -5.208700180053711
        vertex 183.22259521484375 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 -5.445960141514661e-06
    outer loop
        vertex 188.78099060058594 -20.170421600341797 -5.208700180053711
        vertex 189.14064025878906 -22.5 -0.625
        vertex 189.29501342773438 -23.5 -0.625
    endloop
endfacet
facet normal 0.9882910251617432 0.15258069336414337 -0.0
    outer loop
        vertex 182.0389862060547 23.5 -0.625
        vertex 181.65301513671875 26.0 -0.625
        vertex 181.65301513671875 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882916808128357 0.15257644653320312 0.0
    outer loop
        vertex 181.65301513671875 26.0 5.773159728050814e-15
        vertex 189.6809844970703 -26.0 -5.773159728050814e-15
        vertex 189.6809844970703 -26.0 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 5.91250702402775e-17
    outer loop
        vertex 188.1114044189453 -15.833333015441895 -0.625
        vertex 188.1114044189453 -15.833333015441895 -5.208700180053711
        vertex 187.95703125 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9882932901382446 0.15256589651107788 2.956252188524895e-17
    outer loop
        vertex 186.92779541015625 -8.166666984558105 -0.625
        vertex 186.77342224121094 -7.166666507720947 -5.208700180053711
        vertex 186.77342224121094 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 3.3257852010156095e-17
    outer loop
        vertex 185.7441864013672 -0.5 -0.625
        vertex 185.58981323242188 0.5 -5.208700180053711
        vertex 185.58981323242188 0.5 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256589651107788 5.91250437704979e-17
    outer loop
        vertex 184.56057739257812 7.166666507720947 -0.625
        vertex 184.4062042236328 8.166666984558105 -5.208700180053711
        vertex 184.4062042236328 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 5.91250702402775e-17
    outer loop
        vertex 183.37696838378906 14.833333015441895 -0.625
        vertex 183.22259521484375 15.833333015441895 -5.208700180053711
        vertex 183.22259521484375 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882919788360596 0.15257444977760315 8.611122552792949e-07
    outer loop
        vertex 188.78099060058594 -20.170421600341797 -5.208700180053711
        vertex 189.29501342773438 -23.5 -0.625
        vertex 188.8994140625 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882915616035461 0.15257731080055237 -7.356988498941064e-05
    outer loop
        vertex 181.65301513671875 26.0 5.773159728050814e-15
        vertex 189.6809844970703 -26.0 -0.625
        vertex 188.1114044189453 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 5.91250702402775e-17
    outer loop
        vertex 188.1114044189453 -15.833333015441895 -0.625
        vertex 187.95703125 -14.833333015441895 -5.208700180053711
        vertex 187.95703125 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882916808128357 0.15257644653320312 -2.556523213570472e-06
    outer loop
        vertex 182.55300903320312 20.170421600341797 -5.208700180053711
        vertex 188.78099060058594 -20.170421600341797 -5.208700180053711
        vertex 188.8994140625 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882930517196655 0.15256592631340027 0.0007038181647658348
    outer loop
        vertex 181.65301513671875 26.0 5.773159728050814e-15
        vertex 188.1114044189453 -15.833333015441895 -0.625
        vertex 187.95703125 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882916808128357 0.15257638692855835 2.462860948071466e-06
    outer loop
        vertex 182.55300903320312 20.170421600341797 -5.208700180053711
        vertex 188.8994140625 -20.9375 -5.666999816894531
        vertex 182.43458557128906 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882914423942566 0.15257775783538818 -8.532179344911128e-05
    outer loop
        vertex 181.65301513671875 26.0 5.773159728050814e-15
        vertex 187.95703125 -14.833333015441895 -0.625
        vertex 186.92779541015625 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.98829185962677 0.1525752991437912 5.919278578403464e-07
    outer loop
        vertex 182.193359375 22.5 -0.625
        vertex 182.55300903320312 20.170421600341797 -5.208700180053711
        vertex 182.43458557128906 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882931113243103 0.1525658667087555 0.0005789559800177813
    outer loop
        vertex 181.65301513671875 26.0 5.773159728050814e-15
        vertex 186.92779541015625 -8.166666984558105 -0.625
        vertex 186.77342224121094 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 3.5517034575605066e-06
    outer loop
        vertex 182.193359375 22.5 -0.625
        vertex 182.43458557128906 20.9375 -5.666999816894531
        vertex 182.0389862060547 23.5 -0.625
    endloop
endfacet
facet normal 0.9882914423942566 0.15257775783538818 -6.530040263896808e-05
    outer loop
        vertex 181.65301513671875 26.0 5.773159728050814e-15
        vertex 186.77342224121094 -7.166666507720947 -0.625
        vertex 185.7441864013672 -0.5 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 6.0320635384414345e-05
    outer loop
        vertex 182.193359375 22.5 -0.625
        vertex 182.0389862060547 23.5 -0.625
        vertex 181.65301513671875 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882931709289551 0.15256595611572266 0.0004463726654648781
    outer loop
        vertex 181.65301513671875 26.0 5.773159728050814e-15
        vertex 185.7441864013672 -0.5 -0.625
        vertex 185.58981323242188 0.5 -0.625
    endloop
endfacet
facet normal 0.9882914423942566 0.152577742934227 -7.197720151452813e-06
    outer loop
        vertex 183.22259521484375 15.833333015441895 -0.625
        vertex 182.193359375 22.5 -0.625
        vertex 181.65301513671875 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882914423942566 0.15257775783538818 -4.599201929522678e-05
    outer loop
        vertex 181.65301513671875 26.0 5.773159728050814e-15
        vertex 185.58981323242188 0.5 -0.625
        vertex 184.56057739257812 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9882932901382446 0.15256597101688385 0.00018892704974859953
    outer loop
        vertex 183.37696838378906 14.833333015441895 -0.625
        vertex 183.22259521484375 15.833333015441895 -0.625
        vertex 181.65301513671875 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882932305335999 0.1525658816099167 0.00031984204542823136
    outer loop
        vertex 181.65301513671875 26.0 5.773159728050814e-15
        vertex 184.56057739257812 7.166666507720947 -0.625
        vertex 184.4062042236328 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9882914423942566 0.15257775783538818 -2.6878613425651565e-05
    outer loop
        vertex 184.4062042236328 8.166666984558105 -0.625
        vertex 183.37696838378906 14.833333015441895 -0.625
        vertex 181.65301513671875 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582750797271729 0.28584763407707214 1.1077674893459561e-16
    outer loop
        vertex 178.18601989746094 -8.166666984558105 -0.625
        vertex 178.18601989746094 -8.166666984558105 -5.208700180053711
        vertex 177.88772583007812 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.9582790732383728 0.28583434224128723 6.577063266408363e-17
    outer loop
        vertex 175.89913940429688 -0.5 -0.625
        vertex 175.89913940429688 -0.5 -5.208700180053711
        vertex 175.60086059570312 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.9582750797271729 0.28584763407707214 1.1077674893459561e-16
    outer loop
        vertex 173.61227416992188 7.166666507720947 -0.625
        vertex 173.61227416992188 7.166666507720947 -5.208700180053711
        vertex 173.31398010253906 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.9582750201225281 0.2858477532863617 1.1077679525670992e-16
    outer loop
        vertex 171.32540893554688 14.833333015441895 -0.625
        vertex 171.32540893554688 14.833333015441895 -5.208700180053711
        vertex 171.02711486816406 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9582790732383728 0.28583434224128723 -4.4706580411002506e-06
    outer loop
        vertex 181.76658630371094 -20.170421600341797 -5.208700180053711
        vertex 182.4614715576172 -22.5 -0.625
        vertex 182.75975036621094 -23.5 -0.625
    endloop
endfacet
facet normal 0.9582758545875549 0.2858450710773468 -0.0
    outer loop
        vertex 168.74024963378906 23.5 -0.625
        vertex 167.99452209472656 26.0 -0.625
        vertex 167.99452209472656 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582767486572266 0.28584209084510803 0.0
    outer loop
        vertex 167.99452209472656 26.0 5.773159728050814e-15
        vertex 183.50547790527344 -26.0 -5.773159728050814e-15
        vertex 183.50547790527344 -26.0 -0.625
    endloop
endfacet
facet normal 0.9582750201225281 0.2858477532863617 1.1077679525670992e-16
    outer loop
        vertex 180.47288513183594 -15.833333015441895 -0.625
        vertex 180.47288513183594 -15.833333015441895 -5.208700180053711
        vertex 180.17459106445312 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9582750797271729 0.28584763407707214 5.5388374467297806e-17
    outer loop
        vertex 178.18601989746094 -8.166666984558105 -0.625
        vertex 177.88772583007812 -7.166666507720947 -5.208700180053711
        vertex 177.88772583007812 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9582790732383728 0.28583434224128723 6.230902076689211e-17
    outer loop
        vertex 175.89913940429688 -0.5 -0.625
        vertex 175.60086059570312 0.5 -5.208700180053711
        vertex 175.60086059570312 0.5 -0.625
    endloop
endfacet
facet normal 0.9582750797271729 0.28584763407707214 1.1077674893459561e-16
    outer loop
        vertex 173.61227416992188 7.166666507720947 -0.625
        vertex 173.31398010253906 8.166666984558105 -5.208700180053711
        vertex 173.31398010253906 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9582750201225281 0.2858477532863617 1.1077679525670992e-16
    outer loop
        vertex 171.32540893554688 14.833333015441895 -0.625
        vertex 171.02711486816406 15.833333015441895 -5.208700180053711
        vertex 171.02711486816406 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582780003547668 0.28583788871765137 -1.6552851320739137e-06
    outer loop
        vertex 181.76658630371094 -20.170421600341797 -5.208700180053711
        vertex 182.75975036621094 -23.5 -0.625
        vertex 181.99539184570312 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582766890525818 0.28584223985671997 -1.5364708815468475e-05
    outer loop
        vertex 167.99452209472656 26.0 5.773159728050814e-15
        vertex 183.50547790527344 -26.0 -0.625
        vertex 180.47288513183594 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582750201225281 0.2858477532863617 1.1077679525670992e-16
    outer loop
        vertex 180.47288513183594 -15.833333015441895 -0.625
        vertex 180.17459106445312 -14.833333015441895 -5.208700180053711
        vertex 180.17459106445312 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582767486572266 0.28584206104278564 -9.241280167771038e-06
    outer loop
        vertex 169.73341369628906 20.170421600341797 -5.208700180053711
        vertex 181.76658630371094 -20.170421600341797 -5.208700180053711
        vertex 181.99539184570312 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582749605178833 0.2858477234840393 -0.00041707229684107006
    outer loop
        vertex 167.99452209472656 26.0 5.773159728050814e-15
        vertex 180.47288513183594 -15.833333015441895 -0.625
        vertex 180.17459106445312 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582768082618713 0.2858418822288513 8.902711670089047e-06
    outer loop
        vertex 169.73341369628906 20.170421600341797 -5.208700180053711
        vertex 181.99539184570312 -20.9375 -5.666999816894531
        vertex 169.50460815429688 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582772254943848 0.28584039211273193 0.0001065683172782883
    outer loop
        vertex 167.99452209472656 26.0 5.773159728050814e-15
        vertex 180.17459106445312 -14.833333015441895 -0.625
        vertex 178.18601989746094 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9582778811454773 0.28583824634552 2.30389764510619e-06
    outer loop
        vertex 169.0385284423828 22.5 -0.625
        vertex 169.73341369628906 20.170421600341797 -5.208700180053711
        vertex 169.50460815429688 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582750201225281 0.28584763407707214 -0.0003241288068238646
    outer loop
        vertex 167.99452209472656 26.0 5.773159728050814e-15
        vertex 178.18601989746094 -8.166666984558105 -0.625
        vertex 177.88772583007812 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9582790732383728 0.28583434224128723 3.6250937682780204e-06
    outer loop
        vertex 169.0385284423828 22.5 -0.625
        vertex 169.50460815429688 20.9375 -5.666999816894531
        vertex 168.74024963378906 23.5 -0.625
    endloop
endfacet
facet normal 0.958276629447937 0.2858423888683319 -2.1344840206438676e-05
    outer loop
        vertex 167.99452209472656 26.0 5.773159728050814e-15
        vertex 177.88772583007812 -7.166666507720947 -0.625
        vertex 175.89913940429688 -0.5 -0.625
    endloop
endfacet
facet normal 0.9582790732383728 0.28583434224128723 4.679097037296742e-05
    outer loop
        vertex 169.0385284423828 22.5 -0.625
        vertex 168.74024963378906 23.5 -0.625
        vertex 167.99452209472656 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.958279013633728 0.28583431243896484 0.0003509322414174676
    outer loop
        vertex 167.99452209472656 26.0 5.773159728050814e-15
        vertex 175.89913940429688 -0.5 -0.625
        vertex 175.60086059570312 0.5 -0.625
    endloop
endfacet
facet normal 0.958276629447937 0.2858423888683319 -2.2632143554801587e-06
    outer loop
        vertex 171.02711486816406 15.833333015441895 -0.625
        vertex 169.0385284423828 22.5 -0.625
        vertex 167.99452209472656 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.958276629447937 0.2858423888683319 -7.296680450963322e-06
    outer loop
        vertex 167.99452209472656 26.0 5.773159728050814e-15
        vertex 175.60086059570312 0.5 -0.625
        vertex 173.61227416992188 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9582750201225281 0.2858477532863617 -9.762616537045687e-05
    outer loop
        vertex 171.32540893554688 14.833333015441895 -0.625
        vertex 171.02711486816406 15.833333015441895 -0.625
        vertex 167.99452209472656 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582750797271729 0.28584763407707214 -0.00017922930419445038
    outer loop
        vertex 167.99452209472656 26.0 5.773159728050814e-15
        vertex 173.61227416992188 7.166666507720947 -0.625
        vertex 173.31398010253906 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9582772254943848 0.28584039211273193 4.5573564420919865e-05
    outer loop
        vertex 173.31398010253906 8.166666984558105 -0.625
        vertex 171.32540893554688 14.833333015441895 -0.625
        vertex 167.99452209472656 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582750797271729 0.28584763407707214 1.1077674893459561e-16
    outer loop
        vertex 178.18601989746094 -8.166666984558105 -0.625
        vertex 178.18601989746094 -8.166666984558105 -5.208700180053711
        vertex 177.88772583007812 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.9582790732383728 0.28583434224128723 6.577063266408363e-17
    outer loop
        vertex 175.89913940429688 -0.5 -0.625
        vertex 175.89913940429688 -0.5 -5.208700180053711
        vertex 175.60086059570312 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.9582750797271729 0.28584763407707214 1.1077674893459561e-16
    outer loop
        vertex 173.61227416992188 7.166666507720947 -0.625
        vertex 173.61227416992188 7.166666507720947 -5.208700180053711
        vertex 173.31398010253906 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.9582750201225281 0.2858477532863617 1.1077679525670992e-16
    outer loop
        vertex 171.32540893554688 14.833333015441895 -0.625
        vertex 171.32540893554688 14.833333015441895 -5.208700180053711
        vertex 171.02711486816406 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9582790732383728 0.28583434224128723 -4.4706580411002506e-06
    outer loop
        vertex 181.76658630371094 -20.170421600341797 -5.208700180053711
        vertex 182.4614715576172 -22.5 -0.625
        vertex 182.75975036621094 -23.5 -0.625
    endloop
endfacet
facet normal 0.9582758545875549 0.2858450710773468 -0.0
    outer loop
        vertex 168.74024963378906 23.5 -0.625
        vertex 167.99452209472656 26.0 -0.625
        vertex 167.99452209472656 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582767486572266 0.28584209084510803 0.0
    outer loop
        vertex 167.99452209472656 26.0 5.773159728050814e-15
        vertex 183.50547790527344 -26.0 -5.773159728050814e-15
        vertex 183.50547790527344 -26.0 -0.625
    endloop
endfacet
facet normal 0.9582750201225281 0.2858477532863617 1.1077679525670992e-16
    outer loop
        vertex 180.47288513183594 -15.833333015441895 -0.625
        vertex 180.47288513183594 -15.833333015441895 -5.208700180053711
        vertex 180.17459106445312 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9582750797271729 0.28584763407707214 5.5388374467297806e-17
    outer loop
        vertex 178.18601989746094 -8.166666984558105 -0.625
        vertex 177.88772583007812 -7.166666507720947 -5.208700180053711
        vertex 177.88772583007812 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9582790732383728 0.28583434224128723 6.230902076689211e-17
    outer loop
        vertex 175.89913940429688 -0.5 -0.625
        vertex 175.60086059570312 0.5 -5.208700180053711
        vertex 175.60086059570312 0.5 -0.625
    endloop
endfacet
facet normal 0.9582750797271729 0.28584763407707214 1.1077674893459561e-16
    outer loop
        vertex 173.61227416992188 7.166666507720947 -0.625
        vertex 173.31398010253906 8.166666984558105 -5.208700180053711
        vertex 173.31398010253906 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9582750201225281 0.2858477532863617 1.1077679525670992e-16
    outer loop
        vertex 171.32540893554688 14.833333015441895 -0.625
        vertex 171.02711486816406 15.833333015441895 -5.208700180053711
        vertex 171.02711486816406 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582780003547668 0.28583788871765137 -1.6552851320739137e-06
    outer loop
        vertex 181.76658630371094 -20.170421600341797 -5.208700180053711
        vertex 182.75975036621094 -23.5 -0.625
        vertex 181.99539184570312 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582766890525818 0.28584223985671997 -1.5364708815468475e-05
    outer loop
        vertex 167.99452209472656 26.0 5.773159728050814e-15
        vertex 183.50547790527344 -26.0 -0.625
        vertex 180.47288513183594 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582750201225281 0.2858477532863617 1.1077679525670992e-16
    outer loop
        vertex 180.47288513183594 -15.833333015441895 -0.625
        vertex 180.17459106445312 -14.833333015441895 -5.208700180053711
        vertex 180.17459106445312 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582767486572266 0.28584206104278564 -9.241280167771038e-06
    outer loop
        vertex 169.73341369628906 20.170421600341797 -5.208700180053711
        vertex 181.76658630371094 -20.170421600341797 -5.208700180053711
        vertex 181.99539184570312 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582749605178833 0.2858477234840393 -0.00041707229684107006
    outer loop
        vertex 167.99452209472656 26.0 5.773159728050814e-15
        vertex 180.47288513183594 -15.833333015441895 -0.625
        vertex 180.17459106445312 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582768082618713 0.2858418822288513 8.902711670089047e-06
    outer loop
        vertex 169.73341369628906 20.170421600341797 -5.208700180053711
        vertex 181.99539184570312 -20.9375 -5.666999816894531
        vertex 169.50460815429688 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582772254943848 0.28584039211273193 0.0001065683172782883
    outer loop
        vertex 167.99452209472656 26.0 5.773159728050814e-15
        vertex 180.17459106445312 -14.833333015441895 -0.625
        vertex 178.18601989746094 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9582778811454773 0.28583824634552 2.30389764510619e-06
    outer loop
        vertex 169.0385284423828 22.5 -0.625
        vertex 169.73341369628906 20.170421600341797 -5.208700180053711
        vertex 169.50460815429688 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582750201225281 0.28584763407707214 -0.0003241288068238646
    outer loop
        vertex 167.99452209472656 26.0 5.773159728050814e-15
        vertex 178.18601989746094 -8.166666984558105 -0.625
        vertex 177.88772583007812 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9582790732383728 0.28583434224128723 3.6250937682780204e-06
    outer loop
        vertex 169.0385284423828 22.5 -0.625
        vertex 169.50460815429688 20.9375 -5.666999816894531
        vertex 168.74024963378906 23.5 -0.625
    endloop
endfacet
facet normal 0.958276629447937 0.2858423888683319 -2.1344840206438676e-05
    outer loop
        vertex 167.99452209472656 26.0 5.773159728050814e-15
        vertex 177.88772583007812 -7.166666507720947 -0.625
        vertex 175.89913940429688 -0.5 -0.625
    endloop
endfacet
facet normal 0.9582790732383728 0.28583434224128723 4.679097037296742e-05
    outer loop
        vertex 169.0385284423828 22.5 -0.625
        vertex 168.74024963378906 23.5 -0.625
        vertex 167.99452209472656 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.958279013633728 0.28583431243896484 0.0003509322414174676
    outer loop
        vertex 167.99452209472656 26.0 5.773159728050814e-15
        vertex 175.89913940429688 -0.5 -0.625
        vertex 175.60086059570312 0.5 -0.625
    endloop
endfacet
facet normal 0.958276629447937 0.2858423888683319 -2.2632143554801587e-06
    outer loop
        vertex 171.02711486816406 15.833333015441895 -0.625
        vertex 169.0385284423828 22.5 -0.625
        vertex 167.99452209472656 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.958276629447937 0.2858423888683319 -7.296680450963322e-06
    outer loop
        vertex 167.99452209472656 26.0 5.773159728050814e-15
        vertex 175.60086059570312 0.5 -0.625
        vertex 173.61227416992188 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9582750201225281 0.2858477532863617 -9.762616537045687e-05
    outer loop
        vertex 171.32540893554688 14.833333015441895 -0.625
        vertex 171.02711486816406 15.833333015441895 -0.625
        vertex 167.99452209472656 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582750797271729 0.28584763407707214 -0.00017922930419445038
    outer loop
        vertex 167.99452209472656 26.0 5.773159728050814e-15
        vertex 173.61227416992188 7.166666507720947 -0.625
        vertex 173.31398010253906 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9582772254943848 0.28584039211273193 4.5573564420919865e-05
    outer loop
        vertex 173.31398010253906 8.166666984558105 -0.625
        vertex 171.32540893554688 14.833333015441895 -0.625
        vertex 167.99452209472656 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 1.514166287376934e-16
    outer loop
        vertex 169.29934692382812 -8.166666984558105 -0.625
        vertex 169.29934692382812 -8.166666984558105 -5.208700180053711
        vertex 168.87489318847656 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 8.990366012254271e-17
    outer loop
        vertex 166.04522705078125 -0.5 -0.625
        vertex 166.04522705078125 -0.5 -5.208700180053711
        vertex 165.6207733154297 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 1.514166287376934e-16
    outer loop
        vertex 162.79110717773438 7.166666507720947 -0.625
        vertex 162.79110717773438 7.166666507720947 -5.208700180053711
        vertex 162.3666534423828 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 1.514166949121424e-16
    outer loop
        vertex 159.53700256347656 14.833333015441895 -0.625
        vertex 159.53700256347656 14.833333015441895 -5.208700180053711
        vertex 159.112548828125 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 2.7037767722504213e-06
    outer loop
        vertex 174.3943328857422 -20.170421600341797 -5.208700180053711
        vertex 175.38311767578125 -22.5 -0.625
        vertex 175.8075714111328 -23.5 -0.625
    endloop
endfacet
facet normal 0.920512855052948 0.39071229100227356 -0.0
    outer loop
        vertex 155.85842895507812 23.5 -0.625
        vertex 154.79730224609375 26.0 -0.625
        vertex 154.79730224609375 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 0.0
    outer loop
        vertex 154.79730224609375 26.0 5.773159728050814e-15
        vertex 176.8686981201172 -26.0 -5.773159728050814e-15
        vertex 176.8686981201172 -26.0 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 1.514166949121424e-16
    outer loop
        vertex 172.55345153808594 -15.833333015441895 -0.625
        vertex 172.55345153808594 -15.833333015441895 -5.208700180053711
        vertex 172.12899780273438 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 7.57083143688467e-17
    outer loop
        vertex 169.29934692382812 -8.166666984558105 -0.625
        vertex 168.87489318847656 -7.166666507720947 -5.208700180053711
        vertex 168.87489318847656 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 8.517188923371887e-17
    outer loop
        vertex 166.04522705078125 -0.5 -0.625
        vertex 165.6207733154297 0.5 -5.208700180053711
        vertex 165.6207733154297 0.5 -0.625
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 1.514166287376934e-16
    outer loop
        vertex 162.79110717773438 7.166666507720947 -0.625
        vertex 162.3666534423828 8.166666984558105 -5.208700180053711
        vertex 162.3666534423828 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 1.514166949121424e-16
    outer loop
        vertex 159.53700256347656 14.833333015441895 -0.625
        vertex 159.112548828125 15.833333015441895 -5.208700180053711
        vertex 159.112548828125 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205160140991211 0.390704870223999 -5.718965439882595e-06
    outer loop
        vertex 174.3943328857422 -20.170421600341797 -5.208700180053711
        vertex 175.8075714111328 -23.5 -0.625
        vertex 174.71990966796875 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205129146575928 0.3907121419906616 -4.208839527564123e-05
    outer loop
        vertex 154.79730224609375 26.0 5.773159728050814e-15
        vertex 176.8686981201172 -26.0 -0.625
        vertex 172.55345153808594 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 1.514166949121424e-16
    outer loop
        vertex 172.55345153808594 -15.833333015441895 -0.625
        vertex 172.12899780273438 -14.833333015441895 -5.208700180053711
        vertex 172.12899780273438 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907116651535034 -1.9161656382493675e-05
    outer loop
        vertex 157.27166748046875 20.170421600341797 -5.208700180053711
        vertex 174.3943328857422 -20.170421600341797 -5.208700180053711
        vertex 174.71990966796875 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.920511782169342 0.3907146751880646 -0.0002432634646538645
    outer loop
        vertex 154.79730224609375 26.0 5.773159728050814e-15
        vertex 172.55345153808594 -15.833333015441895 -0.625
        vertex 172.12899780273438 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205132722854614 0.39071130752563477 1.84596428880468e-05
    outer loop
        vertex 157.27166748046875 20.170421600341797 -5.208700180053711
        vertex 174.71990966796875 -20.9375 -5.666999816894531
        vertex 156.9460906982422 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205138087272644 0.3907099664211273 0.00012136849545640871
    outer loop
        vertex 154.79730224609375 26.0 5.773159728050814e-15
        vertex 172.12899780273438 -14.833333015441895 -0.625
        vertex 169.29934692382812 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9205164313316345 0.39070388674736023 3.7785082440677797e-06
    outer loop
        vertex 156.2828826904297 22.5 -0.625
        vertex 157.27166748046875 20.170421600341797 -5.208700180053711
        vertex 156.9460906982422 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 -0.00017354698502458632
    outer loop
        vertex 154.79730224609375 26.0 5.773159728050814e-15
        vertex 169.29934692382812 -8.166666984558105 -0.625
        vertex 168.87489318847656 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 -1.741111645969795e-07
    outer loop
        vertex 156.2828826904297 22.5 -0.625
        vertex 156.9460906982422 20.9375 -5.666999816894531
        vertex 155.85842895507812 23.5 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 2.4142145775840618e-06
    outer loop
        vertex 154.79730224609375 26.0 5.773159728050814e-15
        vertex 168.87489318847656 -7.166666507720947 -0.625
        vertex 166.04522705078125 -0.5 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 -1.1236717000429053e-05
    outer loop
        vertex 156.2828826904297 22.5 -0.625
        vertex 155.85842895507812 23.5 -0.625
        vertex 154.79730224609375 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 -0.00014607732009608299
    outer loop
        vertex 154.79730224609375 26.0 5.773159728050814e-15
        vertex 166.04522705078125 -0.5 -0.625
        vertex 165.6207733154297 0.5 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907116949558258 8.531880666851066e-06
    outer loop
        vertex 159.112548828125 15.833333015441895 -0.625
        vertex 156.2828826904297 22.5 -0.625
        vertex 154.79730224609375 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 -3.1892470815364504e-06
    outer loop
        vertex 154.79730224609375 26.0 5.773159728050814e-15
        vertex 165.6207733154297 0.5 -0.625
        vertex 162.79110717773438 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 -4.8891168262343854e-05
    outer loop
        vertex 159.53700256347656 14.833333015441895 -0.625
        vertex 159.112548828125 15.833333015441895 -0.625
        vertex 154.79730224609375 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 -0.0001031069114105776
    outer loop
        vertex 154.79730224609375 26.0 5.773159728050814e-15
        vertex 162.79110717773438 7.166666507720947 -0.625
        vertex 162.3666534423828 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9205138683319092 0.3907099664211273 5.082455390947871e-05
    outer loop
        vertex 162.3666534423828 8.166666984558105 -0.625
        vertex 159.53700256347656 14.833333015441895 -0.625
        vertex 154.79730224609375 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 1.514166287376934e-16
    outer loop
        vertex 169.29934692382812 -8.166666984558105 -0.625
        vertex 169.29934692382812 -8.166666984558105 -5.208700180053711
        vertex 168.87489318847656 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 8.990366012254271e-17
    outer loop
        vertex 166.04522705078125 -0.5 -0.625
        vertex 166.04522705078125 -0.5 -5.208700180053711
        vertex 165.6207733154297 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 1.514166287376934e-16
    outer loop
        vertex 162.79110717773438 7.166666507720947 -0.625
        vertex 162.79110717773438 7.166666507720947 -5.208700180053711
        vertex 162.3666534423828 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 1.514166949121424e-16
    outer loop
        vertex 159.53700256347656 14.833333015441895 -0.625
        vertex 159.53700256347656 14.833333015441895 -5.208700180053711
        vertex 159.112548828125 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 2.7037767722504213e-06
    outer loop
        vertex 174.3943328857422 -20.170421600341797 -5.208700180053711
        vertex 175.38311767578125 -22.5 -0.625
        vertex 175.8075714111328 -23.5 -0.625
    endloop
endfacet
facet normal 0.920512855052948 0.39071229100227356 -0.0
    outer loop
        vertex 155.85842895507812 23.5 -0.625
        vertex 154.79730224609375 26.0 -0.625
        vertex 154.79730224609375 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 0.0
    outer loop
        vertex 154.79730224609375 26.0 5.773159728050814e-15
        vertex 176.8686981201172 -26.0 -5.773159728050814e-15
        vertex 176.8686981201172 -26.0 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 1.514166949121424e-16
    outer loop
        vertex 172.55345153808594 -15.833333015441895 -0.625
        vertex 172.55345153808594 -15.833333015441895 -5.208700180053711
        vertex 172.12899780273438 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 7.57083143688467e-17
    outer loop
        vertex 169.29934692382812 -8.166666984558105 -0.625
        vertex 168.87489318847656 -7.166666507720947 -5.208700180053711
        vertex 168.87489318847656 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 8.517188923371887e-17
    outer loop
        vertex 166.04522705078125 -0.5 -0.625
        vertex 165.6207733154297 0.5 -5.208700180053711
        vertex 165.6207733154297 0.5 -0.625
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 1.514166287376934e-16
    outer loop
        vertex 162.79110717773438 7.166666507720947 -0.625
        vertex 162.3666534423828 8.166666984558105 -5.208700180053711
        vertex 162.3666534423828 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 1.514166949121424e-16
    outer loop
        vertex 159.53700256347656 14.833333015441895 -0.625
        vertex 159.112548828125 15.833333015441895 -5.208700180053711
        vertex 159.112548828125 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205160140991211 0.390704870223999 -5.718965439882595e-06
    outer loop
        vertex 174.3943328857422 -20.170421600341797 -5.208700180053711
        vertex 175.8075714111328 -23.5 -0.625
        vertex 174.71990966796875 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205129146575928 0.3907121419906616 -4.208839527564123e-05
    outer loop
        vertex 154.79730224609375 26.0 5.773159728050814e-15
        vertex 176.8686981201172 -26.0 -0.625
        vertex 172.55345153808594 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 1.514166949121424e-16
    outer loop
        vertex 172.55345153808594 -15.833333015441895 -0.625
        vertex 172.12899780273438 -14.833333015441895 -5.208700180053711
        vertex 172.12899780273438 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907116651535034 -1.9161656382493675e-05
    outer loop
        vertex 157.27166748046875 20.170421600341797 -5.208700180053711
        vertex 174.3943328857422 -20.170421600341797 -5.208700180053711
        vertex 174.71990966796875 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.920511782169342 0.3907146751880646 -0.0002432634646538645
    outer loop
        vertex 154.79730224609375 26.0 5.773159728050814e-15
        vertex 172.55345153808594 -15.833333015441895 -0.625
        vertex 172.12899780273438 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205132722854614 0.39071130752563477 1.84596428880468e-05
    outer loop
        vertex 157.27166748046875 20.170421600341797 -5.208700180053711
        vertex 174.71990966796875 -20.9375 -5.666999816894531
        vertex 156.9460906982422 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205138087272644 0.3907099664211273 0.00012136849545640871
    outer loop
        vertex 154.79730224609375 26.0 5.773159728050814e-15
        vertex 172.12899780273438 -14.833333015441895 -0.625
        vertex 169.29934692382812 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9205164313316345 0.39070388674736023 3.7785082440677797e-06
    outer loop
        vertex 156.2828826904297 22.5 -0.625
        vertex 157.27166748046875 20.170421600341797 -5.208700180053711
        vertex 156.9460906982422 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 -0.00017354698502458632
    outer loop
        vertex 154.79730224609375 26.0 5.773159728050814e-15
        vertex 169.29934692382812 -8.166666984558105 -0.625
        vertex 168.87489318847656 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 -1.741111645969795e-07
    outer loop
        vertex 156.2828826904297 22.5 -0.625
        vertex 156.9460906982422 20.9375 -5.666999816894531
        vertex 155.85842895507812 23.5 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 2.4142145775840618e-06
    outer loop
        vertex 154.79730224609375 26.0 5.773159728050814e-15
        vertex 168.87489318847656 -7.166666507720947 -0.625
        vertex 166.04522705078125 -0.5 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 -1.1236717000429053e-05
    outer loop
        vertex 156.2828826904297 22.5 -0.625
        vertex 155.85842895507812 23.5 -0.625
        vertex 154.79730224609375 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 -0.00014607732009608299
    outer loop
        vertex 154.79730224609375 26.0 5.773159728050814e-15
        vertex 166.04522705078125 -0.5 -0.625
        vertex 165.6207733154297 0.5 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907116949558258 8.531880666851066e-06
    outer loop
        vertex 159.112548828125 15.833333015441895 -0.625
        vertex 156.2828826904297 22.5 -0.625
        vertex 154.79730224609375 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 -3.1892470815364504e-06
    outer loop
        vertex 154.79730224609375 26.0 5.773159728050814e-15
        vertex 165.6207733154297 0.5 -0.625
        vertex 162.79110717773438 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 -4.8891168262343854e-05
    outer loop
        vertex 159.53700256347656 14.833333015441895 -0.625
        vertex 159.112548828125 15.833333015441895 -0.625
        vertex 154.79730224609375 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 -0.0001031069114105776
    outer loop
        vertex 154.79730224609375 26.0 5.773159728050814e-15
        vertex 162.79110717773438 7.166666507720947 -0.625
        vertex 162.3666534423828 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9205138683319092 0.3907099664211273 5.082455390947871e-05
    outer loop
        vertex 162.3666534423828 8.166666984558105 -0.625
        vertex 159.53700256347656 14.833333015441895 -0.625
        vertex 154.79730224609375 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 1.8148514692980838e-16
    outer loop
        vertex 160.24546813964844 -8.166666984558105 -0.625
        vertex 160.24546813964844 -8.166666984558105 -5.208700180053711
        vertex 159.7154541015625 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.0775684486706252e-16
    outer loop
        vertex 156.1820068359375 -0.5 -0.625
        vertex 156.1820068359375 -0.5 -5.208700180053711
        vertex 155.65199279785156 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 1.8148514692980838e-16
    outer loop
        vertex 152.11854553222656 7.166666507720947 -0.625
        vertex 152.11854553222656 7.166666507720947 -5.208700180053711
        vertex 151.58853149414062 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.8148521310425739e-16
    outer loop
        vertex 148.05508422851562 14.833333015441895 -0.625
        vertex 148.05508422851562 14.833333015441895 -5.208700180053711
        vertex 147.5250701904297 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.8835622072219849 0.4683138430118561 6.574685357918497e-06
    outer loop
        vertex 166.60765075683594 -20.170421600341797 -5.208700180053711
        vertex 167.8423614501953 -22.5 -0.625
        vertex 168.3723907470703 -23.5 -0.625
    endloop
endfacet
facet normal 0.8835688829421997 0.4683012068271637 -0.0
    outer loop
        vertex 143.46160888671875 23.5 -0.625
        vertex 142.13658142089844 26.0 -0.625
        vertex 142.13658142089844 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835670351982117 0.46830472350120544 0.0
    outer loop
        vertex 142.13658142089844 26.0 5.773159728050814e-15
        vertex 169.69741821289062 -26.0 -5.773159728050814e-15
        vertex 169.69741821289062 -26.0 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.8148521310425739e-16
    outer loop
        vertex 164.30892944335938 -15.833333015441895 -0.625
        vertex 164.30892944335938 -15.833333015441895 -5.208700180053711
        vertex 163.77891540527344 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 9.074257346490419e-17
    outer loop
        vertex 160.24546813964844 -8.166666984558105 -0.625
        vertex 159.7154541015625 -7.166666507720947 -5.208700180053711
        vertex 159.7154541015625 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.0208542988960294e-16
    outer loop
        vertex 156.1820068359375 -0.5 -0.625
        vertex 155.65199279785156 0.5 -5.208700180053711
        vertex 155.65199279785156 0.5 -0.625
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 1.8148514692980838e-16
    outer loop
        vertex 152.11854553222656 7.166666507720947 -0.625
        vertex 151.58853149414062 8.166666984558105 -5.208700180053711
        vertex 151.58853149414062 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.8148521310425739e-16
    outer loop
        vertex 148.05508422851562 14.833333015441895 -0.625
        vertex 147.5250701904297 15.833333015441895 -5.208700180053711
        vertex 147.5250701904297 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8835645318031311 0.4683094620704651 2.490060296622687e-06
    outer loop
        vertex 166.60765075683594 -20.170421600341797 -5.208700180053711
        vertex 168.3723907470703 -23.5 -0.625
        vertex 167.01422119140625 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835673332214355 0.4683041572570801 6.0274604038568214e-05
    outer loop
        vertex 142.13658142089844 26.0 5.773159728050814e-15
        vertex 169.69741821289062 -26.0 -0.625
        vertex 164.30892944335938 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.8148521310425739e-16
    outer loop
        vertex 164.30892944335938 -15.833333015441895 -0.625
        vertex 163.77891540527344 -14.833333015441895 -5.208700180053711
        vertex 163.77891540527344 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8835669755935669 0.468304842710495 1.2393245015118737e-05
    outer loop
        vertex 145.22634887695312 20.170421600341797 -5.208700180053711
        vertex 166.60765075683594 -20.170421600341797 -5.208700180053711
        vertex 167.01422119140625 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 0.00013326230691745877
    outer loop
        vertex 142.13658142089844 26.0 5.773159728050814e-15
        vertex 164.30892944335938 -15.833333015441895 -0.625
        vertex 163.77891540527344 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8835668563842773 0.4683050513267517 -1.1939197065657936e-05
    outer loop
        vertex 145.22634887695312 20.170421600341797 -5.208700180053711
        vertex 167.01422119140625 -20.9375 -5.666999816894531
        vertex 144.8197784423828 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835666179656982 0.46830546855926514 -4.582256588037126e-05
    outer loop
        vertex 142.13658142089844 26.0 5.773159728050814e-15
        vertex 163.77891540527344 -14.833333015441895 -0.625
        vertex 160.24546813964844 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8835647702217102 0.4683090150356293 -3.431093091421644e-06
    outer loop
        vertex 143.99163818359375 22.5 -0.625
        vertex 145.22634887695312 20.170421600341797 -5.208700180053711
        vertex 144.8197784423828 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 0.00011623126920312643
    outer loop
        vertex 142.13658142089844 26.0 5.773159728050814e-15
        vertex 160.24546813964844 -8.166666984558105 -0.625
        vertex 159.7154541015625 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.8835622072219849 0.4683138430118561 -5.347913429432083e-06
    outer loop
        vertex 143.99163818359375 22.5 -0.625
        vertex 144.8197784423828 20.9375 -5.666999816894531
        vertex 143.46160888671875 23.5 -0.625
    endloop
endfacet
facet normal 0.8835666179656982 0.46830543875694275 -3.93020200135652e-05
    outer loop
        vertex 142.13658142089844 26.0 5.773159728050814e-15
        vertex 159.7154541015625 -7.166666507720947 -0.625
        vertex 156.1820068359375 -0.5 -0.625
    endloop
endfacet
facet normal 0.8835622072219849 0.4683138430118561 -6.471402593888342e-05
    outer loop
        vertex 143.99163818359375 22.5 -0.625
        vertex 143.46160888671875 23.5 -0.625
        vertex 142.13658142089844 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 7.550017471658066e-05
    outer loop
        vertex 142.13658142089844 26.0 5.773159728050814e-15
        vertex 156.1820068359375 -0.5 -0.625
        vertex 155.65199279785156 0.5 -0.625
    endloop
endfacet
facet normal 0.8835675120353699 0.4683038294315338 7.135779014788568e-06
    outer loop
        vertex 147.5250701904297 15.833333015441895 -0.625
        vertex 143.99163818359375 22.5 -0.625
        vertex 142.13658142089844 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835666179656982 0.46830543875694275 -3.4969863918377087e-05
    outer loop
        vertex 142.13658142089844 26.0 5.773159728050814e-15
        vertex 155.65199279785156 0.5 -0.625
        vertex 152.11854553222656 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.7738040696713142e-05
    outer loop
        vertex 148.05508422851562 14.833333015441895 -0.625
        vertex 147.5250701904297 15.833333015441895 -0.625
        vertex 142.13658142089844 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 5.334801608114503e-05
    outer loop
        vertex 142.13658142089844 26.0 5.773159728050814e-15
        vertex 152.11854553222656 7.166666507720947 -0.625
        vertex 151.58853149414062 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8835666179656982 0.46830546855926514 -3.123616988887079e-05
    outer loop
        vertex 151.58853149414062 8.166666984558105 -0.625
        vertex 148.05508422851562 14.833333015441895 -0.625
        vertex 142.13658142089844 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 1.8148514692980838e-16
    outer loop
        vertex 160.24546813964844 -8.166666984558105 -0.625
        vertex 160.24546813964844 -8.166666984558105 -5.208700180053711
        vertex 159.7154541015625 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.0775684486706252e-16
    outer loop
        vertex 156.1820068359375 -0.5 -0.625
        vertex 156.1820068359375 -0.5 -5.208700180053711
        vertex 155.65199279785156 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 1.8148514692980838e-16
    outer loop
        vertex 152.11854553222656 7.166666507720947 -0.625
        vertex 152.11854553222656 7.166666507720947 -5.208700180053711
        vertex 151.58853149414062 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.8148521310425739e-16
    outer loop
        vertex 148.05508422851562 14.833333015441895 -0.625
        vertex 148.05508422851562 14.833333015441895 -5.208700180053711
        vertex 147.5250701904297 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.8835622072219849 0.4683138430118561 6.574685357918497e-06
    outer loop
        vertex 166.60765075683594 -20.170421600341797 -5.208700180053711
        vertex 167.8423614501953 -22.5 -0.625
        vertex 168.3723907470703 -23.5 -0.625
    endloop
endfacet
facet normal 0.8835688829421997 0.4683012068271637 -0.0
    outer loop
        vertex 143.46160888671875 23.5 -0.625
        vertex 142.13658142089844 26.0 -0.625
        vertex 142.13658142089844 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835670351982117 0.46830472350120544 0.0
    outer loop
        vertex 142.13658142089844 26.0 5.773159728050814e-15
        vertex 169.69741821289062 -26.0 -5.773159728050814e-15
        vertex 169.69741821289062 -26.0 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.8148521310425739e-16
    outer loop
        vertex 164.30892944335938 -15.833333015441895 -0.625
        vertex 164.30892944335938 -15.833333015441895 -5.208700180053711
        vertex 163.77891540527344 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 9.074257346490419e-17
    outer loop
        vertex 160.24546813964844 -8.166666984558105 -0.625
        vertex 159.7154541015625 -7.166666507720947 -5.208700180053711
        vertex 159.7154541015625 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.0208542988960294e-16
    outer loop
        vertex 156.1820068359375 -0.5 -0.625
        vertex 155.65199279785156 0.5 -5.208700180053711
        vertex 155.65199279785156 0.5 -0.625
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 1.8148514692980838e-16
    outer loop
        vertex 152.11854553222656 7.166666507720947 -0.625
        vertex 151.58853149414062 8.166666984558105 -5.208700180053711
        vertex 151.58853149414062 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.8148521310425739e-16
    outer loop
        vertex 148.05508422851562 14.833333015441895 -0.625
        vertex 147.5250701904297 15.833333015441895 -5.208700180053711
        vertex 147.5250701904297 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8835645318031311 0.4683094620704651 2.490060296622687e-06
    outer loop
        vertex 166.60765075683594 -20.170421600341797 -5.208700180053711
        vertex 168.3723907470703 -23.5 -0.625
        vertex 167.01422119140625 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835673332214355 0.4683041572570801 6.0274604038568214e-05
    outer loop
        vertex 142.13658142089844 26.0 5.773159728050814e-15
        vertex 169.69741821289062 -26.0 -0.625
        vertex 164.30892944335938 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.8148521310425739e-16
    outer loop
        vertex 164.30892944335938 -15.833333015441895 -0.625
        vertex 163.77891540527344 -14.833333015441895 -5.208700180053711
        vertex 163.77891540527344 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8835669755935669 0.468304842710495 1.2393245015118737e-05
    outer loop
        vertex 145.22634887695312 20.170421600341797 -5.208700180053711
        vertex 166.60765075683594 -20.170421600341797 -5.208700180053711
        vertex 167.01422119140625 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 0.00013326230691745877
    outer loop
        vertex 142.13658142089844 26.0 5.773159728050814e-15
        vertex 164.30892944335938 -15.833333015441895 -0.625
        vertex 163.77891540527344 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8835668563842773 0.4683050513267517 -1.1939197065657936e-05
    outer loop
        vertex 145.22634887695312 20.170421600341797 -5.208700180053711
        vertex 167.01422119140625 -20.9375 -5.666999816894531
        vertex 144.8197784423828 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835666179656982 0.46830546855926514 -4.582256588037126e-05
    outer loop
        vertex 142.13658142089844 26.0 5.773159728050814e-15
        vertex 163.77891540527344 -14.833333015441895 -0.625
        vertex 160.24546813964844 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8835647702217102 0.4683090150356293 -3.431093091421644e-06
    outer loop
        vertex 143.99163818359375 22.5 -0.625
        vertex 145.22634887695312 20.170421600341797 -5.208700180053711
        vertex 144.8197784423828 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 0.00011623126920312643
    outer loop
        vertex 142.13658142089844 26.0 5.773159728050814e-15
        vertex 160.24546813964844 -8.166666984558105 -0.625
        vertex 159.7154541015625 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.8835622072219849 0.4683138430118561 -5.347913429432083e-06
    outer loop
        vertex 143.99163818359375 22.5 -0.625
        vertex 144.8197784423828 20.9375 -5.666999816894531
        vertex 143.46160888671875 23.5 -0.625
    endloop
endfacet
facet normal 0.8835666179656982 0.46830543875694275 -3.93020200135652e-05
    outer loop
        vertex 142.13658142089844 26.0 5.773159728050814e-15
        vertex 159.7154541015625 -7.166666507720947 -0.625
        vertex 156.1820068359375 -0.5 -0.625
    endloop
endfacet
facet normal 0.8835622072219849 0.4683138430118561 -6.471402593888342e-05
    outer loop
        vertex 143.99163818359375 22.5 -0.625
        vertex 143.46160888671875 23.5 -0.625
        vertex 142.13658142089844 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 7.550017471658066e-05
    outer loop
        vertex 142.13658142089844 26.0 5.773159728050814e-15
        vertex 156.1820068359375 -0.5 -0.625
        vertex 155.65199279785156 0.5 -0.625
    endloop
endfacet
facet normal 0.8835675120353699 0.4683038294315338 7.135779014788568e-06
    outer loop
        vertex 147.5250701904297 15.833333015441895 -0.625
        vertex 143.99163818359375 22.5 -0.625
        vertex 142.13658142089844 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835666179656982 0.46830543875694275 -3.4969863918377087e-05
    outer loop
        vertex 142.13658142089844 26.0 5.773159728050814e-15
        vertex 155.65199279785156 0.5 -0.625
        vertex 152.11854553222656 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.7738040696713142e-05
    outer loop
        vertex 148.05508422851562 14.833333015441895 -0.625
        vertex 147.5250701904297 15.833333015441895 -0.625
        vertex 142.13658142089844 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 5.334801608114503e-05
    outer loop
        vertex 142.13658142089844 26.0 5.773159728050814e-15
        vertex 152.11854553222656 7.166666507720947 -0.625
        vertex 151.58853149414062 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8835666179656982 0.46830546855926514 -3.123616988887079e-05
    outer loop
        vertex 151.58853149414062 8.166666984558105 -0.625
        vertex 148.05508422851562 14.833333015441895 -0.625
        vertex 142.13658142089844 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8515531420707703 0.5242683291435242 2.0317376965138956e-16
    outer loop
        vertex 151.0279083251953 -8.166666984558105 -0.625
        vertex 151.0279083251953 -8.166666984558105 -5.208700180053711
        vertex 150.41224670410156 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 1.2063445881773706e-16
    outer loop
        vertex 146.30783081054688 -0.5 -0.625
        vertex 146.30783081054688 -0.5 -5.208700180053711
        vertex 145.69216918945312 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.8515531420707703 0.5242683291435242 2.0317376965138956e-16
    outer loop
        vertex 141.58775329589844 7.166666507720947 -0.625
        vertex 141.58775329589844 7.166666507720947 -5.208700180053711
        vertex 140.9720916748047 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 2.0317383582583857e-16
    outer loop
        vertex 136.86769104003906 14.833333015441895 -0.625
        vertex 136.86769104003906 14.833333015441895 -5.208700180053711
        vertex 136.2520294189453 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 -4.839794200961478e-07
    outer loop
        vertex 158.41815185546875 -20.170421600341797 -5.208700180053711
        vertex 159.85238647460938 -22.5 -0.625
        vertex 160.46804809570312 -23.5 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 -0.0
    outer loop
        vertex 131.53195190429688 23.5 -0.625
        vertex 129.9927978515625 26.0 -0.625
        vertex 129.9927978515625 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 0.0
    outer loop
        vertex 129.9927978515625 26.0 5.773159728050814e-15
        vertex 162.0072021484375 -26.0 -5.773159728050814e-15
        vertex 162.0072021484375 -26.0 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 2.0317383582583857e-16
    outer loop
        vertex 155.7479705810547 -15.833333015441895 -0.625
        vertex 155.7479705810547 -15.833333015441895 -5.208700180053711
        vertex 155.13230895996094 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.8515531420707703 0.5242683291435242 1.0158688482569478e-16
    outer loop
        vertex 151.0279083251953 -8.166666984558105 -0.625
        vertex 150.41224670410156 -7.166666507720947 -5.208700180053711
        vertex 150.41224670410156 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 1.1428528513357603e-16
    outer loop
        vertex 146.30783081054688 -0.5 -0.625
        vertex 145.69216918945312 0.5 -5.208700180053711
        vertex 145.69216918945312 0.5 -0.625
    endloop
endfacet
facet normal 0.8515531420707703 0.5242683291435242 2.0317376965138956e-16
    outer loop
        vertex 141.58775329589844 7.166666507720947 -0.625
        vertex 140.9720916748047 8.166666984558105 -5.208700180053711
        vertex 140.9720916748047 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 2.0317383582583857e-16
    outer loop
        vertex 136.86769104003906 14.833333015441895 -0.625
        vertex 136.2520294189453 15.833333015441895 -5.208700180053711
        vertex 136.2520294189453 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8515533208847046 0.5242679715156555 -1.0176847808907041e-06
    outer loop
        vertex 158.41815185546875 -20.170421600341797 -5.208700180053711
        vertex 160.46804809570312 -23.5 -0.625
        vertex 158.89041137695312 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8515528440475464 0.5242688059806824 -3.408113116165623e-05
    outer loop
        vertex 129.9927978515625 26.0 5.773159728050814e-15
        vertex 162.0072021484375 -26.0 -0.625
        vertex 155.7479705810547 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 2.0317383582583857e-16
    outer loop
        vertex 155.7479705810547 -15.833333015441895 -0.625
        vertex 155.13230895996094 -14.833333015441895 -5.208700180053711
        vertex 155.13230895996094 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8515530824661255 0.5242684483528137 -2.0633538042602595e-06
    outer loop
        vertex 133.58184814453125 20.170421600341797 -5.208700180053711
        vertex 158.41815185546875 -20.170421600341797 -5.208700180053711
        vertex 158.89041137695312 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 -6.663299245701637e-06
    outer loop
        vertex 129.9927978515625 26.0 5.773159728050814e-15
        vertex 155.7479705810547 -15.833333015441895 -0.625
        vertex 155.13230895996094 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8515530824661255 0.524268388748169 1.98775978788035e-06
    outer loop
        vertex 133.58184814453125 20.170421600341797 -5.208700180053711
        vertex 158.89041137695312 -20.9375 -5.666999816894531
        vertex 133.10958862304688 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8515535593032837 0.5242676138877869 7.496217585867271e-05
    outer loop
        vertex 129.9927978515625 26.0 5.773159728050814e-15
        vertex 155.13230895996094 -14.833333015441895 -0.625
        vertex 151.0279083251953 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8515533804893494 0.5242679119110107 8.947282026383618e-07
    outer loop
        vertex 132.14761352539062 22.5 -0.625
        vertex 133.58184814453125 20.170421600341797 -5.208700180053711
        vertex 133.10958862304688 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8515531420707703 0.5242683291435242 2.032945485552773e-05
    outer loop
        vertex 129.9927978515625 26.0 5.773159728050814e-15
        vertex 151.0279083251953 -8.166666984558105 -0.625
        vertex 150.41224670410156 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 6.442715516641329e-07
    outer loop
        vertex 132.14761352539062 22.5 -0.625
        vertex 133.10958862304688 20.9375 -5.666999816894531
        vertex 131.53195190429688 23.5 -0.625
    endloop
endfacet
facet normal 0.8515527248382568 0.5242689847946167 -2.8076547096134163e-05
    outer loop
        vertex 129.9927978515625 26.0 5.773159728050814e-15
        vertex 150.41224670410156 -7.166666507720947 -0.625
        vertex 146.30783081054688 -0.5 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 3.0253240725438982e-15
    outer loop
        vertex 132.14761352539062 22.5 -0.625
        vertex 131.53195190429688 23.5 -0.625
        vertex 129.9927978515625 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 0.0
    outer loop
        vertex 129.9927978515625 26.0 5.773159728050814e-15
        vertex 146.30783081054688 -0.5 -0.625
        vertex 145.69216918945312 0.5 -0.625
    endloop
endfacet
facet normal 0.8515527248382568 0.5242689847946167 -3.4982308534381445e-06
    outer loop
        vertex 136.2520294189453 15.833333015441895 -0.625
        vertex 132.14761352539062 22.5 -0.625
        vertex 129.9927978515625 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8515527248382568 0.5242689847946167 -2.7017054890166037e-05
    outer loop
        vertex 129.9927978515625 26.0 5.773159728050814e-15
        vertex 145.69216918945312 0.5 -0.625
        vertex 141.58775329589844 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 6.663299245701637e-06
    outer loop
        vertex 136.86769104003906 14.833333015441895 -0.625
        vertex 136.2520294189453 15.833333015441895 -0.625
        vertex 129.9927978515625 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8515531420707703 0.5242683291435242 4.697652684626519e-07
    outer loop
        vertex 129.9927978515625 26.0 5.773159728050814e-15
        vertex 141.58775329589844 7.166666507720947 -0.625
        vertex 140.9720916748047 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8515535593032837 0.5242676138877869 2.898537422879599e-05
    outer loop
        vertex 140.9720916748047 8.166666984558105 -0.625
        vertex 136.86769104003906 14.833333015441895 -0.625
        vertex 129.9927978515625 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8515531420707703 0.5242683291435242 2.0317376965138956e-16
    outer loop
        vertex 151.0279083251953 -8.166666984558105 -0.625
        vertex 151.0279083251953 -8.166666984558105 -5.208700180053711
        vertex 150.41224670410156 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 1.2063445881773706e-16
    outer loop
        vertex 146.30783081054688 -0.5 -0.625
        vertex 146.30783081054688 -0.5 -5.208700180053711
        vertex 145.69216918945312 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.8515531420707703 0.5242683291435242 2.0317376965138956e-16
    outer loop
        vertex 141.58775329589844 7.166666507720947 -0.625
        vertex 141.58775329589844 7.166666507720947 -5.208700180053711
        vertex 140.9720916748047 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 2.0317383582583857e-16
    outer loop
        vertex 136.86769104003906 14.833333015441895 -0.625
        vertex 136.86769104003906 14.833333015441895 -5.208700180053711
        vertex 136.2520294189453 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 -4.839794200961478e-07
    outer loop
        vertex 158.41815185546875 -20.170421600341797 -5.208700180053711
        vertex 159.85238647460938 -22.5 -0.625
        vertex 160.46804809570312 -23.5 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 -0.0
    outer loop
        vertex 131.53195190429688 23.5 -0.625
        vertex 129.9927978515625 26.0 -0.625
        vertex 129.9927978515625 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 0.0
    outer loop
        vertex 129.9927978515625 26.0 5.773159728050814e-15
        vertex 162.0072021484375 -26.0 -5.773159728050814e-15
        vertex 162.0072021484375 -26.0 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 2.0317383582583857e-16
    outer loop
        vertex 155.7479705810547 -15.833333015441895 -0.625
        vertex 155.7479705810547 -15.833333015441895 -5.208700180053711
        vertex 155.13230895996094 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.8515531420707703 0.5242683291435242 1.0158688482569478e-16
    outer loop
        vertex 151.0279083251953 -8.166666984558105 -0.625
        vertex 150.41224670410156 -7.166666507720947 -5.208700180053711
        vertex 150.41224670410156 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 1.1428528513357603e-16
    outer loop
        vertex 146.30783081054688 -0.5 -0.625
        vertex 145.69216918945312 0.5 -5.208700180053711
        vertex 145.69216918945312 0.5 -0.625
    endloop
endfacet
facet normal 0.8515531420707703 0.5242683291435242 2.0317376965138956e-16
    outer loop
        vertex 141.58775329589844 7.166666507720947 -0.625
        vertex 140.9720916748047 8.166666984558105 -5.208700180053711
        vertex 140.9720916748047 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 2.0317383582583857e-16
    outer loop
        vertex 136.86769104003906 14.833333015441895 -0.625
        vertex 136.2520294189453 15.833333015441895 -5.208700180053711
        vertex 136.2520294189453 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8515533208847046 0.5242679715156555 -1.0176847808907041e-06
    outer loop
        vertex 158.41815185546875 -20.170421600341797 -5.208700180053711
        vertex 160.46804809570312 -23.5 -0.625
        vertex 158.89041137695312 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8515528440475464 0.5242688059806824 -3.408113116165623e-05
    outer loop
        vertex 129.9927978515625 26.0 5.773159728050814e-15
        vertex 162.0072021484375 -26.0 -0.625
        vertex 155.7479705810547 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 2.0317383582583857e-16
    outer loop
        vertex 155.7479705810547 -15.833333015441895 -0.625
        vertex 155.13230895996094 -14.833333015441895 -5.208700180053711
        vertex 155.13230895996094 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8515530824661255 0.5242684483528137 -2.0633538042602595e-06
    outer loop
        vertex 133.58184814453125 20.170421600341797 -5.208700180053711
        vertex 158.41815185546875 -20.170421600341797 -5.208700180053711
        vertex 158.89041137695312 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 -6.663299245701637e-06
    outer loop
        vertex 129.9927978515625 26.0 5.773159728050814e-15
        vertex 155.7479705810547 -15.833333015441895 -0.625
        vertex 155.13230895996094 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8515530824661255 0.524268388748169 1.98775978788035e-06
    outer loop
        vertex 133.58184814453125 20.170421600341797 -5.208700180053711
        vertex 158.89041137695312 -20.9375 -5.666999816894531
        vertex 133.10958862304688 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8515535593032837 0.5242676138877869 7.496217585867271e-05
    outer loop
        vertex 129.9927978515625 26.0 5.773159728050814e-15
        vertex 155.13230895996094 -14.833333015441895 -0.625
        vertex 151.0279083251953 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8515533804893494 0.5242679119110107 8.947282026383618e-07
    outer loop
        vertex 132.14761352539062 22.5 -0.625
        vertex 133.58184814453125 20.170421600341797 -5.208700180053711
        vertex 133.10958862304688 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8515531420707703 0.5242683291435242 2.032945485552773e-05
    outer loop
        vertex 129.9927978515625 26.0 5.773159728050814e-15
        vertex 151.0279083251953 -8.166666984558105 -0.625
        vertex 150.41224670410156 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 6.442715516641329e-07
    outer loop
        vertex 132.14761352539062 22.5 -0.625
        vertex 133.10958862304688 20.9375 -5.666999816894531
        vertex 131.53195190429688 23.5 -0.625
    endloop
endfacet
facet normal 0.8515527248382568 0.5242689847946167 -2.8076547096134163e-05
    outer loop
        vertex 129.9927978515625 26.0 5.773159728050814e-15
        vertex 150.41224670410156 -7.166666507720947 -0.625
        vertex 146.30783081054688 -0.5 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 3.0253240725438982e-15
    outer loop
        vertex 132.14761352539062 22.5 -0.625
        vertex 131.53195190429688 23.5 -0.625
        vertex 129.9927978515625 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 0.0
    outer loop
        vertex 129.9927978515625 26.0 5.773159728050814e-15
        vertex 146.30783081054688 -0.5 -0.625
        vertex 145.69216918945312 0.5 -0.625
    endloop
endfacet
facet normal 0.8515527248382568 0.5242689847946167 -3.4982308534381445e-06
    outer loop
        vertex 136.2520294189453 15.833333015441895 -0.625
        vertex 132.14761352539062 22.5 -0.625
        vertex 129.9927978515625 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8515527248382568 0.5242689847946167 -2.7017054890166037e-05
    outer loop
        vertex 129.9927978515625 26.0 5.773159728050814e-15
        vertex 145.69216918945312 0.5 -0.625
        vertex 141.58775329589844 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 6.663299245701637e-06
    outer loop
        vertex 136.86769104003906 14.833333015441895 -0.625
        vertex 136.2520294189453 15.833333015441895 -0.625
        vertex 129.9927978515625 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8515531420707703 0.5242683291435242 4.697652684626519e-07
    outer loop
        vertex 129.9927978515625 26.0 5.773159728050814e-15
        vertex 141.58775329589844 7.166666507720947 -0.625
        vertex 140.9720916748047 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8515535593032837 0.5242676138877869 2.898537422879599e-05
    outer loop
        vertex 140.9720916748047 8.166666984558105 -0.625
        vertex 136.86769104003906 14.833333015441895 -0.625
        vertex 129.9927978515625 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 1.8148514692980838e-16
    outer loop
        vertex 140.595458984375 -8.166666984558105 -0.625
        vertex 140.595458984375 -8.166666984558105 -5.208700180053711
        vertex 140.06544494628906 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.0775684486706252e-16
    outer loop
        vertex 136.53201293945312 -0.5 -0.625
        vertex 136.53201293945312 -0.5 -5.208700180053711
        vertex 136.0019989013672 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 1.8148514692980838e-16
    outer loop
        vertex 132.4685516357422 7.166666507720947 -0.625
        vertex 132.4685516357422 7.166666507720947 -5.208700180053711
        vertex 131.93853759765625 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.8148521310425739e-16
    outer loop
        vertex 128.40509033203125 14.833333015441895 -0.625
        vertex 128.40509033203125 14.833333015441895 -5.208700180053711
        vertex 127.87507629394531 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 -2.773317362425587e-07
    outer loop
        vertex 146.95765686035156 -20.170421600341797 -5.208700180053711
        vertex 148.19236755371094 -22.5 -0.625
        vertex 148.72238159179688 -23.5 -0.625
    endloop
endfacet
facet normal 0.883566677570343 0.46830543875694275 -0.0
    outer loop
        vertex 123.81161499023438 23.5 -0.625
        vertex 122.486572265625 26.0 -0.625
        vertex 122.486572265625 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835669159889221 0.46830493211746216 0.0
    outer loop
        vertex 122.486572265625 26.0 5.773159728050814e-15
        vertex 150.04742431640625 -26.0 -5.773159728050814e-15
        vertex 150.04742431640625 -26.0 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.8148521310425739e-16
    outer loop
        vertex 144.65892028808594 -15.833333015441895 -0.625
        vertex 144.65892028808594 -15.833333015441895 -5.208700180053711
        vertex 144.12890625 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 9.074257346490419e-17
    outer loop
        vertex 140.595458984375 -8.166666984558105 -0.625
        vertex 140.06544494628906 -7.166666507720947 -5.208700180053711
        vertex 140.06544494628906 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.0208542988960294e-16
    outer loop
        vertex 136.53201293945312 -0.5 -0.625
        vertex 136.0019989013672 0.5 -5.208700180053711
        vertex 136.0019989013672 0.5 -0.625
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 1.8148514692980838e-16
    outer loop
        vertex 132.4685516357422 7.166666507720947 -0.625
        vertex 131.93853759765625 8.166666984558105 -5.208700180053711
        vertex 131.93853759765625 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.8148521310425739e-16
    outer loop
        vertex 128.40509033203125 14.833333015441895 -0.625
        vertex 127.87507629394531 15.833333015441895 -5.208700180053711
        vertex 127.87507629394531 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8835700750350952 0.46829894185066223 -4.36199616160593e-06
    outer loop
        vertex 146.95765686035156 -20.170421600341797 -5.208700180053711
        vertex 148.72238159179688 -23.5 -0.625
        vertex 147.3642120361328 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835667967796326 0.46830520033836365 -2.8486658266047016e-05
    outer loop
        vertex 122.486572265625 26.0 5.773159728050814e-15
        vertex 150.04742431640625 -26.0 -0.625
        vertex 144.65892028808594 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.8148521310425739e-16
    outer loop
        vertex 144.65892028808594 -15.833333015441895 -0.625
        vertex 144.12890625 -14.833333015441895 -5.208700180053711
        vertex 144.12890625 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8835669159889221 0.46830496191978455 -1.7304231732850894e-05
    outer loop
        vertex 125.57634735107422 20.170421600341797 -5.208700180053711
        vertex 146.95765686035156 -20.170421600341797 -5.208700180053711
        vertex 147.3642120361328 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 0.00013326230691745877
    outer loop
        vertex 122.486572265625 26.0 5.773159728050814e-15
        vertex 144.65892028808594 -15.833333015441895 -0.625
        vertex 144.12890625 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8835669755935669 0.4683047831058502 2.2308122424874455e-06
    outer loop
        vertex 125.57634735107422 20.170421600341797 -5.208700180053711
        vertex 147.3642120361328 -20.9375 -5.666999816894531
        vertex 125.16978454589844 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835666179656982 0.46830546855926514 -4.582256588037126e-05
    outer loop
        vertex 122.486572265625 26.0 5.773159728050814e-15
        vertex 144.12890625 -14.833333015441895 -0.625
        vertex 140.595458984375 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8835672736167908 0.46830427646636963 1.1230368954784353e-06
    outer loop
        vertex 124.34162902832031 22.5 -0.625
        vertex 125.57634735107422 20.170421600341797 -5.208700180053711
        vertex 125.16978454589844 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 0.00011623126920312643
    outer loop
        vertex 122.486572265625 26.0 5.773159728050814e-15
        vertex 140.595458984375 -8.166666984558105 -0.625
        vertex 140.06544494628906 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.5041101733004325e-06
    outer loop
        vertex 124.34162902832031 22.5 -0.625
        vertex 125.16978454589844 20.9375 -5.666999816894531
        vertex 123.81161499023438 23.5 -0.625
    endloop
endfacet
facet normal 0.8835674524307251 0.4683038592338562 6.801601557526737e-05
    outer loop
        vertex 122.486572265625 26.0 5.773159728050814e-15
        vertex 140.06544494628906 -7.166666507720947 -0.625
        vertex 136.53201293945312 -0.5 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.0785739505081438e-05
    outer loop
        vertex 124.34162902832031 22.5 -0.625
        vertex 123.81161499023438 23.5 -0.625
        vertex 122.486572265625 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 9.707165008876473e-05
    outer loop
        vertex 122.486572265625 26.0 5.773159728050814e-15
        vertex 136.53201293945312 -0.5 -0.625
        vertex 136.0019989013672 0.5 -0.625
    endloop
endfacet
facet normal 0.883566677570343 0.46830540895462036 -4.189239461993566e-06
    outer loop
        vertex 127.87507629394531 15.833333015441895 -0.625
        vertex 124.34162902832031 22.5 -0.625
        vertex 122.486572265625 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835666179656982 0.46830543875694275 -1.3398414012044668e-05
    outer loop
        vertex 122.486572265625 26.0 5.773159728050814e-15
        vertex 136.0019989013672 0.5 -0.625
        vertex 132.4685516357422 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 3.9309517887886614e-05
    outer loop
        vertex 128.40509033203125 14.833333015441895 -0.625
        vertex 127.87507629394531 15.833333015441895 -0.625
        vertex 122.486572265625 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 7.491949509130791e-05
    outer loop
        vertex 122.486572265625 26.0 5.773159728050814e-15
        vertex 132.4685516357422 7.166666507720947 -0.625
        vertex 131.93853759765625 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8835666179656982 0.46830546855926514 -9.664717254054267e-06
    outer loop
        vertex 131.93853759765625 8.166666984558105 -0.625
        vertex 128.40509033203125 14.833333015441895 -0.625
        vertex 122.486572265625 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 1.8148514692980838e-16
    outer loop
        vertex 140.595458984375 -8.166666984558105 -0.625
        vertex 140.595458984375 -8.166666984558105 -5.208700180053711
        vertex 140.06544494628906 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.0775684486706252e-16
    outer loop
        vertex 136.53201293945312 -0.5 -0.625
        vertex 136.53201293945312 -0.5 -5.208700180053711
        vertex 136.0019989013672 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 1.8148514692980838e-16
    outer loop
        vertex 132.4685516357422 7.166666507720947 -0.625
        vertex 132.4685516357422 7.166666507720947 -5.208700180053711
        vertex 131.93853759765625 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.8148521310425739e-16
    outer loop
        vertex 128.40509033203125 14.833333015441895 -0.625
        vertex 128.40509033203125 14.833333015441895 -5.208700180053711
        vertex 127.87507629394531 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 -2.773317362425587e-07
    outer loop
        vertex 146.95765686035156 -20.170421600341797 -5.208700180053711
        vertex 148.19236755371094 -22.5 -0.625
        vertex 148.72238159179688 -23.5 -0.625
    endloop
endfacet
facet normal 0.883566677570343 0.46830543875694275 -0.0
    outer loop
        vertex 123.81161499023438 23.5 -0.625
        vertex 122.486572265625 26.0 -0.625
        vertex 122.486572265625 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835669159889221 0.46830493211746216 0.0
    outer loop
        vertex 122.486572265625 26.0 5.773159728050814e-15
        vertex 150.04742431640625 -26.0 -5.773159728050814e-15
        vertex 150.04742431640625 -26.0 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.8148521310425739e-16
    outer loop
        vertex 144.65892028808594 -15.833333015441895 -0.625
        vertex 144.65892028808594 -15.833333015441895 -5.208700180053711
        vertex 144.12890625 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 9.074257346490419e-17
    outer loop
        vertex 140.595458984375 -8.166666984558105 -0.625
        vertex 140.06544494628906 -7.166666507720947 -5.208700180053711
        vertex 140.06544494628906 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.0208542988960294e-16
    outer loop
        vertex 136.53201293945312 -0.5 -0.625
        vertex 136.0019989013672 0.5 -5.208700180053711
        vertex 136.0019989013672 0.5 -0.625
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 1.8148514692980838e-16
    outer loop
        vertex 132.4685516357422 7.166666507720947 -0.625
        vertex 131.93853759765625 8.166666984558105 -5.208700180053711
        vertex 131.93853759765625 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.8148521310425739e-16
    outer loop
        vertex 128.40509033203125 14.833333015441895 -0.625
        vertex 127.87507629394531 15.833333015441895 -5.208700180053711
        vertex 127.87507629394531 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8835700750350952 0.46829894185066223 -4.36199616160593e-06
    outer loop
        vertex 146.95765686035156 -20.170421600341797 -5.208700180053711
        vertex 148.72238159179688 -23.5 -0.625
        vertex 147.3642120361328 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835667967796326 0.46830520033836365 -2.8486658266047016e-05
    outer loop
        vertex 122.486572265625 26.0 5.773159728050814e-15
        vertex 150.04742431640625 -26.0 -0.625
        vertex 144.65892028808594 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.8148521310425739e-16
    outer loop
        vertex 144.65892028808594 -15.833333015441895 -0.625
        vertex 144.12890625 -14.833333015441895 -5.208700180053711
        vertex 144.12890625 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8835669159889221 0.46830496191978455 -1.7304231732850894e-05
    outer loop
        vertex 125.57634735107422 20.170421600341797 -5.208700180053711
        vertex 146.95765686035156 -20.170421600341797 -5.208700180053711
        vertex 147.3642120361328 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 0.00013326230691745877
    outer loop
        vertex 122.486572265625 26.0 5.773159728050814e-15
        vertex 144.65892028808594 -15.833333015441895 -0.625
        vertex 144.12890625 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8835669755935669 0.4683047831058502 2.2308122424874455e-06
    outer loop
        vertex 125.57634735107422 20.170421600341797 -5.208700180053711
        vertex 147.3642120361328 -20.9375 -5.666999816894531
        vertex 125.16978454589844 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835666179656982 0.46830546855926514 -4.582256588037126e-05
    outer loop
        vertex 122.486572265625 26.0 5.773159728050814e-15
        vertex 144.12890625 -14.833333015441895 -0.625
        vertex 140.595458984375 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8835672736167908 0.46830427646636963 1.1230368954784353e-06
    outer loop
        vertex 124.34162902832031 22.5 -0.625
        vertex 125.57634735107422 20.170421600341797 -5.208700180053711
        vertex 125.16978454589844 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 0.00011623126920312643
    outer loop
        vertex 122.486572265625 26.0 5.773159728050814e-15
        vertex 140.595458984375 -8.166666984558105 -0.625
        vertex 140.06544494628906 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.5041101733004325e-06
    outer loop
        vertex 124.34162902832031 22.5 -0.625
        vertex 125.16978454589844 20.9375 -5.666999816894531
        vertex 123.81161499023438 23.5 -0.625
    endloop
endfacet
facet normal 0.8835674524307251 0.4683038592338562 6.801601557526737e-05
    outer loop
        vertex 122.486572265625 26.0 5.773159728050814e-15
        vertex 140.06544494628906 -7.166666507720947 -0.625
        vertex 136.53201293945312 -0.5 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 1.0785739505081438e-05
    outer loop
        vertex 124.34162902832031 22.5 -0.625
        vertex 123.81161499023438 23.5 -0.625
        vertex 122.486572265625 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 9.707165008876473e-05
    outer loop
        vertex 122.486572265625 26.0 5.773159728050814e-15
        vertex 136.53201293945312 -0.5 -0.625
        vertex 136.0019989013672 0.5 -0.625
    endloop
endfacet
facet normal 0.883566677570343 0.46830540895462036 -4.189239461993566e-06
    outer loop
        vertex 127.87507629394531 15.833333015441895 -0.625
        vertex 124.34162902832031 22.5 -0.625
        vertex 122.486572265625 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835666179656982 0.46830543875694275 -1.3398414012044668e-05
    outer loop
        vertex 122.486572265625 26.0 5.773159728050814e-15
        vertex 136.0019989013672 0.5 -0.625
        vertex 132.4685516357422 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.883567750453949 0.4683033227920532 3.9309517887886614e-05
    outer loop
        vertex 128.40509033203125 14.833333015441895 -0.625
        vertex 127.87507629394531 15.833333015441895 -0.625
        vertex 122.486572265625 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835678696632385 0.4683031439781189 7.491949509130791e-05
    outer loop
        vertex 122.486572265625 26.0 5.773159728050814e-15
        vertex 132.4685516357422 7.166666507720947 -0.625
        vertex 131.93853759765625 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8835666179656982 0.46830546855926514 -9.664717254054267e-06
    outer loop
        vertex 131.93853759765625 8.166666984558105 -0.625
        vertex 128.40509033203125 14.833333015441895 -0.625
        vertex 122.486572265625 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 1.514166287376934e-16
    outer loop
        vertex 129.9993438720703 -8.166666984558105 -0.625
        vertex 129.9993438720703 -8.166666984558105 -5.208700180053711
        vertex 129.57489013671875 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.9205143451690674 0.3907087445259094 8.990229031144832e-17
    outer loop
        vertex 126.74522399902344 -0.5 -0.625
        vertex 126.74522399902344 -0.5 -5.208700180053711
        vertex 126.3207778930664 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 1.514166287376934e-16
    outer loop
        vertex 123.4911117553711 7.166666507720947 -0.625
        vertex 123.4911117553711 7.166666507720947 -5.208700180053711
        vertex 123.06665802001953 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.9205143451690674 0.3907087445259094 1.5141437880642725e-16
    outer loop
        vertex 120.23699188232422 14.833333015441895 -0.625
        vertex 120.23699188232422 14.833333015441895 -5.208700180053711
        vertex 119.81254577636719 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 2.7037767722504213e-06
    outer loop
        vertex 135.09432983398438 -20.170421600341797 -5.208700180053711
        vertex 136.08311462402344 -22.5 -0.625
        vertex 136.507568359375 -23.5 -0.625
    endloop
endfacet
facet normal 0.920512855052948 0.39071229100227356 -0.0
    outer loop
        vertex 116.55843353271484 23.5 -0.625
        vertex 115.49730682373047 26.0 -0.625
        vertex 115.49730682373047 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205131530761719 0.39071160554885864 0.0
    outer loop
        vertex 115.49730682373047 26.0 5.773159728050814e-15
        vertex 137.56869506835938 -26.0 -5.773159728050814e-15
        vertex 137.56869506835938 -26.0 -0.625
    endloop
endfacet
facet normal 0.9205169081687927 0.3907027840614319 1.514120759356019e-16
    outer loop
        vertex 133.25344848632812 -15.833333015441895 -0.625
        vertex 133.25344848632812 -15.833333015441895 -5.208700180053711
        vertex 132.82901000976562 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 7.57083143688467e-17
    outer loop
        vertex 129.9993438720703 -8.166666984558105 -0.625
        vertex 129.57489013671875 -7.166666507720947 -5.208700180053711
        vertex 129.57489013671875 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9205143451690674 0.3907087445259094 8.517059221451839e-17
    outer loop
        vertex 126.74522399902344 -0.5 -0.625
        vertex 126.3207778930664 0.5 -5.208700180053711
        vertex 126.3207778930664 0.5 -0.625
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 1.514166287376934e-16
    outer loop
        vertex 123.4911117553711 7.166666507720947 -0.625
        vertex 123.06665802001953 8.166666984558105 -5.208700180053711
        vertex 123.06665802001953 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9205143451690674 0.3907087445259094 1.5141437880642725e-16
    outer loop
        vertex 120.23699188232422 14.833333015441895 -0.625
        vertex 119.81254577636719 15.833333015441895 -5.208700180053711
        vertex 119.81254577636719 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205114245414734 0.39071568846702576 3.5565235521062277e-06
    outer loop
        vertex 135.09432983398438 -20.170421600341797 -5.208700180053711
        vertex 136.507568359375 -23.5 -0.625
        vertex 135.419921875 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205129146575928 0.3907121419906616 -5.332512591849081e-05
    outer loop
        vertex 115.49730682373047 26.0 5.773159728050814e-15
        vertex 137.56869506835938 -26.0 -0.625
        vertex 133.25344848632812 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205169081687927 0.3907027840614319 1.514120759356019e-16
    outer loop
        vertex 133.25344848632812 -15.833333015441895 -0.625
        vertex 132.82901000976562 -14.833333015441895 -5.208700180053711
        vertex 132.82901000976562 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205131530761719 0.3907115161418915 1.1777615327446256e-05
    outer loop
        vertex 117.97167205810547 20.170421600341797 -5.208700180053711
        vertex 135.09432983398438 -20.170421600341797 -5.208700180053711
        vertex 135.419921875 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205166697502136 0.3907026946544647 0.0006856420659460127
    outer loop
        vertex 115.49730682373047 26.0 5.773159728050814e-15
        vertex 133.25344848632812 -15.833333015441895 -0.625
        vertex 132.82901000976562 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 -1.1346121937094722e-05
    outer loop
        vertex 117.97167205810547 20.170421600341797 -5.208700180053711
        vertex 135.419921875 -20.9375 -5.666999816894531
        vertex 117.64608001708984 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117545604706 -5.044853423896711e-06
    outer loop
        vertex 115.49730682373047 26.0 5.773159728050814e-15
        vertex 132.82901000976562 -14.833333015441895 -0.625
        vertex 129.9993438720703 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9205111265182495 0.3907163739204407 -2.184780896641314e-06
    outer loop
        vertex 116.98287963867188 22.5 -0.625
        vertex 117.97167205810547 20.170421600341797 -5.208700180053711
        vertex 117.64608001708984 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 -0.00018478369747754186
    outer loop
        vertex 115.49730682373047 26.0 5.773159728050814e-15
        vertex 129.9993438720703 -8.166666984558105 -0.625
        vertex 129.57489013671875 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9205143451690674 0.3907087445259094 6.093907813919941e-07
    outer loop
        vertex 116.98287963867188 22.5 -0.625
        vertex 117.64608001708984 20.9375 -5.666999816894531
        vertex 116.55843353271484 23.5 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 -8.822517884254921e-06
    outer loop
        vertex 115.49730682373047 26.0 5.773159728050814e-15
        vertex 129.57489013671875 -7.166666507720947 -0.625
        vertex 126.74522399902344 -0.5 -0.625
    endloop
endfacet
facet normal 0.9205143451690674 0.3907087445259094 1.685512143012602e-05
    outer loop
        vertex 116.98287963867188 22.5 -0.625
        vertex 116.55843353271484 23.5 -0.625
        vertex 115.49730682373047 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205143451690674 0.3907087445259094 0.00014045934949535877
    outer loop
        vertex 115.49730682373047 26.0 5.773159728050814e-15
        vertex 126.74522399902344 -0.5 -0.625
        vertex 126.3207778930664 0.5 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907116949558258 -2.704851794987917e-06
    outer loop
        vertex 119.81254577636719 15.833333015441895 -0.625
        vertex 116.98287963867188 22.5 -0.625
        vertex 115.49730682373047 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 -3.1892470815364504e-06
    outer loop
        vertex 115.49730682373047 26.0 5.773159728050814e-15
        vertex 126.3207778930664 0.5 -0.625
        vertex 123.4911117553711 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9205143451690674 0.3907087445259094 5.411222082329914e-05
    outer loop
        vertex 120.23699188232422 14.833333015441895 -0.625
        vertex 119.81254577636719 15.833333015441895 -0.625
        vertex 115.49730682373047 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 -0.0001031069114105776
    outer loop
        vertex 115.49730682373047 26.0 5.773159728050814e-15
        vertex 123.4911117553711 7.166666507720947 -0.625
        vertex 123.06665802001953 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117545604706 -9.292008144257125e-06
    outer loop
        vertex 123.06665802001953 8.166666984558105 -0.625
        vertex 120.23699188232422 14.833333015441895 -0.625
        vertex 115.49730682373047 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 1.514166287376934e-16
    outer loop
        vertex 129.9993438720703 -8.166666984558105 -0.625
        vertex 129.9993438720703 -8.166666984558105 -5.208700180053711
        vertex 129.57489013671875 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.9205143451690674 0.3907087445259094 8.990229031144832e-17
    outer loop
        vertex 126.74522399902344 -0.5 -0.625
        vertex 126.74522399902344 -0.5 -5.208700180053711
        vertex 126.3207778930664 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 1.514166287376934e-16
    outer loop
        vertex 123.4911117553711 7.166666507720947 -0.625
        vertex 123.4911117553711 7.166666507720947 -5.208700180053711
        vertex 123.06665802001953 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.9205143451690674 0.3907087445259094 1.5141437880642725e-16
    outer loop
        vertex 120.23699188232422 14.833333015441895 -0.625
        vertex 120.23699188232422 14.833333015441895 -5.208700180053711
        vertex 119.81254577636719 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9205118417739868 0.3907146751880646 2.7037767722504213e-06
    outer loop
        vertex 135.09432983398438 -20.170421600341797 -5.208700180053711
        vertex 136.08311462402344 -22.5 -0.625
        vertex 136.507568359375 -23.5 -0.625
    endloop
endfacet
facet normal 0.920512855052948 0.39071229100227356 -0.0
    outer loop
        vertex 116.55843353271484 23.5 -0.625
        vertex 115.49730682373047 26.0 -0.625
        vertex 115.49730682373047 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205131530761719 0.39071160554885864 0.0
    outer loop
        vertex 115.49730682373047 26.0 5.773159728050814e-15
        vertex 137.56869506835938 -26.0 -5.773159728050814e-15
        vertex 137.56869506835938 -26.0 -0.625
    endloop
endfacet
facet normal 0.9205169081687927 0.3907027840614319 1.514120759356019e-16
    outer loop
        vertex 133.25344848632812 -15.833333015441895 -0.625
        vertex 133.25344848632812 -15.833333015441895 -5.208700180053711
        vertex 132.82901000976562 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 7.57083143688467e-17
    outer loop
        vertex 129.9993438720703 -8.166666984558105 -0.625
        vertex 129.57489013671875 -7.166666507720947 -5.208700180053711
        vertex 129.57489013671875 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9205143451690674 0.3907087445259094 8.517059221451839e-17
    outer loop
        vertex 126.74522399902344 -0.5 -0.625
        vertex 126.3207778930664 0.5 -5.208700180053711
        vertex 126.3207778930664 0.5 -0.625
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 1.514166287376934e-16
    outer loop
        vertex 123.4911117553711 7.166666507720947 -0.625
        vertex 123.06665802001953 8.166666984558105 -5.208700180053711
        vertex 123.06665802001953 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9205143451690674 0.3907087445259094 1.5141437880642725e-16
    outer loop
        vertex 120.23699188232422 14.833333015441895 -0.625
        vertex 119.81254577636719 15.833333015441895 -5.208700180053711
        vertex 119.81254577636719 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205114245414734 0.39071568846702576 3.5565235521062277e-06
    outer loop
        vertex 135.09432983398438 -20.170421600341797 -5.208700180053711
        vertex 136.507568359375 -23.5 -0.625
        vertex 135.419921875 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205129146575928 0.3907121419906616 -5.332512591849081e-05
    outer loop
        vertex 115.49730682373047 26.0 5.773159728050814e-15
        vertex 137.56869506835938 -26.0 -0.625
        vertex 133.25344848632812 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205169081687927 0.3907027840614319 1.514120759356019e-16
    outer loop
        vertex 133.25344848632812 -15.833333015441895 -0.625
        vertex 132.82901000976562 -14.833333015441895 -5.208700180053711
        vertex 132.82901000976562 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205131530761719 0.3907115161418915 1.1777615327446256e-05
    outer loop
        vertex 117.97167205810547 20.170421600341797 -5.208700180053711
        vertex 135.09432983398438 -20.170421600341797 -5.208700180053711
        vertex 135.419921875 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205166697502136 0.3907026946544647 0.0006856420659460127
    outer loop
        vertex 115.49730682373047 26.0 5.773159728050814e-15
        vertex 133.25344848632812 -15.833333015441895 -0.625
        vertex 132.82901000976562 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 -1.1346121937094722e-05
    outer loop
        vertex 117.97167205810547 20.170421600341797 -5.208700180053711
        vertex 135.419921875 -20.9375 -5.666999816894531
        vertex 117.64608001708984 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117545604706 -5.044853423896711e-06
    outer loop
        vertex 115.49730682373047 26.0 5.773159728050814e-15
        vertex 132.82901000976562 -14.833333015441895 -0.625
        vertex 129.9993438720703 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9205111265182495 0.3907163739204407 -2.184780896641314e-06
    outer loop
        vertex 116.98287963867188 22.5 -0.625
        vertex 117.97167205810547 20.170421600341797 -5.208700180053711
        vertex 117.64608001708984 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 -0.00018478369747754186
    outer loop
        vertex 115.49730682373047 26.0 5.773159728050814e-15
        vertex 129.9993438720703 -8.166666984558105 -0.625
        vertex 129.57489013671875 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9205143451690674 0.3907087445259094 6.093907813919941e-07
    outer loop
        vertex 116.98287963867188 22.5 -0.625
        vertex 117.64608001708984 20.9375 -5.666999816894531
        vertex 116.55843353271484 23.5 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 -8.822517884254921e-06
    outer loop
        vertex 115.49730682373047 26.0 5.773159728050814e-15
        vertex 129.57489013671875 -7.166666507720947 -0.625
        vertex 126.74522399902344 -0.5 -0.625
    endloop
endfacet
facet normal 0.9205143451690674 0.3907087445259094 1.685512143012602e-05
    outer loop
        vertex 116.98287963867188 22.5 -0.625
        vertex 116.55843353271484 23.5 -0.625
        vertex 115.49730682373047 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205143451690674 0.3907087445259094 0.00014045934949535877
    outer loop
        vertex 115.49730682373047 26.0 5.773159728050814e-15
        vertex 126.74522399902344 -0.5 -0.625
        vertex 126.3207778930664 0.5 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907116949558258 -2.704851794987917e-06
    outer loop
        vertex 119.81254577636719 15.833333015441895 -0.625
        vertex 116.98287963867188 22.5 -0.625
        vertex 115.49730682373047 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 -3.1892470815364504e-06
    outer loop
        vertex 115.49730682373047 26.0 5.773159728050814e-15
        vertex 126.3207778930664 0.5 -0.625
        vertex 123.4911117553711 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9205143451690674 0.3907087445259094 5.411222082329914e-05
    outer loop
        vertex 120.23699188232422 14.833333015441895 -0.625
        vertex 119.81254577636719 15.833333015441895 -0.625
        vertex 115.49730682373047 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205119013786316 0.39071452617645264 -0.0001031069114105776
    outer loop
        vertex 115.49730682373047 26.0 5.773159728050814e-15
        vertex 123.4911117553711 7.166666507720947 -0.625
        vertex 123.06665802001953 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117545604706 -9.292008144257125e-06
    outer loop
        vertex 123.06665802001953 8.166666984558105 -0.625
        vertex 120.23699188232422 14.833333015441895 -0.625
        vertex 115.49730682373047 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582771062850952 0.2858409285545349 1.1077414827874975e-16
    outer loop
        vertex 119.23601531982422 -8.166666984558105 -0.625
        vertex 119.23601531982422 -8.166666984558105 -5.208700180053711
        vertex 118.93772888183594 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 6.577218114619033e-17
    outer loop
        vertex 116.94914245605469 -0.5 -0.625
        vertex 116.94914245605469 -0.5 -5.208700180053711
        vertex 116.6508560180664 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.9582750797271729 0.28584763407707214 1.1077674893459561e-16
    outer loop
        vertex 114.66227722167969 7.166666507720947 -0.625
        vertex 114.66227722167969 7.166666507720947 -5.208700180053711
        vertex 114.36398315429688 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 1.1077419460086405e-16
    outer loop
        vertex 112.37540435791016 14.833333015441895 -0.625
        vertex 112.37540435791016 14.833333015441895 -5.208700180053711
        vertex 112.07711791992188 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 -7.549346037194482e-07
    outer loop
        vertex 122.81658172607422 -20.170421600341797 -5.208700180053711
        vertex 123.51146697998047 -22.5 -0.625
        vertex 123.80975341796875 -23.5 -0.625
    endloop
endfacet
facet normal 0.958276629447937 0.2858423888683319 -0.0
    outer loop
        vertex 109.79024505615234 23.5 -0.625
        vertex 109.04452514648438 26.0 -0.625
        vertex 109.04452514648438 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582767486572266 0.2858419418334961 0.0
    outer loop
        vertex 109.04452514648438 26.0 5.773159728050814e-15
        vertex 124.55547332763672 -26.0 -5.773159728050814e-15
        vertex 124.55547332763672 -26.0 -0.625
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 1.1077419460086405e-16
    outer loop
        vertex 121.52288055419922 -15.833333015441895 -0.625
        vertex 121.52288055419922 -15.833333015441895 -5.208700180053711
        vertex 121.22459411621094 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9582771062850952 0.2858409285545349 5.538707413937487e-17
    outer loop
        vertex 119.23601531982422 -8.166666984558105 -0.625
        vertex 118.93772888183594 -7.166666507720947 -5.208700180053711
        vertex 118.93772888183594 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 6.231048322221511e-17
    outer loop
        vertex 116.94914245605469 -0.5 -0.625
        vertex 116.6508560180664 0.5 -5.208700180053711
        vertex 116.6508560180664 0.5 -0.625
    endloop
endfacet
facet normal 0.9582750797271729 0.28584763407707214 1.1077674893459561e-16
    outer loop
        vertex 114.66227722167969 7.166666507720947 -0.625
        vertex 114.36398315429688 8.166666984558105 -5.208700180053711
        vertex 114.36398315429688 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 1.1077419460086405e-16
    outer loop
        vertex 112.37540435791016 14.833333015441895 -0.625
        vertex 112.07711791992188 15.833333015441895 -5.208700180053711
        vertex 112.07711791992188 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582759737968445 0.2858445942401886 2.060425913441577e-06
    outer loop
        vertex 122.81658172607422 -20.170421600341797 -5.208700180053711
        vertex 123.80975341796875 -23.5 -0.625
        vertex 123.04539489746094 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582766890525818 0.28584223985671997 -2.7062422304879874e-05
    outer loop
        vertex 109.04452514648438 26.0 5.773159728050814e-15
        vertex 124.55547332763672 -26.0 -0.625
        vertex 121.52288055419922 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 1.1077419460086405e-16
    outer loop
        vertex 121.52288055419922 -15.833333015441895 -0.625
        vertex 121.22459411621094 -14.833333015441895 -5.208700180053711
        vertex 121.22459411621094 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582768082618713 0.2858418822288513 7.014659331616713e-06
    outer loop
        vertex 110.78341674804688 20.170421600341797 -5.208700180053711
        vertex 122.81658172607422 -20.170421600341797 -5.208700180053711
        vertex 123.04539489746094 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 6.058359576854855e-05
    outer loop
        vertex 109.04452514648438 26.0 5.773159728050814e-15
        vertex 121.52288055419922 -15.833333015441895 -0.625
        vertex 121.22459411621094 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582768082618713 0.2858418822288513 8.902711670089047e-06
    outer loop
        vertex 110.78341674804688 20.170421600341797 -5.208700180053711
        vertex 123.04539489746094 -20.9375 -5.666999816894531
        vertex 110.55461120605469 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582769274711609 0.2858414053916931 3.4919765312224627e-05
    outer loop
        vertex 109.04452514648438 26.0 5.773159728050814e-15
        vertex 121.22459411621094 -14.833333015441895 -0.625
        vertex 119.23601531982422 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9582778811454773 0.28583824634552 2.30389764510619e-06
    outer loop
        vertex 110.08853149414062 22.5 -0.625
        vertex 110.78341674804688 20.170421600341797 -5.208700180053711
        vertex 110.55461120605469 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582771062850952 0.2858409285545349 6.384462903952226e-05
    outer loop
        vertex 109.04452514648438 26.0 5.773159728050814e-15
        vertex 119.23601531982422 -8.166666984558105 -0.625
        vertex 118.93772888183594 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 1.3594072925116052e-06
    outer loop
        vertex 110.08853149414062 22.5 -0.625
        vertex 110.55461120605469 20.9375 -5.666999816894531
        vertex 109.79024505615234 23.5 -0.625
    endloop
endfacet
facet normal 0.958276629447937 0.2858423888683319 -2.1344840206438676e-05
    outer loop
        vertex 109.04452514648438 26.0 5.773159728050814e-15
        vertex 118.93772888183594 -7.166666507720947 -0.625
        vertex 116.94914245605469 -0.5 -0.625
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 5.848859018442454e-06
    outer loop
        vertex 110.08853149414062 22.5 -0.625
        vertex 109.79024505615234 23.5 -0.625
        vertex 109.04452514648438 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 4.094201358384453e-05
    outer loop
        vertex 109.04452514648438 26.0 5.773159728050814e-15
        vertex 116.94914245605469 -0.5 -0.625
        vertex 116.6508560180664 0.5 -0.625
    endloop
endfacet
facet normal 0.958276629447937 0.2858423888683319 -2.2632143554801587e-06
    outer loop
        vertex 112.07711791992188 15.833333015441895 -0.625
        vertex 110.08853149414062 22.5 -0.625
        vertex 109.04452514648438 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582769274711609 0.2858413755893707 2.5749368433025666e-05
    outer loop
        vertex 109.04452514648438 26.0 5.773159728050814e-15
        vertex 116.6508560180664 0.5 -0.625
        vertex 114.66227722167969 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 2.1300429580151103e-05
    outer loop
        vertex 112.37540435791016 14.833333015441895 -0.625
        vertex 112.07711791992188 15.833333015441895 -0.625
        vertex 109.04452514648438 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582750797271729 0.28584763407707214 -0.00017922930419445038
    outer loop
        vertex 109.04452514648438 26.0 5.773159728050814e-15
        vertex 114.66227722167969 7.166666507720947 -0.625
        vertex 114.36398315429688 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9582769274711609 0.2858414053916931 1.4282157280831598e-05
    outer loop
        vertex 114.36398315429688 8.166666984558105 -0.625
        vertex 112.37540435791016 14.833333015441895 -0.625
        vertex 109.04452514648438 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582771062850952 0.2858409285545349 1.1077414827874975e-16
    outer loop
        vertex 119.23601531982422 -8.166666984558105 -0.625
        vertex 119.23601531982422 -8.166666984558105 -5.208700180053711
        vertex 118.93772888183594 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 6.577218114619033e-17
    outer loop
        vertex 116.94914245605469 -0.5 -0.625
        vertex 116.94914245605469 -0.5 -5.208700180053711
        vertex 116.6508560180664 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.9582750797271729 0.28584763407707214 1.1077674893459561e-16
    outer loop
        vertex 114.66227722167969 7.166666507720947 -0.625
        vertex 114.66227722167969 7.166666507720947 -5.208700180053711
        vertex 114.36398315429688 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 1.1077419460086405e-16
    outer loop
        vertex 112.37540435791016 14.833333015441895 -0.625
        vertex 112.37540435791016 14.833333015441895 -5.208700180053711
        vertex 112.07711791992188 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 -7.549346037194482e-07
    outer loop
        vertex 122.81658172607422 -20.170421600341797 -5.208700180053711
        vertex 123.51146697998047 -22.5 -0.625
        vertex 123.80975341796875 -23.5 -0.625
    endloop
endfacet
facet normal 0.958276629447937 0.2858423888683319 -0.0
    outer loop
        vertex 109.79024505615234 23.5 -0.625
        vertex 109.04452514648438 26.0 -0.625
        vertex 109.04452514648438 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582767486572266 0.2858419418334961 0.0
    outer loop
        vertex 109.04452514648438 26.0 5.773159728050814e-15
        vertex 124.55547332763672 -26.0 -5.773159728050814e-15
        vertex 124.55547332763672 -26.0 -0.625
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 1.1077419460086405e-16
    outer loop
        vertex 121.52288055419922 -15.833333015441895 -0.625
        vertex 121.52288055419922 -15.833333015441895 -5.208700180053711
        vertex 121.22459411621094 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9582771062850952 0.2858409285545349 5.538707413937487e-17
    outer loop
        vertex 119.23601531982422 -8.166666984558105 -0.625
        vertex 118.93772888183594 -7.166666507720947 -5.208700180053711
        vertex 118.93772888183594 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 6.231048322221511e-17
    outer loop
        vertex 116.94914245605469 -0.5 -0.625
        vertex 116.6508560180664 0.5 -5.208700180053711
        vertex 116.6508560180664 0.5 -0.625
    endloop
endfacet
facet normal 0.9582750797271729 0.28584763407707214 1.1077674893459561e-16
    outer loop
        vertex 114.66227722167969 7.166666507720947 -0.625
        vertex 114.36398315429688 8.166666984558105 -5.208700180053711
        vertex 114.36398315429688 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 1.1077419460086405e-16
    outer loop
        vertex 112.37540435791016 14.833333015441895 -0.625
        vertex 112.07711791992188 15.833333015441895 -5.208700180053711
        vertex 112.07711791992188 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582759737968445 0.2858445942401886 2.060425913441577e-06
    outer loop
        vertex 122.81658172607422 -20.170421600341797 -5.208700180053711
        vertex 123.80975341796875 -23.5 -0.625
        vertex 123.04539489746094 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582766890525818 0.28584223985671997 -2.7062422304879874e-05
    outer loop
        vertex 109.04452514648438 26.0 5.773159728050814e-15
        vertex 124.55547332763672 -26.0 -0.625
        vertex 121.52288055419922 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 1.1077419460086405e-16
    outer loop
        vertex 121.52288055419922 -15.833333015441895 -0.625
        vertex 121.22459411621094 -14.833333015441895 -5.208700180053711
        vertex 121.22459411621094 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582768082618713 0.2858418822288513 7.014659331616713e-06
    outer loop
        vertex 110.78341674804688 20.170421600341797 -5.208700180053711
        vertex 122.81658172607422 -20.170421600341797 -5.208700180053711
        vertex 123.04539489746094 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 6.058359576854855e-05
    outer loop
        vertex 109.04452514648438 26.0 5.773159728050814e-15
        vertex 121.52288055419922 -15.833333015441895 -0.625
        vertex 121.22459411621094 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582768082618713 0.2858418822288513 8.902711670089047e-06
    outer loop
        vertex 110.78341674804688 20.170421600341797 -5.208700180053711
        vertex 123.04539489746094 -20.9375 -5.666999816894531
        vertex 110.55461120605469 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582769274711609 0.2858414053916931 3.4919765312224627e-05
    outer loop
        vertex 109.04452514648438 26.0 5.773159728050814e-15
        vertex 121.22459411621094 -14.833333015441895 -0.625
        vertex 119.23601531982422 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9582778811454773 0.28583824634552 2.30389764510619e-06
    outer loop
        vertex 110.08853149414062 22.5 -0.625
        vertex 110.78341674804688 20.170421600341797 -5.208700180053711
        vertex 110.55461120605469 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582771062850952 0.2858409285545349 6.384462903952226e-05
    outer loop
        vertex 109.04452514648438 26.0 5.773159728050814e-15
        vertex 119.23601531982422 -8.166666984558105 -0.625
        vertex 118.93772888183594 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 1.3594072925116052e-06
    outer loop
        vertex 110.08853149414062 22.5 -0.625
        vertex 110.55461120605469 20.9375 -5.666999816894531
        vertex 109.79024505615234 23.5 -0.625
    endloop
endfacet
facet normal 0.958276629447937 0.2858423888683319 -2.1344840206438676e-05
    outer loop
        vertex 109.04452514648438 26.0 5.773159728050814e-15
        vertex 118.93772888183594 -7.166666507720947 -0.625
        vertex 116.94914245605469 -0.5 -0.625
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 5.848859018442454e-06
    outer loop
        vertex 110.08853149414062 22.5 -0.625
        vertex 109.79024505615234 23.5 -0.625
        vertex 109.04452514648438 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 4.094201358384453e-05
    outer loop
        vertex 109.04452514648438 26.0 5.773159728050814e-15
        vertex 116.94914245605469 -0.5 -0.625
        vertex 116.6508560180664 0.5 -0.625
    endloop
endfacet
facet normal 0.958276629447937 0.2858423888683319 -2.2632143554801587e-06
    outer loop
        vertex 112.07711791992188 15.833333015441895 -0.625
        vertex 110.08853149414062 22.5 -0.625
        vertex 109.04452514648438 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582769274711609 0.2858413755893707 2.5749368433025666e-05
    outer loop
        vertex 109.04452514648438 26.0 5.773159728050814e-15
        vertex 116.6508560180664 0.5 -0.625
        vertex 114.66227722167969 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 2.1300429580151103e-05
    outer loop
        vertex 112.37540435791016 14.833333015441895 -0.625
        vertex 112.07711791992188 15.833333015441895 -0.625
        vertex 109.04452514648438 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582750797271729 0.28584763407707214 -0.00017922930419445038
    outer loop
        vertex 109.04452514648438 26.0 5.773159728050814e-15
        vertex 114.66227722167969 7.166666507720947 -0.625
        vertex 114.36398315429688 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9582769274711609 0.2858414053916931 1.4282157280831598e-05
    outer loop
        vertex 114.36398315429688 8.166666984558105 -0.625
        vertex 112.37540435791016 14.833333015441895 -0.625
        vertex 109.04452514648438 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882921576499939 0.15257325768470764 5.912789588924998e-17
    outer loop
        vertex 108.32779693603516 -8.166666984558105 -0.625
        vertex 108.32779693603516 -8.166666984558105 -5.208700180053711
        vertex 108.17341613769531 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.9882910251617432 0.15258069336414337 3.510890024131501e-17
    outer loop
        vertex 107.14419555664062 -0.5 -0.625
        vertex 107.14419555664062 -0.5 -5.208700180053711
        vertex 106.98980712890625 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.9882910251617432 0.1525806188583374 5.913075462544697e-17
    outer loop
        vertex 105.96058654785156 7.166666507720947 -0.625
        vertex 105.96058654785156 7.166666507720947 -5.208700180053711
        vertex 105.80619812011719 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.9882910251617432 0.15258069336414337 5.913078109522657e-17
    outer loop
        vertex 104.7769775390625 14.833333015441895 -0.625
        vertex 104.7769775390625 14.833333015441895 -5.208700180053711
        vertex 104.62258911132812 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9882921576499939 0.1525733321905136 -1.6138565115397796e-06
    outer loop
        vertex 110.18098449707031 -20.170421600341797 -5.208700180053711
        vertex 110.54063415527344 -22.5 -0.625
        vertex 110.69501495361328 -23.5 -0.625
    endloop
endfacet
facet normal 0.9882919192314148 0.1525748074054718 -0.0
    outer loop
        vertex 103.43898010253906 23.5 -0.625
        vertex 103.05302429199219 26.0 -0.625
        vertex 103.05302429199219 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882917404174805 0.15257616341114044 0.0
    outer loop
        vertex 103.05302429199219 26.0 5.773159728050814e-15
        vertex 111.08097839355469 -26.0 -5.773159728050814e-15
        vertex 111.08097839355469 -26.0 -0.625
    endloop
endfacet
facet normal 0.9882921576499939 0.1525733321905136 5.912792235902959e-17
    outer loop
        vertex 109.51140594482422 -15.833333015441895 -0.625
        vertex 109.51140594482422 -15.833333015441895 -5.208700180053711
        vertex 109.35702514648438 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9882921576499939 0.15257325768470764 2.956394794462499e-17
    outer loop
        vertex 108.32779693603516 -8.166666984558105 -0.625
        vertex 108.17341613769531 -7.166666507720947 -5.208700180053711
        vertex 108.17341613769531 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9882910251617432 0.15258069336414337 3.326106477965525e-17
    outer loop
        vertex 107.14419555664062 -0.5 -0.625
        vertex 106.98980712890625 0.5 -5.208700180053711
        vertex 106.98980712890625 0.5 -0.625
    endloop
endfacet
facet normal 0.9882910251617432 0.1525806188583374 5.913075462544697e-17
    outer loop
        vertex 105.96058654785156 7.166666507720947 -0.625
        vertex 105.80619812011719 8.166666984558105 -5.208700180053711
        vertex 105.80619812011719 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9882910251617432 0.15258069336414337 5.913078109522657e-17
    outer loop
        vertex 104.7769775390625 14.833333015441895 -0.625
        vertex 104.62258911132812 15.833333015441895 -5.208700180053711
        vertex 104.62258911132812 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.98829185962677 0.15257512032985687 -2.860162453544035e-07
    outer loop
        vertex 110.18098449707031 -20.170421600341797 -5.208700180053711
        vertex 110.69501495361328 -23.5 -0.625
        vertex 110.29940795898438 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882916212081909 0.15257658064365387 -3.5993165511172265e-05
    outer loop
        vertex 103.05302429199219 26.0 5.773159728050814e-15
        vertex 111.08097839355469 -26.0 -0.625
        vertex 109.51140594482422 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882921576499939 0.1525733321905136 5.912792235902959e-17
    outer loop
        vertex 109.51140594482422 -15.833333015441895 -0.625
        vertex 109.35702514648438 -14.833333015441895 -5.208700180053711
        vertex 109.35702514648438 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882917404174805 0.15257607400417328 -1.9308458831801545e-06
    outer loop
        vertex 103.95301818847656 20.170421600341797 -5.208700180053711
        vertex 110.18098449707031 -20.170421600341797 -5.208700180053711
        vertex 110.29940795898438 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882921576499939 0.1525733321905136 0.00018707136041484773
    outer loop
        vertex 103.05302429199219 26.0 5.773159728050814e-15
        vertex 109.51140594482422 -15.833333015441895 -0.625
        vertex 109.35702514648438 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882916808128357 0.15257620811462402 -1.429078201908851e-05
    outer loop
        vertex 103.95301818847656 20.170421600341797 -5.208700180053711
        vertex 110.29940795898438 -20.9375 -5.666999816894531
        vertex 103.83458709716797 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882916212081909 0.15257665514945984 -3.555735747795552e-05
    outer loop
        vertex 103.05302429199219 26.0 5.773159728050814e-15
        vertex 109.35702514648438 -14.833333015441895 -0.625
        vertex 108.32779693603516 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9882907271385193 0.15258266031742096 -3.2401628686784534e-06
    outer loop
        vertex 103.59336853027344 22.5 -0.625
        vertex 103.95301818847656 20.170421600341797 -5.208700180053711
        vertex 103.83458709716797 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882921576499939 0.15257325768470764 0.00015470095968339592
    outer loop
        vertex 103.05302429199219 26.0 5.773159728050814e-15
        vertex 108.32779693603516 -8.166666984558105 -0.625
        vertex 108.17341613769531 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9882910251617432 0.15258069336414337 -2.617038717289688e-06
    outer loop
        vertex 103.59336853027344 22.5 -0.625
        vertex 103.83458709716797 20.9375 -5.666999816894531
        vertex 103.43898010253906 23.5 -0.625
    endloop
endfacet
facet normal 0.9882918000221252 0.1525755375623703 3.060924063902348e-05
    outer loop
        vertex 103.05302429199219 26.0 5.773159728050814e-15
        vertex 108.17341613769531 -7.166666507720947 -0.625
        vertex 107.14419555664062 -0.5 -0.625
    endloop
endfacet
facet normal 0.9882910251617432 0.15258069336414337 -2.4128197765094228e-05
    outer loop
        vertex 103.59336853027344 22.5 -0.625
        vertex 103.43898010253906 23.5 -0.625
        vertex 103.05302429199219 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882910251617432 0.15258069336414337 -0.00019302558212075382
    outer loop
        vertex 103.05302429199219 26.0 5.773159728050814e-15
        vertex 107.14419555664062 -0.5 -0.625
        vertex 106.98980712890625 0.5 -0.625
    endloop
endfacet
facet normal 0.9882918000221252 0.1525755375623703 5.469591087603476e-06
    outer loop
        vertex 104.62258911132812 15.833333015441895 -0.625
        vertex 103.59336853027344 22.5 -0.625
        vertex 103.05302429199219 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882918000221252 0.1525755375623703 2.2170184820424765e-05
    outer loop
        vertex 103.05302429199219 26.0 5.773159728050814e-15
        vertex 106.98980712890625 0.5 -0.625
        vertex 105.96058654785156 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9882910251617432 0.15258069336414337 -8.050493488553911e-05
    outer loop
        vertex 104.7769775390625 14.833333015441895 -0.625
        vertex 104.62258911132812 15.833333015441895 -0.625
        vertex 103.05302429199219 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882910251617432 0.1525806188583374 -0.00013457288150675595
    outer loop
        vertex 103.05302429199219 26.0 5.773159728050814e-15
        vertex 105.96058654785156 7.166666507720947 -0.625
        vertex 105.80619812011719 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9882918000221252 0.1525755524635315 1.353614788968116e-05
    outer loop
        vertex 105.80619812011719 8.166666984558105 -0.625
        vertex 104.7769775390625 14.833333015441895 -0.625
        vertex 103.05302429199219 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882921576499939 0.15257325768470764 5.912789588924998e-17
    outer loop
        vertex 108.32779693603516 -8.166666984558105 -0.625
        vertex 108.32779693603516 -8.166666984558105 -5.208700180053711
        vertex 108.17341613769531 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.9882910251617432 0.15258069336414337 3.510890024131501e-17
    outer loop
        vertex 107.14419555664062 -0.5 -0.625
        vertex 107.14419555664062 -0.5 -5.208700180053711
        vertex 106.98980712890625 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.9882910251617432 0.1525806188583374 5.913075462544697e-17
    outer loop
        vertex 105.96058654785156 7.166666507720947 -0.625
        vertex 105.96058654785156 7.166666507720947 -5.208700180053711
        vertex 105.80619812011719 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.9882910251617432 0.15258069336414337 5.913078109522657e-17
    outer loop
        vertex 104.7769775390625 14.833333015441895 -0.625
        vertex 104.7769775390625 14.833333015441895 -5.208700180053711
        vertex 104.62258911132812 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9882921576499939 0.1525733321905136 -1.6138565115397796e-06
    outer loop
        vertex 110.18098449707031 -20.170421600341797 -5.208700180053711
        vertex 110.54063415527344 -22.5 -0.625
        vertex 110.69501495361328 -23.5 -0.625
    endloop
endfacet
facet normal 0.9882919192314148 0.1525748074054718 -0.0
    outer loop
        vertex 103.43898010253906 23.5 -0.625
        vertex 103.05302429199219 26.0 -0.625
        vertex 103.05302429199219 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882917404174805 0.15257616341114044 0.0
    outer loop
        vertex 103.05302429199219 26.0 5.773159728050814e-15
        vertex 111.08097839355469 -26.0 -5.773159728050814e-15
        vertex 111.08097839355469 -26.0 -0.625
    endloop
endfacet
facet normal 0.9882921576499939 0.1525733321905136 5.912792235902959e-17
    outer loop
        vertex 109.51140594482422 -15.833333015441895 -0.625
        vertex 109.51140594482422 -15.833333015441895 -5.208700180053711
        vertex 109.35702514648438 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9882921576499939 0.15257325768470764 2.956394794462499e-17
    outer loop
        vertex 108.32779693603516 -8.166666984558105 -0.625
        vertex 108.17341613769531 -7.166666507720947 -5.208700180053711
        vertex 108.17341613769531 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9882910251617432 0.15258069336414337 3.326106477965525e-17
    outer loop
        vertex 107.14419555664062 -0.5 -0.625
        vertex 106.98980712890625 0.5 -5.208700180053711
        vertex 106.98980712890625 0.5 -0.625
    endloop
endfacet
facet normal 0.9882910251617432 0.1525806188583374 5.913075462544697e-17
    outer loop
        vertex 105.96058654785156 7.166666507720947 -0.625
        vertex 105.80619812011719 8.166666984558105 -5.208700180053711
        vertex 105.80619812011719 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9882910251617432 0.15258069336414337 5.913078109522657e-17
    outer loop
        vertex 104.7769775390625 14.833333015441895 -0.625
        vertex 104.62258911132812 15.833333015441895 -5.208700180053711
        vertex 104.62258911132812 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.98829185962677 0.15257512032985687 -2.860162453544035e-07
    outer loop
        vertex 110.18098449707031 -20.170421600341797 -5.208700180053711
        vertex 110.69501495361328 -23.5 -0.625
        vertex 110.29940795898438 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882916212081909 0.15257658064365387 -3.5993165511172265e-05
    outer loop
        vertex 103.05302429199219 26.0 5.773159728050814e-15
        vertex 111.08097839355469 -26.0 -0.625
        vertex 109.51140594482422 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882921576499939 0.1525733321905136 5.912792235902959e-17
    outer loop
        vertex 109.51140594482422 -15.833333015441895 -0.625
        vertex 109.35702514648438 -14.833333015441895 -5.208700180053711
        vertex 109.35702514648438 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882917404174805 0.15257607400417328 -1.9308458831801545e-06
    outer loop
        vertex 103.95301818847656 20.170421600341797 -5.208700180053711
        vertex 110.18098449707031 -20.170421600341797 -5.208700180053711
        vertex 110.29940795898438 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882921576499939 0.1525733321905136 0.00018707136041484773
    outer loop
        vertex 103.05302429199219 26.0 5.773159728050814e-15
        vertex 109.51140594482422 -15.833333015441895 -0.625
        vertex 109.35702514648438 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882916808128357 0.15257620811462402 -1.429078201908851e-05
    outer loop
        vertex 103.95301818847656 20.170421600341797 -5.208700180053711
        vertex 110.29940795898438 -20.9375 -5.666999816894531
        vertex 103.83458709716797 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882916212081909 0.15257665514945984 -3.555735747795552e-05
    outer loop
        vertex 103.05302429199219 26.0 5.773159728050814e-15
        vertex 109.35702514648438 -14.833333015441895 -0.625
        vertex 108.32779693603516 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9882907271385193 0.15258266031742096 -3.2401628686784534e-06
    outer loop
        vertex 103.59336853027344 22.5 -0.625
        vertex 103.95301818847656 20.170421600341797 -5.208700180053711
        vertex 103.83458709716797 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882921576499939 0.15257325768470764 0.00015470095968339592
    outer loop
        vertex 103.05302429199219 26.0 5.773159728050814e-15
        vertex 108.32779693603516 -8.166666984558105 -0.625
        vertex 108.17341613769531 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9882910251617432 0.15258069336414337 -2.617038717289688e-06
    outer loop
        vertex 103.59336853027344 22.5 -0.625
        vertex 103.83458709716797 20.9375 -5.666999816894531
        vertex 103.43898010253906 23.5 -0.625
    endloop
endfacet
facet normal 0.9882918000221252 0.1525755375623703 3.060924063902348e-05
    outer loop
        vertex 103.05302429199219 26.0 5.773159728050814e-15
        vertex 108.17341613769531 -7.166666507720947 -0.625
        vertex 107.14419555664062 -0.5 -0.625
    endloop
endfacet
facet normal 0.9882910251617432 0.15258069336414337 -2.4128197765094228e-05
    outer loop
        vertex 103.59336853027344 22.5 -0.625
        vertex 103.43898010253906 23.5 -0.625
        vertex 103.05302429199219 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882910251617432 0.15258069336414337 -0.00019302558212075382
    outer loop
        vertex 103.05302429199219 26.0 5.773159728050814e-15
        vertex 107.14419555664062 -0.5 -0.625
        vertex 106.98980712890625 0.5 -0.625
    endloop
endfacet
facet normal 0.9882918000221252 0.1525755375623703 5.469591087603476e-06
    outer loop
        vertex 104.62258911132812 15.833333015441895 -0.625
        vertex 103.59336853027344 22.5 -0.625
        vertex 103.05302429199219 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882918000221252 0.1525755375623703 2.2170184820424765e-05
    outer loop
        vertex 103.05302429199219 26.0 5.773159728050814e-15
        vertex 106.98980712890625 0.5 -0.625
        vertex 105.96058654785156 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9882910251617432 0.15258069336414337 -8.050493488553911e-05
    outer loop
        vertex 104.7769775390625 14.833333015441895 -0.625
        vertex 104.62258911132812 15.833333015441895 -0.625
        vertex 103.05302429199219 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882910251617432 0.1525806188583374 -0.00013457288150675595
    outer loop
        vertex 103.05302429199219 26.0 5.773159728050814e-15
        vertex 105.96058654785156 7.166666507720947 -0.625
        vertex 105.80619812011719 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9882918000221252 0.1525755524635315 1.353614788968116e-05
    outer loop
        vertex 105.80619812011719 8.166666984558105 -0.625
        vertex 104.7769775390625 14.833333015441895 -0.625
        vertex 103.05302429199219 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 -8.166666984558105 -0.625
        vertex 97.33329772949219 -8.166666984558105 -5.208700180053711
        vertex 97.33329772949219 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 -0.5 -0.625
        vertex 97.33329772949219 -0.5 -5.208700180053711
        vertex 97.33329772949219 0.5 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 7.166666507720947 -0.625
        vertex 97.33329772949219 7.166666507720947 -5.208700180053711
        vertex 97.33329772949219 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 14.833333015441895 -0.625
        vertex 97.33329772949219 14.833333015441895 -5.208700180053711
        vertex 97.33329772949219 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 97.33329772949219 -20.170421600341797 -5.208700180053711
        vertex 97.33329772949219 -22.5 -0.625
        vertex 97.33329772949219 -23.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 97.33329772949219 23.5 -0.625
        vertex 97.33329772949219 26.0 -0.625
        vertex 97.33329772949219 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 97.33329772949219 26.0 5.773159728050814e-15
        vertex 97.33329772949219 -26.0 -5.773159728050814e-15
        vertex 97.33329772949219 -26.0 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 -15.833333015441895 -0.625
        vertex 97.33329772949219 -15.833333015441895 -5.208700180053711
        vertex 97.33329772949219 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 97.33329772949219 -8.166666984558105 -0.625
        vertex 97.33329772949219 -7.166666507720947 -5.208700180053711
        vertex 97.33329772949219 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 97.33329772949219 -0.5 -0.625
        vertex 97.33329772949219 0.5 -5.208700180053711
        vertex 97.33329772949219 0.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 97.33329772949219 7.166666507720947 -0.625
        vertex 97.33329772949219 8.166666984558105 -5.208700180053711
        vertex 97.33329772949219 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 97.33329772949219 14.833333015441895 -0.625
        vertex 97.33329772949219 15.833333015441895 -5.208700180053711
        vertex 97.33329772949219 15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 97.33329772949219 -20.170421600341797 -5.208700180053711
        vertex 97.33329772949219 -23.5 -0.625
        vertex 97.33329772949219 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 26.0 5.773159728050814e-15
        vertex 97.33329772949219 -26.0 -0.625
        vertex 97.33329772949219 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 97.33329772949219 -15.833333015441895 -0.625
        vertex 97.33329772949219 -14.833333015441895 -5.208700180053711
        vertex 97.33329772949219 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 97.33329772949219 20.170421600341797 -5.208700180053711
        vertex 97.33329772949219 -20.170421600341797 -5.208700180053711
        vertex 97.33329772949219 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 26.0 5.773159728050814e-15
        vertex 97.33329772949219 -15.833333015441895 -0.625
        vertex 97.33329772949219 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 20.170421600341797 -5.208700180053711
        vertex 97.33329772949219 -20.9375 -5.666999816894531
        vertex 97.33329772949219 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 26.0 5.773159728050814e-15
        vertex 97.33329772949219 -14.833333015441895 -0.625
        vertex 97.33329772949219 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 97.33329772949219 22.5 -0.625
        vertex 97.33329772949219 20.170421600341797 -5.208700180053711
        vertex 97.33329772949219 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 26.0 5.773159728050814e-15
        vertex 97.33329772949219 -8.166666984558105 -0.625
        vertex 97.33329772949219 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 22.5 -0.625
        vertex 97.33329772949219 20.9375 -5.666999816894531
        vertex 97.33329772949219 23.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 26.0 5.773159728050814e-15
        vertex 97.33329772949219 -7.166666507720947 -0.625
        vertex 97.33329772949219 -0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 97.33329772949219 22.5 -0.625
        vertex 97.33329772949219 23.5 -0.625
        vertex 97.33329772949219 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 26.0 5.773159728050814e-15
        vertex 97.33329772949219 -0.5 -0.625
        vertex 97.33329772949219 0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 97.33329772949219 15.833333015441895 -0.625
        vertex 97.33329772949219 22.5 -0.625
        vertex 97.33329772949219 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 26.0 5.773159728050814e-15
        vertex 97.33329772949219 0.5 -0.625
        vertex 97.33329772949219 7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 97.33329772949219 14.833333015441895 -0.625
        vertex 97.33329772949219 15.833333015441895 -0.625
        vertex 97.33329772949219 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 26.0 5.773159728050814e-15
        vertex 97.33329772949219 7.166666507720947 -0.625
        vertex 97.33329772949219 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 97.33329772949219 8.166666984558105 -0.625
        vertex 97.33329772949219 14.833333015441895 -0.625
        vertex 97.33329772949219 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 -8.166666984558105 -0.625
        vertex 97.33329772949219 -8.166666984558105 -5.208700180053711
        vertex 97.33329772949219 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 -0.5 -0.625
        vertex 97.33329772949219 -0.5 -5.208700180053711
        vertex 97.33329772949219 0.5 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 7.166666507720947 -0.625
        vertex 97.33329772949219 7.166666507720947 -5.208700180053711
        vertex 97.33329772949219 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 14.833333015441895 -0.625
        vertex 97.33329772949219 14.833333015441895 -5.208700180053711
        vertex 97.33329772949219 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 97.33329772949219 -20.170421600341797 -5.208700180053711
        vertex 97.33329772949219 -22.5 -0.625
        vertex 97.33329772949219 -23.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 97.33329772949219 23.5 -0.625
        vertex 97.33329772949219 26.0 -0.625
        vertex 97.33329772949219 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 97.33329772949219 26.0 5.773159728050814e-15
        vertex 97.33329772949219 -26.0 -5.773159728050814e-15
        vertex 97.33329772949219 -26.0 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 -15.833333015441895 -0.625
        vertex 97.33329772949219 -15.833333015441895 -5.208700180053711
        vertex 97.33329772949219 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 97.33329772949219 -8.166666984558105 -0.625
        vertex 97.33329772949219 -7.166666507720947 -5.208700180053711
        vertex 97.33329772949219 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 97.33329772949219 -0.5 -0.625
        vertex 97.33329772949219 0.5 -5.208700180053711
        vertex 97.33329772949219 0.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 97.33329772949219 7.166666507720947 -0.625
        vertex 97.33329772949219 8.166666984558105 -5.208700180053711
        vertex 97.33329772949219 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 97.33329772949219 14.833333015441895 -0.625
        vertex 97.33329772949219 15.833333015441895 -5.208700180053711
        vertex 97.33329772949219 15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 97.33329772949219 -20.170421600341797 -5.208700180053711
        vertex 97.33329772949219 -23.5 -0.625
        vertex 97.33329772949219 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 26.0 5.773159728050814e-15
        vertex 97.33329772949219 -26.0 -0.625
        vertex 97.33329772949219 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 97.33329772949219 -15.833333015441895 -0.625
        vertex 97.33329772949219 -14.833333015441895 -5.208700180053711
        vertex 97.33329772949219 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 97.33329772949219 20.170421600341797 -5.208700180053711
        vertex 97.33329772949219 -20.170421600341797 -5.208700180053711
        vertex 97.33329772949219 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 26.0 5.773159728050814e-15
        vertex 97.33329772949219 -15.833333015441895 -0.625
        vertex 97.33329772949219 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 20.170421600341797 -5.208700180053711
        vertex 97.33329772949219 -20.9375 -5.666999816894531
        vertex 97.33329772949219 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 26.0 5.773159728050814e-15
        vertex 97.33329772949219 -14.833333015441895 -0.625
        vertex 97.33329772949219 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 97.33329772949219 22.5 -0.625
        vertex 97.33329772949219 20.170421600341797 -5.208700180053711
        vertex 97.33329772949219 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 26.0 5.773159728050814e-15
        vertex 97.33329772949219 -8.166666984558105 -0.625
        vertex 97.33329772949219 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 22.5 -0.625
        vertex 97.33329772949219 20.9375 -5.666999816894531
        vertex 97.33329772949219 23.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 26.0 5.773159728050814e-15
        vertex 97.33329772949219 -7.166666507720947 -0.625
        vertex 97.33329772949219 -0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 97.33329772949219 22.5 -0.625
        vertex 97.33329772949219 23.5 -0.625
        vertex 97.33329772949219 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 26.0 5.773159728050814e-15
        vertex 97.33329772949219 -0.5 -0.625
        vertex 97.33329772949219 0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 97.33329772949219 15.833333015441895 -0.625
        vertex 97.33329772949219 22.5 -0.625
        vertex 97.33329772949219 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 26.0 5.773159728050814e-15
        vertex 97.33329772949219 0.5 -0.625
        vertex 97.33329772949219 7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 97.33329772949219 14.833333015441895 -0.625
        vertex 97.33329772949219 15.833333015441895 -0.625
        vertex 97.33329772949219 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 97.33329772949219 26.0 5.773159728050814e-15
        vertex 97.33329772949219 7.166666507720947 -0.625
        vertex 97.33329772949219 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 97.33329772949219 8.166666984558105 -0.625
        vertex 97.33329772949219 14.833333015441895 -0.625
        vertex 97.33329772949219 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 -8.166666984558105 -0.625
        vertex 87.5999984741211 -8.166666984558105 -5.208700180053711
        vertex 87.5999984741211 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 -0.5 -0.625
        vertex 87.5999984741211 -0.5 -5.208700180053711
        vertex 87.5999984741211 0.5 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 7.166666507720947 -0.625
        vertex 87.5999984741211 7.166666507720947 -5.208700180053711
        vertex 87.5999984741211 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 14.833333015441895 -0.625
        vertex 87.5999984741211 14.833333015441895 -5.208700180053711
        vertex 87.5999984741211 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 87.5999984741211 -20.170421600341797 -5.208700180053711
        vertex 87.5999984741211 -22.5 -0.625
        vertex 87.5999984741211 -23.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 87.5999984741211 23.5 -0.625
        vertex 87.5999984741211 26.0 -0.625
        vertex 87.5999984741211 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 87.5999984741211 26.0 5.773159728050814e-15
        vertex 87.5999984741211 -26.0 -5.773159728050814e-15
        vertex 87.5999984741211 -26.0 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 -15.833333015441895 -0.625
        vertex 87.5999984741211 -15.833333015441895 -5.208700180053711
        vertex 87.5999984741211 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 87.5999984741211 -8.166666984558105 -0.625
        vertex 87.5999984741211 -7.166666507720947 -5.208700180053711
        vertex 87.5999984741211 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 87.5999984741211 -0.5 -0.625
        vertex 87.5999984741211 0.5 -5.208700180053711
        vertex 87.5999984741211 0.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 87.5999984741211 7.166666507720947 -0.625
        vertex 87.5999984741211 8.166666984558105 -5.208700180053711
        vertex 87.5999984741211 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 87.5999984741211 14.833333015441895 -0.625
        vertex 87.5999984741211 15.833333015441895 -5.208700180053711
        vertex 87.5999984741211 15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 87.5999984741211 -20.170421600341797 -5.208700180053711
        vertex 87.5999984741211 -23.5 -0.625
        vertex 87.5999984741211 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 26.0 5.773159728050814e-15
        vertex 87.5999984741211 -26.0 -0.625
        vertex 87.5999984741211 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 87.5999984741211 -15.833333015441895 -0.625
        vertex 87.5999984741211 -14.833333015441895 -5.208700180053711
        vertex 87.5999984741211 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 87.5999984741211 20.170421600341797 -5.208700180053711
        vertex 87.5999984741211 -20.170421600341797 -5.208700180053711
        vertex 87.5999984741211 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 26.0 5.773159728050814e-15
        vertex 87.5999984741211 -15.833333015441895 -0.625
        vertex 87.5999984741211 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 20.170421600341797 -5.208700180053711
        vertex 87.5999984741211 -20.9375 -5.666999816894531
        vertex 87.5999984741211 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 26.0 5.773159728050814e-15
        vertex 87.5999984741211 -14.833333015441895 -0.625
        vertex 87.5999984741211 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 87.5999984741211 22.5 -0.625
        vertex 87.5999984741211 20.170421600341797 -5.208700180053711
        vertex 87.5999984741211 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 26.0 5.773159728050814e-15
        vertex 87.5999984741211 -8.166666984558105 -0.625
        vertex 87.5999984741211 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 22.5 -0.625
        vertex 87.5999984741211 20.9375 -5.666999816894531
        vertex 87.5999984741211 23.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 26.0 5.773159728050814e-15
        vertex 87.5999984741211 -7.166666507720947 -0.625
        vertex 87.5999984741211 -0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 87.5999984741211 22.5 -0.625
        vertex 87.5999984741211 23.5 -0.625
        vertex 87.5999984741211 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 26.0 5.773159728050814e-15
        vertex 87.5999984741211 -0.5 -0.625
        vertex 87.5999984741211 0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 87.5999984741211 15.833333015441895 -0.625
        vertex 87.5999984741211 22.5 -0.625
        vertex 87.5999984741211 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 26.0 5.773159728050814e-15
        vertex 87.5999984741211 0.5 -0.625
        vertex 87.5999984741211 7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 87.5999984741211 14.833333015441895 -0.625
        vertex 87.5999984741211 15.833333015441895 -0.625
        vertex 87.5999984741211 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 26.0 5.773159728050814e-15
        vertex 87.5999984741211 7.166666507720947 -0.625
        vertex 87.5999984741211 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 87.5999984741211 8.166666984558105 -0.625
        vertex 87.5999984741211 14.833333015441895 -0.625
        vertex 87.5999984741211 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 -8.166666984558105 -0.625
        vertex 87.5999984741211 -8.166666984558105 -5.208700180053711
        vertex 87.5999984741211 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 -0.5 -0.625
        vertex 87.5999984741211 -0.5 -5.208700180053711
        vertex 87.5999984741211 0.5 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 7.166666507720947 -0.625
        vertex 87.5999984741211 7.166666507720947 -5.208700180053711
        vertex 87.5999984741211 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 14.833333015441895 -0.625
        vertex 87.5999984741211 14.833333015441895 -5.208700180053711
        vertex 87.5999984741211 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 87.5999984741211 -20.170421600341797 -5.208700180053711
        vertex 87.5999984741211 -22.5 -0.625
        vertex 87.5999984741211 -23.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 87.5999984741211 23.5 -0.625
        vertex 87.5999984741211 26.0 -0.625
        vertex 87.5999984741211 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 87.5999984741211 26.0 5.773159728050814e-15
        vertex 87.5999984741211 -26.0 -5.773159728050814e-15
        vertex 87.5999984741211 -26.0 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 -15.833333015441895 -0.625
        vertex 87.5999984741211 -15.833333015441895 -5.208700180053711
        vertex 87.5999984741211 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 87.5999984741211 -8.166666984558105 -0.625
        vertex 87.5999984741211 -7.166666507720947 -5.208700180053711
        vertex 87.5999984741211 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 87.5999984741211 -0.5 -0.625
        vertex 87.5999984741211 0.5 -5.208700180053711
        vertex 87.5999984741211 0.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 87.5999984741211 7.166666507720947 -0.625
        vertex 87.5999984741211 8.166666984558105 -5.208700180053711
        vertex 87.5999984741211 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 87.5999984741211 14.833333015441895 -0.625
        vertex 87.5999984741211 15.833333015441895 -5.208700180053711
        vertex 87.5999984741211 15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 87.5999984741211 -20.170421600341797 -5.208700180053711
        vertex 87.5999984741211 -23.5 -0.625
        vertex 87.5999984741211 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 26.0 5.773159728050814e-15
        vertex 87.5999984741211 -26.0 -0.625
        vertex 87.5999984741211 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 87.5999984741211 -15.833333015441895 -0.625
        vertex 87.5999984741211 -14.833333015441895 -5.208700180053711
        vertex 87.5999984741211 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 87.5999984741211 20.170421600341797 -5.208700180053711
        vertex 87.5999984741211 -20.170421600341797 -5.208700180053711
        vertex 87.5999984741211 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 26.0 5.773159728050814e-15
        vertex 87.5999984741211 -15.833333015441895 -0.625
        vertex 87.5999984741211 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 20.170421600341797 -5.208700180053711
        vertex 87.5999984741211 -20.9375 -5.666999816894531
        vertex 87.5999984741211 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 26.0 5.773159728050814e-15
        vertex 87.5999984741211 -14.833333015441895 -0.625
        vertex 87.5999984741211 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 87.5999984741211 22.5 -0.625
        vertex 87.5999984741211 20.170421600341797 -5.208700180053711
        vertex 87.5999984741211 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 26.0 5.773159728050814e-15
        vertex 87.5999984741211 -8.166666984558105 -0.625
        vertex 87.5999984741211 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 22.5 -0.625
        vertex 87.5999984741211 20.9375 -5.666999816894531
        vertex 87.5999984741211 23.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 26.0 5.773159728050814e-15
        vertex 87.5999984741211 -7.166666507720947 -0.625
        vertex 87.5999984741211 -0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 87.5999984741211 22.5 -0.625
        vertex 87.5999984741211 23.5 -0.625
        vertex 87.5999984741211 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 26.0 5.773159728050814e-15
        vertex 87.5999984741211 -0.5 -0.625
        vertex 87.5999984741211 0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 87.5999984741211 15.833333015441895 -0.625
        vertex 87.5999984741211 22.5 -0.625
        vertex 87.5999984741211 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 26.0 5.773159728050814e-15
        vertex 87.5999984741211 0.5 -0.625
        vertex 87.5999984741211 7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 87.5999984741211 14.833333015441895 -0.625
        vertex 87.5999984741211 15.833333015441895 -0.625
        vertex 87.5999984741211 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 87.5999984741211 26.0 5.773159728050814e-15
        vertex 87.5999984741211 7.166666507720947 -0.625
        vertex 87.5999984741211 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 87.5999984741211 8.166666984558105 -0.625
        vertex 87.5999984741211 14.833333015441895 -0.625
        vertex 87.5999984741211 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 -8.166666984558105 -0.625
        vertex 77.86669921875 -8.166666984558105 -5.208700180053711
        vertex 77.86669921875 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 -0.5 -0.625
        vertex 77.86669921875 -0.5 -5.208700180053711
        vertex 77.86669921875 0.5 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 7.166666507720947 -0.625
        vertex 77.86669921875 7.166666507720947 -5.208700180053711
        vertex 77.86669921875 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 14.833333015441895 -0.625
        vertex 77.86669921875 14.833333015441895 -5.208700180053711
        vertex 77.86669921875 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 77.86669921875 -20.170421600341797 -5.208700180053711
        vertex 77.86669921875 -22.5 -0.625
        vertex 77.86669921875 -23.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 77.86669921875 23.5 -0.625
        vertex 77.86669921875 26.0 -0.625
        vertex 77.86669921875 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 77.86669921875 26.0 5.773159728050814e-15
        vertex 77.86669921875 -26.0 -5.773159728050814e-15
        vertex 77.86669921875 -26.0 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 -15.833333015441895 -0.625
        vertex 77.86669921875 -15.833333015441895 -5.208700180053711
        vertex 77.86669921875 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 77.86669921875 -8.166666984558105 -0.625
        vertex 77.86669921875 -7.166666507720947 -5.208700180053711
        vertex 77.86669921875 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 77.86669921875 -0.5 -0.625
        vertex 77.86669921875 0.5 -5.208700180053711
        vertex 77.86669921875 0.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 77.86669921875 7.166666507720947 -0.625
        vertex 77.86669921875 8.166666984558105 -5.208700180053711
        vertex 77.86669921875 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 77.86669921875 14.833333015441895 -0.625
        vertex 77.86669921875 15.833333015441895 -5.208700180053711
        vertex 77.86669921875 15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 77.86669921875 -20.170421600341797 -5.208700180053711
        vertex 77.86669921875 -23.5 -0.625
        vertex 77.86669921875 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 26.0 5.773159728050814e-15
        vertex 77.86669921875 -26.0 -0.625
        vertex 77.86669921875 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 77.86669921875 -15.833333015441895 -0.625
        vertex 77.86669921875 -14.833333015441895 -5.208700180053711
        vertex 77.86669921875 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 77.86669921875 20.170421600341797 -5.208700180053711
        vertex 77.86669921875 -20.170421600341797 -5.208700180053711
        vertex 77.86669921875 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 26.0 5.773159728050814e-15
        vertex 77.86669921875 -15.833333015441895 -0.625
        vertex 77.86669921875 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 20.170421600341797 -5.208700180053711
        vertex 77.86669921875 -20.9375 -5.666999816894531
        vertex 77.86669921875 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 26.0 5.773159728050814e-15
        vertex 77.86669921875 -14.833333015441895 -0.625
        vertex 77.86669921875 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 77.86669921875 22.5 -0.625
        vertex 77.86669921875 20.170421600341797 -5.208700180053711
        vertex 77.86669921875 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 26.0 5.773159728050814e-15
        vertex 77.86669921875 -8.166666984558105 -0.625
        vertex 77.86669921875 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 22.5 -0.625
        vertex 77.86669921875 20.9375 -5.666999816894531
        vertex 77.86669921875 23.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 26.0 5.773159728050814e-15
        vertex 77.86669921875 -7.166666507720947 -0.625
        vertex 77.86669921875 -0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 77.86669921875 22.5 -0.625
        vertex 77.86669921875 23.5 -0.625
        vertex 77.86669921875 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 26.0 5.773159728050814e-15
        vertex 77.86669921875 -0.5 -0.625
        vertex 77.86669921875 0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 77.86669921875 15.833333015441895 -0.625
        vertex 77.86669921875 22.5 -0.625
        vertex 77.86669921875 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 26.0 5.773159728050814e-15
        vertex 77.86669921875 0.5 -0.625
        vertex 77.86669921875 7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 77.86669921875 14.833333015441895 -0.625
        vertex 77.86669921875 15.833333015441895 -0.625
        vertex 77.86669921875 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 26.0 5.773159728050814e-15
        vertex 77.86669921875 7.166666507720947 -0.625
        vertex 77.86669921875 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 77.86669921875 8.166666984558105 -0.625
        vertex 77.86669921875 14.833333015441895 -0.625
        vertex 77.86669921875 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 -8.166666984558105 -0.625
        vertex 77.86669921875 -8.166666984558105 -5.208700180053711
        vertex 77.86669921875 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 -0.5 -0.625
        vertex 77.86669921875 -0.5 -5.208700180053711
        vertex 77.86669921875 0.5 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 7.166666507720947 -0.625
        vertex 77.86669921875 7.166666507720947 -5.208700180053711
        vertex 77.86669921875 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 14.833333015441895 -0.625
        vertex 77.86669921875 14.833333015441895 -5.208700180053711
        vertex 77.86669921875 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 77.86669921875 -20.170421600341797 -5.208700180053711
        vertex 77.86669921875 -22.5 -0.625
        vertex 77.86669921875 -23.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 77.86669921875 23.5 -0.625
        vertex 77.86669921875 26.0 -0.625
        vertex 77.86669921875 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 77.86669921875 26.0 5.773159728050814e-15
        vertex 77.86669921875 -26.0 -5.773159728050814e-15
        vertex 77.86669921875 -26.0 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 -15.833333015441895 -0.625
        vertex 77.86669921875 -15.833333015441895 -5.208700180053711
        vertex 77.86669921875 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 77.86669921875 -8.166666984558105 -0.625
        vertex 77.86669921875 -7.166666507720947 -5.208700180053711
        vertex 77.86669921875 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 77.86669921875 -0.5 -0.625
        vertex 77.86669921875 0.5 -5.208700180053711
        vertex 77.86669921875 0.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 77.86669921875 7.166666507720947 -0.625
        vertex 77.86669921875 8.166666984558105 -5.208700180053711
        vertex 77.86669921875 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 77.86669921875 14.833333015441895 -0.625
        vertex 77.86669921875 15.833333015441895 -5.208700180053711
        vertex 77.86669921875 15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 77.86669921875 -20.170421600341797 -5.208700180053711
        vertex 77.86669921875 -23.5 -0.625
        vertex 77.86669921875 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 26.0 5.773159728050814e-15
        vertex 77.86669921875 -26.0 -0.625
        vertex 77.86669921875 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 77.86669921875 -15.833333015441895 -0.625
        vertex 77.86669921875 -14.833333015441895 -5.208700180053711
        vertex 77.86669921875 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 77.86669921875 20.170421600341797 -5.208700180053711
        vertex 77.86669921875 -20.170421600341797 -5.208700180053711
        vertex 77.86669921875 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 26.0 5.773159728050814e-15
        vertex 77.86669921875 -15.833333015441895 -0.625
        vertex 77.86669921875 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 20.170421600341797 -5.208700180053711
        vertex 77.86669921875 -20.9375 -5.666999816894531
        vertex 77.86669921875 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 26.0 5.773159728050814e-15
        vertex 77.86669921875 -14.833333015441895 -0.625
        vertex 77.86669921875 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 77.86669921875 22.5 -0.625
        vertex 77.86669921875 20.170421600341797 -5.208700180053711
        vertex 77.86669921875 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 26.0 5.773159728050814e-15
        vertex 77.86669921875 -8.166666984558105 -0.625
        vertex 77.86669921875 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 22.5 -0.625
        vertex 77.86669921875 20.9375 -5.666999816894531
        vertex 77.86669921875 23.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 26.0 5.773159728050814e-15
        vertex 77.86669921875 -7.166666507720947 -0.625
        vertex 77.86669921875 -0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 77.86669921875 22.5 -0.625
        vertex 77.86669921875 23.5 -0.625
        vertex 77.86669921875 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 26.0 5.773159728050814e-15
        vertex 77.86669921875 -0.5 -0.625
        vertex 77.86669921875 0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 77.86669921875 15.833333015441895 -0.625
        vertex 77.86669921875 22.5 -0.625
        vertex 77.86669921875 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 26.0 5.773159728050814e-15
        vertex 77.86669921875 0.5 -0.625
        vertex 77.86669921875 7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 77.86669921875 14.833333015441895 -0.625
        vertex 77.86669921875 15.833333015441895 -0.625
        vertex 77.86669921875 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 77.86669921875 26.0 5.773159728050814e-15
        vertex 77.86669921875 7.166666507720947 -0.625
        vertex 77.86669921875 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 77.86669921875 8.166666984558105 -0.625
        vertex 77.86669921875 14.833333015441895 -0.625
        vertex 77.86669921875 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 -8.166666984558105 -0.625
        vertex 68.13330078125 -8.166666984558105 -5.208700180053711
        vertex 68.13330078125 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 -0.5 -0.625
        vertex 68.13330078125 -0.5 -5.208700180053711
        vertex 68.13330078125 0.5 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 7.166666507720947 -0.625
        vertex 68.13330078125 7.166666507720947 -5.208700180053711
        vertex 68.13330078125 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 14.833333015441895 -0.625
        vertex 68.13330078125 14.833333015441895 -5.208700180053711
        vertex 68.13330078125 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 68.13330078125 -20.170421600341797 -5.208700180053711
        vertex 68.13330078125 -22.5 -0.625
        vertex 68.13330078125 -23.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 68.13330078125 23.5 -0.625
        vertex 68.13330078125 26.0 -0.625
        vertex 68.13330078125 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 68.13330078125 26.0 5.773159728050814e-15
        vertex 68.13330078125 -26.0 -5.773159728050814e-15
        vertex 68.13330078125 -26.0 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 -15.833333015441895 -0.625
        vertex 68.13330078125 -15.833333015441895 -5.208700180053711
        vertex 68.13330078125 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 68.13330078125 -8.166666984558105 -0.625
        vertex 68.13330078125 -7.166666507720947 -5.208700180053711
        vertex 68.13330078125 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 68.13330078125 -0.5 -0.625
        vertex 68.13330078125 0.5 -5.208700180053711
        vertex 68.13330078125 0.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 68.13330078125 7.166666507720947 -0.625
        vertex 68.13330078125 8.166666984558105 -5.208700180053711
        vertex 68.13330078125 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 68.13330078125 14.833333015441895 -0.625
        vertex 68.13330078125 15.833333015441895 -5.208700180053711
        vertex 68.13330078125 15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 68.13330078125 -20.170421600341797 -5.208700180053711
        vertex 68.13330078125 -23.5 -0.625
        vertex 68.13330078125 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 26.0 5.773159728050814e-15
        vertex 68.13330078125 -26.0 -0.625
        vertex 68.13330078125 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 68.13330078125 -15.833333015441895 -0.625
        vertex 68.13330078125 -14.833333015441895 -5.208700180053711
        vertex 68.13330078125 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 68.13330078125 20.170421600341797 -5.208700180053711
        vertex 68.13330078125 -20.170421600341797 -5.208700180053711
        vertex 68.13330078125 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 26.0 5.773159728050814e-15
        vertex 68.13330078125 -15.833333015441895 -0.625
        vertex 68.13330078125 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 20.170421600341797 -5.208700180053711
        vertex 68.13330078125 -20.9375 -5.666999816894531
        vertex 68.13330078125 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 26.0 5.773159728050814e-15
        vertex 68.13330078125 -14.833333015441895 -0.625
        vertex 68.13330078125 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 68.13330078125 22.5 -0.625
        vertex 68.13330078125 20.170421600341797 -5.208700180053711
        vertex 68.13330078125 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 26.0 5.773159728050814e-15
        vertex 68.13330078125 -8.166666984558105 -0.625
        vertex 68.13330078125 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 22.5 -0.625
        vertex 68.13330078125 20.9375 -5.666999816894531
        vertex 68.13330078125 23.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 26.0 5.773159728050814e-15
        vertex 68.13330078125 -7.166666507720947 -0.625
        vertex 68.13330078125 -0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 68.13330078125 22.5 -0.625
        vertex 68.13330078125 23.5 -0.625
        vertex 68.13330078125 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 26.0 5.773159728050814e-15
        vertex 68.13330078125 -0.5 -0.625
        vertex 68.13330078125 0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 68.13330078125 15.833333015441895 -0.625
        vertex 68.13330078125 22.5 -0.625
        vertex 68.13330078125 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 26.0 5.773159728050814e-15
        vertex 68.13330078125 0.5 -0.625
        vertex 68.13330078125 7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 68.13330078125 14.833333015441895 -0.625
        vertex 68.13330078125 15.833333015441895 -0.625
        vertex 68.13330078125 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 26.0 5.773159728050814e-15
        vertex 68.13330078125 7.166666507720947 -0.625
        vertex 68.13330078125 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 68.13330078125 8.166666984558105 -0.625
        vertex 68.13330078125 14.833333015441895 -0.625
        vertex 68.13330078125 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 -8.166666984558105 -0.625
        vertex 68.13330078125 -8.166666984558105 -5.208700180053711
        vertex 68.13330078125 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 -0.5 -0.625
        vertex 68.13330078125 -0.5 -5.208700180053711
        vertex 68.13330078125 0.5 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 7.166666507720947 -0.625
        vertex 68.13330078125 7.166666507720947 -5.208700180053711
        vertex 68.13330078125 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 14.833333015441895 -0.625
        vertex 68.13330078125 14.833333015441895 -5.208700180053711
        vertex 68.13330078125 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 68.13330078125 -20.170421600341797 -5.208700180053711
        vertex 68.13330078125 -22.5 -0.625
        vertex 68.13330078125 -23.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 68.13330078125 23.5 -0.625
        vertex 68.13330078125 26.0 -0.625
        vertex 68.13330078125 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 68.13330078125 26.0 5.773159728050814e-15
        vertex 68.13330078125 -26.0 -5.773159728050814e-15
        vertex 68.13330078125 -26.0 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 -15.833333015441895 -0.625
        vertex 68.13330078125 -15.833333015441895 -5.208700180053711
        vertex 68.13330078125 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 68.13330078125 -8.166666984558105 -0.625
        vertex 68.13330078125 -7.166666507720947 -5.208700180053711
        vertex 68.13330078125 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 68.13330078125 -0.5 -0.625
        vertex 68.13330078125 0.5 -5.208700180053711
        vertex 68.13330078125 0.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 68.13330078125 7.166666507720947 -0.625
        vertex 68.13330078125 8.166666984558105 -5.208700180053711
        vertex 68.13330078125 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 68.13330078125 14.833333015441895 -0.625
        vertex 68.13330078125 15.833333015441895 -5.208700180053711
        vertex 68.13330078125 15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 68.13330078125 -20.170421600341797 -5.208700180053711
        vertex 68.13330078125 -23.5 -0.625
        vertex 68.13330078125 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 26.0 5.773159728050814e-15
        vertex 68.13330078125 -26.0 -0.625
        vertex 68.13330078125 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 68.13330078125 -15.833333015441895 -0.625
        vertex 68.13330078125 -14.833333015441895 -5.208700180053711
        vertex 68.13330078125 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 68.13330078125 20.170421600341797 -5.208700180053711
        vertex 68.13330078125 -20.170421600341797 -5.208700180053711
        vertex 68.13330078125 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 26.0 5.773159728050814e-15
        vertex 68.13330078125 -15.833333015441895 -0.625
        vertex 68.13330078125 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 20.170421600341797 -5.208700180053711
        vertex 68.13330078125 -20.9375 -5.666999816894531
        vertex 68.13330078125 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 26.0 5.773159728050814e-15
        vertex 68.13330078125 -14.833333015441895 -0.625
        vertex 68.13330078125 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 68.13330078125 22.5 -0.625
        vertex 68.13330078125 20.170421600341797 -5.208700180053711
        vertex 68.13330078125 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 26.0 5.773159728050814e-15
        vertex 68.13330078125 -8.166666984558105 -0.625
        vertex 68.13330078125 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 22.5 -0.625
        vertex 68.13330078125 20.9375 -5.666999816894531
        vertex 68.13330078125 23.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 26.0 5.773159728050814e-15
        vertex 68.13330078125 -7.166666507720947 -0.625
        vertex 68.13330078125 -0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 68.13330078125 22.5 -0.625
        vertex 68.13330078125 23.5 -0.625
        vertex 68.13330078125 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 26.0 5.773159728050814e-15
        vertex 68.13330078125 -0.5 -0.625
        vertex 68.13330078125 0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 68.13330078125 15.833333015441895 -0.625
        vertex 68.13330078125 22.5 -0.625
        vertex 68.13330078125 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 26.0 5.773159728050814e-15
        vertex 68.13330078125 0.5 -0.625
        vertex 68.13330078125 7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 68.13330078125 14.833333015441895 -0.625
        vertex 68.13330078125 15.833333015441895 -0.625
        vertex 68.13330078125 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 68.13330078125 26.0 5.773159728050814e-15
        vertex 68.13330078125 7.166666507720947 -0.625
        vertex 68.13330078125 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 68.13330078125 8.166666984558105 -0.625
        vertex 68.13330078125 14.833333015441895 -0.625
        vertex 68.13330078125 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 -8.166666984558105 -0.625
        vertex 58.400001525878906 -8.166666984558105 -5.208700180053711
        vertex 58.400001525878906 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 -0.5 -0.625
        vertex 58.400001525878906 -0.5 -5.208700180053711
        vertex 58.400001525878906 0.5 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 7.166666507720947 -0.625
        vertex 58.400001525878906 7.166666507720947 -5.208700180053711
        vertex 58.400001525878906 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 14.833333015441895 -0.625
        vertex 58.400001525878906 14.833333015441895 -5.208700180053711
        vertex 58.400001525878906 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 58.400001525878906 -20.170421600341797 -5.208700180053711
        vertex 58.400001525878906 -22.5 -0.625
        vertex 58.400001525878906 -23.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 58.400001525878906 23.5 -0.625
        vertex 58.400001525878906 26.0 -0.625
        vertex 58.400001525878906 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 58.400001525878906 26.0 5.773159728050814e-15
        vertex 58.400001525878906 -26.0 -5.773159728050814e-15
        vertex 58.400001525878906 -26.0 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 -15.833333015441895 -0.625
        vertex 58.400001525878906 -15.833333015441895 -5.208700180053711
        vertex 58.400001525878906 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 58.400001525878906 -8.166666984558105 -0.625
        vertex 58.400001525878906 -7.166666507720947 -5.208700180053711
        vertex 58.400001525878906 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 58.400001525878906 -0.5 -0.625
        vertex 58.400001525878906 0.5 -5.208700180053711
        vertex 58.400001525878906 0.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 58.400001525878906 7.166666507720947 -0.625
        vertex 58.400001525878906 8.166666984558105 -5.208700180053711
        vertex 58.400001525878906 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 58.400001525878906 14.833333015441895 -0.625
        vertex 58.400001525878906 15.833333015441895 -5.208700180053711
        vertex 58.400001525878906 15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 58.400001525878906 -20.170421600341797 -5.208700180053711
        vertex 58.400001525878906 -23.5 -0.625
        vertex 58.400001525878906 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 26.0 5.773159728050814e-15
        vertex 58.400001525878906 -26.0 -0.625
        vertex 58.400001525878906 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 58.400001525878906 -15.833333015441895 -0.625
        vertex 58.400001525878906 -14.833333015441895 -5.208700180053711
        vertex 58.400001525878906 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 58.400001525878906 20.170421600341797 -5.208700180053711
        vertex 58.400001525878906 -20.170421600341797 -5.208700180053711
        vertex 58.400001525878906 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 26.0 5.773159728050814e-15
        vertex 58.400001525878906 -15.833333015441895 -0.625
        vertex 58.400001525878906 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 20.170421600341797 -5.208700180053711
        vertex 58.400001525878906 -20.9375 -5.666999816894531
        vertex 58.400001525878906 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 26.0 5.773159728050814e-15
        vertex 58.400001525878906 -14.833333015441895 -0.625
        vertex 58.400001525878906 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 58.400001525878906 22.5 -0.625
        vertex 58.400001525878906 20.170421600341797 -5.208700180053711
        vertex 58.400001525878906 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 26.0 5.773159728050814e-15
        vertex 58.400001525878906 -8.166666984558105 -0.625
        vertex 58.400001525878906 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 22.5 -0.625
        vertex 58.400001525878906 20.9375 -5.666999816894531
        vertex 58.400001525878906 23.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 26.0 5.773159728050814e-15
        vertex 58.400001525878906 -7.166666507720947 -0.625
        vertex 58.400001525878906 -0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 58.400001525878906 22.5 -0.625
        vertex 58.400001525878906 23.5 -0.625
        vertex 58.400001525878906 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 26.0 5.773159728050814e-15
        vertex 58.400001525878906 -0.5 -0.625
        vertex 58.400001525878906 0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 58.400001525878906 15.833333015441895 -0.625
        vertex 58.400001525878906 22.5 -0.625
        vertex 58.400001525878906 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 26.0 5.773159728050814e-15
        vertex 58.400001525878906 0.5 -0.625
        vertex 58.400001525878906 7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 58.400001525878906 14.833333015441895 -0.625
        vertex 58.400001525878906 15.833333015441895 -0.625
        vertex 58.400001525878906 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 26.0 5.773159728050814e-15
        vertex 58.400001525878906 7.166666507720947 -0.625
        vertex 58.400001525878906 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 58.400001525878906 8.166666984558105 -0.625
        vertex 58.400001525878906 14.833333015441895 -0.625
        vertex 58.400001525878906 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 -8.166666984558105 -0.625
        vertex 58.400001525878906 -8.166666984558105 -5.208700180053711
        vertex 58.400001525878906 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 -0.5 -0.625
        vertex 58.400001525878906 -0.5 -5.208700180053711
        vertex 58.400001525878906 0.5 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 7.166666507720947 -0.625
        vertex 58.400001525878906 7.166666507720947 -5.208700180053711
        vertex 58.400001525878906 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 14.833333015441895 -0.625
        vertex 58.400001525878906 14.833333015441895 -5.208700180053711
        vertex 58.400001525878906 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 58.400001525878906 -20.170421600341797 -5.208700180053711
        vertex 58.400001525878906 -22.5 -0.625
        vertex 58.400001525878906 -23.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 58.400001525878906 23.5 -0.625
        vertex 58.400001525878906 26.0 -0.625
        vertex 58.400001525878906 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 58.400001525878906 26.0 5.773159728050814e-15
        vertex 58.400001525878906 -26.0 -5.773159728050814e-15
        vertex 58.400001525878906 -26.0 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 -15.833333015441895 -0.625
        vertex 58.400001525878906 -15.833333015441895 -5.208700180053711
        vertex 58.400001525878906 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 58.400001525878906 -8.166666984558105 -0.625
        vertex 58.400001525878906 -7.166666507720947 -5.208700180053711
        vertex 58.400001525878906 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 58.400001525878906 -0.5 -0.625
        vertex 58.400001525878906 0.5 -5.208700180053711
        vertex 58.400001525878906 0.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 58.400001525878906 7.166666507720947 -0.625
        vertex 58.400001525878906 8.166666984558105 -5.208700180053711
        vertex 58.400001525878906 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 58.400001525878906 14.833333015441895 -0.625
        vertex 58.400001525878906 15.833333015441895 -5.208700180053711
        vertex 58.400001525878906 15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 58.400001525878906 -20.170421600341797 -5.208700180053711
        vertex 58.400001525878906 -23.5 -0.625
        vertex 58.400001525878906 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 26.0 5.773159728050814e-15
        vertex 58.400001525878906 -26.0 -0.625
        vertex 58.400001525878906 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 58.400001525878906 -15.833333015441895 -0.625
        vertex 58.400001525878906 -14.833333015441895 -5.208700180053711
        vertex 58.400001525878906 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 58.400001525878906 20.170421600341797 -5.208700180053711
        vertex 58.400001525878906 -20.170421600341797 -5.208700180053711
        vertex 58.400001525878906 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 26.0 5.773159728050814e-15
        vertex 58.400001525878906 -15.833333015441895 -0.625
        vertex 58.400001525878906 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 20.170421600341797 -5.208700180053711
        vertex 58.400001525878906 -20.9375 -5.666999816894531
        vertex 58.400001525878906 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 26.0 5.773159728050814e-15
        vertex 58.400001525878906 -14.833333015441895 -0.625
        vertex 58.400001525878906 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 58.400001525878906 22.5 -0.625
        vertex 58.400001525878906 20.170421600341797 -5.208700180053711
        vertex 58.400001525878906 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 26.0 5.773159728050814e-15
        vertex 58.400001525878906 -8.166666984558105 -0.625
        vertex 58.400001525878906 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 22.5 -0.625
        vertex 58.400001525878906 20.9375 -5.666999816894531
        vertex 58.400001525878906 23.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 26.0 5.773159728050814e-15
        vertex 58.400001525878906 -7.166666507720947 -0.625
        vertex 58.400001525878906 -0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 58.400001525878906 22.5 -0.625
        vertex 58.400001525878906 23.5 -0.625
        vertex 58.400001525878906 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 26.0 5.773159728050814e-15
        vertex 58.400001525878906 -0.5 -0.625
        vertex 58.400001525878906 0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 58.400001525878906 15.833333015441895 -0.625
        vertex 58.400001525878906 22.5 -0.625
        vertex 58.400001525878906 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 26.0 5.773159728050814e-15
        vertex 58.400001525878906 0.5 -0.625
        vertex 58.400001525878906 7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 58.400001525878906 14.833333015441895 -0.625
        vertex 58.400001525878906 15.833333015441895 -0.625
        vertex 58.400001525878906 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 58.400001525878906 26.0 5.773159728050814e-15
        vertex 58.400001525878906 7.166666507720947 -0.625
        vertex 58.400001525878906 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 58.400001525878906 8.166666984558105 -0.625
        vertex 58.400001525878906 14.833333015441895 -0.625
        vertex 58.400001525878906 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 -8.166666984558105 -0.625
        vertex 48.66669845581055 -8.166666984558105 -5.208700180053711
        vertex 48.66669845581055 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 -0.5 -0.625
        vertex 48.66669845581055 -0.5 -5.208700180053711
        vertex 48.66669845581055 0.5 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 7.166666507720947 -0.625
        vertex 48.66669845581055 7.166666507720947 -5.208700180053711
        vertex 48.66669845581055 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 14.833333015441895 -0.625
        vertex 48.66669845581055 14.833333015441895 -5.208700180053711
        vertex 48.66669845581055 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 48.66669845581055 -20.170421600341797 -5.208700180053711
        vertex 48.66669845581055 -22.5 -0.625
        vertex 48.66669845581055 -23.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 48.66669845581055 23.5 -0.625
        vertex 48.66669845581055 26.0 -0.625
        vertex 48.66669845581055 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 48.66669845581055 26.0 5.773159728050814e-15
        vertex 48.66669845581055 -26.0 -5.773159728050814e-15
        vertex 48.66669845581055 -26.0 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 -15.833333015441895 -0.625
        vertex 48.66669845581055 -15.833333015441895 -5.208700180053711
        vertex 48.66669845581055 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 48.66669845581055 -8.166666984558105 -0.625
        vertex 48.66669845581055 -7.166666507720947 -5.208700180053711
        vertex 48.66669845581055 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 48.66669845581055 -0.5 -0.625
        vertex 48.66669845581055 0.5 -5.208700180053711
        vertex 48.66669845581055 0.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 48.66669845581055 7.166666507720947 -0.625
        vertex 48.66669845581055 8.166666984558105 -5.208700180053711
        vertex 48.66669845581055 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 48.66669845581055 14.833333015441895 -0.625
        vertex 48.66669845581055 15.833333015441895 -5.208700180053711
        vertex 48.66669845581055 15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 48.66669845581055 -20.170421600341797 -5.208700180053711
        vertex 48.66669845581055 -23.5 -0.625
        vertex 48.66669845581055 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 26.0 5.773159728050814e-15
        vertex 48.66669845581055 -26.0 -0.625
        vertex 48.66669845581055 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 48.66669845581055 -15.833333015441895 -0.625
        vertex 48.66669845581055 -14.833333015441895 -5.208700180053711
        vertex 48.66669845581055 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 48.66669845581055 20.170421600341797 -5.208700180053711
        vertex 48.66669845581055 -20.170421600341797 -5.208700180053711
        vertex 48.66669845581055 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 26.0 5.773159728050814e-15
        vertex 48.66669845581055 -15.833333015441895 -0.625
        vertex 48.66669845581055 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 20.170421600341797 -5.208700180053711
        vertex 48.66669845581055 -20.9375 -5.666999816894531
        vertex 48.66669845581055 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 26.0 5.773159728050814e-15
        vertex 48.66669845581055 -14.833333015441895 -0.625
        vertex 48.66669845581055 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 48.66669845581055 22.5 -0.625
        vertex 48.66669845581055 20.170421600341797 -5.208700180053711
        vertex 48.66669845581055 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 26.0 5.773159728050814e-15
        vertex 48.66669845581055 -8.166666984558105 -0.625
        vertex 48.66669845581055 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 22.5 -0.625
        vertex 48.66669845581055 20.9375 -5.666999816894531
        vertex 48.66669845581055 23.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 26.0 5.773159728050814e-15
        vertex 48.66669845581055 -7.166666507720947 -0.625
        vertex 48.66669845581055 -0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 48.66669845581055 22.5 -0.625
        vertex 48.66669845581055 23.5 -0.625
        vertex 48.66669845581055 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 26.0 5.773159728050814e-15
        vertex 48.66669845581055 -0.5 -0.625
        vertex 48.66669845581055 0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 48.66669845581055 15.833333015441895 -0.625
        vertex 48.66669845581055 22.5 -0.625
        vertex 48.66669845581055 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 26.0 5.773159728050814e-15
        vertex 48.66669845581055 0.5 -0.625
        vertex 48.66669845581055 7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 48.66669845581055 14.833333015441895 -0.625
        vertex 48.66669845581055 15.833333015441895 -0.625
        vertex 48.66669845581055 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 26.0 5.773159728050814e-15
        vertex 48.66669845581055 7.166666507720947 -0.625
        vertex 48.66669845581055 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 48.66669845581055 8.166666984558105 -0.625
        vertex 48.66669845581055 14.833333015441895 -0.625
        vertex 48.66669845581055 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 -8.166666984558105 -0.625
        vertex 48.66669845581055 -8.166666984558105 -5.208700180053711
        vertex 48.66669845581055 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 -0.5 -0.625
        vertex 48.66669845581055 -0.5 -5.208700180053711
        vertex 48.66669845581055 0.5 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 7.166666507720947 -0.625
        vertex 48.66669845581055 7.166666507720947 -5.208700180053711
        vertex 48.66669845581055 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 14.833333015441895 -0.625
        vertex 48.66669845581055 14.833333015441895 -5.208700180053711
        vertex 48.66669845581055 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 48.66669845581055 -20.170421600341797 -5.208700180053711
        vertex 48.66669845581055 -22.5 -0.625
        vertex 48.66669845581055 -23.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 48.66669845581055 23.5 -0.625
        vertex 48.66669845581055 26.0 -0.625
        vertex 48.66669845581055 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 48.66669845581055 26.0 5.773159728050814e-15
        vertex 48.66669845581055 -26.0 -5.773159728050814e-15
        vertex 48.66669845581055 -26.0 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 -15.833333015441895 -0.625
        vertex 48.66669845581055 -15.833333015441895 -5.208700180053711
        vertex 48.66669845581055 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 48.66669845581055 -8.166666984558105 -0.625
        vertex 48.66669845581055 -7.166666507720947 -5.208700180053711
        vertex 48.66669845581055 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 48.66669845581055 -0.5 -0.625
        vertex 48.66669845581055 0.5 -5.208700180053711
        vertex 48.66669845581055 0.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 48.66669845581055 7.166666507720947 -0.625
        vertex 48.66669845581055 8.166666984558105 -5.208700180053711
        vertex 48.66669845581055 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 48.66669845581055 14.833333015441895 -0.625
        vertex 48.66669845581055 15.833333015441895 -5.208700180053711
        vertex 48.66669845581055 15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 48.66669845581055 -20.170421600341797 -5.208700180053711
        vertex 48.66669845581055 -23.5 -0.625
        vertex 48.66669845581055 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 26.0 5.773159728050814e-15
        vertex 48.66669845581055 -26.0 -0.625
        vertex 48.66669845581055 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 -0.0
    outer loop
        vertex 48.66669845581055 -15.833333015441895 -0.625
        vertex 48.66669845581055 -14.833333015441895 -5.208700180053711
        vertex 48.66669845581055 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 48.66669845581055 20.170421600341797 -5.208700180053711
        vertex 48.66669845581055 -20.170421600341797 -5.208700180053711
        vertex 48.66669845581055 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 26.0 5.773159728050814e-15
        vertex 48.66669845581055 -15.833333015441895 -0.625
        vertex 48.66669845581055 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 20.170421600341797 -5.208700180053711
        vertex 48.66669845581055 -20.9375 -5.666999816894531
        vertex 48.66669845581055 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 26.0 5.773159728050814e-15
        vertex 48.66669845581055 -14.833333015441895 -0.625
        vertex 48.66669845581055 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 48.66669845581055 22.5 -0.625
        vertex 48.66669845581055 20.170421600341797 -5.208700180053711
        vertex 48.66669845581055 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 26.0 5.773159728050814e-15
        vertex 48.66669845581055 -8.166666984558105 -0.625
        vertex 48.66669845581055 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 22.5 -0.625
        vertex 48.66669845581055 20.9375 -5.666999816894531
        vertex 48.66669845581055 23.5 -0.625
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 26.0 5.773159728050814e-15
        vertex 48.66669845581055 -7.166666507720947 -0.625
        vertex 48.66669845581055 -0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 48.66669845581055 22.5 -0.625
        vertex 48.66669845581055 23.5 -0.625
        vertex 48.66669845581055 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 26.0 5.773159728050814e-15
        vertex 48.66669845581055 -0.5 -0.625
        vertex 48.66669845581055 0.5 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 48.66669845581055 15.833333015441895 -0.625
        vertex 48.66669845581055 22.5 -0.625
        vertex 48.66669845581055 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 26.0 5.773159728050814e-15
        vertex 48.66669845581055 0.5 -0.625
        vertex 48.66669845581055 7.166666507720947 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 48.66669845581055 14.833333015441895 -0.625
        vertex 48.66669845581055 15.833333015441895 -0.625
        vertex 48.66669845581055 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 1.0 -0.0 0.0
    outer loop
        vertex 48.66669845581055 26.0 5.773159728050814e-15
        vertex 48.66669845581055 7.166666507720947 -0.625
        vertex 48.66669845581055 8.166666984558105 -0.625
    endloop
endfacet
facet normal 1.0 0.0 0.0
    outer loop
        vertex 48.66669845581055 8.166666984558105 -0.625
        vertex 48.66669845581055 14.833333015441895 -0.625
        vertex 48.66669845581055 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882921576499939 0.15257325768470764 5.912789588924998e-17
    outer loop
        vertex 40.19409942626953 -8.166666984558105 -0.625
        vertex 40.19409942626953 -8.166666984558105 -5.208700180053711
        vertex 40.03971862792969 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.9882921576499939 0.1525733321905136 3.51072061754205e-17
    outer loop
        vertex 39.01049041748047 -0.5 -0.625
        vertex 39.01049041748047 -0.5 -5.208700180053711
        vertex 38.856109619140625 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.9882921576499939 0.15257325768470764 5.912789588924998e-17
    outer loop
        vertex 37.826881408691406 7.166666507720947 -0.625
        vertex 37.826881408691406 7.166666507720947 -5.208700180053711
        vertex 37.67250061035156 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.9882915616035461 0.1525770127773285 5.912935172712808e-17
    outer loop
        vertex 36.64327621459961 14.833333015441895 -0.625
        vertex 36.64327621459961 14.833333015441895 -5.208700180053711
        vertex 36.4888916015625 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9882915616035461 0.1525770127773285 1.1246788744756486e-06
    outer loop
        vertex 42.04728698730469 -20.170421600341797 -5.208700180053711
        vertex 42.40693283081055 -22.5 -0.625
        vertex 42.561317443847656 -23.5 -0.625
    endloop
endfacet
facet normal 0.9882916808128357 0.15257628262043 -0.0
    outer loop
        vertex 35.30528259277344 23.5 -0.625
        vertex 34.9193229675293 26.0 -0.625
        vertex 34.9193229675293 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882917404174805 0.15257616341114044 0.0
    outer loop
        vertex 34.9193229675293 26.0 5.773159728050814e-15
        vertex 42.9472770690918 -26.0 -5.773159728050814e-15
        vertex 42.9472770690918 -26.0 -0.625
    endloop
endfacet
facet normal 0.9882915616035461 0.1525770127773285 5.912935172712808e-17
    outer loop
        vertex 41.377708435058594 -15.833333015441895 -0.625
        vertex 41.377708435058594 -15.833333015441895 -5.208700180053711
        vertex 41.223323822021484 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9882921576499939 0.15257325768470764 2.956394794462499e-17
    outer loop
        vertex 40.19409942626953 -8.166666984558105 -0.625
        vertex 40.03971862792969 -7.166666507720947 -5.208700180053711
        vertex 40.03971862792969 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9882921576499939 0.1525733321905136 3.325945674054445e-17
    outer loop
        vertex 39.01049041748047 -0.5 -0.625
        vertex 38.856109619140625 0.5 -5.208700180053711
        vertex 38.856109619140625 0.5 -0.625
    endloop
endfacet
facet normal 0.9882921576499939 0.15257325768470764 5.912789588924998e-17
    outer loop
        vertex 37.826881408691406 7.166666507720947 -0.625
        vertex 37.67250061035156 8.166666984558105 -5.208700180053711
        vertex 37.67250061035156 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9882915616035461 0.1525770127773285 5.912935172712808e-17
    outer loop
        vertex 36.64327621459961 14.833333015441895 -0.625
        vertex 36.4888916015625 15.833333015441895 -5.208700180053711
        vertex 36.4888916015625 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.98829185962677 0.15257512032985687 -2.860162453544035e-07
    outer loop
        vertex 42.04728698730469 -20.170421600341797 -5.208700180053711
        vertex 42.561317443847656 -23.5 -0.625
        vertex 42.16571044921875 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882916808128357 0.15257622301578522 -5.140696430316893e-06
    outer loop
        vertex 34.9193229675293 26.0 5.773159728050814e-15
        vertex 42.9472770690918 -26.0 -0.625
        vertex 41.377708435058594 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882915616035461 0.1525770127773285 5.912935172712808e-17
    outer loop
        vertex 41.377708435058594 -15.833333015441895 -0.625
        vertex 41.223323822021484 -14.833333015441895 -5.208700180053711
        vertex 41.223323822021484 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882916808128357 0.1525762528181076 -2.243684548375313e-06
    outer loop
        vertex 35.819313049316406 20.170421600341797 -5.208700180053711
        vertex 42.04728698730469 -20.170421600341797 -5.208700180053711
        vertex 42.16571044921875 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882915616035461 0.1525770127773285 -5.923758362769149e-05
    outer loop
        vertex 34.9193229675293 26.0 5.773159728050814e-15
        vertex 41.377708435058594 -15.833333015441895 -0.625
        vertex 41.223323822021484 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882916808128357 0.15257620811462402 2.161483507734374e-06
    outer loop
        vertex 35.819313049316406 20.170421600341797 -5.208700180053711
        vertex 42.16571044921875 -20.9375 -5.666999816894531
        vertex 35.700889587402344 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882917404174805 0.15257610380649567 1.3889728052163264e-06
    outer loop
        vertex 34.9193229675293 26.0 5.773159728050814e-15
        vertex 41.223323822021484 -14.833333015441895 -0.625
        vertex 40.19409942626953 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9882919192314148 0.15257492661476135 -3.89839094339095e-08
    outer loop
        vertex 35.45966720581055 22.5 -0.625
        vertex 35.819313049316406 20.170421600341797 -5.208700180053711
        vertex 35.700889587402344 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882921576499939 0.15257325768470764 0.00016073300503194332
    outer loop
        vertex 34.9193229675293 26.0 5.773159728050814e-15
        vertex 40.19409942626953 -8.166666984558105 -0.625
        vertex 40.03971862792969 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9882915616035461 0.1525770127773285 -7.009929277046467e-07
    outer loop
        vertex 35.45966720581055 22.5 -0.625
        vertex 35.700889587402344 20.9375 -5.666999816894531
        vertex 35.30528259277344 23.5 -0.625
    endloop
endfacet
facet normal 0.9882916212081909 0.15257665514945984 -2.3377644538413733e-05
    outer loop
        vertex 34.9193229675293 26.0 5.773159728050814e-15
        vertex 40.03971862792969 -7.166666507720947 -0.625
        vertex 39.01049041748047 -0.5 -0.625
    endloop
endfacet
facet normal 0.9882915616035461 0.1525770127773285 -3.016026539626182e-06
    outer loop
        vertex 35.45966720581055 22.5 -0.625
        vertex 35.30528259277344 23.5 -0.625
        vertex 34.9193229675293 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882921576499939 0.1525733321905136 0.00012064113252563402
    outer loop
        vertex 34.9193229675293 26.0 5.773159728050814e-15
        vertex 39.01049041748047 -0.5 -0.625
        vertex 38.856109619140625 0.5 -0.625
    endloop
endfacet
facet normal 0.9882917404174805 0.15257608890533447 2.302762368344702e-06
    outer loop
        vertex 36.4888916015625 15.833333015441895 -0.625
        vertex 35.45966720581055 22.5 -0.625
        vertex 34.9193229675293 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882916212081909 0.15257665514945984 -1.7942977137863636e-05
    outer loop
        vertex 34.9193229675293 26.0 5.773159728050814e-15
        vertex 38.856109619140625 0.5 -0.625
        vertex 37.826881408691406 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9882915616035461 0.1525770127773285 -1.3147053323336877e-05
    outer loop
        vertex 36.64327621459961 14.833333015441895 -0.625
        vertex 36.4888916015625 15.833333015441895 -0.625
        vertex 34.9193229675293 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882921576499939 0.15257325768470764 8.660226740175858e-05
    outer loop
        vertex 34.9193229675293 26.0 5.773159728050814e-15
        vertex 37.826881408691406 7.166666507720947 -0.625
        vertex 37.67250061035156 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9882917404174805 0.15257610380649567 3.4324552871112246e-06
    outer loop
        vertex 37.67250061035156 8.166666984558105 -0.625
        vertex 36.64327621459961 14.833333015441895 -0.625
        vertex 34.9193229675293 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882921576499939 0.15257325768470764 5.912789588924998e-17
    outer loop
        vertex 40.19409942626953 -8.166666984558105 -0.625
        vertex 40.19409942626953 -8.166666984558105 -5.208700180053711
        vertex 40.03971862792969 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.9882921576499939 0.1525733321905136 3.51072061754205e-17
    outer loop
        vertex 39.01049041748047 -0.5 -0.625
        vertex 39.01049041748047 -0.5 -5.208700180053711
        vertex 38.856109619140625 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.9882921576499939 0.15257325768470764 5.912789588924998e-17
    outer loop
        vertex 37.826881408691406 7.166666507720947 -0.625
        vertex 37.826881408691406 7.166666507720947 -5.208700180053711
        vertex 37.67250061035156 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.9882915616035461 0.1525770127773285 5.912935172712808e-17
    outer loop
        vertex 36.64327621459961 14.833333015441895 -0.625
        vertex 36.64327621459961 14.833333015441895 -5.208700180053711
        vertex 36.4888916015625 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9882915616035461 0.1525770127773285 1.1246788744756486e-06
    outer loop
        vertex 42.04728698730469 -20.170421600341797 -5.208700180053711
        vertex 42.40693283081055 -22.5 -0.625
        vertex 42.561317443847656 -23.5 -0.625
    endloop
endfacet
facet normal 0.9882916808128357 0.15257628262043 -0.0
    outer loop
        vertex 35.30528259277344 23.5 -0.625
        vertex 34.9193229675293 26.0 -0.625
        vertex 34.9193229675293 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882917404174805 0.15257616341114044 0.0
    outer loop
        vertex 34.9193229675293 26.0 5.773159728050814e-15
        vertex 42.9472770690918 -26.0 -5.773159728050814e-15
        vertex 42.9472770690918 -26.0 -0.625
    endloop
endfacet
facet normal 0.9882915616035461 0.1525770127773285 5.912935172712808e-17
    outer loop
        vertex 41.377708435058594 -15.833333015441895 -0.625
        vertex 41.377708435058594 -15.833333015441895 -5.208700180053711
        vertex 41.223323822021484 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9882921576499939 0.15257325768470764 2.956394794462499e-17
    outer loop
        vertex 40.19409942626953 -8.166666984558105 -0.625
        vertex 40.03971862792969 -7.166666507720947 -5.208700180053711
        vertex 40.03971862792969 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9882921576499939 0.1525733321905136 3.325945674054445e-17
    outer loop
        vertex 39.01049041748047 -0.5 -0.625
        vertex 38.856109619140625 0.5 -5.208700180053711
        vertex 38.856109619140625 0.5 -0.625
    endloop
endfacet
facet normal 0.9882921576499939 0.15257325768470764 5.912789588924998e-17
    outer loop
        vertex 37.826881408691406 7.166666507720947 -0.625
        vertex 37.67250061035156 8.166666984558105 -5.208700180053711
        vertex 37.67250061035156 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9882915616035461 0.1525770127773285 5.912935172712808e-17
    outer loop
        vertex 36.64327621459961 14.833333015441895 -0.625
        vertex 36.4888916015625 15.833333015441895 -5.208700180053711
        vertex 36.4888916015625 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.98829185962677 0.15257512032985687 -2.860162453544035e-07
    outer loop
        vertex 42.04728698730469 -20.170421600341797 -5.208700180053711
        vertex 42.561317443847656 -23.5 -0.625
        vertex 42.16571044921875 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882916808128357 0.15257622301578522 -5.140696430316893e-06
    outer loop
        vertex 34.9193229675293 26.0 5.773159728050814e-15
        vertex 42.9472770690918 -26.0 -0.625
        vertex 41.377708435058594 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882915616035461 0.1525770127773285 5.912935172712808e-17
    outer loop
        vertex 41.377708435058594 -15.833333015441895 -0.625
        vertex 41.223323822021484 -14.833333015441895 -5.208700180053711
        vertex 41.223323822021484 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882916808128357 0.1525762528181076 -2.243684548375313e-06
    outer loop
        vertex 35.819313049316406 20.170421600341797 -5.208700180053711
        vertex 42.04728698730469 -20.170421600341797 -5.208700180053711
        vertex 42.16571044921875 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882915616035461 0.1525770127773285 -5.923758362769149e-05
    outer loop
        vertex 34.9193229675293 26.0 5.773159728050814e-15
        vertex 41.377708435058594 -15.833333015441895 -0.625
        vertex 41.223323822021484 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9882916808128357 0.15257620811462402 2.161483507734374e-06
    outer loop
        vertex 35.819313049316406 20.170421600341797 -5.208700180053711
        vertex 42.16571044921875 -20.9375 -5.666999816894531
        vertex 35.700889587402344 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882917404174805 0.15257610380649567 1.3889728052163264e-06
    outer loop
        vertex 34.9193229675293 26.0 5.773159728050814e-15
        vertex 41.223323822021484 -14.833333015441895 -0.625
        vertex 40.19409942626953 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9882919192314148 0.15257492661476135 -3.89839094339095e-08
    outer loop
        vertex 35.45966720581055 22.5 -0.625
        vertex 35.819313049316406 20.170421600341797 -5.208700180053711
        vertex 35.700889587402344 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9882921576499939 0.15257325768470764 0.00016073300503194332
    outer loop
        vertex 34.9193229675293 26.0 5.773159728050814e-15
        vertex 40.19409942626953 -8.166666984558105 -0.625
        vertex 40.03971862792969 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9882915616035461 0.1525770127773285 -7.009929277046467e-07
    outer loop
        vertex 35.45966720581055 22.5 -0.625
        vertex 35.700889587402344 20.9375 -5.666999816894531
        vertex 35.30528259277344 23.5 -0.625
    endloop
endfacet
facet normal 0.9882916212081909 0.15257665514945984 -2.3377644538413733e-05
    outer loop
        vertex 34.9193229675293 26.0 5.773159728050814e-15
        vertex 40.03971862792969 -7.166666507720947 -0.625
        vertex 39.01049041748047 -0.5 -0.625
    endloop
endfacet
facet normal 0.9882915616035461 0.1525770127773285 -3.016026539626182e-06
    outer loop
        vertex 35.45966720581055 22.5 -0.625
        vertex 35.30528259277344 23.5 -0.625
        vertex 34.9193229675293 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882921576499939 0.1525733321905136 0.00012064113252563402
    outer loop
        vertex 34.9193229675293 26.0 5.773159728050814e-15
        vertex 39.01049041748047 -0.5 -0.625
        vertex 38.856109619140625 0.5 -0.625
    endloop
endfacet
facet normal 0.9882917404174805 0.15257608890533447 2.302762368344702e-06
    outer loop
        vertex 36.4888916015625 15.833333015441895 -0.625
        vertex 35.45966720581055 22.5 -0.625
        vertex 34.9193229675293 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882916212081909 0.15257665514945984 -1.7942977137863636e-05
    outer loop
        vertex 34.9193229675293 26.0 5.773159728050814e-15
        vertex 38.856109619140625 0.5 -0.625
        vertex 37.826881408691406 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9882915616035461 0.1525770127773285 -1.3147053323336877e-05
    outer loop
        vertex 36.64327621459961 14.833333015441895 -0.625
        vertex 36.4888916015625 15.833333015441895 -0.625
        vertex 34.9193229675293 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9882921576499939 0.15257325768470764 8.660226740175858e-05
    outer loop
        vertex 34.9193229675293 26.0 5.773159728050814e-15
        vertex 37.826881408691406 7.166666507720947 -0.625
        vertex 37.67250061035156 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9882917404174805 0.15257610380649567 3.4324552871112246e-06
    outer loop
        vertex 37.67250061035156 8.166666984558105 -0.625
        vertex 36.64327621459961 14.833333015441895 -0.625
        vertex 34.9193229675293 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582771062850952 0.2858409285545349 1.1077414827874975e-16
    outer loop
        vertex 31.63601303100586 -8.166666984558105 -0.625
        vertex 31.63601303100586 -8.166666984558105 -5.208700180053711
        vertex 31.337726593017578 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.9582765698432922 0.2858427166938782 6.577256495799455e-17
    outer loop
        vertex 29.349143981933594 -0.5 -0.625
        vertex 29.349143981933594 -0.5 -5.208700180053711
        vertex 29.05085563659668 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.9582771062850952 0.2858409285545349 1.1077414827874975e-16
    outer loop
        vertex 27.062273025512695 7.166666507720947 -0.625
        vertex 27.062273025512695 7.166666507720947 -5.208700180053711
        vertex 26.763986587524414 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.9582765698432922 0.2858427166938782 1.1077484311046429e-16
    outer loop
        vertex 24.77540397644043 14.833333015441895 -0.625
        vertex 24.77540397644043 14.833333015441895 -5.208700180053711
        vertex 24.477115631103516 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9582760334014893 0.2858444154262543 1.9004282876267098e-06
    outer loop
        vertex 35.216583251953125 -20.170421600341797 -5.208700180053711
        vertex 35.91146469116211 -22.5 -0.625
        vertex 36.209754943847656 -23.5 -0.625
    endloop
endfacet
facet normal 0.9582768678665161 0.285841703414917 -0.0
    outer loop
        vertex 22.19024658203125 23.5 -0.625
        vertex 21.444528579711914 26.0 -0.625
        vertex 21.444528579711914 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582768082618713 0.28584185242652893 0.0
    outer loop
        vertex 21.444528579711914 26.0 5.773159728050814e-15
        vertex 36.95547103881836 -26.0 -5.773159728050814e-15
        vertex 36.95547103881836 -26.0 -0.625
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 1.1077419460086405e-16
    outer loop
        vertex 33.922882080078125 -15.833333015441895 -0.625
        vertex 33.922882080078125 -15.833333015441895 -5.208700180053711
        vertex 33.624595642089844 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9582771062850952 0.2858409285545349 5.538707413937487e-17
    outer loop
        vertex 31.63601303100586 -8.166666984558105 -0.625
        vertex 31.337726593017578 -7.166666507720947 -5.208700180053711
        vertex 31.337726593017578 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9582765698432922 0.2858427166938782 6.231085379912953e-17
    outer loop
        vertex 29.349143981933594 -0.5 -0.625
        vertex 29.05085563659668 0.5 -5.208700180053711
        vertex 29.05085563659668 0.5 -0.625
    endloop
endfacet
facet normal 0.9582771062850952 0.2858409285545349 1.1077414827874975e-16
    outer loop
        vertex 27.062273025512695 7.166666507720947 -0.625
        vertex 26.763986587524414 8.166666984558105 -5.208700180053711
        vertex 26.763986587524414 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9582765698432922 0.2858427166938782 1.1077484311046429e-16
    outer loop
        vertex 24.77540397644043 14.833333015441895 -0.625
        vertex 24.477115631103516 15.833333015441895 -5.208700180053711
        vertex 24.477115631103516 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582768678665161 0.28584155440330505 -3.535723749337194e-07
    outer loop
        vertex 35.216583251953125 -20.170421600341797 -5.208700180053711
        vertex 36.209754943847656 -23.5 -0.625
        vertex 35.44539260864258 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582768082618713 0.2858419120311737 -5.92024480283726e-06
    outer loop
        vertex 21.444528579711914 26.0 5.773159728050814e-15
        vertex 36.95547103881836 -26.0 -0.625
        vertex 33.922882080078125 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 1.1077419460086405e-16
    outer loop
        vertex 33.922882080078125 -15.833333015441895 -0.625
        vertex 33.624595642089844 -14.833333015441895 -5.208700180053711
        vertex 33.624595642089844 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582768082618713 0.2858418822288513 -9.616414899937809e-07
    outer loop
        vertex 23.18341827392578 20.170421600341797 -5.208700180053711
        vertex 35.216583251953125 -20.170421600341797 -5.208700180053711
        vertex 35.44539260864258 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 5.7659166486701e-05
    outer loop
        vertex 21.444528579711914 26.0 5.773159728050814e-15
        vertex 33.922882080078125 -15.833333015441895 -0.625
        vertex 33.624595642089844 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582768082618713 0.2858419120311737 -2.988684173033107e-06
    outer loop
        vertex 23.18341827392578 20.170421600341797 -5.208700180053711
        vertex 35.44539260864258 -20.9375 -5.666999816894531
        vertex 22.954607009887695 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582768082618713 0.2858419120311737 -3.8289222175080795e-06
    outer loop
        vertex 21.444528579711914 26.0 5.773159728050814e-15
        vertex 33.624595642089844 -14.833333015441895 -0.625
        vertex 31.63601303100586 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9582763910293579 0.28584328293800354 -4.828883106711146e-07
    outer loop
        vertex 22.48853302001953 22.5 -0.625
        vertex 23.18341827392578 20.170421600341797 -5.208700180053711
        vertex 22.954607009887695 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582771062850952 0.2858409285545349 5.5071341193979606e-05
    outer loop
        vertex 21.444528579711914 26.0 5.773159728050814e-15
        vertex 31.63601303100586 -8.166666984558105 -0.625
        vertex 31.337726593017578 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 2.718814755553467e-07
    outer loop
        vertex 22.48853302001953 22.5 -0.625
        vertex 22.954607009887695 20.9375 -5.666999816894531
        vertex 22.19024658203125 23.5 -0.625
    endloop
endfacet
facet normal 0.9582768082618713 0.2858418822288513 -1.020063223222678e-06
    outer loop
        vertex 21.444528579711914 26.0 5.773159728050814e-15
        vertex 31.337726593017578 -7.166666507720947 -0.625
        vertex 29.349143981933594 -0.5 -0.625
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 2.924429509221227e-06
    outer loop
        vertex 22.48853302001953 22.5 -0.625
        vertex 22.19024658203125 23.5 -0.625
        vertex 21.444528579711914 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582765698432922 0.2858427166938782 -3.9479775296058506e-05
    outer loop
        vertex 21.444528579711914 26.0 5.773159728050814e-15
        vertex 29.349143981933594 -0.5 -0.625
        vertex 29.05085563659668 0.5 -0.625
    endloop
endfacet
facet normal 0.9582768082618713 0.2858418822288513 -2.1169935280340724e-06
    outer loop
        vertex 24.477115631103516 15.833333015441895 -0.625
        vertex 22.48853302001953 22.5 -0.625
        vertex 21.444528579711914 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582768082618713 0.2858418822288513 -2.471373591106385e-06
    outer loop
        vertex 21.444528579711914 26.0 5.773159728050814e-15
        vertex 29.05085563659668 0.5 -0.625
        vertex 27.062273025512695 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9582765698432922 0.2858427166938782 -1.7204549294547178e-05
    outer loop
        vertex 24.77540397644043 14.833333015441895 -0.625
        vertex 24.477115631103516 15.833333015441895 -0.625
        vertex 21.444528579711914 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582771062850952 0.2858409285545349 2.9379523766692728e-05
    outer loop
        vertex 21.444528579711914 26.0 5.773159728050814e-15
        vertex 27.062273025512695 7.166666507720947 -0.625
        vertex 26.763986587524414 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9582768082618713 0.2858419120311737 -1.363539354315435e-06
    outer loop
        vertex 26.763986587524414 8.166666984558105 -0.625
        vertex 24.77540397644043 14.833333015441895 -0.625
        vertex 21.444528579711914 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582771062850952 0.2858409285545349 1.1077414827874975e-16
    outer loop
        vertex 31.63601303100586 -8.166666984558105 -0.625
        vertex 31.63601303100586 -8.166666984558105 -5.208700180053711
        vertex 31.337726593017578 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.9582765698432922 0.2858427166938782 6.577256495799455e-17
    outer loop
        vertex 29.349143981933594 -0.5 -0.625
        vertex 29.349143981933594 -0.5 -5.208700180053711
        vertex 29.05085563659668 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.9582771062850952 0.2858409285545349 1.1077414827874975e-16
    outer loop
        vertex 27.062273025512695 7.166666507720947 -0.625
        vertex 27.062273025512695 7.166666507720947 -5.208700180053711
        vertex 26.763986587524414 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.9582765698432922 0.2858427166938782 1.1077484311046429e-16
    outer loop
        vertex 24.77540397644043 14.833333015441895 -0.625
        vertex 24.77540397644043 14.833333015441895 -5.208700180053711
        vertex 24.477115631103516 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9582760334014893 0.2858444154262543 1.9004282876267098e-06
    outer loop
        vertex 35.216583251953125 -20.170421600341797 -5.208700180053711
        vertex 35.91146469116211 -22.5 -0.625
        vertex 36.209754943847656 -23.5 -0.625
    endloop
endfacet
facet normal 0.9582768678665161 0.285841703414917 -0.0
    outer loop
        vertex 22.19024658203125 23.5 -0.625
        vertex 21.444528579711914 26.0 -0.625
        vertex 21.444528579711914 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582768082618713 0.28584185242652893 0.0
    outer loop
        vertex 21.444528579711914 26.0 5.773159728050814e-15
        vertex 36.95547103881836 -26.0 -5.773159728050814e-15
        vertex 36.95547103881836 -26.0 -0.625
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 1.1077419460086405e-16
    outer loop
        vertex 33.922882080078125 -15.833333015441895 -0.625
        vertex 33.922882080078125 -15.833333015441895 -5.208700180053711
        vertex 33.624595642089844 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9582771062850952 0.2858409285545349 5.538707413937487e-17
    outer loop
        vertex 31.63601303100586 -8.166666984558105 -0.625
        vertex 31.337726593017578 -7.166666507720947 -5.208700180053711
        vertex 31.337726593017578 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9582765698432922 0.2858427166938782 6.231085379912953e-17
    outer loop
        vertex 29.349143981933594 -0.5 -0.625
        vertex 29.05085563659668 0.5 -5.208700180053711
        vertex 29.05085563659668 0.5 -0.625
    endloop
endfacet
facet normal 0.9582771062850952 0.2858409285545349 1.1077414827874975e-16
    outer loop
        vertex 27.062273025512695 7.166666507720947 -0.625
        vertex 26.763986587524414 8.166666984558105 -5.208700180053711
        vertex 26.763986587524414 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9582765698432922 0.2858427166938782 1.1077484311046429e-16
    outer loop
        vertex 24.77540397644043 14.833333015441895 -0.625
        vertex 24.477115631103516 15.833333015441895 -5.208700180053711
        vertex 24.477115631103516 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582768678665161 0.28584155440330505 -3.535723749337194e-07
    outer loop
        vertex 35.216583251953125 -20.170421600341797 -5.208700180053711
        vertex 36.209754943847656 -23.5 -0.625
        vertex 35.44539260864258 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582768082618713 0.2858419120311737 -5.92024480283726e-06
    outer loop
        vertex 21.444528579711914 26.0 5.773159728050814e-15
        vertex 36.95547103881836 -26.0 -0.625
        vertex 33.922882080078125 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 1.1077419460086405e-16
    outer loop
        vertex 33.922882080078125 -15.833333015441895 -0.625
        vertex 33.624595642089844 -14.833333015441895 -5.208700180053711
        vertex 33.624595642089844 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582768082618713 0.2858418822288513 -9.616414899937809e-07
    outer loop
        vertex 23.18341827392578 20.170421600341797 -5.208700180053711
        vertex 35.216583251953125 -20.170421600341797 -5.208700180053711
        vertex 35.44539260864258 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 5.7659166486701e-05
    outer loop
        vertex 21.444528579711914 26.0 5.773159728050814e-15
        vertex 33.922882080078125 -15.833333015441895 -0.625
        vertex 33.624595642089844 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9582768082618713 0.2858419120311737 -2.988684173033107e-06
    outer loop
        vertex 23.18341827392578 20.170421600341797 -5.208700180053711
        vertex 35.44539260864258 -20.9375 -5.666999816894531
        vertex 22.954607009887695 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582768082618713 0.2858419120311737 -3.8289222175080795e-06
    outer loop
        vertex 21.444528579711914 26.0 5.773159728050814e-15
        vertex 33.624595642089844 -14.833333015441895 -0.625
        vertex 31.63601303100586 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9582763910293579 0.28584328293800354 -4.828883106711146e-07
    outer loop
        vertex 22.48853302001953 22.5 -0.625
        vertex 23.18341827392578 20.170421600341797 -5.208700180053711
        vertex 22.954607009887695 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9582771062850952 0.2858409285545349 5.5071341193979606e-05
    outer loop
        vertex 21.444528579711914 26.0 5.773159728050814e-15
        vertex 31.63601303100586 -8.166666984558105 -0.625
        vertex 31.337726593017578 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 2.718814755553467e-07
    outer loop
        vertex 22.48853302001953 22.5 -0.625
        vertex 22.954607009887695 20.9375 -5.666999816894531
        vertex 22.19024658203125 23.5 -0.625
    endloop
endfacet
facet normal 0.9582768082618713 0.2858418822288513 -1.020063223222678e-06
    outer loop
        vertex 21.444528579711914 26.0 5.773159728050814e-15
        vertex 31.337726593017578 -7.166666507720947 -0.625
        vertex 29.349143981933594 -0.5 -0.625
    endloop
endfacet
facet normal 0.9582770466804504 0.28584104776382446 2.924429509221227e-06
    outer loop
        vertex 22.48853302001953 22.5 -0.625
        vertex 22.19024658203125 23.5 -0.625
        vertex 21.444528579711914 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582765698432922 0.2858427166938782 -3.9479775296058506e-05
    outer loop
        vertex 21.444528579711914 26.0 5.773159728050814e-15
        vertex 29.349143981933594 -0.5 -0.625
        vertex 29.05085563659668 0.5 -0.625
    endloop
endfacet
facet normal 0.9582768082618713 0.2858418822288513 -2.1169935280340724e-06
    outer loop
        vertex 24.477115631103516 15.833333015441895 -0.625
        vertex 22.48853302001953 22.5 -0.625
        vertex 21.444528579711914 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582768082618713 0.2858418822288513 -2.471373591106385e-06
    outer loop
        vertex 21.444528579711914 26.0 5.773159728050814e-15
        vertex 29.05085563659668 0.5 -0.625
        vertex 27.062273025512695 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9582765698432922 0.2858427166938782 -1.7204549294547178e-05
    outer loop
        vertex 24.77540397644043 14.833333015441895 -0.625
        vertex 24.477115631103516 15.833333015441895 -0.625
        vertex 21.444528579711914 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9582771062850952 0.2858409285545349 2.9379523766692728e-05
    outer loop
        vertex 21.444528579711914 26.0 5.773159728050814e-15
        vertex 27.062273025512695 7.166666507720947 -0.625
        vertex 26.763986587524414 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9582768082618713 0.2858419120311737 -1.363539354315435e-06
    outer loop
        vertex 26.763986587524414 8.166666984558105 -0.625
        vertex 24.77540397644043 14.833333015441895 -0.625
        vertex 21.444528579711914 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205138087272644 0.3907100558280945 1.5141489496712948e-16
    outer loop
        vertex 22.93303871154785 -8.166666984558105 -0.625
        vertex 22.93303871154785 -8.166666984558105 -5.208700180053711
        vertex 22.508590698242188 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 8.990297190827307e-17
    outer loop
        vertex 19.678924560546875 -0.5 -0.625
        vertex 19.678924560546875 -0.5 -5.208700180053711
        vertex 19.254474639892578 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.9205131530761719 0.39071154594421387 1.5141547730228072e-16
    outer loop
        vertex 16.4248104095459 7.166666507720947 -0.625
        vertex 16.4248104095459 7.166666507720947 -5.208700180053711
        vertex 16.0003604888916 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 1.5141553024183992e-16
    outer loop
        vertex 13.170695304870605 14.833333015441895 -0.625
        vertex 13.170695304870605 14.833333015441895 -5.208700180053711
        vertex 12.746245384216309 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 1.530586786202548e-07
    outer loop
        vertex 28.028030395507812 -20.170421600341797 -5.208700180053711
        vertex 29.01681900024414 -22.5 -0.625
        vertex 29.441268920898438 -23.5 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 -0.0
    outer loop
        vertex 9.492131233215332 23.5 -0.625
        vertex 8.43100643157959 26.0 -0.625
        vertex 8.43100643157959 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205131530761719 0.39071157574653625 0.0
    outer loop
        vertex 8.43100643157959 26.0 5.773159728050814e-15
        vertex 30.50239372253418 -26.0 -5.773159728050814e-15
        vertex 30.50239372253418 -26.0 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 1.5141553024183992e-16
    outer loop
        vertex 26.18715476989746 -15.833333015441895 -0.625
        vertex 26.18715476989746 -15.833333015441895 -5.208700180053711
        vertex 25.762704849243164 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9205138087272644 0.3907100558280945 7.570744748356474e-17
    outer loop
        vertex 22.93303871154785 -8.166666984558105 -0.625
        vertex 22.508590698242188 -7.166666507720947 -5.208700180053711
        vertex 22.508590698242188 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 8.517124072411863e-17
    outer loop
        vertex 19.678924560546875 -0.5 -0.625
        vertex 19.254474639892578 0.5 -5.208700180053711
        vertex 19.254474639892578 0.5 -0.625
    endloop
endfacet
facet normal 0.9205131530761719 0.39071154594421387 1.5141547730228072e-16
    outer loop
        vertex 16.4248104095459 7.166666507720947 -0.625
        vertex 16.0003604888916 8.166666984558105 -5.208700180053711
        vertex 16.0003604888916 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 1.5141553024183992e-16
    outer loop
        vertex 13.170695304870605 14.833333015441895 -0.625
        vertex 12.746245384216309 15.833333015441895 -5.208700180053711
        vertex 12.746245384216309 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205131530761719 0.39071163535118103 7.822603720342158e-08
    outer loop
        vertex 28.028030395507812 -20.170421600341797 -5.208700180053711
        vertex 29.441268920898438 -23.5 -0.625
        vertex 28.35361671447754 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205131530761719 0.39071154594421387 2.743392315096571e-06
    outer loop
        vertex 8.43100643157959 26.0 5.773159728050814e-15
        vertex 30.50239372253418 -26.0 -0.625
        vertex 26.18715476989746 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 1.5141553024183992e-16
    outer loop
        vertex 26.18715476989746 -15.833333015441895 -0.625
        vertex 25.762704849243164 -14.833333015441895 -5.208700180053711
        vertex 25.762704849243164 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205131530761719 0.39071157574653625 1.7538759777835367e-07
    outer loop
        vertex 10.905369758605957 20.170421600341797 -5.208700180053711
        vertex 28.028030395507812 -20.170421600341797 -5.208700180053711
        vertex 28.35361671447754 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 -9.633414265408646e-06
    outer loop
        vertex 8.43100643157959 26.0 5.773159728050814e-15
        vertex 26.18715476989746 -15.833333015441895 -0.625
        vertex 25.762704849243164 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205131530761719 0.39071157574653625 -1.689620034994732e-07
    outer loop
        vertex 10.905369758605957 20.170421600341797 -5.208700180053711
        vertex 28.35361671447754 -20.9375 -5.666999816894531
        vertex 10.57978343963623 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117545604706 -1.206781053042505e-05
    outer loop
        vertex 8.43100643157959 26.0 5.773159728050814e-15
        vertex 25.762704849243164 -14.833333015441895 -0.625
        vertex 22.93303871154785 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9205131530761719 0.39071160554885864 -9.546619850198113e-08
    outer loop
        vertex 9.916581153869629 22.5 -0.625
        vertex 10.905369758605957 20.170421600341797 -5.208700180053711
        vertex 10.57978343963623 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205138087272644 0.3907100558280945 9.613429574528709e-05
    outer loop
        vertex 8.43100643157959 26.0 5.773159728050814e-15
        vertex 22.93303871154785 -8.166666984558105 -0.625
        vertex 22.508590698242188 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 -1.3058355818884593e-07
    outer loop
        vertex 9.916581153869629 22.5 -0.625
        vertex 10.57978343963623 20.9375 -5.666999816894531
        vertex 9.492131233215332 23.5 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 -7.417926099151373e-06
    outer loop
        vertex 8.43100643157959 26.0 5.773159728050814e-15
        vertex 22.508590698242188 -7.166666507720947 -0.625
        vertex 19.678924560546875 -0.5 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 2.2892236422597046e-15
    outer loop
        vertex 9.916581153869629 22.5 -0.625
        vertex 9.492131233215332 23.5 -0.625
        vertex 8.43100643157959 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 -7.022957561275689e-06
    outer loop
        vertex 8.43100643157959 26.0 5.773159728050814e-15
        vertex 19.678924560546875 -0.5 -0.625
        vertex 19.254474639892578 0.5 -0.625
    endloop
endfacet
facet normal 0.9205132126808167 0.3907114863395691 1.579152467456879e-06
    outer loop
        vertex 12.746245384216309 15.833333015441895 -0.625
        vertex 9.916581153869629 22.5 -0.625
        vertex 8.43100643157959 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205132126808167 0.3907114863395691 3.342104037074023e-06
    outer loop
        vertex 8.43100643157959 26.0 5.773159728050814e-15
        vertex 19.254474639892578 0.5 -0.625
        vertex 16.4248104095459 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 -3.0079092994128587e-06
    outer loop
        vertex 13.170695304870605 14.833333015441895 -0.625
        vertex 12.746245384216309 15.833333015441895 -0.625
        vertex 8.43100643157959 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205131530761719 0.39071154594421387 1.3008764199184952e-06
    outer loop
        vertex 8.43100643157959 26.0 5.773159728050814e-15
        vertex 16.4248104095459 7.166666507720947 -0.625
        vertex 16.0003604888916 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9205131530761719 0.39071163535118103 -1.3209512417233782e-06
    outer loop
        vertex 16.0003604888916 8.166666984558105 -0.625
        vertex 13.170695304870605 14.833333015441895 -0.625
        vertex 8.43100643157959 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205138087272644 0.3907100558280945 1.5141489496712948e-16
    outer loop
        vertex 22.93303871154785 -8.166666984558105 -0.625
        vertex 22.93303871154785 -8.166666984558105 -5.208700180053711
        vertex 22.508590698242188 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 8.990297190827307e-17
    outer loop
        vertex 19.678924560546875 -0.5 -0.625
        vertex 19.678924560546875 -0.5 -5.208700180053711
        vertex 19.254474639892578 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.9205131530761719 0.39071154594421387 1.5141547730228072e-16
    outer loop
        vertex 16.4248104095459 7.166666507720947 -0.625
        vertex 16.4248104095459 7.166666507720947 -5.208700180053711
        vertex 16.0003604888916 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 1.5141553024183992e-16
    outer loop
        vertex 13.170695304870605 14.833333015441895 -0.625
        vertex 13.170695304870605 14.833333015441895 -5.208700180053711
        vertex 12.746245384216309 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 1.530586786202548e-07
    outer loop
        vertex 28.028030395507812 -20.170421600341797 -5.208700180053711
        vertex 29.01681900024414 -22.5 -0.625
        vertex 29.441268920898438 -23.5 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 -0.0
    outer loop
        vertex 9.492131233215332 23.5 -0.625
        vertex 8.43100643157959 26.0 -0.625
        vertex 8.43100643157959 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205131530761719 0.39071157574653625 0.0
    outer loop
        vertex 8.43100643157959 26.0 5.773159728050814e-15
        vertex 30.50239372253418 -26.0 -5.773159728050814e-15
        vertex 30.50239372253418 -26.0 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 1.5141553024183992e-16
    outer loop
        vertex 26.18715476989746 -15.833333015441895 -0.625
        vertex 26.18715476989746 -15.833333015441895 -5.208700180053711
        vertex 25.762704849243164 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.9205138087272644 0.3907100558280945 7.570744748356474e-17
    outer loop
        vertex 22.93303871154785 -8.166666984558105 -0.625
        vertex 22.508590698242188 -7.166666507720947 -5.208700180053711
        vertex 22.508590698242188 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 8.517124072411863e-17
    outer loop
        vertex 19.678924560546875 -0.5 -0.625
        vertex 19.254474639892578 0.5 -5.208700180053711
        vertex 19.254474639892578 0.5 -0.625
    endloop
endfacet
facet normal 0.9205131530761719 0.39071154594421387 1.5141547730228072e-16
    outer loop
        vertex 16.4248104095459 7.166666507720947 -0.625
        vertex 16.0003604888916 8.166666984558105 -5.208700180053711
        vertex 16.0003604888916 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 1.5141553024183992e-16
    outer loop
        vertex 13.170695304870605 14.833333015441895 -0.625
        vertex 12.746245384216309 15.833333015441895 -5.208700180053711
        vertex 12.746245384216309 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205131530761719 0.39071163535118103 7.822603720342158e-08
    outer loop
        vertex 28.028030395507812 -20.170421600341797 -5.208700180053711
        vertex 29.441268920898438 -23.5 -0.625
        vertex 28.35361671447754 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205131530761719 0.39071154594421387 2.743392315096571e-06
    outer loop
        vertex 8.43100643157959 26.0 5.773159728050814e-15
        vertex 30.50239372253418 -26.0 -0.625
        vertex 26.18715476989746 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 1.5141553024183992e-16
    outer loop
        vertex 26.18715476989746 -15.833333015441895 -0.625
        vertex 25.762704849243164 -14.833333015441895 -5.208700180053711
        vertex 25.762704849243164 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205131530761719 0.39071157574653625 1.7538759777835367e-07
    outer loop
        vertex 10.905369758605957 20.170421600341797 -5.208700180053711
        vertex 28.028030395507812 -20.170421600341797 -5.208700180053711
        vertex 28.35361671447754 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 -9.633414265408646e-06
    outer loop
        vertex 8.43100643157959 26.0 5.773159728050814e-15
        vertex 26.18715476989746 -15.833333015441895 -0.625
        vertex 25.762704849243164 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.9205131530761719 0.39071157574653625 -1.689620034994732e-07
    outer loop
        vertex 10.905369758605957 20.170421600341797 -5.208700180053711
        vertex 28.35361671447754 -20.9375 -5.666999816894531
        vertex 10.57978343963623 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117545604706 -1.206781053042505e-05
    outer loop
        vertex 8.43100643157959 26.0 5.773159728050814e-15
        vertex 25.762704849243164 -14.833333015441895 -0.625
        vertex 22.93303871154785 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9205131530761719 0.39071160554885864 -9.546619850198113e-08
    outer loop
        vertex 9.916581153869629 22.5 -0.625
        vertex 10.905369758605957 20.170421600341797 -5.208700180053711
        vertex 10.57978343963623 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.9205138087272644 0.3907100558280945 9.613429574528709e-05
    outer loop
        vertex 8.43100643157959 26.0 5.773159728050814e-15
        vertex 22.93303871154785 -8.166666984558105 -0.625
        vertex 22.508590698242188 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 -1.3058355818884593e-07
    outer loop
        vertex 9.916581153869629 22.5 -0.625
        vertex 10.57978343963623 20.9375 -5.666999816894531
        vertex 9.492131233215332 23.5 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 -7.417926099151373e-06
    outer loop
        vertex 8.43100643157959 26.0 5.773159728050814e-15
        vertex 22.508590698242188 -7.166666507720947 -0.625
        vertex 19.678924560546875 -0.5 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 2.2892236422597046e-15
    outer loop
        vertex 9.916581153869629 22.5 -0.625
        vertex 9.492131233215332 23.5 -0.625
        vertex 8.43100643157959 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 -7.022957561275689e-06
    outer loop
        vertex 8.43100643157959 26.0 5.773159728050814e-15
        vertex 19.678924560546875 -0.5 -0.625
        vertex 19.254474639892578 0.5 -0.625
    endloop
endfacet
facet normal 0.9205132126808167 0.3907114863395691 1.579152467456879e-06
    outer loop
        vertex 12.746245384216309 15.833333015441895 -0.625
        vertex 9.916581153869629 22.5 -0.625
        vertex 8.43100643157959 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205132126808167 0.3907114863395691 3.342104037074023e-06
    outer loop
        vertex 8.43100643157959 26.0 5.773159728050814e-15
        vertex 19.254474639892578 0.5 -0.625
        vertex 16.4248104095459 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.9205130934715271 0.3907117247581482 -3.0079092994128587e-06
    outer loop
        vertex 13.170695304870605 14.833333015441895 -0.625
        vertex 12.746245384216309 15.833333015441895 -0.625
        vertex 8.43100643157959 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.9205131530761719 0.39071154594421387 1.3008764199184952e-06
    outer loop
        vertex 8.43100643157959 26.0 5.773159728050814e-15
        vertex 16.4248104095459 7.166666507720947 -0.625
        vertex 16.0003604888916 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.9205131530761719 0.39071163535118103 -1.3209512417233782e-06
    outer loop
        vertex 16.0003604888916 8.166666984558105 -0.625
        vertex 13.170695304870605 14.833333015441895 -0.625
        vertex 8.43100643157959 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835671544075012 0.46830445528030396 1.8148564985562081e-16
    outer loop
        vertex 14.061796188354492 -8.166666984558105 -0.625
        vertex 14.061796188354492 -8.166666984558105 -5.208700180053711
        vertex 13.531780242919922 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.8835670948028564 0.4683046340942383 1.0775714926952794e-16
    outer loop
        vertex 9.998337745666504 -0.5 -0.625
        vertex 9.998337745666504 -0.5 -5.208700180053711
        vertex 9.468321800231934 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.8835669755935669 0.4683047831058502 1.8148578220451882e-16
    outer loop
        vertex 5.934879779815674 7.166666507720947 -0.625
        vertex 5.934879779815674 7.166666507720947 -5.208700180053711
        vertex 5.404863357543945 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.8835669159889221 0.4683048725128174 1.8148582190918823e-16
    outer loop
        vertex 1.871421217918396 14.833333015441895 -0.625
        vertex 1.871421217918396 14.833333015441895 -5.208700180053711
        vertex 1.341404914855957 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.8835670948028564 0.4683046340942383 -1.5615675863500655e-07
    outer loop
        vertex 20.423982620239258 -20.170421600341797 -5.208700180053711
        vertex 21.6586971282959 -22.5 -0.625
        vertex 22.18871307373047 -23.5 -0.625
    endloop
endfacet
facet normal 0.8835669159889221 0.46830490231513977 -0.0
    outer loop
        vertex -2.7220535278320312 23.5 -0.625
        vertex -4.047094345092773 26.0 -0.625
        vertex -4.047094345092773 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835669159889221 0.46830490231513977 0.0
    outer loop
        vertex -4.047094345092773 26.0 5.773159728050814e-15
        vertex 23.51375389099121 -26.0 -5.773159728050814e-15
        vertex 23.51375389099121 -26.0 -0.625
    endloop
endfacet
facet normal 0.8835670948028564 0.4683046340942383 1.8148572926495962e-16
    outer loop
        vertex 18.125255584716797 -15.833333015441895 -0.625
        vertex 18.125255584716797 -15.833333015441895 -5.208700180053711
        vertex 17.595239639282227 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.8835671544075012 0.46830445528030396 9.074282492781041e-17
    outer loop
        vertex 14.061796188354492 -8.166666984558105 -0.625
        vertex 13.531780242919922 -7.166666507720947 -5.208700180053711
        vertex 13.531780242919922 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.8835670948028564 0.4683046340942383 1.0208572105717856e-16
    outer loop
        vertex 9.998337745666504 -0.5 -0.625
        vertex 9.468321800231934 0.5 -5.208700180053711
        vertex 9.468321800231934 0.5 -0.625
    endloop
endfacet
facet normal 0.8835669755935669 0.4683047831058502 1.8148578220451882e-16
    outer loop
        vertex 5.934879779815674 7.166666507720947 -0.625
        vertex 5.404863357543945 8.166666984558105 -5.208700180053711
        vertex 5.404863357543945 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8835669159889221 0.4683048725128174 1.8148582190918823e-16
    outer loop
        vertex 1.871421217918396 14.833333015441895 -0.625
        vertex 1.341404914855957 15.833333015441895 -5.208700180053711
        vertex 1.341404914855957 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8835667371749878 0.4683052599430084 4.333352308094618e-07
    outer loop
        vertex 20.423982620239258 -20.170421600341797 -5.208700180053711
        vertex 22.18871307373047 -23.5 -0.625
        vertex 20.830547332763672 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835669755935669 0.4683048129081726 7.495235422538826e-06
    outer loop
        vertex -4.047094345092773 26.0 5.773159728050814e-15
        vertex 23.51375389099121 -26.0 -0.625
        vertex 18.125255584716797 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8835670948028564 0.4683046340942383 1.8148572926495962e-16
    outer loop
        vertex 18.125255584716797 -15.833333015441895 -0.625
        vertex 17.595239639282227 -14.833333015441895 -5.208700180053711
        vertex 17.595239639282227 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8835669159889221 0.46830490231513977 1.2260996982149663e-06
    outer loop
        vertex -0.9573229551315308 20.170421600341797 -5.208700180053711
        vertex 20.423982620239258 -20.170421600341797 -5.208700180053711
        vertex 20.830547332763672 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835670948028564 0.4683046340942383 2.3157870600698516e-05
    outer loop
        vertex -4.047094345092773 26.0 5.773159728050814e-15
        vertex 18.125255584716797 -15.833333015441895 -0.625
        vertex 17.595239639282227 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8835669159889221 0.46830490231513977 6.237518732632452e-07
    outer loop
        vertex -0.9573229551315308 20.170421600341797 -5.208700180053711
        vertex 20.830547332763672 -20.9375 -5.666999816894531
        vertex -1.3638867139816284 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835668563842773 0.4683050513267517 -1.2791283552360255e-05
    outer loop
        vertex -4.047094345092773 26.0 5.773159728050814e-15
        vertex 17.595239639282227 -14.833333015441895 -0.625
        vertex 14.061796188354492 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8835670351982117 0.46830466389656067 7.784630895457667e-08
    outer loop
        vertex -2.1920371055603027 22.5 -0.625
        vertex -0.9573229551315308 20.170421600341797 -5.208700180053711
        vertex -1.3638867139816284 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835671544075012 0.46830445528030396 2.9495960916392505e-05
    outer loop
        vertex -4.047094345092773 26.0 5.773159728050814e-15
        vertex 14.061796188354492 -8.166666984558105 -0.625
        vertex 13.531780242919922 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.8835669159889221 0.46830496191978455 -4.700339673036069e-08
    outer loop
        vertex -2.1920371055603027 22.5 -0.625
        vertex -1.3638867139816284 20.9375 -5.666999816894531
        vertex -2.7220535278320312 23.5 -0.625
    endloop
endfacet
facet normal 0.8835669159889221 0.46830493211746216 -3.0687231173942564e-06
    outer loop
        vertex -4.047094345092773 26.0 5.773159728050814e-15
        vertex 13.531780242919922 -7.166666507720947 -0.625
        vertex 9.998337745666504 -0.5 -0.625
    endloop
endfacet
facet normal 0.8835669159889221 0.46830496191978455 -3.3705401847328176e-07
    outer loop
        vertex -2.1920371055603027 22.5 -0.625
        vertex -2.7220535278320312 23.5 -0.625
        vertex -4.047094345092773 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835670948028564 0.4683046340942383 1.3482163922162727e-05
    outer loop
        vertex -4.047094345092773 26.0 5.773159728050814e-15
        vertex 9.998337745666504 -0.5 -0.625
        vertex 9.468321800231934 0.5 -0.625
    endloop
endfacet
facet normal 0.8835669755935669 0.4683048725128174 3.778414168209565e-07
    outer loop
        vertex 1.341404914855957 15.833333015441895 -0.625
        vertex -2.1920371055603027 22.5 -0.625
        vertex -4.047094345092773 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835669159889221 0.46830490231513977 1.3430201306618983e-07
    outer loop
        vertex -4.047094345092773 26.0 5.773159728050814e-15
        vertex 9.468321800231934 0.5 -0.625
        vertex 5.934879779815674 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.8835669159889221 0.4683048725128174 1.4598350972505614e-08
    outer loop
        vertex 1.871421217918396 14.833333015441895 -0.625
        vertex 1.341404914855957 15.833333015441895 -0.625
        vertex -4.047094345092773 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835669755935669 0.4683047831058502 4.025750513392268e-06
    outer loop
        vertex -4.047094345092773 26.0 5.773159728050814e-15
        vertex 5.934879779815674 7.166666507720947 -0.625
        vertex 5.404863357543945 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8835669159889221 0.46830493211746216 -1.0656283393473132e-06
    outer loop
        vertex 5.404863357543945 8.166666984558105 -0.625
        vertex 1.871421217918396 14.833333015441895 -0.625
        vertex -4.047094345092773 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835671544075012 0.46830445528030396 1.8148564985562081e-16
    outer loop
        vertex 14.061796188354492 -8.166666984558105 -0.625
        vertex 14.061796188354492 -8.166666984558105 -5.208700180053711
        vertex 13.531780242919922 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.8835670948028564 0.4683046340942383 1.0775714926952794e-16
    outer loop
        vertex 9.998337745666504 -0.5 -0.625
        vertex 9.998337745666504 -0.5 -5.208700180053711
        vertex 9.468321800231934 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.8835669755935669 0.4683047831058502 1.8148578220451882e-16
    outer loop
        vertex 5.934879779815674 7.166666507720947 -0.625
        vertex 5.934879779815674 7.166666507720947 -5.208700180053711
        vertex 5.404863357543945 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.8835669159889221 0.4683048725128174 1.8148582190918823e-16
    outer loop
        vertex 1.871421217918396 14.833333015441895 -0.625
        vertex 1.871421217918396 14.833333015441895 -5.208700180053711
        vertex 1.341404914855957 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.8835670948028564 0.4683046340942383 -1.5615675863500655e-07
    outer loop
        vertex 20.423982620239258 -20.170421600341797 -5.208700180053711
        vertex 21.6586971282959 -22.5 -0.625
        vertex 22.18871307373047 -23.5 -0.625
    endloop
endfacet
facet normal 0.8835669159889221 0.46830490231513977 -0.0
    outer loop
        vertex -2.7220535278320312 23.5 -0.625
        vertex -4.047094345092773 26.0 -0.625
        vertex -4.047094345092773 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835669159889221 0.46830490231513977 0.0
    outer loop
        vertex -4.047094345092773 26.0 5.773159728050814e-15
        vertex 23.51375389099121 -26.0 -5.773159728050814e-15
        vertex 23.51375389099121 -26.0 -0.625
    endloop
endfacet
facet normal 0.8835670948028564 0.4683046340942383 1.8148572926495962e-16
    outer loop
        vertex 18.125255584716797 -15.833333015441895 -0.625
        vertex 18.125255584716797 -15.833333015441895 -5.208700180053711
        vertex 17.595239639282227 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.8835671544075012 0.46830445528030396 9.074282492781041e-17
    outer loop
        vertex 14.061796188354492 -8.166666984558105 -0.625
        vertex 13.531780242919922 -7.166666507720947 -5.208700180053711
        vertex 13.531780242919922 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.8835670948028564 0.4683046340942383 1.0208572105717856e-16
    outer loop
        vertex 9.998337745666504 -0.5 -0.625
        vertex 9.468321800231934 0.5 -5.208700180053711
        vertex 9.468321800231934 0.5 -0.625
    endloop
endfacet
facet normal 0.8835669755935669 0.4683047831058502 1.8148578220451882e-16
    outer loop
        vertex 5.934879779815674 7.166666507720947 -0.625
        vertex 5.404863357543945 8.166666984558105 -5.208700180053711
        vertex 5.404863357543945 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8835669159889221 0.4683048725128174 1.8148582190918823e-16
    outer loop
        vertex 1.871421217918396 14.833333015441895 -0.625
        vertex 1.341404914855957 15.833333015441895 -5.208700180053711
        vertex 1.341404914855957 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8835667371749878 0.4683052599430084 4.333352308094618e-07
    outer loop
        vertex 20.423982620239258 -20.170421600341797 -5.208700180053711
        vertex 22.18871307373047 -23.5 -0.625
        vertex 20.830547332763672 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835669755935669 0.4683048129081726 7.495235422538826e-06
    outer loop
        vertex -4.047094345092773 26.0 5.773159728050814e-15
        vertex 23.51375389099121 -26.0 -0.625
        vertex 18.125255584716797 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8835670948028564 0.4683046340942383 1.8148572926495962e-16
    outer loop
        vertex 18.125255584716797 -15.833333015441895 -0.625
        vertex 17.595239639282227 -14.833333015441895 -5.208700180053711
        vertex 17.595239639282227 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8835669159889221 0.46830490231513977 1.2260996982149663e-06
    outer loop
        vertex -0.9573229551315308 20.170421600341797 -5.208700180053711
        vertex 20.423982620239258 -20.170421600341797 -5.208700180053711
        vertex 20.830547332763672 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835670948028564 0.4683046340942383 2.3157870600698516e-05
    outer loop
        vertex -4.047094345092773 26.0 5.773159728050814e-15
        vertex 18.125255584716797 -15.833333015441895 -0.625
        vertex 17.595239639282227 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8835669159889221 0.46830490231513977 6.237518732632452e-07
    outer loop
        vertex -0.9573229551315308 20.170421600341797 -5.208700180053711
        vertex 20.830547332763672 -20.9375 -5.666999816894531
        vertex -1.3638867139816284 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835668563842773 0.4683050513267517 -1.2791283552360255e-05
    outer loop
        vertex -4.047094345092773 26.0 5.773159728050814e-15
        vertex 17.595239639282227 -14.833333015441895 -0.625
        vertex 14.061796188354492 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8835670351982117 0.46830466389656067 7.784630895457667e-08
    outer loop
        vertex -2.1920371055603027 22.5 -0.625
        vertex -0.9573229551315308 20.170421600341797 -5.208700180053711
        vertex -1.3638867139816284 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8835671544075012 0.46830445528030396 2.9495960916392505e-05
    outer loop
        vertex -4.047094345092773 26.0 5.773159728050814e-15
        vertex 14.061796188354492 -8.166666984558105 -0.625
        vertex 13.531780242919922 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.8835669159889221 0.46830496191978455 -4.700339673036069e-08
    outer loop
        vertex -2.1920371055603027 22.5 -0.625
        vertex -1.3638867139816284 20.9375 -5.666999816894531
        vertex -2.7220535278320312 23.5 -0.625
    endloop
endfacet
facet normal 0.8835669159889221 0.46830493211746216 -3.0687231173942564e-06
    outer loop
        vertex -4.047094345092773 26.0 5.773159728050814e-15
        vertex 13.531780242919922 -7.166666507720947 -0.625
        vertex 9.998337745666504 -0.5 -0.625
    endloop
endfacet
facet normal 0.8835669159889221 0.46830496191978455 -3.3705401847328176e-07
    outer loop
        vertex -2.1920371055603027 22.5 -0.625
        vertex -2.7220535278320312 23.5 -0.625
        vertex -4.047094345092773 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835670948028564 0.4683046340942383 1.3482163922162727e-05
    outer loop
        vertex -4.047094345092773 26.0 5.773159728050814e-15
        vertex 9.998337745666504 -0.5 -0.625
        vertex 9.468321800231934 0.5 -0.625
    endloop
endfacet
facet normal 0.8835669755935669 0.4683048725128174 3.778414168209565e-07
    outer loop
        vertex 1.341404914855957 15.833333015441895 -0.625
        vertex -2.1920371055603027 22.5 -0.625
        vertex -4.047094345092773 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835669159889221 0.46830490231513977 1.3430201306618983e-07
    outer loop
        vertex -4.047094345092773 26.0 5.773159728050814e-15
        vertex 9.468321800231934 0.5 -0.625
        vertex 5.934879779815674 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.8835669159889221 0.4683048725128174 1.4598350972505614e-08
    outer loop
        vertex 1.871421217918396 14.833333015441895 -0.625
        vertex 1.341404914855957 15.833333015441895 -0.625
        vertex -4.047094345092773 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8835669755935669 0.4683047831058502 4.025750513392268e-06
    outer loop
        vertex -4.047094345092773 26.0 5.773159728050814e-15
        vertex 5.934879779815674 7.166666507720947 -0.625
        vertex 5.404863357543945 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8835669159889221 0.46830493211746216 -1.0656283393473132e-06
    outer loop
        vertex 5.404863357543945 8.166666984558105 -0.625
        vertex 1.871421217918396 14.833333015441895 -0.625
        vertex -4.047094345092773 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8515531420707703 0.5242683291435242 2.0317376965138956e-16
    outer loop
        vertex 5.027902126312256 -8.166666984558105 -0.625
        vertex 5.027902126312256 -8.166666984558105 -5.208700180053711
        vertex 4.412240505218506 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.8515530824661255 0.5242684483528137 1.2063444558284726e-16
    outer loop
        vertex 0.3078307509422302 -0.5 -0.625
        vertex 0.3078307509422302 -0.5 -5.208700180053711
        vertex -0.3078307509422302 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.8515531420707703 0.5242683291435242 2.0317376965138956e-16
    outer loop
        vertex -4.412240505218506 7.166666507720947 -0.625
        vertex -4.412240505218506 7.166666507720947 -5.208700180053711
        vertex -5.027902126312256 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 2.0317383582583857e-16
    outer loop
        vertex -9.132311820983887 14.833333015441895 -0.625
        vertex -9.132311820983887 14.833333015441895 -5.208700180053711
        vertex -9.747973442077637 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.8515533804893494 0.5242679119110107 -3.6519949730973167e-07
    outer loop
        vertex 12.41815185546875 -20.170421600341797 -5.208700180053711
        vertex 13.852383613586426 -22.5 -0.625
        vertex 14.46804428100586 -23.5 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 -0.0
    outer loop
        vertex -14.46804428100586 23.5 -0.625
        vertex -16.007198333740234 26.0 -0.625
        vertex -16.007198333740234 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8515530824661255 0.524268388748169 0.0
    outer loop
        vertex -16.007198333740234 26.0 5.773159728050814e-15
        vertex 16.007198333740234 -26.0 -5.773159728050814e-15
        vertex 16.007198333740234 -26.0 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 2.0317383582583857e-16
    outer loop
        vertex 9.747973442077637 -15.833333015441895 -0.625
        vertex 9.747973442077637 -15.833333015441895 -5.208700180053711
        vertex 9.132311820983887 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.8515531420707703 0.5242683291435242 1.0158688482569478e-16
    outer loop
        vertex 5.027902126312256 -8.166666984558105 -0.625
        vertex 4.412240505218506 -7.166666507720947 -5.208700180053711
        vertex 4.412240505218506 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.8515530824661255 0.5242684483528137 1.1428527189868623e-16
    outer loop
        vertex 0.3078307509422302 -0.5 -0.625
        vertex -0.3078307509422302 0.5 -5.208700180053711
        vertex -0.3078307509422302 0.5 -0.625
    endloop
endfacet
facet normal 0.8515531420707703 0.5242683291435242 2.0317376965138956e-16
    outer loop
        vertex -4.412240505218506 7.166666507720947 -0.625
        vertex -5.027902126312256 8.166666984558105 -5.208700180053711
        vertex -5.027902126312256 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 2.0317383582583857e-16
    outer loop
        vertex -9.132311820983887 14.833333015441895 -0.625
        vertex -9.747973442077637 15.833333015441895 -5.208700180053711
        vertex -9.747973442077637 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8515531420707703 0.5242682695388794 1.2810147609343403e-08
    outer loop
        vertex 12.41815185546875 -20.170421600341797 -5.208700180053711
        vertex 14.46804428100586 -23.5 -0.625
        vertex 12.890412330627441 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8515530824661255 0.524268388748169 2.0455186131584924e-06
    outer loop
        vertex -16.007198333740234 26.0 5.773159728050814e-15
        vertex 16.007198333740234 -26.0 -0.625
        vertex 9.747973442077637 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 2.0317383582583857e-16
    outer loop
        vertex 9.747973442077637 -15.833333015441895 -0.625
        vertex 9.132311820983887 -14.833333015441895 -5.208700180053711
        vertex 9.132311820983887 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8515530824661255 0.5242684483528137 -2.913597256792855e-07
    outer loop
        vertex -12.41815185546875 20.170421600341797 -5.208700180053711
        vertex 12.41815185546875 -20.170421600341797 -5.208700180053711
        vertex 12.890412330627441 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 -7.962666131788865e-06
    outer loop
        vertex -16.007198333740234 26.0 5.773159728050814e-15
        vertex 9.747973442077637 -15.833333015441895 -0.625
        vertex 9.132311820983887 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.8515530824661255 0.5242684483528137 2.8068529900338035e-07
    outer loop
        vertex -12.41815185546875 20.170421600341797 -5.208700180053711
        vertex 12.890412330627441 -20.9375 -5.666999816894531
        vertex -12.890412330627441 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8515530824661255 0.5242684483528137 -1.9441524727881188e-06
    outer loop
        vertex -16.007198333740234 26.0 5.773159728050814e-15
        vertex 9.132311820983887 -14.833333015441895 -0.625
        vertex 5.027902126312256 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8515531420707703 0.5242683291435242 7.42767980455028e-08
    outer loop
        vertex -13.852383613586426 22.5 -0.625
        vertex -12.41815185546875 20.170421600341797 -5.208700180053711
        vertex -12.890412330627441 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.8515531420707703 0.5242683291435242 6.686101187369786e-06
    outer loop
        vertex -16.007198333740234 26.0 5.773159728050814e-15
        vertex 5.027902126312256 -8.166666984558105 -0.625
        vertex 4.412240505218506 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.8515533804893494 0.5242679119110107 2.5166866635117913e-07
    outer loop
        vertex -13.852383613586426 22.5 -0.625
        vertex -12.890412330627441 20.9375 -5.666999816894531
        vertex -14.46804428100586 23.5 -0.625
    endloop
endfacet
facet normal 0.8515530824661255 0.5242684483528137 -1.0565571528786677e-07
    outer loop
        vertex -16.007198333740234 26.0 5.773159728050814e-15
        vertex 4.412240505218506 -7.166666507720947 -0.625
        vertex 0.3078307509422302 -0.5 -0.625
    endloop
endfacet
facet normal 0.8515533804893494 0.5242679119110107 3.2484183520864462e-06
    outer loop
        vertex -13.852383613586426 22.5 -0.625
        vertex -14.46804428100586 23.5 -0.625
        vertex -16.007198333740234 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8515530824661255 0.5242684483528137 -9.745251645654207e-07
    outer loop
        vertex -16.007198333740234 26.0 5.773159728050814e-15
        vertex 0.3078307509422302 -0.5 -0.625
        vertex -0.3078307509422302 0.5 -0.625
    endloop
endfacet
facet normal 0.8515530824661255 0.5242684483528137 -7.045936740723846e-07
    outer loop
        vertex -9.747973442077637 15.833333015441895 -0.625
        vertex -13.852383613586426 22.5 -0.625
        vertex -16.007198333740234 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8515530824661255 0.5242684483528137 -1.38443240871311e-07
    outer loop
        vertex -16.007198333740234 26.0 5.773159728050814e-15
        vertex -0.3078307509422302 0.5 -0.625
        vertex -4.412240505218506 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.8515530228614807 0.5242685079574585 -2.4322680474142544e-06
    outer loop
        vertex -9.132311820983887 14.833333015441895 -0.625
        vertex -9.747973442077637 15.833333015441895 -0.625
        vertex -16.007198333740234 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.8515531420707703 0.5242683291435242 3.7181825973675586e-06
    outer loop
        vertex -16.007198333740234 26.0 5.773159728050814e-15
        vertex -4.412240505218506 7.166666507720947 -0.625
        vertex -5.027902126312256 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.8515530824661255 0.5242684483528137 -7.863887390158197e-07
    outer loop
        vertex -5.027902126312256 8.166666984558105 -0.625
        vertex -9.132311820983887 14.833333015441895 -0.625
        vertex -16.007198333740234 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.220446049250313e-16 -1.0
    outer loop
        vertex 16.007198333740234 -26.0 -5.773159728050814e-15
        vertex -4.047094345092773 26.0 5.773159728050814e-15
        vertex 23.51375389099121 -26.0 -5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.220446049250313e-16 -1.0
    outer loop
        vertex 16.007198333740234 -26.0 -5.773159728050814e-15
        vertex -16.007198333740234 26.0 5.773159728050814e-15
        vertex -4.047094345092773 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex -16.007198333740234 26.0 5.773159728050814e-15
        vertex -4.047094345092773 26.0 -0.625
        vertex -4.047094345092773 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex -16.007198333740234 26.0 5.773159728050814e-15
        vertex -16.007198333740234 26.0 -0.625
        vertex -4.047094345092773 26.0 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex -16.007198333740234 26.0 -0.625
        vertex -2.7220535278320312 23.5 -0.625
        vertex -4.047094345092773 26.0 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex -16.007198333740234 26.0 -0.625
        vertex -14.46804428100586 23.5 -0.625
        vertex -2.7220535278320312 23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex -14.46804428100586 23.5 -0.625
        vertex -2.7220535278320312 23.5 -0.625
        vertex -2.7220535278320312 23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex -14.46804428100586 23.5 -0.625
        vertex -14.46804428100586 23.5 -0.625
        vertex -2.7220535278320312 23.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 0.45307403802871704
    outer loop
        vertex -14.46804428100586 23.5 -0.625
        vertex -1.3638867139816284 20.9375 -5.666999816894531
        vertex -2.7220535278320312 23.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 0.45307403802871704
    outer loop
        vertex -14.46804428100586 23.5 -0.625
        vertex -12.890412330627441 20.9375 -5.666999816894531
        vertex -1.3638867139816284 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 -2.1210230424372774e-16 1.0
    outer loop
        vertex -12.890412330627441 20.9375 -5.666999816894531
        vertex 20.830547332763672 -20.9375 -5.666999816894531
        vertex -1.3638867139816284 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 -2.1210230424372774e-16 1.0
    outer loop
        vertex -12.890412330627441 20.9375 -5.666999816894531
        vertex 12.890412330627441 -20.9375 -5.666999816894531
        vertex 20.830547332763672 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 0.8914728760719299 0.45307403802871704
    outer loop
        vertex 12.890412330627441 -20.9375 -5.666999816894531
        vertex 22.18871307373047 -23.5 -0.625
        vertex 20.830547332763672 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal -0.0 0.8914728760719299 0.45307403802871704
    outer loop
        vertex 12.890412330627441 -20.9375 -5.666999816894531
        vertex 14.46804428100586 -23.5 -0.625
        vertex 22.18871307373047 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 14.46804428100586 -23.5 -0.625
        vertex 22.18871307373047 -23.5 -0.625
        vertex 22.18871307373047 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 14.46804428100586 -23.5 -0.625
        vertex 14.46804428100586 -23.5 -0.625
        vertex 22.18871307373047 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 14.46804428100586 -23.5 -0.625
        vertex 23.51375389099121 -26.0 -0.625
        vertex 22.18871307373047 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 14.46804428100586 -23.5 -0.625
        vertex 16.007198333740234 -26.0 -0.625
        vertex 23.51375389099121 -26.0 -0.625
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 16.007198333740234 -26.0 -0.625
        vertex 23.51375389099121 -26.0 -5.773159728050814e-15
        vertex 23.51375389099121 -26.0 -0.625
    endloop
endfacet
facet normal 0.0 1.0 0.0
    outer loop
        vertex 16.007198333740234 -26.0 -0.625
        vertex 16.007198333740234 -26.0 -5.773159728050814e-15
        vertex 23.51375389099121 -26.0 -5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 12.41815185546875 -20.170421600341797 -5.208700180053711
        vertex 18.125255584716797 -15.833333015441895 -5.208700180053711
        vertex 20.423982620239258 -20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 12.41815185546875 -20.170421600341797 -5.208700180053711
        vertex 9.747973442077637 -15.833333015441895 -5.208700180053711
        vertex 18.125255584716797 -15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 9.747973442077637 -15.833333015441895 -5.208700180053711
        vertex 18.125255584716797 -15.833333015441895 -0.625
        vertex 18.125255584716797 -15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 9.747973442077637 -15.833333015441895 -5.208700180053711
        vertex 9.747973442077637 -15.833333015441895 -0.625
        vertex 18.125255584716797 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 9.747973442077637 -15.833333015441895 -0.625
        vertex 21.6586971282959 -22.5 -0.625
        vertex 18.125255584716797 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 9.747973442077637 -15.833333015441895 -0.625
        vertex 13.852383613586426 -22.5 -0.625
        vertex 21.6586971282959 -22.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 13.852383613586426 -22.5 -0.625
        vertex 20.423982620239258 -20.170421600341797 -5.208700180053711
        vertex 21.6586971282959 -22.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 13.852383613586426 -22.5 -0.625
        vertex 12.41815185546875 -20.170421600341797 -5.208700180053711
        vertex 20.423982620239258 -20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 9.132311820983887 -14.833333015441895 -5.208700180053711
        vertex 14.061796188354492 -8.166666984558105 -5.208700180053711
        vertex 17.595239639282227 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 9.132311820983887 -14.833333015441895 -5.208700180053711
        vertex 5.027902126312256 -8.166666984558105 -5.208700180053711
        vertex 14.061796188354492 -8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 5.027902126312256 -8.166666984558105 -5.208700180053711
        vertex 14.061796188354492 -8.166666984558105 -0.625
        vertex 14.061796188354492 -8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 5.027902126312256 -8.166666984558105 -5.208700180053711
        vertex 5.027902126312256 -8.166666984558105 -0.625
        vertex 14.061796188354492 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 5.027902126312256 -8.166666984558105 -0.625
        vertex 17.595239639282227 -14.833333015441895 -0.625
        vertex 14.061796188354492 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 5.027902126312256 -8.166666984558105 -0.625
        vertex 9.132311820983887 -14.833333015441895 -0.625
        vertex 17.595239639282227 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 9.132311820983887 -14.833333015441895 -0.625
        vertex 17.595239639282227 -14.833333015441895 -5.208700180053711
        vertex 17.595239639282227 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 9.132311820983887 -14.833333015441895 -0.625
        vertex 9.132311820983887 -14.833333015441895 -5.208700180053711
        vertex 17.595239639282227 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 4.412240505218506 -7.166666507720947 -5.208700180053711
        vertex 9.998337745666504 -0.5 -5.208700180053711
        vertex 13.531780242919922 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 4.412240505218506 -7.166666507720947 -5.208700180053711
        vertex 0.3078307509422302 -0.5 -5.208700180053711
        vertex 9.998337745666504 -0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 2.3010054999790975e-16
    outer loop
        vertex 0.3078307509422302 -0.5 -5.208700180053711
        vertex 9.998337745666504 -0.5 -0.625
        vertex 9.998337745666504 -0.5 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 2.3010054999790975e-16
    outer loop
        vertex 0.3078307509422302 -0.5 -5.208700180053711
        vertex 0.3078307509422302 -0.5 -0.625
        vertex 9.998337745666504 -0.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 0.3078307509422302 -0.5 -0.625
        vertex 13.531780242919922 -7.166666507720947 -0.625
        vertex 9.998337745666504 -0.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 0.3078307509422302 -0.5 -0.625
        vertex 4.412240505218506 -7.166666507720947 -0.625
        vertex 13.531780242919922 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -1.9376887167044945e-16
    outer loop
        vertex 4.412240505218506 -7.166666507720947 -0.625
        vertex 13.531780242919922 -7.166666507720947 -5.208700180053711
        vertex 13.531780242919922 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -1.9376887167044945e-16
    outer loop
        vertex 4.412240505218506 -7.166666507720947 -0.625
        vertex 4.412240505218506 -7.166666507720947 -5.208700180053711
        vertex 13.531780242919922 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex -0.3078307509422302 0.5 -5.208700180053711
        vertex 5.934879779815674 7.166666507720947 -5.208700180053711
        vertex 9.468321800231934 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex -0.3078307509422302 0.5 -5.208700180053711
        vertex -4.412240505218506 7.166666507720947 -5.208700180053711
        vertex 5.934879779815674 7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex -4.412240505218506 7.166666507720947 -5.208700180053711
        vertex 5.934879779815674 7.166666507720947 -0.625
        vertex 5.934879779815674 7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex -4.412240505218506 7.166666507720947 -5.208700180053711
        vertex -4.412240505218506 7.166666507720947 -0.625
        vertex 5.934879779815674 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex -4.412240505218506 7.166666507720947 -0.625
        vertex 9.468321800231934 0.5 -0.625
        vertex 5.934879779815674 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex -4.412240505218506 7.166666507720947 -0.625
        vertex -0.3078307509422302 0.5 -0.625
        vertex 9.468321800231934 0.5 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -2.1798997732053318e-16
    outer loop
        vertex -0.3078307509422302 0.5 -0.625
        vertex 9.468321800231934 0.5 -5.208700180053711
        vertex 9.468321800231934 0.5 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -2.1798997732053318e-16
    outer loop
        vertex -0.3078307509422302 0.5 -0.625
        vertex -0.3078307509422302 0.5 -5.208700180053711
        vertex 9.468321800231934 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex -5.027902126312256 8.166666984558105 -5.208700180053711
        vertex 1.871421217918396 14.833333015441895 -5.208700180053711
        vertex 5.404863357543945 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex -5.027902126312256 8.166666984558105 -5.208700180053711
        vertex -9.132311820983887 14.833333015441895 -5.208700180053711
        vertex 1.871421217918396 14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex -9.132311820983887 14.833333015441895 -5.208700180053711
        vertex 1.871421217918396 14.833333015441895 -0.625
        vertex 1.871421217918396 14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex -9.132311820983887 14.833333015441895 -5.208700180053711
        vertex -9.132311820983887 14.833333015441895 -0.625
        vertex 1.871421217918396 14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex -9.132311820983887 14.833333015441895 -0.625
        vertex 5.404863357543945 8.166666984558105 -0.625
        vertex 1.871421217918396 14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex -9.132311820983887 14.833333015441895 -0.625
        vertex -5.027902126312256 8.166666984558105 -0.625
        vertex 5.404863357543945 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex -5.027902126312256 8.166666984558105 -0.625
        vertex 5.404863357543945 8.166666984558105 -5.208700180053711
        vertex 5.404863357543945 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex -5.027902126312256 8.166666984558105 -0.625
        vertex -5.027902126312256 8.166666984558105 -5.208700180053711
        vertex 5.404863357543945 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex -9.747973442077637 15.833333015441895 -5.208700180053711
        vertex -0.9573229551315308 20.170421600341797 -5.208700180053711
        vertex 1.341404914855957 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex -9.747973442077637 15.833333015441895 -5.208700180053711
        vertex -12.41815185546875 20.170421600341797 -5.208700180053711
        vertex -0.9573229551315308 20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 0.8914728760719299 -0.4530741274356842
    outer loop
        vertex -12.41815185546875 20.170421600341797 -5.208700180053711
        vertex -2.1920371055603027 22.5 -0.625
        vertex -0.9573229551315308 20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 0.8914728760719299 -0.4530741274356842
    outer loop
        vertex -12.41815185546875 20.170421600341797 -5.208700180053711
        vertex -13.852383613586426 22.5 -0.625
        vertex -2.1920371055603027 22.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex -13.852383613586426 22.5 -0.625
        vertex 1.341404914855957 15.833333015441895 -0.625
        vertex -2.1920371055603027 22.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex -13.852383613586426 22.5 -0.625
        vertex -9.747973442077637 15.833333015441895 -0.625
        vertex 1.341404914855957 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex -9.747973442077637 15.833333015441895 -0.625
        vertex 1.341404914855957 15.833333015441895 -5.208700180053711
        vertex 1.341404914855957 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex -9.747973442077637 15.833333015441895 -0.625
        vertex -9.747973442077637 15.833333015441895 -5.208700180053711
        vertex 1.341404914855957 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.220446049250313e-16 -1.0
    outer loop
        vertex 23.51375389099121 -26.0 -5.773159728050814e-15
        vertex 8.43100643157959 26.0 5.773159728050814e-15
        vertex 30.50239372253418 -26.0 -5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.220446049250313e-16 -1.0
    outer loop
        vertex 23.51375389099121 -26.0 -5.773159728050814e-15
        vertex -4.047094345092773 26.0 5.773159728050814e-15
        vertex 8.43100643157959 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex -4.047094345092773 26.0 5.773159728050814e-15
        vertex 8.43100643157959 26.0 -0.625
        vertex 8.43100643157959 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex -4.047094345092773 26.0 5.773159728050814e-15
        vertex -4.047094345092773 26.0 -0.625
        vertex 8.43100643157959 26.0 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex -4.047094345092773 26.0 -0.625
        vertex 9.492131233215332 23.5 -0.625
        vertex 8.43100643157959 26.0 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex -4.047094345092773 26.0 -0.625
        vertex -2.7220535278320312 23.5 -0.625
        vertex 9.492131233215332 23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex -2.7220535278320312 23.5 -0.625
        vertex 9.492131233215332 23.5 -0.625
        vertex 9.492131233215332 23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex -2.7220535278320312 23.5 -0.625
        vertex -2.7220535278320312 23.5 -0.625
        vertex 9.492131233215332 23.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 0.45307403802871704
    outer loop
        vertex -2.7220535278320312 23.5 -0.625
        vertex 10.57978343963623 20.9375 -5.666999816894531
        vertex 9.492131233215332 23.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 0.45307403802871704
    outer loop
        vertex -2.7220535278320312 23.5 -0.625
        vertex -1.3638867139816284 20.9375 -5.666999816894531
        vertex 10.57978343963623 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 -2.1210230424372774e-16 1.0
    outer loop
        vertex -1.3638867139816284 20.9375 -5.666999816894531
        vertex 28.35361671447754 -20.9375 -5.666999816894531
        vertex 10.57978343963623 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 -2.1210230424372774e-16 1.0
    outer loop
        vertex -1.3638867139816284 20.9375 -5.666999816894531
        vertex 20.830547332763672 -20.9375 -5.666999816894531
        vertex 28.35361671447754 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 0.8914728760719299 0.45307403802871704
    outer loop
        vertex 20.830547332763672 -20.9375 -5.666999816894531
        vertex 29.441268920898438 -23.5 -0.625
        vertex 28.35361671447754 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal -0.0 0.8914728760719299 0.45307403802871704
    outer loop
        vertex 20.830547332763672 -20.9375 -5.666999816894531
        vertex 22.18871307373047 -23.5 -0.625
        vertex 29.441268920898438 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 22.18871307373047 -23.5 -0.625
        vertex 29.441268920898438 -23.5 -0.625
        vertex 29.441268920898438 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 22.18871307373047 -23.5 -0.625
        vertex 22.18871307373047 -23.5 -0.625
        vertex 29.441268920898438 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 22.18871307373047 -23.5 -0.625
        vertex 30.50239372253418 -26.0 -0.625
        vertex 29.441268920898438 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 22.18871307373047 -23.5 -0.625
        vertex 23.51375389099121 -26.0 -0.625
        vertex 30.50239372253418 -26.0 -0.625
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 23.51375389099121 -26.0 -0.625
        vertex 30.50239372253418 -26.0 -5.773159728050814e-15
        vertex 30.50239372253418 -26.0 -0.625
    endloop
endfacet
facet normal 0.0 1.0 0.0
    outer loop
        vertex 23.51375389099121 -26.0 -0.625
        vertex 23.51375389099121 -26.0 -5.773159728050814e-15
        vertex 30.50239372253418 -26.0 -5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 20.423982620239258 -20.170421600341797 -5.208700180053711
        vertex 26.18715476989746 -15.833333015441895 -5.208700180053711
        vertex 28.028030395507812 -20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 20.423982620239258 -20.170421600341797 -5.208700180053711
        vertex 18.125255584716797 -15.833333015441895 -5.208700180053711
        vertex 26.18715476989746 -15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 18.125255584716797 -15.833333015441895 -5.208700180053711
        vertex 26.18715476989746 -15.833333015441895 -0.625
        vertex 26.18715476989746 -15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 18.125255584716797 -15.833333015441895 -5.208700180053711
        vertex 18.125255584716797 -15.833333015441895 -0.625
        vertex 26.18715476989746 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 18.125255584716797 -15.833333015441895 -0.625
        vertex 29.01681900024414 -22.5 -0.625
        vertex 26.18715476989746 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 18.125255584716797 -15.833333015441895 -0.625
        vertex 21.6586971282959 -22.5 -0.625
        vertex 29.01681900024414 -22.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 21.6586971282959 -22.5 -0.625
        vertex 28.028030395507812 -20.170421600341797 -5.208700180053711
        vertex 29.01681900024414 -22.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 21.6586971282959 -22.5 -0.625
        vertex 20.423982620239258 -20.170421600341797 -5.208700180053711
        vertex 28.028030395507812 -20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 17.595239639282227 -14.833333015441895 -5.208700180053711
        vertex 22.93303871154785 -8.166666984558105 -5.208700180053711
        vertex 25.762704849243164 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 17.595239639282227 -14.833333015441895 -5.208700180053711
        vertex 14.061796188354492 -8.166666984558105 -5.208700180053711
        vertex 22.93303871154785 -8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 14.061796188354492 -8.166666984558105 -5.208700180053711
        vertex 22.93303871154785 -8.166666984558105 -0.625
        vertex 22.93303871154785 -8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 14.061796188354492 -8.166666984558105 -5.208700180053711
        vertex 14.061796188354492 -8.166666984558105 -0.625
        vertex 22.93303871154785 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 14.061796188354492 -8.166666984558105 -0.625
        vertex 25.762704849243164 -14.833333015441895 -0.625
        vertex 22.93303871154785 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 14.061796188354492 -8.166666984558105 -0.625
        vertex 17.595239639282227 -14.833333015441895 -0.625
        vertex 25.762704849243164 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 17.595239639282227 -14.833333015441895 -0.625
        vertex 25.762704849243164 -14.833333015441895 -5.208700180053711
        vertex 25.762704849243164 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 17.595239639282227 -14.833333015441895 -0.625
        vertex 17.595239639282227 -14.833333015441895 -5.208700180053711
        vertex 25.762704849243164 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 13.531780242919922 -7.166666507720947 -5.208700180053711
        vertex 19.678924560546875 -0.5 -5.208700180053711
        vertex 22.508590698242188 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 13.531780242919922 -7.166666507720947 -5.208700180053711
        vertex 9.998337745666504 -0.5 -5.208700180053711
        vertex 19.678924560546875 -0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 2.3010054999790975e-16
    outer loop
        vertex 9.998337745666504 -0.5 -5.208700180053711
        vertex 19.678924560546875 -0.5 -0.625
        vertex 19.678924560546875 -0.5 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 2.3010054999790975e-16
    outer loop
        vertex 9.998337745666504 -0.5 -5.208700180053711
        vertex 9.998337745666504 -0.5 -0.625
        vertex 19.678924560546875 -0.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 9.998337745666504 -0.5 -0.625
        vertex 22.508590698242188 -7.166666507720947 -0.625
        vertex 19.678924560546875 -0.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 9.998337745666504 -0.5 -0.625
        vertex 13.531780242919922 -7.166666507720947 -0.625
        vertex 22.508590698242188 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -1.9376887167044945e-16
    outer loop
        vertex 13.531780242919922 -7.166666507720947 -0.625
        vertex 22.508590698242188 -7.166666507720947 -5.208700180053711
        vertex 22.508590698242188 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -1.9376887167044945e-16
    outer loop
        vertex 13.531780242919922 -7.166666507720947 -0.625
        vertex 13.531780242919922 -7.166666507720947 -5.208700180053711
        vertex 22.508590698242188 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 9.468321800231934 0.5 -5.208700180053711
        vertex 16.4248104095459 7.166666507720947 -5.208700180053711
        vertex 19.254474639892578 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 9.468321800231934 0.5 -5.208700180053711
        vertex 5.934879779815674 7.166666507720947 -5.208700180053711
        vertex 16.4248104095459 7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 5.934879779815674 7.166666507720947 -5.208700180053711
        vertex 16.4248104095459 7.166666507720947 -0.625
        vertex 16.4248104095459 7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 5.934879779815674 7.166666507720947 -5.208700180053711
        vertex 5.934879779815674 7.166666507720947 -0.625
        vertex 16.4248104095459 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 5.934879779815674 7.166666507720947 -0.625
        vertex 19.254474639892578 0.5 -0.625
        vertex 16.4248104095459 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 5.934879779815674 7.166666507720947 -0.625
        vertex 9.468321800231934 0.5 -0.625
        vertex 19.254474639892578 0.5 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -2.1798997732053318e-16
    outer loop
        vertex 9.468321800231934 0.5 -0.625
        vertex 19.254474639892578 0.5 -5.208700180053711
        vertex 19.254474639892578 0.5 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -2.1798997732053318e-16
    outer loop
        vertex 9.468321800231934 0.5 -0.625
        vertex 9.468321800231934 0.5 -5.208700180053711
        vertex 19.254474639892578 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 5.404863357543945 8.166666984558105 -5.208700180053711
        vertex 13.170695304870605 14.833333015441895 -5.208700180053711
        vertex 16.0003604888916 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 5.404863357543945 8.166666984558105 -5.208700180053711
        vertex 1.871421217918396 14.833333015441895 -5.208700180053711
        vertex 13.170695304870605 14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 1.871421217918396 14.833333015441895 -5.208700180053711
        vertex 13.170695304870605 14.833333015441895 -0.625
        vertex 13.170695304870605 14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 1.871421217918396 14.833333015441895 -5.208700180053711
        vertex 1.871421217918396 14.833333015441895 -0.625
        vertex 13.170695304870605 14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 1.871421217918396 14.833333015441895 -0.625
        vertex 16.0003604888916 8.166666984558105 -0.625
        vertex 13.170695304870605 14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 1.871421217918396 14.833333015441895 -0.625
        vertex 5.404863357543945 8.166666984558105 -0.625
        vertex 16.0003604888916 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 5.404863357543945 8.166666984558105 -0.625
        vertex 16.0003604888916 8.166666984558105 -5.208700180053711
        vertex 16.0003604888916 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 5.404863357543945 8.166666984558105 -0.625
        vertex 5.404863357543945 8.166666984558105 -5.208700180053711
        vertex 16.0003604888916 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 1.341404914855957 15.833333015441895 -5.208700180053711
        vertex 10.905369758605957 20.170421600341797 -5.208700180053711
        vertex 12.746245384216309 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 1.341404914855957 15.833333015441895 -5.208700180053711
        vertex -0.9573229551315308 20.170421600341797 -5.208700180053711
        vertex 10.905369758605957 20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 0.8914728760719299 -0.4530741274356842
    outer loop
        vertex -0.9573229551315308 20.170421600341797 -5.208700180053711
        vertex 9.916581153869629 22.5 -0.625
        vertex 10.905369758605957 20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 0.8914728760719299 -0.4530741274356842
    outer loop
        vertex -0.9573229551315308 20.170421600341797 -5.208700180053711
        vertex -2.1920371055603027 22.5 -0.625
        vertex 9.916581153869629 22.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex -2.1920371055603027 22.5 -0.625
        vertex 12.746245384216309 15.833333015441895 -0.625
        vertex 9.916581153869629 22.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex -2.1920371055603027 22.5 -0.625
        vertex 1.341404914855957 15.833333015441895 -0.625
        vertex 12.746245384216309 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 1.341404914855957 15.833333015441895 -0.625
        vertex 12.746245384216309 15.833333015441895 -5.208700180053711
        vertex 12.746245384216309 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 1.341404914855957 15.833333015441895 -0.625
        vertex 1.341404914855957 15.833333015441895 -5.208700180053711
        vertex 12.746245384216309 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.220446049250313e-16 -1.0
    outer loop
        vertex 30.50239372253418 -26.0 -5.773159728050814e-15
        vertex 21.444528579711914 26.0 5.773159728050814e-15
        vertex 36.95547103881836 -26.0 -5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.220446049250313e-16 -1.0
    outer loop
        vertex 30.50239372253418 -26.0 -5.773159728050814e-15
        vertex 8.43100643157959 26.0 5.773159728050814e-15
        vertex 21.444528579711914 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 8.43100643157959 26.0 5.773159728050814e-15
        vertex 21.444528579711914 26.0 -0.625
        vertex 21.444528579711914 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 8.43100643157959 26.0 5.773159728050814e-15
        vertex 8.43100643157959 26.0 -0.625
        vertex 21.444528579711914 26.0 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 8.43100643157959 26.0 -0.625
        vertex 22.19024658203125 23.5 -0.625
        vertex 21.444528579711914 26.0 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 8.43100643157959 26.0 -0.625
        vertex 9.492131233215332 23.5 -0.625
        vertex 22.19024658203125 23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 9.492131233215332 23.5 -0.625
        vertex 22.19024658203125 23.5 -0.625
        vertex 22.19024658203125 23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 9.492131233215332 23.5 -0.625
        vertex 9.492131233215332 23.5 -0.625
        vertex 22.19024658203125 23.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 0.45307403802871704
    outer loop
        vertex 9.492131233215332 23.5 -0.625
        vertex 22.954607009887695 20.9375 -5.666999816894531
        vertex 22.19024658203125 23.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 0.45307403802871704
    outer loop
        vertex 9.492131233215332 23.5 -0.625
        vertex 10.57978343963623 20.9375 -5.666999816894531
        vertex 22.954607009887695 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 -2.1210230424372774e-16 1.0
    outer loop
        vertex 10.57978343963623 20.9375 -5.666999816894531
        vertex 35.44539260864258 -20.9375 -5.666999816894531
        vertex 22.954607009887695 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 -2.1210230424372774e-16 1.0
    outer loop
        vertex 10.57978343963623 20.9375 -5.666999816894531
        vertex 28.35361671447754 -20.9375 -5.666999816894531
        vertex 35.44539260864258 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 0.8914728760719299 0.45307403802871704
    outer loop
        vertex 28.35361671447754 -20.9375 -5.666999816894531
        vertex 36.209754943847656 -23.5 -0.625
        vertex 35.44539260864258 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal -0.0 0.8914728760719299 0.45307403802871704
    outer loop
        vertex 28.35361671447754 -20.9375 -5.666999816894531
        vertex 29.441268920898438 -23.5 -0.625
        vertex 36.209754943847656 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 29.441268920898438 -23.5 -0.625
        vertex 36.209754943847656 -23.5 -0.625
        vertex 36.209754943847656 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 29.441268920898438 -23.5 -0.625
        vertex 29.441268920898438 -23.5 -0.625
        vertex 36.209754943847656 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 29.441268920898438 -23.5 -0.625
        vertex 36.95547103881836 -26.0 -0.625
        vertex 36.209754943847656 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 29.441268920898438 -23.5 -0.625
        vertex 30.50239372253418 -26.0 -0.625
        vertex 36.95547103881836 -26.0 -0.625
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 30.50239372253418 -26.0 -0.625
        vertex 36.95547103881836 -26.0 -5.773159728050814e-15
        vertex 36.95547103881836 -26.0 -0.625
    endloop
endfacet
facet normal 0.0 1.0 0.0
    outer loop
        vertex 30.50239372253418 -26.0 -0.625
        vertex 30.50239372253418 -26.0 -5.773159728050814e-15
        vertex 36.95547103881836 -26.0 -5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 28.028030395507812 -20.170421600341797 -5.208700180053711
        vertex 33.922882080078125 -15.833333015441895 -5.208700180053711
        vertex 35.216583251953125 -20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 28.028030395507812 -20.170421600341797 -5.208700180053711
        vertex 26.18715476989746 -15.833333015441895 -5.208700180053711
        vertex 33.922882080078125 -15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 26.18715476989746 -15.833333015441895 -5.208700180053711
        vertex 33.922882080078125 -15.833333015441895 -0.625
        vertex 33.922882080078125 -15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 26.18715476989746 -15.833333015441895 -5.208700180053711
        vertex 26.18715476989746 -15.833333015441895 -0.625
        vertex 33.922882080078125 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 26.18715476989746 -15.833333015441895 -0.625
        vertex 35.91146469116211 -22.5 -0.625
        vertex 33.922882080078125 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 26.18715476989746 -15.833333015441895 -0.625
        vertex 29.01681900024414 -22.5 -0.625
        vertex 35.91146469116211 -22.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 29.01681900024414 -22.5 -0.625
        vertex 35.216583251953125 -20.170421600341797 -5.208700180053711
        vertex 35.91146469116211 -22.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 29.01681900024414 -22.5 -0.625
        vertex 28.028030395507812 -20.170421600341797 -5.208700180053711
        vertex 35.216583251953125 -20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 25.762704849243164 -14.833333015441895 -5.208700180053711
        vertex 31.63601303100586 -8.166666984558105 -5.208700180053711
        vertex 33.624595642089844 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 25.762704849243164 -14.833333015441895 -5.208700180053711
        vertex 22.93303871154785 -8.166666984558105 -5.208700180053711
        vertex 31.63601303100586 -8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 22.93303871154785 -8.166666984558105 -5.208700180053711
        vertex 31.63601303100586 -8.166666984558105 -0.625
        vertex 31.63601303100586 -8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 22.93303871154785 -8.166666984558105 -5.208700180053711
        vertex 22.93303871154785 -8.166666984558105 -0.625
        vertex 31.63601303100586 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 22.93303871154785 -8.166666984558105 -0.625
        vertex 33.624595642089844 -14.833333015441895 -0.625
        vertex 31.63601303100586 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 22.93303871154785 -8.166666984558105 -0.625
        vertex 25.762704849243164 -14.833333015441895 -0.625
        vertex 33.624595642089844 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 25.762704849243164 -14.833333015441895 -0.625
        vertex 33.624595642089844 -14.833333015441895 -5.208700180053711
        vertex 33.624595642089844 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 25.762704849243164 -14.833333015441895 -0.625
        vertex 25.762704849243164 -14.833333015441895 -5.208700180053711
        vertex 33.624595642089844 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 22.508590698242188 -7.166666507720947 -5.208700180053711
        vertex 29.349143981933594 -0.5 -5.208700180053711
        vertex 31.337726593017578 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 22.508590698242188 -7.166666507720947 -5.208700180053711
        vertex 19.678924560546875 -0.5 -5.208700180053711
        vertex 29.349143981933594 -0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 2.3010054999790975e-16
    outer loop
        vertex 19.678924560546875 -0.5 -5.208700180053711
        vertex 29.349143981933594 -0.5 -0.625
        vertex 29.349143981933594 -0.5 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 2.3010054999790975e-16
    outer loop
        vertex 19.678924560546875 -0.5 -5.208700180053711
        vertex 19.678924560546875 -0.5 -0.625
        vertex 29.349143981933594 -0.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 19.678924560546875 -0.5 -0.625
        vertex 31.337726593017578 -7.166666507720947 -0.625
        vertex 29.349143981933594 -0.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 19.678924560546875 -0.5 -0.625
        vertex 22.508590698242188 -7.166666507720947 -0.625
        vertex 31.337726593017578 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -1.9376887167044945e-16
    outer loop
        vertex 22.508590698242188 -7.166666507720947 -0.625
        vertex 31.337726593017578 -7.166666507720947 -5.208700180053711
        vertex 31.337726593017578 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -1.9376887167044945e-16
    outer loop
        vertex 22.508590698242188 -7.166666507720947 -0.625
        vertex 22.508590698242188 -7.166666507720947 -5.208700180053711
        vertex 31.337726593017578 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 19.254474639892578 0.5 -5.208700180053711
        vertex 27.062273025512695 7.166666507720947 -5.208700180053711
        vertex 29.05085563659668 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 19.254474639892578 0.5 -5.208700180053711
        vertex 16.4248104095459 7.166666507720947 -5.208700180053711
        vertex 27.062273025512695 7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 16.4248104095459 7.166666507720947 -5.208700180053711
        vertex 27.062273025512695 7.166666507720947 -0.625
        vertex 27.062273025512695 7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 16.4248104095459 7.166666507720947 -5.208700180053711
        vertex 16.4248104095459 7.166666507720947 -0.625
        vertex 27.062273025512695 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 16.4248104095459 7.166666507720947 -0.625
        vertex 29.05085563659668 0.5 -0.625
        vertex 27.062273025512695 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 16.4248104095459 7.166666507720947 -0.625
        vertex 19.254474639892578 0.5 -0.625
        vertex 29.05085563659668 0.5 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -2.1798997732053318e-16
    outer loop
        vertex 19.254474639892578 0.5 -0.625
        vertex 29.05085563659668 0.5 -5.208700180053711
        vertex 29.05085563659668 0.5 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -2.1798997732053318e-16
    outer loop
        vertex 19.254474639892578 0.5 -0.625
        vertex 19.254474639892578 0.5 -5.208700180053711
        vertex 29.05085563659668 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 16.0003604888916 8.166666984558105 -5.208700180053711
        vertex 24.77540397644043 14.833333015441895 -5.208700180053711
        vertex 26.763986587524414 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 16.0003604888916 8.166666984558105 -5.208700180053711
        vertex 13.170695304870605 14.833333015441895 -5.208700180053711
        vertex 24.77540397644043 14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 13.170695304870605 14.833333015441895 -5.208700180053711
        vertex 24.77540397644043 14.833333015441895 -0.625
        vertex 24.77540397644043 14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 13.170695304870605 14.833333015441895 -5.208700180053711
        vertex 13.170695304870605 14.833333015441895 -0.625
        vertex 24.77540397644043 14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 13.170695304870605 14.833333015441895 -0.625
        vertex 26.763986587524414 8.166666984558105 -0.625
        vertex 24.77540397644043 14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 13.170695304870605 14.833333015441895 -0.625
        vertex 16.0003604888916 8.166666984558105 -0.625
        vertex 26.763986587524414 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 16.0003604888916 8.166666984558105 -0.625
        vertex 26.763986587524414 8.166666984558105 -5.208700180053711
        vertex 26.763986587524414 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 16.0003604888916 8.166666984558105 -0.625
        vertex 16.0003604888916 8.166666984558105 -5.208700180053711
        vertex 26.763986587524414 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 12.746245384216309 15.833333015441895 -5.208700180053711
        vertex 23.18341827392578 20.170421600341797 -5.208700180053711
        vertex 24.477115631103516 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 12.746245384216309 15.833333015441895 -5.208700180053711
        vertex 10.905369758605957 20.170421600341797 -5.208700180053711
        vertex 23.18341827392578 20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 10.905369758605957 20.170421600341797 -5.208700180053711
        vertex 22.48853302001953 22.5 -0.625
        vertex 23.18341827392578 20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 10.905369758605957 20.170421600341797 -5.208700180053711
        vertex 9.916581153869629 22.5 -0.625
        vertex 22.48853302001953 22.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 9.916581153869629 22.5 -0.625
        vertex 24.477115631103516 15.833333015441895 -0.625
        vertex 22.48853302001953 22.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 9.916581153869629 22.5 -0.625
        vertex 12.746245384216309 15.833333015441895 -0.625
        vertex 24.477115631103516 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 12.746245384216309 15.833333015441895 -0.625
        vertex 24.477115631103516 15.833333015441895 -5.208700180053711
        vertex 24.477115631103516 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 12.746245384216309 15.833333015441895 -0.625
        vertex 12.746245384216309 15.833333015441895 -5.208700180053711
        vertex 24.477115631103516 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.220446049250313e-16 -1.0
    outer loop
        vertex 36.95547103881836 -26.0 -5.773159728050814e-15
        vertex 34.9193229675293 26.0 5.773159728050814e-15
        vertex 42.9472770690918 -26.0 -5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.220446049250313e-16 -1.0
    outer loop
        vertex 36.95547103881836 -26.0 -5.773159728050814e-15
        vertex 21.444528579711914 26.0 5.773159728050814e-15
        vertex 34.9193229675293 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 21.444528579711914 26.0 5.773159728050814e-15
        vertex 34.9193229675293 26.0 -0.625
        vertex 34.9193229675293 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 21.444528579711914 26.0 5.773159728050814e-15
        vertex 21.444528579711914 26.0 -0.625
        vertex 34.9193229675293 26.0 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 21.444528579711914 26.0 -0.625
        vertex 35.30528259277344 23.5 -0.625
        vertex 34.9193229675293 26.0 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 21.444528579711914 26.0 -0.625
        vertex 22.19024658203125 23.5 -0.625
        vertex 35.30528259277344 23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 22.19024658203125 23.5 -0.625
        vertex 35.30528259277344 23.5 -0.625
        vertex 35.30528259277344 23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 22.19024658203125 23.5 -0.625
        vertex 22.19024658203125 23.5 -0.625
        vertex 35.30528259277344 23.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 0.45307403802871704
    outer loop
        vertex 22.19024658203125 23.5 -0.625
        vertex 35.700889587402344 20.9375 -5.666999816894531
        vertex 35.30528259277344 23.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 0.45307403802871704
    outer loop
        vertex 22.19024658203125 23.5 -0.625
        vertex 22.954607009887695 20.9375 -5.666999816894531
        vertex 35.700889587402344 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 -2.1210230424372774e-16 1.0
    outer loop
        vertex 22.954607009887695 20.9375 -5.666999816894531
        vertex 42.16571044921875 -20.9375 -5.666999816894531
        vertex 35.700889587402344 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 -2.1210230424372774e-16 1.0
    outer loop
        vertex 22.954607009887695 20.9375 -5.666999816894531
        vertex 35.44539260864258 -20.9375 -5.666999816894531
        vertex 42.16571044921875 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 0.8914728760719299 0.45307403802871704
    outer loop
        vertex 35.44539260864258 -20.9375 -5.666999816894531
        vertex 42.561317443847656 -23.5 -0.625
        vertex 42.16571044921875 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal -0.0 0.8914728760719299 0.45307403802871704
    outer loop
        vertex 35.44539260864258 -20.9375 -5.666999816894531
        vertex 36.209754943847656 -23.5 -0.625
        vertex 42.561317443847656 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 36.209754943847656 -23.5 -0.625
        vertex 42.561317443847656 -23.5 -0.625
        vertex 42.561317443847656 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 36.209754943847656 -23.5 -0.625
        vertex 36.209754943847656 -23.5 -0.625
        vertex 42.561317443847656 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 36.209754943847656 -23.5 -0.625
        vertex 42.9472770690918 -26.0 -0.625
        vertex 42.561317443847656 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 36.209754943847656 -23.5 -0.625
        vertex 36.95547103881836 -26.0 -0.625
        vertex 42.9472770690918 -26.0 -0.625
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 36.95547103881836 -26.0 -0.625
        vertex 42.9472770690918 -26.0 -5.773159728050814e-15
        vertex 42.9472770690918 -26.0 -0.625
    endloop
endfacet
facet normal 0.0 1.0 0.0
    outer loop
        vertex 36.95547103881836 -26.0 -0.625
        vertex 36.95547103881836 -26.0 -5.773159728050814e-15
        vertex 42.9472770690918 -26.0 -5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 35.216583251953125 -20.170421600341797 -5.208700180053711
        vertex 41.377708435058594 -15.833333015441895 -5.208700180053711
        vertex 42.04728698730469 -20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 35.216583251953125 -20.170421600341797 -5.208700180053711
        vertex 33.922882080078125 -15.833333015441895 -5.208700180053711
        vertex 41.377708435058594 -15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 33.922882080078125 -15.833333015441895 -5.208700180053711
        vertex 41.377708435058594 -15.833333015441895 -0.625
        vertex 41.377708435058594 -15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 33.922882080078125 -15.833333015441895 -5.208700180053711
        vertex 33.922882080078125 -15.833333015441895 -0.625
        vertex 41.377708435058594 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 33.922882080078125 -15.833333015441895 -0.625
        vertex 42.40693283081055 -22.5 -0.625
        vertex 41.377708435058594 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 33.922882080078125 -15.833333015441895 -0.625
        vertex 35.91146469116211 -22.5 -0.625
        vertex 42.40693283081055 -22.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 35.91146469116211 -22.5 -0.625
        vertex 42.04728698730469 -20.170421600341797 -5.208700180053711
        vertex 42.40693283081055 -22.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 35.91146469116211 -22.5 -0.625
        vertex 35.216583251953125 -20.170421600341797 -5.208700180053711
        vertex 42.04728698730469 -20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 33.624595642089844 -14.833333015441895 -5.208700180053711
        vertex 40.19409942626953 -8.166666984558105 -5.208700180053711
        vertex 41.223323822021484 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 33.624595642089844 -14.833333015441895 -5.208700180053711
        vertex 31.63601303100586 -8.166666984558105 -5.208700180053711
        vertex 40.19409942626953 -8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 31.63601303100586 -8.166666984558105 -5.208700180053711
        vertex 40.19409942626953 -8.166666984558105 -0.625
        vertex 40.19409942626953 -8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 31.63601303100586 -8.166666984558105 -5.208700180053711
        vertex 31.63601303100586 -8.166666984558105 -0.625
        vertex 40.19409942626953 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 31.63601303100586 -8.166666984558105 -0.625
        vertex 41.223323822021484 -14.833333015441895 -0.625
        vertex 40.19409942626953 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 31.63601303100586 -8.166666984558105 -0.625
        vertex 33.624595642089844 -14.833333015441895 -0.625
        vertex 41.223323822021484 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 33.624595642089844 -14.833333015441895 -0.625
        vertex 41.223323822021484 -14.833333015441895 -5.208700180053711
        vertex 41.223323822021484 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 33.624595642089844 -14.833333015441895 -0.625
        vertex 33.624595642089844 -14.833333015441895 -5.208700180053711
        vertex 41.223323822021484 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 31.337726593017578 -7.166666507720947 -5.208700180053711
        vertex 39.01049041748047 -0.5 -5.208700180053711
        vertex 40.03971862792969 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 31.337726593017578 -7.166666507720947 -5.208700180053711
        vertex 29.349143981933594 -0.5 -5.208700180053711
        vertex 39.01049041748047 -0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 2.3010054999790975e-16
    outer loop
        vertex 29.349143981933594 -0.5 -5.208700180053711
        vertex 39.01049041748047 -0.5 -0.625
        vertex 39.01049041748047 -0.5 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 2.3010054999790975e-16
    outer loop
        vertex 29.349143981933594 -0.5 -5.208700180053711
        vertex 29.349143981933594 -0.5 -0.625
        vertex 39.01049041748047 -0.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 29.349143981933594 -0.5 -0.625
        vertex 40.03971862792969 -7.166666507720947 -0.625
        vertex 39.01049041748047 -0.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 29.349143981933594 -0.5 -0.625
        vertex 31.337726593017578 -7.166666507720947 -0.625
        vertex 40.03971862792969 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -1.9376887167044945e-16
    outer loop
        vertex 31.337726593017578 -7.166666507720947 -0.625
        vertex 40.03971862792969 -7.166666507720947 -5.208700180053711
        vertex 40.03971862792969 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -1.9376887167044945e-16
    outer loop
        vertex 31.337726593017578 -7.166666507720947 -0.625
        vertex 31.337726593017578 -7.166666507720947 -5.208700180053711
        vertex 40.03971862792969 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 29.05085563659668 0.5 -5.208700180053711
        vertex 37.826881408691406 7.166666507720947 -5.208700180053711
        vertex 38.856109619140625 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 29.05085563659668 0.5 -5.208700180053711
        vertex 27.062273025512695 7.166666507720947 -5.208700180053711
        vertex 37.826881408691406 7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 27.062273025512695 7.166666507720947 -5.208700180053711
        vertex 37.826881408691406 7.166666507720947 -0.625
        vertex 37.826881408691406 7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 27.062273025512695 7.166666507720947 -5.208700180053711
        vertex 27.062273025512695 7.166666507720947 -0.625
        vertex 37.826881408691406 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 27.062273025512695 7.166666507720947 -0.625
        vertex 38.856109619140625 0.5 -0.625
        vertex 37.826881408691406 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 27.062273025512695 7.166666507720947 -0.625
        vertex 29.05085563659668 0.5 -0.625
        vertex 38.856109619140625 0.5 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -2.1798997732053318e-16
    outer loop
        vertex 29.05085563659668 0.5 -0.625
        vertex 38.856109619140625 0.5 -5.208700180053711
        vertex 38.856109619140625 0.5 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -2.1798997732053318e-16
    outer loop
        vertex 29.05085563659668 0.5 -0.625
        vertex 29.05085563659668 0.5 -5.208700180053711
        vertex 38.856109619140625 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 26.763986587524414 8.166666984558105 -5.208700180053711
        vertex 36.64327621459961 14.833333015441895 -5.208700180053711
        vertex 37.67250061035156 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 26.763986587524414 8.166666984558105 -5.208700180053711
        vertex 24.77540397644043 14.833333015441895 -5.208700180053711
        vertex 36.64327621459961 14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 24.77540397644043 14.833333015441895 -5.208700180053711
        vertex 36.64327621459961 14.833333015441895 -0.625
        vertex 36.64327621459961 14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 24.77540397644043 14.833333015441895 -5.208700180053711
        vertex 24.77540397644043 14.833333015441895 -0.625
        vertex 36.64327621459961 14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 24.77540397644043 14.833333015441895 -0.625
        vertex 37.67250061035156 8.166666984558105 -0.625
        vertex 36.64327621459961 14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 24.77540397644043 14.833333015441895 -0.625
        vertex 26.763986587524414 8.166666984558105 -0.625
        vertex 37.67250061035156 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 26.763986587524414 8.166666984558105 -0.625
        vertex 37.67250061035156 8.166666984558105 -5.208700180053711
        vertex 37.67250061035156 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 26.763986587524414 8.166666984558105 -0.625
        vertex 26.763986587524414 8.166666984558105 -5.208700180053711
        vertex 37.67250061035156 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 24.477115631103516 15.833333015441895 -5.208700180053711
        vertex 35.819313049316406 20.170421600341797 -5.208700180053711
        vertex 36.4888916015625 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 24.477115631103516 15.833333015441895 -5.208700180053711
        vertex 23.18341827392578 20.170421600341797 -5.208700180053711
        vertex 35.819313049316406 20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 23.18341827392578 20.170421600341797 -5.208700180053711
        vertex 35.45966720581055 22.5 -0.625
        vertex 35.819313049316406 20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 23.18341827392578 20.170421600341797 -5.208700180053711
        vertex 22.48853302001953 22.5 -0.625
        vertex 35.45966720581055 22.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 22.48853302001953 22.5 -0.625
        vertex 36.4888916015625 15.833333015441895 -0.625
        vertex 35.45966720581055 22.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 22.48853302001953 22.5 -0.625
        vertex 24.477115631103516 15.833333015441895 -0.625
        vertex 36.4888916015625 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 24.477115631103516 15.833333015441895 -0.625
        vertex 36.4888916015625 15.833333015441895 -5.208700180053711
        vertex 36.4888916015625 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 24.477115631103516 15.833333015441895 -0.625
        vertex 24.477115631103516 15.833333015441895 -5.208700180053711
        vertex 36.4888916015625 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.220446049250313e-16 -1.0
    outer loop
        vertex 42.9472770690918 -26.0 -5.773159728050814e-15
        vertex 48.66669845581055 26.0 5.773159728050814e-15
        vertex 48.66669845581055 -26.0 -5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.220446049250313e-16 -1.0
    outer loop
        vertex 42.9472770690918 -26.0 -5.773159728050814e-15
        vertex 34.9193229675293 26.0 5.773159728050814e-15
        vertex 48.66669845581055 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 34.9193229675293 26.0 5.773159728050814e-15
        vertex 48.66669845581055 26.0 -0.625
        vertex 48.66669845581055 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 34.9193229675293 26.0 5.773159728050814e-15
        vertex 34.9193229675293 26.0 -0.625
        vertex 48.66669845581055 26.0 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 34.9193229675293 26.0 -0.625
        vertex 48.66669845581055 23.5 -0.625
        vertex 48.66669845581055 26.0 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 34.9193229675293 26.0 -0.625
        vertex 35.30528259277344 23.5 -0.625
        vertex 48.66669845581055 23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 35.30528259277344 23.5 -0.625
        vertex 48.66669845581055 23.5 -0.625
        vertex 48.66669845581055 23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 35.30528259277344 23.5 -0.625
        vertex 35.30528259277344 23.5 -0.625
        vertex 48.66669845581055 23.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 0.45307403802871704
    outer loop
        vertex 35.30528259277344 23.5 -0.625
        vertex 48.66669845581055 20.9375 -5.666999816894531
        vertex 48.66669845581055 23.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 0.45307403802871704
    outer loop
        vertex 35.30528259277344 23.5 -0.625
        vertex 35.700889587402344 20.9375 -5.666999816894531
        vertex 48.66669845581055 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 -2.1210230424372774e-16 1.0
    outer loop
        vertex 35.700889587402344 20.9375 -5.666999816894531
        vertex 48.66669845581055 -20.9375 -5.666999816894531
        vertex 48.66669845581055 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 -2.1210230424372774e-16 1.0
    outer loop
        vertex 35.700889587402344 20.9375 -5.666999816894531
        vertex 42.16571044921875 -20.9375 -5.666999816894531
        vertex 48.66669845581055 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 0.8914728760719299 0.45307403802871704
    outer loop
        vertex 42.16571044921875 -20.9375 -5.666999816894531
        vertex 48.66669845581055 -23.5 -0.625
        vertex 48.66669845581055 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal -0.0 0.8914728760719299 0.45307403802871704
    outer loop
        vertex 42.16571044921875 -20.9375 -5.666999816894531
        vertex 42.561317443847656 -23.5 -0.625
        vertex 48.66669845581055 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 42.561317443847656 -23.5 -0.625
        vertex 48.66669845581055 -23.5 -0.625
        vertex 48.66669845581055 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 42.561317443847656 -23.5 -0.625
        vertex 42.561317443847656 -23.5 -0.625
        vertex 48.66669845581055 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 42.561317443847656 -23.5 -0.625
        vertex 48.66669845581055 -26.0 -0.625
        vertex 48.66669845581055 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 42.561317443847656 -23.5 -0.625
        vertex 42.9472770690918 -26.0 -0.625
        vertex 48.66669845581055 -26.0 -0.625
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 42.9472770690918 -26.0 -0.625
        vertex 48.66669845581055 -26.0 -5.773159728050814e-15
        vertex 48.66669845581055 -26.0 -0.625
    endloop
endfacet
facet normal 0.0 1.0 0.0
    outer loop
        vertex 42.9472770690918 -26.0 -0.625
        vertex 42.9472770690918 -26.0 -5.773159728050814e-15
        vertex 48.66669845581055 -26.0 -5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 42.04728698730469 -20.170421600341797 -5.208700180053711
        vertex 48.66669845581055 -15.833333015441895 -5.208700180053711
        vertex 48.66669845581055 -20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 42.04728698730469 -20.170421600341797 -5.208700180053711
        vertex 41.377708435058594 -15.833333015441895 -5.208700180053711
        vertex 48.66669845581055 -15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 41.377708435058594 -15.833333015441895 -5.208700180053711
        vertex 48.66669845581055 -15.833333015441895 -0.625
        vertex 48.66669845581055 -15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 41.377708435058594 -15.833333015441895 -5.208700180053711
        vertex 41.377708435058594 -15.833333015441895 -0.625
        vertex 48.66669845581055 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 41.377708435058594 -15.833333015441895 -0.625
        vertex 48.66669845581055 -22.5 -0.625
        vertex 48.66669845581055 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 41.377708435058594 -15.833333015441895 -0.625
        vertex 42.40693283081055 -22.5 -0.625
        vertex 48.66669845581055 -22.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 42.40693283081055 -22.5 -0.625
        vertex 48.66669845581055 -20.170421600341797 -5.208700180053711
        vertex 48.66669845581055 -22.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 42.40693283081055 -22.5 -0.625
        vertex 42.04728698730469 -20.170421600341797 -5.208700180053711
        vertex 48.66669845581055 -20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 41.223323822021484 -14.833333015441895 -5.208700180053711
        vertex 48.66669845581055 -8.166666984558105 -5.208700180053711
        vertex 48.66669845581055 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 41.223323822021484 -14.833333015441895 -5.208700180053711
        vertex 40.19409942626953 -8.166666984558105 -5.208700180053711
        vertex 48.66669845581055 -8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 40.19409942626953 -8.166666984558105 -5.208700180053711
        vertex 48.66669845581055 -8.166666984558105 -0.625
        vertex 48.66669845581055 -8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 40.19409942626953 -8.166666984558105 -5.208700180053711
        vertex 40.19409942626953 -8.166666984558105 -0.625
        vertex 48.66669845581055 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 40.19409942626953 -8.166666984558105 -0.625
        vertex 48.66669845581055 -14.833333015441895 -0.625
        vertex 48.66669845581055 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 40.19409942626953 -8.166666984558105 -0.625
        vertex 41.223323822021484 -14.833333015441895 -0.625
        vertex 48.66669845581055 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 41.223323822021484 -14.833333015441895 -0.625
        vertex 48.66669845581055 -14.833333015441895 -5.208700180053711
        vertex 48.66669845581055 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 41.223323822021484 -14.833333015441895 -0.625
        vertex 41.223323822021484 -14.833333015441895 -5.208700180053711
        vertex 48.66669845581055 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 40.03971862792969 -7.166666507720947 -5.208700180053711
        vertex 48.66669845581055 -0.5 -5.208700180053711
        vertex 48.66669845581055 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 40.03971862792969 -7.166666507720947 -5.208700180053711
        vertex 39.01049041748047 -0.5 -5.208700180053711
        vertex 48.66669845581055 -0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 2.3010054999790975e-16
    outer loop
        vertex 39.01049041748047 -0.5 -5.208700180053711
        vertex 48.66669845581055 -0.5 -0.625
        vertex 48.66669845581055 -0.5 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 2.3010054999790975e-16
    outer loop
        vertex 39.01049041748047 -0.5 -5.208700180053711
        vertex 39.01049041748047 -0.5 -0.625
        vertex 48.66669845581055 -0.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 39.01049041748047 -0.5 -0.625
        vertex 48.66669845581055 -7.166666507720947 -0.625
        vertex 48.66669845581055 -0.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 39.01049041748047 -0.5 -0.625
        vertex 40.03971862792969 -7.166666507720947 -0.625
        vertex 48.66669845581055 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -1.9376887167044945e-16
    outer loop
        vertex 40.03971862792969 -7.166666507720947 -0.625
        vertex 48.66669845581055 -7.166666507720947 -5.208700180053711
        vertex 48.66669845581055 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -1.9376887167044945e-16
    outer loop
        vertex 40.03971862792969 -7.166666507720947 -0.625
        vertex 40.03971862792969 -7.166666507720947 -5.208700180053711
        vertex 48.66669845581055 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 38.856109619140625 0.5 -5.208700180053711
        vertex 48.66669845581055 7.166666507720947 -5.208700180053711
        vertex 48.66669845581055 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 38.856109619140625 0.5 -5.208700180053711
        vertex 37.826881408691406 7.166666507720947 -5.208700180053711
        vertex 48.66669845581055 7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 37.826881408691406 7.166666507720947 -5.208700180053711
        vertex 48.66669845581055 7.166666507720947 -0.625
        vertex 48.66669845581055 7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 37.826881408691406 7.166666507720947 -5.208700180053711
        vertex 37.826881408691406 7.166666507720947 -0.625
        vertex 48.66669845581055 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 37.826881408691406 7.166666507720947 -0.625
        vertex 48.66669845581055 0.5 -0.625
        vertex 48.66669845581055 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 37.826881408691406 7.166666507720947 -0.625
        vertex 38.856109619140625 0.5 -0.625
        vertex 48.66669845581055 0.5 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -2.1798997732053318e-16
    outer loop
        vertex 38.856109619140625 0.5 -0.625
        vertex 48.66669845581055 0.5 -5.208700180053711
        vertex 48.66669845581055 0.5 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -2.1798997732053318e-16
    outer loop
        vertex 38.856109619140625 0.5 -0.625
        vertex 38.856109619140625 0.5 -5.208700180053711
        vertex 48.66669845581055 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 37.67250061035156 8.166666984558105 -5.208700180053711
        vertex 48.66669845581055 14.833333015441895 -5.208700180053711
        vertex 48.66669845581055 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 37.67250061035156 8.166666984558105 -5.208700180053711
        vertex 36.64327621459961 14.833333015441895 -5.208700180053711
        vertex 48.66669845581055 14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 36.64327621459961 14.833333015441895 -5.208700180053711
        vertex 48.66669845581055 14.833333015441895 -0.625
        vertex 48.66669845581055 14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 36.64327621459961 14.833333015441895 -5.208700180053711
        vertex 36.64327621459961 14.833333015441895 -0.625
        vertex 48.66669845581055 14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 36.64327621459961 14.833333015441895 -0.625
        vertex 48.66669845581055 8.166666984558105 -0.625
        vertex 48.66669845581055 14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 36.64327621459961 14.833333015441895 -0.625
        vertex 37.67250061035156 8.166666984558105 -0.625
        vertex 48.66669845581055 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 37.67250061035156 8.166666984558105 -0.625
        vertex 48.66669845581055 8.166666984558105 -5.208700180053711
        vertex 48.66669845581055 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 37.67250061035156 8.166666984558105 -0.625
        vertex 37.67250061035156 8.166666984558105 -5.208700180053711
        vertex 48.66669845581055 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 36.4888916015625 15.833333015441895 -5.208700180053711
        vertex 48.66669845581055 20.170421600341797 -5.208700180053711
        vertex 48.66669845581055 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 36.4888916015625 15.833333015441895 -5.208700180053711
        vertex 35.819313049316406 20.170421600341797 -5.208700180053711
        vertex 48.66669845581055 20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 35.819313049316406 20.170421600341797 -5.208700180053711
        vertex 48.66669845581055 22.5 -0.625
        vertex 48.66669845581055 20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 35.819313049316406 20.170421600341797 -5.208700180053711
        vertex 35.45966720581055 22.5 -0.625
        vertex 48.66669845581055 22.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 35.45966720581055 22.5 -0.625
        vertex 48.66669845581055 15.833333015441895 -0.625
        vertex 48.66669845581055 22.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 35.45966720581055 22.5 -0.625
        vertex 36.4888916015625 15.833333015441895 -0.625
        vertex 48.66669845581055 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 36.4888916015625 15.833333015441895 -0.625
        vertex 48.66669845581055 15.833333015441895 -5.208700180053711
        vertex 48.66669845581055 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 36.4888916015625 15.833333015441895 -0.625
        vertex 36.4888916015625 15.833333015441895 -5.208700180053711
        vertex 48.66669845581055 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.220446049250313e-16 -1.0
    outer loop
        vertex 48.66669845581055 -26.0 -5.773159728050814e-15
        vertex 58.400001525878906 26.0 5.773159728050814e-15
        vertex 58.400001525878906 -26.0 -5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.220446049250313e-16 -1.0
    outer loop
        vertex 48.66669845581055 -26.0 -5.773159728050814e-15
        vertex 48.66669845581055 26.0 5.773159728050814e-15
        vertex 58.400001525878906 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 48.66669845581055 26.0 5.773159728050814e-15
        vertex 58.400001525878906 26.0 -0.625
        vertex 58.400001525878906 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 48.66669845581055 26.0 5.773159728050814e-15
        vertex 48.66669845581055 26.0 -0.625
        vertex 58.400001525878906 26.0 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 48.66669845581055 26.0 -0.625
        vertex 58.400001525878906 23.5 -0.625
        vertex 58.400001525878906 26.0 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 48.66669845581055 26.0 -0.625
        vertex 48.66669845581055 23.5 -0.625
        vertex 58.400001525878906 23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 48.66669845581055 23.5 -0.625
        vertex 58.400001525878906 23.5 -0.625
        vertex 58.400001525878906 23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 48.66669845581055 23.5 -0.625
        vertex 48.66669845581055 23.5 -0.625
        vertex 58.400001525878906 23.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 0.45307403802871704
    outer loop
        vertex 48.66669845581055 23.5 -0.625
        vertex 58.400001525878906 20.9375 -5.666999816894531
        vertex 58.400001525878906 23.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 0.45307403802871704
    outer loop
        vertex 48.66669845581055 23.5 -0.625
        vertex 48.66669845581055 20.9375 -5.666999816894531
        vertex 58.400001525878906 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 -2.1210230424372774e-16 1.0
    outer loop
        vertex 48.66669845581055 20.9375 -5.666999816894531
        vertex 58.400001525878906 -20.9375 -5.666999816894531
        vertex 58.400001525878906 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 -2.1210230424372774e-16 1.0
    outer loop
        vertex 48.66669845581055 20.9375 -5.666999816894531
        vertex 48.66669845581055 -20.9375 -5.666999816894531
        vertex 58.400001525878906 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 0.8914728760719299 0.45307403802871704
    outer loop
        vertex 48.66669845581055 -20.9375 -5.666999816894531
        vertex 58.400001525878906 -23.5 -0.625
        vertex 58.400001525878906 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal -0.0 0.8914728760719299 0.45307403802871704
    outer loop
        vertex 48.66669845581055 -20.9375 -5.666999816894531
        vertex 48.66669845581055 -23.5 -0.625
        vertex 58.400001525878906 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 48.66669845581055 -23.5 -0.625
        vertex 58.400001525878906 -23.5 -0.625
        vertex 58.400001525878906 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 48.66669845581055 -23.5 -0.625
        vertex 48.66669845581055 -23.5 -0.625
        vertex 58.400001525878906 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 48.66669845581055 -23.5 -0.625
        vertex 58.400001525878906 -26.0 -0.625
        vertex 58.400001525878906 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 48.66669845581055 -23.5 -0.625
        vertex 48.66669845581055 -26.0 -0.625
        vertex 58.400001525878906 -26.0 -0.625
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 48.66669845581055 -26.0 -0.625
        vertex 58.400001525878906 -26.0 -5.773159728050814e-15
        vertex 58.400001525878906 -26.0 -0.625
    endloop
endfacet
facet normal 0.0 1.0 0.0
    outer loop
        vertex 48.66669845581055 -26.0 -0.625
        vertex 48.66669845581055 -26.0 -5.773159728050814e-15
        vertex 58.400001525878906 -26.0 -5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 48.66669845581055 -20.170421600341797 -5.208700180053711
        vertex 58.400001525878906 -15.833333015441895 -5.208700180053711
        vertex 58.400001525878906 -20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 48.66669845581055 -20.170421600341797 -5.208700180053711
        vertex 48.66669845581055 -15.833333015441895 -5.208700180053711
        vertex 58.400001525878906 -15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 48.66669845581055 -15.833333015441895 -5.208700180053711
        vertex 58.400001525878906 -15.833333015441895 -0.625
        vertex 58.400001525878906 -15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 48.66669845581055 -15.833333015441895 -5.208700180053711
        vertex 48.66669845581055 -15.833333015441895 -0.625
        vertex 58.400001525878906 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 48.66669845581055 -15.833333015441895 -0.625
        vertex 58.400001525878906 -22.5 -0.625
        vertex 58.400001525878906 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 48.66669845581055 -15.833333015441895 -0.625
        vertex 48.66669845581055 -22.5 -0.625
        vertex 58.400001525878906 -22.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 48.66669845581055 -22.5 -0.625
        vertex 58.400001525878906 -20.170421600341797 -5.208700180053711
        vertex 58.400001525878906 -22.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 48.66669845581055 -22.5 -0.625
        vertex 48.66669845581055 -20.170421600341797 -5.208700180053711
        vertex 58.400001525878906 -20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 48.66669845581055 -14.833333015441895 -5.208700180053711
        vertex 58.400001525878906 -8.166666984558105 -5.208700180053711
        vertex 58.400001525878906 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 48.66669845581055 -14.833333015441895 -5.208700180053711
        vertex 48.66669845581055 -8.166666984558105 -5.208700180053711
        vertex 58.400001525878906 -8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 48.66669845581055 -8.166666984558105 -5.208700180053711
        vertex 58.400001525878906 -8.166666984558105 -0.625
        vertex 58.400001525878906 -8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 48.66669845581055 -8.166666984558105 -5.208700180053711
        vertex 48.66669845581055 -8.166666984558105 -0.625
        vertex 58.400001525878906 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 48.66669845581055 -8.166666984558105 -0.625
        vertex 58.400001525878906 -14.833333015441895 -0.625
        vertex 58.400001525878906 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 48.66669845581055 -8.166666984558105 -0.625
        vertex 48.66669845581055 -14.833333015441895 -0.625
        vertex 58.400001525878906 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 48.66669845581055 -14.833333015441895 -0.625
        vertex 58.400001525878906 -14.833333015441895 -5.208700180053711
        vertex 58.400001525878906 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 48.66669845581055 -14.833333015441895 -0.625
        vertex 48.66669845581055 -14.833333015441895 -5.208700180053711
        vertex 58.400001525878906 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 48.66669845581055 -7.166666507720947 -5.208700180053711
        vertex 58.400001525878906 -0.5 -5.208700180053711
        vertex 58.400001525878906 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 48.66669845581055 -7.166666507720947 -5.208700180053711
        vertex 48.66669845581055 -0.5 -5.208700180053711
        vertex 58.400001525878906 -0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 2.3010054999790975e-16
    outer loop
        vertex 48.66669845581055 -0.5 -5.208700180053711
        vertex 58.400001525878906 -0.5 -0.625
        vertex 58.400001525878906 -0.5 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 2.3010054999790975e-16
    outer loop
        vertex 48.66669845581055 -0.5 -5.208700180053711
        vertex 48.66669845581055 -0.5 -0.625
        vertex 58.400001525878906 -0.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 48.66669845581055 -0.5 -0.625
        vertex 58.400001525878906 -7.166666507720947 -0.625
        vertex 58.400001525878906 -0.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 48.66669845581055 -0.5 -0.625
        vertex 48.66669845581055 -7.166666507720947 -0.625
        vertex 58.400001525878906 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -1.9376887167044945e-16
    outer loop
        vertex 48.66669845581055 -7.166666507720947 -0.625
        vertex 58.400001525878906 -7.166666507720947 -5.208700180053711
        vertex 58.400001525878906 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -1.9376887167044945e-16
    outer loop
        vertex 48.66669845581055 -7.166666507720947 -0.625
        vertex 48.66669845581055 -7.166666507720947 -5.208700180053711
        vertex 58.400001525878906 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 48.66669845581055 0.5 -5.208700180053711
        vertex 58.400001525878906 7.166666507720947 -5.208700180053711
        vertex 58.400001525878906 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 48.66669845581055 0.5 -5.208700180053711
        vertex 48.66669845581055 7.166666507720947 -5.208700180053711
        vertex 58.400001525878906 7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 48.66669845581055 7.166666507720947 -5.208700180053711
        vertex 58.400001525878906 7.166666507720947 -0.625
        vertex 58.400001525878906 7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 48.66669845581055 7.166666507720947 -5.208700180053711
        vertex 48.66669845581055 7.166666507720947 -0.625
        vertex 58.400001525878906 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 48.66669845581055 7.166666507720947 -0.625
        vertex 58.400001525878906 0.5 -0.625
        vertex 58.400001525878906 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 48.66669845581055 7.166666507720947 -0.625
        vertex 48.66669845581055 0.5 -0.625
        vertex 58.400001525878906 0.5 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -2.1798997732053318e-16
    outer loop
        vertex 48.66669845581055 0.5 -0.625
        vertex 58.400001525878906 0.5 -5.208700180053711
        vertex 58.400001525878906 0.5 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -2.1798997732053318e-16
    outer loop
        vertex 48.66669845581055 0.5 -0.625
        vertex 48.66669845581055 0.5 -5.208700180053711
        vertex 58.400001525878906 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 48.66669845581055 8.166666984558105 -5.208700180053711
        vertex 58.400001525878906 14.833333015441895 -5.208700180053711
        vertex 58.400001525878906 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 48.66669845581055 8.166666984558105 -5.208700180053711
        vertex 48.66669845581055 14.833333015441895 -5.208700180053711
        vertex 58.400001525878906 14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 48.66669845581055 14.833333015441895 -5.208700180053711
        vertex 58.400001525878906 14.833333015441895 -0.625
        vertex 58.400001525878906 14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 48.66669845581055 14.833333015441895 -5.208700180053711
        vertex 48.66669845581055 14.833333015441895 -0.625
        vertex 58.400001525878906 14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 48.66669845581055 14.833333015441895 -0.625
        vertex 58.400001525878906 8.166666984558105 -0.625
        vertex 58.400001525878906 14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 48.66669845581055 14.833333015441895 -0.625
        vertex 48.66669845581055 8.166666984558105 -0.625
        vertex 58.400001525878906 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 48.66669845581055 8.166666984558105 -0.625
        vertex 58.400001525878906 8.166666984558105 -5.208700180053711
        vertex 58.400001525878906 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 48.66669845581055 8.166666984558105 -0.625
        vertex 48.66669845581055 8.166666984558105 -5.208700180053711
        vertex 58.400001525878906 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 48.66669845581055 15.833333015441895 -5.208700180053711
        vertex 58.400001525878906 20.170421600341797 -5.208700180053711
        vertex 58.400001525878906 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 48.66669845581055 15.833333015441895 -5.208700180053711
        vertex 48.66669845581055 20.170421600341797 -5.208700180053711
        vertex 58.400001525878906 20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 48.66669845581055 20.170421600341797 -5.208700180053711
        vertex 58.400001525878906 22.5 -0.625
        vertex 58.400001525878906 20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 48.66669845581055 20.170421600341797 -5.208700180053711
        vertex 48.66669845581055 22.5 -0.625
        vertex 58.400001525878906 22.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 48.66669845581055 22.5 -0.625
        vertex 58.400001525878906 15.833333015441895 -0.625
        vertex 58.400001525878906 22.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 48.66669845581055 22.5 -0.625
        vertex 48.66669845581055 15.833333015441895 -0.625
        vertex 58.400001525878906 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 48.66669845581055 15.833333015441895 -0.625
        vertex 58.400001525878906 15.833333015441895 -5.208700180053711
        vertex 58.400001525878906 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 48.66669845581055 15.833333015441895 -0.625
        vertex 48.66669845581055 15.833333015441895 -5.208700180053711
        vertex 58.400001525878906 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.220446049250313e-16 -1.0
    outer loop
        vertex 58.400001525878906 -26.0 -5.773159728050814e-15
        vertex 68.13330078125 26.0 5.773159728050814e-15
        vertex 68.13330078125 -26.0 -5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.220446049250313e-16 -1.0
    outer loop
        vertex 58.400001525878906 -26.0 -5.773159728050814e-15
        vertex 58.400001525878906 26.0 5.773159728050814e-15
        vertex 68.13330078125 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 58.400001525878906 26.0 5.773159728050814e-15
        vertex 68.13330078125 26.0 -0.625
        vertex 68.13330078125 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 58.400001525878906 26.0 5.773159728050814e-15
        vertex 58.400001525878906 26.0 -0.625
        vertex 68.13330078125 26.0 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 58.400001525878906 26.0 -0.625
        vertex 68.13330078125 23.5 -0.625
        vertex 68.13330078125 26.0 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 58.400001525878906 26.0 -0.625
        vertex 58.400001525878906 23.5 -0.625
        vertex 68.13330078125 23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 58.400001525878906 23.5 -0.625
        vertex 68.13330078125 23.5 -0.625
        vertex 68.13330078125 23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 58.400001525878906 23.5 -0.625
        vertex 58.400001525878906 23.5 -0.625
        vertex 68.13330078125 23.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 0.45307403802871704
    outer loop
        vertex 58.400001525878906 23.5 -0.625
        vertex 68.13330078125 20.9375 -5.666999816894531
        vertex 68.13330078125 23.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 0.45307403802871704
    outer loop
        vertex 58.400001525878906 23.5 -0.625
        vertex 58.400001525878906 20.9375 -5.666999816894531
        vertex 68.13330078125 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 -2.1210230424372774e-16 1.0
    outer loop
        vertex 58.400001525878906 20.9375 -5.666999816894531
        vertex 68.13330078125 -20.9375 -5.666999816894531
        vertex 68.13330078125 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 -2.1210230424372774e-16 1.0
    outer loop
        vertex 58.400001525878906 20.9375 -5.666999816894531
        vertex 58.400001525878906 -20.9375 -5.666999816894531
        vertex 68.13330078125 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 0.8914728760719299 0.45307403802871704
    outer loop
        vertex 58.400001525878906 -20.9375 -5.666999816894531
        vertex 68.13330078125 -23.5 -0.625
        vertex 68.13330078125 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal -0.0 0.8914728760719299 0.45307403802871704
    outer loop
        vertex 58.400001525878906 -20.9375 -5.666999816894531
        vertex 58.400001525878906 -23.5 -0.625
        vertex 68.13330078125 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 58.400001525878906 -23.5 -0.625
        vertex 68.13330078125 -23.5 -0.625
        vertex 68.13330078125 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 58.400001525878906 -23.5 -0.625
        vertex 58.400001525878906 -23.5 -0.625
        vertex 68.13330078125 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 58.400001525878906 -23.5 -0.625
        vertex 68.13330078125 -26.0 -0.625
        vertex 68.13330078125 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 58.400001525878906 -23.5 -0.625
        vertex 58.400001525878906 -26.0 -0.625
        vertex 68.13330078125 -26.0 -0.625
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 58.400001525878906 -26.0 -0.625
        vertex 68.13330078125 -26.0 -5.773159728050814e-15
        vertex 68.13330078125 -26.0 -0.625
    endloop
endfacet
facet normal 0.0 1.0 0.0
    outer loop
        vertex 58.400001525878906 -26.0 -0.625
        vertex 58.400001525878906 -26.0 -5.773159728050814e-15
        vertex 68.13330078125 -26.0 -5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 58.400001525878906 -20.170421600341797 -5.208700180053711
        vertex 68.13330078125 -15.833333015441895 -5.208700180053711
        vertex 68.13330078125 -20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 58.400001525878906 -20.170421600341797 -5.208700180053711
        vertex 58.400001525878906 -15.833333015441895 -5.208700180053711
        vertex 68.13330078125 -15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 58.400001525878906 -15.833333015441895 -5.208700180053711
        vertex 68.13330078125 -15.833333015441895 -0.625
        vertex 68.13330078125 -15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 58.400001525878906 -15.833333015441895 -5.208700180053711
        vertex 58.400001525878906 -15.833333015441895 -0.625
        vertex 68.13330078125 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 58.400001525878906 -15.833333015441895 -0.625
        vertex 68.13330078125 -22.5 -0.625
        vertex 68.13330078125 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 58.400001525878906 -15.833333015441895 -0.625
        vertex 58.400001525878906 -22.5 -0.625
        vertex 68.13330078125 -22.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 58.400001525878906 -22.5 -0.625
        vertex 68.13330078125 -20.170421600341797 -5.208700180053711
        vertex 68.13330078125 -22.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 58.400001525878906 -22.5 -0.625
        vertex 58.400001525878906 -20.170421600341797 -5.208700180053711
        vertex 68.13330078125 -20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 58.400001525878906 -14.833333015441895 -5.208700180053711
        vertex 68.13330078125 -8.166666984558105 -5.208700180053711
        vertex 68.13330078125 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 58.400001525878906 -14.833333015441895 -5.208700180053711
        vertex 58.400001525878906 -8.166666984558105 -5.208700180053711
        vertex 68.13330078125 -8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 58.400001525878906 -8.166666984558105 -5.208700180053711
        vertex 68.13330078125 -8.166666984558105 -0.625
        vertex 68.13330078125 -8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 58.400001525878906 -8.166666984558105 -5.208700180053711
        vertex 58.400001525878906 -8.166666984558105 -0.625
        vertex 68.13330078125 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 58.400001525878906 -8.166666984558105 -0.625
        vertex 68.13330078125 -14.833333015441895 -0.625
        vertex 68.13330078125 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 58.400001525878906 -8.166666984558105 -0.625
        vertex 58.400001525878906 -14.833333015441895 -0.625
        vertex 68.13330078125 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 58.400001525878906 -14.833333015441895 -0.625
        vertex 68.13330078125 -14.833333015441895 -5.208700180053711
        vertex 68.13330078125 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 58.400001525878906 -14.833333015441895 -0.625
        vertex 58.400001525878906 -14.833333015441895 -5.208700180053711
        vertex 68.13330078125 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 58.400001525878906 -7.166666507720947 -5.208700180053711
        vertex 68.13330078125 -0.5 -5.208700180053711
        vertex 68.13330078125 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 58.400001525878906 -7.166666507720947 -5.208700180053711
        vertex 58.400001525878906 -0.5 -5.208700180053711
        vertex 68.13330078125 -0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 2.3010054999790975e-16
    outer loop
        vertex 58.400001525878906 -0.5 -5.208700180053711
        vertex 68.13330078125 -0.5 -0.625
        vertex 68.13330078125 -0.5 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 2.3010054999790975e-16
    outer loop
        vertex 58.400001525878906 -0.5 -5.208700180053711
        vertex 58.400001525878906 -0.5 -0.625
        vertex 68.13330078125 -0.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 58.400001525878906 -0.5 -0.625
        vertex 68.13330078125 -7.166666507720947 -0.625
        vertex 68.13330078125 -0.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 58.400001525878906 -0.5 -0.625
        vertex 58.400001525878906 -7.166666507720947 -0.625
        vertex 68.13330078125 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -1.9376887167044945e-16
    outer loop
        vertex 58.400001525878906 -7.166666507720947 -0.625
        vertex 68.13330078125 -7.166666507720947 -5.208700180053711
        vertex 68.13330078125 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -1.9376887167044945e-16
    outer loop
        vertex 58.400001525878906 -7.166666507720947 -0.625
        vertex 58.400001525878906 -7.166666507720947 -5.208700180053711
        vertex 68.13330078125 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 58.400001525878906 0.5 -5.208700180053711
        vertex 68.13330078125 7.166666507720947 -5.208700180053711
        vertex 68.13330078125 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 58.400001525878906 0.5 -5.208700180053711
        vertex 58.400001525878906 7.166666507720947 -5.208700180053711
        vertex 68.13330078125 7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 58.400001525878906 7.166666507720947 -5.208700180053711
        vertex 68.13330078125 7.166666507720947 -0.625
        vertex 68.13330078125 7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 58.400001525878906 7.166666507720947 -5.208700180053711
        vertex 58.400001525878906 7.166666507720947 -0.625
        vertex 68.13330078125 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 58.400001525878906 7.166666507720947 -0.625
        vertex 68.13330078125 0.5 -0.625
        vertex 68.13330078125 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 58.400001525878906 7.166666507720947 -0.625
        vertex 58.400001525878906 0.5 -0.625
        vertex 68.13330078125 0.5 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -2.1798997732053318e-16
    outer loop
        vertex 58.400001525878906 0.5 -0.625
        vertex 68.13330078125 0.5 -5.208700180053711
        vertex 68.13330078125 0.5 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -2.1798997732053318e-16
    outer loop
        vertex 58.400001525878906 0.5 -0.625
        vertex 58.400001525878906 0.5 -5.208700180053711
        vertex 68.13330078125 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 58.400001525878906 8.166666984558105 -5.208700180053711
        vertex 68.13330078125 14.833333015441895 -5.208700180053711
        vertex 68.13330078125 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 58.400001525878906 8.166666984558105 -5.208700180053711
        vertex 58.400001525878906 14.833333015441895 -5.208700180053711
        vertex 68.13330078125 14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 58.400001525878906 14.833333015441895 -5.208700180053711
        vertex 68.13330078125 14.833333015441895 -0.625
        vertex 68.13330078125 14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 58.400001525878906 14.833333015441895 -5.208700180053711
        vertex 58.400001525878906 14.833333015441895 -0.625
        vertex 68.13330078125 14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 58.400001525878906 14.833333015441895 -0.625
        vertex 68.13330078125 8.166666984558105 -0.625
        vertex 68.13330078125 14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 58.400001525878906 14.833333015441895 -0.625
        vertex 58.400001525878906 8.166666984558105 -0.625
        vertex 68.13330078125 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 58.400001525878906 8.166666984558105 -0.625
        vertex 68.13330078125 8.166666984558105 -5.208700180053711
        vertex 68.13330078125 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 58.400001525878906 8.166666984558105 -0.625
        vertex 58.400001525878906 8.166666984558105 -5.208700180053711
        vertex 68.13330078125 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 58.400001525878906 15.833333015441895 -5.208700180053711
        vertex 68.13330078125 20.170421600341797 -5.208700180053711
        vertex 68.13330078125 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 58.400001525878906 15.833333015441895 -5.208700180053711
        vertex 58.400001525878906 20.170421600341797 -5.208700180053711
        vertex 68.13330078125 20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 58.400001525878906 20.170421600341797 -5.208700180053711
        vertex 68.13330078125 22.5 -0.625
        vertex 68.13330078125 20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 58.400001525878906 20.170421600341797 -5.208700180053711
        vertex 58.400001525878906 22.5 -0.625
        vertex 68.13330078125 22.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 58.400001525878906 22.5 -0.625
        vertex 68.13330078125 15.833333015441895 -0.625
        vertex 68.13330078125 22.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 58.400001525878906 22.5 -0.625
        vertex 58.400001525878906 15.833333015441895 -0.625
        vertex 68.13330078125 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 58.400001525878906 15.833333015441895 -0.625
        vertex 68.13330078125 15.833333015441895 -5.208700180053711
        vertex 68.13330078125 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 58.400001525878906 15.833333015441895 -0.625
        vertex 58.400001525878906 15.833333015441895 -5.208700180053711
        vertex 68.13330078125 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.220446049250313e-16 -1.0
    outer loop
        vertex 68.13330078125 -26.0 -5.773159728050814e-15
        vertex 77.86669921875 26.0 5.773159728050814e-15
        vertex 77.86669921875 -26.0 -5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.220446049250313e-16 -1.0
    outer loop
        vertex 68.13330078125 -26.0 -5.773159728050814e-15
        vertex 68.13330078125 26.0 5.773159728050814e-15
        vertex 77.86669921875 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 68.13330078125 26.0 5.773159728050814e-15
        vertex 77.86669921875 26.0 -0.625
        vertex 77.86669921875 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 68.13330078125 26.0 5.773159728050814e-15
        vertex 68.13330078125 26.0 -0.625
        vertex 77.86669921875 26.0 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 68.13330078125 26.0 -0.625
        vertex 77.86669921875 23.5 -0.625
        vertex 77.86669921875 26.0 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 68.13330078125 26.0 -0.625
        vertex 68.13330078125 23.5 -0.625
        vertex 77.86669921875 23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 68.13330078125 23.5 -0.625
        vertex 77.86669921875 23.5 -0.625
        vertex 77.86669921875 23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 68.13330078125 23.5 -0.625
        vertex 68.13330078125 23.5 -0.625
        vertex 77.86669921875 23.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 0.45307403802871704
    outer loop
        vertex 68.13330078125 23.5 -0.625
        vertex 77.86669921875 20.9375 -5.666999816894531
        vertex 77.86669921875 23.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 0.45307403802871704
    outer loop
        vertex 68.13330078125 23.5 -0.625
        vertex 68.13330078125 20.9375 -5.666999816894531
        vertex 77.86669921875 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 -2.1210230424372774e-16 1.0
    outer loop
        vertex 68.13330078125 20.9375 -5.666999816894531
        vertex 77.86669921875 -20.9375 -5.666999816894531
        vertex 77.86669921875 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 -2.1210230424372774e-16 1.0
    outer loop
        vertex 68.13330078125 20.9375 -5.666999816894531
        vertex 68.13330078125 -20.9375 -5.666999816894531
        vertex 77.86669921875 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 0.8914728760719299 0.45307403802871704
    outer loop
        vertex 68.13330078125 -20.9375 -5.666999816894531
        vertex 77.86669921875 -23.5 -0.625
        vertex 77.86669921875 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal -0.0 0.8914728760719299 0.45307403802871704
    outer loop
        vertex 68.13330078125 -20.9375 -5.666999816894531
        vertex 68.13330078125 -23.5 -0.625
        vertex 77.86669921875 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 68.13330078125 -23.5 -0.625
        vertex 77.86669921875 -23.5 -0.625
        vertex 77.86669921875 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 68.13330078125 -23.5 -0.625
        vertex 68.13330078125 -23.5 -0.625
        vertex 77.86669921875 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 68.13330078125 -23.5 -0.625
        vertex 77.86669921875 -26.0 -0.625
        vertex 77.86669921875 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 68.13330078125 -23.5 -0.625
        vertex 68.13330078125 -26.0 -0.625
        vertex 77.86669921875 -26.0 -0.625
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 68.13330078125 -26.0 -0.625
        vertex 77.86669921875 -26.0 -5.773159728050814e-15
        vertex 77.86669921875 -26.0 -0.625
    endloop
endfacet
facet normal 0.0 1.0 0.0
    outer loop
        vertex 68.13330078125 -26.0 -0.625
        vertex 68.13330078125 -26.0 -5.773159728050814e-15
        vertex 77.86669921875 -26.0 -5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 68.13330078125 -20.170421600341797 -5.208700180053711
        vertex 77.86669921875 -15.833333015441895 -5.208700180053711
        vertex 77.86669921875 -20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 68.13330078125 -20.170421600341797 -5.208700180053711
        vertex 68.13330078125 -15.833333015441895 -5.208700180053711
        vertex 77.86669921875 -15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 68.13330078125 -15.833333015441895 -5.208700180053711
        vertex 77.86669921875 -15.833333015441895 -0.625
        vertex 77.86669921875 -15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 68.13330078125 -15.833333015441895 -5.208700180053711
        vertex 68.13330078125 -15.833333015441895 -0.625
        vertex 77.86669921875 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 68.13330078125 -15.833333015441895 -0.625
        vertex 77.86669921875 -22.5 -0.625
        vertex 77.86669921875 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 68.13330078125 -15.833333015441895 -0.625
        vertex 68.13330078125 -22.5 -0.625
        vertex 77.86669921875 -22.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 68.13330078125 -22.5 -0.625
        vertex 77.86669921875 -20.170421600341797 -5.208700180053711
        vertex 77.86669921875 -22.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 68.13330078125 -22.5 -0.625
        vertex 68.13330078125 -20.170421600341797 -5.208700180053711
        vertex 77.86669921875 -20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 68.13330078125 -14.833333015441895 -5.208700180053711
        vertex 77.86669921875 -8.166666984558105 -5.208700180053711
        vertex 77.86669921875 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 68.13330078125 -14.833333015441895 -5.208700180053711
        vertex 68.13330078125 -8.166666984558105 -5.208700180053711
        vertex 77.86669921875 -8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 68.13330078125 -8.166666984558105 -5.208700180053711
        vertex 77.86669921875 -8.166666984558105 -0.625
        vertex 77.86669921875 -8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 68.13330078125 -8.166666984558105 -5.208700180053711
        vertex 68.13330078125 -8.166666984558105 -0.625
        vertex 77.86669921875 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 68.13330078125 -8.166666984558105 -0.625
        vertex 77.86669921875 -14.833333015441895 -0.625
        vertex 77.86669921875 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 68.13330078125 -8.166666984558105 -0.625
        vertex 68.13330078125 -14.833333015441895 -0.625
        vertex 77.86669921875 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 68.13330078125 -14.833333015441895 -0.625
        vertex 77.86669921875 -14.833333015441895 -5.208700180053711
        vertex 77.86669921875 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 68.13330078125 -14.833333015441895 -0.625
        vertex 68.13330078125 -14.833333015441895 -5.208700180053711
        vertex 77.86669921875 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 68.13330078125 -7.166666507720947 -5.208700180053711
        vertex 77.86669921875 -0.5 -5.208700180053711
        vertex 77.86669921875 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 68.13330078125 -7.166666507720947 -5.208700180053711
        vertex 68.13330078125 -0.5 -5.208700180053711
        vertex 77.86669921875 -0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 2.3010054999790975e-16
    outer loop
        vertex 68.13330078125 -0.5 -5.208700180053711
        vertex 77.86669921875 -0.5 -0.625
        vertex 77.86669921875 -0.5 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 2.3010054999790975e-16
    outer loop
        vertex 68.13330078125 -0.5 -5.208700180053711
        vertex 68.13330078125 -0.5 -0.625
        vertex 77.86669921875 -0.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 68.13330078125 -0.5 -0.625
        vertex 77.86669921875 -7.166666507720947 -0.625
        vertex 77.86669921875 -0.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 68.13330078125 -0.5 -0.625
        vertex 68.13330078125 -7.166666507720947 -0.625
        vertex 77.86669921875 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -1.9376887167044945e-16
    outer loop
        vertex 68.13330078125 -7.166666507720947 -0.625
        vertex 77.86669921875 -7.166666507720947 -5.208700180053711
        vertex 77.86669921875 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -1.9376887167044945e-16
    outer loop
        vertex 68.13330078125 -7.166666507720947 -0.625
        vertex 68.13330078125 -7.166666507720947 -5.208700180053711
        vertex 77.86669921875 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 68.13330078125 0.5 -5.208700180053711
        vertex 77.86669921875 7.166666507720947 -5.208700180053711
        vertex 77.86669921875 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 68.13330078125 0.5 -5.208700180053711
        vertex 68.13330078125 7.166666507720947 -5.208700180053711
        vertex 77.86669921875 7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 68.13330078125 7.166666507720947 -5.208700180053711
        vertex 77.86669921875 7.166666507720947 -0.625
        vertex 77.86669921875 7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 68.13330078125 7.166666507720947 -5.208700180053711
        vertex 68.13330078125 7.166666507720947 -0.625
        vertex 77.86669921875 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 68.13330078125 7.166666507720947 -0.625
        vertex 77.86669921875 0.5 -0.625
        vertex 77.86669921875 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 68.13330078125 7.166666507720947 -0.625
        vertex 68.13330078125 0.5 -0.625
        vertex 77.86669921875 0.5 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -2.1798997732053318e-16
    outer loop
        vertex 68.13330078125 0.5 -0.625
        vertex 77.86669921875 0.5 -5.208700180053711
        vertex 77.86669921875 0.5 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -2.1798997732053318e-16
    outer loop
        vertex 68.13330078125 0.5 -0.625
        vertex 68.13330078125 0.5 -5.208700180053711
        vertex 77.86669921875 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 68.13330078125 8.166666984558105 -5.208700180053711
        vertex 77.86669921875 14.833333015441895 -5.208700180053711
        vertex 77.86669921875 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 68.13330078125 8.166666984558105 -5.208700180053711
        vertex 68.13330078125 14.833333015441895 -5.208700180053711
        vertex 77.86669921875 14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 68.13330078125 14.833333015441895 -5.208700180053711
        vertex 77.86669921875 14.833333015441895 -0.625
        vertex 77.86669921875 14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 68.13330078125 14.833333015441895 -5.208700180053711
        vertex 68.13330078125 14.833333015441895 -0.625
        vertex 77.86669921875 14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 68.13330078125 14.833333015441895 -0.625
        vertex 77.86669921875 8.166666984558105 -0.625
        vertex 77.86669921875 14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 68.13330078125 14.833333015441895 -0.625
        vertex 68.13330078125 8.166666984558105 -0.625
        vertex 77.86669921875 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 68.13330078125 8.166666984558105 -0.625
        vertex 77.86669921875 8.166666984558105 -5.208700180053711
        vertex 77.86669921875 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 68.13330078125 8.166666984558105 -0.625
        vertex 68.13330078125 8.166666984558105 -5.208700180053711
        vertex 77.86669921875 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 68.13330078125 15.833333015441895 -5.208700180053711
        vertex 77.86669921875 20.170421600341797 -5.208700180053711
        vertex 77.86669921875 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 68.13330078125 15.833333015441895 -5.208700180053711
        vertex 68.13330078125 20.170421600341797 -5.208700180053711
        vertex 77.86669921875 20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 68.13330078125 20.170421600341797 -5.208700180053711
        vertex 77.86669921875 22.5 -0.625
        vertex 77.86669921875 20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 68.13330078125 20.170421600341797 -5.208700180053711
        vertex 68.13330078125 22.5 -0.625
        vertex 77.86669921875 22.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 68.13330078125 22.5 -0.625
        vertex 77.86669921875 15.833333015441895 -0.625
        vertex 77.86669921875 22.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 68.13330078125 22.5 -0.625
        vertex 68.13330078125 15.833333015441895 -0.625
        vertex 77.86669921875 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 68.13330078125 15.833333015441895 -0.625
        vertex 77.86669921875 15.833333015441895 -5.208700180053711
        vertex 77.86669921875 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 68.13330078125 15.833333015441895 -0.625
        vertex 68.13330078125 15.833333015441895 -5.208700180053711
        vertex 77.86669921875 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.220446049250313e-16 -1.0
    outer loop
        vertex 77.86669921875 -26.0 -5.773159728050814e-15
        vertex 87.5999984741211 26.0 5.773159728050814e-15
        vertex 87.5999984741211 -26.0 -5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.220446049250313e-16 -1.0
    outer loop
        vertex 77.86669921875 -26.0 -5.773159728050814e-15
        vertex 77.86669921875 26.0 5.773159728050814e-15
        vertex 87.5999984741211 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 77.86669921875 26.0 5.773159728050814e-15
        vertex 87.5999984741211 26.0 -0.625
        vertex 87.5999984741211 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 77.86669921875 26.0 5.773159728050814e-15
        vertex 77.86669921875 26.0 -0.625
        vertex 87.5999984741211 26.0 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 77.86669921875 26.0 -0.625
        vertex 87.5999984741211 23.5 -0.625
        vertex 87.5999984741211 26.0 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 77.86669921875 26.0 -0.625
        vertex 77.86669921875 23.5 -0.625
        vertex 87.5999984741211 23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 77.86669921875 23.5 -0.625
        vertex 87.5999984741211 23.5 -0.625
        vertex 87.5999984741211 23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 77.86669921875 23.5 -0.625
        vertex 77.86669921875 23.5 -0.625
        vertex 87.5999984741211 23.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 0.45307403802871704
    outer loop
        vertex 77.86669921875 23.5 -0.625
        vertex 87.5999984741211 20.9375 -5.666999816894531
        vertex 87.5999984741211 23.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 0.45307403802871704
    outer loop
        vertex 77.86669921875 23.5 -0.625
        vertex 77.86669921875 20.9375 -5.666999816894531
        vertex 87.5999984741211 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 -2.1210230424372774e-16 1.0
    outer loop
        vertex 77.86669921875 20.9375 -5.666999816894531
        vertex 87.5999984741211 -20.9375 -5.666999816894531
        vertex 87.5999984741211 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 -2.1210230424372774e-16 1.0
    outer loop
        vertex 77.86669921875 20.9375 -5.666999816894531
        vertex 77.86669921875 -20.9375 -5.666999816894531
        vertex 87.5999984741211 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 0.8914728760719299 0.45307403802871704
    outer loop
        vertex 77.86669921875 -20.9375 -5.666999816894531
        vertex 87.5999984741211 -23.5 -0.625
        vertex 87.5999984741211 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal -0.0 0.8914728760719299 0.45307403802871704
    outer loop
        vertex 77.86669921875 -20.9375 -5.666999816894531
        vertex 77.86669921875 -23.5 -0.625
        vertex 87.5999984741211 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 77.86669921875 -23.5 -0.625
        vertex 87.5999984741211 -23.5 -0.625
        vertex 87.5999984741211 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 77.86669921875 -23.5 -0.625
        vertex 77.86669921875 -23.5 -0.625
        vertex 87.5999984741211 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 77.86669921875 -23.5 -0.625
        vertex 87.5999984741211 -26.0 -0.625
        vertex 87.5999984741211 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 77.86669921875 -23.5 -0.625
        vertex 77.86669921875 -26.0 -0.625
        vertex 87.5999984741211 -26.0 -0.625
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 77.86669921875 -26.0 -0.625
        vertex 87.5999984741211 -26.0 -5.773159728050814e-15
        vertex 87.5999984741211 -26.0 -0.625
    endloop
endfacet
facet normal 0.0 1.0 0.0
    outer loop
        vertex 77.86669921875 -26.0 -0.625
        vertex 77.86669921875 -26.0 -5.773159728050814e-15
        vertex 87.5999984741211 -26.0 -5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 77.86669921875 -20.170421600341797 -5.208700180053711
        vertex 87.5999984741211 -15.833333015441895 -5.208700180053711
        vertex 87.5999984741211 -20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 77.86669921875 -20.170421600341797 -5.208700180053711
        vertex 77.86669921875 -15.833333015441895 -5.208700180053711
        vertex 87.5999984741211 -15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 77.86669921875 -15.833333015441895 -5.208700180053711
        vertex 87.5999984741211 -15.833333015441895 -0.625
        vertex 87.5999984741211 -15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 77.86669921875 -15.833333015441895 -5.208700180053711
        vertex 77.86669921875 -15.833333015441895 -0.625
        vertex 87.5999984741211 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 77.86669921875 -15.833333015441895 -0.625
        vertex 87.5999984741211 -22.5 -0.625
        vertex 87.5999984741211 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 77.86669921875 -15.833333015441895 -0.625
        vertex 77.86669921875 -22.5 -0.625
        vertex 87.5999984741211 -22.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 77.86669921875 -22.5 -0.625
        vertex 87.5999984741211 -20.170421600341797 -5.208700180053711
        vertex 87.5999984741211 -22.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 77.86669921875 -22.5 -0.625
        vertex 77.86669921875 -20.170421600341797 -5.208700180053711
        vertex 87.5999984741211 -20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 77.86669921875 -14.833333015441895 -5.208700180053711
        vertex 87.5999984741211 -8.166666984558105 -5.208700180053711
        vertex 87.5999984741211 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 77.86669921875 -14.833333015441895 -5.208700180053711
        vertex 77.86669921875 -8.166666984558105 -5.208700180053711
        vertex 87.5999984741211 -8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 77.86669921875 -8.166666984558105 -5.208700180053711
        vertex 87.5999984741211 -8.166666984558105 -0.625
        vertex 87.5999984741211 -8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 77.86669921875 -8.166666984558105 -5.208700180053711
        vertex 77.86669921875 -8.166666984558105 -0.625
        vertex 87.5999984741211 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 77.86669921875 -8.166666984558105 -0.625
        vertex 87.5999984741211 -14.833333015441895 -0.625
        vertex 87.5999984741211 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 77.86669921875 -8.166666984558105 -0.625
        vertex 77.86669921875 -14.833333015441895 -0.625
        vertex 87.5999984741211 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 77.86669921875 -14.833333015441895 -0.625
        vertex 87.5999984741211 -14.833333015441895 -5.208700180053711
        vertex 87.5999984741211 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 77.86669921875 -14.833333015441895 -0.625
        vertex 77.86669921875 -14.833333015441895 -5.208700180053711
        vertex 87.5999984741211 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 77.86669921875 -7.166666507720947 -5.208700180053711
        vertex 87.5999984741211 -0.5 -5.208700180053711
        vertex 87.5999984741211 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 77.86669921875 -7.166666507720947 -5.208700180053711
        vertex 77.86669921875 -0.5 -5.208700180053711
        vertex 87.5999984741211 -0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 2.3010054999790975e-16
    outer loop
        vertex 77.86669921875 -0.5 -5.208700180053711
        vertex 87.5999984741211 -0.5 -0.625
        vertex 87.5999984741211 -0.5 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 2.3010054999790975e-16
    outer loop
        vertex 77.86669921875 -0.5 -5.208700180053711
        vertex 77.86669921875 -0.5 -0.625
        vertex 87.5999984741211 -0.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 77.86669921875 -0.5 -0.625
        vertex 87.5999984741211 -7.166666507720947 -0.625
        vertex 87.5999984741211 -0.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 77.86669921875 -0.5 -0.625
        vertex 77.86669921875 -7.166666507720947 -0.625
        vertex 87.5999984741211 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -1.9376887167044945e-16
    outer loop
        vertex 77.86669921875 -7.166666507720947 -0.625
        vertex 87.5999984741211 -7.166666507720947 -5.208700180053711
        vertex 87.5999984741211 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -1.9376887167044945e-16
    outer loop
        vertex 77.86669921875 -7.166666507720947 -0.625
        vertex 77.86669921875 -7.166666507720947 -5.208700180053711
        vertex 87.5999984741211 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 77.86669921875 0.5 -5.208700180053711
        vertex 87.5999984741211 7.166666507720947 -5.208700180053711
        vertex 87.5999984741211 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 77.86669921875 0.5 -5.208700180053711
        vertex 77.86669921875 7.166666507720947 -5.208700180053711
        vertex 87.5999984741211 7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 77.86669921875 7.166666507720947 -5.208700180053711
        vertex 87.5999984741211 7.166666507720947 -0.625
        vertex 87.5999984741211 7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 77.86669921875 7.166666507720947 -5.208700180053711
        vertex 77.86669921875 7.166666507720947 -0.625
        vertex 87.5999984741211 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 77.86669921875 7.166666507720947 -0.625
        vertex 87.5999984741211 0.5 -0.625
        vertex 87.5999984741211 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 77.86669921875 7.166666507720947 -0.625
        vertex 77.86669921875 0.5 -0.625
        vertex 87.5999984741211 0.5 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -2.1798997732053318e-16
    outer loop
        vertex 77.86669921875 0.5 -0.625
        vertex 87.5999984741211 0.5 -5.208700180053711
        vertex 87.5999984741211 0.5 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -2.1798997732053318e-16
    outer loop
        vertex 77.86669921875 0.5 -0.625
        vertex 77.86669921875 0.5 -5.208700180053711
        vertex 87.5999984741211 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 77.86669921875 8.166666984558105 -5.208700180053711
        vertex 87.5999984741211 14.833333015441895 -5.208700180053711
        vertex 87.5999984741211 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 77.86669921875 8.166666984558105 -5.208700180053711
        vertex 77.86669921875 14.833333015441895 -5.208700180053711
        vertex 87.5999984741211 14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 77.86669921875 14.833333015441895 -5.208700180053711
        vertex 87.5999984741211 14.833333015441895 -0.625
        vertex 87.5999984741211 14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 77.86669921875 14.833333015441895 -5.208700180053711
        vertex 77.86669921875 14.833333015441895 -0.625
        vertex 87.5999984741211 14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 77.86669921875 14.833333015441895 -0.625
        vertex 87.5999984741211 8.166666984558105 -0.625
        vertex 87.5999984741211 14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 77.86669921875 14.833333015441895 -0.625
        vertex 77.86669921875 8.166666984558105 -0.625
        vertex 87.5999984741211 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 77.86669921875 8.166666984558105 -0.625
        vertex 87.5999984741211 8.166666984558105 -5.208700180053711
        vertex 87.5999984741211 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 77.86669921875 8.166666984558105 -0.625
        vertex 77.86669921875 8.166666984558105 -5.208700180053711
        vertex 87.5999984741211 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 77.86669921875 15.833333015441895 -5.208700180053711
        vertex 87.5999984741211 20.170421600341797 -5.208700180053711
        vertex 87.5999984741211 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 77.86669921875 15.833333015441895 -5.208700180053711
        vertex 77.86669921875 20.170421600341797 -5.208700180053711
        vertex 87.5999984741211 20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 77.86669921875 20.170421600341797 -5.208700180053711
        vertex 87.5999984741211 22.5 -0.625
        vertex 87.5999984741211 20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 77.86669921875 20.170421600341797 -5.208700180053711
        vertex 77.86669921875 22.5 -0.625
        vertex 87.5999984741211 22.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 77.86669921875 22.5 -0.625
        vertex 87.5999984741211 15.833333015441895 -0.625
        vertex 87.5999984741211 22.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 77.86669921875 22.5 -0.625
        vertex 77.86669921875 15.833333015441895 -0.625
        vertex 87.5999984741211 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 77.86669921875 15.833333015441895 -0.625
        vertex 87.5999984741211 15.833333015441895 -5.208700180053711
        vertex 87.5999984741211 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 77.86669921875 15.833333015441895 -0.625
        vertex 77.86669921875 15.833333015441895 -5.208700180053711
        vertex 87.5999984741211 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.220446049250313e-16 -1.0
    outer loop
        vertex 87.5999984741211 -26.0 -5.773159728050814e-15
        vertex 97.33329772949219 26.0 5.773159728050814e-15
        vertex 97.33329772949219 -26.0 -5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.220446049250313e-16 -1.0
    outer loop
        vertex 87.5999984741211 -26.0 -5.773159728050814e-15
        vertex 87.5999984741211 26.0 5.773159728050814e-15
        vertex 97.33329772949219 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 87.5999984741211 26.0 5.773159728050814e-15
        vertex 97.33329772949219 26.0 -0.625
        vertex 97.33329772949219 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 87.5999984741211 26.0 5.773159728050814e-15
        vertex 87.5999984741211 26.0 -0.625
        vertex 97.33329772949219 26.0 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 87.5999984741211 26.0 -0.625
        vertex 97.33329772949219 23.5 -0.625
        vertex 97.33329772949219 26.0 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 87.5999984741211 26.0 -0.625
        vertex 87.5999984741211 23.5 -0.625
        vertex 97.33329772949219 23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 87.5999984741211 23.5 -0.625
        vertex 97.33329772949219 23.5 -0.625
        vertex 97.33329772949219 23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 87.5999984741211 23.5 -0.625
        vertex 87.5999984741211 23.5 -0.625
        vertex 97.33329772949219 23.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 0.45307403802871704
    outer loop
        vertex 87.5999984741211 23.5 -0.625
        vertex 97.33329772949219 20.9375 -5.666999816894531
        vertex 97.33329772949219 23.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 0.45307403802871704
    outer loop
        vertex 87.5999984741211 23.5 -0.625
        vertex 87.5999984741211 20.9375 -5.666999816894531
        vertex 97.33329772949219 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 -2.1210230424372774e-16 1.0
    outer loop
        vertex 87.5999984741211 20.9375 -5.666999816894531
        vertex 97.33329772949219 -20.9375 -5.666999816894531
        vertex 97.33329772949219 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 -2.1210230424372774e-16 1.0
    outer loop
        vertex 87.5999984741211 20.9375 -5.666999816894531
        vertex 87.5999984741211 -20.9375 -5.666999816894531
        vertex 97.33329772949219 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 0.8914728760719299 0.45307403802871704
    outer loop
        vertex 87.5999984741211 -20.9375 -5.666999816894531
        vertex 97.33329772949219 -23.5 -0.625
        vertex 97.33329772949219 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal -0.0 0.8914728760719299 0.45307403802871704
    outer loop
        vertex 87.5999984741211 -20.9375 -5.666999816894531
        vertex 87.5999984741211 -23.5 -0.625
        vertex 97.33329772949219 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 87.5999984741211 -23.5 -0.625
        vertex 97.33329772949219 -23.5 -0.625
        vertex 97.33329772949219 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 87.5999984741211 -23.5 -0.625
        vertex 87.5999984741211 -23.5 -0.625
        vertex 97.33329772949219 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 87.5999984741211 -23.5 -0.625
        vertex 97.33329772949219 -26.0 -0.625
        vertex 97.33329772949219 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 87.5999984741211 -23.5 -0.625
        vertex 87.5999984741211 -26.0 -0.625
        vertex 97.33329772949219 -26.0 -0.625
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 87.5999984741211 -26.0 -0.625
        vertex 97.33329772949219 -26.0 -5.773159728050814e-15
        vertex 97.33329772949219 -26.0 -0.625
    endloop
endfacet
facet normal 0.0 1.0 0.0
    outer loop
        vertex 87.5999984741211 -26.0 -0.625
        vertex 87.5999984741211 -26.0 -5.773159728050814e-15
        vertex 97.33329772949219 -26.0 -5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 87.5999984741211 -20.170421600341797 -5.208700180053711
        vertex 97.33329772949219 -15.833333015441895 -5.208700180053711
        vertex 97.33329772949219 -20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 87.5999984741211 -20.170421600341797 -5.208700180053711
        vertex 87.5999984741211 -15.833333015441895 -5.208700180053711
        vertex 97.33329772949219 -15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 87.5999984741211 -15.833333015441895 -5.208700180053711
        vertex 97.33329772949219 -15.833333015441895 -0.625
        vertex 97.33329772949219 -15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 87.5999984741211 -15.833333015441895 -5.208700180053711
        vertex 87.5999984741211 -15.833333015441895 -0.625
        vertex 97.33329772949219 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 87.5999984741211 -15.833333015441895 -0.625
        vertex 97.33329772949219 -22.5 -0.625
        vertex 97.33329772949219 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 87.5999984741211 -15.833333015441895 -0.625
        vertex 87.5999984741211 -22.5 -0.625
        vertex 97.33329772949219 -22.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 87.5999984741211 -22.5 -0.625
        vertex 97.33329772949219 -20.170421600341797 -5.208700180053711
        vertex 97.33329772949219 -22.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 87.5999984741211 -22.5 -0.625
        vertex 87.5999984741211 -20.170421600341797 -5.208700180053711
        vertex 97.33329772949219 -20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 87.5999984741211 -14.833333015441895 -5.208700180053711
        vertex 97.33329772949219 -8.166666984558105 -5.208700180053711
        vertex 97.33329772949219 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 87.5999984741211 -14.833333015441895 -5.208700180053711
        vertex 87.5999984741211 -8.166666984558105 -5.208700180053711
        vertex 97.33329772949219 -8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 87.5999984741211 -8.166666984558105 -5.208700180053711
        vertex 97.33329772949219 -8.166666984558105 -0.625
        vertex 97.33329772949219 -8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 87.5999984741211 -8.166666984558105 -5.208700180053711
        vertex 87.5999984741211 -8.166666984558105 -0.625
        vertex 97.33329772949219 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 87.5999984741211 -8.166666984558105 -0.625
        vertex 97.33329772949219 -14.833333015441895 -0.625
        vertex 97.33329772949219 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 87.5999984741211 -8.166666984558105 -0.625
        vertex 87.5999984741211 -14.833333015441895 -0.625
        vertex 97.33329772949219 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 87.5999984741211 -14.833333015441895 -0.625
        vertex 97.33329772949219 -14.833333015441895 -5.208700180053711
        vertex 97.33329772949219 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 87.5999984741211 -14.833333015441895 -0.625
        vertex 87.5999984741211 -14.833333015441895 -5.208700180053711
        vertex 97.33329772949219 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 87.5999984741211 -7.166666507720947 -5.208700180053711
        vertex 97.33329772949219 -0.5 -5.208700180053711
        vertex 97.33329772949219 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 87.5999984741211 -7.166666507720947 -5.208700180053711
        vertex 87.5999984741211 -0.5 -5.208700180053711
        vertex 97.33329772949219 -0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 2.3010054999790975e-16
    outer loop
        vertex 87.5999984741211 -0.5 -5.208700180053711
        vertex 97.33329772949219 -0.5 -0.625
        vertex 97.33329772949219 -0.5 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 2.3010054999790975e-16
    outer loop
        vertex 87.5999984741211 -0.5 -5.208700180053711
        vertex 87.5999984741211 -0.5 -0.625
        vertex 97.33329772949219 -0.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 87.5999984741211 -0.5 -0.625
        vertex 97.33329772949219 -7.166666507720947 -0.625
        vertex 97.33329772949219 -0.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 87.5999984741211 -0.5 -0.625
        vertex 87.5999984741211 -7.166666507720947 -0.625
        vertex 97.33329772949219 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -1.9376887167044945e-16
    outer loop
        vertex 87.5999984741211 -7.166666507720947 -0.625
        vertex 97.33329772949219 -7.166666507720947 -5.208700180053711
        vertex 97.33329772949219 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -1.9376887167044945e-16
    outer loop
        vertex 87.5999984741211 -7.166666507720947 -0.625
        vertex 87.5999984741211 -7.166666507720947 -5.208700180053711
        vertex 97.33329772949219 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 87.5999984741211 0.5 -5.208700180053711
        vertex 97.33329772949219 7.166666507720947 -5.208700180053711
        vertex 97.33329772949219 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 87.5999984741211 0.5 -5.208700180053711
        vertex 87.5999984741211 7.166666507720947 -5.208700180053711
        vertex 97.33329772949219 7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 87.5999984741211 7.166666507720947 -5.208700180053711
        vertex 97.33329772949219 7.166666507720947 -0.625
        vertex 97.33329772949219 7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 87.5999984741211 7.166666507720947 -5.208700180053711
        vertex 87.5999984741211 7.166666507720947 -0.625
        vertex 97.33329772949219 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 87.5999984741211 7.166666507720947 -0.625
        vertex 97.33329772949219 0.5 -0.625
        vertex 97.33329772949219 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 87.5999984741211 7.166666507720947 -0.625
        vertex 87.5999984741211 0.5 -0.625
        vertex 97.33329772949219 0.5 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -2.1798997732053318e-16
    outer loop
        vertex 87.5999984741211 0.5 -0.625
        vertex 97.33329772949219 0.5 -5.208700180053711
        vertex 97.33329772949219 0.5 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -2.1798997732053318e-16
    outer loop
        vertex 87.5999984741211 0.5 -0.625
        vertex 87.5999984741211 0.5 -5.208700180053711
        vertex 97.33329772949219 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 87.5999984741211 8.166666984558105 -5.208700180053711
        vertex 97.33329772949219 14.833333015441895 -5.208700180053711
        vertex 97.33329772949219 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 87.5999984741211 8.166666984558105 -5.208700180053711
        vertex 87.5999984741211 14.833333015441895 -5.208700180053711
        vertex 97.33329772949219 14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 87.5999984741211 14.833333015441895 -5.208700180053711
        vertex 97.33329772949219 14.833333015441895 -0.625
        vertex 97.33329772949219 14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 87.5999984741211 14.833333015441895 -5.208700180053711
        vertex 87.5999984741211 14.833333015441895 -0.625
        vertex 97.33329772949219 14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 87.5999984741211 14.833333015441895 -0.625
        vertex 97.33329772949219 8.166666984558105 -0.625
        vertex 97.33329772949219 14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 87.5999984741211 14.833333015441895 -0.625
        vertex 87.5999984741211 8.166666984558105 -0.625
        vertex 97.33329772949219 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 87.5999984741211 8.166666984558105 -0.625
        vertex 97.33329772949219 8.166666984558105 -5.208700180053711
        vertex 97.33329772949219 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 87.5999984741211 8.166666984558105 -0.625
        vertex 87.5999984741211 8.166666984558105 -5.208700180053711
        vertex 97.33329772949219 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 87.5999984741211 15.833333015441895 -5.208700180053711
        vertex 97.33329772949219 20.170421600341797 -5.208700180053711
        vertex 97.33329772949219 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 87.5999984741211 15.833333015441895 -5.208700180053711
        vertex 87.5999984741211 20.170421600341797 -5.208700180053711
        vertex 97.33329772949219 20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 87.5999984741211 20.170421600341797 -5.208700180053711
        vertex 97.33329772949219 22.5 -0.625
        vertex 97.33329772949219 20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 87.5999984741211 20.170421600341797 -5.208700180053711
        vertex 87.5999984741211 22.5 -0.625
        vertex 97.33329772949219 22.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 87.5999984741211 22.5 -0.625
        vertex 97.33329772949219 15.833333015441895 -0.625
        vertex 97.33329772949219 22.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 87.5999984741211 22.5 -0.625
        vertex 87.5999984741211 15.833333015441895 -0.625
        vertex 97.33329772949219 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 87.5999984741211 15.833333015441895 -0.625
        vertex 97.33329772949219 15.833333015441895 -5.208700180053711
        vertex 97.33329772949219 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 87.5999984741211 15.833333015441895 -0.625
        vertex 87.5999984741211 15.833333015441895 -5.208700180053711
        vertex 97.33329772949219 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.220446049250313e-16 -1.0
    outer loop
        vertex 97.33329772949219 -26.0 -5.773159728050814e-15
        vertex 103.05302429199219 26.0 5.773159728050814e-15
        vertex 111.08097839355469 -26.0 -5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.220446049250313e-16 -1.0
    outer loop
        vertex 97.33329772949219 -26.0 -5.773159728050814e-15
        vertex 97.33329772949219 26.0 5.773159728050814e-15
        vertex 103.05302429199219 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 97.33329772949219 26.0 5.773159728050814e-15
        vertex 103.05302429199219 26.0 -0.625
        vertex 103.05302429199219 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 97.33329772949219 26.0 5.773159728050814e-15
        vertex 97.33329772949219 26.0 -0.625
        vertex 103.05302429199219 26.0 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 97.33329772949219 26.0 -0.625
        vertex 103.43898010253906 23.5 -0.625
        vertex 103.05302429199219 26.0 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 97.33329772949219 26.0 -0.625
        vertex 97.33329772949219 23.5 -0.625
        vertex 103.43898010253906 23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 97.33329772949219 23.5 -0.625
        vertex 103.43898010253906 23.5 -0.625
        vertex 103.43898010253906 23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 97.33329772949219 23.5 -0.625
        vertex 97.33329772949219 23.5 -0.625
        vertex 103.43898010253906 23.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 0.45307403802871704
    outer loop
        vertex 97.33329772949219 23.5 -0.625
        vertex 103.83458709716797 20.9375 -5.666999816894531
        vertex 103.43898010253906 23.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 0.45307403802871704
    outer loop
        vertex 97.33329772949219 23.5 -0.625
        vertex 97.33329772949219 20.9375 -5.666999816894531
        vertex 103.83458709716797 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 -2.1210230424372774e-16 1.0
    outer loop
        vertex 97.33329772949219 20.9375 -5.666999816894531
        vertex 110.29940795898438 -20.9375 -5.666999816894531
        vertex 103.83458709716797 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 -2.1210230424372774e-16 1.0
    outer loop
        vertex 97.33329772949219 20.9375 -5.666999816894531
        vertex 97.33329772949219 -20.9375 -5.666999816894531
        vertex 110.29940795898438 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 0.8914728760719299 0.45307403802871704
    outer loop
        vertex 97.33329772949219 -20.9375 -5.666999816894531
        vertex 110.69501495361328 -23.5 -0.625
        vertex 110.29940795898438 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal -0.0 0.8914728760719299 0.45307403802871704
    outer loop
        vertex 97.33329772949219 -20.9375 -5.666999816894531
        vertex 97.33329772949219 -23.5 -0.625
        vertex 110.69501495361328 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 97.33329772949219 -23.5 -0.625
        vertex 110.69501495361328 -23.5 -0.625
        vertex 110.69501495361328 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 97.33329772949219 -23.5 -0.625
        vertex 97.33329772949219 -23.5 -0.625
        vertex 110.69501495361328 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 97.33329772949219 -23.5 -0.625
        vertex 111.08097839355469 -26.0 -0.625
        vertex 110.69501495361328 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 97.33329772949219 -23.5 -0.625
        vertex 97.33329772949219 -26.0 -0.625
        vertex 111.08097839355469 -26.0 -0.625
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 97.33329772949219 -26.0 -0.625
        vertex 111.08097839355469 -26.0 -5.773159728050814e-15
        vertex 111.08097839355469 -26.0 -0.625
    endloop
endfacet
facet normal 0.0 1.0 0.0
    outer loop
        vertex 97.33329772949219 -26.0 -0.625
        vertex 97.33329772949219 -26.0 -5.773159728050814e-15
        vertex 111.08097839355469 -26.0 -5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 97.33329772949219 -20.170421600341797 -5.208700180053711
        vertex 109.51140594482422 -15.833333015441895 -5.208700180053711
        vertex 110.18098449707031 -20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 97.33329772949219 -20.170421600341797 -5.208700180053711
        vertex 97.33329772949219 -15.833333015441895 -5.208700180053711
        vertex 109.51140594482422 -15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 97.33329772949219 -15.833333015441895 -5.208700180053711
        vertex 109.51140594482422 -15.833333015441895 -0.625
        vertex 109.51140594482422 -15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 97.33329772949219 -15.833333015441895 -5.208700180053711
        vertex 97.33329772949219 -15.833333015441895 -0.625
        vertex 109.51140594482422 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 97.33329772949219 -15.833333015441895 -0.625
        vertex 110.54063415527344 -22.5 -0.625
        vertex 109.51140594482422 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 97.33329772949219 -15.833333015441895 -0.625
        vertex 97.33329772949219 -22.5 -0.625
        vertex 110.54063415527344 -22.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 97.33329772949219 -22.5 -0.625
        vertex 110.18098449707031 -20.170421600341797 -5.208700180053711
        vertex 110.54063415527344 -22.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 97.33329772949219 -22.5 -0.625
        vertex 97.33329772949219 -20.170421600341797 -5.208700180053711
        vertex 110.18098449707031 -20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 97.33329772949219 -14.833333015441895 -5.208700180053711
        vertex 108.32779693603516 -8.166666984558105 -5.208700180053711
        vertex 109.35702514648438 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 97.33329772949219 -14.833333015441895 -5.208700180053711
        vertex 97.33329772949219 -8.166666984558105 -5.208700180053711
        vertex 108.32779693603516 -8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 97.33329772949219 -8.166666984558105 -5.208700180053711
        vertex 108.32779693603516 -8.166666984558105 -0.625
        vertex 108.32779693603516 -8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 97.33329772949219 -8.166666984558105 -5.208700180053711
        vertex 97.33329772949219 -8.166666984558105 -0.625
        vertex 108.32779693603516 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 97.33329772949219 -8.166666984558105 -0.625
        vertex 109.35702514648438 -14.833333015441895 -0.625
        vertex 108.32779693603516 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 97.33329772949219 -8.166666984558105 -0.625
        vertex 97.33329772949219 -14.833333015441895 -0.625
        vertex 109.35702514648438 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 97.33329772949219 -14.833333015441895 -0.625
        vertex 109.35702514648438 -14.833333015441895 -5.208700180053711
        vertex 109.35702514648438 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 97.33329772949219 -14.833333015441895 -0.625
        vertex 97.33329772949219 -14.833333015441895 -5.208700180053711
        vertex 109.35702514648438 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 97.33329772949219 -7.166666507720947 -5.208700180053711
        vertex 107.14419555664062 -0.5 -5.208700180053711
        vertex 108.17341613769531 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 97.33329772949219 -7.166666507720947 -5.208700180053711
        vertex 97.33329772949219 -0.5 -5.208700180053711
        vertex 107.14419555664062 -0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 2.3010054999790975e-16
    outer loop
        vertex 97.33329772949219 -0.5 -5.208700180053711
        vertex 107.14419555664062 -0.5 -0.625
        vertex 107.14419555664062 -0.5 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 2.3010054999790975e-16
    outer loop
        vertex 97.33329772949219 -0.5 -5.208700180053711
        vertex 97.33329772949219 -0.5 -0.625
        vertex 107.14419555664062 -0.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 97.33329772949219 -0.5 -0.625
        vertex 108.17341613769531 -7.166666507720947 -0.625
        vertex 107.14419555664062 -0.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 97.33329772949219 -0.5 -0.625
        vertex 97.33329772949219 -7.166666507720947 -0.625
        vertex 108.17341613769531 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -1.9376887167044945e-16
    outer loop
        vertex 97.33329772949219 -7.166666507720947 -0.625
        vertex 108.17341613769531 -7.166666507720947 -5.208700180053711
        vertex 108.17341613769531 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -1.9376887167044945e-16
    outer loop
        vertex 97.33329772949219 -7.166666507720947 -0.625
        vertex 97.33329772949219 -7.166666507720947 -5.208700180053711
        vertex 108.17341613769531 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 97.33329772949219 0.5 -5.208700180053711
        vertex 105.96058654785156 7.166666507720947 -5.208700180053711
        vertex 106.98980712890625 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 97.33329772949219 0.5 -5.208700180053711
        vertex 97.33329772949219 7.166666507720947 -5.208700180053711
        vertex 105.96058654785156 7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 97.33329772949219 7.166666507720947 -5.208700180053711
        vertex 105.96058654785156 7.166666507720947 -0.625
        vertex 105.96058654785156 7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 97.33329772949219 7.166666507720947 -5.208700180053711
        vertex 97.33329772949219 7.166666507720947 -0.625
        vertex 105.96058654785156 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 97.33329772949219 7.166666507720947 -0.625
        vertex 106.98980712890625 0.5 -0.625
        vertex 105.96058654785156 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 97.33329772949219 7.166666507720947 -0.625
        vertex 97.33329772949219 0.5 -0.625
        vertex 106.98980712890625 0.5 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -2.1798997732053318e-16
    outer loop
        vertex 97.33329772949219 0.5 -0.625
        vertex 106.98980712890625 0.5 -5.208700180053711
        vertex 106.98980712890625 0.5 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -2.1798997732053318e-16
    outer loop
        vertex 97.33329772949219 0.5 -0.625
        vertex 97.33329772949219 0.5 -5.208700180053711
        vertex 106.98980712890625 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 97.33329772949219 8.166666984558105 -5.208700180053711
        vertex 104.7769775390625 14.833333015441895 -5.208700180053711
        vertex 105.80619812011719 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 97.33329772949219 8.166666984558105 -5.208700180053711
        vertex 97.33329772949219 14.833333015441895 -5.208700180053711
        vertex 104.7769775390625 14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 97.33329772949219 14.833333015441895 -5.208700180053711
        vertex 104.7769775390625 14.833333015441895 -0.625
        vertex 104.7769775390625 14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 97.33329772949219 14.833333015441895 -5.208700180053711
        vertex 97.33329772949219 14.833333015441895 -0.625
        vertex 104.7769775390625 14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 97.33329772949219 14.833333015441895 -0.625
        vertex 105.80619812011719 8.166666984558105 -0.625
        vertex 104.7769775390625 14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 97.33329772949219 14.833333015441895 -0.625
        vertex 97.33329772949219 8.166666984558105 -0.625
        vertex 105.80619812011719 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 97.33329772949219 8.166666984558105 -0.625
        vertex 105.80619812011719 8.166666984558105 -5.208700180053711
        vertex 105.80619812011719 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 97.33329772949219 8.166666984558105 -0.625
        vertex 97.33329772949219 8.166666984558105 -5.208700180053711
        vertex 105.80619812011719 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 97.33329772949219 15.833333015441895 -5.208700180053711
        vertex 103.95301818847656 20.170421600341797 -5.208700180053711
        vertex 104.62258911132812 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 97.33329772949219 15.833333015441895 -5.208700180053711
        vertex 97.33329772949219 20.170421600341797 -5.208700180053711
        vertex 103.95301818847656 20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 97.33329772949219 20.170421600341797 -5.208700180053711
        vertex 103.59336853027344 22.5 -0.625
        vertex 103.95301818847656 20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 97.33329772949219 20.170421600341797 -5.208700180053711
        vertex 97.33329772949219 22.5 -0.625
        vertex 103.59336853027344 22.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 97.33329772949219 22.5 -0.625
        vertex 104.62258911132812 15.833333015441895 -0.625
        vertex 103.59336853027344 22.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 97.33329772949219 22.5 -0.625
        vertex 97.33329772949219 15.833333015441895 -0.625
        vertex 104.62258911132812 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 97.33329772949219 15.833333015441895 -0.625
        vertex 104.62258911132812 15.833333015441895 -5.208700180053711
        vertex 104.62258911132812 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 97.33329772949219 15.833333015441895 -0.625
        vertex 97.33329772949219 15.833333015441895 -5.208700180053711
        vertex 104.62258911132812 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.220446049250313e-16 -1.0
    outer loop
        vertex 111.08097839355469 -26.0 -5.773159728050814e-15
        vertex 109.04452514648438 26.0 5.773159728050814e-15
        vertex 124.55547332763672 -26.0 -5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.220446049250313e-16 -1.0
    outer loop
        vertex 111.08097839355469 -26.0 -5.773159728050814e-15
        vertex 103.05302429199219 26.0 5.773159728050814e-15
        vertex 109.04452514648438 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 103.05302429199219 26.0 5.773159728050814e-15
        vertex 109.04452514648438 26.0 -0.625
        vertex 109.04452514648438 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 103.05302429199219 26.0 5.773159728050814e-15
        vertex 103.05302429199219 26.0 -0.625
        vertex 109.04452514648438 26.0 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 103.05302429199219 26.0 -0.625
        vertex 109.79024505615234 23.5 -0.625
        vertex 109.04452514648438 26.0 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 103.05302429199219 26.0 -0.625
        vertex 103.43898010253906 23.5 -0.625
        vertex 109.79024505615234 23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 103.43898010253906 23.5 -0.625
        vertex 109.79024505615234 23.5 -0.625
        vertex 109.79024505615234 23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 103.43898010253906 23.5 -0.625
        vertex 103.43898010253906 23.5 -0.625
        vertex 109.79024505615234 23.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 0.45307403802871704
    outer loop
        vertex 103.43898010253906 23.5 -0.625
        vertex 110.55461120605469 20.9375 -5.666999816894531
        vertex 109.79024505615234 23.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 0.45307403802871704
    outer loop
        vertex 103.43898010253906 23.5 -0.625
        vertex 103.83458709716797 20.9375 -5.666999816894531
        vertex 110.55461120605469 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 -2.1210230424372774e-16 1.0
    outer loop
        vertex 103.83458709716797 20.9375 -5.666999816894531
        vertex 123.04539489746094 -20.9375 -5.666999816894531
        vertex 110.55461120605469 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 -2.1210230424372774e-16 1.0
    outer loop
        vertex 103.83458709716797 20.9375 -5.666999816894531
        vertex 110.29940795898438 -20.9375 -5.666999816894531
        vertex 123.04539489746094 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 0.8914728760719299 0.45307403802871704
    outer loop
        vertex 110.29940795898438 -20.9375 -5.666999816894531
        vertex 123.80975341796875 -23.5 -0.625
        vertex 123.04539489746094 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal -0.0 0.8914728760719299 0.45307403802871704
    outer loop
        vertex 110.29940795898438 -20.9375 -5.666999816894531
        vertex 110.69501495361328 -23.5 -0.625
        vertex 123.80975341796875 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 110.69501495361328 -23.5 -0.625
        vertex 123.80975341796875 -23.5 -0.625
        vertex 123.80975341796875 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 110.69501495361328 -23.5 -0.625
        vertex 110.69501495361328 -23.5 -0.625
        vertex 123.80975341796875 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 110.69501495361328 -23.5 -0.625
        vertex 124.55547332763672 -26.0 -0.625
        vertex 123.80975341796875 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 110.69501495361328 -23.5 -0.625
        vertex 111.08097839355469 -26.0 -0.625
        vertex 124.55547332763672 -26.0 -0.625
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 111.08097839355469 -26.0 -0.625
        vertex 124.55547332763672 -26.0 -5.773159728050814e-15
        vertex 124.55547332763672 -26.0 -0.625
    endloop
endfacet
facet normal 0.0 1.0 0.0
    outer loop
        vertex 111.08097839355469 -26.0 -0.625
        vertex 111.08097839355469 -26.0 -5.773159728050814e-15
        vertex 124.55547332763672 -26.0 -5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 110.18098449707031 -20.170421600341797 -5.208700180053711
        vertex 121.52288055419922 -15.833333015441895 -5.208700180053711
        vertex 122.81658172607422 -20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 110.18098449707031 -20.170421600341797 -5.208700180053711
        vertex 109.51140594482422 -15.833333015441895 -5.208700180053711
        vertex 121.52288055419922 -15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 109.51140594482422 -15.833333015441895 -5.208700180053711
        vertex 121.52288055419922 -15.833333015441895 -0.625
        vertex 121.52288055419922 -15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 109.51140594482422 -15.833333015441895 -5.208700180053711
        vertex 109.51140594482422 -15.833333015441895 -0.625
        vertex 121.52288055419922 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 109.51140594482422 -15.833333015441895 -0.625
        vertex 123.51146697998047 -22.5 -0.625
        vertex 121.52288055419922 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 109.51140594482422 -15.833333015441895 -0.625
        vertex 110.54063415527344 -22.5 -0.625
        vertex 123.51146697998047 -22.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 110.54063415527344 -22.5 -0.625
        vertex 122.81658172607422 -20.170421600341797 -5.208700180053711
        vertex 123.51146697998047 -22.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 110.54063415527344 -22.5 -0.625
        vertex 110.18098449707031 -20.170421600341797 -5.208700180053711
        vertex 122.81658172607422 -20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 109.35702514648438 -14.833333015441895 -5.208700180053711
        vertex 119.23601531982422 -8.166666984558105 -5.208700180053711
        vertex 121.22459411621094 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 109.35702514648438 -14.833333015441895 -5.208700180053711
        vertex 108.32779693603516 -8.166666984558105 -5.208700180053711
        vertex 119.23601531982422 -8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 108.32779693603516 -8.166666984558105 -5.208700180053711
        vertex 119.23601531982422 -8.166666984558105 -0.625
        vertex 119.23601531982422 -8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 108.32779693603516 -8.166666984558105 -5.208700180053711
        vertex 108.32779693603516 -8.166666984558105 -0.625
        vertex 119.23601531982422 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 108.32779693603516 -8.166666984558105 -0.625
        vertex 121.22459411621094 -14.833333015441895 -0.625
        vertex 119.23601531982422 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 108.32779693603516 -8.166666984558105 -0.625
        vertex 109.35702514648438 -14.833333015441895 -0.625
        vertex 121.22459411621094 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 109.35702514648438 -14.833333015441895 -0.625
        vertex 121.22459411621094 -14.833333015441895 -5.208700180053711
        vertex 121.22459411621094 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 109.35702514648438 -14.833333015441895 -0.625
        vertex 109.35702514648438 -14.833333015441895 -5.208700180053711
        vertex 121.22459411621094 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 108.17341613769531 -7.166666507720947 -5.208700180053711
        vertex 116.94914245605469 -0.5 -5.208700180053711
        vertex 118.93772888183594 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 108.17341613769531 -7.166666507720947 -5.208700180053711
        vertex 107.14419555664062 -0.5 -5.208700180053711
        vertex 116.94914245605469 -0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 2.3010054999790975e-16
    outer loop
        vertex 107.14419555664062 -0.5 -5.208700180053711
        vertex 116.94914245605469 -0.5 -0.625
        vertex 116.94914245605469 -0.5 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 2.3010054999790975e-16
    outer loop
        vertex 107.14419555664062 -0.5 -5.208700180053711
        vertex 107.14419555664062 -0.5 -0.625
        vertex 116.94914245605469 -0.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 107.14419555664062 -0.5 -0.625
        vertex 118.93772888183594 -7.166666507720947 -0.625
        vertex 116.94914245605469 -0.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 107.14419555664062 -0.5 -0.625
        vertex 108.17341613769531 -7.166666507720947 -0.625
        vertex 118.93772888183594 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -1.9376887167044945e-16
    outer loop
        vertex 108.17341613769531 -7.166666507720947 -0.625
        vertex 118.93772888183594 -7.166666507720947 -5.208700180053711
        vertex 118.93772888183594 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -1.9376887167044945e-16
    outer loop
        vertex 108.17341613769531 -7.166666507720947 -0.625
        vertex 108.17341613769531 -7.166666507720947 -5.208700180053711
        vertex 118.93772888183594 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 106.98980712890625 0.5 -5.208700180053711
        vertex 114.66227722167969 7.166666507720947 -5.208700180053711
        vertex 116.6508560180664 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 106.98980712890625 0.5 -5.208700180053711
        vertex 105.96058654785156 7.166666507720947 -5.208700180053711
        vertex 114.66227722167969 7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 105.96058654785156 7.166666507720947 -5.208700180053711
        vertex 114.66227722167969 7.166666507720947 -0.625
        vertex 114.66227722167969 7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 105.96058654785156 7.166666507720947 -5.208700180053711
        vertex 105.96058654785156 7.166666507720947 -0.625
        vertex 114.66227722167969 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 105.96058654785156 7.166666507720947 -0.625
        vertex 116.6508560180664 0.5 -0.625
        vertex 114.66227722167969 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 105.96058654785156 7.166666507720947 -0.625
        vertex 106.98980712890625 0.5 -0.625
        vertex 116.6508560180664 0.5 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -2.1798997732053318e-16
    outer loop
        vertex 106.98980712890625 0.5 -0.625
        vertex 116.6508560180664 0.5 -5.208700180053711
        vertex 116.6508560180664 0.5 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -2.1798997732053318e-16
    outer loop
        vertex 106.98980712890625 0.5 -0.625
        vertex 106.98980712890625 0.5 -5.208700180053711
        vertex 116.6508560180664 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 105.80619812011719 8.166666984558105 -5.208700180053711
        vertex 112.37540435791016 14.833333015441895 -5.208700180053711
        vertex 114.36398315429688 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 105.80619812011719 8.166666984558105 -5.208700180053711
        vertex 104.7769775390625 14.833333015441895 -5.208700180053711
        vertex 112.37540435791016 14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 104.7769775390625 14.833333015441895 -5.208700180053711
        vertex 112.37540435791016 14.833333015441895 -0.625
        vertex 112.37540435791016 14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 104.7769775390625 14.833333015441895 -5.208700180053711
        vertex 104.7769775390625 14.833333015441895 -0.625
        vertex 112.37540435791016 14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 104.7769775390625 14.833333015441895 -0.625
        vertex 114.36398315429688 8.166666984558105 -0.625
        vertex 112.37540435791016 14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 104.7769775390625 14.833333015441895 -0.625
        vertex 105.80619812011719 8.166666984558105 -0.625
        vertex 114.36398315429688 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 105.80619812011719 8.166666984558105 -0.625
        vertex 114.36398315429688 8.166666984558105 -5.208700180053711
        vertex 114.36398315429688 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 105.80619812011719 8.166666984558105 -0.625
        vertex 105.80619812011719 8.166666984558105 -5.208700180053711
        vertex 114.36398315429688 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 104.62258911132812 15.833333015441895 -5.208700180053711
        vertex 110.78341674804688 20.170421600341797 -5.208700180053711
        vertex 112.07711791992188 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 104.62258911132812 15.833333015441895 -5.208700180053711
        vertex 103.95301818847656 20.170421600341797 -5.208700180053711
        vertex 110.78341674804688 20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 103.95301818847656 20.170421600341797 -5.208700180053711
        vertex 110.08853149414062 22.5 -0.625
        vertex 110.78341674804688 20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 103.95301818847656 20.170421600341797 -5.208700180053711
        vertex 103.59336853027344 22.5 -0.625
        vertex 110.08853149414062 22.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 103.59336853027344 22.5 -0.625
        vertex 112.07711791992188 15.833333015441895 -0.625
        vertex 110.08853149414062 22.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 103.59336853027344 22.5 -0.625
        vertex 104.62258911132812 15.833333015441895 -0.625
        vertex 112.07711791992188 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 104.62258911132812 15.833333015441895 -0.625
        vertex 112.07711791992188 15.833333015441895 -5.208700180053711
        vertex 112.07711791992188 15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 104.62258911132812 15.833333015441895 -0.625
        vertex 104.62258911132812 15.833333015441895 -5.208700180053711
        vertex 112.07711791992188 15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.220446049250313e-16 -1.0
    outer loop
        vertex 124.55547332763672 -26.0 -5.773159728050814e-15
        vertex 115.49730682373047 26.0 5.773159728050814e-15
        vertex 137.56869506835938 -26.0 -5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.220446049250313e-16 -1.0
    outer loop
        vertex 124.55547332763672 -26.0 -5.773159728050814e-15
        vertex 109.04452514648438 26.0 5.773159728050814e-15
        vertex 115.49730682373047 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 109.04452514648438 26.0 5.773159728050814e-15
        vertex 115.49730682373047 26.0 -0.625
        vertex 115.49730682373047 26.0 5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 -1.0 0.0
    outer loop
        vertex 109.04452514648438 26.0 5.773159728050814e-15
        vertex 109.04452514648438 26.0 -0.625
        vertex 115.49730682373047 26.0 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 109.04452514648438 26.0 -0.625
        vertex 116.55843353271484 23.5 -0.625
        vertex 115.49730682373047 26.0 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 109.04452514648438 26.0 -0.625
        vertex 109.79024505615234 23.5 -0.625
        vertex 116.55843353271484 23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 109.79024505615234 23.5 -0.625
        vertex 116.55843353271484 23.5 -0.625
        vertex 116.55843353271484 23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 109.79024505615234 23.5 -0.625
        vertex 109.79024505615234 23.5 -0.625
        vertex 116.55843353271484 23.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 0.45307403802871704
    outer loop
        vertex 109.79024505615234 23.5 -0.625
        vertex 117.64608001708984 20.9375 -5.666999816894531
        vertex 116.55843353271484 23.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 0.45307403802871704
    outer loop
        vertex 109.79024505615234 23.5 -0.625
        vertex 110.55461120605469 20.9375 -5.666999816894531
        vertex 117.64608001708984 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 -2.1210230424372774e-16 1.0
    outer loop
        vertex 110.55461120605469 20.9375 -5.666999816894531
        vertex 135.419921875 -20.9375 -5.666999816894531
        vertex 117.64608001708984 20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 -2.1210230424372774e-16 1.0
    outer loop
        vertex 110.55461120605469 20.9375 -5.666999816894531
        vertex 123.04539489746094 -20.9375 -5.666999816894531
        vertex 135.419921875 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal 0.0 0.8914728760719299 0.45307403802871704
    outer loop
        vertex 123.04539489746094 -20.9375 -5.666999816894531
        vertex 136.507568359375 -23.5 -0.625
        vertex 135.419921875 -20.9375 -5.666999816894531
    endloop
endfacet
facet normal -0.0 0.8914728760719299 0.45307403802871704
    outer loop
        vertex 123.04539489746094 -20.9375 -5.666999816894531
        vertex 123.80975341796875 -23.5 -0.625
        vertex 136.507568359375 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 123.80975341796875 -23.5 -0.625
        vertex 136.507568359375 -23.5 -0.625
        vertex 136.507568359375 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 0.0 0.0
    outer loop
        vertex 123.80975341796875 -23.5 -0.625
        vertex 123.80975341796875 -23.5 -0.625
        vertex 136.507568359375 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 123.80975341796875 -23.5 -0.625
        vertex 137.56869506835938 -26.0 -0.625
        vertex 136.507568359375 -23.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.220446049250313e-16 1.0
    outer loop
        vertex 123.80975341796875 -23.5 -0.625
        vertex 124.55547332763672 -26.0 -0.625
        vertex 137.56869506835938 -26.0 -0.625
    endloop
endfacet
facet normal -0.0 1.0 0.0
    outer loop
        vertex 124.55547332763672 -26.0 -0.625
        vertex 137.56869506835938 -26.0 -5.773159728050814e-15
        vertex 137.56869506835938 -26.0 -0.625
    endloop
endfacet
facet normal 0.0 1.0 0.0
    outer loop
        vertex 124.55547332763672 -26.0 -0.625
        vertex 124.55547332763672 -26.0 -5.773159728050814e-15
        vertex 137.56869506835938 -26.0 -5.773159728050814e-15
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 122.81658172607422 -20.170421600341797 -5.208700180053711
        vertex 133.25344848632812 -15.833333015441895 -5.208700180053711
        vertex 135.09432983398438 -20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 122.81658172607422 -20.170421600341797 -5.208700180053711
        vertex 121.52288055419922 -15.833333015441895 -5.208700180053711
        vertex 133.25344848632812 -15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 121.52288055419922 -15.833333015441895 -5.208700180053711
        vertex 133.25344848632812 -15.833333015441895 -0.625
        vertex 133.25344848632812 -15.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 121.52288055419922 -15.833333015441895 -5.208700180053711
        vertex 121.52288055419922 -15.833333015441895 -0.625
        vertex 133.25344848632812 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 121.52288055419922 -15.833333015441895 -0.625
        vertex 136.08311462402344 -22.5 -0.625
        vertex 133.25344848632812 -15.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649348186097164e-16 1.0
    outer loop
        vertex 121.52288055419922 -15.833333015441895 -0.625
        vertex 123.51146697998047 -22.5 -0.625
        vertex 136.08311462402344 -22.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 123.51146697998047 -22.5 -0.625
        vertex 135.09432983398438 -20.170421600341797 -5.208700180053711
        vertex 136.08311462402344 -22.5 -0.625
    endloop
endfacet
facet normal 0.0 -0.8914728760719299 -0.4530741274356842
    outer loop
        vertex 123.51146697998047 -22.5 -0.625
        vertex 122.81658172607422 -20.170421600341797 -5.208700180053711
        vertex 135.09432983398438 -20.170421600341797 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 121.22459411621094 -14.833333015441895 -5.208700180053711
        vertex 129.9993438720703 -8.166666984558105 -5.208700180053711
        vertex 132.82901000976562 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 121.22459411621094 -14.833333015441895 -5.208700180053711
        vertex 119.23601531982422 -8.166666984558105 -5.208700180053711
        vertex 129.9993438720703 -8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 119.23601531982422 -8.166666984558105 -5.208700180053711
        vertex 129.9993438720703 -8.166666984558105 -0.625
        vertex 129.9993438720703 -8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 119.23601531982422 -8.166666984558105 -5.208700180053711
        vertex 119.23601531982422 -8.166666984558105 -0.625
        vertex 129.9993438720703 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 119.23601531982422 -8.166666984558105 -0.625
        vertex 132.82901000976562 -14.833333015441895 -0.625
        vertex 129.9993438720703 -8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 119.23601531982422 -8.166666984558105 -0.625
        vertex 121.22459411621094 -14.833333015441895 -0.625
        vertex 132.82901000976562 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 121.22459411621094 -14.833333015441895 -0.625
        vertex 132.82901000976562 -14.833333015441895 -5.208700180053711
        vertex 132.82901000976562 -14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 121.22459411621094 -14.833333015441895 -0.625
        vertex 121.22459411621094 -14.833333015441895 -5.208700180053711
        vertex 132.82901000976562 -14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 118.93772888183594 -7.166666507720947 -5.208700180053711
        vertex 126.74522399902344 -0.5 -5.208700180053711
        vertex 129.57489013671875 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 118.93772888183594 -7.166666507720947 -5.208700180053711
        vertex 116.94914245605469 -0.5 -5.208700180053711
        vertex 126.74522399902344 -0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 2.3010054999790975e-16
    outer loop
        vertex 116.94914245605469 -0.5 -5.208700180053711
        vertex 126.74522399902344 -0.5 -0.625
        vertex 126.74522399902344 -0.5 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 2.3010054999790975e-16
    outer loop
        vertex 116.94914245605469 -0.5 -5.208700180053711
        vertex 116.94914245605469 -0.5 -0.625
        vertex 126.74522399902344 -0.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 116.94914245605469 -0.5 -0.625
        vertex 129.57489013671875 -7.166666507720947 -0.625
        vertex 126.74522399902344 -0.5 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 116.94914245605469 -0.5 -0.625
        vertex 118.93772888183594 -7.166666507720947 -0.625
        vertex 129.57489013671875 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -1.9376887167044945e-16
    outer loop
        vertex 118.93772888183594 -7.166666507720947 -0.625
        vertex 129.57489013671875 -7.166666507720947 -5.208700180053711
        vertex 129.57489013671875 -7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -1.9376887167044945e-16
    outer loop
        vertex 118.93772888183594 -7.166666507720947 -0.625
        vertex 118.93772888183594 -7.166666507720947 -5.208700180053711
        vertex 129.57489013671875 -7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 116.6508560180664 0.5 -5.208700180053711
        vertex 123.4911117553711 7.166666507720947 -5.208700180053711
        vertex 126.3207778930664 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.664535364979494e-16 -1.0
    outer loop
        vertex 116.6508560180664 0.5 -5.208700180053711
        vertex 114.66227722167969 7.166666507720947 -5.208700180053711
        vertex 123.4911117553711 7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 114.66227722167969 7.166666507720947 -5.208700180053711
        vertex 123.4911117553711 7.166666507720947 -0.625
        vertex 123.4911117553711 7.166666507720947 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 114.66227722167969 7.166666507720947 -5.208700180053711
        vertex 114.66227722167969 7.166666507720947 -0.625
        vertex 123.4911117553711 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 114.66227722167969 7.166666507720947 -0.625
        vertex 126.3207778930664 0.5 -0.625
        vertex 123.4911117553711 7.166666507720947 -0.625
    endloop
endfacet
facet normal 0.0 -2.1649349509586145e-16 1.0
    outer loop
        vertex 114.66227722167969 7.166666507720947 -0.625
        vertex 116.6508560180664 0.5 -0.625
        vertex 126.3207778930664 0.5 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -2.1798997732053318e-16
    outer loop
        vertex 116.6508560180664 0.5 -0.625
        vertex 126.3207778930664 0.5 -5.208700180053711
        vertex 126.3207778930664 0.5 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -2.1798997732053318e-16
    outer loop
        vertex 116.6508560180664 0.5 -0.625
        vertex 116.6508560180664 0.5 -5.208700180053711
        vertex 126.3207778930664 0.5 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 114.36398315429688 8.166666984558105 -5.208700180053711
        vertex 120.23699188232422 14.833333015441895 -5.208700180053711
        vertex 123.06665802001953 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.66453562967729e-16 -1.0
    outer loop
        vertex 114.36398315429688 8.166666984558105 -5.208700180053711
        vertex 112.37540435791016 14.833333015441895 -5.208700180053711
        vertex 120.23699188232422 14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal 0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 112.37540435791016 14.833333015441895 -5.208700180053711
        vertex 120.23699188232422 14.833333015441895 -0.625
        vertex 120.23699188232422 14.833333015441895 -5.208700180053711
    endloop
endfacet
facet normal -0.0 1.0 3.875377433408989e-16
    outer loop
        vertex 112.37540435791016 14.833333015441895 -5.208700180053711
        vertex 112.37540435791016 14.833333015441895 -0.625
        vertex 120.23699188232422 14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 112.37540435791016 14.833333015441895 -0.625
        vertex 123.06665802001953 8.166666984558105 -0.625
        vertex 120.23699188232422 14.833333015441895 -0.625
    endloop
endfacet
facet normal 0.0 -2.3314685105315063e-16 1.0
    outer loop
        vertex 112.37540435791016 14.833333015441895 -0.625
        vertex 114.36398315429688 8.166666984558105 -0.625
        vertex 123.06665802001953 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 114.36398315429688 8.166666984558105 -0.625
        vertex 123.06665802001953 8.166666984558105 -5.208700180053711
        vertex 123.06665802001953 8.166666984558105 -0.625
    endloop
endfacet
facet normal 0.0 -1.0 -3.875377433408989e-16
    outer loop
        vertex 114.36398315429688 8.166666984558105 -0.625
        vertex 114.36398315429688 8.166666984558105 -5.208700180053711
        vertex 123.06665802001953 8.166666984558105 -5.208700180053711
    endloop
endfacet
facet normal 0.0 2.0478678508075777e-16 -1.0
    outer loop
        vertex 112.07711791992188 15.833333015441895 -5.208700180053711
        vertex 117.97167205810547 20.170421600341797 -5.208700180053711
        vertex 119.81254577636719 15.833333015441895 -5.208700180053711
    endloop
e