# Compiling

1. Clone the package repository:
   ``` shell
   git clone https://github.com/claudioperez/OpenSeesRT
   ```

2. install *run-time* dependencies. These are the libraries that will be needed 
   in order to use OpenSees. To install these, run:
   ```bash
   python -m pip install opensees
   ```


2. Install *compile-time* dependencies; see **Dependencies** below. These dependencies are only
   needed for the compilinf process.


3. Create a *persistent* build tree for C/C++ development:

   1. Run the CMake *configure* operation. This should be carried out
      by running the following command:
      ```shell
      python setup.py cmake
      ```
      This effectively runs the standard CMake *configure* procedure 
      (i.e., `mkdir build && cd build && cmake ..`) but adds flags to ensure
      the proper libraries and compilers are found. The name of the resulting 
      build directory will depend on factors such as your operating system,
      and the version of Python that is installed in the environment. An example
      might be `./build/temp.linux-x86_64-cpython-39_local/`, where `.` refers
      to the directory that contains `setup.py`.
      

   2. Navigate into the build tree that was generated by the last step, and 
      build the `OpenSeesRT` target to create `libOpenSeesRT.so`.
      Building is typically performed by executing one of:
      ```shell
      cmake --build . --target OpenSeesRT -j8
      # or if using make
      make OpenSeesRT -j8
      ```
      where the option `-j8` makes the build faster and can be adjusted
      for your needs and resources (see `make` documentation).

   3. When `libOpenSeesRT.so` is built in a persistent tree, the `opensees` 
      package needs to be told where to find it. This can be done by setting
      an environment variable with the name `OPENSEESRT_LIB` to point to
      the location of `libOpenSeesRT.so` in the build tree.
      To this end, you may want to add a line llike the following to your shell
      startup script (e.g., `.bashrc`):
      ```bash
      export OPENSEESRT_LIB="/path/to/your/compiled/libOpenSeesRT.so"
      ```

4. Check that everything was built properly by running the following command:
   ```shell
   python -m opensees
   ```
   This should start an OpenSees interpreter which can be closed by running
   the `exit` command.


## Dependencies

The primary system dependencies required for compiling are LAPACK/BLAS and Tcl.
Packages providing these libraries are listed below for various package
management ecosystems.

> **IMPORTANT** When building in an Anaconda environment, you should install 
> **all** dependencies with `conda` or `mamba`, and preferably from the
> `conda-forge` channel. Expand the notes on Anaconda below.

**Windows**: Install Intel compilers and Conan


<details><summary><b>APT (Ubuntu, Debian Linux)</b></summary>

| Dependency  | Package              |
|:------------|:---------------------|
| LAPACK      | `liblapack-dev`      |
| BLAS        | `libblas-dev`        |
| Tcl\*       | `tcl-dev`            |

</details>
<details>
<summary>
<b>Pacman (Arch, Manjaro Linux)</b>
</summary>

The Pacman package manager

| Dependency  | Package       |
|:------------|:--------------|
| LAPACK      | `lapack`      |
| BLAS        | `blas`        |
| Tcl\*       | `tcl`         |

</details>
<details>
<summary>
<b>Anaconda (Mac, Windows, Linux)</b>
</summary>

When using conda, you need to ensure that CMake only finds 
compilers that are compatible with the libraries in the
environment. <b>System compilers (like those installed
by the operating system's package manager) often cannot be used
and can lead to segfaults.</b>
The following command should install everything you need:

``` shell
conda install -c conda-forge fortran-compiler cxx-compiler c-compiler openblas
```

</details>
</details>
<details>
<summary>
<b>Yum (CentOS, Redhat Linux)</b>
</summary>

| Dependency | Package        |
|------------|----------------|
| LAPACK     | `lapack-devel` |
| Tcl\*      | `tcl-devel`    |

</details>

## Other

- [x] **Windows** CI build

  ``` shell
  python scripts\win_repair.py win32 wheelhouse\opensees-*
  ```

## Build Variations

The build type can be configured through the file `setup.py`. For example,
to change from a `Release` to `Debug` build, look for the following lines
in `setup.py` and make the appropriate change:
```python
                cmake_configure_options = [
                    "-G", "Unix Makefiles",
                    *EnvArgs,
                    "-DCMAKE_BUILD_TYPE=DEBUG",
#                   "-DCMAKE_BUILD_TYPE=RELEASE",
```
After this is changed, step 5 needs to be performed again.

