"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .approvaltarget import ApprovalTarget
from .cardscheme import CardScheme
from .method import Method
from .mode import Mode
from .paymentmethoddetailscard import (
    PaymentMethodDetailsCard,
    PaymentMethodDetailsCardTypedDict,
)
from datetime import datetime
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const, validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator, PlainValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class TransactionPaymentMethodTypedDict(TypedDict):
    method: Method
    type: Literal["payment-method"]
    r"""Always `payment-method`."""
    approval_url: NotRequired[Nullable[str]]
    r"""The optional URL that the buyer needs to be redirected to to further authorize their payment."""
    country: NotRequired[Nullable[str]]
    r"""The 2-letter ISO code of the country this payment method can be used for. If this value is null the payment method may be used in multiple countries."""
    currency: NotRequired[Nullable[str]]
    r"""The ISO-4217 currency code that this payment method can be used for. If this value is null the payment method may be used for multiple currencies."""
    details: NotRequired[Nullable[PaymentMethodDetailsCardTypedDict]]
    r"""Details for credit or debit card payment method."""
    expiration_date: NotRequired[Nullable[str]]
    r"""The expiration date for the payment method."""
    fingerprint: NotRequired[Nullable[str]]
    r"""The unique hash derived from the payment method identifier (e.g. card number)."""
    label: NotRequired[Nullable[str]]
    r"""A label for the card or the account. For a paypal payment method this is the user's email address. For a card it is the last 4 digits of the card."""
    last_replaced_at: NotRequired[Nullable[datetime]]
    r"""The date and time when this card was last replaced by the account updater."""
    mode: NotRequired[Nullable[Mode]]
    r"""The mode to use with this payment method."""
    scheme: NotRequired[Nullable[CardScheme]]
    r"""The scheme of the card. Only applies to card payments."""
    id: NotRequired[Nullable[str]]
    r"""The ID of the payment method."""
    approval_target: NotRequired[Nullable[ApprovalTarget]]
    r"""The browser target that an approval URL must be opened in. If any or null, then there is no specific requirement."""
    external_identifier: NotRequired[Nullable[str]]
    r"""An external identifier that can be used to match the payment method against your own records."""
    payment_account_reference: NotRequired[Nullable[str]]
    r"""The payment account reference (PAR) returned by the card scheme. This is a unique reference to the underlying account that has been used to fund this payment method."""


class TransactionPaymentMethod(BaseModel):
    method: Annotated[Method, PlainValidator(validate_open_enum(False))]

    TYPE: Annotated[
        Annotated[
            Optional[Literal["payment-method"]],
            AfterValidator(validate_const("payment-method")),
        ],
        pydantic.Field(alias="type"),
    ] = "payment-method"
    r"""Always `payment-method`."""

    approval_url: OptionalNullable[str] = UNSET
    r"""The optional URL that the buyer needs to be redirected to to further authorize their payment."""

    country: OptionalNullable[str] = UNSET
    r"""The 2-letter ISO code of the country this payment method can be used for. If this value is null the payment method may be used in multiple countries."""

    currency: OptionalNullable[str] = UNSET
    r"""The ISO-4217 currency code that this payment method can be used for. If this value is null the payment method may be used for multiple currencies."""

    details: OptionalNullable[PaymentMethodDetailsCard] = UNSET
    r"""Details for credit or debit card payment method."""

    expiration_date: OptionalNullable[str] = UNSET
    r"""The expiration date for the payment method."""

    fingerprint: OptionalNullable[str] = UNSET
    r"""The unique hash derived from the payment method identifier (e.g. card number)."""

    label: OptionalNullable[str] = UNSET
    r"""A label for the card or the account. For a paypal payment method this is the user's email address. For a card it is the last 4 digits of the card."""

    last_replaced_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when this card was last replaced by the account updater."""

    mode: Annotated[
        OptionalNullable[Mode], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""The mode to use with this payment method."""

    scheme: Annotated[
        OptionalNullable[CardScheme], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""The scheme of the card. Only applies to card payments."""

    id: OptionalNullable[str] = UNSET
    r"""The ID of the payment method."""

    approval_target: Annotated[
        OptionalNullable[ApprovalTarget], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""The browser target that an approval URL must be opened in. If any or null, then there is no specific requirement."""

    external_identifier: OptionalNullable[str] = UNSET
    r"""An external identifier that can be used to match the payment method against your own records."""

    payment_account_reference: OptionalNullable[str] = UNSET
    r"""The payment account reference (PAR) returned by the card scheme. This is a unique reference to the underlying account that has been used to fund this payment method."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "type",
            "approval_url",
            "country",
            "currency",
            "details",
            "expiration_date",
            "fingerprint",
            "label",
            "last_replaced_at",
            "mode",
            "scheme",
            "id",
            "approval_target",
            "external_identifier",
            "payment_account_reference",
        ]
        nullable_fields = [
            "approval_url",
            "country",
            "currency",
            "details",
            "expiration_date",
            "fingerprint",
            "label",
            "last_replaced_at",
            "mode",
            "scheme",
            "id",
            "approval_target",
            "external_identifier",
            "payment_account_reference",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
