# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ClusterNetwork',
]

@pulumi.output_type
class ClusterNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcId":
            suggest = "vpc_id"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_id: _builtins.str,
                 vswitches: Sequence[_builtins.str],
                 security_group_ids: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str vpc_id: VpcId to which the cluster belongs.
        :param Sequence[_builtins.str] vswitches: Switch to which the cluster belongs.
        :param Sequence[_builtins.str] security_group_ids: Security group to which the cluster belongs.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitches", vswitches)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        VpcId to which the cluster belongs.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter
    def vswitches(self) -> Sequence[_builtins.str]:
        """
        Switch to which the cluster belongs.
        """
        return pulumi.get(self, "vswitches")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Security group to which the cluster belongs.
        """
        return pulumi.get(self, "security_group_ids")


