# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSaslAclsResult',
    'AwaitableGetSaslAclsResult',
    'get_sasl_acls',
    'get_sasl_acls_output',
]

@pulumi.output_type
class GetSaslAclsResult:
    """
    A collection of values returned by getSaslAcls.
    """
    def __init__(__self__, acl_resource_name=None, acl_resource_type=None, acls=None, id=None, instance_id=None, output_file=None, username=None):
        if acl_resource_name and not isinstance(acl_resource_name, str):
            raise TypeError("Expected argument 'acl_resource_name' to be a str")
        pulumi.set(__self__, "acl_resource_name", acl_resource_name)
        if acl_resource_type and not isinstance(acl_resource_type, str):
            raise TypeError("Expected argument 'acl_resource_type' to be a str")
        pulumi.set(__self__, "acl_resource_type", acl_resource_type)
        if acls and not isinstance(acls, list):
            raise TypeError("Expected argument 'acls' to be a list")
        pulumi.set(__self__, "acls", acls)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="aclResourceName")
    def acl_resource_name(self) -> _builtins.str:
        """
        The resource name of the sasl acl.
        """
        return pulumi.get(self, "acl_resource_name")

    @_builtins.property
    @pulumi.getter(name="aclResourceType")
    def acl_resource_type(self) -> _builtins.str:
        """
        The resource type of the sasl acl.
        """
        return pulumi.get(self, "acl_resource_type")

    @_builtins.property
    @pulumi.getter
    def acls(self) -> Sequence['outputs.GetSaslAclsAclResult']:
        """
        A list of sasl acls. Each element contains the following attributes:
        """
        return pulumi.get(self, "acls")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The username of the sasl acl.
        """
        return pulumi.get(self, "username")


class AwaitableGetSaslAclsResult(GetSaslAclsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSaslAclsResult(
            acl_resource_name=self.acl_resource_name,
            acl_resource_type=self.acl_resource_type,
            acls=self.acls,
            id=self.id,
            instance_id=self.instance_id,
            output_file=self.output_file,
            username=self.username)


def get_sasl_acls(acl_resource_name: Optional[_builtins.str] = None,
                  acl_resource_type: Optional[_builtins.str] = None,
                  instance_id: Optional[_builtins.str] = None,
                  output_file: Optional[_builtins.str] = None,
                  username: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSaslAclsResult:
    """
    This data source provides a list of ALIKAFKA Sasl acls in an Alibaba Cloud account according to the specified filters.

    > **NOTE:** Available in 1.66.0+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    sasl_acls_ds = alicloud.actiontrail.get_sasl_acls(instance_id="xxx",
        username="username",
        acl_resource_type="Topic",
        acl_resource_name="testTopic",
        output_file="saslAcls.txt")
    pulumi.export("firstSaslAclUsername", sasl_acls_ds.acls[0].username)
    ```


    :param _builtins.str acl_resource_name: Get results for the specified resource name.
    :param _builtins.str acl_resource_type: Get results for the specified resource type.
    :param _builtins.str instance_id: ID of the ALIKAFKA Instance that owns the sasl acls.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str username: Get results for the specified username.
    """
    __args__ = dict()
    __args__['aclResourceName'] = acl_resource_name
    __args__['aclResourceType'] = acl_resource_type
    __args__['instanceId'] = instance_id
    __args__['outputFile'] = output_file
    __args__['username'] = username
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:actiontrail/getSaslAcls:getSaslAcls', __args__, opts=opts, typ=GetSaslAclsResult).value

    return AwaitableGetSaslAclsResult(
        acl_resource_name=pulumi.get(__ret__, 'acl_resource_name'),
        acl_resource_type=pulumi.get(__ret__, 'acl_resource_type'),
        acls=pulumi.get(__ret__, 'acls'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        username=pulumi.get(__ret__, 'username'))
def get_sasl_acls_output(acl_resource_name: Optional[pulumi.Input[_builtins.str]] = None,
                         acl_resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                         instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                         output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         username: Optional[pulumi.Input[_builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSaslAclsResult]:
    """
    This data source provides a list of ALIKAFKA Sasl acls in an Alibaba Cloud account according to the specified filters.

    > **NOTE:** Available in 1.66.0+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    sasl_acls_ds = alicloud.actiontrail.get_sasl_acls(instance_id="xxx",
        username="username",
        acl_resource_type="Topic",
        acl_resource_name="testTopic",
        output_file="saslAcls.txt")
    pulumi.export("firstSaslAclUsername", sasl_acls_ds.acls[0].username)
    ```


    :param _builtins.str acl_resource_name: Get results for the specified resource name.
    :param _builtins.str acl_resource_type: Get results for the specified resource type.
    :param _builtins.str instance_id: ID of the ALIKAFKA Instance that owns the sasl acls.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str username: Get results for the specified username.
    """
    __args__ = dict()
    __args__['aclResourceName'] = acl_resource_name
    __args__['aclResourceType'] = acl_resource_type
    __args__['instanceId'] = instance_id
    __args__['outputFile'] = output_file
    __args__['username'] = username
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:actiontrail/getSaslAcls:getSaslAcls', __args__, opts=opts, typ=GetSaslAclsResult)
    return __ret__.apply(lambda __response__: GetSaslAclsResult(
        acl_resource_name=pulumi.get(__response__, 'acl_resource_name'),
        acl_resource_type=pulumi.get(__response__, 'acl_resource_type'),
        acls=pulumi.get(__response__, 'acls'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        output_file=pulumi.get(__response__, 'output_file'),
        username=pulumi.get(__response__, 'username')))
