# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetServerGroupsResult',
    'AwaitableGetServerGroupsResult',
    'get_server_groups',
    'get_server_groups_output',
]

@pulumi.output_type
class GetServerGroupsResult:
    """
    A collection of values returned by getServerGroups.
    """
    def __init__(__self__, enable_details=None, groups=None, id=None, ids=None, name_regex=None, names=None, output_file=None, resource_group_id=None, server_group_ids=None, server_group_name=None, status=None, tags=None, vpc_id=None):
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if groups and not isinstance(groups, list):
            raise TypeError("Expected argument 'groups' to be a list")
        pulumi.set(__self__, "groups", groups)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if server_group_ids and not isinstance(server_group_ids, list):
            raise TypeError("Expected argument 'server_group_ids' to be a list")
        pulumi.set(__self__, "server_group_ids", server_group_ids)
        if server_group_name and not isinstance(server_group_name, str):
            raise TypeError("Expected argument 'server_group_name' to be a str")
        pulumi.set(__self__, "server_group_name", server_group_name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enable_details")

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.GetServerGroupsGroupResult']:
        """
        A list of Server Groups. Each element contains the following attributes:
        """
        return pulumi.get(self, "groups")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of Server Group names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="serverGroupIds")
    def server_group_ids(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "server_group_ids")

    @_builtins.property
    @pulumi.getter(name="serverGroupName")
    def server_group_name(self) -> Optional[_builtins.str]:
        """
        The name of the Server Group.
        """
        return pulumi.get(self, "server_group_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the server.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The tags of the resource. **Note:** `tags` takes effect only if `enable_details` is set to `true`.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetServerGroupsResult(GetServerGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerGroupsResult(
            enable_details=self.enable_details,
            groups=self.groups,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            resource_group_id=self.resource_group_id,
            server_group_ids=self.server_group_ids,
            server_group_name=self.server_group_name,
            status=self.status,
            tags=self.tags,
            vpc_id=self.vpc_id)


def get_server_groups(enable_details: Optional[_builtins.bool] = None,
                      ids: Optional[Sequence[_builtins.str]] = None,
                      name_regex: Optional[_builtins.str] = None,
                      output_file: Optional[_builtins.str] = None,
                      resource_group_id: Optional[_builtins.str] = None,
                      server_group_ids: Optional[Sequence[_builtins.str]] = None,
                      server_group_name: Optional[_builtins.str] = None,
                      status: Optional[_builtins.str] = None,
                      tags: Optional[Mapping[str, _builtins.str]] = None,
                      vpc_id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerGroupsResult:
    """
    This data source provides the Alb Server Groups of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.131.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.vpc.Network("default",
        vpc_name=name,
        cidr_block="192.168.0.0/16")
    default_server_group = alicloud.alb.ServerGroup("default",
        protocol="HTTP",
        vpc_id=default.id,
        server_group_name=name,
        health_check_config={
            "health_check_enabled": False,
        },
        sticky_session_config={
            "sticky_session_enabled": False,
        })
    ids = alicloud.alb.get_server_groups_output(ids=[default_server_group.id])
    pulumi.export("albServerGroupId0", ids.groups[0].id)
    ```


    :param _builtins.bool enable_details: Whether to query the detailed list of resource attributes. Default value: `false`.
    :param Sequence[_builtins.str] ids: A list of Server Group IDs.
    :param _builtins.str name_regex: A regex string to filter results by Server Group name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: The ID of the resource group.
    :param Sequence[_builtins.str] server_group_ids: The server group IDs.
    :param _builtins.str server_group_name: The names of the Server Group.
    :param _builtins.str status: The status of the Server Group. Valid values: `Available`, `Configuring`, `Provisioning`.
    :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
    :param _builtins.str vpc_id: The ID of the virtual private cloud (VPC).
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['resourceGroupId'] = resource_group_id
    __args__['serverGroupIds'] = server_group_ids
    __args__['serverGroupName'] = server_group_name
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:alb/getServerGroups:getServerGroups', __args__, opts=opts, typ=GetServerGroupsResult).value

    return AwaitableGetServerGroupsResult(
        enable_details=pulumi.get(__ret__, 'enable_details'),
        groups=pulumi.get(__ret__, 'groups'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        server_group_ids=pulumi.get(__ret__, 'server_group_ids'),
        server_group_name=pulumi.get(__ret__, 'server_group_name'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_server_groups_output(enable_details: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                             ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                             name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             resource_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             server_group_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                             server_group_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                             vpc_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServerGroupsResult]:
    """
    This data source provides the Alb Server Groups of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.131.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.vpc.Network("default",
        vpc_name=name,
        cidr_block="192.168.0.0/16")
    default_server_group = alicloud.alb.ServerGroup("default",
        protocol="HTTP",
        vpc_id=default.id,
        server_group_name=name,
        health_check_config={
            "health_check_enabled": False,
        },
        sticky_session_config={
            "sticky_session_enabled": False,
        })
    ids = alicloud.alb.get_server_groups_output(ids=[default_server_group.id])
    pulumi.export("albServerGroupId0", ids.groups[0].id)
    ```


    :param _builtins.bool enable_details: Whether to query the detailed list of resource attributes. Default value: `false`.
    :param Sequence[_builtins.str] ids: A list of Server Group IDs.
    :param _builtins.str name_regex: A regex string to filter results by Server Group name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: The ID of the resource group.
    :param Sequence[_builtins.str] server_group_ids: The server group IDs.
    :param _builtins.str server_group_name: The names of the Server Group.
    :param _builtins.str status: The status of the Server Group. Valid values: `Available`, `Configuring`, `Provisioning`.
    :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
    :param _builtins.str vpc_id: The ID of the virtual private cloud (VPC).
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['resourceGroupId'] = resource_group_id
    __args__['serverGroupIds'] = server_group_ids
    __args__['serverGroupName'] = server_group_name
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:alb/getServerGroups:getServerGroups', __args__, opts=opts, typ=GetServerGroupsResult)
    return __ret__.apply(lambda __response__: GetServerGroupsResult(
        enable_details=pulumi.get(__response__, 'enable_details'),
        groups=pulumi.get(__response__, 'groups'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        resource_group_id=pulumi.get(__response__, 'resource_group_id'),
        server_group_ids=pulumi.get(__response__, 'server_group_ids'),
        server_group_name=pulumi.get(__response__, 'server_group_name'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
