# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RuleArgs', 'Rule']

@pulumi.input_type
class RuleArgs:
    def __init__(__self__, *,
                 listener_id: pulumi.Input[_builtins.str],
                 priority: pulumi.Input[_builtins.int],
                 rule_actions: pulumi.Input[Sequence[pulumi.Input['RuleRuleActionArgs']]],
                 rule_conditions: pulumi.Input[Sequence[pulumi.Input['RuleRuleConditionArgs']]],
                 rule_name: pulumi.Input[_builtins.str],
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Rule resource.
        :param pulumi.Input[_builtins.str] listener_id: The ID of the listener to which the forwarding rule belongs.
        :param pulumi.Input[_builtins.int] priority: The priority of the rule. Valid values: 1 to 10000. A smaller value indicates a higher priority. **Note*:* The priority of each rule within the same listener must be unique.
        :param pulumi.Input[Sequence[pulumi.Input['RuleRuleActionArgs']]] rule_actions: The actions of the forwarding rules. See `rule_actions` below.
        :param pulumi.Input[Sequence[pulumi.Input['RuleRuleConditionArgs']]] rule_conditions: The conditions of the forwarding rule. See `rule_conditions` below.
        :param pulumi.Input[_builtins.str] rule_name: The name of the forwarding rule. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        :param pulumi.Input[_builtins.str] direction: The direction to which the forwarding rule is applied. Default value: `Request`. Valid values:
               - `Request`: The forwarding rule is applied to the client requests received by ALB.
               - `Response`: The forwarding rule is applied to the responses returned by backend servers.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to precheck this request.
        """
        pulumi.set(__self__, "listener_id", listener_id)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "rule_actions", rule_actions)
        pulumi.set(__self__, "rule_conditions", rule_conditions)
        pulumi.set(__self__, "rule_name", rule_name)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the listener to which the forwarding rule belongs.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "listener_id", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Input[_builtins.int]:
        """
        The priority of the rule. Valid values: 1 to 10000. A smaller value indicates a higher priority. **Note*:* The priority of each rule within the same listener must be unique.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="ruleActions")
    def rule_actions(self) -> pulumi.Input[Sequence[pulumi.Input['RuleRuleActionArgs']]]:
        """
        The actions of the forwarding rules. See `rule_actions` below.
        """
        return pulumi.get(self, "rule_actions")

    @rule_actions.setter
    def rule_actions(self, value: pulumi.Input[Sequence[pulumi.Input['RuleRuleActionArgs']]]):
        pulumi.set(self, "rule_actions", value)

    @_builtins.property
    @pulumi.getter(name="ruleConditions")
    def rule_conditions(self) -> pulumi.Input[Sequence[pulumi.Input['RuleRuleConditionArgs']]]:
        """
        The conditions of the forwarding rule. See `rule_conditions` below.
        """
        return pulumi.get(self, "rule_conditions")

    @rule_conditions.setter
    def rule_conditions(self, value: pulumi.Input[Sequence[pulumi.Input['RuleRuleConditionArgs']]]):
        pulumi.set(self, "rule_conditions", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the forwarding rule. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The direction to which the forwarding rule is applied. Default value: `Request`. Valid values:
        - `Request`: The forwarding rule is applied to the client requests received by ALB.
        - `Response`: The forwarding rule is applied to the responses returned by backend servers.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to precheck this request.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)


@pulumi.input_type
class _RuleState:
    def __init__(__self__, *,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 rule_actions: Optional[pulumi.Input[Sequence[pulumi.Input['RuleRuleActionArgs']]]] = None,
                 rule_conditions: Optional[pulumi.Input[Sequence[pulumi.Input['RuleRuleConditionArgs']]]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Rule resources.
        :param pulumi.Input[_builtins.str] direction: The direction to which the forwarding rule is applied. Default value: `Request`. Valid values:
               - `Request`: The forwarding rule is applied to the client requests received by ALB.
               - `Response`: The forwarding rule is applied to the responses returned by backend servers.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to precheck this request.
        :param pulumi.Input[_builtins.str] listener_id: The ID of the listener to which the forwarding rule belongs.
        :param pulumi.Input[_builtins.int] priority: The priority of the rule. Valid values: 1 to 10000. A smaller value indicates a higher priority. **Note*:* The priority of each rule within the same listener must be unique.
        :param pulumi.Input[Sequence[pulumi.Input['RuleRuleActionArgs']]] rule_actions: The actions of the forwarding rules. See `rule_actions` below.
        :param pulumi.Input[Sequence[pulumi.Input['RuleRuleConditionArgs']]] rule_conditions: The conditions of the forwarding rule. See `rule_conditions` below.
        :param pulumi.Input[_builtins.str] rule_name: The name of the forwarding rule. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        """
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if rule_actions is not None:
            pulumi.set(__self__, "rule_actions", rule_actions)
        if rule_conditions is not None:
            pulumi.set(__self__, "rule_conditions", rule_conditions)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The direction to which the forwarding rule is applied. Default value: `Request`. Valid values:
        - `Request`: The forwarding rule is applied to the client requests received by ALB.
        - `Response`: The forwarding rule is applied to the responses returned by backend servers.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to precheck this request.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the listener to which the forwarding rule belongs.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listener_id", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The priority of the rule. Valid values: 1 to 10000. A smaller value indicates a higher priority. **Note*:* The priority of each rule within the same listener must be unique.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="ruleActions")
    def rule_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleRuleActionArgs']]]]:
        """
        The actions of the forwarding rules. See `rule_actions` below.
        """
        return pulumi.get(self, "rule_actions")

    @rule_actions.setter
    def rule_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleRuleActionArgs']]]]):
        pulumi.set(self, "rule_actions", value)

    @_builtins.property
    @pulumi.getter(name="ruleConditions")
    def rule_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleRuleConditionArgs']]]]:
        """
        The conditions of the forwarding rule. See `rule_conditions` below.
        """
        return pulumi.get(self, "rule_conditions")

    @rule_conditions.setter
    def rule_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleRuleConditionArgs']]]]):
        pulumi.set(self, "rule_conditions", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the forwarding rule. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:alb/rule:Rule")
class Rule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 rule_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleRuleActionArgs', 'RuleRuleActionArgsDict']]]]] = None,
                 rule_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleRuleConditionArgs', 'RuleRuleConditionArgsDict']]]]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Application Load Balancer (ALB) Rule resource.

        For information about Application Load Balancer (ALB) Rule and how to use it, see [What is Rule](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createrule).

        > **NOTE:** Available since v1.133.0.

        > **NOTE:** This version only supports forwarding rules in the request direction.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.alb.get_zones()
        default_get_resource_groups = alicloud.resourcemanager.get_resource_groups()
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = []
        for range in [{"value": i} for i in range(0, 2)]:
            default_switch.append(alicloud.vpc.Switch(f"default-{range['value']}",
                vpc_id=default_network.id,
                cidr_block=std.format(input="10.4.%d.0/24",
                    args=[range["value"] + 1]).result,
                zone_id=default.zones[range["value"]].id,
                vswitch_name=std.format(input=f"{name}_%d",
                    args=[range["value"] + 1]).result))
        default_load_balancer = alicloud.alb.LoadBalancer("default",
            vpc_id=default_network.id,
            address_type="Internet",
            address_allocated_mode="Fixed",
            load_balancer_name=name,
            load_balancer_edition="Standard",
            resource_group_id=default_get_resource_groups.groups[0].id,
            load_balancer_billing_config={
                "pay_type": "PayAsYouGo",
            },
            tags={
                "Created": "TF",
            },
            zone_mappings=[
                {
                    "vswitch_id": default_switch[0].id,
                    "zone_id": default.zones[0].id,
                },
                {
                    "vswitch_id": default_switch[1].id,
                    "zone_id": default.zones[1].id,
                },
            ])
        default_server_group = alicloud.alb.ServerGroup("default",
            protocol="HTTP",
            vpc_id=default_network.id,
            server_group_name=name,
            resource_group_id=default_get_resource_groups.groups[0].id,
            health_check_config={
                "health_check_enabled": False,
            },
            sticky_session_config={
                "sticky_session_enabled": False,
            },
            tags={
                "Created": "TF",
            })
        default_listener = alicloud.alb.Listener("default",
            load_balancer_id=default_load_balancer.id,
            listener_protocol="HTTP",
            listener_port=80,
            listener_description=name,
            default_actions=[{
                "type": "ForwardGroup",
                "forward_group_config": {
                    "server_group_tuples": [{
                        "server_group_id": default_server_group.id,
                    }],
                },
            }])
        default_rule = alicloud.alb.Rule("default",
            rule_name=name,
            listener_id=default_listener.id,
            priority=555,
            rule_conditions=[{
                "cookie_config": {
                    "values": [{
                        "key": "created",
                        "value": "tf",
                    }],
                },
                "type": "Cookie",
            }],
            rule_actions=[{
                "forward_group_config": {
                    "server_group_tuples": [{
                        "server_group_id": default_server_group.id,
                    }],
                },
                "order": 9,
                "type": "ForwardGroup",
            }])
        ```

        ## Import

        Application Load Balancer (ALB) Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:alb/rule:Rule example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] direction: The direction to which the forwarding rule is applied. Default value: `Request`. Valid values:
               - `Request`: The forwarding rule is applied to the client requests received by ALB.
               - `Response`: The forwarding rule is applied to the responses returned by backend servers.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to precheck this request.
        :param pulumi.Input[_builtins.str] listener_id: The ID of the listener to which the forwarding rule belongs.
        :param pulumi.Input[_builtins.int] priority: The priority of the rule. Valid values: 1 to 10000. A smaller value indicates a higher priority. **Note*:* The priority of each rule within the same listener must be unique.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleRuleActionArgs', 'RuleRuleActionArgsDict']]]] rule_actions: The actions of the forwarding rules. See `rule_actions` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleRuleConditionArgs', 'RuleRuleConditionArgsDict']]]] rule_conditions: The conditions of the forwarding rule. See `rule_conditions` below.
        :param pulumi.Input[_builtins.str] rule_name: The name of the forwarding rule. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Application Load Balancer (ALB) Rule resource.

        For information about Application Load Balancer (ALB) Rule and how to use it, see [What is Rule](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-createrule).

        > **NOTE:** Available since v1.133.0.

        > **NOTE:** This version only supports forwarding rules in the request direction.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.alb.get_zones()
        default_get_resource_groups = alicloud.resourcemanager.get_resource_groups()
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = []
        for range in [{"value": i} for i in range(0, 2)]:
            default_switch.append(alicloud.vpc.Switch(f"default-{range['value']}",
                vpc_id=default_network.id,
                cidr_block=std.format(input="10.4.%d.0/24",
                    args=[range["value"] + 1]).result,
                zone_id=default.zones[range["value"]].id,
                vswitch_name=std.format(input=f"{name}_%d",
                    args=[range["value"] + 1]).result))
        default_load_balancer = alicloud.alb.LoadBalancer("default",
            vpc_id=default_network.id,
            address_type="Internet",
            address_allocated_mode="Fixed",
            load_balancer_name=name,
            load_balancer_edition="Standard",
            resource_group_id=default_get_resource_groups.groups[0].id,
            load_balancer_billing_config={
                "pay_type": "PayAsYouGo",
            },
            tags={
                "Created": "TF",
            },
            zone_mappings=[
                {
                    "vswitch_id": default_switch[0].id,
                    "zone_id": default.zones[0].id,
                },
                {
                    "vswitch_id": default_switch[1].id,
                    "zone_id": default.zones[1].id,
                },
            ])
        default_server_group = alicloud.alb.ServerGroup("default",
            protocol="HTTP",
            vpc_id=default_network.id,
            server_group_name=name,
            resource_group_id=default_get_resource_groups.groups[0].id,
            health_check_config={
                "health_check_enabled": False,
            },
            sticky_session_config={
                "sticky_session_enabled": False,
            },
            tags={
                "Created": "TF",
            })
        default_listener = alicloud.alb.Listener("default",
            load_balancer_id=default_load_balancer.id,
            listener_protocol="HTTP",
            listener_port=80,
            listener_description=name,
            default_actions=[{
                "type": "ForwardGroup",
                "forward_group_config": {
                    "server_group_tuples": [{
                        "server_group_id": default_server_group.id,
                    }],
                },
            }])
        default_rule = alicloud.alb.Rule("default",
            rule_name=name,
            listener_id=default_listener.id,
            priority=555,
            rule_conditions=[{
                "cookie_config": {
                    "values": [{
                        "key": "created",
                        "value": "tf",
                    }],
                },
                "type": "Cookie",
            }],
            rule_actions=[{
                "forward_group_config": {
                    "server_group_tuples": [{
                        "server_group_id": default_server_group.id,
                    }],
                },
                "order": 9,
                "type": "ForwardGroup",
            }])
        ```

        ## Import

        Application Load Balancer (ALB) Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:alb/rule:Rule example <id>
        ```

        :param str resource_name: The name of the resource.
        :param RuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 rule_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleRuleActionArgs', 'RuleRuleActionArgsDict']]]]] = None,
                 rule_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleRuleConditionArgs', 'RuleRuleConditionArgsDict']]]]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleArgs.__new__(RuleArgs)

            __props__.__dict__["direction"] = direction
            __props__.__dict__["dry_run"] = dry_run
            if listener_id is None and not opts.urn:
                raise TypeError("Missing required property 'listener_id'")
            __props__.__dict__["listener_id"] = listener_id
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
            if rule_actions is None and not opts.urn:
                raise TypeError("Missing required property 'rule_actions'")
            __props__.__dict__["rule_actions"] = rule_actions
            if rule_conditions is None and not opts.urn:
                raise TypeError("Missing required property 'rule_conditions'")
            __props__.__dict__["rule_conditions"] = rule_conditions
            if rule_name is None and not opts.urn:
                raise TypeError("Missing required property 'rule_name'")
            __props__.__dict__["rule_name"] = rule_name
            __props__.__dict__["status"] = None
        super(Rule, __self__).__init__(
            'alicloud:alb/rule:Rule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            direction: Optional[pulumi.Input[_builtins.str]] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            listener_id: Optional[pulumi.Input[_builtins.str]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            rule_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleRuleActionArgs', 'RuleRuleActionArgsDict']]]]] = None,
            rule_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleRuleConditionArgs', 'RuleRuleConditionArgsDict']]]]] = None,
            rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'Rule':
        """
        Get an existing Rule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] direction: The direction to which the forwarding rule is applied. Default value: `Request`. Valid values:
               - `Request`: The forwarding rule is applied to the client requests received by ALB.
               - `Response`: The forwarding rule is applied to the responses returned by backend servers.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to precheck this request.
        :param pulumi.Input[_builtins.str] listener_id: The ID of the listener to which the forwarding rule belongs.
        :param pulumi.Input[_builtins.int] priority: The priority of the rule. Valid values: 1 to 10000. A smaller value indicates a higher priority. **Note*:* The priority of each rule within the same listener must be unique.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleRuleActionArgs', 'RuleRuleActionArgsDict']]]] rule_actions: The actions of the forwarding rules. See `rule_actions` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleRuleConditionArgs', 'RuleRuleConditionArgsDict']]]] rule_conditions: The conditions of the forwarding rule. See `rule_conditions` below.
        :param pulumi.Input[_builtins.str] rule_name: The name of the forwarding rule. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleState.__new__(_RuleState)

        __props__.__dict__["direction"] = direction
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["listener_id"] = listener_id
        __props__.__dict__["priority"] = priority
        __props__.__dict__["rule_actions"] = rule_actions
        __props__.__dict__["rule_conditions"] = rule_conditions
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["status"] = status
        return Rule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> pulumi.Output[_builtins.str]:
        """
        The direction to which the forwarding rule is applied. Default value: `Request`. Valid values:
        - `Request`: The forwarding rule is applied to the client requests received by ALB.
        - `Response`: The forwarding rule is applied to the responses returned by backend servers.
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to precheck this request.
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the listener to which the forwarding rule belongs.
        """
        return pulumi.get(self, "listener_id")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[_builtins.int]:
        """
        The priority of the rule. Valid values: 1 to 10000. A smaller value indicates a higher priority. **Note*:* The priority of each rule within the same listener must be unique.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="ruleActions")
    def rule_actions(self) -> pulumi.Output[Sequence['outputs.RuleRuleAction']]:
        """
        The actions of the forwarding rules. See `rule_actions` below.
        """
        return pulumi.get(self, "rule_actions")

    @_builtins.property
    @pulumi.getter(name="ruleConditions")
    def rule_conditions(self) -> pulumi.Output[Sequence['outputs.RuleRuleCondition']]:
        """
        The conditions of the forwarding rule. See `rule_conditions` below.
        """
        return pulumi.get(self, "rule_conditions")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the forwarding rule. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

