# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ImageLibArgs', 'ImageLib']

@pulumi.input_type
class ImageLibArgs:
    def __init__(__self__, *,
                 category: pulumi.Input[_builtins.str],
                 image_lib_name: pulumi.Input[_builtins.str],
                 scene: pulumi.Input[_builtins.str],
                 biz_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ImageLib resource.
        :param pulumi.Input[_builtins.str] category: The category of the image library. Valid values: BLACK: a blacklist, WHITE: a whitelist, REVIEW: a review list
        :param pulumi.Input[_builtins.str] image_lib_name: The name of the image library defined by the customer. It can contain no more than 20 characters in Chinese, English, and underscore (_).
        :param pulumi.Input[_builtins.str] scene: The moderation scenario to which the custom image library applies. Valid values: PORN: pornography detection, AD: ad detection, ILLEGAL: terrorist content detection
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] biz_types: List of business scenarios. For example: ["bizTypeA", "bizTypeB", "bizTypeC"]
        :param pulumi.Input[_builtins.bool] enable: Specifies whether to enable the image library. Valid values: true: Enable the image library. This is the default value. false: Disable the image library.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "image_lib_name", image_lib_name)
        pulumi.set(__self__, "scene", scene)
        if biz_types is not None:
            pulumi.set(__self__, "biz_types", biz_types)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Input[_builtins.str]:
        """
        The category of the image library. Valid values: BLACK: a blacklist, WHITE: a whitelist, REVIEW: a review list
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="imageLibName")
    def image_lib_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the image library defined by the customer. It can contain no more than 20 characters in Chinese, English, and underscore (_).
        """
        return pulumi.get(self, "image_lib_name")

    @image_lib_name.setter
    def image_lib_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "image_lib_name", value)

    @_builtins.property
    @pulumi.getter
    def scene(self) -> pulumi.Input[_builtins.str]:
        """
        The moderation scenario to which the custom image library applies. Valid values: PORN: pornography detection, AD: ad detection, ILLEGAL: terrorist content detection
        """
        return pulumi.get(self, "scene")

    @scene.setter
    def scene(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scene", value)

    @_builtins.property
    @pulumi.getter(name="bizTypes")
    def biz_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of business scenarios. For example: ["bizTypeA", "bizTypeB", "bizTypeC"]
        """
        return pulumi.get(self, "biz_types")

    @biz_types.setter
    def biz_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "biz_types", value)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the image library. Valid values: true: Enable the image library. This is the default value. false: Disable the image library.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable", value)


@pulumi.input_type
class _ImageLibState:
    def __init__(__self__, *,
                 biz_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_lib_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scene: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ImageLib resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] biz_types: List of business scenarios. For example: ["bizTypeA", "bizTypeB", "bizTypeC"]
        :param pulumi.Input[_builtins.str] category: The category of the image library. Valid values: BLACK: a blacklist, WHITE: a whitelist, REVIEW: a review list
        :param pulumi.Input[_builtins.bool] enable: Specifies whether to enable the image library. Valid values: true: Enable the image library. This is the default value. false: Disable the image library.
        :param pulumi.Input[_builtins.str] image_lib_name: The name of the image library defined by the customer. It can contain no more than 20 characters in Chinese, English, and underscore (_).
        :param pulumi.Input[_builtins.str] scene: The moderation scenario to which the custom image library applies. Valid values: PORN: pornography detection, AD: ad detection, ILLEGAL: terrorist content detection
        """
        if biz_types is not None:
            pulumi.set(__self__, "biz_types", biz_types)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if image_lib_name is not None:
            pulumi.set(__self__, "image_lib_name", image_lib_name)
        if scene is not None:
            pulumi.set(__self__, "scene", scene)

    @_builtins.property
    @pulumi.getter(name="bizTypes")
    def biz_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of business scenarios. For example: ["bizTypeA", "bizTypeB", "bizTypeC"]
        """
        return pulumi.get(self, "biz_types")

    @biz_types.setter
    def biz_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "biz_types", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The category of the image library. Valid values: BLACK: a blacklist, WHITE: a whitelist, REVIEW: a review list
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the image library. Valid values: true: Enable the image library. This is the default value. false: Disable the image library.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable", value)

    @_builtins.property
    @pulumi.getter(name="imageLibName")
    def image_lib_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the image library defined by the customer. It can contain no more than 20 characters in Chinese, English, and underscore (_).
        """
        return pulumi.get(self, "image_lib_name")

    @image_lib_name.setter
    def image_lib_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_lib_name", value)

    @_builtins.property
    @pulumi.getter
    def scene(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The moderation scenario to which the custom image library applies. Valid values: PORN: pornography detection, AD: ad detection, ILLEGAL: terrorist content detection
        """
        return pulumi.get(self, "scene")

    @scene.setter
    def scene(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scene", value)


@pulumi.type_token("alicloud:aligreen/imageLib:ImageLib")
class ImageLib(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 biz_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_lib_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scene: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Aligreen Image Lib resource.

        Image library for image detection.

        For information about Aligreen Image Lib and how to use it, see [What is Image Lib](https://next.api.alibabacloud.com/document/Green/2017-08-23/CreateImageLib).

        > **NOTE:** Available since v1.228.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform"
        default_ualun_b = alicloud.aligreen.BizType("defaultUalunB", biz_type_name=name)
        default = alicloud.aligreen.ImageLib("default",
            category="BLACK",
            enable=True,
            scene="PORN",
            image_lib_name=name,
            biz_types=[default_ualun_b.biz_type_name])
        ```

        ## Import

        Aligreen Image Lib can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:aligreen/imageLib:ImageLib example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] biz_types: List of business scenarios. For example: ["bizTypeA", "bizTypeB", "bizTypeC"]
        :param pulumi.Input[_builtins.str] category: The category of the image library. Valid values: BLACK: a blacklist, WHITE: a whitelist, REVIEW: a review list
        :param pulumi.Input[_builtins.bool] enable: Specifies whether to enable the image library. Valid values: true: Enable the image library. This is the default value. false: Disable the image library.
        :param pulumi.Input[_builtins.str] image_lib_name: The name of the image library defined by the customer. It can contain no more than 20 characters in Chinese, English, and underscore (_).
        :param pulumi.Input[_builtins.str] scene: The moderation scenario to which the custom image library applies. Valid values: PORN: pornography detection, AD: ad detection, ILLEGAL: terrorist content detection
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ImageLibArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Aligreen Image Lib resource.

        Image library for image detection.

        For information about Aligreen Image Lib and how to use it, see [What is Image Lib](https://next.api.alibabacloud.com/document/Green/2017-08-23/CreateImageLib).

        > **NOTE:** Available since v1.228.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform"
        default_ualun_b = alicloud.aligreen.BizType("defaultUalunB", biz_type_name=name)
        default = alicloud.aligreen.ImageLib("default",
            category="BLACK",
            enable=True,
            scene="PORN",
            image_lib_name=name,
            biz_types=[default_ualun_b.biz_type_name])
        ```

        ## Import

        Aligreen Image Lib can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:aligreen/imageLib:ImageLib example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ImageLibArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImageLibArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 biz_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_lib_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scene: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImageLibArgs.__new__(ImageLibArgs)

            __props__.__dict__["biz_types"] = biz_types
            if category is None and not opts.urn:
                raise TypeError("Missing required property 'category'")
            __props__.__dict__["category"] = category
            __props__.__dict__["enable"] = enable
            if image_lib_name is None and not opts.urn:
                raise TypeError("Missing required property 'image_lib_name'")
            __props__.__dict__["image_lib_name"] = image_lib_name
            if scene is None and not opts.urn:
                raise TypeError("Missing required property 'scene'")
            __props__.__dict__["scene"] = scene
        super(ImageLib, __self__).__init__(
            'alicloud:aligreen/imageLib:ImageLib',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            biz_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            category: Optional[pulumi.Input[_builtins.str]] = None,
            enable: Optional[pulumi.Input[_builtins.bool]] = None,
            image_lib_name: Optional[pulumi.Input[_builtins.str]] = None,
            scene: Optional[pulumi.Input[_builtins.str]] = None) -> 'ImageLib':
        """
        Get an existing ImageLib resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] biz_types: List of business scenarios. For example: ["bizTypeA", "bizTypeB", "bizTypeC"]
        :param pulumi.Input[_builtins.str] category: The category of the image library. Valid values: BLACK: a blacklist, WHITE: a whitelist, REVIEW: a review list
        :param pulumi.Input[_builtins.bool] enable: Specifies whether to enable the image library. Valid values: true: Enable the image library. This is the default value. false: Disable the image library.
        :param pulumi.Input[_builtins.str] image_lib_name: The name of the image library defined by the customer. It can contain no more than 20 characters in Chinese, English, and underscore (_).
        :param pulumi.Input[_builtins.str] scene: The moderation scenario to which the custom image library applies. Valid values: PORN: pornography detection, AD: ad detection, ILLEGAL: terrorist content detection
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ImageLibState.__new__(_ImageLibState)

        __props__.__dict__["biz_types"] = biz_types
        __props__.__dict__["category"] = category
        __props__.__dict__["enable"] = enable
        __props__.__dict__["image_lib_name"] = image_lib_name
        __props__.__dict__["scene"] = scene
        return ImageLib(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bizTypes")
    def biz_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of business scenarios. For example: ["bizTypeA", "bizTypeB", "bizTypeC"]
        """
        return pulumi.get(self, "biz_types")

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Output[_builtins.str]:
        """
        The category of the image library. Valid values: BLACK: a blacklist, WHITE: a whitelist, REVIEW: a review list
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable the image library. Valid values: true: Enable the image library. This is the default value. false: Disable the image library.
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="imageLibName")
    def image_lib_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the image library defined by the customer. It can contain no more than 20 characters in Chinese, English, and underscore (_).
        """
        return pulumi.get(self, "image_lib_name")

    @_builtins.property
    @pulumi.getter
    def scene(self) -> pulumi.Output[_builtins.str]:
        """
        The moderation scenario to which the custom image library applies. Valid values: PORN: pornography detection, AD: ad detection, ILLEGAL: terrorist content detection
        """
        return pulumi.get(self, "scene")

