# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AclEntryAttachmentArgs', 'AclEntryAttachment']

@pulumi.input_type
class AclEntryAttachmentArgs:
    def __init__(__self__, *,
                 acl_id: pulumi.Input[_builtins.str],
                 entry: pulumi.Input[_builtins.str],
                 comment: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AclEntryAttachment resource.
        :param pulumi.Input[_builtins.str] acl_id: The ID of the ACL that the entry will be attached to.
        :param pulumi.Input[_builtins.str] entry: The CIDR block of the entry to attach.
        :param pulumi.Input[_builtins.str] comment: The comment for the entry.
        """
        pulumi.set(__self__, "acl_id", acl_id)
        pulumi.set(__self__, "entry", entry)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @_builtins.property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the ACL that the entry will be attached to.
        """
        return pulumi.get(self, "acl_id")

    @acl_id.setter
    def acl_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "acl_id", value)

    @_builtins.property
    @pulumi.getter
    def entry(self) -> pulumi.Input[_builtins.str]:
        """
        The CIDR block of the entry to attach.
        """
        return pulumi.get(self, "entry")

    @entry.setter
    def entry(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "entry", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The comment for the entry.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)


@pulumi.input_type
class _AclEntryAttachmentState:
    def __init__(__self__, *,
                 acl_id: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 entry: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AclEntryAttachment resources.
        :param pulumi.Input[_builtins.str] acl_id: The ID of the ACL that the entry will be attached to.
        :param pulumi.Input[_builtins.str] comment: The comment for the entry.
        :param pulumi.Input[_builtins.str] entry: The CIDR block of the entry to attach.
        """
        if acl_id is not None:
            pulumi.set(__self__, "acl_id", acl_id)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if entry is not None:
            pulumi.set(__self__, "entry", entry)

    @_builtins.property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the ACL that the entry will be attached to.
        """
        return pulumi.get(self, "acl_id")

    @acl_id.setter
    def acl_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl_id", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The comment for the entry.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def entry(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CIDR block of the entry to attach.
        """
        return pulumi.get(self, "entry")

    @entry.setter
    def entry(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entry", value)


@pulumi.type_token("alicloud:apigateway/aclEntryAttachment:AclEntryAttachment")
class AclEntryAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_id: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 entry: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an ACL entry attachment resource for attaching ACL entry to an API Gateway ACL.

        > **NOTE:** Available since v1.228.0

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default = alicloud.apigateway.AccessControlList("default",
            access_control_list_name=name,
            address_ip_version="ipv4")
        default_acl_entry_attachment = alicloud.apigateway.AclEntryAttachment("default",
            acl_id=default.id,
            entry="128.0.0.1/32",
            comment="test comment")
        ```

        ## Import

        Api Gateway Acl Entry Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:apigateway/aclEntryAttachment:AclEntryAttachment example <acl_id>:<entry>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl_id: The ID of the ACL that the entry will be attached to.
        :param pulumi.Input[_builtins.str] comment: The comment for the entry.
        :param pulumi.Input[_builtins.str] entry: The CIDR block of the entry to attach.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AclEntryAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an ACL entry attachment resource for attaching ACL entry to an API Gateway ACL.

        > **NOTE:** Available since v1.228.0

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default = alicloud.apigateway.AccessControlList("default",
            access_control_list_name=name,
            address_ip_version="ipv4")
        default_acl_entry_attachment = alicloud.apigateway.AclEntryAttachment("default",
            acl_id=default.id,
            entry="128.0.0.1/32",
            comment="test comment")
        ```

        ## Import

        Api Gateway Acl Entry Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:apigateway/aclEntryAttachment:AclEntryAttachment example <acl_id>:<entry>
        ```

        :param str resource_name: The name of the resource.
        :param AclEntryAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AclEntryAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_id: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 entry: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AclEntryAttachmentArgs.__new__(AclEntryAttachmentArgs)

            if acl_id is None and not opts.urn:
                raise TypeError("Missing required property 'acl_id'")
            __props__.__dict__["acl_id"] = acl_id
            __props__.__dict__["comment"] = comment
            if entry is None and not opts.urn:
                raise TypeError("Missing required property 'entry'")
            __props__.__dict__["entry"] = entry
        super(AclEntryAttachment, __self__).__init__(
            'alicloud:apigateway/aclEntryAttachment:AclEntryAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl_id: Optional[pulumi.Input[_builtins.str]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            entry: Optional[pulumi.Input[_builtins.str]] = None) -> 'AclEntryAttachment':
        """
        Get an existing AclEntryAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl_id: The ID of the ACL that the entry will be attached to.
        :param pulumi.Input[_builtins.str] comment: The comment for the entry.
        :param pulumi.Input[_builtins.str] entry: The CIDR block of the entry to attach.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AclEntryAttachmentState.__new__(_AclEntryAttachmentState)

        __props__.__dict__["acl_id"] = acl_id
        __props__.__dict__["comment"] = comment
        __props__.__dict__["entry"] = entry
        return AclEntryAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the ACL that the entry will be attached to.
        """
        return pulumi.get(self, "acl_id")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The comment for the entry.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter
    def entry(self) -> pulumi.Output[_builtins.str]:
        """
        The CIDR block of the entry to attach.
        """
        return pulumi.get(self, "entry")

