# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AccessControlListAclEntry',
    'ApiConstantParameter',
    'ApiFcServiceConfig',
    'ApiHttpServiceConfig',
    'ApiHttpVpcServiceConfig',
    'ApiMockServiceConfig',
    'ApiRequestConfig',
    'ApiRequestParameter',
    'ApiSystemParameter',
    'GroupUserLogConfig',
    'InstanceToConnectVpcIpBlock',
    'InstanceZoneVswitchSecurityGroup',
    'GetApisApiResult',
    'GetAppsAppResult',
    'GetBackendsBackendResult',
    'GetGroupsGroupResult',
    'GetLogConfigsConfigResult',
    'GetModelsModelResult',
    'GetPluginsPluginResult',
]

@pulumi.output_type
class AccessControlListAclEntry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aclEntryComment":
            suggest = "acl_entry_comment"
        elif key == "aclEntryIp":
            suggest = "acl_entry_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessControlListAclEntry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessControlListAclEntry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessControlListAclEntry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acl_entry_comment: Optional[_builtins.str] = None,
                 acl_entry_ip: Optional[_builtins.str] = None):
        """
        :param _builtins.str acl_entry_comment: The description of the ACL.
        :param _builtins.str acl_entry_ip: The entries that you want to add to the ACL. You can add CIDR blocks. Separate multiple CIDR blocks with commas (,).
        """
        if acl_entry_comment is not None:
            pulumi.set(__self__, "acl_entry_comment", acl_entry_comment)
        if acl_entry_ip is not None:
            pulumi.set(__self__, "acl_entry_ip", acl_entry_ip)

    @_builtins.property
    @pulumi.getter(name="aclEntryComment")
    def acl_entry_comment(self) -> Optional[_builtins.str]:
        """
        The description of the ACL.
        """
        return pulumi.get(self, "acl_entry_comment")

    @_builtins.property
    @pulumi.getter(name="aclEntryIp")
    def acl_entry_ip(self) -> Optional[_builtins.str]:
        """
        The entries that you want to add to the ACL. You can add CIDR blocks. Separate multiple CIDR blocks with commas (,).
        """
        return pulumi.get(self, "acl_entry_ip")


@pulumi.output_type
class ApiConstantParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "in":
            suggest = "in_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiConstantParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiConstantParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiConstantParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 in_: _builtins.str,
                 name: _builtins.str,
                 value: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str in_: Constant parameter location; values: 'HEAD' and 'QUERY'.
        :param _builtins.str name: Constant parameter name.
        :param _builtins.str value: Constant parameter value.
        :param _builtins.str description: The description of Constant parameter.
        """
        pulumi.set(__self__, "in_", in_)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="in")
    def in_(self) -> _builtins.str:
        """
        Constant parameter location; values: 'HEAD' and 'QUERY'.
        """
        return pulumi.get(self, "in_")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Constant parameter name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Constant parameter value.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The description of Constant parameter.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class ApiFcServiceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "arnRole":
            suggest = "arn_role"
        elif key == "functionBaseUrl":
            suggest = "function_base_url"
        elif key == "functionName":
            suggest = "function_name"
        elif key == "functionType":
            suggest = "function_type"
        elif key == "functionVersion":
            suggest = "function_version"
        elif key == "onlyBusinessPath":
            suggest = "only_business_path"
        elif key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiFcServiceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiFcServiceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiFcServiceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arn_role: _builtins.str,
                 region: _builtins.str,
                 timeout: _builtins.int,
                 function_base_url: Optional[_builtins.str] = None,
                 function_name: Optional[_builtins.str] = None,
                 function_type: Optional[_builtins.str] = None,
                 function_version: Optional[_builtins.str] = None,
                 method: Optional[_builtins.str] = None,
                 only_business_path: Optional[_builtins.bool] = None,
                 path: Optional[_builtins.str] = None,
                 qualifier: Optional[_builtins.str] = None,
                 service_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str arn_role: RAM role arn attached to the Function Compute service. This governs both who / what can invoke your Function, as well as what resources our Function has access to. See [User Permissions](https://www.alibabacloud.com/help/doc-detail/52885.htm) for more details.
        :param _builtins.str region: The region that the function compute service belongs to.
        :param _builtins.int timeout: Backend service time-out time; unit: millisecond.
        :param _builtins.str function_base_url: The base url of function compute service. Required if `function_type` is `HttpTrigger`.
        :param _builtins.str function_name: The function name of function compute service. Required if `function_type` is `FCEvent`.
        :param _builtins.str function_type: The type of function compute service. Supports values of `FCEvent`,`HttpTrigger`. Default value: `FCEvent`.
        :param _builtins.str function_version: The function compute version of function compute service. Supports values of `2.0`, `3.0`. Default value: `2.0`.
        :param _builtins.str method: The http method of function compute service. Required if `function_type` is `HttpTrigger`.
        :param _builtins.bool only_business_path: Whether to filter path in `function_base_url`. Optional if `function_type` is `HttpTrigger`.
        :param _builtins.str path: The path of function compute service. Required if `function_type` is `HttpTrigger`.
        :param _builtins.str qualifier: The qualifier of function name of compute service.
        :param _builtins.str service_name: The service name of function compute service. Required if `function_type` is `FCEvent` and `function_version` is `2.0`.
        """
        pulumi.set(__self__, "arn_role", arn_role)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "timeout", timeout)
        if function_base_url is not None:
            pulumi.set(__self__, "function_base_url", function_base_url)
        if function_name is not None:
            pulumi.set(__self__, "function_name", function_name)
        if function_type is not None:
            pulumi.set(__self__, "function_type", function_type)
        if function_version is not None:
            pulumi.set(__self__, "function_version", function_version)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if only_business_path is not None:
            pulumi.set(__self__, "only_business_path", only_business_path)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @_builtins.property
    @pulumi.getter(name="arnRole")
    def arn_role(self) -> _builtins.str:
        """
        RAM role arn attached to the Function Compute service. This governs both who / what can invoke your Function, as well as what resources our Function has access to. See [User Permissions](https://www.alibabacloud.com/help/doc-detail/52885.htm) for more details.
        """
        return pulumi.get(self, "arn_role")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region that the function compute service belongs to.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> _builtins.int:
        """
        Backend service time-out time; unit: millisecond.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter(name="functionBaseUrl")
    def function_base_url(self) -> Optional[_builtins.str]:
        """
        The base url of function compute service. Required if `function_type` is `HttpTrigger`.
        """
        return pulumi.get(self, "function_base_url")

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> Optional[_builtins.str]:
        """
        The function name of function compute service. Required if `function_type` is `FCEvent`.
        """
        return pulumi.get(self, "function_name")

    @_builtins.property
    @pulumi.getter(name="functionType")
    def function_type(self) -> Optional[_builtins.str]:
        """
        The type of function compute service. Supports values of `FCEvent`,`HttpTrigger`. Default value: `FCEvent`.
        """
        return pulumi.get(self, "function_type")

    @_builtins.property
    @pulumi.getter(name="functionVersion")
    def function_version(self) -> Optional[_builtins.str]:
        """
        The function compute version of function compute service. Supports values of `2.0`, `3.0`. Default value: `2.0`.
        """
        return pulumi.get(self, "function_version")

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[_builtins.str]:
        """
        The http method of function compute service. Required if `function_type` is `HttpTrigger`.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter(name="onlyBusinessPath")
    def only_business_path(self) -> Optional[_builtins.bool]:
        """
        Whether to filter path in `function_base_url`. Optional if `function_type` is `HttpTrigger`.
        """
        return pulumi.get(self, "only_business_path")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        The path of function compute service. Required if `function_type` is `HttpTrigger`.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def qualifier(self) -> Optional[_builtins.str]:
        """
        The qualifier of function name of compute service.
        """
        return pulumi.get(self, "qualifier")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[_builtins.str]:
        """
        The service name of function compute service. Required if `function_type` is `FCEvent` and `function_version` is `2.0`.
        """
        return pulumi.get(self, "service_name")


@pulumi.output_type
class ApiHttpServiceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aoneName":
            suggest = "aone_name"
        elif key == "contentTypeCategory":
            suggest = "content_type_category"
        elif key == "contentTypeValue":
            suggest = "content_type_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiHttpServiceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiHttpServiceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiHttpServiceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: _builtins.str,
                 method: _builtins.str,
                 path: _builtins.str,
                 timeout: _builtins.int,
                 aone_name: Optional[_builtins.str] = None,
                 content_type_category: Optional[_builtins.str] = None,
                 content_type_value: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The address of backend service.
        :param _builtins.str method: The http method of backend service.
        :param _builtins.str path: The path of backend service.
        :param _builtins.int timeout: Backend service time-out time; unit: millisecond.
        :param _builtins.str aone_name: The name of aone.
        :param _builtins.str content_type_category: The content type category of backend service which supports values of 'DEFAULT','CUSTOM' and 'CLIENT'.
        :param _builtins.str content_type_value: The content type value of backend service.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "timeout", timeout)
        if aone_name is not None:
            pulumi.set(__self__, "aone_name", aone_name)
        if content_type_category is not None:
            pulumi.set(__self__, "content_type_category", content_type_category)
        if content_type_value is not None:
            pulumi.set(__self__, "content_type_value", content_type_value)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The address of backend service.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        The http method of backend service.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path of backend service.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> _builtins.int:
        """
        Backend service time-out time; unit: millisecond.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter(name="aoneName")
    def aone_name(self) -> Optional[_builtins.str]:
        """
        The name of aone.
        """
        return pulumi.get(self, "aone_name")

    @_builtins.property
    @pulumi.getter(name="contentTypeCategory")
    def content_type_category(self) -> Optional[_builtins.str]:
        """
        The content type category of backend service which supports values of 'DEFAULT','CUSTOM' and 'CLIENT'.
        """
        return pulumi.get(self, "content_type_category")

    @_builtins.property
    @pulumi.getter(name="contentTypeValue")
    def content_type_value(self) -> Optional[_builtins.str]:
        """
        The content type value of backend service.
        """
        return pulumi.get(self, "content_type_value")


@pulumi.output_type
class ApiHttpVpcServiceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aoneName":
            suggest = "aone_name"
        elif key == "contentTypeCategory":
            suggest = "content_type_category"
        elif key == "contentTypeValue":
            suggest = "content_type_value"
        elif key == "vpcScheme":
            suggest = "vpc_scheme"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiHttpVpcServiceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiHttpVpcServiceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiHttpVpcServiceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method: _builtins.str,
                 name: _builtins.str,
                 path: _builtins.str,
                 timeout: _builtins.int,
                 aone_name: Optional[_builtins.str] = None,
                 content_type_category: Optional[_builtins.str] = None,
                 content_type_value: Optional[_builtins.str] = None,
                 vpc_scheme: Optional[_builtins.str] = None):
        """
        :param _builtins.str method: The http method of backend service.
        :param _builtins.str name: The name of vpc instance.
        :param _builtins.str path: The path of backend service.
        :param _builtins.int timeout: Backend service time-out time. Unit: millisecond.
        :param _builtins.str aone_name: The name of aone.
        :param _builtins.str content_type_category: The content type category of backend service which supports values of 'DEFAULT','CUSTOM' and 'CLIENT'.
        :param _builtins.str content_type_value: The content type value of backend service.
        :param _builtins.str vpc_scheme: The vpc scheme of backend service which supports values of `HTTP` and `HTTPS`.
        """
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "timeout", timeout)
        if aone_name is not None:
            pulumi.set(__self__, "aone_name", aone_name)
        if content_type_category is not None:
            pulumi.set(__self__, "content_type_category", content_type_category)
        if content_type_value is not None:
            pulumi.set(__self__, "content_type_value", content_type_value)
        if vpc_scheme is not None:
            pulumi.set(__self__, "vpc_scheme", vpc_scheme)

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        The http method of backend service.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of vpc instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path of backend service.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> _builtins.int:
        """
        Backend service time-out time. Unit: millisecond.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter(name="aoneName")
    def aone_name(self) -> Optional[_builtins.str]:
        """
        The name of aone.
        """
        return pulumi.get(self, "aone_name")

    @_builtins.property
    @pulumi.getter(name="contentTypeCategory")
    def content_type_category(self) -> Optional[_builtins.str]:
        """
        The content type category of backend service which supports values of 'DEFAULT','CUSTOM' and 'CLIENT'.
        """
        return pulumi.get(self, "content_type_category")

    @_builtins.property
    @pulumi.getter(name="contentTypeValue")
    def content_type_value(self) -> Optional[_builtins.str]:
        """
        The content type value of backend service.
        """
        return pulumi.get(self, "content_type_value")

    @_builtins.property
    @pulumi.getter(name="vpcScheme")
    def vpc_scheme(self) -> Optional[_builtins.str]:
        """
        The vpc scheme of backend service which supports values of `HTTP` and `HTTPS`.
        """
        return pulumi.get(self, "vpc_scheme")


@pulumi.output_type
class ApiMockServiceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aoneName":
            suggest = "aone_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiMockServiceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiMockServiceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiMockServiceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 result: _builtins.str,
                 aone_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str result: The result of the mock service.
        :param _builtins.str aone_name: The name of aone.
        """
        pulumi.set(__self__, "result", result)
        if aone_name is not None:
            pulumi.set(__self__, "aone_name", aone_name)

    @_builtins.property
    @pulumi.getter
    def result(self) -> _builtins.str:
        """
        The result of the mock service.
        """
        return pulumi.get(self, "result")

    @_builtins.property
    @pulumi.getter(name="aoneName")
    def aone_name(self) -> Optional[_builtins.str]:
        """
        The name of aone.
        """
        return pulumi.get(self, "aone_name")


@pulumi.output_type
class ApiRequestConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bodyFormat":
            suggest = "body_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiRequestConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiRequestConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiRequestConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method: _builtins.str,
                 mode: _builtins.str,
                 path: _builtins.str,
                 protocol: _builtins.str,
                 body_format: Optional[_builtins.str] = None):
        """
        :param _builtins.str method: The method of the api, including 'GET','POST','PUT' etc.
        :param _builtins.str mode: The mode of the parameters between request parameters and service parameters, which support the values of 'MAPPING' and 'PASSTHROUGH'.
        :param _builtins.str path: The request path of the api.
        :param _builtins.str protocol: The protocol of api which supports values of 'HTTP','HTTPS' or 'HTTP,HTTPS'.
        :param _builtins.str body_format: The body format of the api, which support the values of 'STREAM' and 'FORM'.
        """
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "protocol", protocol)
        if body_format is not None:
            pulumi.set(__self__, "body_format", body_format)

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        The method of the api, including 'GET','POST','PUT' etc.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        The mode of the parameters between request parameters and service parameters, which support the values of 'MAPPING' and 'PASSTHROUGH'.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The request path of the api.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The protocol of api which supports values of 'HTTP','HTTPS' or 'HTTP,HTTPS'.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="bodyFormat")
    def body_format(self) -> Optional[_builtins.str]:
        """
        The body format of the api, which support the values of 'STREAM' and 'FORM'.
        """
        return pulumi.get(self, "body_format")


@pulumi.output_type
class ApiRequestParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "in":
            suggest = "in_"
        elif key == "inService":
            suggest = "in_service"
        elif key == "nameService":
            suggest = "name_service"
        elif key == "defaultValue":
            suggest = "default_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiRequestParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiRequestParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiRequestParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 in_: _builtins.str,
                 in_service: _builtins.str,
                 name: _builtins.str,
                 name_service: _builtins.str,
                 required: _builtins.str,
                 type: _builtins.str,
                 default_value: Optional[_builtins.str] = None,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str in_: Request's parameter location; values: BODY, HEAD, QUERY, and PATH.
        :param _builtins.str in_service: Backend service's parameter location; values: BODY, HEAD, QUERY, and PATH.
        :param _builtins.str name: Request's parameter name.
        :param _builtins.str name_service: Backend service's parameter name.
        :param _builtins.str required: Parameter required or not; values: REQUIRED and OPTIONAL.
        :param _builtins.str type: Parameter type which supports values of 'STRING','INT','BOOLEAN','LONG',"FLOAT" and "DOUBLE".
        :param _builtins.str default_value: The default value of the parameter.
        :param _builtins.str description: The description of parameter.
        """
        pulumi.set(__self__, "in_", in_)
        pulumi.set(__self__, "in_service", in_service)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "name_service", name_service)
        pulumi.set(__self__, "required", required)
        pulumi.set(__self__, "type", type)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="in")
    def in_(self) -> _builtins.str:
        """
        Request's parameter location; values: BODY, HEAD, QUERY, and PATH.
        """
        return pulumi.get(self, "in_")

    @_builtins.property
    @pulumi.getter(name="inService")
    def in_service(self) -> _builtins.str:
        """
        Backend service's parameter location; values: BODY, HEAD, QUERY, and PATH.
        """
        return pulumi.get(self, "in_service")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Request's parameter name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nameService")
    def name_service(self) -> _builtins.str:
        """
        Backend service's parameter name.
        """
        return pulumi.get(self, "name_service")

    @_builtins.property
    @pulumi.getter
    def required(self) -> _builtins.str:
        """
        Parameter required or not; values: REQUIRED and OPTIONAL.
        """
        return pulumi.get(self, "required")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Parameter type which supports values of 'STRING','INT','BOOLEAN','LONG',"FLOAT" and "DOUBLE".
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[_builtins.str]:
        """
        The default value of the parameter.
        """
        return pulumi.get(self, "default_value")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The description of parameter.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class ApiSystemParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "in":
            suggest = "in_"
        elif key == "nameService":
            suggest = "name_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiSystemParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiSystemParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiSystemParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 in_: _builtins.str,
                 name: _builtins.str,
                 name_service: _builtins.str):
        """
        :param _builtins.str in_: System parameter location; values: 'HEAD' and 'QUERY'.
        :param _builtins.str name: System parameter name which supports values including in [system parameter list](https://www.alibabacloud.com/help/doc-detail/43677.html).
        :param _builtins.str name_service: Backend service's parameter name.
        """
        pulumi.set(__self__, "in_", in_)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "name_service", name_service)

    @_builtins.property
    @pulumi.getter(name="in")
    def in_(self) -> _builtins.str:
        """
        System parameter location; values: 'HEAD' and 'QUERY'.
        """
        return pulumi.get(self, "in_")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        System parameter name which supports values including in [system parameter list](https://www.alibabacloud.com/help/doc-detail/43677.html).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nameService")
    def name_service(self) -> _builtins.str:
        """
        Backend service's parameter name.
        """
        return pulumi.get(self, "name_service")


@pulumi.output_type
class GroupUserLogConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jwtClaims":
            suggest = "jwt_claims"
        elif key == "queryString":
            suggest = "query_string"
        elif key == "requestBody":
            suggest = "request_body"
        elif key == "requestHeaders":
            suggest = "request_headers"
        elif key == "responseBody":
            suggest = "response_body"
        elif key == "responseHeaders":
            suggest = "response_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupUserLogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupUserLogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupUserLogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 jwt_claims: Optional[_builtins.str] = None,
                 query_string: Optional[_builtins.str] = None,
                 request_body: Optional[_builtins.bool] = None,
                 request_headers: Optional[_builtins.str] = None,
                 response_body: Optional[_builtins.bool] = None,
                 response_headers: Optional[_builtins.str] = None):
        """
        :param _builtins.str jwt_claims: The jwt claims to be record, support multi jwt claims split by `,`. Set `*` to record all.
        :param _builtins.str query_string: The query params to be record, support multi query params split by `,`. Set `*` to record all.
        :param _builtins.bool request_body: Whether to record the request body.
        :param _builtins.str request_headers: The request headers to be record, support multi request headers split by `,`. Set `*` to record all.
        :param _builtins.bool response_body: Whether to record the response body.
        :param _builtins.str response_headers: The response headers to be record, support multi response headers split by `,`. Set `*` to record all.
        """
        if jwt_claims is not None:
            pulumi.set(__self__, "jwt_claims", jwt_claims)
        if query_string is not None:
            pulumi.set(__self__, "query_string", query_string)
        if request_body is not None:
            pulumi.set(__self__, "request_body", request_body)
        if request_headers is not None:
            pulumi.set(__self__, "request_headers", request_headers)
        if response_body is not None:
            pulumi.set(__self__, "response_body", response_body)
        if response_headers is not None:
            pulumi.set(__self__, "response_headers", response_headers)

    @_builtins.property
    @pulumi.getter(name="jwtClaims")
    def jwt_claims(self) -> Optional[_builtins.str]:
        """
        The jwt claims to be record, support multi jwt claims split by `,`. Set `*` to record all.
        """
        return pulumi.get(self, "jwt_claims")

    @_builtins.property
    @pulumi.getter(name="queryString")
    def query_string(self) -> Optional[_builtins.str]:
        """
        The query params to be record, support multi query params split by `,`. Set `*` to record all.
        """
        return pulumi.get(self, "query_string")

    @_builtins.property
    @pulumi.getter(name="requestBody")
    def request_body(self) -> Optional[_builtins.bool]:
        """
        Whether to record the request body.
        """
        return pulumi.get(self, "request_body")

    @_builtins.property
    @pulumi.getter(name="requestHeaders")
    def request_headers(self) -> Optional[_builtins.str]:
        """
        The request headers to be record, support multi request headers split by `,`. Set `*` to record all.
        """
        return pulumi.get(self, "request_headers")

    @_builtins.property
    @pulumi.getter(name="responseBody")
    def response_body(self) -> Optional[_builtins.bool]:
        """
        Whether to record the response body.
        """
        return pulumi.get(self, "response_body")

    @_builtins.property
    @pulumi.getter(name="responseHeaders")
    def response_headers(self) -> Optional[_builtins.str]:
        """
        The response headers to be record, support multi response headers split by `,`. Set `*` to record all.
        """
        return pulumi.get(self, "response_headers")


@pulumi.output_type
class InstanceToConnectVpcIpBlock(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cidrBlock":
            suggest = "cidr_block"
        elif key == "vswitchId":
            suggest = "vswitch_id"
        elif key == "zoneId":
            suggest = "zone_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceToConnectVpcIpBlock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceToConnectVpcIpBlock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceToConnectVpcIpBlock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidr_block: _builtins.str,
                 customized: Optional[_builtins.bool] = None,
                 vswitch_id: Optional[_builtins.str] = None,
                 zone_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str cidr_block: The CIDR block of the VSwitch.
        :param _builtins.bool customized: Specifies whether the IP block is customized.
        :param _builtins.str vswitch_id: The VSwitch ID.
        :param _builtins.str zone_id: The zone ID.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        if customized is not None:
            pulumi.set(__self__, "customized", customized)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> _builtins.str:
        """
        The CIDR block of the VSwitch.
        """
        return pulumi.get(self, "cidr_block")

    @_builtins.property
    @pulumi.getter
    def customized(self) -> Optional[_builtins.bool]:
        """
        Specifies whether the IP block is customized.
        """
        return pulumi.get(self, "customized")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[_builtins.str]:
        """
        The VSwitch ID.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[_builtins.str]:
        """
        The zone ID.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class InstanceZoneVswitchSecurityGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cidrBlock":
            suggest = "cidr_block"
        elif key == "securityGroup":
            suggest = "security_group"
        elif key == "vswitchId":
            suggest = "vswitch_id"
        elif key == "zoneId":
            suggest = "zone_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceZoneVswitchSecurityGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceZoneVswitchSecurityGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceZoneVswitchSecurityGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidr_block: _builtins.str,
                 security_group: _builtins.str,
                 vswitch_id: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.str cidr_block: The CIDR block of the VSwitch.
        :param _builtins.str security_group: The ID of the security group.
        :param _builtins.str vswitch_id: The VSwitch ID.
        :param _builtins.str zone_id: The zone ID.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "security_group", security_group)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> _builtins.str:
        """
        The CIDR block of the VSwitch.
        """
        return pulumi.get(self, "cidr_block")

    @_builtins.property
    @pulumi.getter(name="securityGroup")
    def security_group(self) -> _builtins.str:
        """
        The ID of the security group.
        """
        return pulumi.get(self, "security_group")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The VSwitch ID.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The zone ID.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetApisApiResult(dict):
    def __init__(__self__, *,
                 api_id: _builtins.str,
                 description: _builtins.str,
                 group_id: _builtins.str,
                 group_name: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 region_id: _builtins.str):
        """
        :param _builtins.str api_id: The ID of the API.
        :param _builtins.str description: The description of the API.
        :param _builtins.str group_id: The ID of the API group.
        :param _builtins.str group_name: The name of the API group.
        :param _builtins.str name: The name of the API.
        :param _builtins.str region_id: The region ID of the API.
        """
        pulumi.set(__self__, "api_id", api_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region_id", region_id)

    @_builtins.property
    @pulumi.getter(name="apiId")
    def api_id(self) -> _builtins.str:
        """
        The ID of the API.
        """
        return pulumi.get(self, "api_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the API.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> _builtins.str:
        """
        The ID of the API group.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> _builtins.str:
        """
        The name of the API group.
        """
        return pulumi.get(self, "group_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the API.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The region ID of the API.
        """
        return pulumi.get(self, "region_id")


@pulumi.output_type
class GetAppsAppResult(dict):
    def __init__(__self__, *,
                 app_code: _builtins.str,
                 created_time: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.int,
                 modified_time: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str app_code: App code.
        :param _builtins.str created_time: Creation time (Greenwich mean time).
        :param _builtins.str description: App description.
        :param _builtins.int id: App ID, which is generated by the system and globally unique.
        :param _builtins.str modified_time: Last modification time (Greenwich mean time).
        :param _builtins.str name: App name.
        """
        pulumi.set(__self__, "app_code", app_code)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "modified_time", modified_time)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="appCode")
    def app_code(self) -> _builtins.str:
        """
        App code.
        """
        return pulumi.get(self, "app_code")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> _builtins.str:
        """
        Creation time (Greenwich mean time).
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        App description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        App ID, which is generated by the system and globally unique.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> _builtins.str:
        """
        Last modification time (Greenwich mean time).
        """
        return pulumi.get(self, "modified_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        App name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetBackendsBackendResult(dict):
    def __init__(__self__, *,
                 backend_id: _builtins.str,
                 backend_name: _builtins.str,
                 backend_type: _builtins.str,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 modified_time: _builtins.str):
        """
        :param _builtins.str backend_id: The id of the Backend.
        :param _builtins.str backend_name: The name of the Backend.
        :param _builtins.str backend_type: The type of the Backend.
        :param _builtins.str create_time: The created time of the Backend.
        :param _builtins.str description: The description of the Backend.
        :param _builtins.str modified_time: The modified time of the Backend.
        """
        pulumi.set(__self__, "backend_id", backend_id)
        pulumi.set(__self__, "backend_name", backend_name)
        pulumi.set(__self__, "backend_type", backend_type)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "modified_time", modified_time)

    @_builtins.property
    @pulumi.getter(name="backendId")
    def backend_id(self) -> _builtins.str:
        """
        The id of the Backend.
        """
        return pulumi.get(self, "backend_id")

    @_builtins.property
    @pulumi.getter(name="backendName")
    def backend_name(self) -> _builtins.str:
        """
        The name of the Backend.
        """
        return pulumi.get(self, "backend_name")

    @_builtins.property
    @pulumi.getter(name="backendType")
    def backend_type(self) -> _builtins.str:
        """
        The type of the Backend.
        """
        return pulumi.get(self, "backend_type")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The created time of the Backend.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the Backend.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> _builtins.str:
        """
        The modified time of the Backend.
        """
        return pulumi.get(self, "modified_time")


@pulumi.output_type
class GetGroupsGroupResult(dict):
    def __init__(__self__, *,
                 billing_status: _builtins.str,
                 created_time: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 illegal_status: _builtins.str,
                 modified_time: _builtins.str,
                 name: _builtins.str,
                 region_id: _builtins.str,
                 sub_domain: _builtins.str,
                 traffic_limit: _builtins.int):
        """
        :param _builtins.str billing_status: Billing status.
               - NORMAL: The API group is normal.
               - LOCKED: Locked due to outstanding payment.
        :param _builtins.str created_time: Creation time (Greenwich mean time).
        :param _builtins.str description: API group description.
        :param _builtins.str id: API group ID, which is generated by the system and globally unique.
        :param _builtins.str illegal_status: Locking in invalid state.
               - NORMAL: The API group is normal.
               - LOCKED: Locked due to illegality.
        :param _builtins.str modified_time: Last modification time (Greenwich mean time).
        :param _builtins.str name: API group name.
        :param _builtins.str region_id: The ID of the region where the API group is located.
        :param _builtins.str sub_domain: Second-level domain name automatically assigned to the API group.
        :param _builtins.int traffic_limit: Upper QPS limit of the API group; default value: 500, which can be increased by submitting an application.
        """
        pulumi.set(__self__, "billing_status", billing_status)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "illegal_status", illegal_status)
        pulumi.set(__self__, "modified_time", modified_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "sub_domain", sub_domain)
        pulumi.set(__self__, "traffic_limit", traffic_limit)

    @_builtins.property
    @pulumi.getter(name="billingStatus")
    def billing_status(self) -> _builtins.str:
        """
        Billing status.
        - NORMAL: The API group is normal.
        - LOCKED: Locked due to outstanding payment.
        """
        return pulumi.get(self, "billing_status")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> _builtins.str:
        """
        Creation time (Greenwich mean time).
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        API group description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        API group ID, which is generated by the system and globally unique.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="illegalStatus")
    def illegal_status(self) -> _builtins.str:
        """
        Locking in invalid state.
        - NORMAL: The API group is normal.
        - LOCKED: Locked due to illegality.
        """
        return pulumi.get(self, "illegal_status")

    @_builtins.property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> _builtins.str:
        """
        Last modification time (Greenwich mean time).
        """
        return pulumi.get(self, "modified_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        API group name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The ID of the region where the API group is located.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="subDomain")
    def sub_domain(self) -> _builtins.str:
        """
        Second-level domain name automatically assigned to the API group.
        """
        return pulumi.get(self, "sub_domain")

    @_builtins.property
    @pulumi.getter(name="trafficLimit")
    def traffic_limit(self) -> _builtins.int:
        """
        Upper QPS limit of the API group; default value: 500, which can be increased by submitting an application.
        """
        return pulumi.get(self, "traffic_limit")


@pulumi.output_type
class GetLogConfigsConfigResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 log_type: _builtins.str,
                 region_id: _builtins.str,
                 sls_log_store: _builtins.str,
                 sls_project: _builtins.str):
        """
        :param _builtins.str id: The ID of the Log Config.
        :param _builtins.str log_type: The type the of log.
        :param _builtins.str region_id: The region ID of the Log Config.
        :param _builtins.str sls_log_store: The name of the Log Store.
        :param _builtins.str sls_project: The name of the Project.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "log_type", log_type)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "sls_log_store", sls_log_store)
        pulumi.set(__self__, "sls_project", sls_project)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Log Config.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="logType")
    def log_type(self) -> _builtins.str:
        """
        The type the of log.
        """
        return pulumi.get(self, "log_type")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The region ID of the Log Config.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="slsLogStore")
    def sls_log_store(self) -> _builtins.str:
        """
        The name of the Log Store.
        """
        return pulumi.get(self, "sls_log_store")

    @_builtins.property
    @pulumi.getter(name="slsProject")
    def sls_project(self) -> _builtins.str:
        """
        The name of the Project.
        """
        return pulumi.get(self, "sls_project")


@pulumi.output_type
class GetModelsModelResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 group_id: _builtins.str,
                 id: _builtins.str,
                 model_id: _builtins.str,
                 model_name: _builtins.str,
                 model_ref: _builtins.str,
                 modified_time: _builtins.str,
                 schema: _builtins.str):
        """
        :param _builtins.str create_time: The creation time of the model.
        :param _builtins.str description: The description of the model.
        :param _builtins.str group_id: The ID of the api group.
        :param _builtins.str id: The ID of the Api Gateway Model.
        :param _builtins.str model_id: The id of the model.
        :param _builtins.str model_name: The name of the Model.
        :param _builtins.str model_ref: The reference of the model.
        :param _builtins.str modified_time: The modified time of the model.
        :param _builtins.str schema: The schema of the model.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "model_id", model_id)
        pulumi.set(__self__, "model_name", model_name)
        pulumi.set(__self__, "model_ref", model_ref)
        pulumi.set(__self__, "modified_time", modified_time)
        pulumi.set(__self__, "schema", schema)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the model.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the model.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> _builtins.str:
        """
        The ID of the api group.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Api Gateway Model.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="modelId")
    def model_id(self) -> _builtins.str:
        """
        The id of the model.
        """
        return pulumi.get(self, "model_id")

    @_builtins.property
    @pulumi.getter(name="modelName")
    def model_name(self) -> _builtins.str:
        """
        The name of the Model.
        """
        return pulumi.get(self, "model_name")

    @_builtins.property
    @pulumi.getter(name="modelRef")
    def model_ref(self) -> _builtins.str:
        """
        The reference of the model.
        """
        return pulumi.get(self, "model_ref")

    @_builtins.property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> _builtins.str:
        """
        The modified time of the model.
        """
        return pulumi.get(self, "modified_time")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> _builtins.str:
        """
        The schema of the model.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class GetPluginsPluginResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 modified_time: _builtins.str,
                 plugin_data: _builtins.str,
                 plugin_id: _builtins.str,
                 plugin_name: _builtins.str,
                 plugin_type: _builtins.str,
                 tags: Mapping[str, _builtins.str]):
        """
        :param _builtins.str create_time: The CreateTime of the resource.
        :param _builtins.str description: The description of the plug-in, which cannot exceed 200 characters.
        :param _builtins.str id: The ID of the Plugin.
        :param _builtins.str modified_time: The ModifiedTime of the resource.
        :param _builtins.str plugin_data: The definition statement of the plug-in. Plug-in definition statements in the JSON and YAML formats are supported.
        :param _builtins.str plugin_id: The first ID of the resource.
        :param _builtins.str plugin_name: The name of the plug-in that you want to create.
        :param _builtins.str plugin_type: The type of the plug-in.
        :param Mapping[str, _builtins.str] tags: The tag of the resource.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "modified_time", modified_time)
        pulumi.set(__self__, "plugin_data", plugin_data)
        pulumi.set(__self__, "plugin_id", plugin_id)
        pulumi.set(__self__, "plugin_name", plugin_name)
        pulumi.set(__self__, "plugin_type", plugin_type)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The CreateTime of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the plug-in, which cannot exceed 200 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Plugin.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> _builtins.str:
        """
        The ModifiedTime of the resource.
        """
        return pulumi.get(self, "modified_time")

    @_builtins.property
    @pulumi.getter(name="pluginData")
    def plugin_data(self) -> _builtins.str:
        """
        The definition statement of the plug-in. Plug-in definition statements in the JSON and YAML formats are supported.
        """
        return pulumi.get(self, "plugin_data")

    @_builtins.property
    @pulumi.getter(name="pluginId")
    def plugin_id(self) -> _builtins.str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "plugin_id")

    @_builtins.property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> _builtins.str:
        """
        The name of the plug-in that you want to create.
        """
        return pulumi.get(self, "plugin_name")

    @_builtins.property
    @pulumi.getter(name="pluginType")
    def plugin_type(self) -> _builtins.str:
        """
        The type of the plug-in.
        """
        return pulumi.get(self, "plugin_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")


