# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EnvFeatureArgs', 'EnvFeature']

@pulumi.input_type
class EnvFeatureArgs:
    def __init__(__self__, *,
                 env_feature_name: pulumi.Input[_builtins.str],
                 environment_id: pulumi.Input[_builtins.str],
                 feature_version: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a EnvFeature resource.
        :param pulumi.Input[_builtins.str] env_feature_name: The name of the resource.
        :param pulumi.Input[_builtins.str] environment_id: The first ID of the resource.
        :param pulumi.Input[_builtins.str] feature_version: Version information of the Feature. You can query Feature information by using ListEnvironmentFeatures.
        """
        pulumi.set(__self__, "env_feature_name", env_feature_name)
        pulumi.set(__self__, "environment_id", environment_id)
        pulumi.set(__self__, "feature_version", feature_version)

    @_builtins.property
    @pulumi.getter(name="envFeatureName")
    def env_feature_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "env_feature_name")

    @env_feature_name.setter
    def env_feature_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "env_feature_name", value)

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Input[_builtins.str]:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "environment_id", value)

    @_builtins.property
    @pulumi.getter(name="featureVersion")
    def feature_version(self) -> pulumi.Input[_builtins.str]:
        """
        Version information of the Feature. You can query Feature information by using ListEnvironmentFeatures.
        """
        return pulumi.get(self, "feature_version")

    @feature_version.setter
    def feature_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "feature_version", value)


@pulumi.input_type
class _EnvFeatureState:
    def __init__(__self__, *,
                 env_feature_name: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 feature_version: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EnvFeature resources.
        :param pulumi.Input[_builtins.str] env_feature_name: The name of the resource.
        :param pulumi.Input[_builtins.str] environment_id: The first ID of the resource.
        :param pulumi.Input[_builtins.str] feature_version: Version information of the Feature. You can query Feature information by using ListEnvironmentFeatures.
        :param pulumi.Input[_builtins.str] namespace: Namespace.
        :param pulumi.Input[_builtins.str] status: Status.
        """
        if env_feature_name is not None:
            pulumi.set(__self__, "env_feature_name", env_feature_name)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if feature_version is not None:
            pulumi.set(__self__, "feature_version", feature_version)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="envFeatureName")
    def env_feature_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "env_feature_name")

    @env_feature_name.setter
    def env_feature_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "env_feature_name", value)

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment_id", value)

    @_builtins.property
    @pulumi.getter(name="featureVersion")
    def feature_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version information of the Feature. You can query Feature information by using ListEnvironmentFeatures.
        """
        return pulumi.get(self, "feature_version")

    @feature_version.setter
    def feature_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "feature_version", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:arms/envFeature:EnvFeature")
class EnvFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 env_feature_name: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 feature_version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ARMS Env Feature resource. Feature of the arms environment.

        For information about ARMS Env Feature and how to use it, see [What is Env Feature](https://www.alibabacloud.com/help/en/arms/developer-reference/api-arms-2019-08-08-installenvironmentfeature).

        > **NOTE:** Available since v1.212.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random
        import pulumi_std as std

        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        enhanced = alicloud.vpc.get_enhanced_nat_available_zones()
        vpc = alicloud.vpc.Network("vpc",
            description=name,
            cidr_block="192.168.0.0/16",
            vpc_name=name)
        vswitch = alicloud.vpc.Switch("vswitch",
            description=name,
            vpc_id=vpc.id,
            vswitch_name=name,
            zone_id=enhanced.zones[0].zone_id,
            cidr_block=vpc.cidr_block.apply(lambda cidr_block: std.cidrsubnet_output(input=cidr_block,
                newbits=8,
                netnum=8)).apply(lambda invoke: invoke.result))
        default_snapshot_policy = alicloud.ecs.SnapshotPolicy("default",
            name=name,
            repeat_weekdays=[
                "1",
                "2",
                "3",
            ],
            retention_days=-1,
            time_points=[
                "1",
                "22",
                "23",
            ])
        default = vswitch.zone_id.apply(lambda zone_id: alicloud.ecs.get_instance_types_output(availability_zone=zone_id,
            cpu_core_count=2,
            memory_size=4,
            kubernetes_node_role="Worker",
            instance_type_family="ecs.sn1ne"))
        default_managed_kubernetes = alicloud.cs.ManagedKubernetes("default",
            name=f"terraform-example-{default_integer['result']}",
            cluster_spec="ack.pro.small",
            version="1.24.6-aliyun.1",
            new_nat_gateway=True,
            node_cidr_mask=26,
            proxy_mode="ipvs",
            service_cidr="172.23.0.0/16",
            pod_cidr="10.95.0.0/16",
            worker_vswitch_ids=[vswitch.id])
        default_key_pair = alicloud.ecs.KeyPair("default", key_pair_name=f"{name}-{default_integer['result']}")
        default_node_pool = alicloud.cs.NodePool("default",
            node_pool_name="desired_size",
            cluster_id=default_managed_kubernetes.id,
            vswitch_ids=[vswitch.id],
            instance_types=[default.instance_types[0].id],
            system_disk_category="cloud_efficiency",
            system_disk_size=40,
            key_name=default_key_pair.key_pair_name,
            desired_size="2")
        default_environment = alicloud.arms.Environment("default",
            bind_resource_id=default_node_pool.cluster_id,
            environment_sub_type="ManagedKubernetes",
            environment_type="CS",
            environment_name=f"terraform-example-{default_integer['result']}")
        default_env_feature = alicloud.arms.EnvFeature("default",
            env_feature_name="metric-agent",
            environment_id=default_environment.id,
            feature_version="1.1.17")
        ```

        ## Import

        ARMS Env Feature can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:arms/envFeature:EnvFeature example <environment_id>:<env_feature_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] env_feature_name: The name of the resource.
        :param pulumi.Input[_builtins.str] environment_id: The first ID of the resource.
        :param pulumi.Input[_builtins.str] feature_version: Version information of the Feature. You can query Feature information by using ListEnvironmentFeatures.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvFeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ARMS Env Feature resource. Feature of the arms environment.

        For information about ARMS Env Feature and how to use it, see [What is Env Feature](https://www.alibabacloud.com/help/en/arms/developer-reference/api-arms-2019-08-08-installenvironmentfeature).

        > **NOTE:** Available since v1.212.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random
        import pulumi_std as std

        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        enhanced = alicloud.vpc.get_enhanced_nat_available_zones()
        vpc = alicloud.vpc.Network("vpc",
            description=name,
            cidr_block="192.168.0.0/16",
            vpc_name=name)
        vswitch = alicloud.vpc.Switch("vswitch",
            description=name,
            vpc_id=vpc.id,
            vswitch_name=name,
            zone_id=enhanced.zones[0].zone_id,
            cidr_block=vpc.cidr_block.apply(lambda cidr_block: std.cidrsubnet_output(input=cidr_block,
                newbits=8,
                netnum=8)).apply(lambda invoke: invoke.result))
        default_snapshot_policy = alicloud.ecs.SnapshotPolicy("default",
            name=name,
            repeat_weekdays=[
                "1",
                "2",
                "3",
            ],
            retention_days=-1,
            time_points=[
                "1",
                "22",
                "23",
            ])
        default = vswitch.zone_id.apply(lambda zone_id: alicloud.ecs.get_instance_types_output(availability_zone=zone_id,
            cpu_core_count=2,
            memory_size=4,
            kubernetes_node_role="Worker",
            instance_type_family="ecs.sn1ne"))
        default_managed_kubernetes = alicloud.cs.ManagedKubernetes("default",
            name=f"terraform-example-{default_integer['result']}",
            cluster_spec="ack.pro.small",
            version="1.24.6-aliyun.1",
            new_nat_gateway=True,
            node_cidr_mask=26,
            proxy_mode="ipvs",
            service_cidr="172.23.0.0/16",
            pod_cidr="10.95.0.0/16",
            worker_vswitch_ids=[vswitch.id])
        default_key_pair = alicloud.ecs.KeyPair("default", key_pair_name=f"{name}-{default_integer['result']}")
        default_node_pool = alicloud.cs.NodePool("default",
            node_pool_name="desired_size",
            cluster_id=default_managed_kubernetes.id,
            vswitch_ids=[vswitch.id],
            instance_types=[default.instance_types[0].id],
            system_disk_category="cloud_efficiency",
            system_disk_size=40,
            key_name=default_key_pair.key_pair_name,
            desired_size="2")
        default_environment = alicloud.arms.Environment("default",
            bind_resource_id=default_node_pool.cluster_id,
            environment_sub_type="ManagedKubernetes",
            environment_type="CS",
            environment_name=f"terraform-example-{default_integer['result']}")
        default_env_feature = alicloud.arms.EnvFeature("default",
            env_feature_name="metric-agent",
            environment_id=default_environment.id,
            feature_version="1.1.17")
        ```

        ## Import

        ARMS Env Feature can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:arms/envFeature:EnvFeature example <environment_id>:<env_feature_name>
        ```

        :param str resource_name: The name of the resource.
        :param EnvFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 env_feature_name: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 feature_version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvFeatureArgs.__new__(EnvFeatureArgs)

            if env_feature_name is None and not opts.urn:
                raise TypeError("Missing required property 'env_feature_name'")
            __props__.__dict__["env_feature_name"] = env_feature_name
            if environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'environment_id'")
            __props__.__dict__["environment_id"] = environment_id
            if feature_version is None and not opts.urn:
                raise TypeError("Missing required property 'feature_version'")
            __props__.__dict__["feature_version"] = feature_version
            __props__.__dict__["namespace"] = None
            __props__.__dict__["status"] = None
        super(EnvFeature, __self__).__init__(
            'alicloud:arms/envFeature:EnvFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            env_feature_name: Optional[pulumi.Input[_builtins.str]] = None,
            environment_id: Optional[pulumi.Input[_builtins.str]] = None,
            feature_version: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'EnvFeature':
        """
        Get an existing EnvFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] env_feature_name: The name of the resource.
        :param pulumi.Input[_builtins.str] environment_id: The first ID of the resource.
        :param pulumi.Input[_builtins.str] feature_version: Version information of the Feature. You can query Feature information by using ListEnvironmentFeatures.
        :param pulumi.Input[_builtins.str] namespace: Namespace.
        :param pulumi.Input[_builtins.str] status: Status.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvFeatureState.__new__(_EnvFeatureState)

        __props__.__dict__["env_feature_name"] = env_feature_name
        __props__.__dict__["environment_id"] = environment_id
        __props__.__dict__["feature_version"] = feature_version
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["status"] = status
        return EnvFeature(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="envFeatureName")
    def env_feature_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "env_feature_name")

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "environment_id")

    @_builtins.property
    @pulumi.getter(name="featureVersion")
    def feature_version(self) -> pulumi.Output[_builtins.str]:
        """
        Version information of the Feature. You can query Feature information by using ListEnvironmentFeatures.
        """
        return pulumi.get(self, "feature_version")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[_builtins.str]:
        """
        Namespace.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status.
        """
        return pulumi.get(self, "status")

