# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GrafanaWorkspaceArgs', 'GrafanaWorkspace']

@pulumi.input_type
class GrafanaWorkspaceArgs:
    def __init__(__self__, *,
                 grafana_workspace_name: pulumi.Input[_builtins.str],
                 account_number: Optional[pulumi.Input[_builtins.str]] = None,
                 aliyun_lang: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_account_number: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.str]] = None,
                 grafana_version: Optional[pulumi.Input[_builtins.str]] = None,
                 grafana_workspace_edition: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a GrafanaWorkspace resource.
        :param pulumi.Input[_builtins.str] grafana_workspace_name: The name of the resource
        :param pulumi.Input[_builtins.str] account_number: Value Description:
               GrafanaWorkspaceEdition is standard, this parameter is invalid.
               GrafanaWorkspaceEdition is personal_edition. This parameter is invalid. Default value: 1.
               The value of GrafanaWorkspaceEdition is experts_edition. The values are respectively 10, 30, and 50. The default value is 10.
               The value of GrafanaWorkspaceEdition is advanced_edition. This parameter is invalid. The default value is 100.
        :param pulumi.Input[_builtins.str] aliyun_lang: Language environment (if not filled in, default is zh):
               - zh
               - en
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to automatically renew. Value range:
               - true: Automatic renewal. Default value: true.
               - false: Do not renew automatically.
        :param pulumi.Input[_builtins.str] custom_account_number: The number of additional user-defined accounts. Value Description:
               - GrafanaWorkspaceEdition is standard, this parameter is invalid.
               - GrafanaWorkspaceEdition is personal_edition, this parameter is invalid.
               - GrafanaWorkspaceEdition is experts_edition, this parameter is invalid.
               - GrafanaWorkspaceEdition is advanced_edition. The value range is 0 to 2000 and is a multiple of 10. The default value is 0.
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] duration: The time of the instance package. Valid values:
               - PricingCycle is Month, indicating monthly payment. The value range is 1 to 9.
               - PricingCycle is set to Year, indicating annual payment. The value range is 1 to 3. Default value: 1.
        :param pulumi.Input[_builtins.str] grafana_version: Grafana version
        :param pulumi.Input[_builtins.str] grafana_workspace_edition: The edition. **Valid values:**
               - standard: `Beta Edition(For internal testing only) `
               - personal_edition: Developer Edition
               - experts_edition: Pro Edition
               - advanced_edition: Advanced Edition
        :param pulumi.Input[_builtins.str] password: The password of the instance. It is 8 to 30 characters in length and must contain three types of characters: uppercase and lowercase letters, numbers, and special symbols. Special symbols can be:()'~! @#$%^& *-_+ =
        :param pulumi.Input[_builtins.str] pricing_cycle: The billing cycle of the package year and Month. Value: Month (default): purchase by Month. Year: Purchased by Year.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        """
        pulumi.set(__self__, "grafana_workspace_name", grafana_workspace_name)
        if account_number is not None:
            pulumi.set(__self__, "account_number", account_number)
        if aliyun_lang is not None:
            pulumi.set(__self__, "aliyun_lang", aliyun_lang)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if custom_account_number is not None:
            pulumi.set(__self__, "custom_account_number", custom_account_number)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if grafana_version is not None:
            pulumi.set(__self__, "grafana_version", grafana_version)
        if grafana_workspace_edition is not None:
            pulumi.set(__self__, "grafana_workspace_edition", grafana_workspace_edition)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="grafanaWorkspaceName")
    def grafana_workspace_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "grafana_workspace_name")

    @grafana_workspace_name.setter
    def grafana_workspace_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "grafana_workspace_name", value)

    @_builtins.property
    @pulumi.getter(name="accountNumber")
    def account_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Value Description:
        GrafanaWorkspaceEdition is standard, this parameter is invalid.
        GrafanaWorkspaceEdition is personal_edition. This parameter is invalid. Default value: 1.
        The value of GrafanaWorkspaceEdition is experts_edition. The values are respectively 10, 30, and 50. The default value is 10.
        The value of GrafanaWorkspaceEdition is advanced_edition. This parameter is invalid. The default value is 100.
        """
        return pulumi.get(self, "account_number")

    @account_number.setter
    def account_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_number", value)

    @_builtins.property
    @pulumi.getter(name="aliyunLang")
    def aliyun_lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Language environment (if not filled in, default is zh):
        - zh
        - en
        """
        return pulumi.get(self, "aliyun_lang")

    @aliyun_lang.setter
    def aliyun_lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aliyun_lang", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to automatically renew. Value range:
        - true: Automatic renewal. Default value: true.
        - false: Do not renew automatically.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="customAccountNumber")
    def custom_account_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The number of additional user-defined accounts. Value Description:
        - GrafanaWorkspaceEdition is standard, this parameter is invalid.
        - GrafanaWorkspaceEdition is personal_edition, this parameter is invalid.
        - GrafanaWorkspaceEdition is experts_edition, this parameter is invalid.
        - GrafanaWorkspaceEdition is advanced_edition. The value range is 0 to 2000 and is a multiple of 10. The default value is 0.
        """
        return pulumi.get(self, "custom_account_number")

    @custom_account_number.setter
    def custom_account_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_account_number", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time of the instance package. Valid values:
        - PricingCycle is Month, indicating monthly payment. The value range is 1 to 9.
        - PricingCycle is set to Year, indicating annual payment. The value range is 1 to 3. Default value: 1.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter(name="grafanaVersion")
    def grafana_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Grafana version
        """
        return pulumi.get(self, "grafana_version")

    @grafana_version.setter
    def grafana_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "grafana_version", value)

    @_builtins.property
    @pulumi.getter(name="grafanaWorkspaceEdition")
    def grafana_workspace_edition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The edition. **Valid values:**
        - standard: `Beta Edition(For internal testing only) `
        - personal_edition: Developer Edition
        - experts_edition: Pro Edition
        - advanced_edition: Advanced Edition
        """
        return pulumi.get(self, "grafana_workspace_edition")

    @grafana_workspace_edition.setter
    def grafana_workspace_edition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "grafana_workspace_edition", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the instance. It is 8 to 30 characters in length and must contain three types of characters: uppercase and lowercase letters, numbers, and special symbols. Special symbols can be:()'~! @#$%^& *-_+ =
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing cycle of the package year and Month. Value: Month (default): purchase by Month. Year: Purchased by Year.
        """
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pricing_cycle", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _GrafanaWorkspaceState:
    def __init__(__self__, *,
                 account_number: Optional[pulumi.Input[_builtins.str]] = None,
                 aliyun_lang: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_account_number: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.str]] = None,
                 grafana_version: Optional[pulumi.Input[_builtins.str]] = None,
                 grafana_workspace_edition: Optional[pulumi.Input[_builtins.str]] = None,
                 grafana_workspace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering GrafanaWorkspace resources.
        :param pulumi.Input[_builtins.str] account_number: Value Description:
               GrafanaWorkspaceEdition is standard, this parameter is invalid.
               GrafanaWorkspaceEdition is personal_edition. This parameter is invalid. Default value: 1.
               The value of GrafanaWorkspaceEdition is experts_edition. The values are respectively 10, 30, and 50. The default value is 10.
               The value of GrafanaWorkspaceEdition is advanced_edition. This parameter is invalid. The default value is 100.
        :param pulumi.Input[_builtins.str] aliyun_lang: Language environment (if not filled in, default is zh):
               - zh
               - en
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to automatically renew. Value range:
               - true: Automatic renewal. Default value: true.
               - false: Do not renew automatically.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] custom_account_number: The number of additional user-defined accounts. Value Description:
               - GrafanaWorkspaceEdition is standard, this parameter is invalid.
               - GrafanaWorkspaceEdition is personal_edition, this parameter is invalid.
               - GrafanaWorkspaceEdition is experts_edition, this parameter is invalid.
               - GrafanaWorkspaceEdition is advanced_edition. The value range is 0 to 2000 and is a multiple of 10. The default value is 0.
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] duration: The time of the instance package. Valid values:
               - PricingCycle is Month, indicating monthly payment. The value range is 1 to 9.
               - PricingCycle is set to Year, indicating annual payment. The value range is 1 to 3. Default value: 1.
        :param pulumi.Input[_builtins.str] grafana_version: Grafana version
        :param pulumi.Input[_builtins.str] grafana_workspace_edition: The edition. **Valid values:**
               - standard: `Beta Edition(For internal testing only) `
               - personal_edition: Developer Edition
               - experts_edition: Pro Edition
               - advanced_edition: Advanced Edition
        :param pulumi.Input[_builtins.str] grafana_workspace_name: The name of the resource
        :param pulumi.Input[_builtins.str] password: The password of the instance. It is 8 to 30 characters in length and must contain three types of characters: uppercase and lowercase letters, numbers, and special symbols. Special symbols can be:()'~! @#$%^& *-_+ =
        :param pulumi.Input[_builtins.str] pricing_cycle: The billing cycle of the package year and Month. Value: Month (default): purchase by Month. Year: Purchased by Year.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the resource
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        """
        if account_number is not None:
            pulumi.set(__self__, "account_number", account_number)
        if aliyun_lang is not None:
            pulumi.set(__self__, "aliyun_lang", aliyun_lang)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if custom_account_number is not None:
            pulumi.set(__self__, "custom_account_number", custom_account_number)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if grafana_version is not None:
            pulumi.set(__self__, "grafana_version", grafana_version)
        if grafana_workspace_edition is not None:
            pulumi.set(__self__, "grafana_workspace_edition", grafana_workspace_edition)
        if grafana_workspace_name is not None:
            pulumi.set(__self__, "grafana_workspace_name", grafana_workspace_name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="accountNumber")
    def account_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Value Description:
        GrafanaWorkspaceEdition is standard, this parameter is invalid.
        GrafanaWorkspaceEdition is personal_edition. This parameter is invalid. Default value: 1.
        The value of GrafanaWorkspaceEdition is experts_edition. The values are respectively 10, 30, and 50. The default value is 10.
        The value of GrafanaWorkspaceEdition is advanced_edition. This parameter is invalid. The default value is 100.
        """
        return pulumi.get(self, "account_number")

    @account_number.setter
    def account_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_number", value)

    @_builtins.property
    @pulumi.getter(name="aliyunLang")
    def aliyun_lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Language environment (if not filled in, default is zh):
        - zh
        - en
        """
        return pulumi.get(self, "aliyun_lang")

    @aliyun_lang.setter
    def aliyun_lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aliyun_lang", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to automatically renew. Value range:
        - true: Automatic renewal. Default value: true.
        - false: Do not renew automatically.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="customAccountNumber")
    def custom_account_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The number of additional user-defined accounts. Value Description:
        - GrafanaWorkspaceEdition is standard, this parameter is invalid.
        - GrafanaWorkspaceEdition is personal_edition, this parameter is invalid.
        - GrafanaWorkspaceEdition is experts_edition, this parameter is invalid.
        - GrafanaWorkspaceEdition is advanced_edition. The value range is 0 to 2000 and is a multiple of 10. The default value is 0.
        """
        return pulumi.get(self, "custom_account_number")

    @custom_account_number.setter
    def custom_account_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_account_number", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time of the instance package. Valid values:
        - PricingCycle is Month, indicating monthly payment. The value range is 1 to 9.
        - PricingCycle is set to Year, indicating annual payment. The value range is 1 to 3. Default value: 1.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter(name="grafanaVersion")
    def grafana_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Grafana version
        """
        return pulumi.get(self, "grafana_version")

    @grafana_version.setter
    def grafana_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "grafana_version", value)

    @_builtins.property
    @pulumi.getter(name="grafanaWorkspaceEdition")
    def grafana_workspace_edition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The edition. **Valid values:**
        - standard: `Beta Edition(For internal testing only) `
        - personal_edition: Developer Edition
        - experts_edition: Pro Edition
        - advanced_edition: Advanced Edition
        """
        return pulumi.get(self, "grafana_workspace_edition")

    @grafana_workspace_edition.setter
    def grafana_workspace_edition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "grafana_workspace_edition", value)

    @_builtins.property
    @pulumi.getter(name="grafanaWorkspaceName")
    def grafana_workspace_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "grafana_workspace_name")

    @grafana_workspace_name.setter
    def grafana_workspace_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "grafana_workspace_name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the instance. It is 8 to 30 characters in length and must contain three types of characters: uppercase and lowercase letters, numbers, and special symbols. Special symbols can be:()'~! @#$%^& *-_+ =
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing cycle of the package year and Month. Value: Month (default): purchase by Month. Year: Purchased by Year.
        """
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pricing_cycle", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the resource
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:arms/grafanaWorkspace:GrafanaWorkspace")
class GrafanaWorkspace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_number: Optional[pulumi.Input[_builtins.str]] = None,
                 aliyun_lang: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_account_number: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.str]] = None,
                 grafana_version: Optional[pulumi.Input[_builtins.str]] = None,
                 grafana_workspace_edition: Optional[pulumi.Input[_builtins.str]] = None,
                 grafana_workspace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Application Real-Time Monitoring Service (ARMS) Grafana Workspace resource.

        For information about Application Real-Time Monitoring Service (ARMS) Grafana Workspace and how to use it, see [What is Grafana Workspace](https://next.api.alibabacloud.com/document/ARMS/2019-08-08/ListGrafanaWorkspace).

        > **NOTE:** Available since v1.215.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_grafana_workspace = alicloud.arms.GrafanaWorkspace("default",
            grafana_version="9.0.x",
            description=name,
            resource_group_id=default.ids[0],
            grafana_workspace_edition="standard",
            grafana_workspace_name=name,
            tags={
                "Created": "tf",
                "For": "example",
            })
        ```

        ## Import

        Application Real-Time Monitoring Service (ARMS) Grafana Workspace can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:arms/grafanaWorkspace:GrafanaWorkspace example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_number: Value Description:
               GrafanaWorkspaceEdition is standard, this parameter is invalid.
               GrafanaWorkspaceEdition is personal_edition. This parameter is invalid. Default value: 1.
               The value of GrafanaWorkspaceEdition is experts_edition. The values are respectively 10, 30, and 50. The default value is 10.
               The value of GrafanaWorkspaceEdition is advanced_edition. This parameter is invalid. The default value is 100.
        :param pulumi.Input[_builtins.str] aliyun_lang: Language environment (if not filled in, default is zh):
               - zh
               - en
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to automatically renew. Value range:
               - true: Automatic renewal. Default value: true.
               - false: Do not renew automatically.
        :param pulumi.Input[_builtins.str] custom_account_number: The number of additional user-defined accounts. Value Description:
               - GrafanaWorkspaceEdition is standard, this parameter is invalid.
               - GrafanaWorkspaceEdition is personal_edition, this parameter is invalid.
               - GrafanaWorkspaceEdition is experts_edition, this parameter is invalid.
               - GrafanaWorkspaceEdition is advanced_edition. The value range is 0 to 2000 and is a multiple of 10. The default value is 0.
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] duration: The time of the instance package. Valid values:
               - PricingCycle is Month, indicating monthly payment. The value range is 1 to 9.
               - PricingCycle is set to Year, indicating annual payment. The value range is 1 to 3. Default value: 1.
        :param pulumi.Input[_builtins.str] grafana_version: Grafana version
        :param pulumi.Input[_builtins.str] grafana_workspace_edition: The edition. **Valid values:**
               - standard: `Beta Edition(For internal testing only) `
               - personal_edition: Developer Edition
               - experts_edition: Pro Edition
               - advanced_edition: Advanced Edition
        :param pulumi.Input[_builtins.str] grafana_workspace_name: The name of the resource
        :param pulumi.Input[_builtins.str] password: The password of the instance. It is 8 to 30 characters in length and must contain three types of characters: uppercase and lowercase letters, numbers, and special symbols. Special symbols can be:()'~! @#$%^& *-_+ =
        :param pulumi.Input[_builtins.str] pricing_cycle: The billing cycle of the package year and Month. Value: Month (default): purchase by Month. Year: Purchased by Year.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GrafanaWorkspaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Application Real-Time Monitoring Service (ARMS) Grafana Workspace resource.

        For information about Application Real-Time Monitoring Service (ARMS) Grafana Workspace and how to use it, see [What is Grafana Workspace](https://next.api.alibabacloud.com/document/ARMS/2019-08-08/ListGrafanaWorkspace).

        > **NOTE:** Available since v1.215.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_grafana_workspace = alicloud.arms.GrafanaWorkspace("default",
            grafana_version="9.0.x",
            description=name,
            resource_group_id=default.ids[0],
            grafana_workspace_edition="standard",
            grafana_workspace_name=name,
            tags={
                "Created": "tf",
                "For": "example",
            })
        ```

        ## Import

        Application Real-Time Monitoring Service (ARMS) Grafana Workspace can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:arms/grafanaWorkspace:GrafanaWorkspace example <id>
        ```

        :param str resource_name: The name of the resource.
        :param GrafanaWorkspaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GrafanaWorkspaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_number: Optional[pulumi.Input[_builtins.str]] = None,
                 aliyun_lang: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_account_number: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 duration: Optional[pulumi.Input[_builtins.str]] = None,
                 grafana_version: Optional[pulumi.Input[_builtins.str]] = None,
                 grafana_workspace_edition: Optional[pulumi.Input[_builtins.str]] = None,
                 grafana_workspace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GrafanaWorkspaceArgs.__new__(GrafanaWorkspaceArgs)

            __props__.__dict__["account_number"] = account_number
            __props__.__dict__["aliyun_lang"] = aliyun_lang
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["custom_account_number"] = custom_account_number
            __props__.__dict__["description"] = description
            __props__.__dict__["duration"] = duration
            __props__.__dict__["grafana_version"] = grafana_version
            __props__.__dict__["grafana_workspace_edition"] = grafana_workspace_edition
            if grafana_workspace_name is None and not opts.urn:
                raise TypeError("Missing required property 'grafana_workspace_name'")
            __props__.__dict__["grafana_workspace_name"] = grafana_workspace_name
            __props__.__dict__["password"] = password
            __props__.__dict__["pricing_cycle"] = pricing_cycle
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
        super(GrafanaWorkspace, __self__).__init__(
            'alicloud:arms/grafanaWorkspace:GrafanaWorkspace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_number: Optional[pulumi.Input[_builtins.str]] = None,
            aliyun_lang: Optional[pulumi.Input[_builtins.str]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            custom_account_number: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            duration: Optional[pulumi.Input[_builtins.str]] = None,
            grafana_version: Optional[pulumi.Input[_builtins.str]] = None,
            grafana_workspace_edition: Optional[pulumi.Input[_builtins.str]] = None,
            grafana_workspace_name: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'GrafanaWorkspace':
        """
        Get an existing GrafanaWorkspace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_number: Value Description:
               GrafanaWorkspaceEdition is standard, this parameter is invalid.
               GrafanaWorkspaceEdition is personal_edition. This parameter is invalid. Default value: 1.
               The value of GrafanaWorkspaceEdition is experts_edition. The values are respectively 10, 30, and 50. The default value is 10.
               The value of GrafanaWorkspaceEdition is advanced_edition. This parameter is invalid. The default value is 100.
        :param pulumi.Input[_builtins.str] aliyun_lang: Language environment (if not filled in, default is zh):
               - zh
               - en
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to automatically renew. Value range:
               - true: Automatic renewal. Default value: true.
               - false: Do not renew automatically.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] custom_account_number: The number of additional user-defined accounts. Value Description:
               - GrafanaWorkspaceEdition is standard, this parameter is invalid.
               - GrafanaWorkspaceEdition is personal_edition, this parameter is invalid.
               - GrafanaWorkspaceEdition is experts_edition, this parameter is invalid.
               - GrafanaWorkspaceEdition is advanced_edition. The value range is 0 to 2000 and is a multiple of 10. The default value is 0.
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] duration: The time of the instance package. Valid values:
               - PricingCycle is Month, indicating monthly payment. The value range is 1 to 9.
               - PricingCycle is set to Year, indicating annual payment. The value range is 1 to 3. Default value: 1.
        :param pulumi.Input[_builtins.str] grafana_version: Grafana version
        :param pulumi.Input[_builtins.str] grafana_workspace_edition: The edition. **Valid values:**
               - standard: `Beta Edition(For internal testing only) `
               - personal_edition: Developer Edition
               - experts_edition: Pro Edition
               - advanced_edition: Advanced Edition
        :param pulumi.Input[_builtins.str] grafana_workspace_name: The name of the resource
        :param pulumi.Input[_builtins.str] password: The password of the instance. It is 8 to 30 characters in length and must contain three types of characters: uppercase and lowercase letters, numbers, and special symbols. Special symbols can be:()'~! @#$%^& *-_+ =
        :param pulumi.Input[_builtins.str] pricing_cycle: The billing cycle of the package year and Month. Value: Month (default): purchase by Month. Year: Purchased by Year.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the resource
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GrafanaWorkspaceState.__new__(_GrafanaWorkspaceState)

        __props__.__dict__["account_number"] = account_number
        __props__.__dict__["aliyun_lang"] = aliyun_lang
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["custom_account_number"] = custom_account_number
        __props__.__dict__["description"] = description
        __props__.__dict__["duration"] = duration
        __props__.__dict__["grafana_version"] = grafana_version
        __props__.__dict__["grafana_workspace_edition"] = grafana_workspace_edition
        __props__.__dict__["grafana_workspace_name"] = grafana_workspace_name
        __props__.__dict__["password"] = password
        __props__.__dict__["pricing_cycle"] = pricing_cycle
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return GrafanaWorkspace(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountNumber")
    def account_number(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Value Description:
        GrafanaWorkspaceEdition is standard, this parameter is invalid.
        GrafanaWorkspaceEdition is personal_edition. This parameter is invalid. Default value: 1.
        The value of GrafanaWorkspaceEdition is experts_edition. The values are respectively 10, 30, and 50. The default value is 10.
        The value of GrafanaWorkspaceEdition is advanced_edition. This parameter is invalid. The default value is 100.
        """
        return pulumi.get(self, "account_number")

    @_builtins.property
    @pulumi.getter(name="aliyunLang")
    def aliyun_lang(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Language environment (if not filled in, default is zh):
        - zh
        - en
        """
        return pulumi.get(self, "aliyun_lang")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to automatically renew. Value range:
        - true: Automatic renewal. Default value: true.
        - false: Do not renew automatically.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="customAccountNumber")
    def custom_account_number(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The number of additional user-defined accounts. Value Description:
        - GrafanaWorkspaceEdition is standard, this parameter is invalid.
        - GrafanaWorkspaceEdition is personal_edition, this parameter is invalid.
        - GrafanaWorkspaceEdition is experts_edition, this parameter is invalid.
        - GrafanaWorkspaceEdition is advanced_edition. The value range is 0 to 2000 and is a multiple of 10. The default value is 0.
        """
        return pulumi.get(self, "custom_account_number")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The time of the instance package. Valid values:
        - PricingCycle is Month, indicating monthly payment. The value range is 1 to 9.
        - PricingCycle is set to Year, indicating annual payment. The value range is 1 to 3. Default value: 1.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="grafanaVersion")
    def grafana_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Grafana version
        """
        return pulumi.get(self, "grafana_version")

    @_builtins.property
    @pulumi.getter(name="grafanaWorkspaceEdition")
    def grafana_workspace_edition(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The edition. **Valid values:**
        - standard: `Beta Edition(For internal testing only) `
        - personal_edition: Developer Edition
        - experts_edition: Pro Edition
        - advanced_edition: Advanced Edition
        """
        return pulumi.get(self, "grafana_workspace_edition")

    @_builtins.property
    @pulumi.getter(name="grafanaWorkspaceName")
    def grafana_workspace_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "grafana_workspace_name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password of the instance. It is 8 to 30 characters in length and must contain three types of characters: uppercase and lowercase letters, numbers, and special symbols. Special symbols can be:()'~! @#$%^& *-_+ =
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The billing cycle of the package year and Month. Value: Month (default): purchase by Month. Year: Purchased by Year.
        """
        return pulumi.get(self, "pricing_cycle")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID of the resource
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

