# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['HostAccountUserAttachmentArgs', 'HostAccountUserAttachment']

@pulumi.input_type
class HostAccountUserAttachmentArgs:
    def __init__(__self__, *,
                 host_account_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 host_id: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 user_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a HostAccountUserAttachment resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_account_ids: A list IDs of the host account.
        :param pulumi.Input[_builtins.str] host_id: The ID of the host.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Bastionhost instance where you want to authorize the user to manage the specified hosts and host accounts.
        :param pulumi.Input[_builtins.str] user_id: The ID of the user that you want to authorize to manage the specified hosts and host accounts.
        """
        pulumi.set(__self__, "host_account_ids", host_account_ids)
        pulumi.set(__self__, "host_id", host_id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="hostAccountIds")
    def host_account_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list IDs of the host account.
        """
        return pulumi.get(self, "host_account_ids")

    @host_account_ids.setter
    def host_account_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "host_account_ids", value)

    @_builtins.property
    @pulumi.getter(name="hostId")
    def host_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the host.
        """
        return pulumi.get(self, "host_id")

    @host_id.setter
    def host_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "host_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Bastionhost instance where you want to authorize the user to manage the specified hosts and host accounts.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the user that you want to authorize to manage the specified hosts and host accounts.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class _HostAccountUserAttachmentState:
    def __init__(__self__, *,
                 host_account_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering HostAccountUserAttachment resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_account_ids: A list IDs of the host account.
        :param pulumi.Input[_builtins.str] host_id: The ID of the host.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Bastionhost instance where you want to authorize the user to manage the specified hosts and host accounts.
        :param pulumi.Input[_builtins.str] user_id: The ID of the user that you want to authorize to manage the specified hosts and host accounts.
        """
        if host_account_ids is not None:
            pulumi.set(__self__, "host_account_ids", host_account_ids)
        if host_id is not None:
            pulumi.set(__self__, "host_id", host_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="hostAccountIds")
    def host_account_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list IDs of the host account.
        """
        return pulumi.get(self, "host_account_ids")

    @host_account_ids.setter
    def host_account_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "host_account_ids", value)

    @_builtins.property
    @pulumi.getter(name="hostId")
    def host_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the host.
        """
        return pulumi.get(self, "host_id")

    @host_id.setter
    def host_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Bastionhost instance where you want to authorize the user to manage the specified hosts and host accounts.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the user that you want to authorize to manage the specified hosts and host accounts.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)


@pulumi.type_token("alicloud:bastionhost/hostAccountUserAttachment:HostAccountUserAttachment")
class HostAccountUserAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 host_account_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Bastion Host Host Account Attachment resource to add list host accounts into one user.

        > **NOTE:** Available since v1.135.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$",
            cidr_block="10.4.0.0/16")
        default_get_switches = alicloud.vpc.get_switches(cidr_block="10.4.0.0/24",
            vpc_id=default_get_networks.ids[0],
            zone_id=default.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("default", vpc_id=default_get_networks.ids[0])
        default_instance = alicloud.bastionhost.Instance("default",
            description=name,
            license_code="bhah_ent_50_asset",
            plan_code="cloudbastion",
            storage="5",
            bandwidth="5",
            period=1,
            vswitch_id=default_get_switches.ids[0],
            security_group_ids=[default_security_group.id])
        default_host = alicloud.bastionhost.Host("default",
            instance_id=default_instance.id,
            host_name=name,
            active_address_type="Private",
            host_private_address="172.16.0.10",
            os_type="Linux",
            source="Local")
        default_host_account = alicloud.bastionhost.HostAccount("default",
            host_account_name=name,
            host_id=default_host.host_id,
            instance_id=default_host.instance_id,
            protocol_name="SSH",
            password="YourPassword12345")
        local_user = alicloud.bastionhost.User("local_user",
            instance_id=default_instance.id,
            mobile_country_code="CN",
            mobile="13312345678",
            password="YourPassword-123",
            source="Local",
            user_name=f"{name}_local_user")
        default_host_account_user_attachment = alicloud.bastionhost.HostAccountUserAttachment("default",
            instance_id=default_host.instance_id,
            user_id=local_user.user_id,
            host_id=default_host.host_id,
            host_account_ids=[default_host_account.host_account_id])
        ```

        ## Import

        Bastion Host Host Account can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:bastionhost/hostAccountUserAttachment:HostAccountUserAttachment example <instance_id>:<user_id>:<host_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_account_ids: A list IDs of the host account.
        :param pulumi.Input[_builtins.str] host_id: The ID of the host.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Bastionhost instance where you want to authorize the user to manage the specified hosts and host accounts.
        :param pulumi.Input[_builtins.str] user_id: The ID of the user that you want to authorize to manage the specified hosts and host accounts.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HostAccountUserAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Bastion Host Host Account Attachment resource to add list host accounts into one user.

        > **NOTE:** Available since v1.135.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$",
            cidr_block="10.4.0.0/16")
        default_get_switches = alicloud.vpc.get_switches(cidr_block="10.4.0.0/24",
            vpc_id=default_get_networks.ids[0],
            zone_id=default.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("default", vpc_id=default_get_networks.ids[0])
        default_instance = alicloud.bastionhost.Instance("default",
            description=name,
            license_code="bhah_ent_50_asset",
            plan_code="cloudbastion",
            storage="5",
            bandwidth="5",
            period=1,
            vswitch_id=default_get_switches.ids[0],
            security_group_ids=[default_security_group.id])
        default_host = alicloud.bastionhost.Host("default",
            instance_id=default_instance.id,
            host_name=name,
            active_address_type="Private",
            host_private_address="172.16.0.10",
            os_type="Linux",
            source="Local")
        default_host_account = alicloud.bastionhost.HostAccount("default",
            host_account_name=name,
            host_id=default_host.host_id,
            instance_id=default_host.instance_id,
            protocol_name="SSH",
            password="YourPassword12345")
        local_user = alicloud.bastionhost.User("local_user",
            instance_id=default_instance.id,
            mobile_country_code="CN",
            mobile="13312345678",
            password="YourPassword-123",
            source="Local",
            user_name=f"{name}_local_user")
        default_host_account_user_attachment = alicloud.bastionhost.HostAccountUserAttachment("default",
            instance_id=default_host.instance_id,
            user_id=local_user.user_id,
            host_id=default_host.host_id,
            host_account_ids=[default_host_account.host_account_id])
        ```

        ## Import

        Bastion Host Host Account can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:bastionhost/hostAccountUserAttachment:HostAccountUserAttachment example <instance_id>:<user_id>:<host_id>
        ```

        :param str resource_name: The name of the resource.
        :param HostAccountUserAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HostAccountUserAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 host_account_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HostAccountUserAttachmentArgs.__new__(HostAccountUserAttachmentArgs)

            if host_account_ids is None and not opts.urn:
                raise TypeError("Missing required property 'host_account_ids'")
            __props__.__dict__["host_account_ids"] = host_account_ids
            if host_id is None and not opts.urn:
                raise TypeError("Missing required property 'host_id'")
            __props__.__dict__["host_id"] = host_id
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__.__dict__["user_id"] = user_id
        super(HostAccountUserAttachment, __self__).__init__(
            'alicloud:bastionhost/hostAccountUserAttachment:HostAccountUserAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            host_account_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            host_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            user_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'HostAccountUserAttachment':
        """
        Get an existing HostAccountUserAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] host_account_ids: A list IDs of the host account.
        :param pulumi.Input[_builtins.str] host_id: The ID of the host.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Bastionhost instance where you want to authorize the user to manage the specified hosts and host accounts.
        :param pulumi.Input[_builtins.str] user_id: The ID of the user that you want to authorize to manage the specified hosts and host accounts.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HostAccountUserAttachmentState.__new__(_HostAccountUserAttachmentState)

        __props__.__dict__["host_account_ids"] = host_account_ids
        __props__.__dict__["host_id"] = host_id
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["user_id"] = user_id
        return HostAccountUserAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="hostAccountIds")
    def host_account_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list IDs of the host account.
        """
        return pulumi.get(self, "host_account_ids")

    @_builtins.property
    @pulumi.getter(name="hostId")
    def host_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the host.
        """
        return pulumi.get(self, "host_id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Bastionhost instance where you want to authorize the user to manage the specified hosts and host accounts.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the user that you want to authorize to manage the specified hosts and host accounts.
        """
        return pulumi.get(self, "user_id")

