# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTransitRouterRouteTableAssociationsResult',
    'AwaitableGetTransitRouterRouteTableAssociationsResult',
    'get_transit_router_route_table_associations',
    'get_transit_router_route_table_associations_output',
]

@pulumi.output_type
class GetTransitRouterRouteTableAssociationsResult:
    """
    A collection of values returned by getTransitRouterRouteTableAssociations.
    """
    def __init__(__self__, associations=None, id=None, ids=None, output_file=None, status=None, transit_router_attachment_id=None, transit_router_attachment_resource_id=None, transit_router_attachment_resource_type=None, transit_router_route_table_id=None):
        if associations and not isinstance(associations, list):
            raise TypeError("Expected argument 'associations' to be a list")
        pulumi.set(__self__, "associations", associations)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if transit_router_attachment_id and not isinstance(transit_router_attachment_id, str):
            raise TypeError("Expected argument 'transit_router_attachment_id' to be a str")
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        if transit_router_attachment_resource_id and not isinstance(transit_router_attachment_resource_id, str):
            raise TypeError("Expected argument 'transit_router_attachment_resource_id' to be a str")
        pulumi.set(__self__, "transit_router_attachment_resource_id", transit_router_attachment_resource_id)
        if transit_router_attachment_resource_type and not isinstance(transit_router_attachment_resource_type, str):
            raise TypeError("Expected argument 'transit_router_attachment_resource_type' to be a str")
        pulumi.set(__self__, "transit_router_attachment_resource_type", transit_router_attachment_resource_type)
        if transit_router_route_table_id and not isinstance(transit_router_route_table_id, str):
            raise TypeError("Expected argument 'transit_router_route_table_id' to be a str")
        pulumi.set(__self__, "transit_router_route_table_id", transit_router_route_table_id)

    @_builtins.property
    @pulumi.getter
    def associations(self) -> Sequence['outputs.GetTransitRouterRouteTableAssociationsAssociationResult']:
        """
        A list of CEN Transit Router Route Table Associations. Each element contains the following attributes:
        """
        return pulumi.get(self, "associations")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of CEN Transit Router Route Table Association IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the route table.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> Optional[_builtins.str]:
        """
        ID of the transit router attachment.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentResourceId")
    def transit_router_attachment_resource_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "transit_router_attachment_resource_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentResourceType")
    def transit_router_attachment_resource_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "transit_router_attachment_resource_type")

    @_builtins.property
    @pulumi.getter(name="transitRouterRouteTableId")
    def transit_router_route_table_id(self) -> Optional[_builtins.str]:
        """
        ID of the transit router route table.
        """
        return pulumi.get(self, "transit_router_route_table_id")


class AwaitableGetTransitRouterRouteTableAssociationsResult(GetTransitRouterRouteTableAssociationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTransitRouterRouteTableAssociationsResult(
            associations=self.associations,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            status=self.status,
            transit_router_attachment_id=self.transit_router_attachment_id,
            transit_router_attachment_resource_id=self.transit_router_attachment_resource_id,
            transit_router_attachment_resource_type=self.transit_router_attachment_resource_type,
            transit_router_route_table_id=self.transit_router_route_table_id)


def get_transit_router_route_table_associations(ids: Optional[Sequence[_builtins.str]] = None,
                                                output_file: Optional[_builtins.str] = None,
                                                status: Optional[_builtins.str] = None,
                                                transit_router_attachment_id: Optional[_builtins.str] = None,
                                                transit_router_attachment_resource_id: Optional[_builtins.str] = None,
                                                transit_router_attachment_resource_type: Optional[_builtins.str] = None,
                                                transit_router_route_table_id: Optional[_builtins.str] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTransitRouterRouteTableAssociationsResult:
    """
    This data source provides CEN Transit Router Route Table Associations available to the user.[What is Cen Transit Router Route Table Associations](https://help.aliyun.com/document_detail/261243.html)

    > **NOTE:** Available in 1.126.0+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.cen.get_transit_router_route_table_associations(transit_router_route_table_id="rtb-id1")
    pulumi.export("firstTransitRouterPeerAttachmentsTransitRouterAttachmentResourceType", default.associations[0].resource_type)
    ```


    :param Sequence[_builtins.str] ids: A list of CEN Transit Router Route Table Association IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of the route table, including `Active`, `Associating`, `Dissociating`.
    :param _builtins.str transit_router_attachment_id: The ID of the network instance connection.
    :param _builtins.str transit_router_attachment_resource_id: The ID of the next hop.
    :param _builtins.str transit_router_attachment_resource_type: The type of next hop. Valid values:
           * `VPC`: virtual private cloud (VPC)
           * `VBR`: virtual border router (VBR)
           * `TR`: transit router
           * `VPN`: VPN attachment
    :param _builtins.str transit_router_route_table_id: The ID of the route table of the Enterprise Edition transit router.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['status'] = status
    __args__['transitRouterAttachmentId'] = transit_router_attachment_id
    __args__['transitRouterAttachmentResourceId'] = transit_router_attachment_resource_id
    __args__['transitRouterAttachmentResourceType'] = transit_router_attachment_resource_type
    __args__['transitRouterRouteTableId'] = transit_router_route_table_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cen/getTransitRouterRouteTableAssociations:getTransitRouterRouteTableAssociations', __args__, opts=opts, typ=GetTransitRouterRouteTableAssociationsResult).value

    return AwaitableGetTransitRouterRouteTableAssociationsResult(
        associations=pulumi.get(__ret__, 'associations'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        status=pulumi.get(__ret__, 'status'),
        transit_router_attachment_id=pulumi.get(__ret__, 'transit_router_attachment_id'),
        transit_router_attachment_resource_id=pulumi.get(__ret__, 'transit_router_attachment_resource_id'),
        transit_router_attachment_resource_type=pulumi.get(__ret__, 'transit_router_attachment_resource_type'),
        transit_router_route_table_id=pulumi.get(__ret__, 'transit_router_route_table_id'))
def get_transit_router_route_table_associations_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                                       output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                       status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                       transit_router_attachment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                       transit_router_attachment_resource_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                       transit_router_attachment_resource_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                       transit_router_route_table_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTransitRouterRouteTableAssociationsResult]:
    """
    This data source provides CEN Transit Router Route Table Associations available to the user.[What is Cen Transit Router Route Table Associations](https://help.aliyun.com/document_detail/261243.html)

    > **NOTE:** Available in 1.126.0+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.cen.get_transit_router_route_table_associations(transit_router_route_table_id="rtb-id1")
    pulumi.export("firstTransitRouterPeerAttachmentsTransitRouterAttachmentResourceType", default.associations[0].resource_type)
    ```


    :param Sequence[_builtins.str] ids: A list of CEN Transit Router Route Table Association IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of the route table, including `Active`, `Associating`, `Dissociating`.
    :param _builtins.str transit_router_attachment_id: The ID of the network instance connection.
    :param _builtins.str transit_router_attachment_resource_id: The ID of the next hop.
    :param _builtins.str transit_router_attachment_resource_type: The type of next hop. Valid values:
           * `VPC`: virtual private cloud (VPC)
           * `VBR`: virtual border router (VBR)
           * `TR`: transit router
           * `VPN`: VPN attachment
    :param _builtins.str transit_router_route_table_id: The ID of the route table of the Enterprise Edition transit router.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['status'] = status
    __args__['transitRouterAttachmentId'] = transit_router_attachment_id
    __args__['transitRouterAttachmentResourceId'] = transit_router_attachment_resource_id
    __args__['transitRouterAttachmentResourceType'] = transit_router_attachment_resource_type
    __args__['transitRouterRouteTableId'] = transit_router_route_table_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cen/getTransitRouterRouteTableAssociations:getTransitRouterRouteTableAssociations', __args__, opts=opts, typ=GetTransitRouterRouteTableAssociationsResult)
    return __ret__.apply(lambda __response__: GetTransitRouterRouteTableAssociationsResult(
        associations=pulumi.get(__response__, 'associations'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        output_file=pulumi.get(__response__, 'output_file'),
        status=pulumi.get(__response__, 'status'),
        transit_router_attachment_id=pulumi.get(__response__, 'transit_router_attachment_id'),
        transit_router_attachment_resource_id=pulumi.get(__response__, 'transit_router_attachment_resource_id'),
        transit_router_attachment_resource_type=pulumi.get(__response__, 'transit_router_attachment_resource_type'),
        transit_router_route_table_id=pulumi.get(__response__, 'transit_router_route_table_id')))
