# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTransitRouterVpnAttachmentsResult',
    'AwaitableGetTransitRouterVpnAttachmentsResult',
    'get_transit_router_vpn_attachments',
    'get_transit_router_vpn_attachments_output',
]

@pulumi.output_type
class GetTransitRouterVpnAttachmentsResult:
    """
    A collection of values returned by getTransitRouterVpnAttachments.
    """
    def __init__(__self__, attachments=None, cen_id=None, id=None, ids=None, name_regex=None, names=None, output_file=None, status=None, tags=None, transit_router_attachment_id=None, transit_router_id=None):
        if attachments and not isinstance(attachments, list):
            raise TypeError("Expected argument 'attachments' to be a list")
        pulumi.set(__self__, "attachments", attachments)
        if cen_id and not isinstance(cen_id, str):
            raise TypeError("Expected argument 'cen_id' to be a str")
        pulumi.set(__self__, "cen_id", cen_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if transit_router_attachment_id and not isinstance(transit_router_attachment_id, str):
            raise TypeError("Expected argument 'transit_router_attachment_id' to be a str")
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        if transit_router_id and not isinstance(transit_router_id, str):
            raise TypeError("Expected argument 'transit_router_id' to be a str")
        pulumi.set(__self__, "transit_router_id", transit_router_id)

    @_builtins.property
    @pulumi.getter
    def attachments(self) -> Sequence['outputs.GetTransitRouterVpnAttachmentsAttachmentResult']:
        """
        A list of Transit Router Vpn Attachment Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "attachments")

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[_builtins.str]:
        """
        (Available since v1.245.0) The ID of the Cloud Enterprise Network (CEN) instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of name of Transit Router Vpn Attachments.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the VPN connection.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        (Available since v1.245.0) The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> Optional[_builtins.str]:
        """
        (Available since v1.245.0) The ID of the VPN attachment.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[_builtins.str]:
        """
        The ID of the transit router.
        """
        return pulumi.get(self, "transit_router_id")


class AwaitableGetTransitRouterVpnAttachmentsResult(GetTransitRouterVpnAttachmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTransitRouterVpnAttachmentsResult(
            attachments=self.attachments,
            cen_id=self.cen_id,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            status=self.status,
            tags=self.tags,
            transit_router_attachment_id=self.transit_router_attachment_id,
            transit_router_id=self.transit_router_id)


def get_transit_router_vpn_attachments(cen_id: Optional[_builtins.str] = None,
                                       ids: Optional[Sequence[_builtins.str]] = None,
                                       name_regex: Optional[_builtins.str] = None,
                                       output_file: Optional[_builtins.str] = None,
                                       status: Optional[_builtins.str] = None,
                                       tags: Optional[Mapping[str, _builtins.str]] = None,
                                       transit_router_attachment_id: Optional[_builtins.str] = None,
                                       transit_router_id: Optional[_builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTransitRouterVpnAttachmentsResult:
    """
    This data source provides Cen Transit Router Vpn Attachment available to the user.[What is Transit Router Vpn Attachment](https://next.api.alibabacloud.com/document/Cbn/2017-09-12/CreateTransitRouterVpnAttachment)

    > **NOTE:** Available since v1.183.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.get_account()
    default_instance = alicloud.cen.Instance("default", cen_instance_name=name)
    default_transit_router = alicloud.cen.TransitRouter("default", cen_id=default_instance.id)
    default_transit_router_cidr = alicloud.cen.TransitRouterCidr("default",
        cidr="192.168.10.0/24",
        transit_router_id=default_transit_router.transit_router_id,
        publish_cidr_route=True)
    default_customer_gateway = alicloud.vpn.CustomerGateway("default",
        ip_address="1.1.1.8",
        customer_gateway_name=name,
        opts = pulumi.ResourceOptions(depends_on=[default_transit_router_cidr]))
    default_gateway_vpn_attachment = alicloud.vpn.GatewayVpnAttachment("default",
        network_type="public",
        local_subnet="0.0.0.0/0",
        enable_tunnels_bgp=False,
        vpn_attachment_name=name,
        tunnel_options_specifications=[
            {
                "customer_gateway_id": default_customer_gateway.id,
                "enable_dpd": True,
                "enable_nat_traversal": True,
                "tunnel_index": 1,
                "tunnel_ike_config": {
                    "remote_id": "2.2.2.2",
                    "ike_enc_alg": "aes",
                    "ike_mode": "main",
                    "ike_version": "ikev1",
                    "local_id": "1.1.1.1",
                    "ike_auth_alg": "md5",
                    "ike_lifetime": 86100,
                    "ike_pfs": "group2",
                    "psk": "12345678",
                },
                "tunnel_ipsec_config": {
                    "ipsec_auth_alg": "md5",
                    "ipsec_enc_alg": "aes",
                    "ipsec_lifetime": 86200,
                    "ipsec_pfs": "group5",
                },
            },
            {
                "enable_nat_traversal": True,
                "tunnel_index": 2,
                "tunnel_ike_config": {
                    "local_id": "4.4.4.4",
                    "remote_id": "5.5.5.5",
                    "ike_lifetime": 86400,
                    "ike_pfs": "group5",
                    "ike_mode": "main",
                    "ike_version": "ikev2",
                    "psk": "32333442",
                    "ike_auth_alg": "md5",
                    "ike_enc_alg": "aes",
                },
                "tunnel_ipsec_config": {
                    "ipsec_enc_alg": "aes",
                    "ipsec_lifetime": 86400,
                    "ipsec_pfs": "group5",
                    "ipsec_auth_alg": "sha256",
                },
                "customer_gateway_id": default_customer_gateway.id,
                "enable_dpd": True,
            },
        ],
        remote_subnet="0.0.0.0/0")
    default_transit_router_vpn_attachment = alicloud.cen.TransitRouterVpnAttachment("default",
        auto_publish_route_enabled=False,
        transit_router_attachment_description=name,
        transit_router_attachment_name=name,
        cen_id=default_transit_router.cen_id,
        transit_router_id=default_transit_router.transit_router_id,
        vpn_id=default_gateway_vpn_attachment.id,
        vpn_owner_id=default.id,
        charge_type="POSTPAY",
        tags={
            "Created": "TF",
            "For": "VpnAttachment",
        })
    ids = pulumi.Output.all(
        id=default_transit_router_vpn_attachment.id,
        cen_id=default_transit_router_vpn_attachment.cen_id,
        transit_router_id=default_transit_router_vpn_attachment.transit_router_id
    ).apply(lambda resolved_outputs: alicloud.cen.get_transit_router_vpn_attachments_output(ids=[resolved_outputs['id']],
        cen_id=resolved_outputs['cen_id'],
        transit_router_id=resolved_outputs['transit_router_id']))

    pulumi.export("cenTransitRouterVpnAttachmentId0", ids.attachments[0].id)
    ```


    :param _builtins.str cen_id: The ID of the Cloud Enterprise Network (CEN) instance.
    :param Sequence[_builtins.str] ids: A list of Transit Router Vpn Attachment IDs.
    :param _builtins.str name_regex: A regex string to filter results by Transit Router Vpn Attachment name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The Status of Transit Router Vpn Attachment. Valid values: `Attached`, `Attaching`, `Detaching`.
    :param Mapping[str, _builtins.str] tags: The tag of the resource.
    :param _builtins.str transit_router_attachment_id: The ID of the VPN attachment.
    :param _builtins.str transit_router_id: The ID of the transit router.
    """
    __args__ = dict()
    __args__['cenId'] = cen_id
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['transitRouterAttachmentId'] = transit_router_attachment_id
    __args__['transitRouterId'] = transit_router_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cen/getTransitRouterVpnAttachments:getTransitRouterVpnAttachments', __args__, opts=opts, typ=GetTransitRouterVpnAttachmentsResult).value

    return AwaitableGetTransitRouterVpnAttachmentsResult(
        attachments=pulumi.get(__ret__, 'attachments'),
        cen_id=pulumi.get(__ret__, 'cen_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        transit_router_attachment_id=pulumi.get(__ret__, 'transit_router_attachment_id'),
        transit_router_id=pulumi.get(__ret__, 'transit_router_id'))
def get_transit_router_vpn_attachments_output(cen_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                              name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                              transit_router_attachment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              transit_router_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTransitRouterVpnAttachmentsResult]:
    """
    This data source provides Cen Transit Router Vpn Attachment available to the user.[What is Transit Router Vpn Attachment](https://next.api.alibabacloud.com/document/Cbn/2017-09-12/CreateTransitRouterVpnAttachment)

    > **NOTE:** Available since v1.183.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.get_account()
    default_instance = alicloud.cen.Instance("default", cen_instance_name=name)
    default_transit_router = alicloud.cen.TransitRouter("default", cen_id=default_instance.id)
    default_transit_router_cidr = alicloud.cen.TransitRouterCidr("default",
        cidr="192.168.10.0/24",
        transit_router_id=default_transit_router.transit_router_id,
        publish_cidr_route=True)
    default_customer_gateway = alicloud.vpn.CustomerGateway("default",
        ip_address="1.1.1.8",
        customer_gateway_name=name,
        opts = pulumi.ResourceOptions(depends_on=[default_transit_router_cidr]))
    default_gateway_vpn_attachment = alicloud.vpn.GatewayVpnAttachment("default",
        network_type="public",
        local_subnet="0.0.0.0/0",
        enable_tunnels_bgp=False,
        vpn_attachment_name=name,
        tunnel_options_specifications=[
            {
                "customer_gateway_id": default_customer_gateway.id,
                "enable_dpd": True,
                "enable_nat_traversal": True,
                "tunnel_index": 1,
                "tunnel_ike_config": {
                    "remote_id": "2.2.2.2",
                    "ike_enc_alg": "aes",
                    "ike_mode": "main",
                    "ike_version": "ikev1",
                    "local_id": "1.1.1.1",
                    "ike_auth_alg": "md5",
                    "ike_lifetime": 86100,
                    "ike_pfs": "group2",
                    "psk": "12345678",
                },
                "tunnel_ipsec_config": {
                    "ipsec_auth_alg": "md5",
                    "ipsec_enc_alg": "aes",
                    "ipsec_lifetime": 86200,
                    "ipsec_pfs": "group5",
                },
            },
            {
                "enable_nat_traversal": True,
                "tunnel_index": 2,
                "tunnel_ike_config": {
                    "local_id": "4.4.4.4",
                    "remote_id": "5.5.5.5",
                    "ike_lifetime": 86400,
                    "ike_pfs": "group5",
                    "ike_mode": "main",
                    "ike_version": "ikev2",
                    "psk": "32333442",
                    "ike_auth_alg": "md5",
                    "ike_enc_alg": "aes",
                },
                "tunnel_ipsec_config": {
                    "ipsec_enc_alg": "aes",
                    "ipsec_lifetime": 86400,
                    "ipsec_pfs": "group5",
                    "ipsec_auth_alg": "sha256",
                },
                "customer_gateway_id": default_customer_gateway.id,
                "enable_dpd": True,
            },
        ],
        remote_subnet="0.0.0.0/0")
    default_transit_router_vpn_attachment = alicloud.cen.TransitRouterVpnAttachment("default",
        auto_publish_route_enabled=False,
        transit_router_attachment_description=name,
        transit_router_attachment_name=name,
        cen_id=default_transit_router.cen_id,
        transit_router_id=default_transit_router.transit_router_id,
        vpn_id=default_gateway_vpn_attachment.id,
        vpn_owner_id=default.id,
        charge_type="POSTPAY",
        tags={
            "Created": "TF",
            "For": "VpnAttachment",
        })
    ids = pulumi.Output.all(
        id=default_transit_router_vpn_attachment.id,
        cen_id=default_transit_router_vpn_attachment.cen_id,
        transit_router_id=default_transit_router_vpn_attachment.transit_router_id
    ).apply(lambda resolved_outputs: alicloud.cen.get_transit_router_vpn_attachments_output(ids=[resolved_outputs['id']],
        cen_id=resolved_outputs['cen_id'],
        transit_router_id=resolved_outputs['transit_router_id']))

    pulumi.export("cenTransitRouterVpnAttachmentId0", ids.attachments[0].id)
    ```


    :param _builtins.str cen_id: The ID of the Cloud Enterprise Network (CEN) instance.
    :param Sequence[_builtins.str] ids: A list of Transit Router Vpn Attachment IDs.
    :param _builtins.str name_regex: A regex string to filter results by Transit Router Vpn Attachment name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The Status of Transit Router Vpn Attachment. Valid values: `Attached`, `Attaching`, `Detaching`.
    :param Mapping[str, _builtins.str] tags: The tag of the resource.
    :param _builtins.str transit_router_attachment_id: The ID of the VPN attachment.
    :param _builtins.str transit_router_id: The ID of the transit router.
    """
    __args__ = dict()
    __args__['cenId'] = cen_id
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['transitRouterAttachmentId'] = transit_router_attachment_id
    __args__['transitRouterId'] = transit_router_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cen/getTransitRouterVpnAttachments:getTransitRouterVpnAttachments', __args__, opts=opts, typ=GetTransitRouterVpnAttachmentsResult)
    return __ret__.apply(lambda __response__: GetTransitRouterVpnAttachmentsResult(
        attachments=pulumi.get(__response__, 'attachments'),
        cen_id=pulumi.get(__response__, 'cen_id'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        transit_router_attachment_id=pulumi.get(__response__, 'transit_router_attachment_id'),
        transit_router_id=pulumi.get(__response__, 'transit_router_id')))
