# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetInstancesResult',
    'AwaitableGetInstancesResult',
    'get_instances',
    'get_instances_output',
]

@pulumi.output_type
class GetInstancesResult:
    """
    A collection of values returned by getInstances.
    """
    def __init__(__self__, id=None, instances=None, output_file=None, payment_type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if payment_type and not isinstance(payment_type, str):
            raise TypeError("Expected argument 'payment_type' to be a str")
        pulumi.set(__self__, "payment_type", payment_type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetInstancesInstanceResult']:
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "payment_type")


class AwaitableGetInstancesResult(GetInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstancesResult(
            id=self.id,
            instances=self.instances,
            output_file=self.output_file,
            payment_type=self.payment_type)


def get_instances(output_file: Optional[_builtins.str] = None,
                  payment_type: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstancesResult:
    """
    This data source provides the Cloud Firewall Instances of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.139.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.cloudfirewall.get_instances()
    pulumi.export("cloudFirewallInstanceId1", ids.instances[0].id)
    ```


    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str payment_type: The payment type of the cloud firewall instance. Valid values: `PayAsYouGo`,`Subscription`.
    """
    __args__ = dict()
    __args__['outputFile'] = output_file
    __args__['paymentType'] = payment_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cloudfirewall/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult).value

    return AwaitableGetInstancesResult(
        id=pulumi.get(__ret__, 'id'),
        instances=pulumi.get(__ret__, 'instances'),
        output_file=pulumi.get(__ret__, 'output_file'),
        payment_type=pulumi.get(__ret__, 'payment_type'))
def get_instances_output(output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         payment_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstancesResult]:
    """
    This data source provides the Cloud Firewall Instances of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.139.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.cloudfirewall.get_instances()
    pulumi.export("cloudFirewallInstanceId1", ids.instances[0].id)
    ```


    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str payment_type: The payment type of the cloud firewall instance. Valid values: `PayAsYouGo`,`Subscription`.
    """
    __args__ = dict()
    __args__['outputFile'] = output_file
    __args__['paymentType'] = payment_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cloudfirewall/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult)
    return __ret__.apply(lambda __response__: GetInstancesResult(
        id=pulumi.get(__response__, 'id'),
        instances=pulumi.get(__response__, 'instances'),
        output_file=pulumi.get(__response__, 'output_file'),
        payment_type=pulumi.get(__response__, 'payment_type')))
