# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'NestServiceInstanceCommodity',
    'NestServiceInstanceOperationMetadata',
    'GetNestServiceInstancesFilterResult',
    'GetNestServiceInstancesServiceInstanceResult',
    'GetNestServiceInstancesServiceInstanceServiceResult',
    'GetNestServiceInstancesServiceInstanceServiceServiceInfoResult',
]

@pulumi.output_type
class NestServiceInstanceCommodity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "payPeriod":
            suggest = "pay_period"
        elif key == "payPeriodUnit":
            suggest = "pay_period_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NestServiceInstanceCommodity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NestServiceInstanceCommodity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NestServiceInstanceCommodity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pay_period: Optional[_builtins.int] = None,
                 pay_period_unit: Optional[_builtins.str] = None):
        """
        :param _builtins.int pay_period: Length of purchase.
        :param _builtins.str pay_period_unit: Duration unit. Valid values: `Year`, `Month`, `Day`.
        """
        if pay_period is not None:
            pulumi.set(__self__, "pay_period", pay_period)
        if pay_period_unit is not None:
            pulumi.set(__self__, "pay_period_unit", pay_period_unit)

    @_builtins.property
    @pulumi.getter(name="payPeriod")
    def pay_period(self) -> Optional[_builtins.int]:
        """
        Length of purchase.
        """
        return pulumi.get(self, "pay_period")

    @_builtins.property
    @pulumi.getter(name="payPeriodUnit")
    def pay_period_unit(self) -> Optional[_builtins.str]:
        """
        Duration unit. Valid values: `Year`, `Month`, `Day`.
        """
        return pulumi.get(self, "pay_period_unit")


@pulumi.output_type
class NestServiceInstanceOperationMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatedServiceInstanceId":
            suggest = "operated_service_instance_id"
        elif key == "operationEndTime":
            suggest = "operation_end_time"
        elif key == "operationStartTime":
            suggest = "operation_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NestServiceInstanceOperationMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NestServiceInstanceOperationMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NestServiceInstanceOperationMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operated_service_instance_id: Optional[_builtins.str] = None,
                 operation_end_time: Optional[_builtins.str] = None,
                 operation_start_time: Optional[_builtins.str] = None,
                 resources: Optional[_builtins.str] = None):
        """
        :param _builtins.str operated_service_instance_id: The ID of the imported service instance.
        :param _builtins.str operation_end_time: The end time of O&M.
        :param _builtins.str operation_start_time: The start time of O&M.
        :param _builtins.str resources: The list of imported resources.
        """
        if operated_service_instance_id is not None:
            pulumi.set(__self__, "operated_service_instance_id", operated_service_instance_id)
        if operation_end_time is not None:
            pulumi.set(__self__, "operation_end_time", operation_end_time)
        if operation_start_time is not None:
            pulumi.set(__self__, "operation_start_time", operation_start_time)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @_builtins.property
    @pulumi.getter(name="operatedServiceInstanceId")
    def operated_service_instance_id(self) -> Optional[_builtins.str]:
        """
        The ID of the imported service instance.
        """
        return pulumi.get(self, "operated_service_instance_id")

    @_builtins.property
    @pulumi.getter(name="operationEndTime")
    def operation_end_time(self) -> Optional[_builtins.str]:
        """
        The end time of O&M.
        """
        return pulumi.get(self, "operation_end_time")

    @_builtins.property
    @pulumi.getter(name="operationStartTime")
    def operation_start_time(self) -> Optional[_builtins.str]:
        """
        The start time of O&M.
        """
        return pulumi.get(self, "operation_start_time")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional[_builtins.str]:
        """
        The list of imported resources.
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class GetNestServiceInstancesFilterResult(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 values: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str name: The name of the service.
        :param Sequence[_builtins.str] values: Set of values that are accepted for the given field.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[Sequence[_builtins.str]]:
        """
        Set of values that are accepted for the given field.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetNestServiceInstancesServiceInstanceResult(dict):
    def __init__(__self__, *,
                 enable_instance_ops: _builtins.bool,
                 id: _builtins.str,
                 operated_service_instance_id: _builtins.str,
                 operation_end_time: _builtins.str,
                 operation_start_time: _builtins.str,
                 parameters: _builtins.str,
                 resources: _builtins.str,
                 service_instance_id: _builtins.str,
                 service_instance_name: _builtins.str,
                 services: Sequence['outputs.GetNestServiceInstancesServiceInstanceServiceResult'],
                 source: _builtins.str,
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 template_name: _builtins.str):
        """
        :param _builtins.bool enable_instance_ops: Whether the service instance has the O&M function.
        :param _builtins.str id: The ID of the Service Instance.
        :param _builtins.str operated_service_instance_id: The ID of the imported service instance.
        :param _builtins.str operation_end_time: The end time of O&M.
        :param _builtins.str operation_start_time: The start time of O&M.
        :param _builtins.str parameters: The parameters entered by the deployment service instance.
        :param _builtins.str resources: The list of imported resources.
        :param _builtins.str service_instance_id: The ID of the Service Instance.
        :param _builtins.str service_instance_name: The name of the Service Instance.
        :param Sequence['GetNestServiceInstancesServiceInstanceServiceArgs'] services: Service details.
        :param _builtins.str source: The source of the Service Instance.
        :param _builtins.str status: The status of the Service Instance. Valid Values: `Created`, `Deploying`, `DeployedFailed`, `Deployed`, `Upgrading`, `Deleting`, `Deleted`, `DeletedFailed`.
        :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
        :param _builtins.str template_name: The name of the template.
        """
        pulumi.set(__self__, "enable_instance_ops", enable_instance_ops)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "operated_service_instance_id", operated_service_instance_id)
        pulumi.set(__self__, "operation_end_time", operation_end_time)
        pulumi.set(__self__, "operation_start_time", operation_start_time)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "service_instance_id", service_instance_id)
        pulumi.set(__self__, "service_instance_name", service_instance_name)
        pulumi.set(__self__, "services", services)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "template_name", template_name)

    @_builtins.property
    @pulumi.getter(name="enableInstanceOps")
    def enable_instance_ops(self) -> _builtins.bool:
        """
        Whether the service instance has the O&M function.
        """
        return pulumi.get(self, "enable_instance_ops")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Service Instance.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="operatedServiceInstanceId")
    def operated_service_instance_id(self) -> _builtins.str:
        """
        The ID of the imported service instance.
        """
        return pulumi.get(self, "operated_service_instance_id")

    @_builtins.property
    @pulumi.getter(name="operationEndTime")
    def operation_end_time(self) -> _builtins.str:
        """
        The end time of O&M.
        """
        return pulumi.get(self, "operation_end_time")

    @_builtins.property
    @pulumi.getter(name="operationStartTime")
    def operation_start_time(self) -> _builtins.str:
        """
        The start time of O&M.
        """
        return pulumi.get(self, "operation_start_time")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> _builtins.str:
        """
        The parameters entered by the deployment service instance.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> _builtins.str:
        """
        The list of imported resources.
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter(name="serviceInstanceId")
    def service_instance_id(self) -> _builtins.str:
        """
        The ID of the Service Instance.
        """
        return pulumi.get(self, "service_instance_id")

    @_builtins.property
    @pulumi.getter(name="serviceInstanceName")
    def service_instance_name(self) -> _builtins.str:
        """
        The name of the Service Instance.
        """
        return pulumi.get(self, "service_instance_name")

    @_builtins.property
    @pulumi.getter
    def services(self) -> Sequence['outputs.GetNestServiceInstancesServiceInstanceServiceResult']:
        """
        Service details.
        """
        return pulumi.get(self, "services")

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        """
        The source of the Service Instance.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the Service Instance. Valid Values: `Created`, `Deploying`, `DeployedFailed`, `Deployed`, `Upgrading`, `Deleting`, `Deleted`, `DeletedFailed`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="templateName")
    def template_name(self) -> _builtins.str:
        """
        The name of the template.
        """
        return pulumi.get(self, "template_name")


@pulumi.output_type
class GetNestServiceInstancesServiceInstanceServiceResult(dict):
    def __init__(__self__, *,
                 deploy_type: _builtins.str,
                 publish_time: _builtins.str,
                 service_id: _builtins.str,
                 service_infos: Sequence['outputs.GetNestServiceInstancesServiceInstanceServiceServiceInfoResult'],
                 service_type: _builtins.str,
                 status: _builtins.str,
                 supplier_name: _builtins.str,
                 supplier_url: _builtins.str,
                 version: _builtins.str,
                 version_name: _builtins.str):
        """
        :param _builtins.str deploy_type: The type of the deployment.
        :param _builtins.str publish_time: The time of publish.
        :param _builtins.str service_id: The id of the service.
        :param Sequence['GetNestServiceInstancesServiceInstanceServiceServiceInfoArgs'] service_infos: Service information.
        :param _builtins.str service_type: The type of the service.
        :param _builtins.str status: The status of the Service Instance. Valid Values: `Created`, `Deploying`, `DeployedFailed`, `Deployed`, `Upgrading`, `Deleting`, `Deleted`, `DeletedFailed`.
        :param _builtins.str supplier_name: The name of the supplier.
        :param _builtins.str supplier_url: The url of the supplier.
        :param _builtins.str version: The version of the service.
        :param _builtins.str version_name: The version name of the service.
        """
        pulumi.set(__self__, "deploy_type", deploy_type)
        pulumi.set(__self__, "publish_time", publish_time)
        pulumi.set(__self__, "service_id", service_id)
        pulumi.set(__self__, "service_infos", service_infos)
        pulumi.set(__self__, "service_type", service_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "supplier_name", supplier_name)
        pulumi.set(__self__, "supplier_url", supplier_url)
        pulumi.set(__self__, "version", version)
        pulumi.set(__self__, "version_name", version_name)

    @_builtins.property
    @pulumi.getter(name="deployType")
    def deploy_type(self) -> _builtins.str:
        """
        The type of the deployment.
        """
        return pulumi.get(self, "deploy_type")

    @_builtins.property
    @pulumi.getter(name="publishTime")
    def publish_time(self) -> _builtins.str:
        """
        The time of publish.
        """
        return pulumi.get(self, "publish_time")

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> _builtins.str:
        """
        The id of the service.
        """
        return pulumi.get(self, "service_id")

    @_builtins.property
    @pulumi.getter(name="serviceInfos")
    def service_infos(self) -> Sequence['outputs.GetNestServiceInstancesServiceInstanceServiceServiceInfoResult']:
        """
        Service information.
        """
        return pulumi.get(self, "service_infos")

    @_builtins.property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> _builtins.str:
        """
        The type of the service.
        """
        return pulumi.get(self, "service_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the Service Instance. Valid Values: `Created`, `Deploying`, `DeployedFailed`, `Deployed`, `Upgrading`, `Deleting`, `Deleted`, `DeletedFailed`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="supplierName")
    def supplier_name(self) -> _builtins.str:
        """
        The name of the supplier.
        """
        return pulumi.get(self, "supplier_name")

    @_builtins.property
    @pulumi.getter(name="supplierUrl")
    def supplier_url(self) -> _builtins.str:
        """
        The url of the supplier.
        """
        return pulumi.get(self, "supplier_url")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of the service.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="versionName")
    def version_name(self) -> _builtins.str:
        """
        The version name of the service.
        """
        return pulumi.get(self, "version_name")


@pulumi.output_type
class GetNestServiceInstancesServiceInstanceServiceServiceInfoResult(dict):
    def __init__(__self__, *,
                 image: _builtins.str,
                 locale: _builtins.str,
                 name: _builtins.str,
                 short_description: _builtins.str):
        """
        :param _builtins.str image: The image of the service.
        :param _builtins.str locale: The locale of the service.
        :param _builtins.str name: The name of the service.
        :param _builtins.str short_description: The short description of the service.
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "locale", locale)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "short_description", short_description)

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        The image of the service.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter
    def locale(self) -> _builtins.str:
        """
        The locale of the service.
        """
        return pulumi.get(self, "locale")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="shortDescription")
    def short_description(self) -> _builtins.str:
        """
        The short description of the service.
        """
        return pulumi.get(self, "short_description")


