# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetKubernetesAddonMetadataResult',
    'AwaitableGetKubernetesAddonMetadataResult',
    'get_kubernetes_addon_metadata',
    'get_kubernetes_addon_metadata_output',
]

@pulumi.output_type
class GetKubernetesAddonMetadataResult:
    """
    A collection of values returned by getKubernetesAddonMetadata.
    """
    def __init__(__self__, cluster_id=None, config_schema=None, id=None, name=None, version=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if config_schema and not isinstance(config_schema, str):
            raise TypeError("Expected argument 'config_schema' to be a str")
        pulumi.set(__self__, "config_schema", config_schema)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="configSchema")
    def config_schema(self) -> _builtins.str:
        """
        The addon configuration that can be customized. The returned format is the standard json schema. If return empty, it means that the addon does not support custom configuration yet.
        """
        return pulumi.get(self, "config_schema")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        return pulumi.get(self, "version")


class AwaitableGetKubernetesAddonMetadataResult(GetKubernetesAddonMetadataResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKubernetesAddonMetadataResult(
            cluster_id=self.cluster_id,
            config_schema=self.config_schema,
            id=self.id,
            name=self.name,
            version=self.version)


def get_kubernetes_addon_metadata(cluster_id: Optional[_builtins.str] = None,
                                  name: Optional[_builtins.str] = None,
                                  version: Optional[_builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKubernetesAddonMetadataResult:
    """
    This data source provides metadata of kubernetes cluster addons.

    > **NOTE:** Available in 1.166.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud
    import pulumi_std as std

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.get_zones(available_resource_creation="VSwitch")
    default_network = alicloud.vpc.Network("default",
        vpc_name=name,
        cidr_block="10.4.0.0/16")
    default_switch = alicloud.vpc.Switch("default",
        vswitch_name=name,
        cidr_block="10.4.0.0/24",
        vpc_id=default_network.id,
        zone_id=default.zones[0].id)
    default_managed_kubernetes = alicloud.cs.ManagedKubernetes("default",
        name_prefix=name,
        cluster_spec="ack.pro.small",
        worker_vswitch_ids=[default_switch.id],
        new_nat_gateway=False,
        pod_cidr=std.cidrsubnet(input="10.0.0.0/8",
            newbits=8,
            netnum=36).result,
        service_cidr=std.cidrsubnet(input="172.16.0.0/16",
            newbits=4,
            netnum=7).result,
        slb_internet_enabled=True)
    cluster_id = default_managed_kubernetes.id
    default_get_kubernetes_addon_metadata = alicloud.cs.get_kubernetes_addon_metadata_output(cluster_id=cluster_id,
        name="nginx-ingress-controller",
        version="v1.1.2-aliyun.2")
    pulumi.export("addonConfigSchema", default_get_kubernetes_addon_metadata.config_schema)
    ```


    :param _builtins.str cluster_id: The id of kubernetes cluster.
    :param _builtins.str name: The name of the cluster addon. You can get a list of available addons that the cluster can install by using data source `cs_get_kubernetes_addons`.
    :param _builtins.str version: The version of the cluster addon.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cs/getKubernetesAddonMetadata:getKubernetesAddonMetadata', __args__, opts=opts, typ=GetKubernetesAddonMetadataResult).value

    return AwaitableGetKubernetesAddonMetadataResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        config_schema=pulumi.get(__ret__, 'config_schema'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        version=pulumi.get(__ret__, 'version'))
def get_kubernetes_addon_metadata_output(cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                                         name: Optional[pulumi.Input[_builtins.str]] = None,
                                         version: Optional[pulumi.Input[_builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKubernetesAddonMetadataResult]:
    """
    This data source provides metadata of kubernetes cluster addons.

    > **NOTE:** Available in 1.166.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud
    import pulumi_std as std

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.get_zones(available_resource_creation="VSwitch")
    default_network = alicloud.vpc.Network("default",
        vpc_name=name,
        cidr_block="10.4.0.0/16")
    default_switch = alicloud.vpc.Switch("default",
        vswitch_name=name,
        cidr_block="10.4.0.0/24",
        vpc_id=default_network.id,
        zone_id=default.zones[0].id)
    default_managed_kubernetes = alicloud.cs.ManagedKubernetes("default",
        name_prefix=name,
        cluster_spec="ack.pro.small",
        worker_vswitch_ids=[default_switch.id],
        new_nat_gateway=False,
        pod_cidr=std.cidrsubnet(input="10.0.0.0/8",
            newbits=8,
            netnum=36).result,
        service_cidr=std.cidrsubnet(input="172.16.0.0/16",
            newbits=4,
            netnum=7).result,
        slb_internet_enabled=True)
    cluster_id = default_managed_kubernetes.id
    default_get_kubernetes_addon_metadata = alicloud.cs.get_kubernetes_addon_metadata_output(cluster_id=cluster_id,
        name="nginx-ingress-controller",
        version="v1.1.2-aliyun.2")
    pulumi.export("addonConfigSchema", default_get_kubernetes_addon_metadata.config_schema)
    ```


    :param _builtins.str cluster_id: The id of kubernetes cluster.
    :param _builtins.str name: The name of the cluster addon. You can get a list of available addons that the cluster can install by using data source `cs_get_kubernetes_addons`.
    :param _builtins.str version: The version of the cluster addon.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    __args__['version'] = version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cs/getKubernetesAddonMetadata:getKubernetesAddonMetadata', __args__, opts=opts, typ=GetKubernetesAddonMetadataResult)
    return __ret__.apply(lambda __response__: GetKubernetesAddonMetadataResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        config_schema=pulumi.get(__response__, 'config_schema'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        version=pulumi.get(__response__, 'version')))
