# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetKubernetesNodePoolsResult',
    'AwaitableGetKubernetesNodePoolsResult',
    'get_kubernetes_node_pools',
    'get_kubernetes_node_pools_output',
]

@pulumi.output_type
class GetKubernetesNodePoolsResult:
    """
    A collection of values returned by getKubernetesNodePools.
    """
    def __init__(__self__, cluster_id=None, id=None, ids=None, node_pool_name=None, nodepools=None, output_file=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if node_pool_name and not isinstance(node_pool_name, str):
            raise TypeError("Expected argument 'node_pool_name' to be a str")
        pulumi.set(__self__, "node_pool_name", node_pool_name)
        if nodepools and not isinstance(nodepools, list):
            raise TypeError("Expected argument 'nodepools' to be a list")
        pulumi.set(__self__, "nodepools", nodepools)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Nodepool IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nodePoolName")
    def node_pool_name(self) -> Optional[_builtins.str]:
        """
        The name of node pool.
        """
        return pulumi.get(self, "node_pool_name")

    @_builtins.property
    @pulumi.getter
    def nodepools(self) -> Sequence['outputs.GetKubernetesNodePoolsNodepoolResult']:
        """
        A list of Nodepool Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "nodepools")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")


class AwaitableGetKubernetesNodePoolsResult(GetKubernetesNodePoolsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKubernetesNodePoolsResult(
            cluster_id=self.cluster_id,
            id=self.id,
            ids=self.ids,
            node_pool_name=self.node_pool_name,
            nodepools=self.nodepools,
            output_file=self.output_file)


def get_kubernetes_node_pools(cluster_id: Optional[_builtins.str] = None,
                              ids: Optional[Sequence[_builtins.str]] = None,
                              node_pool_name: Optional[_builtins.str] = None,
                              output_file: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKubernetesNodePoolsResult:
    """
    This data source provides Ack Nodepool available to the user.[What is Nodepool](https://next.api.alibabacloud.com/document/CS/2015-12-15/CreateClusterNodePool)

    > **NOTE:** Available since v1.246.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud
    import pulumi_std as std

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    enhanced = alicloud.vpc.get_enhanced_nat_available_zones()
    cloud_efficiency = alicloud.ecs.get_instance_types(availability_zone=enhanced.zones[0].zone_id,
        cpu_core_count=4,
        memory_size=8,
        kubernetes_node_role="Worker",
        system_disk_category="cloud_efficiency")
    default_network = alicloud.vpc.Network("default",
        vpc_name=name,
        cidr_block="10.4.0.0/16")
    default_switch = alicloud.vpc.Switch("default",
        vswitch_name=name,
        cidr_block="10.4.0.0/24",
        vpc_id=default_network.id,
        zone_id=enhanced.zones[0].zone_id)
    default_managed_kubernetes = alicloud.cs.ManagedKubernetes("default",
        name_prefix=name,
        cluster_spec="ack.pro.small",
        vswitch_ids=[default_switch.id],
        new_nat_gateway=True,
        pod_cidr=std.cidrsubnet(input="10.0.0.0/8",
            newbits=8,
            netnum=36).result,
        service_cidr=std.cidrsubnet(input="172.16.0.0/16",
            newbits=4,
            netnum=7).result,
        slb_internet_enabled=True,
        enable_rrsa=True)
    default_key_pair = alicloud.ecs.KeyPair("default", key_pair_name=name)
    default_node_pool = alicloud.cs.NodePool("default",
        node_pool_name="spot_auto_scaling",
        cluster_id=default_managed_kubernetes.id,
        vswitch_ids=[default_switch.id],
        instance_types=[cloud_efficiency.instance_types[0].id],
        system_disk_category="cloud_efficiency",
        system_disk_size=40,
        key_name=default_key_pair.key_pair_name,
        scaling_config={
            "min_size": 1,
            "max_size": 10,
            "type": "spot",
        },
        spot_strategy="SpotWithPriceLimit",
        spot_price_limits=[{
            "instance_type": cloud_efficiency.instance_types[0].id,
            "price_limit": "0.70",
        }])
    default = alicloud.cs.get_kubernetes_node_pools_output(ids=[default_node_pool.node_pool_id],
        cluster_id=default_managed_kubernetes.id)
    pulumi.export("alicloudCsKubernetesNodePoolExampleId", default.nodepools[0].node_pool_id)
    ```


    :param _builtins.str cluster_id: The id of kubernetes cluster.
    :param Sequence[_builtins.str] ids: A list of Nodepool IDs.
    :param _builtins.str node_pool_name: The name of node pool.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['ids'] = ids
    __args__['nodePoolName'] = node_pool_name
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cs/getKubernetesNodePools:getKubernetesNodePools', __args__, opts=opts, typ=GetKubernetesNodePoolsResult).value

    return AwaitableGetKubernetesNodePoolsResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        node_pool_name=pulumi.get(__ret__, 'node_pool_name'),
        nodepools=pulumi.get(__ret__, 'nodepools'),
        output_file=pulumi.get(__ret__, 'output_file'))
def get_kubernetes_node_pools_output(cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                     node_pool_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKubernetesNodePoolsResult]:
    """
    This data source provides Ack Nodepool available to the user.[What is Nodepool](https://next.api.alibabacloud.com/document/CS/2015-12-15/CreateClusterNodePool)

    > **NOTE:** Available since v1.246.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud
    import pulumi_std as std

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    enhanced = alicloud.vpc.get_enhanced_nat_available_zones()
    cloud_efficiency = alicloud.ecs.get_instance_types(availability_zone=enhanced.zones[0].zone_id,
        cpu_core_count=4,
        memory_size=8,
        kubernetes_node_role="Worker",
        system_disk_category="cloud_efficiency")
    default_network = alicloud.vpc.Network("default",
        vpc_name=name,
        cidr_block="10.4.0.0/16")
    default_switch = alicloud.vpc.Switch("default",
        vswitch_name=name,
        cidr_block="10.4.0.0/24",
        vpc_id=default_network.id,
        zone_id=enhanced.zones[0].zone_id)
    default_managed_kubernetes = alicloud.cs.ManagedKubernetes("default",
        name_prefix=name,
        cluster_spec="ack.pro.small",
        vswitch_ids=[default_switch.id],
        new_nat_gateway=True,
        pod_cidr=std.cidrsubnet(input="10.0.0.0/8",
            newbits=8,
            netnum=36).result,
        service_cidr=std.cidrsubnet(input="172.16.0.0/16",
            newbits=4,
            netnum=7).result,
        slb_internet_enabled=True,
        enable_rrsa=True)
    default_key_pair = alicloud.ecs.KeyPair("default", key_pair_name=name)
    default_node_pool = alicloud.cs.NodePool("default",
        node_pool_name="spot_auto_scaling",
        cluster_id=default_managed_kubernetes.id,
        vswitch_ids=[default_switch.id],
        instance_types=[cloud_efficiency.instance_types[0].id],
        system_disk_category="cloud_efficiency",
        system_disk_size=40,
        key_name=default_key_pair.key_pair_name,
        scaling_config={
            "min_size": 1,
            "max_size": 10,
            "type": "spot",
        },
        spot_strategy="SpotWithPriceLimit",
        spot_price_limits=[{
            "instance_type": cloud_efficiency.instance_types[0].id,
            "price_limit": "0.70",
        }])
    default = alicloud.cs.get_kubernetes_node_pools_output(ids=[default_node_pool.node_pool_id],
        cluster_id=default_managed_kubernetes.id)
    pulumi.export("alicloudCsKubernetesNodePoolExampleId", default.nodepools[0].node_pool_id)
    ```


    :param _builtins.str cluster_id: The id of kubernetes cluster.
    :param Sequence[_builtins.str] ids: A list of Nodepool IDs.
    :param _builtins.str node_pool_name: The name of node pool.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['ids'] = ids
    __args__['nodePoolName'] = node_pool_name
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cs/getKubernetesNodePools:getKubernetesNodePools', __args__, opts=opts, typ=GetKubernetesNodePoolsResult)
    return __ret__.apply(lambda __response__: GetKubernetesNodePoolsResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        node_pool_name=pulumi.get(__response__, 'node_pool_name'),
        nodepools=pulumi.get(__response__, 'nodepools'),
        output_file=pulumi.get(__response__, 'output_file')))
