# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetKubernetesVersionResult',
    'AwaitableGetKubernetesVersionResult',
    'get_kubernetes_version',
    'get_kubernetes_version_output',
]

@pulumi.output_type
class GetKubernetesVersionResult:
    """
    A collection of values returned by getKubernetesVersion.
    """
    def __init__(__self__, cluster_type=None, id=None, kubernetes_version=None, metadatas=None, profile=None):
        if cluster_type and not isinstance(cluster_type, str):
            raise TypeError("Expected argument 'cluster_type' to be a str")
        pulumi.set(__self__, "cluster_type", cluster_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kubernetes_version and not isinstance(kubernetes_version, str):
            raise TypeError("Expected argument 'kubernetes_version' to be a str")
        pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if metadatas and not isinstance(metadatas, list):
            raise TypeError("Expected argument 'metadatas' to be a list")
        pulumi.set(__self__, "metadatas", metadatas)
        if profile and not isinstance(profile, str):
            raise TypeError("Expected argument 'profile' to be a str")
        pulumi.set(__self__, "profile", profile)

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> _builtins.str:
        return pulumi.get(self, "cluster_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "kubernetes_version")

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Sequence['outputs.GetKubernetesVersionMetadataResult']:
        """
        A list of metadata of kubernetes version.
        """
        return pulumi.get(self, "metadatas")

    @_builtins.property
    @pulumi.getter
    def profile(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "profile")


class AwaitableGetKubernetesVersionResult(GetKubernetesVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKubernetesVersionResult(
            cluster_type=self.cluster_type,
            id=self.id,
            kubernetes_version=self.kubernetes_version,
            metadatas=self.metadatas,
            profile=self.profile)


def get_kubernetes_version(cluster_type: Optional[_builtins.str] = None,
                           kubernetes_version: Optional[_builtins.str] = None,
                           profile: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKubernetesVersionResult:
    """
    This data source provides the details of the Kubernetes version supported by ACK.

    > **NOTE:** Available since v1.170.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    # Query the managed kubernetes cluster metadata of version 1.22.3-aliyun.1 in the region specified by the client.
    default = alicloud.cs.get_kubernetes_version(cluster_type="ManagedKubernetes",
        kubernetes_version="1.22.3-aliyun.1",
        profile="Default")
    pulumi.export("metadata", default.metadatas)
    ```

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    # Query the kubernetes cluster metadata of version 1.22.3-aliyun.1 in the region specified by the client.
    default = alicloud.cs.get_kubernetes_version(cluster_type="Kubernetes",
        kubernetes_version="1.22.3-aliyun.1",
        profile="Default")
    pulumi.export("metadata", default.metadatas)
    ```

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    # Query the serverless kubernetes cluster metadata of version 1.22.3-aliyun.1 in the region specified by the client.
    default = alicloud.cs.get_kubernetes_version(cluster_type="ManagedKubernetes",
        kubernetes_version="1.22.3-aliyun.1",
        profile="Serverless")
    pulumi.export("metadata", default.metadatas)
    ```

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    # Query the edge kubernetes cluster metadata of version 1.20.11-aliyunedge.1 in the region specified by the client.
    default = alicloud.cs.get_kubernetes_version(cluster_type="ManagedKubernetes",
        kubernetes_version="1.20.11-aliyunedge.1",
        profile="Edge")
    pulumi.export("metadata", default.metadatas)
    ```


    :param _builtins.str cluster_type: The type of cluster. Its valid value are `Kubernetes` and `ManagedKubernetes`.
    :param _builtins.str kubernetes_version: The ACK released kubernetes version.
    :param _builtins.str profile: The profile of cluster. Its valid value are `Default`, `Serverless`, `Edge` and `Acs`.
    """
    __args__ = dict()
    __args__['clusterType'] = cluster_type
    __args__['kubernetesVersion'] = kubernetes_version
    __args__['profile'] = profile
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cs/getKubernetesVersion:getKubernetesVersion', __args__, opts=opts, typ=GetKubernetesVersionResult).value

    return AwaitableGetKubernetesVersionResult(
        cluster_type=pulumi.get(__ret__, 'cluster_type'),
        id=pulumi.get(__ret__, 'id'),
        kubernetes_version=pulumi.get(__ret__, 'kubernetes_version'),
        metadatas=pulumi.get(__ret__, 'metadatas'),
        profile=pulumi.get(__ret__, 'profile'))
def get_kubernetes_version_output(cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                                  kubernetes_version: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  profile: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKubernetesVersionResult]:
    """
    This data source provides the details of the Kubernetes version supported by ACK.

    > **NOTE:** Available since v1.170.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    # Query the managed kubernetes cluster metadata of version 1.22.3-aliyun.1 in the region specified by the client.
    default = alicloud.cs.get_kubernetes_version(cluster_type="ManagedKubernetes",
        kubernetes_version="1.22.3-aliyun.1",
        profile="Default")
    pulumi.export("metadata", default.metadatas)
    ```

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    # Query the kubernetes cluster metadata of version 1.22.3-aliyun.1 in the region specified by the client.
    default = alicloud.cs.get_kubernetes_version(cluster_type="Kubernetes",
        kubernetes_version="1.22.3-aliyun.1",
        profile="Default")
    pulumi.export("metadata", default.metadatas)
    ```

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    # Query the serverless kubernetes cluster metadata of version 1.22.3-aliyun.1 in the region specified by the client.
    default = alicloud.cs.get_kubernetes_version(cluster_type="ManagedKubernetes",
        kubernetes_version="1.22.3-aliyun.1",
        profile="Serverless")
    pulumi.export("metadata", default.metadatas)
    ```

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    # Query the edge kubernetes cluster metadata of version 1.20.11-aliyunedge.1 in the region specified by the client.
    default = alicloud.cs.get_kubernetes_version(cluster_type="ManagedKubernetes",
        kubernetes_version="1.20.11-aliyunedge.1",
        profile="Edge")
    pulumi.export("metadata", default.metadatas)
    ```


    :param _builtins.str cluster_type: The type of cluster. Its valid value are `Kubernetes` and `ManagedKubernetes`.
    :param _builtins.str kubernetes_version: The ACK released kubernetes version.
    :param _builtins.str profile: The profile of cluster. Its valid value are `Default`, `Serverless`, `Edge` and `Acs`.
    """
    __args__ = dict()
    __args__['clusterType'] = cluster_type
    __args__['kubernetesVersion'] = kubernetes_version
    __args__['profile'] = profile
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cs/getKubernetesVersion:getKubernetesVersion', __args__, opts=opts, typ=GetKubernetesVersionResult)
    return __ret__.apply(lambda __response__: GetKubernetesVersionResult(
        cluster_type=pulumi.get(__response__, 'cluster_type'),
        id=pulumi.get(__response__, 'id'),
        kubernetes_version=pulumi.get(__response__, 'kubernetes_version'),
        metadatas=pulumi.get(__response__, 'metadatas'),
        profile=pulumi.get(__response__, 'profile')))
