# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NodePoolArgs', 'NodePool']

@pulumi.input_type
class NodePoolArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 cis_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 compensate_with_on_demand: Optional[pulumi.Input[_builtins.bool]] = None,
                 cpu_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolDataDiskArgs']]]] = None,
                 deployment_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_size: Optional[pulumi.Input[_builtins.str]] = None,
                 eflo_node_group: Optional[pulumi.Input['NodePoolEfloNodeGroupArgs']] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 format_disk: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_type: Optional[pulumi.Input[_builtins.str]] = None,
                 install_cloud_monitor: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
                 keep_instance_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 kubelet_configuration: Optional[pulumi.Input['NodePoolKubeletConfigurationArgs']] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolLabelArgs']]]] = None,
                 login_as_non_root: Optional[pulumi.Input[_builtins.bool]] = None,
                 management: Optional[pulumi.Input['NodePoolManagementArgs']] = None,
                 multi_az_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 node_name_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 node_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_demand_base_capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 on_demand_percentage_above_base_capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 private_pool_options: Optional[pulumi.Input['NodePoolPrivatePoolOptionsArgs']] = None,
                 ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rds_instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rolling_policy: Optional[pulumi.Input['NodePoolRollingPolicyArgs']] = None,
                 runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_version: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_config: Optional[pulumi.Input['NodePoolScalingConfigArgs']] = None,
                 scaling_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_hardening_os: Optional[pulumi.Input[_builtins.bool]] = None,
                 soc_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 spot_instance_pools: Optional[pulumi.Input[_builtins.int]] = None,
                 spot_instance_remedy: Optional[pulumi.Input[_builtins.bool]] = None,
                 spot_price_limits: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolSpotPriceLimitArgs']]]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_bursting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_disk_categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 system_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_encrypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_disk_kms_key: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_provisioned_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_snapshot_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]]] = None,
                 tee_config: Optional[pulumi.Input['NodePoolTeeConfigArgs']] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 unschedulable: Optional[pulumi.Input[_builtins.bool]] = None,
                 update_nodes: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a NodePool resource.
        :param pulumi.Input[_builtins.str] cluster_id: The id of kubernetes cluster.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to enable automatic renewal for nodes in the node pool takes effect only when `instance_charge_type` is set to `PrePaid`. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.int] auto_renew_period: The automatic renewal period of nodes in the node pool takes effect only when you select Prepaid and Automatic Renewal, and is a required value. When `PeriodUnit = Month`, the value range is {1, 2, 3, 6, 12}. Default value: 1.
        :param pulumi.Input[_builtins.bool] cis_enabled: Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. Use `security_hardening_os` instead.
        :param pulumi.Input[_builtins.bool] compensate_with_on_demand: Specifies whether to automatically create pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created due to reasons such as cost or insufficient inventory. This parameter takes effect when you set `multi_az_policy` to `COST_OPTIMIZED`. Valid values: `true`: automatically creates pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created. `false`: does not create pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created.
        :param pulumi.Input[_builtins.str] cpu_policy: Node CPU management policies. Default value: `none`. When the cluster version is 1.12.6 or later, the following two policies are supported:
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolDataDiskArgs']]] data_disks: Configure the data disk of the node in the node pool. See `data_disks` below.
        :param pulumi.Input[_builtins.str] deployment_set_id: The deployment set of node pool. Specify the deploymentSet to ensure that the nodes in the node pool can be distributed on different physical machines.
        :param pulumi.Input[_builtins.str] desired_size: Number of expected nodes in the node pool.
        :param pulumi.Input['NodePoolEfloNodeGroupArgs'] eflo_node_group: Lingjun node pool configuration. See `eflo_node_group` below.
        :param pulumi.Input[_builtins.bool] force_delete: Whether to force deletion.
        :param pulumi.Input[_builtins.bool] format_disk: After you select this check box, if data disks have been attached to the specified ECS instances and the file system of the last data disk is uninitialized, the system automatically formats the last data disk to ext4 and mounts the data disk to /var/lib/docker and /var/lib/kubelet. The original data on the disk will be cleared. Make sure that you back up data in advance. If no data disk is mounted on the ECS instance, no new data disk will be purchased. Default is `false`.
        :param pulumi.Input[_builtins.str] image_id: The custom image ID. The system-provided image is used by default.
        :param pulumi.Input[_builtins.str] image_type: The operating system image type and the `platform` parameter can be selected from the following values:
               - `AliyunLinux` : Alinux2 image.
               - `AliyunLinux3` : Alinux3 image.
               - `AliyunLinux3Arm64` : Alinux3 mirror ARM version.
               - `AliyunLinuxUEFI` : Alinux2 Image UEFI version.
               - `CentOS` : CentOS image.
               - `Windows` : Windows image.
               - `WindowsCore` : WindowsCore image.
               - `ContainerOS` : container-optimized image.
               - `Ubuntu`: Ubuntu image.
               - `AliyunLinux3ContainerOptimized`: Alinux3 container-optimized image.
               - `Custom`: Custom image.
        :param pulumi.Input[_builtins.bool] install_cloud_monitor: Whether to install cloud monitoring on the ECS node. After installation, you can view the monitoring information of the created ECS instance in the cloud monitoring console and recommend enable it. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] instance_charge_type: Node payment type. Valid values: `PostPaid`, `PrePaid`, default is `PostPaid`. If value is `PrePaid`, the arguments `period`, `period_unit`, `auto_renew` and `auto_renew_period` are required.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_types: In the node instance specification list, you can select multiple instance specifications as alternatives. When each node is created, it will try to purchase from the first specification until it is created successfully. The final purchased instance specifications may vary with inventory changes.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instances: The instance list. Add existing nodes under the same cluster VPC to the node pool.
        :param pulumi.Input[_builtins.str] internet_charge_type: The billing method for network usage. Valid values `PayByBandwidth` and `PayByTraffic`. Conflict with `eip_internet_charge_type`, EIP and public network IP can only choose one.
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_out: The maximum bandwidth of the public IP address of the node. The unit is Mbps(Mega bit per second). The value range is:\\[1,100\\]
        :param pulumi.Input[_builtins.bool] keep_instance_name: Add an existing instance to the node pool, whether to keep the original instance name. It is recommended to set to `true`.
        :param pulumi.Input[_builtins.str] key_name: The name of the key pair. When the node pool is a managed node pool, only `key_name` is supported.
        :param pulumi.Input[_builtins.str] kms_encrypted_password: An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input['NodePoolKubeletConfigurationArgs'] kubelet_configuration: Kubelet configuration parameters for worker nodes. See `kubelet_configuration` below. More information in [Kubelet Configuration](https://kubernetes.io/docs/reference/config-api/kubelet-config.v1beta1/). See `kubelet_configuration` below.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolLabelArgs']]] labels: A List of Kubernetes labels to assign to the nodes . Only labels that are applied with the ACK API are managed by this argument. Detailed below. More information in [Labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/). See `labels` below.
        :param pulumi.Input[_builtins.bool] login_as_non_root: Whether the ECS instance is logged on as a ecs-user user. Valid value: `true` and `false`.
        :param pulumi.Input['NodePoolManagementArgs'] management: Managed node pool configuration. See `management` below.
        :param pulumi.Input[_builtins.str] multi_az_policy: The scaling policy for ECS instances in a multi-zone scaling group. Valid value: `PRIORITY`, `COST_OPTIMIZED` and `BALANCE`. `PRIORITY`: scales the capacity according to the virtual switches you define (VSwitchIds.N). When an ECS instance cannot be created in the zone where the higher-priority vSwitch is located, the next-priority vSwitch is automatically used to create an ECS instance. `COST_OPTIMIZED`: try to create by vCPU unit price from low to high. When the scaling configuration is configured with multiple instances of preemptible billing, preemptible instances are created first. You can continue to use the `CompensateWithOnDemand` parameter to specify whether to automatically try to create a preemptible instance by paying for it. It takes effect only when the scaling configuration has multi-instance specifications or preemptible instances. `BALANCE`: distributes ECS instances evenly among the multi-zone specified by the scaling group. If the zones become unbalanced due to insufficient inventory, you can use the API RebalanceInstances to balance resources.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.219.0. New field 'node_pool_name' instead.
        :param pulumi.Input[_builtins.int] node_count: The worker node number of the node pool. From version 1.111.0, `node_count` is not required.
        :param pulumi.Input[_builtins.str] node_name_mode: Each node name consists of a prefix, its private network IP, and a suffix, separated by commas. The input format is `customized,,ip,`.
               - The prefix and suffix can be composed of one or more parts separated by '.', each part can use lowercase letters, numbers and '-', and the beginning and end of the node name must be lowercase letters and numbers.
               - The node IP address is the complete private IP address of the node.
               - For example, if the string `customized,aliyun,ip,com` is passed in (where 'customized' and 'ip' are fixed strings, 'aliyun' is the prefix, and 'com' is the suffix), the name of the node is `aliyun192.168.xxx.xxxcom`.
        :param pulumi.Input[_builtins.str] node_pool_name: The name of node pool.
        :param pulumi.Input[_builtins.str] on_demand_base_capacity: The minimum number of pay-as-you-go instances that must be kept in the scaling group. Valid values: 0 to 1000. If the number of pay-as-you-go instances is less than the value of this parameter, Auto Scaling preferably creates pay-as-you-go instances.
        :param pulumi.Input[_builtins.str] on_demand_percentage_above_base_capacity: The percentage of pay-as-you-go instances among the extra instances that exceed the number specified by `on_demand_base_capacity`. Valid values: 0 to 100.
        :param pulumi.Input[_builtins.str] password: The password of ssh login. You have to specify one of `password` and `key_name` fields. The password rule is 8 to 30 characters and contains at least three items (upper and lower case letters, numbers, and special symbols).
        :param pulumi.Input[_builtins.int] period: Node payment period. Its valid value is one of {1, 2, 3, 6, 12}.
        :param pulumi.Input[_builtins.str] period_unit: Node payment period unit, valid value: `Month`. Default is `Month`.
        :param pulumi.Input[_builtins.str] platform: Operating system release, using `image_type` instead.
        :param pulumi.Input[_builtins.str] pre_user_data: Node pre custom data, base64-encoded, the script executed before the node is initialized.
        :param pulumi.Input['NodePoolPrivatePoolOptionsArgs'] private_pool_options: Private node pool configuration. See `private_pool_options` below.
        :param pulumi.Input[_builtins.str] ram_role_name: The name of the Worker RAM role.
               * If it is empty, the default Worker RAM role created in the cluster will be used.
               * If the specified RAM role is not empty, the specified RAM role must be a **Common Service role**, and its **trusted service** configuration must be **cloud server**. For more information, see [Create a common service role](https://help.aliyun.com/document_detail/116800.html). If the specified RAM role is not the default Worker RAM role created in the cluster, the role name cannot start with 'KubernetesMasterRole-'or 'KubernetesWorkerRole.
               
               > **NOTE:**  This parameter is only supported for ACK-managed clusters of 1.22 or later versions.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rds_instances: The list of RDS instances.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input['NodePoolRollingPolicyArgs'] rolling_policy: Rotary configuration. See `rolling_policy` below.
        :param pulumi.Input[_builtins.str] runtime_name: The runtime name of containers. If not set, the cluster runtime will be used as the node pool runtime. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm).
        :param pulumi.Input[_builtins.str] runtime_version: The runtime version of containers. If not set, the cluster runtime will be used as the node pool runtime.
        :param pulumi.Input['NodePoolScalingConfigArgs'] scaling_config: Automatic scaling configuration. See `scaling_config` below.
        :param pulumi.Input[_builtins.str] scaling_policy: Scaling group mode, default value: `release`. Valid values:
        :param pulumi.Input[_builtins.str] security_group_id: The security group ID of the node pool. This field has been replaced by `security_group_ids`, please use the `security_group_ids` field instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: Multiple security groups can be configured for a node pool. If both `security_group_ids` and `security_group_id` are configured, `security_group_ids` takes effect. This field cannot be modified.
        :param pulumi.Input[_builtins.bool] security_hardening_os: Alibaba Cloud OS security reinforcement. Default value: `false`. Value:
        :param pulumi.Input[_builtins.bool] soc_enabled: Whether enable worker node to support soc security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [SOC Reinforcement](https://help.aliyun.com/document_detail/196148.html).
               
               > **NOTE:**  It is forbidden to set both `security_hardening_os` and `soc_enabled` to `true` at the same time.
        :param pulumi.Input[_builtins.int] spot_instance_pools: The number of instance types that are available. Auto Scaling creates preemptible instances of multiple instance types that are available at the lowest cost. Valid values: 1 to 10.
        :param pulumi.Input[_builtins.bool] spot_instance_remedy: Specifies whether to supplement preemptible instances when the number of preemptible instances drops below the specified minimum number. If you set the value to true, Auto Scaling attempts to create a new preemptible instance when the system notifies that an existing preemptible instance is about to be reclaimed. Valid values: `true`: enables the supplementation of preemptible instances. `false`: disables the supplementation of preemptible instances.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolSpotPriceLimitArgs']]] spot_price_limits: The current single preemptible instance type market price range configuration. See `spot_price_limit` below.
        :param pulumi.Input[_builtins.str] spot_strategy: The preemptible instance type. Value:
               - `NoSpot` : Non-preemptible instance.
               - `SpotWithPriceLimit` : Set the upper limit of the preemptible instance price.
               - `SpotAsPriceGo` : The system automatically bids, following the actual price of the current market.
        :param pulumi.Input[_builtins.bool] system_disk_bursting_enabled: Specifies whether to enable the burst feature for system disks. Valid values:`true`: enables the burst feature. `false`: disables the burst feature. This parameter is supported only when `system_disk_category` is set to `cloud_auto`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] system_disk_categories: The multi-disk categories of the system disk. When a high-priority disk type cannot be used, Auto Scaling automatically tries to create a system disk with the next priority disk category. Valid values see `system_disk_category`.
        :param pulumi.Input[_builtins.str] system_disk_category: The category of the system disk for nodes. Default value: `cloud_efficiency`. Valid values:
        :param pulumi.Input[_builtins.str] system_disk_encrypt_algorithm: The encryption algorithm used by the system disk. Value range: aes-256.
        :param pulumi.Input[_builtins.bool] system_disk_encrypted: Whether to encrypt the system disk. Value range: `true`: encryption. `false`: Do not encrypt.
        :param pulumi.Input[_builtins.str] system_disk_kms_key: The ID of the KMS key used by the system disk.
        :param pulumi.Input[_builtins.str] system_disk_performance_level: The system disk performance of the node takes effect only for the ESSD disk.
               - `PL0`: maximum random read/write IOPS 10000 for a single disk.
               - `PL1`: maximum random read/write IOPS 50000 for a single disk.
               - `PL2`: highest random read/write IOPS 100000 for a single disk.
               - `PL3`: maximum random read/write IOPS 1 million for a single disk.
        :param pulumi.Input[_builtins.int] system_disk_provisioned_iops: The predefined IOPS of a system disk. Valid values: 0 to min{50,000, 1,000 × Capacity - Baseline IOPS}. Baseline IOPS = min{1,800 + 50 × Capacity, 50,000}. This parameter is supported only when `system_disk_category` is set to `cloud_auto`.
        :param pulumi.Input[_builtins.int] system_disk_size: The size of the system disk. Unit: GiB. The value of this parameter must be at least 1 and greater than or equal to the image size. Default value: 40 or the size of the image, whichever is larger.
               - Basic disk: 20 to 500.
               - ESSD (cloud_essd): The valid values vary based on the performance level of the ESSD. PL0 ESSD: 1 to 2048. PL1 ESSD: 20 to 2048. PL2 ESSD: 461 to 2048. PL3 ESSD: 1261 to 2048.
               - ESSD AutoPL disk (cloud_auto): 1 to 2048.
               - Other disk categories: 20 to 2048.
        :param pulumi.Input[_builtins.str] system_disk_snapshot_policy_id: The ID of the automatic snapshot policy used by the system disk.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Add tags only for ECS instances. The maximum length of the tag key is 128 characters. The tag key and value cannot start with aliyun or acs:, or contain https:// or http://.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]] taints: A List of Kubernetes taints to assign to the nodes. Detailed below. More information in [Taints and Toleration](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/). See `taints` below.
        :param pulumi.Input['NodePoolTeeConfigArgs'] tee_config: The configuration about confidential computing for the cluster. See `tee_config` below.
        :param pulumi.Input[_builtins.str] type: Node pool type, value range:
               -'ess': common node pool (including hosting function and auto scaling function).
               -'lingjun': Lingjun node pool.
        :param pulumi.Input[_builtins.bool] unschedulable: Whether the node after expansion can be scheduled.
        :param pulumi.Input[_builtins.bool] update_nodes: Synchronously update node labels and taints.
        :param pulumi.Input[_builtins.str] user_data: Node custom data, base64-encoded.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vswitch_ids: The vswitches used by node pool workers.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if cis_enabled is not None:
            warnings.warn("""Field 'cis_enabled' has been deprecated from provider version 1.223.1. Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. Use `security_hardening_os` instead.""", DeprecationWarning)
            pulumi.log.warn("""cis_enabled is deprecated: Field 'cis_enabled' has been deprecated from provider version 1.223.1. Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. Use `security_hardening_os` instead.""")
        if cis_enabled is not None:
            pulumi.set(__self__, "cis_enabled", cis_enabled)
        if compensate_with_on_demand is not None:
            pulumi.set(__self__, "compensate_with_on_demand", compensate_with_on_demand)
        if cpu_policy is not None:
            pulumi.set(__self__, "cpu_policy", cpu_policy)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if deployment_set_id is not None:
            pulumi.set(__self__, "deployment_set_id", deployment_set_id)
        if desired_size is not None:
            pulumi.set(__self__, "desired_size", desired_size)
        if eflo_node_group is not None:
            pulumi.set(__self__, "eflo_node_group", eflo_node_group)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if format_disk is not None:
            pulumi.set(__self__, "format_disk", format_disk)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)
        if install_cloud_monitor is not None:
            pulumi.set(__self__, "install_cloud_monitor", install_cloud_monitor)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if internet_max_bandwidth_out is not None:
            pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        if keep_instance_name is not None:
            pulumi.set(__self__, "keep_instance_name", keep_instance_name)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if kms_encrypted_password is not None:
            pulumi.set(__self__, "kms_encrypted_password", kms_encrypted_password)
        if kms_encryption_context is not None:
            pulumi.set(__self__, "kms_encryption_context", kms_encryption_context)
        if kubelet_configuration is not None:
            pulumi.set(__self__, "kubelet_configuration", kubelet_configuration)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if login_as_non_root is not None:
            pulumi.set(__self__, "login_as_non_root", login_as_non_root)
        if management is not None:
            pulumi.set(__self__, "management", management)
        if multi_az_policy is not None:
            pulumi.set(__self__, "multi_az_policy", multi_az_policy)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated since provider version 1.219.0. New field 'node_pool_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.219.0. New field 'node_pool_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_count is not None:
            warnings.warn("""Field 'node_count' has been deprecated from provider version 1.158.0. New field 'desired_size' instead.""", DeprecationWarning)
            pulumi.log.warn("""node_count is deprecated: Field 'node_count' has been deprecated from provider version 1.158.0. New field 'desired_size' instead.""")
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if node_name_mode is not None:
            pulumi.set(__self__, "node_name_mode", node_name_mode)
        if node_pool_name is not None:
            pulumi.set(__self__, "node_pool_name", node_pool_name)
        if on_demand_base_capacity is not None:
            pulumi.set(__self__, "on_demand_base_capacity", on_demand_base_capacity)
        if on_demand_percentage_above_base_capacity is not None:
            pulumi.set(__self__, "on_demand_percentage_above_base_capacity", on_demand_percentage_above_base_capacity)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if platform is not None:
            warnings.warn("""Field 'platform' has been deprecated from provider version 1.145.0. Operating system release, using `image_type` instead.""", DeprecationWarning)
            pulumi.log.warn("""platform is deprecated: Field 'platform' has been deprecated from provider version 1.145.0. Operating system release, using `image_type` instead.""")
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if pre_user_data is not None:
            pulumi.set(__self__, "pre_user_data", pre_user_data)
        if private_pool_options is not None:
            pulumi.set(__self__, "private_pool_options", private_pool_options)
        if ram_role_name is not None:
            pulumi.set(__self__, "ram_role_name", ram_role_name)
        if rds_instances is not None:
            pulumi.set(__self__, "rds_instances", rds_instances)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if rolling_policy is not None:
            pulumi.set(__self__, "rolling_policy", rolling_policy)
        if runtime_name is not None:
            pulumi.set(__self__, "runtime_name", runtime_name)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)
        if scaling_config is not None:
            pulumi.set(__self__, "scaling_config", scaling_config)
        if scaling_policy is not None:
            pulumi.set(__self__, "scaling_policy", scaling_policy)
        if security_group_id is not None:
            warnings.warn("""Field 'security_group_id' has been deprecated from provider version 1.145.0. The security group ID of the node pool. This field has been replaced by `security_group_ids`, please use the `security_group_ids` field instead.""", DeprecationWarning)
            pulumi.log.warn("""security_group_id is deprecated: Field 'security_group_id' has been deprecated from provider version 1.145.0. The security group ID of the node pool. This field has been replaced by `security_group_ids`, please use the `security_group_ids` field instead.""")
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if security_hardening_os is not None:
            pulumi.set(__self__, "security_hardening_os", security_hardening_os)
        if soc_enabled is not None:
            pulumi.set(__self__, "soc_enabled", soc_enabled)
        if spot_instance_pools is not None:
            pulumi.set(__self__, "spot_instance_pools", spot_instance_pools)
        if spot_instance_remedy is not None:
            pulumi.set(__self__, "spot_instance_remedy", spot_instance_remedy)
        if spot_price_limits is not None:
            pulumi.set(__self__, "spot_price_limits", spot_price_limits)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if system_disk_bursting_enabled is not None:
            pulumi.set(__self__, "system_disk_bursting_enabled", system_disk_bursting_enabled)
        if system_disk_categories is not None:
            pulumi.set(__self__, "system_disk_categories", system_disk_categories)
        if system_disk_category is not None:
            pulumi.set(__self__, "system_disk_category", system_disk_category)
        if system_disk_encrypt_algorithm is not None:
            pulumi.set(__self__, "system_disk_encrypt_algorithm", system_disk_encrypt_algorithm)
        if system_disk_encrypted is not None:
            pulumi.set(__self__, "system_disk_encrypted", system_disk_encrypted)
        if system_disk_kms_key is not None:
            pulumi.set(__self__, "system_disk_kms_key", system_disk_kms_key)
        if system_disk_performance_level is not None:
            pulumi.set(__self__, "system_disk_performance_level", system_disk_performance_level)
        if system_disk_provisioned_iops is not None:
            pulumi.set(__self__, "system_disk_provisioned_iops", system_disk_provisioned_iops)
        if system_disk_size is not None:
            pulumi.set(__self__, "system_disk_size", system_disk_size)
        if system_disk_snapshot_policy_id is not None:
            pulumi.set(__self__, "system_disk_snapshot_policy_id", system_disk_snapshot_policy_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if tee_config is not None:
            pulumi.set(__self__, "tee_config", tee_config)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if unschedulable is not None:
            pulumi.set(__self__, "unschedulable", unschedulable)
        if update_nodes is not None:
            pulumi.set(__self__, "update_nodes", update_nodes)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if vswitch_ids is not None:
            pulumi.set(__self__, "vswitch_ids", vswitch_ids)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of kubernetes cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable automatic renewal for nodes in the node pool takes effect only when `instance_charge_type` is set to `PrePaid`. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The automatic renewal period of nodes in the node pool takes effect only when you select Prepaid and Automatic Renewal, and is a required value. When `PeriodUnit = Month`, the value range is {1, 2, 3, 6, 12}. Default value: 1.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_renew_period", value)

    @_builtins.property
    @pulumi.getter(name="cisEnabled")
    @_utilities.deprecated("""Field 'cis_enabled' has been deprecated from provider version 1.223.1. Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. Use `security_hardening_os` instead.""")
    def cis_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. Use `security_hardening_os` instead.
        """
        return pulumi.get(self, "cis_enabled")

    @cis_enabled.setter
    def cis_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cis_enabled", value)

    @_builtins.property
    @pulumi.getter(name="compensateWithOnDemand")
    def compensate_with_on_demand(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to automatically create pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created due to reasons such as cost or insufficient inventory. This parameter takes effect when you set `multi_az_policy` to `COST_OPTIMIZED`. Valid values: `true`: automatically creates pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created. `false`: does not create pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created.
        """
        return pulumi.get(self, "compensate_with_on_demand")

    @compensate_with_on_demand.setter
    def compensate_with_on_demand(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "compensate_with_on_demand", value)

    @_builtins.property
    @pulumi.getter(name="cpuPolicy")
    def cpu_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node CPU management policies. Default value: `none`. When the cluster version is 1.12.6 or later, the following two policies are supported:
        """
        return pulumi.get(self, "cpu_policy")

    @cpu_policy.setter
    def cpu_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cpu_policy", value)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolDataDiskArgs']]]]:
        """
        Configure the data disk of the node in the node pool. See `data_disks` below.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @_builtins.property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The deployment set of node pool. Specify the deploymentSet to ensure that the nodes in the node pool can be distributed on different physical machines.
        """
        return pulumi.get(self, "deployment_set_id")

    @deployment_set_id.setter
    def deployment_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployment_set_id", value)

    @_builtins.property
    @pulumi.getter(name="desiredSize")
    def desired_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Number of expected nodes in the node pool.
        """
        return pulumi.get(self, "desired_size")

    @desired_size.setter
    def desired_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_size", value)

    @_builtins.property
    @pulumi.getter(name="efloNodeGroup")
    def eflo_node_group(self) -> Optional[pulumi.Input['NodePoolEfloNodeGroupArgs']]:
        """
        Lingjun node pool configuration. See `eflo_node_group` below.
        """
        return pulumi.get(self, "eflo_node_group")

    @eflo_node_group.setter
    def eflo_node_group(self, value: Optional[pulumi.Input['NodePoolEfloNodeGroupArgs']]):
        pulumi.set(self, "eflo_node_group", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to force deletion.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="formatDisk")
    def format_disk(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        After you select this check box, if data disks have been attached to the specified ECS instances and the file system of the last data disk is uninitialized, the system automatically formats the last data disk to ext4 and mounts the data disk to /var/lib/docker and /var/lib/kubelet. The original data on the disk will be cleared. Make sure that you back up data in advance. If no data disk is mounted on the ECS instance, no new data disk will be purchased. Default is `false`.
        """
        return pulumi.get(self, "format_disk")

    @format_disk.setter
    def format_disk(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "format_disk", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The custom image ID. The system-provided image is used by default.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operating system image type and the `platform` parameter can be selected from the following values:
        - `AliyunLinux` : Alinux2 image.
        - `AliyunLinux3` : Alinux3 image.
        - `AliyunLinux3Arm64` : Alinux3 mirror ARM version.
        - `AliyunLinuxUEFI` : Alinux2 Image UEFI version.
        - `CentOS` : CentOS image.
        - `Windows` : Windows image.
        - `WindowsCore` : WindowsCore image.
        - `ContainerOS` : container-optimized image.
        - `Ubuntu`: Ubuntu image.
        - `AliyunLinux3ContainerOptimized`: Alinux3 container-optimized image.
        - `Custom`: Custom image.
        """
        return pulumi.get(self, "image_type")

    @image_type.setter
    def image_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_type", value)

    @_builtins.property
    @pulumi.getter(name="installCloudMonitor")
    def install_cloud_monitor(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to install cloud monitoring on the ECS node. After installation, you can view the monitoring information of the created ECS instance in the cloud monitoring console and recommend enable it. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "install_cloud_monitor")

    @install_cloud_monitor.setter
    def install_cloud_monitor(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "install_cloud_monitor", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node payment type. Valid values: `PostPaid`, `PrePaid`, default is `PostPaid`. If value is `PrePaid`, the arguments `period`, `period_unit`, `auto_renew` and `auto_renew_period` are required.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        In the node instance specification list, you can select multiple instance specifications as alternatives. When each node is created, it will try to purchase from the first specification until it is created successfully. The final purchased instance specifications may vary with inventory changes.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "instance_types", value)

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The instance list. Add existing nodes under the same cluster VPC to the node pool.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "instances", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method for network usage. Valid values `PayByBandwidth` and `PayByTraffic`. Conflict with `eip_internet_charge_type`, EIP and public network IP can only choose one.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum bandwidth of the public IP address of the node. The unit is Mbps(Mega bit per second). The value range is:\\[1,100\\]
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @internet_max_bandwidth_out.setter
    def internet_max_bandwidth_out(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "internet_max_bandwidth_out", value)

    @_builtins.property
    @pulumi.getter(name="keepInstanceName")
    def keep_instance_name(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Add an existing instance to the node pool, whether to keep the original instance name. It is recommended to set to `true`.
        """
        return pulumi.get(self, "keep_instance_name")

    @keep_instance_name.setter
    def keep_instance_name(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "keep_instance_name", value)

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the key pair. When the node pool is a managed node pool, only `key_name` is supported.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_name", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @kms_encrypted_password.setter
    def kms_encrypted_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_encrypted_password", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @kms_encryption_context.setter
    def kms_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "kms_encryption_context", value)

    @_builtins.property
    @pulumi.getter(name="kubeletConfiguration")
    def kubelet_configuration(self) -> Optional[pulumi.Input['NodePoolKubeletConfigurationArgs']]:
        """
        Kubelet configuration parameters for worker nodes. See `kubelet_configuration` below. More information in [Kubelet Configuration](https://kubernetes.io/docs/reference/config-api/kubelet-config.v1beta1/). See `kubelet_configuration` below.
        """
        return pulumi.get(self, "kubelet_configuration")

    @kubelet_configuration.setter
    def kubelet_configuration(self, value: Optional[pulumi.Input['NodePoolKubeletConfigurationArgs']]):
        pulumi.set(self, "kubelet_configuration", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolLabelArgs']]]]:
        """
        A List of Kubernetes labels to assign to the nodes . Only labels that are applied with the ACK API are managed by this argument. Detailed below. More information in [Labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/). See `labels` below.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="loginAsNonRoot")
    def login_as_non_root(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the ECS instance is logged on as a ecs-user user. Valid value: `true` and `false`.
        """
        return pulumi.get(self, "login_as_non_root")

    @login_as_non_root.setter
    def login_as_non_root(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "login_as_non_root", value)

    @_builtins.property
    @pulumi.getter
    def management(self) -> Optional[pulumi.Input['NodePoolManagementArgs']]:
        """
        Managed node pool configuration. See `management` below.
        """
        return pulumi.get(self, "management")

    @management.setter
    def management(self, value: Optional[pulumi.Input['NodePoolManagementArgs']]):
        pulumi.set(self, "management", value)

    @_builtins.property
    @pulumi.getter(name="multiAzPolicy")
    def multi_az_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scaling policy for ECS instances in a multi-zone scaling group. Valid value: `PRIORITY`, `COST_OPTIMIZED` and `BALANCE`. `PRIORITY`: scales the capacity according to the virtual switches you define (VSwitchIds.N). When an ECS instance cannot be created in the zone where the higher-priority vSwitch is located, the next-priority vSwitch is automatically used to create an ECS instance. `COST_OPTIMIZED`: try to create by vCPU unit price from low to high. When the scaling configuration is configured with multiple instances of preemptible billing, preemptible instances are created first. You can continue to use the `CompensateWithOnDemand` parameter to specify whether to automatically try to create a preemptible instance by paying for it. It takes effect only when the scaling configuration has multi-instance specifications or preemptible instances. `BALANCE`: distributes ECS instances evenly among the multi-zone specified by the scaling group. If the zones become unbalanced due to insufficient inventory, you can use the API RebalanceInstances to balance resources.
        """
        return pulumi.get(self, "multi_az_policy")

    @multi_az_policy.setter
    def multi_az_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "multi_az_policy", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.219.0. New field 'node_pool_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'name' has been deprecated from provider version 1.219.0. New field 'node_pool_name' instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    @_utilities.deprecated("""Field 'node_count' has been deprecated from provider version 1.158.0. New field 'desired_size' instead.""")
    def node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The worker node number of the node pool. From version 1.111.0, `node_count` is not required.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_count", value)

    @_builtins.property
    @pulumi.getter(name="nodeNameMode")
    def node_name_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Each node name consists of a prefix, its private network IP, and a suffix, separated by commas. The input format is `customized,,ip,`.
        - The prefix and suffix can be composed of one or more parts separated by '.', each part can use lowercase letters, numbers and '-', and the beginning and end of the node name must be lowercase letters and numbers.
        - The node IP address is the complete private IP address of the node.
        - For example, if the string `customized,aliyun,ip,com` is passed in (where 'customized' and 'ip' are fixed strings, 'aliyun' is the prefix, and 'com' is the suffix), the name of the node is `aliyun192.168.xxx.xxxcom`.
        """
        return pulumi.get(self, "node_name_mode")

    @node_name_mode.setter
    def node_name_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_name_mode", value)

    @_builtins.property
    @pulumi.getter(name="nodePoolName")
    def node_pool_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of node pool.
        """
        return pulumi.get(self, "node_pool_name")

    @node_pool_name.setter
    def node_pool_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_pool_name", value)

    @_builtins.property
    @pulumi.getter(name="onDemandBaseCapacity")
    def on_demand_base_capacity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minimum number of pay-as-you-go instances that must be kept in the scaling group. Valid values: 0 to 1000. If the number of pay-as-you-go instances is less than the value of this parameter, Auto Scaling preferably creates pay-as-you-go instances.
        """
        return pulumi.get(self, "on_demand_base_capacity")

    @on_demand_base_capacity.setter
    def on_demand_base_capacity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_demand_base_capacity", value)

    @_builtins.property
    @pulumi.getter(name="onDemandPercentageAboveBaseCapacity")
    def on_demand_percentage_above_base_capacity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The percentage of pay-as-you-go instances among the extra instances that exceed the number specified by `on_demand_base_capacity`. Valid values: 0 to 100.
        """
        return pulumi.get(self, "on_demand_percentage_above_base_capacity")

    @on_demand_percentage_above_base_capacity.setter
    def on_demand_percentage_above_base_capacity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_demand_percentage_above_base_capacity", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of ssh login. You have to specify one of `password` and `key_name` fields. The password rule is 8 to 30 characters and contains at least three items (upper and lower case letters, numbers, and special symbols).
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Node payment period. Its valid value is one of {1, 2, 3, 6, 12}.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node payment period unit, valid value: `Month`. Default is `Month`.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'platform' has been deprecated from provider version 1.145.0. Operating system release, using `image_type` instead.""")
    def platform(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Operating system release, using `image_type` instead.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform", value)

    @_builtins.property
    @pulumi.getter(name="preUserData")
    def pre_user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node pre custom data, base64-encoded, the script executed before the node is initialized.
        """
        return pulumi.get(self, "pre_user_data")

    @pre_user_data.setter
    def pre_user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pre_user_data", value)

    @_builtins.property
    @pulumi.getter(name="privatePoolOptions")
    def private_pool_options(self) -> Optional[pulumi.Input['NodePoolPrivatePoolOptionsArgs']]:
        """
        Private node pool configuration. See `private_pool_options` below.
        """
        return pulumi.get(self, "private_pool_options")

    @private_pool_options.setter
    def private_pool_options(self, value: Optional[pulumi.Input['NodePoolPrivatePoolOptionsArgs']]):
        pulumi.set(self, "private_pool_options", value)

    @_builtins.property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Worker RAM role.
        * If it is empty, the default Worker RAM role created in the cluster will be used.
        * If the specified RAM role is not empty, the specified RAM role must be a **Common Service role**, and its **trusted service** configuration must be **cloud server**. For more information, see [Create a common service role](https://help.aliyun.com/document_detail/116800.html). If the specified RAM role is not the default Worker RAM role created in the cluster, the role name cannot start with 'KubernetesMasterRole-'or 'KubernetesWorkerRole.

        > **NOTE:**  This parameter is only supported for ACK-managed clusters of 1.22 or later versions.
        """
        return pulumi.get(self, "ram_role_name")

    @ram_role_name.setter
    def ram_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ram_role_name", value)

    @_builtins.property
    @pulumi.getter(name="rdsInstances")
    def rds_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of RDS instances.
        """
        return pulumi.get(self, "rds_instances")

    @rds_instances.setter
    def rds_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "rds_instances", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="rollingPolicy")
    def rolling_policy(self) -> Optional[pulumi.Input['NodePoolRollingPolicyArgs']]:
        """
        Rotary configuration. See `rolling_policy` below.
        """
        return pulumi.get(self, "rolling_policy")

    @rolling_policy.setter
    def rolling_policy(self, value: Optional[pulumi.Input['NodePoolRollingPolicyArgs']]):
        pulumi.set(self, "rolling_policy", value)

    @_builtins.property
    @pulumi.getter(name="runtimeName")
    def runtime_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The runtime name of containers. If not set, the cluster runtime will be used as the node pool runtime. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm).
        """
        return pulumi.get(self, "runtime_name")

    @runtime_name.setter
    def runtime_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime_name", value)

    @_builtins.property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The runtime version of containers. If not set, the cluster runtime will be used as the node pool runtime.
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime_version", value)

    @_builtins.property
    @pulumi.getter(name="scalingConfig")
    def scaling_config(self) -> Optional[pulumi.Input['NodePoolScalingConfigArgs']]:
        """
        Automatic scaling configuration. See `scaling_config` below.
        """
        return pulumi.get(self, "scaling_config")

    @scaling_config.setter
    def scaling_config(self, value: Optional[pulumi.Input['NodePoolScalingConfigArgs']]):
        pulumi.set(self, "scaling_config", value)

    @_builtins.property
    @pulumi.getter(name="scalingPolicy")
    def scaling_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scaling group mode, default value: `release`. Valid values:
        """
        return pulumi.get(self, "scaling_policy")

    @scaling_policy.setter
    def scaling_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_policy", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    @_utilities.deprecated("""Field 'security_group_id' has been deprecated from provider version 1.145.0. The security group ID of the node pool. This field has been replaced by `security_group_ids`, please use the `security_group_ids` field instead.""")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security group ID of the node pool. This field has been replaced by `security_group_ids`, please use the `security_group_ids` field instead.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Multiple security groups can be configured for a node pool. If both `security_group_ids` and `security_group_id` are configured, `security_group_ids` takes effect. This field cannot be modified.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="securityHardeningOs")
    def security_hardening_os(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Alibaba Cloud OS security reinforcement. Default value: `false`. Value:
        """
        return pulumi.get(self, "security_hardening_os")

    @security_hardening_os.setter
    def security_hardening_os(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "security_hardening_os", value)

    @_builtins.property
    @pulumi.getter(name="socEnabled")
    def soc_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether enable worker node to support soc security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [SOC Reinforcement](https://help.aliyun.com/document_detail/196148.html).

        > **NOTE:**  It is forbidden to set both `security_hardening_os` and `soc_enabled` to `true` at the same time.
        """
        return pulumi.get(self, "soc_enabled")

    @soc_enabled.setter
    def soc_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "soc_enabled", value)

    @_builtins.property
    @pulumi.getter(name="spotInstancePools")
    def spot_instance_pools(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of instance types that are available. Auto Scaling creates preemptible instances of multiple instance types that are available at the lowest cost. Valid values: 1 to 10.
        """
        return pulumi.get(self, "spot_instance_pools")

    @spot_instance_pools.setter
    def spot_instance_pools(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "spot_instance_pools", value)

    @_builtins.property
    @pulumi.getter(name="spotInstanceRemedy")
    def spot_instance_remedy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to supplement preemptible instances when the number of preemptible instances drops below the specified minimum number. If you set the value to true, Auto Scaling attempts to create a new preemptible instance when the system notifies that an existing preemptible instance is about to be reclaimed. Valid values: `true`: enables the supplementation of preemptible instances. `false`: disables the supplementation of preemptible instances.
        """
        return pulumi.get(self, "spot_instance_remedy")

    @spot_instance_remedy.setter
    def spot_instance_remedy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "spot_instance_remedy", value)

    @_builtins.property
    @pulumi.getter(name="spotPriceLimits")
    def spot_price_limits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolSpotPriceLimitArgs']]]]:
        """
        The current single preemptible instance type market price range configuration. See `spot_price_limit` below.
        """
        return pulumi.get(self, "spot_price_limits")

    @spot_price_limits.setter
    def spot_price_limits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolSpotPriceLimitArgs']]]]):
        pulumi.set(self, "spot_price_limits", value)

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The preemptible instance type. Value:
        - `NoSpot` : Non-preemptible instance.
        - `SpotWithPriceLimit` : Set the upper limit of the preemptible instance price.
        - `SpotAsPriceGo` : The system automatically bids, following the actual price of the current market.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_strategy", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskBurstingEnabled")
    def system_disk_bursting_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the burst feature for system disks. Valid values:`true`: enables the burst feature. `false`: disables the burst feature. This parameter is supported only when `system_disk_category` is set to `cloud_auto`.
        """
        return pulumi.get(self, "system_disk_bursting_enabled")

    @system_disk_bursting_enabled.setter
    def system_disk_bursting_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "system_disk_bursting_enabled", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskCategories")
    def system_disk_categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The multi-disk categories of the system disk. When a high-priority disk type cannot be used, Auto Scaling automatically tries to create a system disk with the next priority disk category. Valid values see `system_disk_category`.
        """
        return pulumi.get(self, "system_disk_categories")

    @system_disk_categories.setter
    def system_disk_categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_disk_categories", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskCategory")
    def system_disk_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The category of the system disk for nodes. Default value: `cloud_efficiency`. Valid values:
        """
        return pulumi.get(self, "system_disk_category")

    @system_disk_category.setter
    def system_disk_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_category", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskEncryptAlgorithm")
    def system_disk_encrypt_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The encryption algorithm used by the system disk. Value range: aes-256.
        """
        return pulumi.get(self, "system_disk_encrypt_algorithm")

    @system_disk_encrypt_algorithm.setter
    def system_disk_encrypt_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_encrypt_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskEncrypted")
    def system_disk_encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to encrypt the system disk. Value range: `true`: encryption. `false`: Do not encrypt.
        """
        return pulumi.get(self, "system_disk_encrypted")

    @system_disk_encrypted.setter
    def system_disk_encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "system_disk_encrypted", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskKmsKey")
    def system_disk_kms_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the KMS key used by the system disk.
        """
        return pulumi.get(self, "system_disk_kms_key")

    @system_disk_kms_key.setter
    def system_disk_kms_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_kms_key", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskPerformanceLevel")
    def system_disk_performance_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The system disk performance of the node takes effect only for the ESSD disk.
        - `PL0`: maximum random read/write IOPS 10000 for a single disk.
        - `PL1`: maximum random read/write IOPS 50000 for a single disk.
        - `PL2`: highest random read/write IOPS 100000 for a single disk.
        - `PL3`: maximum random read/write IOPS 1 million for a single disk.
        """
        return pulumi.get(self, "system_disk_performance_level")

    @system_disk_performance_level.setter
    def system_disk_performance_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_performance_level", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskProvisionedIops")
    def system_disk_provisioned_iops(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The predefined IOPS of a system disk. Valid values: 0 to min{50,000, 1,000 × Capacity - Baseline IOPS}. Baseline IOPS = min{1,800 + 50 × Capacity, 50,000}. This parameter is supported only when `system_disk_category` is set to `cloud_auto`.
        """
        return pulumi.get(self, "system_disk_provisioned_iops")

    @system_disk_provisioned_iops.setter
    def system_disk_provisioned_iops(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "system_disk_provisioned_iops", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the system disk. Unit: GiB. The value of this parameter must be at least 1 and greater than or equal to the image size. Default value: 40 or the size of the image, whichever is larger.
        - Basic disk: 20 to 500.
        - ESSD (cloud_essd): The valid values vary based on the performance level of the ESSD. PL0 ESSD: 1 to 2048. PL1 ESSD: 20 to 2048. PL2 ESSD: 461 to 2048. PL3 ESSD: 1261 to 2048.
        - ESSD AutoPL disk (cloud_auto): 1 to 2048.
        - Other disk categories: 20 to 2048.
        """
        return pulumi.get(self, "system_disk_size")

    @system_disk_size.setter
    def system_disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "system_disk_size", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskSnapshotPolicyId")
    def system_disk_snapshot_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the automatic snapshot policy used by the system disk.
        """
        return pulumi.get(self, "system_disk_snapshot_policy_id")

    @system_disk_snapshot_policy_id.setter
    def system_disk_snapshot_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_snapshot_policy_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Add tags only for ECS instances. The maximum length of the tag key is 128 characters. The tag key and value cannot start with aliyun or acs:, or contain https:// or http://.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]]]:
        """
        A List of Kubernetes taints to assign to the nodes. Detailed below. More information in [Taints and Toleration](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/). See `taints` below.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @_builtins.property
    @pulumi.getter(name="teeConfig")
    def tee_config(self) -> Optional[pulumi.Input['NodePoolTeeConfigArgs']]:
        """
        The configuration about confidential computing for the cluster. See `tee_config` below.
        """
        return pulumi.get(self, "tee_config")

    @tee_config.setter
    def tee_config(self, value: Optional[pulumi.Input['NodePoolTeeConfigArgs']]):
        pulumi.set(self, "tee_config", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node pool type, value range:
        -'ess': common node pool (including hosting function and auto scaling function).
        -'lingjun': Lingjun node pool.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def unschedulable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the node after expansion can be scheduled.
        """
        return pulumi.get(self, "unschedulable")

    @unschedulable.setter
    def unschedulable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "unschedulable", value)

    @_builtins.property
    @pulumi.getter(name="updateNodes")
    def update_nodes(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Synchronously update node labels and taints.
        """
        return pulumi.get(self, "update_nodes")

    @update_nodes.setter
    def update_nodes(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "update_nodes", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node custom data, base64-encoded.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The vswitches used by node pool workers.
        """
        return pulumi.get(self, "vswitch_ids")

    @vswitch_ids.setter
    def vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vswitch_ids", value)


@pulumi.input_type
class _NodePoolState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 cis_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compensate_with_on_demand: Optional[pulumi.Input[_builtins.bool]] = None,
                 cpu_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolDataDiskArgs']]]] = None,
                 deployment_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_size: Optional[pulumi.Input[_builtins.str]] = None,
                 eflo_node_group: Optional[pulumi.Input['NodePoolEfloNodeGroupArgs']] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 format_disk: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_type: Optional[pulumi.Input[_builtins.str]] = None,
                 install_cloud_monitor: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
                 keep_instance_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 kubelet_configuration: Optional[pulumi.Input['NodePoolKubeletConfigurationArgs']] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolLabelArgs']]]] = None,
                 login_as_non_root: Optional[pulumi.Input[_builtins.bool]] = None,
                 management: Optional[pulumi.Input['NodePoolManagementArgs']] = None,
                 multi_az_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 node_name_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 node_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_demand_base_capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 on_demand_percentage_above_base_capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 private_pool_options: Optional[pulumi.Input['NodePoolPrivatePoolOptionsArgs']] = None,
                 ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rds_instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rolling_policy: Optional[pulumi.Input['NodePoolRollingPolicyArgs']] = None,
                 runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_version: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_config: Optional[pulumi.Input['NodePoolScalingConfigArgs']] = None,
                 scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_hardening_os: Optional[pulumi.Input[_builtins.bool]] = None,
                 soc_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 spot_instance_pools: Optional[pulumi.Input[_builtins.int]] = None,
                 spot_instance_remedy: Optional[pulumi.Input[_builtins.bool]] = None,
                 spot_price_limits: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolSpotPriceLimitArgs']]]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_bursting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_disk_categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 system_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_encrypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_disk_kms_key: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_provisioned_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_snapshot_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]]] = None,
                 tee_config: Optional[pulumi.Input['NodePoolTeeConfigArgs']] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 unschedulable: Optional[pulumi.Input[_builtins.bool]] = None,
                 update_nodes: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering NodePool resources.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to enable automatic renewal for nodes in the node pool takes effect only when `instance_charge_type` is set to `PrePaid`. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.int] auto_renew_period: The automatic renewal period of nodes in the node pool takes effect only when you select Prepaid and Automatic Renewal, and is a required value. When `PeriodUnit = Month`, the value range is {1, 2, 3, 6, 12}. Default value: 1.
        :param pulumi.Input[_builtins.bool] cis_enabled: Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. Use `security_hardening_os` instead.
        :param pulumi.Input[_builtins.str] cluster_id: The id of kubernetes cluster.
        :param pulumi.Input[_builtins.bool] compensate_with_on_demand: Specifies whether to automatically create pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created due to reasons such as cost or insufficient inventory. This parameter takes effect when you set `multi_az_policy` to `COST_OPTIMIZED`. Valid values: `true`: automatically creates pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created. `false`: does not create pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created.
        :param pulumi.Input[_builtins.str] cpu_policy: Node CPU management policies. Default value: `none`. When the cluster version is 1.12.6 or later, the following two policies are supported:
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolDataDiskArgs']]] data_disks: Configure the data disk of the node in the node pool. See `data_disks` below.
        :param pulumi.Input[_builtins.str] deployment_set_id: The deployment set of node pool. Specify the deploymentSet to ensure that the nodes in the node pool can be distributed on different physical machines.
        :param pulumi.Input[_builtins.str] desired_size: Number of expected nodes in the node pool.
        :param pulumi.Input['NodePoolEfloNodeGroupArgs'] eflo_node_group: Lingjun node pool configuration. See `eflo_node_group` below.
        :param pulumi.Input[_builtins.bool] force_delete: Whether to force deletion.
        :param pulumi.Input[_builtins.bool] format_disk: After you select this check box, if data disks have been attached to the specified ECS instances and the file system of the last data disk is uninitialized, the system automatically formats the last data disk to ext4 and mounts the data disk to /var/lib/docker and /var/lib/kubelet. The original data on the disk will be cleared. Make sure that you back up data in advance. If no data disk is mounted on the ECS instance, no new data disk will be purchased. Default is `false`.
        :param pulumi.Input[_builtins.str] image_id: The custom image ID. The system-provided image is used by default.
        :param pulumi.Input[_builtins.str] image_type: The operating system image type and the `platform` parameter can be selected from the following values:
               - `AliyunLinux` : Alinux2 image.
               - `AliyunLinux3` : Alinux3 image.
               - `AliyunLinux3Arm64` : Alinux3 mirror ARM version.
               - `AliyunLinuxUEFI` : Alinux2 Image UEFI version.
               - `CentOS` : CentOS image.
               - `Windows` : Windows image.
               - `WindowsCore` : WindowsCore image.
               - `ContainerOS` : container-optimized image.
               - `Ubuntu`: Ubuntu image.
               - `AliyunLinux3ContainerOptimized`: Alinux3 container-optimized image.
               - `Custom`: Custom image.
        :param pulumi.Input[_builtins.bool] install_cloud_monitor: Whether to install cloud monitoring on the ECS node. After installation, you can view the monitoring information of the created ECS instance in the cloud monitoring console and recommend enable it. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] instance_charge_type: Node payment type. Valid values: `PostPaid`, `PrePaid`, default is `PostPaid`. If value is `PrePaid`, the arguments `period`, `period_unit`, `auto_renew` and `auto_renew_period` are required.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_types: In the node instance specification list, you can select multiple instance specifications as alternatives. When each node is created, it will try to purchase from the first specification until it is created successfully. The final purchased instance specifications may vary with inventory changes.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instances: The instance list. Add existing nodes under the same cluster VPC to the node pool.
        :param pulumi.Input[_builtins.str] internet_charge_type: The billing method for network usage. Valid values `PayByBandwidth` and `PayByTraffic`. Conflict with `eip_internet_charge_type`, EIP and public network IP can only choose one.
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_out: The maximum bandwidth of the public IP address of the node. The unit is Mbps(Mega bit per second). The value range is:\\[1,100\\]
        :param pulumi.Input[_builtins.bool] keep_instance_name: Add an existing instance to the node pool, whether to keep the original instance name. It is recommended to set to `true`.
        :param pulumi.Input[_builtins.str] key_name: The name of the key pair. When the node pool is a managed node pool, only `key_name` is supported.
        :param pulumi.Input[_builtins.str] kms_encrypted_password: An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input['NodePoolKubeletConfigurationArgs'] kubelet_configuration: Kubelet configuration parameters for worker nodes. See `kubelet_configuration` below. More information in [Kubelet Configuration](https://kubernetes.io/docs/reference/config-api/kubelet-config.v1beta1/). See `kubelet_configuration` below.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolLabelArgs']]] labels: A List of Kubernetes labels to assign to the nodes . Only labels that are applied with the ACK API are managed by this argument. Detailed below. More information in [Labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/). See `labels` below.
        :param pulumi.Input[_builtins.bool] login_as_non_root: Whether the ECS instance is logged on as a ecs-user user. Valid value: `true` and `false`.
        :param pulumi.Input['NodePoolManagementArgs'] management: Managed node pool configuration. See `management` below.
        :param pulumi.Input[_builtins.str] multi_az_policy: The scaling policy for ECS instances in a multi-zone scaling group. Valid value: `PRIORITY`, `COST_OPTIMIZED` and `BALANCE`. `PRIORITY`: scales the capacity according to the virtual switches you define (VSwitchIds.N). When an ECS instance cannot be created in the zone where the higher-priority vSwitch is located, the next-priority vSwitch is automatically used to create an ECS instance. `COST_OPTIMIZED`: try to create by vCPU unit price from low to high. When the scaling configuration is configured with multiple instances of preemptible billing, preemptible instances are created first. You can continue to use the `CompensateWithOnDemand` parameter to specify whether to automatically try to create a preemptible instance by paying for it. It takes effect only when the scaling configuration has multi-instance specifications or preemptible instances. `BALANCE`: distributes ECS instances evenly among the multi-zone specified by the scaling group. If the zones become unbalanced due to insufficient inventory, you can use the API RebalanceInstances to balance resources.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.219.0. New field 'node_pool_name' instead.
        :param pulumi.Input[_builtins.int] node_count: The worker node number of the node pool. From version 1.111.0, `node_count` is not required.
        :param pulumi.Input[_builtins.str] node_name_mode: Each node name consists of a prefix, its private network IP, and a suffix, separated by commas. The input format is `customized,,ip,`.
               - The prefix and suffix can be composed of one or more parts separated by '.', each part can use lowercase letters, numbers and '-', and the beginning and end of the node name must be lowercase letters and numbers.
               - The node IP address is the complete private IP address of the node.
               - For example, if the string `customized,aliyun,ip,com` is passed in (where 'customized' and 'ip' are fixed strings, 'aliyun' is the prefix, and 'com' is the suffix), the name of the node is `aliyun192.168.xxx.xxxcom`.
        :param pulumi.Input[_builtins.str] node_pool_id: The first ID of the resource.
        :param pulumi.Input[_builtins.str] node_pool_name: The name of node pool.
        :param pulumi.Input[_builtins.str] on_demand_base_capacity: The minimum number of pay-as-you-go instances that must be kept in the scaling group. Valid values: 0 to 1000. If the number of pay-as-you-go instances is less than the value of this parameter, Auto Scaling preferably creates pay-as-you-go instances.
        :param pulumi.Input[_builtins.str] on_demand_percentage_above_base_capacity: The percentage of pay-as-you-go instances among the extra instances that exceed the number specified by `on_demand_base_capacity`. Valid values: 0 to 100.
        :param pulumi.Input[_builtins.str] password: The password of ssh login. You have to specify one of `password` and `key_name` fields. The password rule is 8 to 30 characters and contains at least three items (upper and lower case letters, numbers, and special symbols).
        :param pulumi.Input[_builtins.int] period: Node payment period. Its valid value is one of {1, 2, 3, 6, 12}.
        :param pulumi.Input[_builtins.str] period_unit: Node payment period unit, valid value: `Month`. Default is `Month`.
        :param pulumi.Input[_builtins.str] platform: Operating system release, using `image_type` instead.
        :param pulumi.Input[_builtins.str] pre_user_data: Node pre custom data, base64-encoded, the script executed before the node is initialized.
        :param pulumi.Input['NodePoolPrivatePoolOptionsArgs'] private_pool_options: Private node pool configuration. See `private_pool_options` below.
        :param pulumi.Input[_builtins.str] ram_role_name: The name of the Worker RAM role.
               * If it is empty, the default Worker RAM role created in the cluster will be used.
               * If the specified RAM role is not empty, the specified RAM role must be a **Common Service role**, and its **trusted service** configuration must be **cloud server**. For more information, see [Create a common service role](https://help.aliyun.com/document_detail/116800.html). If the specified RAM role is not the default Worker RAM role created in the cluster, the role name cannot start with 'KubernetesMasterRole-'or 'KubernetesWorkerRole.
               
               > **NOTE:**  This parameter is only supported for ACK-managed clusters of 1.22 or later versions.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rds_instances: The list of RDS instances.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input['NodePoolRollingPolicyArgs'] rolling_policy: Rotary configuration. See `rolling_policy` below.
        :param pulumi.Input[_builtins.str] runtime_name: The runtime name of containers. If not set, the cluster runtime will be used as the node pool runtime. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm).
        :param pulumi.Input[_builtins.str] runtime_version: The runtime version of containers. If not set, the cluster runtime will be used as the node pool runtime.
        :param pulumi.Input['NodePoolScalingConfigArgs'] scaling_config: Automatic scaling configuration. See `scaling_config` below.
        :param pulumi.Input[_builtins.str] scaling_group_id: The ID of the scaling group.
        :param pulumi.Input[_builtins.str] scaling_policy: Scaling group mode, default value: `release`. Valid values:
        :param pulumi.Input[_builtins.str] security_group_id: The security group ID of the node pool. This field has been replaced by `security_group_ids`, please use the `security_group_ids` field instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: Multiple security groups can be configured for a node pool. If both `security_group_ids` and `security_group_id` are configured, `security_group_ids` takes effect. This field cannot be modified.
        :param pulumi.Input[_builtins.bool] security_hardening_os: Alibaba Cloud OS security reinforcement. Default value: `false`. Value:
        :param pulumi.Input[_builtins.bool] soc_enabled: Whether enable worker node to support soc security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [SOC Reinforcement](https://help.aliyun.com/document_detail/196148.html).
               
               > **NOTE:**  It is forbidden to set both `security_hardening_os` and `soc_enabled` to `true` at the same time.
        :param pulumi.Input[_builtins.int] spot_instance_pools: The number of instance types that are available. Auto Scaling creates preemptible instances of multiple instance types that are available at the lowest cost. Valid values: 1 to 10.
        :param pulumi.Input[_builtins.bool] spot_instance_remedy: Specifies whether to supplement preemptible instances when the number of preemptible instances drops below the specified minimum number. If you set the value to true, Auto Scaling attempts to create a new preemptible instance when the system notifies that an existing preemptible instance is about to be reclaimed. Valid values: `true`: enables the supplementation of preemptible instances. `false`: disables the supplementation of preemptible instances.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolSpotPriceLimitArgs']]] spot_price_limits: The current single preemptible instance type market price range configuration. See `spot_price_limit` below.
        :param pulumi.Input[_builtins.str] spot_strategy: The preemptible instance type. Value:
               - `NoSpot` : Non-preemptible instance.
               - `SpotWithPriceLimit` : Set the upper limit of the preemptible instance price.
               - `SpotAsPriceGo` : The system automatically bids, following the actual price of the current market.
        :param pulumi.Input[_builtins.bool] system_disk_bursting_enabled: Specifies whether to enable the burst feature for system disks. Valid values:`true`: enables the burst feature. `false`: disables the burst feature. This parameter is supported only when `system_disk_category` is set to `cloud_auto`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] system_disk_categories: The multi-disk categories of the system disk. When a high-priority disk type cannot be used, Auto Scaling automatically tries to create a system disk with the next priority disk category. Valid values see `system_disk_category`.
        :param pulumi.Input[_builtins.str] system_disk_category: The category of the system disk for nodes. Default value: `cloud_efficiency`. Valid values:
        :param pulumi.Input[_builtins.str] system_disk_encrypt_algorithm: The encryption algorithm used by the system disk. Value range: aes-256.
        :param pulumi.Input[_builtins.bool] system_disk_encrypted: Whether to encrypt the system disk. Value range: `true`: encryption. `false`: Do not encrypt.
        :param pulumi.Input[_builtins.str] system_disk_kms_key: The ID of the KMS key used by the system disk.
        :param pulumi.Input[_builtins.str] system_disk_performance_level: The system disk performance of the node takes effect only for the ESSD disk.
               - `PL0`: maximum random read/write IOPS 10000 for a single disk.
               - `PL1`: maximum random read/write IOPS 50000 for a single disk.
               - `PL2`: highest random read/write IOPS 100000 for a single disk.
               - `PL3`: maximum random read/write IOPS 1 million for a single disk.
        :param pulumi.Input[_builtins.int] system_disk_provisioned_iops: The predefined IOPS of a system disk. Valid values: 0 to min{50,000, 1,000 × Capacity - Baseline IOPS}. Baseline IOPS = min{1,800 + 50 × Capacity, 50,000}. This parameter is supported only when `system_disk_category` is set to `cloud_auto`.
        :param pulumi.Input[_builtins.int] system_disk_size: The size of the system disk. Unit: GiB. The value of this parameter must be at least 1 and greater than or equal to the image size. Default value: 40 or the size of the image, whichever is larger.
               - Basic disk: 20 to 500.
               - ESSD (cloud_essd): The valid values vary based on the performance level of the ESSD. PL0 ESSD: 1 to 2048. PL1 ESSD: 20 to 2048. PL2 ESSD: 461 to 2048. PL3 ESSD: 1261 to 2048.
               - ESSD AutoPL disk (cloud_auto): 1 to 2048.
               - Other disk categories: 20 to 2048.
        :param pulumi.Input[_builtins.str] system_disk_snapshot_policy_id: The ID of the automatic snapshot policy used by the system disk.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Add tags only for ECS instances. The maximum length of the tag key is 128 characters. The tag key and value cannot start with aliyun or acs:, or contain https:// or http://.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]] taints: A List of Kubernetes taints to assign to the nodes. Detailed below. More information in [Taints and Toleration](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/). See `taints` below.
        :param pulumi.Input['NodePoolTeeConfigArgs'] tee_config: The configuration about confidential computing for the cluster. See `tee_config` below.
        :param pulumi.Input[_builtins.str] type: Node pool type, value range:
               -'ess': common node pool (including hosting function and auto scaling function).
               -'lingjun': Lingjun node pool.
        :param pulumi.Input[_builtins.bool] unschedulable: Whether the node after expansion can be scheduled.
        :param pulumi.Input[_builtins.bool] update_nodes: Synchronously update node labels and taints.
        :param pulumi.Input[_builtins.str] user_data: Node custom data, base64-encoded.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vswitch_ids: The vswitches used by node pool workers.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if cis_enabled is not None:
            warnings.warn("""Field 'cis_enabled' has been deprecated from provider version 1.223.1. Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. Use `security_hardening_os` instead.""", DeprecationWarning)
            pulumi.log.warn("""cis_enabled is deprecated: Field 'cis_enabled' has been deprecated from provider version 1.223.1. Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. Use `security_hardening_os` instead.""")
        if cis_enabled is not None:
            pulumi.set(__self__, "cis_enabled", cis_enabled)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if compensate_with_on_demand is not None:
            pulumi.set(__self__, "compensate_with_on_demand", compensate_with_on_demand)
        if cpu_policy is not None:
            pulumi.set(__self__, "cpu_policy", cpu_policy)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if deployment_set_id is not None:
            pulumi.set(__self__, "deployment_set_id", deployment_set_id)
        if desired_size is not None:
            pulumi.set(__self__, "desired_size", desired_size)
        if eflo_node_group is not None:
            pulumi.set(__self__, "eflo_node_group", eflo_node_group)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if format_disk is not None:
            pulumi.set(__self__, "format_disk", format_disk)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)
        if install_cloud_monitor is not None:
            pulumi.set(__self__, "install_cloud_monitor", install_cloud_monitor)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if internet_max_bandwidth_out is not None:
            pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        if keep_instance_name is not None:
            pulumi.set(__self__, "keep_instance_name", keep_instance_name)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if kms_encrypted_password is not None:
            pulumi.set(__self__, "kms_encrypted_password", kms_encrypted_password)
        if kms_encryption_context is not None:
            pulumi.set(__self__, "kms_encryption_context", kms_encryption_context)
        if kubelet_configuration is not None:
            pulumi.set(__self__, "kubelet_configuration", kubelet_configuration)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if login_as_non_root is not None:
            pulumi.set(__self__, "login_as_non_root", login_as_non_root)
        if management is not None:
            pulumi.set(__self__, "management", management)
        if multi_az_policy is not None:
            pulumi.set(__self__, "multi_az_policy", multi_az_policy)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated since provider version 1.219.0. New field 'node_pool_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.219.0. New field 'node_pool_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_count is not None:
            warnings.warn("""Field 'node_count' has been deprecated from provider version 1.158.0. New field 'desired_size' instead.""", DeprecationWarning)
            pulumi.log.warn("""node_count is deprecated: Field 'node_count' has been deprecated from provider version 1.158.0. New field 'desired_size' instead.""")
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if node_name_mode is not None:
            pulumi.set(__self__, "node_name_mode", node_name_mode)
        if node_pool_id is not None:
            pulumi.set(__self__, "node_pool_id", node_pool_id)
        if node_pool_name is not None:
            pulumi.set(__self__, "node_pool_name", node_pool_name)
        if on_demand_base_capacity is not None:
            pulumi.set(__self__, "on_demand_base_capacity", on_demand_base_capacity)
        if on_demand_percentage_above_base_capacity is not None:
            pulumi.set(__self__, "on_demand_percentage_above_base_capacity", on_demand_percentage_above_base_capacity)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if platform is not None:
            warnings.warn("""Field 'platform' has been deprecated from provider version 1.145.0. Operating system release, using `image_type` instead.""", DeprecationWarning)
            pulumi.log.warn("""platform is deprecated: Field 'platform' has been deprecated from provider version 1.145.0. Operating system release, using `image_type` instead.""")
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if pre_user_data is not None:
            pulumi.set(__self__, "pre_user_data", pre_user_data)
        if private_pool_options is not None:
            pulumi.set(__self__, "private_pool_options", private_pool_options)
        if ram_role_name is not None:
            pulumi.set(__self__, "ram_role_name", ram_role_name)
        if rds_instances is not None:
            pulumi.set(__self__, "rds_instances", rds_instances)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if rolling_policy is not None:
            pulumi.set(__self__, "rolling_policy", rolling_policy)
        if runtime_name is not None:
            pulumi.set(__self__, "runtime_name", runtime_name)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)
        if scaling_config is not None:
            pulumi.set(__self__, "scaling_config", scaling_config)
        if scaling_group_id is not None:
            pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        if scaling_policy is not None:
            pulumi.set(__self__, "scaling_policy", scaling_policy)
        if security_group_id is not None:
            warnings.warn("""Field 'security_group_id' has been deprecated from provider version 1.145.0. The security group ID of the node pool. This field has been replaced by `security_group_ids`, please use the `security_group_ids` field instead.""", DeprecationWarning)
            pulumi.log.warn("""security_group_id is deprecated: Field 'security_group_id' has been deprecated from provider version 1.145.0. The security group ID of the node pool. This field has been replaced by `security_group_ids`, please use the `security_group_ids` field instead.""")
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if security_hardening_os is not None:
            pulumi.set(__self__, "security_hardening_os", security_hardening_os)
        if soc_enabled is not None:
            pulumi.set(__self__, "soc_enabled", soc_enabled)
        if spot_instance_pools is not None:
            pulumi.set(__self__, "spot_instance_pools", spot_instance_pools)
        if spot_instance_remedy is not None:
            pulumi.set(__self__, "spot_instance_remedy", spot_instance_remedy)
        if spot_price_limits is not None:
            pulumi.set(__self__, "spot_price_limits", spot_price_limits)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if system_disk_bursting_enabled is not None:
            pulumi.set(__self__, "system_disk_bursting_enabled", system_disk_bursting_enabled)
        if system_disk_categories is not None:
            pulumi.set(__self__, "system_disk_categories", system_disk_categories)
        if system_disk_category is not None:
            pulumi.set(__self__, "system_disk_category", system_disk_category)
        if system_disk_encrypt_algorithm is not None:
            pulumi.set(__self__, "system_disk_encrypt_algorithm", system_disk_encrypt_algorithm)
        if system_disk_encrypted is not None:
            pulumi.set(__self__, "system_disk_encrypted", system_disk_encrypted)
        if system_disk_kms_key is not None:
            pulumi.set(__self__, "system_disk_kms_key", system_disk_kms_key)
        if system_disk_performance_level is not None:
            pulumi.set(__self__, "system_disk_performance_level", system_disk_performance_level)
        if system_disk_provisioned_iops is not None:
            pulumi.set(__self__, "system_disk_provisioned_iops", system_disk_provisioned_iops)
        if system_disk_size is not None:
            pulumi.set(__self__, "system_disk_size", system_disk_size)
        if system_disk_snapshot_policy_id is not None:
            pulumi.set(__self__, "system_disk_snapshot_policy_id", system_disk_snapshot_policy_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if tee_config is not None:
            pulumi.set(__self__, "tee_config", tee_config)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if unschedulable is not None:
            pulumi.set(__self__, "unschedulable", unschedulable)
        if update_nodes is not None:
            pulumi.set(__self__, "update_nodes", update_nodes)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if vswitch_ids is not None:
            pulumi.set(__self__, "vswitch_ids", vswitch_ids)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable automatic renewal for nodes in the node pool takes effect only when `instance_charge_type` is set to `PrePaid`. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The automatic renewal period of nodes in the node pool takes effect only when you select Prepaid and Automatic Renewal, and is a required value. When `PeriodUnit = Month`, the value range is {1, 2, 3, 6, 12}. Default value: 1.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_renew_period", value)

    @_builtins.property
    @pulumi.getter(name="cisEnabled")
    @_utilities.deprecated("""Field 'cis_enabled' has been deprecated from provider version 1.223.1. Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. Use `security_hardening_os` instead.""")
    def cis_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. Use `security_hardening_os` instead.
        """
        return pulumi.get(self, "cis_enabled")

    @cis_enabled.setter
    def cis_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cis_enabled", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of kubernetes cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="compensateWithOnDemand")
    def compensate_with_on_demand(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to automatically create pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created due to reasons such as cost or insufficient inventory. This parameter takes effect when you set `multi_az_policy` to `COST_OPTIMIZED`. Valid values: `true`: automatically creates pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created. `false`: does not create pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created.
        """
        return pulumi.get(self, "compensate_with_on_demand")

    @compensate_with_on_demand.setter
    def compensate_with_on_demand(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "compensate_with_on_demand", value)

    @_builtins.property
    @pulumi.getter(name="cpuPolicy")
    def cpu_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node CPU management policies. Default value: `none`. When the cluster version is 1.12.6 or later, the following two policies are supported:
        """
        return pulumi.get(self, "cpu_policy")

    @cpu_policy.setter
    def cpu_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cpu_policy", value)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolDataDiskArgs']]]]:
        """
        Configure the data disk of the node in the node pool. See `data_disks` below.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @_builtins.property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The deployment set of node pool. Specify the deploymentSet to ensure that the nodes in the node pool can be distributed on different physical machines.
        """
        return pulumi.get(self, "deployment_set_id")

    @deployment_set_id.setter
    def deployment_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployment_set_id", value)

    @_builtins.property
    @pulumi.getter(name="desiredSize")
    def desired_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Number of expected nodes in the node pool.
        """
        return pulumi.get(self, "desired_size")

    @desired_size.setter
    def desired_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_size", value)

    @_builtins.property
    @pulumi.getter(name="efloNodeGroup")
    def eflo_node_group(self) -> Optional[pulumi.Input['NodePoolEfloNodeGroupArgs']]:
        """
        Lingjun node pool configuration. See `eflo_node_group` below.
        """
        return pulumi.get(self, "eflo_node_group")

    @eflo_node_group.setter
    def eflo_node_group(self, value: Optional[pulumi.Input['NodePoolEfloNodeGroupArgs']]):
        pulumi.set(self, "eflo_node_group", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to force deletion.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="formatDisk")
    def format_disk(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        After you select this check box, if data disks have been attached to the specified ECS instances and the file system of the last data disk is uninitialized, the system automatically formats the last data disk to ext4 and mounts the data disk to /var/lib/docker and /var/lib/kubelet. The original data on the disk will be cleared. Make sure that you back up data in advance. If no data disk is mounted on the ECS instance, no new data disk will be purchased. Default is `false`.
        """
        return pulumi.get(self, "format_disk")

    @format_disk.setter
    def format_disk(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "format_disk", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The custom image ID. The system-provided image is used by default.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operating system image type and the `platform` parameter can be selected from the following values:
        - `AliyunLinux` : Alinux2 image.
        - `AliyunLinux3` : Alinux3 image.
        - `AliyunLinux3Arm64` : Alinux3 mirror ARM version.
        - `AliyunLinuxUEFI` : Alinux2 Image UEFI version.
        - `CentOS` : CentOS image.
        - `Windows` : Windows image.
        - `WindowsCore` : WindowsCore image.
        - `ContainerOS` : container-optimized image.
        - `Ubuntu`: Ubuntu image.
        - `AliyunLinux3ContainerOptimized`: Alinux3 container-optimized image.
        - `Custom`: Custom image.
        """
        return pulumi.get(self, "image_type")

    @image_type.setter
    def image_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_type", value)

    @_builtins.property
    @pulumi.getter(name="installCloudMonitor")
    def install_cloud_monitor(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to install cloud monitoring on the ECS node. After installation, you can view the monitoring information of the created ECS instance in the cloud monitoring console and recommend enable it. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "install_cloud_monitor")

    @install_cloud_monitor.setter
    def install_cloud_monitor(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "install_cloud_monitor", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node payment type. Valid values: `PostPaid`, `PrePaid`, default is `PostPaid`. If value is `PrePaid`, the arguments `period`, `period_unit`, `auto_renew` and `auto_renew_period` are required.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        In the node instance specification list, you can select multiple instance specifications as alternatives. When each node is created, it will try to purchase from the first specification until it is created successfully. The final purchased instance specifications may vary with inventory changes.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "instance_types", value)

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The instance list. Add existing nodes under the same cluster VPC to the node pool.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "instances", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method for network usage. Valid values `PayByBandwidth` and `PayByTraffic`. Conflict with `eip_internet_charge_type`, EIP and public network IP can only choose one.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum bandwidth of the public IP address of the node. The unit is Mbps(Mega bit per second). The value range is:\\[1,100\\]
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @internet_max_bandwidth_out.setter
    def internet_max_bandwidth_out(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "internet_max_bandwidth_out", value)

    @_builtins.property
    @pulumi.getter(name="keepInstanceName")
    def keep_instance_name(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Add an existing instance to the node pool, whether to keep the original instance name. It is recommended to set to `true`.
        """
        return pulumi.get(self, "keep_instance_name")

    @keep_instance_name.setter
    def keep_instance_name(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "keep_instance_name", value)

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the key pair. When the node pool is a managed node pool, only `key_name` is supported.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_name", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @kms_encrypted_password.setter
    def kms_encrypted_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_encrypted_password", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @kms_encryption_context.setter
    def kms_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "kms_encryption_context", value)

    @_builtins.property
    @pulumi.getter(name="kubeletConfiguration")
    def kubelet_configuration(self) -> Optional[pulumi.Input['NodePoolKubeletConfigurationArgs']]:
        """
        Kubelet configuration parameters for worker nodes. See `kubelet_configuration` below. More information in [Kubelet Configuration](https://kubernetes.io/docs/reference/config-api/kubelet-config.v1beta1/). See `kubelet_configuration` below.
        """
        return pulumi.get(self, "kubelet_configuration")

    @kubelet_configuration.setter
    def kubelet_configuration(self, value: Optional[pulumi.Input['NodePoolKubeletConfigurationArgs']]):
        pulumi.set(self, "kubelet_configuration", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolLabelArgs']]]]:
        """
        A List of Kubernetes labels to assign to the nodes . Only labels that are applied with the ACK API are managed by this argument. Detailed below. More information in [Labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/). See `labels` below.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="loginAsNonRoot")
    def login_as_non_root(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the ECS instance is logged on as a ecs-user user. Valid value: `true` and `false`.
        """
        return pulumi.get(self, "login_as_non_root")

    @login_as_non_root.setter
    def login_as_non_root(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "login_as_non_root", value)

    @_builtins.property
    @pulumi.getter
    def management(self) -> Optional[pulumi.Input['NodePoolManagementArgs']]:
        """
        Managed node pool configuration. See `management` below.
        """
        return pulumi.get(self, "management")

    @management.setter
    def management(self, value: Optional[pulumi.Input['NodePoolManagementArgs']]):
        pulumi.set(self, "management", value)

    @_builtins.property
    @pulumi.getter(name="multiAzPolicy")
    def multi_az_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scaling policy for ECS instances in a multi-zone scaling group. Valid value: `PRIORITY`, `COST_OPTIMIZED` and `BALANCE`. `PRIORITY`: scales the capacity according to the virtual switches you define (VSwitchIds.N). When an ECS instance cannot be created in the zone where the higher-priority vSwitch is located, the next-priority vSwitch is automatically used to create an ECS instance. `COST_OPTIMIZED`: try to create by vCPU unit price from low to high. When the scaling configuration is configured with multiple instances of preemptible billing, preemptible instances are created first. You can continue to use the `CompensateWithOnDemand` parameter to specify whether to automatically try to create a preemptible instance by paying for it. It takes effect only when the scaling configuration has multi-instance specifications or preemptible instances. `BALANCE`: distributes ECS instances evenly among the multi-zone specified by the scaling group. If the zones become unbalanced due to insufficient inventory, you can use the API RebalanceInstances to balance resources.
        """
        return pulumi.get(self, "multi_az_policy")

    @multi_az_policy.setter
    def multi_az_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "multi_az_policy", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.219.0. New field 'node_pool_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'name' has been deprecated from provider version 1.219.0. New field 'node_pool_name' instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    @_utilities.deprecated("""Field 'node_count' has been deprecated from provider version 1.158.0. New field 'desired_size' instead.""")
    def node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The worker node number of the node pool. From version 1.111.0, `node_count` is not required.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_count", value)

    @_builtins.property
    @pulumi.getter(name="nodeNameMode")
    def node_name_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Each node name consists of a prefix, its private network IP, and a suffix, separated by commas. The input format is `customized,,ip,`.
        - The prefix and suffix can be composed of one or more parts separated by '.', each part can use lowercase letters, numbers and '-', and the beginning and end of the node name must be lowercase letters and numbers.
        - The node IP address is the complete private IP address of the node.
        - For example, if the string `customized,aliyun,ip,com` is passed in (where 'customized' and 'ip' are fixed strings, 'aliyun' is the prefix, and 'com' is the suffix), the name of the node is `aliyun192.168.xxx.xxxcom`.
        """
        return pulumi.get(self, "node_name_mode")

    @node_name_mode.setter
    def node_name_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_name_mode", value)

    @_builtins.property
    @pulumi.getter(name="nodePoolId")
    def node_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "node_pool_id")

    @node_pool_id.setter
    def node_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="nodePoolName")
    def node_pool_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of node pool.
        """
        return pulumi.get(self, "node_pool_name")

    @node_pool_name.setter
    def node_pool_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_pool_name", value)

    @_builtins.property
    @pulumi.getter(name="onDemandBaseCapacity")
    def on_demand_base_capacity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minimum number of pay-as-you-go instances that must be kept in the scaling group. Valid values: 0 to 1000. If the number of pay-as-you-go instances is less than the value of this parameter, Auto Scaling preferably creates pay-as-you-go instances.
        """
        return pulumi.get(self, "on_demand_base_capacity")

    @on_demand_base_capacity.setter
    def on_demand_base_capacity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_demand_base_capacity", value)

    @_builtins.property
    @pulumi.getter(name="onDemandPercentageAboveBaseCapacity")
    def on_demand_percentage_above_base_capacity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The percentage of pay-as-you-go instances among the extra instances that exceed the number specified by `on_demand_base_capacity`. Valid values: 0 to 100.
        """
        return pulumi.get(self, "on_demand_percentage_above_base_capacity")

    @on_demand_percentage_above_base_capacity.setter
    def on_demand_percentage_above_base_capacity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "on_demand_percentage_above_base_capacity", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of ssh login. You have to specify one of `password` and `key_name` fields. The password rule is 8 to 30 characters and contains at least three items (upper and lower case letters, numbers, and special symbols).
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Node payment period. Its valid value is one of {1, 2, 3, 6, 12}.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node payment period unit, valid value: `Month`. Default is `Month`.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'platform' has been deprecated from provider version 1.145.0. Operating system release, using `image_type` instead.""")
    def platform(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Operating system release, using `image_type` instead.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform", value)

    @_builtins.property
    @pulumi.getter(name="preUserData")
    def pre_user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node pre custom data, base64-encoded, the script executed before the node is initialized.
        """
        return pulumi.get(self, "pre_user_data")

    @pre_user_data.setter
    def pre_user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pre_user_data", value)

    @_builtins.property
    @pulumi.getter(name="privatePoolOptions")
    def private_pool_options(self) -> Optional[pulumi.Input['NodePoolPrivatePoolOptionsArgs']]:
        """
        Private node pool configuration. See `private_pool_options` below.
        """
        return pulumi.get(self, "private_pool_options")

    @private_pool_options.setter
    def private_pool_options(self, value: Optional[pulumi.Input['NodePoolPrivatePoolOptionsArgs']]):
        pulumi.set(self, "private_pool_options", value)

    @_builtins.property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Worker RAM role.
        * If it is empty, the default Worker RAM role created in the cluster will be used.
        * If the specified RAM role is not empty, the specified RAM role must be a **Common Service role**, and its **trusted service** configuration must be **cloud server**. For more information, see [Create a common service role](https://help.aliyun.com/document_detail/116800.html). If the specified RAM role is not the default Worker RAM role created in the cluster, the role name cannot start with 'KubernetesMasterRole-'or 'KubernetesWorkerRole.

        > **NOTE:**  This parameter is only supported for ACK-managed clusters of 1.22 or later versions.
        """
        return pulumi.get(self, "ram_role_name")

    @ram_role_name.setter
    def ram_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ram_role_name", value)

    @_builtins.property
    @pulumi.getter(name="rdsInstances")
    def rds_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of RDS instances.
        """
        return pulumi.get(self, "rds_instances")

    @rds_instances.setter
    def rds_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "rds_instances", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="rollingPolicy")
    def rolling_policy(self) -> Optional[pulumi.Input['NodePoolRollingPolicyArgs']]:
        """
        Rotary configuration. See `rolling_policy` below.
        """
        return pulumi.get(self, "rolling_policy")

    @rolling_policy.setter
    def rolling_policy(self, value: Optional[pulumi.Input['NodePoolRollingPolicyArgs']]):
        pulumi.set(self, "rolling_policy", value)

    @_builtins.property
    @pulumi.getter(name="runtimeName")
    def runtime_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The runtime name of containers. If not set, the cluster runtime will be used as the node pool runtime. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm).
        """
        return pulumi.get(self, "runtime_name")

    @runtime_name.setter
    def runtime_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime_name", value)

    @_builtins.property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The runtime version of containers. If not set, the cluster runtime will be used as the node pool runtime.
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runtime_version", value)

    @_builtins.property
    @pulumi.getter(name="scalingConfig")
    def scaling_config(self) -> Optional[pulumi.Input['NodePoolScalingConfigArgs']]:
        """
        Automatic scaling configuration. See `scaling_config` below.
        """
        return pulumi.get(self, "scaling_config")

    @scaling_config.setter
    def scaling_config(self, value: Optional[pulumi.Input['NodePoolScalingConfigArgs']]):
        pulumi.set(self, "scaling_config", value)

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the scaling group.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_group_id", value)

    @_builtins.property
    @pulumi.getter(name="scalingPolicy")
    def scaling_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scaling group mode, default value: `release`. Valid values:
        """
        return pulumi.get(self, "scaling_policy")

    @scaling_policy.setter
    def scaling_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_policy", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    @_utilities.deprecated("""Field 'security_group_id' has been deprecated from provider version 1.145.0. The security group ID of the node pool. This field has been replaced by `security_group_ids`, please use the `security_group_ids` field instead.""")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security group ID of the node pool. This field has been replaced by `security_group_ids`, please use the `security_group_ids` field instead.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Multiple security groups can be configured for a node pool. If both `security_group_ids` and `security_group_id` are configured, `security_group_ids` takes effect. This field cannot be modified.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="securityHardeningOs")
    def security_hardening_os(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Alibaba Cloud OS security reinforcement. Default value: `false`. Value:
        """
        return pulumi.get(self, "security_hardening_os")

    @security_hardening_os.setter
    def security_hardening_os(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "security_hardening_os", value)

    @_builtins.property
    @pulumi.getter(name="socEnabled")
    def soc_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether enable worker node to support soc security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [SOC Reinforcement](https://help.aliyun.com/document_detail/196148.html).

        > **NOTE:**  It is forbidden to set both `security_hardening_os` and `soc_enabled` to `true` at the same time.
        """
        return pulumi.get(self, "soc_enabled")

    @soc_enabled.setter
    def soc_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "soc_enabled", value)

    @_builtins.property
    @pulumi.getter(name="spotInstancePools")
    def spot_instance_pools(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of instance types that are available. Auto Scaling creates preemptible instances of multiple instance types that are available at the lowest cost. Valid values: 1 to 10.
        """
        return pulumi.get(self, "spot_instance_pools")

    @spot_instance_pools.setter
    def spot_instance_pools(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "spot_instance_pools", value)

    @_builtins.property
    @pulumi.getter(name="spotInstanceRemedy")
    def spot_instance_remedy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to supplement preemptible instances when the number of preemptible instances drops below the specified minimum number. If you set the value to true, Auto Scaling attempts to create a new preemptible instance when the system notifies that an existing preemptible instance is about to be reclaimed. Valid values: `true`: enables the supplementation of preemptible instances. `false`: disables the supplementation of preemptible instances.
        """
        return pulumi.get(self, "spot_instance_remedy")

    @spot_instance_remedy.setter
    def spot_instance_remedy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "spot_instance_remedy", value)

    @_builtins.property
    @pulumi.getter(name="spotPriceLimits")
    def spot_price_limits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolSpotPriceLimitArgs']]]]:
        """
        The current single preemptible instance type market price range configuration. See `spot_price_limit` below.
        """
        return pulumi.get(self, "spot_price_limits")

    @spot_price_limits.setter
    def spot_price_limits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolSpotPriceLimitArgs']]]]):
        pulumi.set(self, "spot_price_limits", value)

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The preemptible instance type. Value:
        - `NoSpot` : Non-preemptible instance.
        - `SpotWithPriceLimit` : Set the upper limit of the preemptible instance price.
        - `SpotAsPriceGo` : The system automatically bids, following the actual price of the current market.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_strategy", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskBurstingEnabled")
    def system_disk_bursting_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the burst feature for system disks. Valid values:`true`: enables the burst feature. `false`: disables the burst feature. This parameter is supported only when `system_disk_category` is set to `cloud_auto`.
        """
        return pulumi.get(self, "system_disk_bursting_enabled")

    @system_disk_bursting_enabled.setter
    def system_disk_bursting_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "system_disk_bursting_enabled", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskCategories")
    def system_disk_categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The multi-disk categories of the system disk. When a high-priority disk type cannot be used, Auto Scaling automatically tries to create a system disk with the next priority disk category. Valid values see `system_disk_category`.
        """
        return pulumi.get(self, "system_disk_categories")

    @system_disk_categories.setter
    def system_disk_categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_disk_categories", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskCategory")
    def system_disk_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The category of the system disk for nodes. Default value: `cloud_efficiency`. Valid values:
        """
        return pulumi.get(self, "system_disk_category")

    @system_disk_category.setter
    def system_disk_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_category", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskEncryptAlgorithm")
    def system_disk_encrypt_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The encryption algorithm used by the system disk. Value range: aes-256.
        """
        return pulumi.get(self, "system_disk_encrypt_algorithm")

    @system_disk_encrypt_algorithm.setter
    def system_disk_encrypt_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_encrypt_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskEncrypted")
    def system_disk_encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to encrypt the system disk. Value range: `true`: encryption. `false`: Do not encrypt.
        """
        return pulumi.get(self, "system_disk_encrypted")

    @system_disk_encrypted.setter
    def system_disk_encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "system_disk_encrypted", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskKmsKey")
    def system_disk_kms_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the KMS key used by the system disk.
        """
        return pulumi.get(self, "system_disk_kms_key")

    @system_disk_kms_key.setter
    def system_disk_kms_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_kms_key", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskPerformanceLevel")
    def system_disk_performance_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The system disk performance of the node takes effect only for the ESSD disk.
        - `PL0`: maximum random read/write IOPS 10000 for a single disk.
        - `PL1`: maximum random read/write IOPS 50000 for a single disk.
        - `PL2`: highest random read/write IOPS 100000 for a single disk.
        - `PL3`: maximum random read/write IOPS 1 million for a single disk.
        """
        return pulumi.get(self, "system_disk_performance_level")

    @system_disk_performance_level.setter
    def system_disk_performance_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_performance_level", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskProvisionedIops")
    def system_disk_provisioned_iops(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The predefined IOPS of a system disk. Valid values: 0 to min{50,000, 1,000 × Capacity - Baseline IOPS}. Baseline IOPS = min{1,800 + 50 × Capacity, 50,000}. This parameter is supported only when `system_disk_category` is set to `cloud_auto`.
        """
        return pulumi.get(self, "system_disk_provisioned_iops")

    @system_disk_provisioned_iops.setter
    def system_disk_provisioned_iops(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "system_disk_provisioned_iops", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the system disk. Unit: GiB. The value of this parameter must be at least 1 and greater than or equal to the image size. Default value: 40 or the size of the image, whichever is larger.
        - Basic disk: 20 to 500.
        - ESSD (cloud_essd): The valid values vary based on the performance level of the ESSD. PL0 ESSD: 1 to 2048. PL1 ESSD: 20 to 2048. PL2 ESSD: 461 to 2048. PL3 ESSD: 1261 to 2048.
        - ESSD AutoPL disk (cloud_auto): 1 to 2048.
        - Other disk categories: 20 to 2048.
        """
        return pulumi.get(self, "system_disk_size")

    @system_disk_size.setter
    def system_disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "system_disk_size", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskSnapshotPolicyId")
    def system_disk_snapshot_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the automatic snapshot policy used by the system disk.
        """
        return pulumi.get(self, "system_disk_snapshot_policy_id")

    @system_disk_snapshot_policy_id.setter
    def system_disk_snapshot_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_snapshot_policy_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Add tags only for ECS instances. The maximum length of the tag key is 128 characters. The tag key and value cannot start with aliyun or acs:, or contain https:// or http://.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]]]:
        """
        A List of Kubernetes taints to assign to the nodes. Detailed below. More information in [Taints and Toleration](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/). See `taints` below.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @_builtins.property
    @pulumi.getter(name="teeConfig")
    def tee_config(self) -> Optional[pulumi.Input['NodePoolTeeConfigArgs']]:
        """
        The configuration about confidential computing for the cluster. See `tee_config` below.
        """
        return pulumi.get(self, "tee_config")

    @tee_config.setter
    def tee_config(self, value: Optional[pulumi.Input['NodePoolTeeConfigArgs']]):
        pulumi.set(self, "tee_config", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node pool type, value range:
        -'ess': common node pool (including hosting function and auto scaling function).
        -'lingjun': Lingjun node pool.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def unschedulable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the node after expansion can be scheduled.
        """
        return pulumi.get(self, "unschedulable")

    @unschedulable.setter
    def unschedulable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "unschedulable", value)

    @_builtins.property
    @pulumi.getter(name="updateNodes")
    def update_nodes(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Synchronously update node labels and taints.
        """
        return pulumi.get(self, "update_nodes")

    @update_nodes.setter
    def update_nodes(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "update_nodes", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node custom data, base64-encoded.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The vswitches used by node pool workers.
        """
        return pulumi.get(self, "vswitch_ids")

    @vswitch_ids.setter
    def vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vswitch_ids", value)


@pulumi.type_token("alicloud:cs/nodePool:NodePool")
class NodePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 cis_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compensate_with_on_demand: Optional[pulumi.Input[_builtins.bool]] = None,
                 cpu_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodePoolDataDiskArgs', 'NodePoolDataDiskArgsDict']]]]] = None,
                 deployment_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_size: Optional[pulumi.Input[_builtins.str]] = None,
                 eflo_node_group: Optional[pulumi.Input[Union['NodePoolEfloNodeGroupArgs', 'NodePoolEfloNodeGroupArgsDict']]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 format_disk: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_type: Optional[pulumi.Input[_builtins.str]] = None,
                 install_cloud_monitor: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
                 keep_instance_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 kubelet_configuration: Optional[pulumi.Input[Union['NodePoolKubeletConfigurationArgs', 'NodePoolKubeletConfigurationArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodePoolLabelArgs', 'NodePoolLabelArgsDict']]]]] = None,
                 login_as_non_root: Optional[pulumi.Input[_builtins.bool]] = None,
                 management: Optional[pulumi.Input[Union['NodePoolManagementArgs', 'NodePoolManagementArgsDict']]] = None,
                 multi_az_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 node_name_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 node_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_demand_base_capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 on_demand_percentage_above_base_capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 private_pool_options: Optional[pulumi.Input[Union['NodePoolPrivatePoolOptionsArgs', 'NodePoolPrivatePoolOptionsArgsDict']]] = None,
                 ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rds_instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rolling_policy: Optional[pulumi.Input[Union['NodePoolRollingPolicyArgs', 'NodePoolRollingPolicyArgsDict']]] = None,
                 runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_version: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_config: Optional[pulumi.Input[Union['NodePoolScalingConfigArgs', 'NodePoolScalingConfigArgsDict']]] = None,
                 scaling_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_hardening_os: Optional[pulumi.Input[_builtins.bool]] = None,
                 soc_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 spot_instance_pools: Optional[pulumi.Input[_builtins.int]] = None,
                 spot_instance_remedy: Optional[pulumi.Input[_builtins.bool]] = None,
                 spot_price_limits: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodePoolSpotPriceLimitArgs', 'NodePoolSpotPriceLimitArgsDict']]]]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_bursting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_disk_categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 system_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_encrypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_disk_kms_key: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_provisioned_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_snapshot_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodePoolTaintArgs', 'NodePoolTaintArgsDict']]]]] = None,
                 tee_config: Optional[pulumi.Input[Union['NodePoolTeeConfigArgs', 'NodePoolTeeConfigArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 unschedulable: Optional[pulumi.Input[_builtins.bool]] = None,
                 update_nodes: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random
        import pulumi_std as std

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        enhanced = alicloud.vpc.get_enhanced_nat_available_zones()
        cloud_efficiency = alicloud.ecs.get_instance_types(availability_zone=enhanced.zones[0].zone_id,
            cpu_core_count=4,
            memory_size=8,
            kubernetes_node_role="Worker",
            system_disk_category="cloud_efficiency")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=enhanced.zones[0].zone_id)
        default_managed_kubernetes = alicloud.cs.ManagedKubernetes("default",
            name_prefix=f"terraform-example-{default['result']}",
            cluster_spec="ack.pro.small",
            worker_vswitch_ids=[default_switch.id],
            new_nat_gateway=True,
            pod_cidr=std.cidrsubnet(input="10.0.0.0/8",
                newbits=8,
                netnum=36).result,
            service_cidr=std.cidrsubnet(input="172.16.0.0/16",
                newbits=4,
                netnum=7).result,
            slb_internet_enabled=True,
            enable_rrsa=True)
        default_key_pair = alicloud.ecs.KeyPair("default", key_pair_name=f"terraform-example-{default['result']}")
        default_node_pool = alicloud.cs.NodePool("default",
            node_pool_name=name,
            cluster_id=default_managed_kubernetes.id,
            vswitch_ids=[default_switch.id],
            instance_types=[cloud_efficiency.instance_types[0].id],
            system_disk_category="cloud_efficiency",
            system_disk_size=40,
            key_name=default_key_pair.key_pair_name,
            labels=[
                {
                    "key": "test1",
                    "value": "nodepool",
                },
                {
                    "key": "test2",
                    "value": "nodepool",
                },
            ],
            taints=[
                {
                    "key": "tf",
                    "effect": "NoSchedule",
                    "value": "example",
                },
                {
                    "key": "tf2",
                    "effect": "NoSchedule",
                    "value": "example2",
                },
            ])
        #The parameter `node_count` is deprecated from version 1.158.0. Please use the new parameter `desired_size` instead, you can update it as follows.
        desired_size = alicloud.cs.NodePool("desired_size",
            node_pool_name="desired_size",
            cluster_id=default_managed_kubernetes.id,
            vswitch_ids=[default_switch.id],
            instance_types=[cloud_efficiency.instance_types[0].id],
            system_disk_category="cloud_efficiency",
            system_disk_size=40,
            key_name=default_key_pair.key_pair_name,
            desired_size="0")
        # Create a managed node pool. If you need to enable maintenance window, you need to set the maintenance window in `alicloud_cs_managed_kubernetes`.
        maintenance = alicloud.cs.NodePool("maintenance",
            node_pool_name="maintenance",
            cluster_id=default_managed_kubernetes.id,
            vswitch_ids=[default_switch.id],
            instance_types=[cloud_efficiency.instance_types[0].id],
            system_disk_category="cloud_efficiency",
            system_disk_size=40,
            key_name=default_key_pair.key_pair_name,
            desired_size="1",
            management={
                "enable": True,
                "auto_repair": True,
                "auto_repair_policy": {
                    "restart_node": True,
                },
                "auto_upgrade": True,
                "auto_upgrade_policy": {
                    "auto_upgrade_kubelet": True,
                },
                "auto_vul_fix": True,
                "auto_vul_fix_policy": {
                    "vul_level": "asap",
                    "restart_node": True,
                },
                "max_unavailable": 1,
            })
        #Create a node pool with spot instance.
        spot_instance = alicloud.cs.NodePool("spot_instance",
            node_pool_name="spot_instance",
            cluster_id=default_managed_kubernetes.id,
            vswitch_ids=[default_switch.id],
            instance_types=[
                cloud_efficiency.instance_types[0].id,
                cloud_efficiency.instance_types[1].id,
            ],
            system_disk_category="cloud_efficiency",
            system_disk_size=40,
            key_name=default_key_pair.key_pair_name,
            desired_size="1",
            spot_strategy="SpotWithPriceLimit",
            spot_price_limits=[
                {
                    "instance_type": cloud_efficiency.instance_types[0].id,
                    "price_limit": "0.70",
                },
                {
                    "instance_type": cloud_efficiency.instance_types[1].id,
                    "price_limit": "0.72",
                },
            ])
        #Use Spot instances to create a node pool with auto-scaling enabled
        spot_auto_scaling = alicloud.cs.NodePool("spot_auto_scaling",
            node_pool_name="spot_auto_scaling",
            cluster_id=default_managed_kubernetes.id,
            vswitch_ids=[default_switch.id],
            instance_types=[cloud_efficiency.instance_types[0].id],
            system_disk_category="cloud_efficiency",
            system_disk_size=40,
            key_name=default_key_pair.key_pair_name,
            scaling_config={
                "min_size": 1,
                "max_size": 10,
                "type": "spot",
            },
            spot_strategy="SpotWithPriceLimit",
            spot_price_limits=[{
                "instance_type": cloud_efficiency.instance_types[0].id,
                "price_limit": "0.70",
            }])
        #Create a `PrePaid` node pool.
        prepaid_node = alicloud.cs.NodePool("prepaid_node",
            node_pool_name="prepaid_node",
            cluster_id=default_managed_kubernetes.id,
            vswitch_ids=[default_switch.id],
            instance_types=[cloud_efficiency.instance_types[0].id],
            system_disk_category="cloud_efficiency",
            system_disk_size=40,
            key_name=default_key_pair.key_pair_name,
            instance_charge_type="PrePaid",
            period=1,
            period_unit="Month",
            auto_renew=True,
            auto_renew_period=1,
            install_cloud_monitor=True)
        ##Create a node pool with customized kubelet parameters
        customized_kubelet = alicloud.cs.NodePool("customized_kubelet",
            node_pool_name="customized_kubelet",
            cluster_id=default_managed_kubernetes.id,
            vswitch_ids=[default_switch.id],
            instance_types=[cloud_efficiency.instance_types[0].id],
            system_disk_category="cloud_efficiency",
            system_disk_size=40,
            instance_charge_type="PostPaid",
            desired_size="0",
            kubelet_configuration={
                "registry_pull_qps": "10",
                "registry_burst": "5",
                "event_record_qps": "10",
                "event_burst": "5",
                "serialize_image_pulls": "true",
                "eviction_hard": {
                    "memory.available": "1024Mi",
                    "nodefs.available": "10%",
                    "nodefs.inodesFree": "5%",
                    "imagefs.available": "10%",
                },
                "system_reserved": {
                    "cpu": "1",
                    "memory": "1Gi",
                    "ephemeral-storage": "10Gi",
                },
                "kube_reserved": {
                    "cpu": "500m",
                    "memory": "1Gi",
                },
                "container_log_max_size": "200Mi",
                "container_log_max_files": "3",
                "max_pods": "100",
                "read_only_port": "0",
                "allowed_unsafe_sysctls": ["net.ipv4.route.min_pmtu"],
            },
            rolling_policy={
                "max_parallelism": 1,
            })
        ```

        ## Import

        Container Service for Kubernetes (ACK) Nodepool can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cs/nodePool:NodePool example <cluster_id>:<node_pool_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to enable automatic renewal for nodes in the node pool takes effect only when `instance_charge_type` is set to `PrePaid`. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.int] auto_renew_period: The automatic renewal period of nodes in the node pool takes effect only when you select Prepaid and Automatic Renewal, and is a required value. When `PeriodUnit = Month`, the value range is {1, 2, 3, 6, 12}. Default value: 1.
        :param pulumi.Input[_builtins.bool] cis_enabled: Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. Use `security_hardening_os` instead.
        :param pulumi.Input[_builtins.str] cluster_id: The id of kubernetes cluster.
        :param pulumi.Input[_builtins.bool] compensate_with_on_demand: Specifies whether to automatically create pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created due to reasons such as cost or insufficient inventory. This parameter takes effect when you set `multi_az_policy` to `COST_OPTIMIZED`. Valid values: `true`: automatically creates pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created. `false`: does not create pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created.
        :param pulumi.Input[_builtins.str] cpu_policy: Node CPU management policies. Default value: `none`. When the cluster version is 1.12.6 or later, the following two policies are supported:
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodePoolDataDiskArgs', 'NodePoolDataDiskArgsDict']]]] data_disks: Configure the data disk of the node in the node pool. See `data_disks` below.
        :param pulumi.Input[_builtins.str] deployment_set_id: The deployment set of node pool. Specify the deploymentSet to ensure that the nodes in the node pool can be distributed on different physical machines.
        :param pulumi.Input[_builtins.str] desired_size: Number of expected nodes in the node pool.
        :param pulumi.Input[Union['NodePoolEfloNodeGroupArgs', 'NodePoolEfloNodeGroupArgsDict']] eflo_node_group: Lingjun node pool configuration. See `eflo_node_group` below.
        :param pulumi.Input[_builtins.bool] force_delete: Whether to force deletion.
        :param pulumi.Input[_builtins.bool] format_disk: After you select this check box, if data disks have been attached to the specified ECS instances and the file system of the last data disk is uninitialized, the system automatically formats the last data disk to ext4 and mounts the data disk to /var/lib/docker and /var/lib/kubelet. The original data on the disk will be cleared. Make sure that you back up data in advance. If no data disk is mounted on the ECS instance, no new data disk will be purchased. Default is `false`.
        :param pulumi.Input[_builtins.str] image_id: The custom image ID. The system-provided image is used by default.
        :param pulumi.Input[_builtins.str] image_type: The operating system image type and the `platform` parameter can be selected from the following values:
               - `AliyunLinux` : Alinux2 image.
               - `AliyunLinux3` : Alinux3 image.
               - `AliyunLinux3Arm64` : Alinux3 mirror ARM version.
               - `AliyunLinuxUEFI` : Alinux2 Image UEFI version.
               - `CentOS` : CentOS image.
               - `Windows` : Windows image.
               - `WindowsCore` : WindowsCore image.
               - `ContainerOS` : container-optimized image.
               - `Ubuntu`: Ubuntu image.
               - `AliyunLinux3ContainerOptimized`: Alinux3 container-optimized image.
               - `Custom`: Custom image.
        :param pulumi.Input[_builtins.bool] install_cloud_monitor: Whether to install cloud monitoring on the ECS node. After installation, you can view the monitoring information of the created ECS instance in the cloud monitoring console and recommend enable it. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] instance_charge_type: Node payment type. Valid values: `PostPaid`, `PrePaid`, default is `PostPaid`. If value is `PrePaid`, the arguments `period`, `period_unit`, `auto_renew` and `auto_renew_period` are required.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_types: In the node instance specification list, you can select multiple instance specifications as alternatives. When each node is created, it will try to purchase from the first specification until it is created successfully. The final purchased instance specifications may vary with inventory changes.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instances: The instance list. Add existing nodes under the same cluster VPC to the node pool.
        :param pulumi.Input[_builtins.str] internet_charge_type: The billing method for network usage. Valid values `PayByBandwidth` and `PayByTraffic`. Conflict with `eip_internet_charge_type`, EIP and public network IP can only choose one.
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_out: The maximum bandwidth of the public IP address of the node. The unit is Mbps(Mega bit per second). The value range is:\\[1,100\\]
        :param pulumi.Input[_builtins.bool] keep_instance_name: Add an existing instance to the node pool, whether to keep the original instance name. It is recommended to set to `true`.
        :param pulumi.Input[_builtins.str] key_name: The name of the key pair. When the node pool is a managed node pool, only `key_name` is supported.
        :param pulumi.Input[_builtins.str] kms_encrypted_password: An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[Union['NodePoolKubeletConfigurationArgs', 'NodePoolKubeletConfigurationArgsDict']] kubelet_configuration: Kubelet configuration parameters for worker nodes. See `kubelet_configuration` below. More information in [Kubelet Configuration](https://kubernetes.io/docs/reference/config-api/kubelet-config.v1beta1/). See `kubelet_configuration` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodePoolLabelArgs', 'NodePoolLabelArgsDict']]]] labels: A List of Kubernetes labels to assign to the nodes . Only labels that are applied with the ACK API are managed by this argument. Detailed below. More information in [Labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/). See `labels` below.
        :param pulumi.Input[_builtins.bool] login_as_non_root: Whether the ECS instance is logged on as a ecs-user user. Valid value: `true` and `false`.
        :param pulumi.Input[Union['NodePoolManagementArgs', 'NodePoolManagementArgsDict']] management: Managed node pool configuration. See `management` below.
        :param pulumi.Input[_builtins.str] multi_az_policy: The scaling policy for ECS instances in a multi-zone scaling group. Valid value: `PRIORITY`, `COST_OPTIMIZED` and `BALANCE`. `PRIORITY`: scales the capacity according to the virtual switches you define (VSwitchIds.N). When an ECS instance cannot be created in the zone where the higher-priority vSwitch is located, the next-priority vSwitch is automatically used to create an ECS instance. `COST_OPTIMIZED`: try to create by vCPU unit price from low to high. When the scaling configuration is configured with multiple instances of preemptible billing, preemptible instances are created first. You can continue to use the `CompensateWithOnDemand` parameter to specify whether to automatically try to create a preemptible instance by paying for it. It takes effect only when the scaling configuration has multi-instance specifications or preemptible instances. `BALANCE`: distributes ECS instances evenly among the multi-zone specified by the scaling group. If the zones become unbalanced due to insufficient inventory, you can use the API RebalanceInstances to balance resources.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.219.0. New field 'node_pool_name' instead.
        :param pulumi.Input[_builtins.int] node_count: The worker node number of the node pool. From version 1.111.0, `node_count` is not required.
        :param pulumi.Input[_builtins.str] node_name_mode: Each node name consists of a prefix, its private network IP, and a suffix, separated by commas. The input format is `customized,,ip,`.
               - The prefix and suffix can be composed of one or more parts separated by '.', each part can use lowercase letters, numbers and '-', and the beginning and end of the node name must be lowercase letters and numbers.
               - The node IP address is the complete private IP address of the node.
               - For example, if the string `customized,aliyun,ip,com` is passed in (where 'customized' and 'ip' are fixed strings, 'aliyun' is the prefix, and 'com' is the suffix), the name of the node is `aliyun192.168.xxx.xxxcom`.
        :param pulumi.Input[_builtins.str] node_pool_name: The name of node pool.
        :param pulumi.Input[_builtins.str] on_demand_base_capacity: The minimum number of pay-as-you-go instances that must be kept in the scaling group. Valid values: 0 to 1000. If the number of pay-as-you-go instances is less than the value of this parameter, Auto Scaling preferably creates pay-as-you-go instances.
        :param pulumi.Input[_builtins.str] on_demand_percentage_above_base_capacity: The percentage of pay-as-you-go instances among the extra instances that exceed the number specified by `on_demand_base_capacity`. Valid values: 0 to 100.
        :param pulumi.Input[_builtins.str] password: The password of ssh login. You have to specify one of `password` and `key_name` fields. The password rule is 8 to 30 characters and contains at least three items (upper and lower case letters, numbers, and special symbols).
        :param pulumi.Input[_builtins.int] period: Node payment period. Its valid value is one of {1, 2, 3, 6, 12}.
        :param pulumi.Input[_builtins.str] period_unit: Node payment period unit, valid value: `Month`. Default is `Month`.
        :param pulumi.Input[_builtins.str] platform: Operating system release, using `image_type` instead.
        :param pulumi.Input[_builtins.str] pre_user_data: Node pre custom data, base64-encoded, the script executed before the node is initialized.
        :param pulumi.Input[Union['NodePoolPrivatePoolOptionsArgs', 'NodePoolPrivatePoolOptionsArgsDict']] private_pool_options: Private node pool configuration. See `private_pool_options` below.
        :param pulumi.Input[_builtins.str] ram_role_name: The name of the Worker RAM role.
               * If it is empty, the default Worker RAM role created in the cluster will be used.
               * If the specified RAM role is not empty, the specified RAM role must be a **Common Service role**, and its **trusted service** configuration must be **cloud server**. For more information, see [Create a common service role](https://help.aliyun.com/document_detail/116800.html). If the specified RAM role is not the default Worker RAM role created in the cluster, the role name cannot start with 'KubernetesMasterRole-'or 'KubernetesWorkerRole.
               
               > **NOTE:**  This parameter is only supported for ACK-managed clusters of 1.22 or later versions.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rds_instances: The list of RDS instances.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[Union['NodePoolRollingPolicyArgs', 'NodePoolRollingPolicyArgsDict']] rolling_policy: Rotary configuration. See `rolling_policy` below.
        :param pulumi.Input[_builtins.str] runtime_name: The runtime name of containers. If not set, the cluster runtime will be used as the node pool runtime. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm).
        :param pulumi.Input[_builtins.str] runtime_version: The runtime version of containers. If not set, the cluster runtime will be used as the node pool runtime.
        :param pulumi.Input[Union['NodePoolScalingConfigArgs', 'NodePoolScalingConfigArgsDict']] scaling_config: Automatic scaling configuration. See `scaling_config` below.
        :param pulumi.Input[_builtins.str] scaling_policy: Scaling group mode, default value: `release`. Valid values:
        :param pulumi.Input[_builtins.str] security_group_id: The security group ID of the node pool. This field has been replaced by `security_group_ids`, please use the `security_group_ids` field instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: Multiple security groups can be configured for a node pool. If both `security_group_ids` and `security_group_id` are configured, `security_group_ids` takes effect. This field cannot be modified.
        :param pulumi.Input[_builtins.bool] security_hardening_os: Alibaba Cloud OS security reinforcement. Default value: `false`. Value:
        :param pulumi.Input[_builtins.bool] soc_enabled: Whether enable worker node to support soc security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [SOC Reinforcement](https://help.aliyun.com/document_detail/196148.html).
               
               > **NOTE:**  It is forbidden to set both `security_hardening_os` and `soc_enabled` to `true` at the same time.
        :param pulumi.Input[_builtins.int] spot_instance_pools: The number of instance types that are available. Auto Scaling creates preemptible instances of multiple instance types that are available at the lowest cost. Valid values: 1 to 10.
        :param pulumi.Input[_builtins.bool] spot_instance_remedy: Specifies whether to supplement preemptible instances when the number of preemptible instances drops below the specified minimum number. If you set the value to true, Auto Scaling attempts to create a new preemptible instance when the system notifies that an existing preemptible instance is about to be reclaimed. Valid values: `true`: enables the supplementation of preemptible instances. `false`: disables the supplementation of preemptible instances.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodePoolSpotPriceLimitArgs', 'NodePoolSpotPriceLimitArgsDict']]]] spot_price_limits: The current single preemptible instance type market price range configuration. See `spot_price_limit` below.
        :param pulumi.Input[_builtins.str] spot_strategy: The preemptible instance type. Value:
               - `NoSpot` : Non-preemptible instance.
               - `SpotWithPriceLimit` : Set the upper limit of the preemptible instance price.
               - `SpotAsPriceGo` : The system automatically bids, following the actual price of the current market.
        :param pulumi.Input[_builtins.bool] system_disk_bursting_enabled: Specifies whether to enable the burst feature for system disks. Valid values:`true`: enables the burst feature. `false`: disables the burst feature. This parameter is supported only when `system_disk_category` is set to `cloud_auto`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] system_disk_categories: The multi-disk categories of the system disk. When a high-priority disk type cannot be used, Auto Scaling automatically tries to create a system disk with the next priority disk category. Valid values see `system_disk_category`.
        :param pulumi.Input[_builtins.str] system_disk_category: The category of the system disk for nodes. Default value: `cloud_efficiency`. Valid values:
        :param pulumi.Input[_builtins.str] system_disk_encrypt_algorithm: The encryption algorithm used by the system disk. Value range: aes-256.
        :param pulumi.Input[_builtins.bool] system_disk_encrypted: Whether to encrypt the system disk. Value range: `true`: encryption. `false`: Do not encrypt.
        :param pulumi.Input[_builtins.str] system_disk_kms_key: The ID of the KMS key used by the system disk.
        :param pulumi.Input[_builtins.str] system_disk_performance_level: The system disk performance of the node takes effect only for the ESSD disk.
               - `PL0`: maximum random read/write IOPS 10000 for a single disk.
               - `PL1`: maximum random read/write IOPS 50000 for a single disk.
               - `PL2`: highest random read/write IOPS 100000 for a single disk.
               - `PL3`: maximum random read/write IOPS 1 million for a single disk.
        :param pulumi.Input[_builtins.int] system_disk_provisioned_iops: The predefined IOPS of a system disk. Valid values: 0 to min{50,000, 1,000 × Capacity - Baseline IOPS}. Baseline IOPS = min{1,800 + 50 × Capacity, 50,000}. This parameter is supported only when `system_disk_category` is set to `cloud_auto`.
        :param pulumi.Input[_builtins.int] system_disk_size: The size of the system disk. Unit: GiB. The value of this parameter must be at least 1 and greater than or equal to the image size. Default value: 40 or the size of the image, whichever is larger.
               - Basic disk: 20 to 500.
               - ESSD (cloud_essd): The valid values vary based on the performance level of the ESSD. PL0 ESSD: 1 to 2048. PL1 ESSD: 20 to 2048. PL2 ESSD: 461 to 2048. PL3 ESSD: 1261 to 2048.
               - ESSD AutoPL disk (cloud_auto): 1 to 2048.
               - Other disk categories: 20 to 2048.
        :param pulumi.Input[_builtins.str] system_disk_snapshot_policy_id: The ID of the automatic snapshot policy used by the system disk.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Add tags only for ECS instances. The maximum length of the tag key is 128 characters. The tag key and value cannot start with aliyun or acs:, or contain https:// or http://.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodePoolTaintArgs', 'NodePoolTaintArgsDict']]]] taints: A List of Kubernetes taints to assign to the nodes. Detailed below. More information in [Taints and Toleration](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/). See `taints` below.
        :param pulumi.Input[Union['NodePoolTeeConfigArgs', 'NodePoolTeeConfigArgsDict']] tee_config: The configuration about confidential computing for the cluster. See `tee_config` below.
        :param pulumi.Input[_builtins.str] type: Node pool type, value range:
               -'ess': common node pool (including hosting function and auto scaling function).
               -'lingjun': Lingjun node pool.
        :param pulumi.Input[_builtins.bool] unschedulable: Whether the node after expansion can be scheduled.
        :param pulumi.Input[_builtins.bool] update_nodes: Synchronously update node labels and taints.
        :param pulumi.Input[_builtins.str] user_data: Node custom data, base64-encoded.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vswitch_ids: The vswitches used by node pool workers.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NodePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random
        import pulumi_std as std

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        enhanced = alicloud.vpc.get_enhanced_nat_available_zones()
        cloud_efficiency = alicloud.ecs.get_instance_types(availability_zone=enhanced.zones[0].zone_id,
            cpu_core_count=4,
            memory_size=8,
            kubernetes_node_role="Worker",
            system_disk_category="cloud_efficiency")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=enhanced.zones[0].zone_id)
        default_managed_kubernetes = alicloud.cs.ManagedKubernetes("default",
            name_prefix=f"terraform-example-{default['result']}",
            cluster_spec="ack.pro.small",
            worker_vswitch_ids=[default_switch.id],
            new_nat_gateway=True,
            pod_cidr=std.cidrsubnet(input="10.0.0.0/8",
                newbits=8,
                netnum=36).result,
            service_cidr=std.cidrsubnet(input="172.16.0.0/16",
                newbits=4,
                netnum=7).result,
            slb_internet_enabled=True,
            enable_rrsa=True)
        default_key_pair = alicloud.ecs.KeyPair("default", key_pair_name=f"terraform-example-{default['result']}")
        default_node_pool = alicloud.cs.NodePool("default",
            node_pool_name=name,
            cluster_id=default_managed_kubernetes.id,
            vswitch_ids=[default_switch.id],
            instance_types=[cloud_efficiency.instance_types[0].id],
            system_disk_category="cloud_efficiency",
            system_disk_size=40,
            key_name=default_key_pair.key_pair_name,
            labels=[
                {
                    "key": "test1",
                    "value": "nodepool",
                },
                {
                    "key": "test2",
                    "value": "nodepool",
                },
            ],
            taints=[
                {
                    "key": "tf",
                    "effect": "NoSchedule",
                    "value": "example",
                },
                {
                    "key": "tf2",
                    "effect": "NoSchedule",
                    "value": "example2",
                },
            ])
        #The parameter `node_count` is deprecated from version 1.158.0. Please use the new parameter `desired_size` instead, you can update it as follows.
        desired_size = alicloud.cs.NodePool("desired_size",
            node_pool_name="desired_size",
            cluster_id=default_managed_kubernetes.id,
            vswitch_ids=[default_switch.id],
            instance_types=[cloud_efficiency.instance_types[0].id],
            system_disk_category="cloud_efficiency",
            system_disk_size=40,
            key_name=default_key_pair.key_pair_name,
            desired_size="0")
        # Create a managed node pool. If you need to enable maintenance window, you need to set the maintenance window in `alicloud_cs_managed_kubernetes`.
        maintenance = alicloud.cs.NodePool("maintenance",
            node_pool_name="maintenance",
            cluster_id=default_managed_kubernetes.id,
            vswitch_ids=[default_switch.id],
            instance_types=[cloud_efficiency.instance_types[0].id],
            system_disk_category="cloud_efficiency",
            system_disk_size=40,
            key_name=default_key_pair.key_pair_name,
            desired_size="1",
            management={
                "enable": True,
                "auto_repair": True,
                "auto_repair_policy": {
                    "restart_node": True,
                },
                "auto_upgrade": True,
                "auto_upgrade_policy": {
                    "auto_upgrade_kubelet": True,
                },
                "auto_vul_fix": True,
                "auto_vul_fix_policy": {
                    "vul_level": "asap",
                    "restart_node": True,
                },
                "max_unavailable": 1,
            })
        #Create a node pool with spot instance.
        spot_instance = alicloud.cs.NodePool("spot_instance",
            node_pool_name="spot_instance",
            cluster_id=default_managed_kubernetes.id,
            vswitch_ids=[default_switch.id],
            instance_types=[
                cloud_efficiency.instance_types[0].id,
                cloud_efficiency.instance_types[1].id,
            ],
            system_disk_category="cloud_efficiency",
            system_disk_size=40,
            key_name=default_key_pair.key_pair_name,
            desired_size="1",
            spot_strategy="SpotWithPriceLimit",
            spot_price_limits=[
                {
                    "instance_type": cloud_efficiency.instance_types[0].id,
                    "price_limit": "0.70",
                },
                {
                    "instance_type": cloud_efficiency.instance_types[1].id,
                    "price_limit": "0.72",
                },
            ])
        #Use Spot instances to create a node pool with auto-scaling enabled
        spot_auto_scaling = alicloud.cs.NodePool("spot_auto_scaling",
            node_pool_name="spot_auto_scaling",
            cluster_id=default_managed_kubernetes.id,
            vswitch_ids=[default_switch.id],
            instance_types=[cloud_efficiency.instance_types[0].id],
            system_disk_category="cloud_efficiency",
            system_disk_size=40,
            key_name=default_key_pair.key_pair_name,
            scaling_config={
                "min_size": 1,
                "max_size": 10,
                "type": "spot",
            },
            spot_strategy="SpotWithPriceLimit",
            spot_price_limits=[{
                "instance_type": cloud_efficiency.instance_types[0].id,
                "price_limit": "0.70",
            }])
        #Create a `PrePaid` node pool.
        prepaid_node = alicloud.cs.NodePool("prepaid_node",
            node_pool_name="prepaid_node",
            cluster_id=default_managed_kubernetes.id,
            vswitch_ids=[default_switch.id],
            instance_types=[cloud_efficiency.instance_types[0].id],
            system_disk_category="cloud_efficiency",
            system_disk_size=40,
            key_name=default_key_pair.key_pair_name,
            instance_charge_type="PrePaid",
            period=1,
            period_unit="Month",
            auto_renew=True,
            auto_renew_period=1,
            install_cloud_monitor=True)
        ##Create a node pool with customized kubelet parameters
        customized_kubelet = alicloud.cs.NodePool("customized_kubelet",
            node_pool_name="customized_kubelet",
            cluster_id=default_managed_kubernetes.id,
            vswitch_ids=[default_switch.id],
            instance_types=[cloud_efficiency.instance_types[0].id],
            system_disk_category="cloud_efficiency",
            system_disk_size=40,
            instance_charge_type="PostPaid",
            desired_size="0",
            kubelet_configuration={
                "registry_pull_qps": "10",
                "registry_burst": "5",
                "event_record_qps": "10",
                "event_burst": "5",
                "serialize_image_pulls": "true",
                "eviction_hard": {
                    "memory.available": "1024Mi",
                    "nodefs.available": "10%",
                    "nodefs.inodesFree": "5%",
                    "imagefs.available": "10%",
                },
                "system_reserved": {
                    "cpu": "1",
                    "memory": "1Gi",
                    "ephemeral-storage": "10Gi",
                },
                "kube_reserved": {
                    "cpu": "500m",
                    "memory": "1Gi",
                },
                "container_log_max_size": "200Mi",
                "container_log_max_files": "3",
                "max_pods": "100",
                "read_only_port": "0",
                "allowed_unsafe_sysctls": ["net.ipv4.route.min_pmtu"],
            },
            rolling_policy={
                "max_parallelism": 1,
            })
        ```

        ## Import

        Container Service for Kubernetes (ACK) Nodepool can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cs/nodePool:NodePool example <cluster_id>:<node_pool_id>
        ```

        :param str resource_name: The name of the resource.
        :param NodePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NodePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 cis_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compensate_with_on_demand: Optional[pulumi.Input[_builtins.bool]] = None,
                 cpu_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodePoolDataDiskArgs', 'NodePoolDataDiskArgsDict']]]]] = None,
                 deployment_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_size: Optional[pulumi.Input[_builtins.str]] = None,
                 eflo_node_group: Optional[pulumi.Input[Union['NodePoolEfloNodeGroupArgs', 'NodePoolEfloNodeGroupArgsDict']]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 format_disk: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_type: Optional[pulumi.Input[_builtins.str]] = None,
                 install_cloud_monitor: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
                 keep_instance_name: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 kubelet_configuration: Optional[pulumi.Input[Union['NodePoolKubeletConfigurationArgs', 'NodePoolKubeletConfigurationArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodePoolLabelArgs', 'NodePoolLabelArgsDict']]]]] = None,
                 login_as_non_root: Optional[pulumi.Input[_builtins.bool]] = None,
                 management: Optional[pulumi.Input[Union['NodePoolManagementArgs', 'NodePoolManagementArgsDict']]] = None,
                 multi_az_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 node_name_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 node_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 on_demand_base_capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 on_demand_percentage_above_base_capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 pre_user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 private_pool_options: Optional[pulumi.Input[Union['NodePoolPrivatePoolOptionsArgs', 'NodePoolPrivatePoolOptionsArgsDict']]] = None,
                 ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rds_instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rolling_policy: Optional[pulumi.Input[Union['NodePoolRollingPolicyArgs', 'NodePoolRollingPolicyArgsDict']]] = None,
                 runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime_version: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_config: Optional[pulumi.Input[Union['NodePoolScalingConfigArgs', 'NodePoolScalingConfigArgsDict']]] = None,
                 scaling_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_hardening_os: Optional[pulumi.Input[_builtins.bool]] = None,
                 soc_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 spot_instance_pools: Optional[pulumi.Input[_builtins.int]] = None,
                 spot_instance_remedy: Optional[pulumi.Input[_builtins.bool]] = None,
                 spot_price_limits: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodePoolSpotPriceLimitArgs', 'NodePoolSpotPriceLimitArgsDict']]]]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_bursting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_disk_categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 system_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_encrypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_disk_kms_key: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_provisioned_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_snapshot_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodePoolTaintArgs', 'NodePoolTaintArgsDict']]]]] = None,
                 tee_config: Optional[pulumi.Input[Union['NodePoolTeeConfigArgs', 'NodePoolTeeConfigArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 unschedulable: Optional[pulumi.Input[_builtins.bool]] = None,
                 update_nodes: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NodePoolArgs.__new__(NodePoolArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["auto_renew_period"] = auto_renew_period
            __props__.__dict__["cis_enabled"] = cis_enabled
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["compensate_with_on_demand"] = compensate_with_on_demand
            __props__.__dict__["cpu_policy"] = cpu_policy
            __props__.__dict__["data_disks"] = data_disks
            __props__.__dict__["deployment_set_id"] = deployment_set_id
            __props__.__dict__["desired_size"] = desired_size
            __props__.__dict__["eflo_node_group"] = eflo_node_group
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["format_disk"] = format_disk
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["image_type"] = image_type
            __props__.__dict__["install_cloud_monitor"] = install_cloud_monitor
            __props__.__dict__["instance_charge_type"] = instance_charge_type
            __props__.__dict__["instance_types"] = instance_types
            __props__.__dict__["instances"] = instances
            __props__.__dict__["internet_charge_type"] = internet_charge_type
            __props__.__dict__["internet_max_bandwidth_out"] = internet_max_bandwidth_out
            __props__.__dict__["keep_instance_name"] = keep_instance_name
            __props__.__dict__["key_name"] = key_name
            __props__.__dict__["kms_encrypted_password"] = None if kms_encrypted_password is None else pulumi.Output.secret(kms_encrypted_password)
            __props__.__dict__["kms_encryption_context"] = kms_encryption_context
            __props__.__dict__["kubelet_configuration"] = kubelet_configuration
            __props__.__dict__["labels"] = labels
            __props__.__dict__["login_as_non_root"] = login_as_non_root
            __props__.__dict__["management"] = management
            __props__.__dict__["multi_az_policy"] = multi_az_policy
            __props__.__dict__["name"] = name
            __props__.__dict__["node_count"] = node_count
            __props__.__dict__["node_name_mode"] = node_name_mode
            __props__.__dict__["node_pool_name"] = node_pool_name
            __props__.__dict__["on_demand_base_capacity"] = on_demand_base_capacity
            __props__.__dict__["on_demand_percentage_above_base_capacity"] = on_demand_percentage_above_base_capacity
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["platform"] = platform
            __props__.__dict__["pre_user_data"] = pre_user_data
            __props__.__dict__["private_pool_options"] = private_pool_options
            __props__.__dict__["ram_role_name"] = ram_role_name
            __props__.__dict__["rds_instances"] = rds_instances
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["rolling_policy"] = rolling_policy
            __props__.__dict__["runtime_name"] = runtime_name
            __props__.__dict__["runtime_version"] = runtime_version
            __props__.__dict__["scaling_config"] = scaling_config
            __props__.__dict__["scaling_policy"] = scaling_policy
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["security_hardening_os"] = security_hardening_os
            __props__.__dict__["soc_enabled"] = soc_enabled
            __props__.__dict__["spot_instance_pools"] = spot_instance_pools
            __props__.__dict__["spot_instance_remedy"] = spot_instance_remedy
            __props__.__dict__["spot_price_limits"] = spot_price_limits
            __props__.__dict__["spot_strategy"] = spot_strategy
            __props__.__dict__["system_disk_bursting_enabled"] = system_disk_bursting_enabled
            __props__.__dict__["system_disk_categories"] = system_disk_categories
            __props__.__dict__["system_disk_category"] = system_disk_category
            __props__.__dict__["system_disk_encrypt_algorithm"] = system_disk_encrypt_algorithm
            __props__.__dict__["system_disk_encrypted"] = system_disk_encrypted
            __props__.__dict__["system_disk_kms_key"] = system_disk_kms_key
            __props__.__dict__["system_disk_performance_level"] = system_disk_performance_level
            __props__.__dict__["system_disk_provisioned_iops"] = system_disk_provisioned_iops
            __props__.__dict__["system_disk_size"] = system_disk_size
            __props__.__dict__["system_disk_snapshot_policy_id"] = system_disk_snapshot_policy_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["taints"] = taints
            __props__.__dict__["tee_config"] = tee_config
            __props__.__dict__["type"] = type
            __props__.__dict__["unschedulable"] = unschedulable
            __props__.__dict__["update_nodes"] = update_nodes
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["vswitch_ids"] = vswitch_ids
            __props__.__dict__["node_pool_id"] = None
            __props__.__dict__["scaling_group_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["kmsEncryptedPassword", "password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(NodePool, __self__).__init__(
            'alicloud:cs/nodePool:NodePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
            cis_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            compensate_with_on_demand: Optional[pulumi.Input[_builtins.bool]] = None,
            cpu_policy: Optional[pulumi.Input[_builtins.str]] = None,
            data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodePoolDataDiskArgs', 'NodePoolDataDiskArgsDict']]]]] = None,
            deployment_set_id: Optional[pulumi.Input[_builtins.str]] = None,
            desired_size: Optional[pulumi.Input[_builtins.str]] = None,
            eflo_node_group: Optional[pulumi.Input[Union['NodePoolEfloNodeGroupArgs', 'NodePoolEfloNodeGroupArgsDict']]] = None,
            force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
            format_disk: Optional[pulumi.Input[_builtins.bool]] = None,
            image_id: Optional[pulumi.Input[_builtins.str]] = None,
            image_type: Optional[pulumi.Input[_builtins.str]] = None,
            install_cloud_monitor: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
            keep_instance_name: Optional[pulumi.Input[_builtins.bool]] = None,
            key_name: Optional[pulumi.Input[_builtins.str]] = None,
            kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
            kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            kubelet_configuration: Optional[pulumi.Input[Union['NodePoolKubeletConfigurationArgs', 'NodePoolKubeletConfigurationArgsDict']]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodePoolLabelArgs', 'NodePoolLabelArgsDict']]]]] = None,
            login_as_non_root: Optional[pulumi.Input[_builtins.bool]] = None,
            management: Optional[pulumi.Input[Union['NodePoolManagementArgs', 'NodePoolManagementArgsDict']]] = None,
            multi_az_policy: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            node_count: Optional[pulumi.Input[_builtins.int]] = None,
            node_name_mode: Optional[pulumi.Input[_builtins.str]] = None,
            node_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            node_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
            on_demand_base_capacity: Optional[pulumi.Input[_builtins.str]] = None,
            on_demand_percentage_above_base_capacity: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            platform: Optional[pulumi.Input[_builtins.str]] = None,
            pre_user_data: Optional[pulumi.Input[_builtins.str]] = None,
            private_pool_options: Optional[pulumi.Input[Union['NodePoolPrivatePoolOptionsArgs', 'NodePoolPrivatePoolOptionsArgsDict']]] = None,
            ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
            rds_instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            rolling_policy: Optional[pulumi.Input[Union['NodePoolRollingPolicyArgs', 'NodePoolRollingPolicyArgsDict']]] = None,
            runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
            runtime_version: Optional[pulumi.Input[_builtins.str]] = None,
            scaling_config: Optional[pulumi.Input[Union['NodePoolScalingConfigArgs', 'NodePoolScalingConfigArgsDict']]] = None,
            scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            scaling_policy: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            security_hardening_os: Optional[pulumi.Input[_builtins.bool]] = None,
            soc_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            spot_instance_pools: Optional[pulumi.Input[_builtins.int]] = None,
            spot_instance_remedy: Optional[pulumi.Input[_builtins.bool]] = None,
            spot_price_limits: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodePoolSpotPriceLimitArgs', 'NodePoolSpotPriceLimitArgsDict']]]]] = None,
            spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_bursting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            system_disk_categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            system_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_encrypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
            system_disk_kms_key: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_provisioned_iops: Optional[pulumi.Input[_builtins.int]] = None,
            system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
            system_disk_snapshot_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodePoolTaintArgs', 'NodePoolTaintArgsDict']]]]] = None,
            tee_config: Optional[pulumi.Input[Union['NodePoolTeeConfigArgs', 'NodePoolTeeConfigArgsDict']]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            unschedulable: Optional[pulumi.Input[_builtins.bool]] = None,
            update_nodes: Optional[pulumi.Input[_builtins.bool]] = None,
            user_data: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'NodePool':
        """
        Get an existing NodePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to enable automatic renewal for nodes in the node pool takes effect only when `instance_charge_type` is set to `PrePaid`. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.int] auto_renew_period: The automatic renewal period of nodes in the node pool takes effect only when you select Prepaid and Automatic Renewal, and is a required value. When `PeriodUnit = Month`, the value range is {1, 2, 3, 6, 12}. Default value: 1.
        :param pulumi.Input[_builtins.bool] cis_enabled: Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. Use `security_hardening_os` instead.
        :param pulumi.Input[_builtins.str] cluster_id: The id of kubernetes cluster.
        :param pulumi.Input[_builtins.bool] compensate_with_on_demand: Specifies whether to automatically create pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created due to reasons such as cost or insufficient inventory. This parameter takes effect when you set `multi_az_policy` to `COST_OPTIMIZED`. Valid values: `true`: automatically creates pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created. `false`: does not create pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created.
        :param pulumi.Input[_builtins.str] cpu_policy: Node CPU management policies. Default value: `none`. When the cluster version is 1.12.6 or later, the following two policies are supported:
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodePoolDataDiskArgs', 'NodePoolDataDiskArgsDict']]]] data_disks: Configure the data disk of the node in the node pool. See `data_disks` below.
        :param pulumi.Input[_builtins.str] deployment_set_id: The deployment set of node pool. Specify the deploymentSet to ensure that the nodes in the node pool can be distributed on different physical machines.
        :param pulumi.Input[_builtins.str] desired_size: Number of expected nodes in the node pool.
        :param pulumi.Input[Union['NodePoolEfloNodeGroupArgs', 'NodePoolEfloNodeGroupArgsDict']] eflo_node_group: Lingjun node pool configuration. See `eflo_node_group` below.
        :param pulumi.Input[_builtins.bool] force_delete: Whether to force deletion.
        :param pulumi.Input[_builtins.bool] format_disk: After you select this check box, if data disks have been attached to the specified ECS instances and the file system of the last data disk is uninitialized, the system automatically formats the last data disk to ext4 and mounts the data disk to /var/lib/docker and /var/lib/kubelet. The original data on the disk will be cleared. Make sure that you back up data in advance. If no data disk is mounted on the ECS instance, no new data disk will be purchased. Default is `false`.
        :param pulumi.Input[_builtins.str] image_id: The custom image ID. The system-provided image is used by default.
        :param pulumi.Input[_builtins.str] image_type: The operating system image type and the `platform` parameter can be selected from the following values:
               - `AliyunLinux` : Alinux2 image.
               - `AliyunLinux3` : Alinux3 image.
               - `AliyunLinux3Arm64` : Alinux3 mirror ARM version.
               - `AliyunLinuxUEFI` : Alinux2 Image UEFI version.
               - `CentOS` : CentOS image.
               - `Windows` : Windows image.
               - `WindowsCore` : WindowsCore image.
               - `ContainerOS` : container-optimized image.
               - `Ubuntu`: Ubuntu image.
               - `AliyunLinux3ContainerOptimized`: Alinux3 container-optimized image.
               - `Custom`: Custom image.
        :param pulumi.Input[_builtins.bool] install_cloud_monitor: Whether to install cloud monitoring on the ECS node. After installation, you can view the monitoring information of the created ECS instance in the cloud monitoring console and recommend enable it. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] instance_charge_type: Node payment type. Valid values: `PostPaid`, `PrePaid`, default is `PostPaid`. If value is `PrePaid`, the arguments `period`, `period_unit`, `auto_renew` and `auto_renew_period` are required.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_types: In the node instance specification list, you can select multiple instance specifications as alternatives. When each node is created, it will try to purchase from the first specification until it is created successfully. The final purchased instance specifications may vary with inventory changes.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instances: The instance list. Add existing nodes under the same cluster VPC to the node pool.
        :param pulumi.Input[_builtins.str] internet_charge_type: The billing method for network usage. Valid values `PayByBandwidth` and `PayByTraffic`. Conflict with `eip_internet_charge_type`, EIP and public network IP can only choose one.
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_out: The maximum bandwidth of the public IP address of the node. The unit is Mbps(Mega bit per second). The value range is:\\[1,100\\]
        :param pulumi.Input[_builtins.bool] keep_instance_name: Add an existing instance to the node pool, whether to keep the original instance name. It is recommended to set to `true`.
        :param pulumi.Input[_builtins.str] key_name: The name of the key pair. When the node pool is a managed node pool, only `key_name` is supported.
        :param pulumi.Input[_builtins.str] kms_encrypted_password: An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[Union['NodePoolKubeletConfigurationArgs', 'NodePoolKubeletConfigurationArgsDict']] kubelet_configuration: Kubelet configuration parameters for worker nodes. See `kubelet_configuration` below. More information in [Kubelet Configuration](https://kubernetes.io/docs/reference/config-api/kubelet-config.v1beta1/). See `kubelet_configuration` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodePoolLabelArgs', 'NodePoolLabelArgsDict']]]] labels: A List of Kubernetes labels to assign to the nodes . Only labels that are applied with the ACK API are managed by this argument. Detailed below. More information in [Labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/). See `labels` below.
        :param pulumi.Input[_builtins.bool] login_as_non_root: Whether the ECS instance is logged on as a ecs-user user. Valid value: `true` and `false`.
        :param pulumi.Input[Union['NodePoolManagementArgs', 'NodePoolManagementArgsDict']] management: Managed node pool configuration. See `management` below.
        :param pulumi.Input[_builtins.str] multi_az_policy: The scaling policy for ECS instances in a multi-zone scaling group. Valid value: `PRIORITY`, `COST_OPTIMIZED` and `BALANCE`. `PRIORITY`: scales the capacity according to the virtual switches you define (VSwitchIds.N). When an ECS instance cannot be created in the zone where the higher-priority vSwitch is located, the next-priority vSwitch is automatically used to create an ECS instance. `COST_OPTIMIZED`: try to create by vCPU unit price from low to high. When the scaling configuration is configured with multiple instances of preemptible billing, preemptible instances are created first. You can continue to use the `CompensateWithOnDemand` parameter to specify whether to automatically try to create a preemptible instance by paying for it. It takes effect only when the scaling configuration has multi-instance specifications or preemptible instances. `BALANCE`: distributes ECS instances evenly among the multi-zone specified by the scaling group. If the zones become unbalanced due to insufficient inventory, you can use the API RebalanceInstances to balance resources.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.219.0. New field 'node_pool_name' instead.
        :param pulumi.Input[_builtins.int] node_count: The worker node number of the node pool. From version 1.111.0, `node_count` is not required.
        :param pulumi.Input[_builtins.str] node_name_mode: Each node name consists of a prefix, its private network IP, and a suffix, separated by commas. The input format is `customized,,ip,`.
               - The prefix and suffix can be composed of one or more parts separated by '.', each part can use lowercase letters, numbers and '-', and the beginning and end of the node name must be lowercase letters and numbers.
               - The node IP address is the complete private IP address of the node.
               - For example, if the string `customized,aliyun,ip,com` is passed in (where 'customized' and 'ip' are fixed strings, 'aliyun' is the prefix, and 'com' is the suffix), the name of the node is `aliyun192.168.xxx.xxxcom`.
        :param pulumi.Input[_builtins.str] node_pool_id: The first ID of the resource.
        :param pulumi.Input[_builtins.str] node_pool_name: The name of node pool.
        :param pulumi.Input[_builtins.str] on_demand_base_capacity: The minimum number of pay-as-you-go instances that must be kept in the scaling group. Valid values: 0 to 1000. If the number of pay-as-you-go instances is less than the value of this parameter, Auto Scaling preferably creates pay-as-you-go instances.
        :param pulumi.Input[_builtins.str] on_demand_percentage_above_base_capacity: The percentage of pay-as-you-go instances among the extra instances that exceed the number specified by `on_demand_base_capacity`. Valid values: 0 to 100.
        :param pulumi.Input[_builtins.str] password: The password of ssh login. You have to specify one of `password` and `key_name` fields. The password rule is 8 to 30 characters and contains at least three items (upper and lower case letters, numbers, and special symbols).
        :param pulumi.Input[_builtins.int] period: Node payment period. Its valid value is one of {1, 2, 3, 6, 12}.
        :param pulumi.Input[_builtins.str] period_unit: Node payment period unit, valid value: `Month`. Default is `Month`.
        :param pulumi.Input[_builtins.str] platform: Operating system release, using `image_type` instead.
        :param pulumi.Input[_builtins.str] pre_user_data: Node pre custom data, base64-encoded, the script executed before the node is initialized.
        :param pulumi.Input[Union['NodePoolPrivatePoolOptionsArgs', 'NodePoolPrivatePoolOptionsArgsDict']] private_pool_options: Private node pool configuration. See `private_pool_options` below.
        :param pulumi.Input[_builtins.str] ram_role_name: The name of the Worker RAM role.
               * If it is empty, the default Worker RAM role created in the cluster will be used.
               * If the specified RAM role is not empty, the specified RAM role must be a **Common Service role**, and its **trusted service** configuration must be **cloud server**. For more information, see [Create a common service role](https://help.aliyun.com/document_detail/116800.html). If the specified RAM role is not the default Worker RAM role created in the cluster, the role name cannot start with 'KubernetesMasterRole-'or 'KubernetesWorkerRole.
               
               > **NOTE:**  This parameter is only supported for ACK-managed clusters of 1.22 or later versions.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rds_instances: The list of RDS instances.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[Union['NodePoolRollingPolicyArgs', 'NodePoolRollingPolicyArgsDict']] rolling_policy: Rotary configuration. See `rolling_policy` below.
        :param pulumi.Input[_builtins.str] runtime_name: The runtime name of containers. If not set, the cluster runtime will be used as the node pool runtime. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm).
        :param pulumi.Input[_builtins.str] runtime_version: The runtime version of containers. If not set, the cluster runtime will be used as the node pool runtime.
        :param pulumi.Input[Union['NodePoolScalingConfigArgs', 'NodePoolScalingConfigArgsDict']] scaling_config: Automatic scaling configuration. See `scaling_config` below.
        :param pulumi.Input[_builtins.str] scaling_group_id: The ID of the scaling group.
        :param pulumi.Input[_builtins.str] scaling_policy: Scaling group mode, default value: `release`. Valid values:
        :param pulumi.Input[_builtins.str] security_group_id: The security group ID of the node pool. This field has been replaced by `security_group_ids`, please use the `security_group_ids` field instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: Multiple security groups can be configured for a node pool. If both `security_group_ids` and `security_group_id` are configured, `security_group_ids` takes effect. This field cannot be modified.
        :param pulumi.Input[_builtins.bool] security_hardening_os: Alibaba Cloud OS security reinforcement. Default value: `false`. Value:
        :param pulumi.Input[_builtins.bool] soc_enabled: Whether enable worker node to support soc security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [SOC Reinforcement](https://help.aliyun.com/document_detail/196148.html).
               
               > **NOTE:**  It is forbidden to set both `security_hardening_os` and `soc_enabled` to `true` at the same time.
        :param pulumi.Input[_builtins.int] spot_instance_pools: The number of instance types that are available. Auto Scaling creates preemptible instances of multiple instance types that are available at the lowest cost. Valid values: 1 to 10.
        :param pulumi.Input[_builtins.bool] spot_instance_remedy: Specifies whether to supplement preemptible instances when the number of preemptible instances drops below the specified minimum number. If you set the value to true, Auto Scaling attempts to create a new preemptible instance when the system notifies that an existing preemptible instance is about to be reclaimed. Valid values: `true`: enables the supplementation of preemptible instances. `false`: disables the supplementation of preemptible instances.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodePoolSpotPriceLimitArgs', 'NodePoolSpotPriceLimitArgsDict']]]] spot_price_limits: The current single preemptible instance type market price range configuration. See `spot_price_limit` below.
        :param pulumi.Input[_builtins.str] spot_strategy: The preemptible instance type. Value:
               - `NoSpot` : Non-preemptible instance.
               - `SpotWithPriceLimit` : Set the upper limit of the preemptible instance price.
               - `SpotAsPriceGo` : The system automatically bids, following the actual price of the current market.
        :param pulumi.Input[_builtins.bool] system_disk_bursting_enabled: Specifies whether to enable the burst feature for system disks. Valid values:`true`: enables the burst feature. `false`: disables the burst feature. This parameter is supported only when `system_disk_category` is set to `cloud_auto`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] system_disk_categories: The multi-disk categories of the system disk. When a high-priority disk type cannot be used, Auto Scaling automatically tries to create a system disk with the next priority disk category. Valid values see `system_disk_category`.
        :param pulumi.Input[_builtins.str] system_disk_category: The category of the system disk for nodes. Default value: `cloud_efficiency`. Valid values:
        :param pulumi.Input[_builtins.str] system_disk_encrypt_algorithm: The encryption algorithm used by the system disk. Value range: aes-256.
        :param pulumi.Input[_builtins.bool] system_disk_encrypted: Whether to encrypt the system disk. Value range: `true`: encryption. `false`: Do not encrypt.
        :param pulumi.Input[_builtins.str] system_disk_kms_key: The ID of the KMS key used by the system disk.
        :param pulumi.Input[_builtins.str] system_disk_performance_level: The system disk performance of the node takes effect only for the ESSD disk.
               - `PL0`: maximum random read/write IOPS 10000 for a single disk.
               - `PL1`: maximum random read/write IOPS 50000 for a single disk.
               - `PL2`: highest random read/write IOPS 100000 for a single disk.
               - `PL3`: maximum random read/write IOPS 1 million for a single disk.
        :param pulumi.Input[_builtins.int] system_disk_provisioned_iops: The predefined IOPS of a system disk. Valid values: 0 to min{50,000, 1,000 × Capacity - Baseline IOPS}. Baseline IOPS = min{1,800 + 50 × Capacity, 50,000}. This parameter is supported only when `system_disk_category` is set to `cloud_auto`.
        :param pulumi.Input[_builtins.int] system_disk_size: The size of the system disk. Unit: GiB. The value of this parameter must be at least 1 and greater than or equal to the image size. Default value: 40 or the size of the image, whichever is larger.
               - Basic disk: 20 to 500.
               - ESSD (cloud_essd): The valid values vary based on the performance level of the ESSD. PL0 ESSD: 1 to 2048. PL1 ESSD: 20 to 2048. PL2 ESSD: 461 to 2048. PL3 ESSD: 1261 to 2048.
               - ESSD AutoPL disk (cloud_auto): 1 to 2048.
               - Other disk categories: 20 to 2048.
        :param pulumi.Input[_builtins.str] system_disk_snapshot_policy_id: The ID of the automatic snapshot policy used by the system disk.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Add tags only for ECS instances. The maximum length of the tag key is 128 characters. The tag key and value cannot start with aliyun or acs:, or contain https:// or http://.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodePoolTaintArgs', 'NodePoolTaintArgsDict']]]] taints: A List of Kubernetes taints to assign to the nodes. Detailed below. More information in [Taints and Toleration](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/). See `taints` below.
        :param pulumi.Input[Union['NodePoolTeeConfigArgs', 'NodePoolTeeConfigArgsDict']] tee_config: The configuration about confidential computing for the cluster. See `tee_config` below.
        :param pulumi.Input[_builtins.str] type: Node pool type, value range:
               -'ess': common node pool (including hosting function and auto scaling function).
               -'lingjun': Lingjun node pool.
        :param pulumi.Input[_builtins.bool] unschedulable: Whether the node after expansion can be scheduled.
        :param pulumi.Input[_builtins.bool] update_nodes: Synchronously update node labels and taints.
        :param pulumi.Input[_builtins.str] user_data: Node custom data, base64-encoded.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vswitch_ids: The vswitches used by node pool workers.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NodePoolState.__new__(_NodePoolState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["auto_renew_period"] = auto_renew_period
        __props__.__dict__["cis_enabled"] = cis_enabled
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["compensate_with_on_demand"] = compensate_with_on_demand
        __props__.__dict__["cpu_policy"] = cpu_policy
        __props__.__dict__["data_disks"] = data_disks
        __props__.__dict__["deployment_set_id"] = deployment_set_id
        __props__.__dict__["desired_size"] = desired_size
        __props__.__dict__["eflo_node_group"] = eflo_node_group
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["format_disk"] = format_disk
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["image_type"] = image_type
        __props__.__dict__["install_cloud_monitor"] = install_cloud_monitor
        __props__.__dict__["instance_charge_type"] = instance_charge_type
        __props__.__dict__["instance_types"] = instance_types
        __props__.__dict__["instances"] = instances
        __props__.__dict__["internet_charge_type"] = internet_charge_type
        __props__.__dict__["internet_max_bandwidth_out"] = internet_max_bandwidth_out
        __props__.__dict__["keep_instance_name"] = keep_instance_name
        __props__.__dict__["key_name"] = key_name
        __props__.__dict__["kms_encrypted_password"] = kms_encrypted_password
        __props__.__dict__["kms_encryption_context"] = kms_encryption_context
        __props__.__dict__["kubelet_configuration"] = kubelet_configuration
        __props__.__dict__["labels"] = labels
        __props__.__dict__["login_as_non_root"] = login_as_non_root
        __props__.__dict__["management"] = management
        __props__.__dict__["multi_az_policy"] = multi_az_policy
        __props__.__dict__["name"] = name
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["node_name_mode"] = node_name_mode
        __props__.__dict__["node_pool_id"] = node_pool_id
        __props__.__dict__["node_pool_name"] = node_pool_name
        __props__.__dict__["on_demand_base_capacity"] = on_demand_base_capacity
        __props__.__dict__["on_demand_percentage_above_base_capacity"] = on_demand_percentage_above_base_capacity
        __props__.__dict__["password"] = password
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["platform"] = platform
        __props__.__dict__["pre_user_data"] = pre_user_data
        __props__.__dict__["private_pool_options"] = private_pool_options
        __props__.__dict__["ram_role_name"] = ram_role_name
        __props__.__dict__["rds_instances"] = rds_instances
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["rolling_policy"] = rolling_policy
        __props__.__dict__["runtime_name"] = runtime_name
        __props__.__dict__["runtime_version"] = runtime_version
        __props__.__dict__["scaling_config"] = scaling_config
        __props__.__dict__["scaling_group_id"] = scaling_group_id
        __props__.__dict__["scaling_policy"] = scaling_policy
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["security_hardening_os"] = security_hardening_os
        __props__.__dict__["soc_enabled"] = soc_enabled
        __props__.__dict__["spot_instance_pools"] = spot_instance_pools
        __props__.__dict__["spot_instance_remedy"] = spot_instance_remedy
        __props__.__dict__["spot_price_limits"] = spot_price_limits
        __props__.__dict__["spot_strategy"] = spot_strategy
        __props__.__dict__["system_disk_bursting_enabled"] = system_disk_bursting_enabled
        __props__.__dict__["system_disk_categories"] = system_disk_categories
        __props__.__dict__["system_disk_category"] = system_disk_category
        __props__.__dict__["system_disk_encrypt_algorithm"] = system_disk_encrypt_algorithm
        __props__.__dict__["system_disk_encrypted"] = system_disk_encrypted
        __props__.__dict__["system_disk_kms_key"] = system_disk_kms_key
        __props__.__dict__["system_disk_performance_level"] = system_disk_performance_level
        __props__.__dict__["system_disk_provisioned_iops"] = system_disk_provisioned_iops
        __props__.__dict__["system_disk_size"] = system_disk_size
        __props__.__dict__["system_disk_snapshot_policy_id"] = system_disk_snapshot_policy_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["taints"] = taints
        __props__.__dict__["tee_config"] = tee_config
        __props__.__dict__["type"] = type
        __props__.__dict__["unschedulable"] = unschedulable
        __props__.__dict__["update_nodes"] = update_nodes
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["vswitch_ids"] = vswitch_ids
        return NodePool(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable automatic renewal for nodes in the node pool takes effect only when `instance_charge_type` is set to `PrePaid`. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The automatic renewal period of nodes in the node pool takes effect only when you select Prepaid and Automatic Renewal, and is a required value. When `PeriodUnit = Month`, the value range is {1, 2, 3, 6, 12}. Default value: 1.
        """
        return pulumi.get(self, "auto_renew_period")

    @_builtins.property
    @pulumi.getter(name="cisEnabled")
    @_utilities.deprecated("""Field 'cis_enabled' has been deprecated from provider version 1.223.1. Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. Use `security_hardening_os` instead.""")
    def cis_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether enable worker node to support cis security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. Use `security_hardening_os` instead.
        """
        return pulumi.get(self, "cis_enabled")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of kubernetes cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="compensateWithOnDemand")
    def compensate_with_on_demand(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to automatically create pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created due to reasons such as cost or insufficient inventory. This parameter takes effect when you set `multi_az_policy` to `COST_OPTIMIZED`. Valid values: `true`: automatically creates pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created. `false`: does not create pay-as-you-go instances to meet the required number of ECS instances if preemptible instances cannot be created.
        """
        return pulumi.get(self, "compensate_with_on_demand")

    @_builtins.property
    @pulumi.getter(name="cpuPolicy")
    def cpu_policy(self) -> pulumi.Output[_builtins.str]:
        """
        Node CPU management policies. Default value: `none`. When the cluster version is 1.12.6 or later, the following two policies are supported:
        """
        return pulumi.get(self, "cpu_policy")

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> pulumi.Output[Optional[Sequence['outputs.NodePoolDataDisk']]]:
        """
        Configure the data disk of the node in the node pool. See `data_disks` below.
        """
        return pulumi.get(self, "data_disks")

    @_builtins.property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The deployment set of node pool. Specify the deploymentSet to ensure that the nodes in the node pool can be distributed on different physical machines.
        """
        return pulumi.get(self, "deployment_set_id")

    @_builtins.property
    @pulumi.getter(name="desiredSize")
    def desired_size(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Number of expected nodes in the node pool.
        """
        return pulumi.get(self, "desired_size")

    @_builtins.property
    @pulumi.getter(name="efloNodeGroup")
    def eflo_node_group(self) -> pulumi.Output[Optional['outputs.NodePoolEfloNodeGroup']]:
        """
        Lingjun node pool configuration. See `eflo_node_group` below.
        """
        return pulumi.get(self, "eflo_node_group")

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to force deletion.
        """
        return pulumi.get(self, "force_delete")

    @_builtins.property
    @pulumi.getter(name="formatDisk")
    def format_disk(self) -> pulumi.Output[_builtins.bool]:
        """
        After you select this check box, if data disks have been attached to the specified ECS instances and the file system of the last data disk is uninitialized, the system automatically formats the last data disk to ext4 and mounts the data disk to /var/lib/docker and /var/lib/kubelet. The original data on the disk will be cleared. Make sure that you back up data in advance. If no data disk is mounted on the ECS instance, no new data disk will be purchased. Default is `false`.
        """
        return pulumi.get(self, "format_disk")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[_builtins.str]:
        """
        The custom image ID. The system-provided image is used by default.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="imageType")
    def image_type(self) -> pulumi.Output[_builtins.str]:
        """
        The operating system image type and the `platform` parameter can be selected from the following values:
        - `AliyunLinux` : Alinux2 image.
        - `AliyunLinux3` : Alinux3 image.
        - `AliyunLinux3Arm64` : Alinux3 mirror ARM version.
        - `AliyunLinuxUEFI` : Alinux2 Image UEFI version.
        - `CentOS` : CentOS image.
        - `Windows` : Windows image.
        - `WindowsCore` : WindowsCore image.
        - `ContainerOS` : container-optimized image.
        - `Ubuntu`: Ubuntu image.
        - `AliyunLinux3ContainerOptimized`: Alinux3 container-optimized image.
        - `Custom`: Custom image.
        """
        return pulumi.get(self, "image_type")

    @_builtins.property
    @pulumi.getter(name="installCloudMonitor")
    def install_cloud_monitor(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to install cloud monitoring on the ECS node. After installation, you can view the monitoring information of the created ECS instance in the cloud monitoring console and recommend enable it. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "install_cloud_monitor")

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> pulumi.Output[_builtins.str]:
        """
        Node payment type. Valid values: `PostPaid`, `PrePaid`, default is `PostPaid`. If value is `PrePaid`, the arguments `period`, `period_unit`, `auto_renew` and `auto_renew_period` are required.
        """
        return pulumi.get(self, "instance_charge_type")

    @_builtins.property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        In the node instance specification list, you can select multiple instance specifications as alternatives. When each node is created, it will try to purchase from the first specification until it is created successfully. The final purchased instance specifications may vary with inventory changes.
        """
        return pulumi.get(self, "instance_types")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The instance list. Add existing nodes under the same cluster VPC to the node pool.
        """
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The billing method for network usage. Valid values `PayByBandwidth` and `PayByTraffic`. Conflict with `eip_internet_charge_type`, EIP and public network IP can only choose one.
        """
        return pulumi.get(self, "internet_charge_type")

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum bandwidth of the public IP address of the node. The unit is Mbps(Mega bit per second). The value range is:\\[1,100\\]
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @_builtins.property
    @pulumi.getter(name="keepInstanceName")
    def keep_instance_name(self) -> pulumi.Output[_builtins.bool]:
        """
        Add an existing instance to the node pool, whether to keep the original instance name. It is recommended to set to `true`.
        """
        return pulumi.get(self, "keep_instance_name")

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the key pair. When the node pool is a managed node pool, only `key_name` is supported.
        """
        return pulumi.get(self, "key_name")

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An KMS encrypts password used to a cs kubernetes. You have to specify one of `password` `key_name` `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a cs kubernetes with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @_builtins.property
    @pulumi.getter(name="kubeletConfiguration")
    def kubelet_configuration(self) -> pulumi.Output[Optional['outputs.NodePoolKubeletConfiguration']]:
        """
        Kubelet configuration parameters for worker nodes. See `kubelet_configuration` below. More information in [Kubelet Configuration](https://kubernetes.io/docs/reference/config-api/kubelet-config.v1beta1/). See `kubelet_configuration` below.
        """
        return pulumi.get(self, "kubelet_configuration")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Sequence['outputs.NodePoolLabel']]]:
        """
        A List of Kubernetes labels to assign to the nodes . Only labels that are applied with the ACK API are managed by this argument. Detailed below. More information in [Labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/). See `labels` below.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="loginAsNonRoot")
    def login_as_non_root(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the ECS instance is logged on as a ecs-user user. Valid value: `true` and `false`.
        """
        return pulumi.get(self, "login_as_non_root")

    @_builtins.property
    @pulumi.getter
    def management(self) -> pulumi.Output['outputs.NodePoolManagement']:
        """
        Managed node pool configuration. See `management` below.
        """
        return pulumi.get(self, "management")

    @_builtins.property
    @pulumi.getter(name="multiAzPolicy")
    def multi_az_policy(self) -> pulumi.Output[_builtins.str]:
        """
        The scaling policy for ECS instances in a multi-zone scaling group. Valid value: `PRIORITY`, `COST_OPTIMIZED` and `BALANCE`. `PRIORITY`: scales the capacity according to the virtual switches you define (VSwitchIds.N). When an ECS instance cannot be created in the zone where the higher-priority vSwitch is located, the next-priority vSwitch is automatically used to create an ECS instance. `COST_OPTIMIZED`: try to create by vCPU unit price from low to high. When the scaling configuration is configured with multiple instances of preemptible billing, preemptible instances are created first. You can continue to use the `CompensateWithOnDemand` parameter to specify whether to automatically try to create a preemptible instance by paying for it. It takes effect only when the scaling configuration has multi-instance specifications or preemptible instances. `BALANCE`: distributes ECS instances evenly among the multi-zone specified by the scaling group. If the zones become unbalanced due to insufficient inventory, you can use the API RebalanceInstances to balance resources.
        """
        return pulumi.get(self, "multi_az_policy")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.219.0. New field 'node_pool_name' instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        . Field 'name' has been deprecated from provider version 1.219.0. New field 'node_pool_name' instead.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    @_utilities.deprecated("""Field 'node_count' has been deprecated from provider version 1.158.0. New field 'desired_size' instead.""")
    def node_count(self) -> pulumi.Output[_builtins.int]:
        """
        The worker node number of the node pool. From version 1.111.0, `node_count` is not required.
        """
        return pulumi.get(self, "node_count")

    @_builtins.property
    @pulumi.getter(name="nodeNameMode")
    def node_name_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Each node name consists of a prefix, its private network IP, and a suffix, separated by commas. The input format is `customized,,ip,`.
        - The prefix and suffix can be composed of one or more parts separated by '.', each part can use lowercase letters, numbers and '-', and the beginning and end of the node name must be lowercase letters and numbers.
        - The node IP address is the complete private IP address of the node.
        - For example, if the string `customized,aliyun,ip,com` is passed in (where 'customized' and 'ip' are fixed strings, 'aliyun' is the prefix, and 'com' is the suffix), the name of the node is `aliyun192.168.xxx.xxxcom`.
        """
        return pulumi.get(self, "node_name_mode")

    @_builtins.property
    @pulumi.getter(name="nodePoolId")
    def node_pool_id(self) -> pulumi.Output[_builtins.str]:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "node_pool_id")

    @_builtins.property
    @pulumi.getter(name="nodePoolName")
    def node_pool_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of node pool.
        """
        return pulumi.get(self, "node_pool_name")

    @_builtins.property
    @pulumi.getter(name="onDemandBaseCapacity")
    def on_demand_base_capacity(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The minimum number of pay-as-you-go instances that must be kept in the scaling group. Valid values: 0 to 1000. If the number of pay-as-you-go instances is less than the value of this parameter, Auto Scaling preferably creates pay-as-you-go instances.
        """
        return pulumi.get(self, "on_demand_base_capacity")

    @_builtins.property
    @pulumi.getter(name="onDemandPercentageAboveBaseCapacity")
    def on_demand_percentage_above_base_capacity(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The percentage of pay-as-you-go instances among the extra instances that exceed the number specified by `on_demand_base_capacity`. Valid values: 0 to 100.
        """
        return pulumi.get(self, "on_demand_percentage_above_base_capacity")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password of ssh login. You have to specify one of `password` and `key_name` fields. The password rule is 8 to 30 characters and contains at least three items (upper and lower case letters, numbers, and special symbols).
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Node payment period. Its valid value is one of {1, 2, 3, 6, 12}.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Node payment period unit, valid value: `Month`. Default is `Month`.
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'platform' has been deprecated from provider version 1.145.0. Operating system release, using `image_type` instead.""")
    def platform(self) -> pulumi.Output[_builtins.str]:
        """
        Operating system release, using `image_type` instead.
        """
        return pulumi.get(self, "platform")

    @_builtins.property
    @pulumi.getter(name="preUserData")
    def pre_user_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Node pre custom data, base64-encoded, the script executed before the node is initialized.
        """
        return pulumi.get(self, "pre_user_data")

    @_builtins.property
    @pulumi.getter(name="privatePoolOptions")
    def private_pool_options(self) -> pulumi.Output[Optional['outputs.NodePoolPrivatePoolOptions']]:
        """
        Private node pool configuration. See `private_pool_options` below.
        """
        return pulumi.get(self, "private_pool_options")

    @_builtins.property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Worker RAM role.
        * If it is empty, the default Worker RAM role created in the cluster will be used.
        * If the specified RAM role is not empty, the specified RAM role must be a **Common Service role**, and its **trusted service** configuration must be **cloud server**. For more information, see [Create a common service role](https://help.aliyun.com/document_detail/116800.html). If the specified RAM role is not the default Worker RAM role created in the cluster, the role name cannot start with 'KubernetesMasterRole-'or 'KubernetesWorkerRole.

        > **NOTE:**  This parameter is only supported for ACK-managed clusters of 1.22 or later versions.
        """
        return pulumi.get(self, "ram_role_name")

    @_builtins.property
    @pulumi.getter(name="rdsInstances")
    def rds_instances(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of RDS instances.
        """
        return pulumi.get(self, "rds_instances")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="rollingPolicy")
    def rolling_policy(self) -> pulumi.Output[Optional['outputs.NodePoolRollingPolicy']]:
        """
        Rotary configuration. See `rolling_policy` below.
        """
        return pulumi.get(self, "rolling_policy")

    @_builtins.property
    @pulumi.getter(name="runtimeName")
    def runtime_name(self) -> pulumi.Output[_builtins.str]:
        """
        The runtime name of containers. If not set, the cluster runtime will be used as the node pool runtime. If you select another container runtime, see [Comparison of Docker, containerd, and Sandboxed-Container](https://www.alibabacloud.com/help/doc-detail/160313.htm).
        """
        return pulumi.get(self, "runtime_name")

    @_builtins.property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> pulumi.Output[_builtins.str]:
        """
        The runtime version of containers. If not set, the cluster runtime will be used as the node pool runtime.
        """
        return pulumi.get(self, "runtime_version")

    @_builtins.property
    @pulumi.getter(name="scalingConfig")
    def scaling_config(self) -> pulumi.Output['outputs.NodePoolScalingConfig']:
        """
        Automatic scaling configuration. See `scaling_config` below.
        """
        return pulumi.get(self, "scaling_config")

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the scaling group.
        """
        return pulumi.get(self, "scaling_group_id")

    @_builtins.property
    @pulumi.getter(name="scalingPolicy")
    def scaling_policy(self) -> pulumi.Output[_builtins.str]:
        """
        Scaling group mode, default value: `release`. Valid values:
        """
        return pulumi.get(self, "scaling_policy")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    @_utilities.deprecated("""Field 'security_group_id' has been deprecated from provider version 1.145.0. The security group ID of the node pool. This field has been replaced by `security_group_ids`, please use the `security_group_ids` field instead.""")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The security group ID of the node pool. This field has been replaced by `security_group_ids`, please use the `security_group_ids` field instead.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Multiple security groups can be configured for a node pool. If both `security_group_ids` and `security_group_id` are configured, `security_group_ids` takes effect. This field cannot be modified.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="securityHardeningOs")
    def security_hardening_os(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Alibaba Cloud OS security reinforcement. Default value: `false`. Value:
        """
        return pulumi.get(self, "security_hardening_os")

    @_builtins.property
    @pulumi.getter(name="socEnabled")
    def soc_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether enable worker node to support soc security reinforcement, its valid value `true` or `false`. Default to `false` and apply to AliyunLinux series. See [SOC Reinforcement](https://help.aliyun.com/document_detail/196148.html).

        > **NOTE:**  It is forbidden to set both `security_hardening_os` and `soc_enabled` to `true` at the same time.
        """
        return pulumi.get(self, "soc_enabled")

    @_builtins.property
    @pulumi.getter(name="spotInstancePools")
    def spot_instance_pools(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of instance types that are available. Auto Scaling creates preemptible instances of multiple instance types that are available at the lowest cost. Valid values: 1 to 10.
        """
        return pulumi.get(self, "spot_instance_pools")

    @_builtins.property
    @pulumi.getter(name="spotInstanceRemedy")
    def spot_instance_remedy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to supplement preemptible instances when the number of preemptible instances drops below the specified minimum number. If you set the value to true, Auto Scaling attempts to create a new preemptible instance when the system notifies that an existing preemptible instance is about to be reclaimed. Valid values: `true`: enables the supplementation of preemptible instances. `false`: disables the supplementation of preemptible instances.
        """
        return pulumi.get(self, "spot_instance_remedy")

    @_builtins.property
    @pulumi.getter(name="spotPriceLimits")
    def spot_price_limits(self) -> pulumi.Output[Optional[Sequence['outputs.NodePoolSpotPriceLimit']]]:
        """
        The current single preemptible instance type market price range configuration. See `spot_price_limit` below.
        """
        return pulumi.get(self, "spot_price_limits")

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> pulumi.Output[_builtins.str]:
        """
        The preemptible instance type. Value:
        - `NoSpot` : Non-preemptible instance.
        - `SpotWithPriceLimit` : Set the upper limit of the preemptible instance price.
        - `SpotAsPriceGo` : The system automatically bids, following the actual price of the current market.
        """
        return pulumi.get(self, "spot_strategy")

    @_builtins.property
    @pulumi.getter(name="systemDiskBurstingEnabled")
    def system_disk_bursting_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable the burst feature for system disks. Valid values:`true`: enables the burst feature. `false`: disables the burst feature. This parameter is supported only when `system_disk_category` is set to `cloud_auto`.
        """
        return pulumi.get(self, "system_disk_bursting_enabled")

    @_builtins.property
    @pulumi.getter(name="systemDiskCategories")
    def system_disk_categories(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The multi-disk categories of the system disk. When a high-priority disk type cannot be used, Auto Scaling automatically tries to create a system disk with the next priority disk category. Valid values see `system_disk_category`.
        """
        return pulumi.get(self, "system_disk_categories")

    @_builtins.property
    @pulumi.getter(name="systemDiskCategory")
    def system_disk_category(self) -> pulumi.Output[_builtins.str]:
        """
        The category of the system disk for nodes. Default value: `cloud_efficiency`. Valid values:
        """
        return pulumi.get(self, "system_disk_category")

    @_builtins.property
    @pulumi.getter(name="systemDiskEncryptAlgorithm")
    def system_disk_encrypt_algorithm(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The encryption algorithm used by the system disk. Value range: aes-256.
        """
        return pulumi.get(self, "system_disk_encrypt_algorithm")

    @_builtins.property
    @pulumi.getter(name="systemDiskEncrypted")
    def system_disk_encrypted(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to encrypt the system disk. Value range: `true`: encryption. `false`: Do not encrypt.
        """
        return pulumi.get(self, "system_disk_encrypted")

    @_builtins.property
    @pulumi.getter(name="systemDiskKmsKey")
    def system_disk_kms_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the KMS key used by the system disk.
        """
        return pulumi.get(self, "system_disk_kms_key")

    @_builtins.property
    @pulumi.getter(name="systemDiskPerformanceLevel")
    def system_disk_performance_level(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The system disk performance of the node takes effect only for the ESSD disk.
        - `PL0`: maximum random read/write IOPS 10000 for a single disk.
        - `PL1`: maximum random read/write IOPS 50000 for a single disk.
        - `PL2`: highest random read/write IOPS 100000 for a single disk.
        - `PL3`: maximum random read/write IOPS 1 million for a single disk.
        """
        return pulumi.get(self, "system_disk_performance_level")

    @_builtins.property
    @pulumi.getter(name="systemDiskProvisionedIops")
    def system_disk_provisioned_iops(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The predefined IOPS of a system disk. Valid values: 0 to min{50,000, 1,000 × Capacity - Baseline IOPS}. Baseline IOPS = min{1,800 + 50 × Capacity, 50,000}. This parameter is supported only when `system_disk_category` is set to `cloud_auto`.
        """
        return pulumi.get(self, "system_disk_provisioned_iops")

    @_builtins.property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The size of the system disk. Unit: GiB. The value of this parameter must be at least 1 and greater than or equal to the image size. Default value: 40 or the size of the image, whichever is larger.
        - Basic disk: 20 to 500.
        - ESSD (cloud_essd): The valid values vary based on the performance level of the ESSD. PL0 ESSD: 1 to 2048. PL1 ESSD: 20 to 2048. PL2 ESSD: 461 to 2048. PL3 ESSD: 1261 to 2048.
        - ESSD AutoPL disk (cloud_auto): 1 to 2048.
        - Other disk categories: 20 to 2048.
        """
        return pulumi.get(self, "system_disk_size")

    @_builtins.property
    @pulumi.getter(name="systemDiskSnapshotPolicyId")
    def system_disk_snapshot_policy_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the automatic snapshot policy used by the system disk.
        """
        return pulumi.get(self, "system_disk_snapshot_policy_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Add tags only for ECS instances. The maximum length of the tag key is 128 characters. The tag key and value cannot start with aliyun or acs:, or contain https:// or http://.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def taints(self) -> pulumi.Output[Optional[Sequence['outputs.NodePoolTaint']]]:
        """
        A List of Kubernetes taints to assign to the nodes. Detailed below. More information in [Taints and Toleration](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/). See `taints` below.
        """
        return pulumi.get(self, "taints")

    @_builtins.property
    @pulumi.getter(name="teeConfig")
    def tee_config(self) -> pulumi.Output['outputs.NodePoolTeeConfig']:
        """
        The configuration about confidential computing for the cluster. See `tee_config` below.
        """
        return pulumi.get(self, "tee_config")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Node pool type, value range:
        -'ess': common node pool (including hosting function and auto scaling function).
        -'lingjun': Lingjun node pool.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def unschedulable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the node after expansion can be scheduled.
        """
        return pulumi.get(self, "unschedulable")

    @_builtins.property
    @pulumi.getter(name="updateNodes")
    def update_nodes(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Synchronously update node labels and taints.
        """
        return pulumi.get(self, "update_nodes")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Node custom data, base64-encoded.
        """
        return pulumi.get(self, "user_data")

    @_builtins.property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The vswitches used by node pool workers.
        """
        return pulumi.get(self, "vswitch_ids")

